/** 
 * JavaClientFrame.java
 *
 * Title:			JavaClient
 * Description:	
 * @author			RoboDog
 * @version			
 */

package JavaClient;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// TCP/IP Connection
import java.io.*;
import java.net.*;
import java.util.*;

public class JavaClientFrame extends javax.swing.JFrame {

	private boolean isConnected = false;
	Socket clientSocket = null;
	String serverAddr = "0.0.0.0";
	int serverPort = 2001;
	
	public boolean connected() {
		return isConnected;
	}
	
// IMPORTANT: Source code between BEGIN/END comment pair will be regenerated
// every time the form is saved. All manual changes will be overwritten.
// BEGIN GENERATED CODE
	// member declarations
	javax.swing.JScrollPane jScrollPaneClientStatus = new javax.swing.JScrollPane();
	javax.swing.JTextArea jTextAreaClientStatus = new javax.swing.JTextArea();
	javax.swing.JButton jButtonClearClientStatus = new javax.swing.JButton();
	javax.swing.JLabel jLabelServerAddress = new javax.swing.JLabel();
	javax.swing.JLabel jLabelServerPort = new javax.swing.JLabel();
	javax.swing.JTextField jTextFieldServerAddress = new javax.swing.JTextField();
	javax.swing.JTextField jTextFieldServerPort = new javax.swing.JTextField();
	javax.swing.JButton jButtonConnect = new javax.swing.JButton();
	javax.swing.JTextField jTextFieldMessage = new javax.swing.JTextField();
	javax.swing.JLabel jLabelTitle = new javax.swing.JLabel();
// END GENERATED CODE

	public JavaClientFrame() {
	}

	public void initComponents() throws Exception {
// IMPORTANT: Source code between BEGIN/END comment pair will be regenerated
// every time the form is saved. All manual changes will be overwritten.
// BEGIN GENERATED CODE
		// the following code sets the frame's initial state

		jScrollPaneClientStatus.setLocation(new java.awt.Point(5, 130));
		jScrollPaneClientStatus.setAutoscrolls(true);
		jScrollPaneClientStatus.setVisible(true);
		jScrollPaneClientStatus.setSize(new java.awt.Dimension(480, 240));
		jScrollPaneClientStatus.getViewport().add(jTextAreaClientStatus);

		jTextAreaClientStatus.setText("Java Client Status");
		jTextAreaClientStatus.setVisible(true);

		jButtonClearClientStatus.setText("Clear");
		jButtonClearClientStatus.setLocation(new java.awt.Point(215, 380));
		jButtonClearClientStatus.setVisible(true);
		jButtonClearClientStatus.setOpaque(false);
		jButtonClearClientStatus.setSize(new java.awt.Dimension(80, 30));

		jLabelServerAddress.setText("Server Address:");
		jLabelServerAddress.setLocation(new java.awt.Point(35, 50));
		jLabelServerAddress.setVisible(true);
		jLabelServerAddress.setSize(new java.awt.Dimension(100, 30));

		jLabelServerPort.setText("Server Port:");
		jLabelServerPort.setLocation(new java.awt.Point(265, 50));
		jLabelServerPort.setVisible(true);
		jLabelServerPort.setSize(new java.awt.Dimension(80, 30));

		jTextFieldServerAddress.setText("127.0.0.1");
		jTextFieldServerAddress.setLocation(new java.awt.Point(145, 50));
		jTextFieldServerAddress.setVisible(true);
		jTextFieldServerAddress.setSize(new java.awt.Dimension(90, 30));

		jTextFieldServerPort.setText("2001");
		jTextFieldServerPort.setLocation(new java.awt.Point(355, 50));
		jTextFieldServerPort.setVisible(true);
		jTextFieldServerPort.setSize(new java.awt.Dimension(90, 30));

		jButtonConnect.setText("Connect");
		jButtonConnect.setLocation(new java.awt.Point(405, 90));
		jButtonConnect.setVisible(true);
		jButtonConnect.setOpaque(false);
		jButtonConnect.setSize(new java.awt.Dimension(80, 30));

		jTextFieldMessage.setText("Message");
		jTextFieldMessage.setLocation(new java.awt.Point(5, 90));
		jTextFieldMessage.setVisible(true);
		jTextFieldMessage.setSize(new java.awt.Dimension(390, 30));

		jLabelTitle.setText("Java Client");
		jLabelTitle.setForeground(new java.awt.Color(0, 102, 153));
		jLabelTitle.setLocation(new java.awt.Point(130, 10));
		jLabelTitle.setVisible(true);
		jLabelTitle.setFont(new java.awt.Font("Application", 1, 24));
		jLabelTitle.setHorizontalAlignment(javax.swing.JLabel.CENTER);
		jLabelTitle.setSize(new java.awt.Dimension(260, 30));

		setLocation(new java.awt.Point(5, 40));
		setTitle("JavaClient.JavaClientFrame");
		getContentPane().setLayout(null);
		setSize(new java.awt.Dimension(490, 416));
		getContentPane().add(jScrollPaneClientStatus);
		getContentPane().add(jButtonClearClientStatus);
		getContentPane().add(jLabelServerAddress);
		getContentPane().add(jLabelServerPort);
		getContentPane().add(jTextFieldServerAddress);
		getContentPane().add(jTextFieldServerPort);
		getContentPane().add(jButtonConnect);
		getContentPane().add(jTextFieldMessage);
		getContentPane().add(jLabelTitle);


		jButtonClearClientStatus.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButtonClearClientStatusActionPerformed(e);
			}
		});
		jButtonConnect.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButtonConnectActionPerformed(e);
			}
		});
		jTextFieldMessage.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jTextFieldMessageActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});

// END GENERATED CODE
	}
  
  	private boolean mShown = false;
  	
	public void addNotify() {
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e) {
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	ClientSessionThread sessionThread = null;
	String requestMessage = null;
	
	public void jButtonConnectActionPerformed(java.awt.event.ActionEvent e) {
		//Thread th = new Thread() {
		//	public void run() {
				if (isConnected) {
					// stop session
					if (sessionThread.isAlive()) {
						sessionThread.stop();
					}
					sessionThread = null;
					
					// bail out
					disconnect();
				} else {
					// connect
					connect();
					
					// create session thread
					sessionThread = new ClientSessionThread("");
					
					//sendRequest(null);					
					// for contiguous session, we need not to disconnect established connection
					//disconnect();////
				}
		//	}
		//};
		//th.start();
	}
	
	public void jButtonClearClientStatusActionPerformed(java.awt.event.ActionEvent e) {
		jTextAreaClientStatus.setText("");
	}
	
	public void jTextFieldMessageActionPerformed(java.awt.event.ActionEvent e) {
		//jButtonConnectActionPerformed(e);
		if (isConnected == false) {
			printlnClientStatus("Not Connected.");
			return;
			//connect();
		} else {
			sendRequest(jTextFieldMessage.getText());
		}
	}
	
	public void printlnClientStatus(String str) {
		Date date = new java.util.Date();
		if (date != null)
		{
			jTextAreaClientStatus.append(date.toString() + ": " + str + "\n");
		} else {
			jTextAreaClientStatus.append(str + "\n");
		}
	}

	public void connect()
	{
		if (sessionThread != null) return;
		
		// create client socket 
		String portTxt = null;
		Integer intObj = null;
				
		// try to create client socket
		// if the server is waiting to accept a client,
		// the session will be established
		serverAddr = jTextFieldServerAddress.getText();
		portTxt = jTextFieldServerPort.getText();
		intObj = new Integer(portTxt);
		serverPort = intObj.intValue();
		try {
			// create socket to the server
			clientSocket = new Socket(serverAddr, serverPort);
			printlnClientStatus("Client socket created: port = " + String.valueOf(clientSocket.getLocalPort()));
		} catch (IOException e) {
			printlnClientStatus("Couldn't create client socket.");
			return;
		}
		
		printlnClientStatus("Opened connection.");
		jButtonConnect.setText("Close");//
		isConnected = true;
	}
	
	String result = "";
	boolean hasRequest = false;
	boolean gotResult = false;
	
	class ClientSessionThread extends Thread {
		public ClientSessionThread(String s) {
			requestMessage = s;
			start();
		}
		
		public void run() {
			OutputStream outStream = null;
			InputStream inStream = null;
			BufferedReader clientInputReader = null;
			// get stream
			try {
				// output stream for request
				outStream = clientSocket.getOutputStream();
				// input stream and buffer reader for reply
				inStream = clientSocket.getInputStream();
				clientInputReader = new BufferedReader(
					new InputStreamReader(inStream)
				);
			} catch (IOException e1) {
				printlnClientStatus("Failed to get stream.");
				if (clientSocket != null) {
					try {
						clientSocket.close();
					} catch (IOException e2) {
					
					}
					clientSocket = null;
				}
				
				stop();
				return;
			}
			
			while (true) {
				// push if there's something to send
				if (hasRequest == false) continue;
				
				try {		
					String msg = requestMessage;
					hasRequest = false;
					// TERMINATE the string with return code!!!
					msg = new String(msg + "\r\n");// LF CR
					if (msg != null)
					{
						// send message
						outStream.write(msg.getBytes());
						outStream.flush();
						printlnClientStatus("<SND>" + msg);
					} else {
						//stop();
						continue;
					}
				} catch (IOException e2) {
					//stop();
					continue;
				}
				
				try {
					gotResult = false;
					
					// waiting for reply
					String reply = null;
					while (clientInputReader.ready() == false) {
						// wait...
						try {
							Thread.sleep(100);
						} catch (InterruptedException e3) {
							continue;
						}
					}
					
					// read result
					while (clientInputReader.ready() == true) {
						reply = clientInputReader.readLine();
						if (reply != null)
						{
							printlnClientStatus("<RCV> "+ reply);
							
							// append reply to result
							result = result + reply;
							continue;
						}
						
						try {
							Thread.sleep(10);
						} catch (InterruptedException e4) {
							continue;;
						}
					}
					
					gotResult = true;
					
					continue;
				} catch (IOException e5) {
					continue;
				}
			}
		}
	}
	
	public String sendRequest(String request) {
		// create message string
		requestMessage = request;//jTextFieldMessage.getText();
		hasRequest = true;
		// wait until the server returns the reply and this client gets all of them
		
		// make copy of result
		String answer = result;
		// empty result
		result = "";
		// return the answer
		return answer;
	}
	
	public void disconnect()
	{
		// close connection
		if (sessionThread != null) {
			if (sessionThread.isAlive())
			{
				sessionThread.stop();
				printlnClientStatus("Stopped session thread.");
			}
			sessionThread = null;
		}
		
		printlnClientStatus("Closed connection.");
		jButtonConnect.setText("Connect");//
		isConnected = false;
	}
}
