/*
 * Decompiled with CFR 0.152.
 */
package JavaClient;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JavaClientFrame
extends JFrame {
    private boolean isConnected = false;
    Socket clientSocket = null;
    String serverAddr = "0.0.0.0";
    int serverPort = 2001;
    JScrollPane jScrollPaneClientStatus = new JScrollPane();
    JTextArea jTextAreaClientStatus = new JTextArea();
    JButton jButtonClearClientStatus = new JButton();
    JLabel jLabelServerAddress = new JLabel();
    JLabel jLabelServerPort = new JLabel();
    JTextField jTextFieldServerAddress = new JTextField();
    JTextField jTextFieldServerPort = new JTextField();
    JButton jButtonConnect = new JButton();
    JTextField jTextFieldMessage = new JTextField();
    JLabel jLabelTitle = new JLabel();
    private boolean mShown = false;
    ClientSessionThread sessionThread = null;
    ClientIncomingThread clientIncomingThread = null;
    ClientOutgoingThread clientOutgoingThread = null;
    String requestMessage = null;
    String result = "";
    boolean hasRequest = false;
    OutputStream outStream = null;
    InputStream inStream = null;
    BufferedInputStream in = null;
    byte[] buff = new byte[1024];

    public boolean connected() {
        return this.isConnected;
    }

    public void initComponents() throws Exception {
        this.jScrollPaneClientStatus.setSize(new Dimension(480, 240));
        this.jScrollPaneClientStatus.setLocation(new Point(5, 130));
        this.jScrollPaneClientStatus.setVisible(true);
        this.jScrollPaneClientStatus.setAutoscrolls(true);
        this.jScrollPaneClientStatus.getViewport().add(this.jTextAreaClientStatus);
        this.jTextAreaClientStatus.setVisible(true);
        this.jTextAreaClientStatus.setText("Java Client Status");
        this.jButtonClearClientStatus.setOpaque(false);
        this.jButtonClearClientStatus.setSize(new Dimension(80, 30));
        this.jButtonClearClientStatus.setLocation(new Point(215, 380));
        this.jButtonClearClientStatus.setVisible(true);
        this.jButtonClearClientStatus.setText("Clear");
        this.jLabelServerAddress.setSize(new Dimension(100, 30));
        this.jLabelServerAddress.setLocation(new Point(35, 50));
        this.jLabelServerAddress.setVisible(true);
        this.jLabelServerAddress.setText("Server Address:");
        this.jLabelServerPort.setSize(new Dimension(80, 30));
        this.jLabelServerPort.setLocation(new Point(265, 50));
        this.jLabelServerPort.setVisible(true);
        this.jLabelServerPort.setText("Server Port:");
        this.jTextFieldServerAddress.setSize(new Dimension(90, 30));
        this.jTextFieldServerAddress.setLocation(new Point(145, 50));
        this.jTextFieldServerAddress.setVisible(true);
        this.jTextFieldServerAddress.setText("127.0.0.1");
        this.jTextFieldServerPort.setSize(new Dimension(90, 30));
        this.jTextFieldServerPort.setLocation(new Point(355, 50));
        this.jTextFieldServerPort.setVisible(true);
        this.jTextFieldServerPort.setText("2001");
        this.jButtonConnect.setOpaque(false);
        this.jButtonConnect.setSize(new Dimension(80, 30));
        this.jButtonConnect.setLocation(new Point(405, 90));
        this.jButtonConnect.setVisible(true);
        this.jButtonConnect.setText("Connect");
        this.jTextFieldMessage.setSize(new Dimension(390, 30));
        this.jTextFieldMessage.setLocation(new Point(5, 90));
        this.jTextFieldMessage.setVisible(true);
        this.jTextFieldMessage.setText("Message");
        this.jLabelTitle.setSize(new Dimension(260, 30));
        this.jLabelTitle.setLocation(new Point(130, 10));
        this.jLabelTitle.setVisible(true);
        this.jLabelTitle.setText("Java Client");
        this.jLabelTitle.setForeground(new Color(0, 102, 153));
        this.jLabelTitle.setHorizontalAlignment(0);
        this.jLabelTitle.setFont(new Font("Application", 1, 24));
        ((Component)this).setLocation(new Point(5, 40));
        ((Component)this).setSize(new Dimension(520, 448));
        this.getContentPane().setLayout(null);
        this.setTitle("JavaClient.JavaClientFrame");
        this.getContentPane().add(this.jScrollPaneClientStatus);
        this.getContentPane().add(this.jButtonClearClientStatus);
        this.getContentPane().add(this.jLabelServerAddress);
        this.getContentPane().add(this.jLabelServerPort);
        this.getContentPane().add(this.jTextFieldServerAddress);
        this.getContentPane().add(this.jTextFieldServerPort);
        this.getContentPane().add(this.jButtonConnect);
        this.getContentPane().add(this.jTextFieldMessage);
        this.getContentPane().add(this.jLabelTitle);
        this.jButtonClearClientStatus.addActionListener(new 1());
        this.jButtonConnect.addActionListener(new 2());
        this.jTextFieldMessage.addActionListener(new 3());
        this.addWindowListener(new 4());
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int n = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += n;
            ((Component)this).setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent windowEvent) {
        ((Component)this).setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public void jButtonConnectActionPerformed(ActionEvent actionEvent) {
        if (this.isConnected) {
            if (this.sessionThread.isAlive()) {
                this.sessionThread.stop();
            }
            this.sessionThread = null;
            this.disconnect();
        } else {
            this.connect();
            this.sessionThread = new ClientSessionThread();
            this.sessionThread.start();
        }
    }

    public void negotiate() {
        if (this.serverPort == 23) {
            byte by = -1;
            int n = -2;
            byte by2 = -3;
            int n2 = -4;
            int n3 = -5;
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.clientSocket.getInputStream());
                OutputStream outputStream = this.clientSocket.getOutputStream();
                byte[] byArray = new byte[3];
                while (true) {
                    bufferedInputStream.mark(byArray.length);
                    if (bufferedInputStream.available() < byArray.length) continue;
                    bufferedInputStream.read(byArray);
                    if (byArray[0] != by) {
                        bufferedInputStream.reset();
                        return;
                    }
                    if (byArray[1] != by2) continue;
                    byArray[1] = n2;
                    outputStream.write(byArray);
                }
            }
            catch (IOException iOException) {
            }
        }
    }

    public void jButtonClearClientStatusActionPerformed(ActionEvent actionEvent) {
        this.jTextAreaClientStatus.setText("");
    }

    public void jTextFieldMessageActionPerformed(ActionEvent actionEvent) {
        if (!this.isConnected) {
            this.printlnClientStatus("Not Connected.");
            return;
        }
        this.sendRequest(this.jTextFieldMessage.getText());
    }

    public void printlnClientStatus(String string) {
        Date date = new Date();
        if (date != null) {
            this.jTextAreaClientStatus.append(String.valueOf(date.toString()) + ": " + string + "\n");
        } else {
            this.jTextAreaClientStatus.append(String.valueOf(string) + "\n");
        }
        this.repaint();
    }

    public void printClientStatus(String string) {
        this.jTextAreaClientStatus.append(string);
        this.repaint();
    }

    public void connect() {
        String string = null;
        Integer n = null;
        this.serverAddr = this.jTextFieldServerAddress.getText();
        string = this.jTextFieldServerPort.getText();
        n = new Integer(string);
        this.serverPort = n;
        try {
            this.clientSocket = new Socket(this.serverAddr, this.serverPort);
            this.printlnClientStatus("Client socket created: port = " + String.valueOf(this.clientSocket.getLocalPort()));
        }
        catch (IOException iOException) {
            this.printlnClientStatus("Couldn't create client socket.");
            return;
        }
        this.printlnClientStatus("Opened connection.");
        this.jButtonConnect.setText("Close");
        this.isConnected = true;
    }

    public String sendRequest(String string) {
        this.requestMessage = string;
        this.hasRequest = true;
        return null;
    }

    public void disconnect() {
        if (this.sessionThread != null) {
            if (this.sessionThread.isAlive()) {
                this.sessionThread.stop();
                this.printlnClientStatus("Stopped session thread.");
            }
            this.sessionThread = null;
        }
        this.printlnClientStatus("Closed connection.");
        this.jButtonConnect.setText("Connect");
        this.isConnected = false;
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JavaClientFrame.this.jButtonClearClientStatusActionPerformed(actionEvent);
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JavaClientFrame.this.jButtonConnectActionPerformed(actionEvent);
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JavaClientFrame.this.jTextFieldMessageActionPerformed(actionEvent);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            JavaClientFrame.this.thisWindowClosing(windowEvent);
        }

        /* synthetic */ 4() {
        }
    }

    public class ClientIncomingThread
    extends Thread {
        public void run() {
            int n = 0;
            while (true) {
                try {
                    Object var2_2 = null;
                    n = JavaClientFrame.this.in.read(JavaClientFrame.this.buff);
                    if (n > 0) {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n);
                        byteArrayOutputStream.write(JavaClientFrame.this.buff, 0, n);
                        JavaClientFrame.this.printlnClientStatus("<RCV>" + byteArrayOutputStream.toString());
                    }
                }
                catch (IOException iOException) {}
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public class ClientOutgoingThread
    extends Thread {
        public void run() {
            while (true) {
                if (!JavaClientFrame.this.hasRequest) {
                    continue;
                }
                try {
                    String string = JavaClientFrame.this.requestMessage;
                    JavaClientFrame.this.requestMessage = "";
                    JavaClientFrame.this.hasRequest = false;
                    string = new String(String.valueOf(string) + "\r\n");
                    if (string != null) {
                        JavaClientFrame.this.outStream.write(string.getBytes());
                        JavaClientFrame.this.outStream.flush();
                        JavaClientFrame.this.printlnClientStatus("<SND>" + string);
                    }
                }
                catch (IOException iOException) {}
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }

    public class ClientSessionThread
    extends Thread {
        public void run() {
            JavaClientFrame.this.requestMessage = "";
            try {
                JavaClientFrame.this.outStream = JavaClientFrame.this.clientSocket.getOutputStream();
                JavaClientFrame.this.inStream = JavaClientFrame.this.clientSocket.getInputStream();
                JavaClientFrame.this.in = new BufferedInputStream(JavaClientFrame.this.inStream);
            }
            catch (IOException iOException) {
                JavaClientFrame.this.printlnClientStatus("Failed to get stream.");
                if (JavaClientFrame.this.clientSocket != null) {
                    try {
                        JavaClientFrame.this.clientSocket.close();
                    }
                    catch (IOException iOException2) {}
                    JavaClientFrame.this.clientSocket = null;
                }
                return;
            }
            JavaClientFrame.this.clientIncomingThread = new ClientIncomingThread();
            JavaClientFrame.this.clientOutgoingThread = new ClientOutgoingThread();
            JavaClientFrame.this.clientIncomingThread.start();
            JavaClientFrame.this.clientOutgoingThread.start();
            while (!JavaClientFrame.this.clientIncomingThread.isAlive() || !JavaClientFrame.this.clientOutgoingThread.isAlive()) {
            }
            JavaClientFrame.this.negotiate();
        }
    }
}

