/** 
 * JavaClientFrame.java
 *
 * Title:			JavaClient
 * Description:	
 * @author			RoboDog
 * @version			
 */

package JavaClient;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

// TCP/IP Connection
import java.io.*;
import java.net.*;
import java.util.*;

public class JavaClientFrame extends javax.swing.JFrame {

	private boolean isConnected = false;
	Socket clientSocket = null;
	String serverAddr = "0.0.0.0";
	int serverPort = 2001;
	
	public boolean connected() {
		return isConnected;
	}
	
// IMPORTANT: Source code between BEGIN/END comment pair will be regenerated
// every time the form is saved. All manual changes will be overwritten.
// BEGIN GENERATED CODE
	// member declarations
	javax.swing.JScrollPane jScrollPaneClientStatus = new javax.swing.JScrollPane();
	javax.swing.JTextArea jTextAreaClientStatus = new javax.swing.JTextArea();
	javax.swing.JButton jButtonClearClientStatus = new javax.swing.JButton();
	javax.swing.JLabel jLabelServerAddress = new javax.swing.JLabel();
	javax.swing.JLabel jLabelServerPort = new javax.swing.JLabel();
	javax.swing.JTextField jTextFieldServerAddress = new javax.swing.JTextField();
	javax.swing.JTextField jTextFieldServerPort = new javax.swing.JTextField();
	javax.swing.JButton jButtonConnect = new javax.swing.JButton();
	javax.swing.JTextField jTextFieldMessage = new javax.swing.JTextField();
	javax.swing.JLabel jLabelTitle = new javax.swing.JLabel();
// END GENERATED CODE

	public JavaClientFrame() {
	}

	public void initComponents() throws Exception {
// IMPORTANT: Source code between BEGIN/END comment pair will be regenerated
// every time the form is saved. All manual changes will be overwritten.
// BEGIN GENERATED CODE
		// the following code sets the frame's initial state

		jScrollPaneClientStatus.setSize(new java.awt.Dimension(480, 240));
		jScrollPaneClientStatus.setLocation(new java.awt.Point(5, 130));
		jScrollPaneClientStatus.setVisible(true);
		jScrollPaneClientStatus.setAutoscrolls(true);
		jScrollPaneClientStatus.getViewport().add(jTextAreaClientStatus);

		jTextAreaClientStatus.setVisible(true);
		jTextAreaClientStatus.setText("Java Client Status");

		jButtonClearClientStatus.setOpaque(false);
		jButtonClearClientStatus.setSize(new java.awt.Dimension(80, 30));
		jButtonClearClientStatus.setLocation(new java.awt.Point(215, 380));
		jButtonClearClientStatus.setVisible(true);
		jButtonClearClientStatus.setText("Clear");

		jLabelServerAddress.setSize(new java.awt.Dimension(100, 30));
		jLabelServerAddress.setLocation(new java.awt.Point(35, 50));
		jLabelServerAddress.setVisible(true);
		jLabelServerAddress.setText("Server Address:");

		jLabelServerPort.setSize(new java.awt.Dimension(80, 30));
		jLabelServerPort.setLocation(new java.awt.Point(265, 50));
		jLabelServerPort.setVisible(true);
		jLabelServerPort.setText("Server Port:");

		jTextFieldServerAddress.setSize(new java.awt.Dimension(90, 30));
		jTextFieldServerAddress.setLocation(new java.awt.Point(145, 50));
		jTextFieldServerAddress.setVisible(true);
		jTextFieldServerAddress.setText("127.0.0.1");

		jTextFieldServerPort.setSize(new java.awt.Dimension(90, 30));
		jTextFieldServerPort.setLocation(new java.awt.Point(355, 50));
		jTextFieldServerPort.setVisible(true);
		jTextFieldServerPort.setText("2001");

		jButtonConnect.setOpaque(false);
		jButtonConnect.setSize(new java.awt.Dimension(80, 30));
		jButtonConnect.setLocation(new java.awt.Point(405, 90));
		jButtonConnect.setVisible(true);
		jButtonConnect.setText("Connect");

		jTextFieldMessage.setSize(new java.awt.Dimension(390, 30));
		jTextFieldMessage.setLocation(new java.awt.Point(5, 90));
		jTextFieldMessage.setVisible(true);
		jTextFieldMessage.setText("Message");

		jLabelTitle.setSize(new java.awt.Dimension(260, 30));
		jLabelTitle.setLocation(new java.awt.Point(130, 10));
		jLabelTitle.setVisible(true);
		jLabelTitle.setText("Java Client");
		jLabelTitle.setForeground(new java.awt.Color(0, 102, 153));
		jLabelTitle.setHorizontalAlignment(javax.swing.JLabel.CENTER);
		jLabelTitle.setFont(new java.awt.Font("Application", 1, 24));

		setLocation(new java.awt.Point(5, 40));
		setSize(new java.awt.Dimension(520, 448));
		getContentPane().setLayout(null);
		setTitle("JavaClient.JavaClientFrame");
		getContentPane().add(jScrollPaneClientStatus);
		getContentPane().add(jButtonClearClientStatus);
		getContentPane().add(jLabelServerAddress);
		getContentPane().add(jLabelServerPort);
		getContentPane().add(jTextFieldServerAddress);
		getContentPane().add(jTextFieldServerPort);
		getContentPane().add(jButtonConnect);
		getContentPane().add(jTextFieldMessage);
		getContentPane().add(jLabelTitle);


		jButtonClearClientStatus.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButtonClearClientStatusActionPerformed(e);
			}
		});
		jButtonConnect.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButtonConnectActionPerformed(e);
			}
		});
		jTextFieldMessage.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jTextFieldMessageActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});

// END GENERATED CODE
	}
  
  	private boolean mShown = false;
  	
	public void addNotify() {
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e) {
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	ClientSessionThread sessionThread = null;
	ClientIncomingThread clientIncomingThread = null;
	ClientOutgoingThread clientOutgoingThread = null;

	String requestMessage = null;
	String result = "";
	boolean hasRequest = false;

	OutputStream outStream = null;
	InputStream inStream = null;
	
	// BufferedReader clientInputReader = null;
	BufferedInputStream in = null;
	byte[] buff = new byte[1024];
	
	public void jButtonConnectActionPerformed(java.awt.event.ActionEvent e) {
		if (isConnected) {
			// stop session
			if (sessionThread.isAlive()) {
				sessionThread.stop();
			}
			sessionThread = null;
			
			// bail out
			disconnect();
		} else {
			// connect
			connect();
			
			// create session thread
			sessionThread = new ClientSessionThread();
			sessionThread.start();
		}
	}
	
	public void negotiate() {
		// FOR TELNET [referred the book "Java Network Programming" by Tomihiro Odaka]
		if (serverPort == 23) {
			byte IAC = (byte)255;	//0xff
			byte DONT = (byte)254;	//0xfe
			byte DO = (byte)253;	//0xfd
			byte WONT = (byte)252;	//0xfc
			byte WILL = (byte)251;	//0xfb
			try {
				BufferedInputStream in = new BufferedInputStream(clientSocket.getInputStream());
				OutputStream out = clientSocket.getOutputStream();
				byte[] token = new byte[3];
				while (true) {
					in.mark(token.length);
					if (in.available() >= token.length) {
						in.read(token);
						printlnClientStatus("READ");
						if (token[0] != IAC) {
							in.reset();
							
							// derive "login:" prompt
							printlnClientStatus("IAC");
							int n = in.available();
							byte[] buff = new byte[n];
							in.read(buff);
							ByteArrayOutputStream ba = new ByteArrayOutputStream(n);
							ba.write(buff,0,n);
							String str = ba.toString();
							str = str.trim();
							printlnClientStatus(str);
							buff = null;
							
							return;
						} else if (token[1] == DO) {
							token[1] = WONT;
							out.write(token);
							printlnClientStatus("WONT");
							continue;
						}
					}
				}
			} catch (IOException e) {
			
			}
		}
	}
	
	public void jButtonClearClientStatusActionPerformed(java.awt.event.ActionEvent e) {
		jTextAreaClientStatus.setText("");
	}
	
	public void jTextFieldMessageActionPerformed(java.awt.event.ActionEvent e) {
		//jButtonConnectActionPerformed(e);
		if (isConnected == false) {
			printlnClientStatus("Not Connected.");
			return;
			//connect();
		} else {
			sendRequest(jTextFieldMessage.getText());
		}
	}
	
	public void printlnClientStatus(String str) {
		Date date = new java.util.Date();
		if (date != null)
		{
			jTextAreaClientStatus.append(date.toString() + ": " + str + "\n");
			//System.out.println(date.toString() + ": " + str);
		} else {
			jTextAreaClientStatus.append(str + "\n");
			//System.out.println(str);
		}
		repaint();
	}

	public void printClientStatus(String str) {
		jTextAreaClientStatus.append(str);
		repaint();
	}

	public void connect()
	{
		//if (sessionThread != null) return;// already connected
		
		// create client socket 
		String portTxt = null;
		Integer intObj = null;
				
		// try to create client socket
		// if the server is waiting to accept a client,
		// the session will be established
		serverAddr = jTextFieldServerAddress.getText();
		portTxt = jTextFieldServerPort.getText();
		intObj = new Integer(portTxt);
		serverPort = intObj.intValue();
		try {
			// create socket to the server
			clientSocket = new Socket(serverAddr, serverPort);
			printlnClientStatus("Client socket created: port = " + String.valueOf(clientSocket.getLocalPort()));
		} catch (IOException e) {
			printlnClientStatus("Couldn't create client socket.");
			return;
		}
		
		printlnClientStatus("Opened connection.");
		jButtonConnect.setText("Close");//
		isConnected = true;
	}
	
	public class ClientIncomingThread extends Thread {		
	 	public void run() {
	 		int n = 0;
	 		
			while (true) {
				try {
					// waiting for reply
					String reply = null;

					// read result
					/*
					if (clientInputReader.ready() == true) {
						reply = clientInputReader.readLine();
						if (reply != null)
						{
							printlnClientStatus("<RCV> "+ reply);
							
							// append reply to result
							result = result + reply;
						}
					}
					*/
					//
					// NOTE: 
					// If you would like to use this client for such as telnet,
					// using string reader isn't suitable because the data from the server
					// is not always a text message terminated by CRLF.
					// We should use simple byte array.
					//
					n = in.read(buff);
					if (n>0) {
						ByteArrayOutputStream ba = new ByteArrayOutputStream(n);
						ba.write(buff,0,n);
						printlnClientStatus("<RCV>" + ba.toString());
					}

				} catch (IOException e3) {

				}
				
				try {
					Thread.sleep(10);
				} catch (InterruptedException e4) {
					//continue;;
				}
			}
	 	}			
	}
	
	public class ClientOutgoingThread extends Thread {
		public void run() {
			while (true) {
				// push if there's something to send
				if (hasRequest == false) continue;
				
				try {		
					String msg = requestMessage;
					requestMessage = "";
					hasRequest = false;
					
					// TERMINATE the string with return code!!!
					msg = new String(msg + "\r\n");// LFCR
					if (msg != null)
					{
						// send message
						outStream.write(msg.getBytes());
						outStream.flush();
						printlnClientStatus("<SND>" + msg);
						//printClientStatus(msg);
					} else {
					
					}
				} catch (IOException e5) {
				
				}
				
				try {
					Thread.sleep(10);
				} catch (InterruptedException e6) {
					//continue;;
				}
			}
		}
	}
	
	public class ClientSessionThread extends Thread {
		public void run() {		
			requestMessage = "";
			
			//
			// get streams
			//
			try {
				// output stream for request
				outStream = clientSocket.getOutputStream();
				// input stream for reply
				inStream = clientSocket.getInputStream();
				// clientInputReader = new BufferedReader( new InputStreamReader(inStream) );
				in = new BufferedInputStream(inStream);
			} catch (IOException e1) {
				printlnClientStatus("Failed to get stream.");
				if (clientSocket != null) {
					try {
						clientSocket.close();
					} catch (IOException e2) {
					
					}
					clientSocket = null;
				}
				return;
			}

			clientIncomingThread = new ClientIncomingThread();
			clientOutgoingThread = new ClientOutgoingThread();
			
			clientIncomingThread.start();
			clientOutgoingThread.start();
			
			// wait until both threads are ready
			while (clientIncomingThread.isAlive() == false || clientOutgoingThread.isAlive() == false) {
			
			}
			
			negotiate();
			
			/*
			while (true) {
				try {
					Thread.sleep(1000);
				} catch (InterruptedException e4) {
					//continue;;
				}
			}
			*/
		}
	}
	
	public String sendRequest(String request) {
		// create message string
		requestMessage = request;//jTextFieldMessage.getText();
		hasRequest = true;
		// wait until the server returns the reply and this client gets all of them
		
		/*
		// make a copy of result
		String answer = result;
		// empty result
		result = "";
		// return the answer
		return answer;
		*/
		return null;
	}
	
	public void disconnect()
	{
		// close connection
		if (sessionThread != null) {
			if (sessionThread.isAlive())
			{
				sessionThread.stop();
				printlnClientStatus("Stopped session thread.");
			}
			sessionThread = null;
		}
		
		printlnClientStatus("Closed connection.");
		jButtonConnect.setText("Connect");//
		isConnected = false;
	}
}
