/** 
 * JavaServerFrame.java
 *
 * Title:			JavaServer
 * Description:	
 * @author			RoboDog
 * @version			
 */

package JavaServer;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

import java.io.*;
import java.net.*;
import java.util.*;

public class JavaServerFrame extends javax.swing.JFrame {
	// server variables
	private boolean isServing = false;
	int serverPort;
	ServerSocket serverSocket = null;
	Thread serverThread = null;

// IMPORTANT: Source code between BEGIN/END comment pair will be regenerated
// every time the form is saved. All manual changes will be overwritten.
// BEGIN GENERATED CODE
	// member declarations
	javax.swing.JLabel jLabelServerPort = new javax.swing.JLabel();
	javax.swing.JTextField jTextFieldServerPort = new javax.swing.JTextField();
	javax.swing.JScrollPane jScrollPaneServerStatus = new javax.swing.JScrollPane();
	javax.swing.JTextArea jTextAreaServerStatus = new javax.swing.JTextArea();
	javax.swing.JButton jButtonStartStopServer = new javax.swing.JButton();
	javax.swing.JButton jButtonClearServerStatus = new javax.swing.JButton();
	javax.swing.JLabel jLabelServerTitle = new javax.swing.JLabel();
// END GENERATED CODE

	public JavaServerFrame() {
	}

	public void initComponents() throws Exception {
// IMPORTANT: Source code between BEGIN/END comment pair will be regenerated
// every time the form is saved. All manual changes will be overwritten.
// BEGIN GENERATED CODE
		// the following code sets the frame's initial state

		jLabelServerPort.setText("Server Port:");
		jLabelServerPort.setLocation(new java.awt.Point(125, 50));
		jLabelServerPort.setVisible(true);
		jLabelServerPort.setSize(new java.awt.Dimension(80, 30));

		jTextFieldServerPort.setText("2001");
		jTextFieldServerPort.setLocation(new java.awt.Point(205, 50));
		jTextFieldServerPort.setVisible(true);
		jTextFieldServerPort.setSize(new java.awt.Dimension(80, 30));

		jScrollPaneServerStatus.setLocation(new java.awt.Point(5, 90));
		jScrollPaneServerStatus.setVisible(true);
		jScrollPaneServerStatus.setSize(new java.awt.Dimension(480, 280));
		jScrollPaneServerStatus.getViewport().add(jTextAreaServerStatus);

		jTextAreaServerStatus.setText("Java Server Status");
		jTextAreaServerStatus.setAutoscrolls(false);
		jTextAreaServerStatus.setVisible(true);

		jButtonStartStopServer.setText("Start");
		jButtonStartStopServer.setLocation(new java.awt.Point(295, 50));
		jButtonStartStopServer.setVisible(true);
		jButtonStartStopServer.setOpaque(false);
		jButtonStartStopServer.setSize(new java.awt.Dimension(80, 30));

		jButtonClearServerStatus.setText("Clear");
		jButtonClearServerStatus.setLocation(new java.awt.Point(215, 380));
		jButtonClearServerStatus.setVisible(true);
		jButtonClearServerStatus.setOpaque(false);
		jButtonClearServerStatus.setSize(new java.awt.Dimension(80, 30));

		jLabelServerTitle.setText("Java Server");
		jLabelServerTitle.setForeground(new java.awt.Color(200, 0, 0));
		jLabelServerTitle.setLocation(new java.awt.Point(120, 10));
		jLabelServerTitle.setVisible(true);
		jLabelServerTitle.setFont(new java.awt.Font("Application", 1, 24));
		jLabelServerTitle.setHorizontalAlignment(javax.swing.JLabel.CENTER);
		jLabelServerTitle.setSize(new java.awt.Dimension(260, 30));

		setLocation(new java.awt.Point(5, 40));
		setTitle("JavaServer.JavaServerFrame");
		getContentPane().setLayout(null);
		setSize(new java.awt.Dimension(489, 415));
		getContentPane().add(jLabelServerPort);
		getContentPane().add(jTextFieldServerPort);
		getContentPane().add(jScrollPaneServerStatus);
		getContentPane().add(jButtonStartStopServer);
		getContentPane().add(jButtonClearServerStatus);
		getContentPane().add(jLabelServerTitle);


		jButtonStartStopServer.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButtonStartStopServerActionPerformed(e);
			}
		});
		jButtonClearServerStatus.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				jButtonClearServerStatusActionPerformed(e);
			}
		});
		addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				thisWindowClosing(e);
			}
		});

// END GENERATED CODE
		printlnServerStatus("Launched server.");
	}
  
  	private boolean mShown = false;
  	
	public void addNotify() {
		super.addNotify();
		
		if (mShown)
			return;
			
		// resize frame to account for menubar
		JMenuBar jMenuBar = getJMenuBar();
		if (jMenuBar != null) {
			int jMenuBarHeight = jMenuBar.getPreferredSize().height;
			Dimension dimension = getSize();
			dimension.height += jMenuBarHeight;
			setSize(dimension);
		}

		mShown = true;
	}

	// Close the window when the close box is clicked
	void thisWindowClosing(java.awt.event.WindowEvent e) {
		setVisible(false);
		dispose();
		System.exit(0);
	}
	
	public void printlnServerStatus(String str) {
		Date date = new java.util.Date();
		if (date != null)
		{
			jTextAreaServerStatus.append(date.toString() + ": " + str + "\n");
		} else {
			jTextAreaServerStatus.append(str + "\n");
		}
	}
	
	// the class to handle a session between this server and a client
	class sessionProc extends Thread {
		Socket client = null;
		InputStream inStream = null;
		BufferedReader serverInputReader = null;
		OutputStream outStream = null;
		
		// constructor is called with the client socket
		public sessionProc(Socket s) throws IOException {
			this.client = s;
			// create buffer reader for input stream
			inStream = client.getInputStream();
			serverInputReader = new BufferedReader( new InputStreamReader(inStream) );
			// get output stream
			outStream = client.getOutputStream();
		}
		
		public void run() {
			String inputLine = null;
			String reply = "";
			// start session
			while (true) {
				// wait until the input stream is ready
				try {
					while (serverInputReader.ready() == false) {
						try {
							Thread.sleep(10);
						} catch(InterruptedException e1) {
							break;
						}
					}
				} catch (IOException e) {
				
				}
				
				// read until the input stream becomes empty
				try {
					while (serverInputReader.ready() == true) {
						try {
							inputLine = serverInputReader.readLine();
						} catch (IOException e) {
							printlnServerStatus("Couldn't read line.");
							continue;
						}
						
						// process line if it's not null
						if (inputLine != null) {
							printlnServerStatus("<RCV> " + inputLine);	

							reply = inputLine.toUpperCase();
							reply = new String(reply + "\r\n");// LF CR
							// reply
							if (reply != null) {
								try{
									outStream.write(reply.getBytes());
									outStream.flush();
									printlnServerStatus("<SND> " + reply);
									continue;
								} catch (IOException e) {
									printlnServerStatus("Couldn't write");
									continue;
								}
							}
						}
						
						try {
							Thread.sleep(10);
						} catch(InterruptedException e1) {
							break;
						}
					}
				} catch (IOException e) {
				
				}
			}
			// stop this session thread
			//stop();
			
			/*
			// close client socket
			try {
				client.close();
				printlnServerStatus("Closed client socket.\n");
			} catch (IOException e6) {
			
			}
			client = null;
			*/
			
			//return;
		}
	}

			
	Socket clientSocket = null;
				
	public void startServer()
	{
		// start serving
		
		// get port number from the text field
		String portTxt = jTextFieldServerPort.getText();
		Integer intObj = new Integer(portTxt);
		serverPort = intObj.intValue();

		// create server socket
		try {
			serverSocket = new ServerSocket(serverPort);
			printlnServerStatus("Created server socket. Port = " + String.valueOf(serverSocket.getLocalPort()));
		} catch (IOException e1) {
			printlnServerStatus("Couldn't create server socket." );
			return;
		}
		// create server thread
		serverThread = new Thread() {
			public void run() {
				// start accepting a client
				while (clientSocket == null) {
					//Socket clientSocket = null;
					// polling...
					try {
						clientSocket = serverSocket.accept();
						printlnServerStatus("Accepted a client. Address = " + clientSocket.getInetAddress().getHostAddress() +
							", Port = " + String.valueOf(clientSocket.getPort()));
					} catch (IOException e2) {
						printlnServerStatus("Couldn't accept a client.");
						continue;
					}
				}
				
				// once the client is accepted, we will use this session forever...
				//while (true) {	
					// session with the client
					try {
						// start the session with the accepted client
						Thread sessionThread = new Thread( new sessionProc(clientSocket) );
						sessionThread.start();
					} catch (IOException e3) {
						/*
						if (clientSocket != null) {
							try {
								clientSocket.close();
							} catch (IOException e4) {
							
							}
							clientSocket = null;
						}
						*/
						//printlnServerStatus("Couldn't start session thread.");
						//continue;
					}
					
					// sleep server thread
					try {
						Thread.sleep(10);
					} catch (InterruptedException e4) {
						/*
						if (clientSocket != null) {
							try {
								clientSocket.close();
							} catch (IOException e5) {
							
							}
							clientSocket = null;
						}
						*/
						//continue;
					}
				//}
			}
			
		};
		
		if (serverThread == null)
		{
			printlnServerStatus("Couldn't create server thread.");
			return;
		}
		serverThread.start();
		
		// set button text
		jButtonStartStopServer.setText("Stop");
		
		// toggle flag
		isServing = true;
	}
	
	public void stopServer()
	{
		String portTxt = String.valueOf(serverPort);
		
		if (clientSocket != null) {
			try {
				clientSocket.close();
			} catch (IOException e4) {
			
			}
			clientSocket = null;
		}
		
		// stop serving
		if (serverThread != null) {
			if (serverThread.isAlive() == true) {
				serverThread.stop();
			}
			serverThread = null;
		}
		
		// dispose server socket 
		if (serverSocket != null) {
			try {
				serverSocket.close();
				printlnServerStatus("Closed server socket.");
			} catch (IOException e6) {
			
			}
			serverSocket = null;
		}
		
		// set button text 
		jButtonStartStopServer.setText("Start");
		
		// toggle flag
		isServing = false;
	}

	public void jButtonStartStopServerActionPerformed(java.awt.event.ActionEvent e) {
		// Toggle status of the server.
		if (isServing) {
			stopServer();
		} else {
			startServer();
		}
	}
	
	public void jButtonClearServerStatusActionPerformed(java.awt.event.ActionEvent e) {
		// clear server status by setting empty string
		jTextAreaServerStatus.setText("");
	}
	
	
	
}
