/** 
 * RelayStation.java
 *
 * Title:			RelayStation
 * Description:		Copyright (c) 2001, Junzo SATO. All rights reserved.
 * @author			RoboDog
 * @version			
 */

package RelayStation;
import javax.swing.*;

import java.io.*;
import java.net.*;

public class Relay extends Thread {
	InputStream in = null;
	OutputStream out = null;
	BufferedInputStream input = null;
	
	public Relay(InputStream inStream, OutputStream outStream) {
		in = inStream;
		out = outStream;
		input = new BufferedInputStream(in);
		start();
	}
	
	public OutputStream getOutputStream() {
		return out;
	}
	
	public void setOutputStream(OutputStream outStream) {
		out = outStream;
	}
	
	public void run() {
		int n = 0;
		//byte[] buff = new byte[1024];
		while (true) {
			try {
				// from remote client to local server
				n = input.available();
				if (n <= 0) continue;
				
				System.out.println(n);
				
				byte[] buff = new byte[n];
				n = input.read(buff);
				if (n <= 0) continue;
				
				//-------------------
				// relay buffer
				out.write(buff,0,n);
				out.flush();
				//-------------------
				
				buff = null;
			} catch (IOException e) {

			}

			try {
				Thread.sleep(1);
			} catch (InterruptedException e) {
			
			}
		}
	}
}

public class RelayStation {
	static public void main(String[] args) {
		// To specify default arguments in the CWPro IDE,
		// see Program Arguments in Runtime Settings.
		// 1357 "127.0.0.1" 23
		if (args.length == 3) {
			System.out.println(args[0] + " " + args[1] + " " + args[2]);
			
			startLocalServer(Integer.parseInt(args[0]));
			connectToRemoteServer(args[1], Integer.parseInt(args[2]));
		} else {
			System.out.println("2001 127.0.0.1 23");
			startLocalServer(2001);
			connectToRemoteServer("127.0.0.1", 23);
		}
	}
	
	//==============================================================
	static public String negotiate(Socket clientSocket) {
		String str = null;
		
		// FOR TELNET 
		// Reference:
		// "Java Network Programming" by Tomihiro Odaka (Written in Japanese), Ohmsha, 1999 
		byte IAC = (byte)255;
		byte DONT = (byte)254;
		byte DO = (byte)253;
		byte WONT = (byte)252;
		byte WILL = (byte)251;
		try {
			BufferedInputStream in = new BufferedInputStream(clientSocket.getInputStream());
			OutputStream out = clientSocket.getOutputStream();
			byte[] token = new byte[3];
			while (true) {
				in.mark(token.length);
				if (in.available() >= token.length) {
					in.read(token);
					if (token[0] != IAC) {
						in.reset();
													
						// derive "login:" prompt
						int n = in.available();
						byte[] buff = new byte[n];
						in.read(buff);
						ByteArrayOutputStream ba = new ByteArrayOutputStream(n);
						ba.write(buff,0,n);
						str = ba.toString();
						str = str.trim();
						buff = null;
						
						return str;
					} else if (token[1] == DO) {
						token[1] = WONT;
						out.write(token);
						continue;
					}
				}
			}
		} catch (IOException e) {
		
		}
		
		return str;
	}
	
	static Relay fromRemoteClient = null;
	static Relay toRemoteServer = null;
	
	static public void startLocalServer(int port) {
		int localServerPort = port;
		ServerSocket localServerSocket = null;
		// create local server socket
		try {
			localServerSocket = new ServerSocket(localServerPort);
		} catch (IOException e) {
			return;
		}
		
		// wait for a client...; for me, Mathematica :)
		Socket remoteClientSocket = null;
		while (remoteClientSocket == null) {
			try {
				remoteClientSocket = localServerSocket.accept();
			} catch (IOException e1) {
				continue;
			}
		}
		
		//--------------------------------
		// start session with the client
		//--------------------------------
		
		// get I/O streams of the local server
		InputStream localServerInputStream = null;
		OutputStream localServerOutputStream = null;
		try {
			localServerInputStream = remoteClientSocket.getInputStream();
			localServerOutputStream = remoteClientSocket.getOutputStream();
		} catch (IOException e2) {
			return;
		}		

		if (localServerInputStream == null || localServerOutputStream == null) return;
		fromRemoteClient = new Relay(localServerInputStream, localServerOutputStream);
	}
	
	static public void connectToRemoteServer(String addr, int port) {
		String remoteServerAddr = addr;
		int remoteServerPort = port;
		Socket localClientSocket = null;
		
		try {
			// create socket to the server
			localClientSocket = new Socket(remoteServerAddr, remoteServerPort);
		} catch (IOException e) {
			return;
		}
		
		// get I/O streams of the local client
		InputStream localClientInputStream = null;
		OutputStream localClientOutputStream = null;
		try {
			localClientInputStream = localClientSocket.getInputStream();
			localClientOutputStream = localClientSocket.getOutputStream();
		} catch (IOException e2) {
			return;
		}		
		if (localClientInputStream == null || localClientOutputStream == null) return;
		
		//---------------------------------------------------------------------
		// Do negotiation if the remote server is a telnet host.
		String prompt = null;
		if (remoteServerPort == 23) {
			prompt = negotiate(localClientSocket);
		}
		if (prompt != null) {
			// send prompt to the remote client
			if (fromRemoteClient == null) return;
			OutputStream out = fromRemoteClient.getOutputStream();
			OutputStreamWriter writer = new OutputStreamWriter(out);
			try {
				writer.write(prompt,0,prompt.length());
				writer.flush();
			} catch (IOException e) {
			
			}
		}
		//----------------------------------------------------------------------
		
		// switch the target of the fromRemoteClient's output
		if (fromRemoteClient == null) return;
		OutputStream stream = fromRemoteClient.getOutputStream();
		fromRemoteClient.setOutputStream(localClientOutputStream);
		
		// create toRemoteServer thread
		toRemoteServer = new Relay(localClientInputStream, stream);
	}
}

