/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.Expr;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.StdLink;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.Hashtable;

public abstract class ThreadMathListener
implements EventListener {
    private Hashtable handlers;
    private KernelLink ml;
    static /* synthetic */ Class class$java$lang$Object;

    public ThreadMathListener() {
        this(StdLink.getLink());
    }

    public ThreadMathListener(KernelLink ml) {
        this.ml = ml;
        this.setupEvents();
    }

    public ThreadMathListener(String[][] handlers) {
        this();
        int i = 0;
        while (i < handlers.length) {
            this.setHandler(handlers[i][0], handlers[i][1]);
            ++i;
        }
    }

    public boolean setHandler(String meth, String func) {
        if (this.handlers.containsKey(meth)) {
            this.handlers.put(meth, func);
            return true;
        }
        this.ml.message("Java::nohndlr", new String[]{meth, this.getClass().getName()});
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expr callMathHandler(String meth, Object[] args) {
        if (this.ml == null) {
            return null;
        }
        String func = (String)this.handlers.get(meth);
        if (func == null) {
            System.err.println("Warning: calling MathListener.callMathHandler() with a method name that does not exist in the class. Method name is " + meth + ". Class is " + this.getClass().getName());
            return null;
        }
        Expr result = null;
        if (!func.equals("")) {
            int numArgs = args != null ? args.length : 0;
            StdLink.requestTransaction();
            KernelLink kernelLink = this.ml;
            synchronized (kernelLink) {
                try {
                    this.ml.putFunction("EvaluatePacket", 1);
                    this.ml.putNext(70);
                    this.ml.putArgCount(numArgs);
                    this.ml.putFunction("ToExpression", 1);
                    this.ml.put((Object)func);
                    int i = 0;
                    while (i < numArgs) {
                        this.ml.put(args[i]);
                        ++i;
                    }
                    this.ml.endPacket();
                    this.ml.waitForAnswer();
                    result = this.ml.getExpr();
                }
                catch (MathLinkException exc) {
                    this.ml.clearError();
                    this.ml.newPacket();
                }
            }
        }
        return result;
    }

    private void setupEvents() {
        this.handlers = new Hashtable(10);
        try {
            Method[] meths = this.getClass().getMethods();
            Method[] objectMethods = (class$java$lang$Object == null ? (class$java$lang$Object = ThreadMathListener.class$("java.lang.Object")) : class$java$lang$Object).getMethods();
            String[] objectMethodNames = new String[objectMethods.length];
            int i = 0;
            while (i < objectMethods.length) {
                objectMethodNames[i] = objectMethods[i].getName();
                ++i;
            }
            int i2 = 0;
            while (i2 < meths.length) {
                boolean belongs = true;
                String name = meths[i2].getName();
                int j = 0;
                while (j < objectMethodNames.length) {
                    if (name.equals(objectMethodNames[j])) {
                        belongs = false;
                        break;
                    }
                    ++j;
                }
                if (belongs) {
                    this.handlers.put(name, "");
                }
                ++i2;
            }
        }
        catch (SecurityException e) {
            System.err.println("Warning: MathListener cannot establish event handler callbacks: " + e.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

