/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.ExprFormatException;
import com.wolfram.jlink.LoopbackLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkFactory;
import com.wolfram.jlink.NativeLink;
import com.wolfram.jlink.Utils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class Expr
implements Serializable {
    public static final int INTEGER = 1;
    public static final int REAL = 2;
    public static final int STRING = 3;
    public static final int SYMBOL = 4;
    public static final int RATIONAL = 5;
    public static final int COMPLEX = 6;
    public static final int BIGINTEGER = 7;
    public static final int BIGDECIMAL = 8;
    private static final int UNKNOWN = 0;
    private static final int FIRST_COMPOSITE = 100;
    private static final int FUNCTION = 100;
    private static final int FIRST_ARRAY_TYPE = 200;
    private static final int INTARRAY1 = 200;
    private static final int REALARRAY1 = 201;
    private static final int INTARRAY2 = 202;
    private static final int REALARRAY2 = 203;
    public static final Expr SYM_SYMBOL = new Expr(4, "Symbol");
    public static final Expr SYM_INTEGER = new Expr(4, "Integer");
    public static final Expr SYM_REAL = new Expr(4, "Real");
    public static final Expr SYM_STRING = new Expr(4, "String");
    public static final Expr SYM_RATIONAL = new Expr(4, "Rational");
    public static final Expr SYM_COMPLEX = new Expr(4, "Complex");
    public static final Expr SYM_LIST = new Expr(4, "List");
    public static final Expr SYM_TRUE = new Expr(4, "True");
    public static final Expr SYM_FALSE = new Expr(4, "False");
    public static final Expr INT_ONE = new Expr(1L);
    public static final Expr INT_ZERO = new Expr(0L);
    public static final Expr INT_MINUSONE = new Expr(-1L);
    private int type;
    private Expr head;
    private Expr[] args;
    private Object val;
    private transient LoopbackLink link;
    private volatile int cachedHashCode = 0;
    private static final long serialVersionUID = 469201568023508L;

    private Expr() {
    }

    public Expr(int n, String string) {
        this.type = n;
        switch (n) {
            case 1: {
                this.head = SYM_INTEGER;
                this.val = new Long(string);
                break;
            }
            case 2: {
                this.head = SYM_REAL;
                this.val = new Double(string);
                break;
            }
            case 3: {
                this.head = SYM_STRING;
                this.val = string;
                break;
            }
            case 4: {
                this.head = this;
                this.val = string;
                break;
            }
            case 7: {
                this.head = SYM_INTEGER;
                this.val = new BigInteger(string);
                break;
            }
            case 8: {
                this.head = SYM_REAL;
                this.val = new BigDecimal(string);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type in Expr(type, string) constructor: " + n);
            }
        }
    }

    public Expr(long l) {
        this.type = 1;
        this.head = SYM_INTEGER;
        this.val = new Long(l);
    }

    public Expr(double d) {
        this.type = 2;
        this.head = SYM_REAL;
        this.val = new Double(d);
    }

    public Expr(String string) {
        this.type = 3;
        this.head = SYM_STRING;
        this.val = string;
    }

    public Expr(int[] nArray) {
        this.type = 200;
        this.head = SYM_LIST;
        this.val = nArray.clone();
    }

    public Expr(double[] dArray) {
        this.type = 201;
        this.head = SYM_LIST;
        this.val = dArray.clone();
    }

    public Expr(int[][] nArray) {
        this.type = 202;
        this.head = SYM_LIST;
        this.val = new int[nArray.length][];
        int n = 0;
        while (n < nArray.length) {
            ((int[][])this.val)[n] = (int[])nArray[n].clone();
            ++n;
        }
    }

    public Expr(double[][] dArray) {
        this.type = 203;
        this.head = SYM_LIST;
        this.val = new double[dArray.length][];
        int n = 0;
        while (n < dArray.length) {
            ((double[][])this.val)[n] = (double[])dArray[n].clone();
            ++n;
        }
    }

    public Expr(BigInteger bigInteger) {
        this.type = 7;
        this.head = SYM_INTEGER;
        this.val = bigInteger;
    }

    public Expr(BigDecimal bigDecimal) {
        this.type = 8;
        this.head = SYM_REAL;
        this.val = bigDecimal;
    }

    public Expr(Expr expr, Expr[] exprArray) {
        this.type = 100;
        this.head = expr;
        this.args = exprArray != null ? (Expr[])exprArray.clone() : new Expr[]{};
    }

    public static Expr createFromLink(MathLink mathLink) throws MathLinkException {
        return Expr.createFromLink(mathLink, true);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.prepareFromLoopback();
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Expr)) {
            return false;
        }
        Expr expr = (Expr)object;
        if (this.cachedHashCode != 0 && expr.cachedHashCode != 0 && this.cachedHashCode != expr.cachedHashCode) {
            return false;
        }
        expr.prepareFromLoopback();
        this.prepareFromLoopback();
        if (this.type != expr.type) {
            return false;
        }
        if (this.val != null) {
            if (expr.val == null) {
                return false;
            }
            switch (this.type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: 
                case 8: {
                    return this.val.equals(expr.val);
                }
                case 200: {
                    int[] nArray = (int[])this.val;
                    int[] nArray2 = (int[])expr.val;
                    if (nArray.length != nArray2.length) {
                        return false;
                    }
                    int n = 0;
                    while (n < nArray.length) {
                        if (nArray[n] != nArray2[n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 201: {
                    double[] dArray = (double[])this.val;
                    double[] dArray2 = (double[])expr.val;
                    if (dArray.length != dArray2.length) {
                        return false;
                    }
                    int n = 0;
                    while (n < dArray.length) {
                        if (dArray[n] != dArray2[n]) {
                            return false;
                        }
                        ++n;
                    }
                    return true;
                }
                case 202: {
                    int[][] nArray = (int[][])this.val;
                    int[][] nArray3 = (int[][])expr.val;
                    if (nArray.length != nArray3.length) {
                        return false;
                    }
                    int n = 0;
                    while (n < nArray.length) {
                        int[] nArray4 = nArray[n];
                        int[] nArray5 = nArray3[n];
                        if (nArray4.length != nArray5.length) {
                            return false;
                        }
                        int n2 = 0;
                        while (n2 < nArray4.length) {
                            if (nArray4[n2] != nArray5[n2]) {
                                return false;
                            }
                            ++n2;
                        }
                        ++n;
                    }
                    return true;
                }
                case 203: {
                    double[][] dArray = (double[][])this.val;
                    double[][] dArray3 = (double[][])expr.val;
                    if (dArray.length != dArray3.length) {
                        return false;
                    }
                    int n = 0;
                    while (n < dArray.length) {
                        double[] dArray4 = dArray[n];
                        double[] dArray5 = dArray3[n];
                        if (dArray4.length != dArray5.length) {
                            return false;
                        }
                        int n3 = 0;
                        while (n3 < dArray4.length) {
                            if (dArray4[n3] != dArray5[n3]) {
                                return false;
                            }
                            ++n3;
                        }
                        ++n;
                    }
                    return true;
                }
            }
            return false;
        }
        if (expr.val != null) {
            return false;
        }
        if (!this.head.equals(expr.head)) {
            return false;
        }
        if (this.args.length != expr.args.length) {
            return false;
        }
        int n = 0;
        while (n < this.args.length) {
            if (!this.args[n].equals(expr.args[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        this.prepareFromLoopback();
        if (this.type != 5 && this.type != 6 && this.atomQ()) {
            return this.val.hashCode();
        }
        int n = 17;
        n = 37 * n + this.type;
        if (this.head != null) {
            n = 37 * n + this.head.hashCode();
        }
        if (this.args != null) {
            int n2 = 0;
            while (n2 < this.args.length) {
                n = 37 * n + this.args[n2].hashCode();
                ++n2;
            }
        }
        if (this.val != null) {
            if (this.type < 200) {
                n = 37 * n + this.val.hashCode();
            } else if (this.type == 200) {
                int[] nArray = (int[])this.val;
                int n3 = 0;
                while (n3 < nArray.length) {
                    n += nArray[n3];
                    ++n3;
                }
            } else if (this.type == 201) {
                double[] dArray = (double[])this.val;
                int n4 = 0;
                while (n4 < dArray.length) {
                    n += (int)dArray[n4];
                    ++n4;
                }
            } else if (this.type == 202) {
                int[][] nArray = (int[][])this.val;
                int n5 = 0;
                while (n5 < nArray.length) {
                    int[] nArray2 = nArray[n5];
                    int n6 = 0;
                    while (n6 < nArray2.length) {
                        n += nArray2[n6];
                        ++n6;
                    }
                    ++n5;
                }
            } else if (this.type == 203) {
                double[][] dArray = (double[][])this.val;
                int n7 = 0;
                while (n7 < dArray.length) {
                    double[] dArray2 = dArray[n7];
                    int n8 = 0;
                    while (n8 < dArray2.length) {
                        n += (int)dArray2[n8];
                        ++n8;
                    }
                    ++n7;
                }
            }
        }
        this.cachedHashCode = n;
        return n;
    }

    int inheritedHashCode() {
        return super.hashCode();
    }

    public synchronized void dispose() {
        if (this.link != null) {
            this.link.close();
            this.link = null;
        } else if (this.type == 100) {
            if (this.head != null) {
                this.head.dispose();
            }
            if (this.args != null) {
                int n = 0;
                while (n < this.args.length) {
                    this.args[n].dispose();
                    ++n;
                }
            }
        }
    }

    public Expr head() {
        this.prepareFromLoopback();
        return this.type < 200 ? this.head : SYM_LIST;
    }

    public synchronized Expr[] args() {
        return (Expr[])this.nonCopyingArgs().clone();
    }

    public int length() {
        this.prepareFromLoopback();
        if (this.type >= 200) {
            return Array.getLength(this.val);
        }
        return this.args != null ? this.args.length : 0;
    }

    public int[] dimensions() {
        this.prepareFromLoopback();
        int[] nArray = null;
        if (this.type < 100) {
            nArray = new int[]{};
        } else {
            switch (this.type) {
                case 200: 
                case 201: {
                    nArray = new int[]{Array.getLength(this.val)};
                    break;
                }
                case 202: {
                    nArray = new int[]{Array.getLength(this.val), ((int[][])this.val)[0].length};
                    break;
                }
                case 203: {
                    nArray = new int[]{Array.getLength(this.val), ((double[][])this.val)[0].length};
                    break;
                }
                case 100: {
                    int n;
                    Object object;
                    if (this.args.length == 0) {
                        nArray = new int[]{0};
                        break;
                    }
                    int[] nArray2 = this.args[0].dimensions();
                    int[] nArray3 = new int[nArray2.length + 1];
                    nArray3[0] = this.args.length;
                    System.arraycopy(nArray2, 0, nArray3, 1, nArray2.length);
                    int n2 = 1 + nArray2.length;
                    int n3 = 1;
                    while (n3 < this.args.length) {
                        if (n2 == 1) break;
                        object = this.args[n3].dimensions();
                        n2 = Math.min(n2, 1 + ((Object)object).length);
                        n = 1;
                        while (n < n2) {
                            if (nArray3[n] != object[n - 1]) {
                                n2 = n;
                                break;
                            }
                            ++n;
                        }
                        ++n3;
                    }
                    object = this.head().toString();
                    n = this.checkHeads((String)object, 0, n2);
                    nArray = new int[n];
                    System.arraycopy(nArray3, 0, nArray, 0, n);
                    break;
                }
            }
        }
        return nArray;
    }

    public Expr part(int n) {
        this.prepareFromLoopback();
        if (Math.abs(n) > this.length()) {
            throw new IllegalArgumentException("Cannot take part " + n + " from this Expr because it has length " + this.length() + ".");
        }
        if (n == 0) {
            return this.head();
        }
        if (n > 0) {
            return this.nonCopyingArgs()[n - 1];
        }
        return this.nonCopyingArgs()[this.length() + n];
    }

    public Expr part(int[] nArray) {
        try {
            int n = nArray.length;
            if (n == 1) {
                return this.part(nArray[0]);
            }
            int[] nArray2 = new int[n - 1];
            System.arraycopy(nArray, 0, nArray2, 0, n - 1);
            return this.part(nArray2).part(nArray[n - 1]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IllegalArgumentException("Part " + new Expr(nArray).toString() + " of this Expr does not exist.");
        }
    }

    public double re() throws ExprFormatException {
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                return this.asDouble();
            }
            case 6: {
                return this.args[0].asDouble();
            }
        }
        throw new ExprFormatException("This Expr is of type " + this.typeToString() + ", so you cannot call re() on it.");
    }

    public double im() throws ExprFormatException {
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 8: {
                return 0.0;
            }
            case 6: {
                return this.args[1].asDouble();
            }
        }
        throw new ExprFormatException("This Expr is of type " + this.typeToString() + ", so you cannot call im() on it.");
    }

    public String toString() {
        String string = null;
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: 
            case 4: 
            case 7: 
            case 8: {
                string = this.val.toString();
                break;
            }
            case 2: {
                string = Expr.doubleToInputFormString((Double)this.val);
                break;
            }
            case 3: {
                string = this.val.toString();
                StringBuffer stringBuffer = new StringBuffer(string.length() + 10);
                stringBuffer.append('\"');
                int n = string.length();
                int n2 = 0;
                while (n2 < n) {
                    char c = string.charAt(n2);
                    if (c == '\\' || c == '\"') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c);
                    ++n2;
                }
                stringBuffer.append('\"');
                string = new String(stringBuffer);
                break;
            }
            case 5: {
                string = "Rational[" + this.args[0].toString() + ", " + this.args[1].toString() + "]";
                break;
            }
            case 6: {
                string = "Complex[" + this.args[0].toString() + ", " + this.args[1].toString() + "]";
                break;
            }
            case 100: {
                boolean bl = this.listQ();
                int n = this.length();
                StringBuffer stringBuffer = new StringBuffer(n * 2);
                stringBuffer.append(bl ? "{" : this.head.toString() + "[");
                int n3 = 0;
                while (n3 < n) {
                    stringBuffer.append(this.args[n3].toString());
                    if (n3 < n - 1) {
                        stringBuffer.append(',');
                    }
                    ++n3;
                }
                stringBuffer.append(bl ? (char)'}' : ']');
                string = new String(stringBuffer);
                break;
            }
            case 200: 
            case 201: {
                int n = Array.getLength(this.val);
                int[] nArray = this.type == 200 ? (int[])this.val : null;
                double[] dArray = this.type == 201 ? (double[])this.val : null;
                StringBuffer stringBuffer = new StringBuffer(n * 2);
                stringBuffer.append('{');
                int n4 = 0;
                while (n4 < n) {
                    stringBuffer.append(this.type == 200 ? String.valueOf(nArray[n4]) : Expr.doubleToInputFormString(dArray[n4]));
                    if (n4 < n - 1) {
                        stringBuffer.append(',');
                    }
                    ++n4;
                }
                stringBuffer.append('}');
                string = new String(stringBuffer);
                break;
            }
            case 202: 
            case 203: {
                int n = Array.getLength(this.val);
                int n5 = Array.getLength(Array.get(this.val, 0));
                int[][] nArray = this.type == 202 ? (int[][])this.val : null;
                double[][] dArray = this.type == 203 ? (double[][])this.val : null;
                StringBuffer stringBuffer = new StringBuffer(n * n5 * 2);
                stringBuffer.append('{');
                int n6 = 0;
                while (n6 < n) {
                    stringBuffer.append('{');
                    int n7 = 0;
                    while (n7 < n5) {
                        stringBuffer.append(this.type == 202 ? String.valueOf(nArray[n6][n7]) : Expr.doubleToInputFormString(dArray[n6][n7]));
                        if (n7 < n5 - 1) {
                            stringBuffer.append(',');
                        }
                        ++n7;
                    }
                    stringBuffer.append(n6 < n - 1 ? "}," : "}");
                    ++n6;
                }
                stringBuffer.append('}');
                string = new String(stringBuffer);
                break;
            }
        }
        return string;
    }

    public boolean atomQ() {
        this.prepareFromLoopback();
        return this.type < 100;
    }

    public boolean stringQ() {
        this.prepareFromLoopback();
        return this.type == 3;
    }

    public boolean symbolQ() {
        this.prepareFromLoopback();
        return this.type == 4;
    }

    public boolean integerQ() {
        this.prepareFromLoopback();
        return this.type == 1 || this.type == 7;
    }

    public boolean realQ() {
        this.prepareFromLoopback();
        return this.type == 2 || this.type == 8;
    }

    public boolean rationalQ() {
        this.prepareFromLoopback();
        return this.type == 5;
    }

    public boolean complexQ() {
        this.prepareFromLoopback();
        return this.type == 6;
    }

    public boolean numberQ() {
        this.prepareFromLoopback();
        return this.type == 2 || this.type == 1 || this.type == 7 || this.type == 8 || this.type == 6 || this.type == 5;
    }

    public boolean bigIntegerQ() {
        this.prepareFromLoopback();
        return this.type == 7;
    }

    public boolean bigDecimalQ() {
        this.prepareFromLoopback();
        return this.type == 8;
    }

    public boolean trueQ() {
        this.prepareFromLoopback();
        return this.type == 4 && this.val.equals("True");
    }

    public boolean listQ() {
        this.prepareFromLoopback();
        return this.type >= 200 || this.type == 100 && this.head.type == 4 && this.head.val.equals("List");
    }

    public boolean vectorQ() {
        this.prepareFromLoopback();
        if (this.type == 200 || this.type == 201) {
            return true;
        }
        if (this.type == 202 || this.type == 203 || !this.listQ()) {
            return false;
        }
        int n = 0;
        while (n < this.args.length) {
            if (this.args[n].listQ()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean vectorQ(int n) {
        if (!this.vectorQ()) {
            return false;
        }
        switch (this.type) {
            case 200: {
                return n == 1;
            }
            case 201: {
                return n == 2;
            }
            case 202: 
            case 203: {
                return false;
            }
        }
        int n2 = this.length();
        int n3 = 0;
        while (n3 < n2) {
            if (this.args[n3].type() != n) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public boolean matrixQ() {
        this.prepareFromLoopback();
        if (this.type == 202 || this.type == 203) {
            return true;
        }
        if (this.type == 200 || this.type == 201 || !this.listQ()) {
            return false;
        }
        if (this.args.length == 0) {
            return false;
        }
        int n = 0;
        while (n < this.args.length) {
            if (!this.args[n].vectorQ()) {
                return false;
            }
            ++n;
        }
        return this.dimensions().length >= 2;
    }

    public boolean matrixQ(int n) {
        if (!this.matrixQ()) {
            return false;
        }
        if (n == 1 && this.type == 202 || n == 2 && this.type == 203) {
            return true;
        }
        int n2 = this.length();
        this.nonCopyingArgs();
        int n3 = 0;
        while (n3 < n2) {
            if (!this.args[n3].vectorQ(n)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public int asInt() throws ExprFormatException {
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: {
                return ((Long)this.val).intValue();
            }
            case 7: {
                return ((BigInteger)this.val).intValue();
            }
        }
        throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java int");
    }

    public long asLong() throws ExprFormatException {
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: {
                return (Long)this.val;
            }
            case 7: {
                return ((BigInteger)this.val).longValue();
            }
        }
        throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java long");
    }

    public double asDouble() throws ExprFormatException {
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: 
            case 2: {
                return ((Number)this.val).doubleValue();
            }
            case 7: {
                return ((BigInteger)this.val).doubleValue();
            }
            case 8: {
                return ((BigDecimal)this.val).doubleValue();
            }
            case 5: {
                return this.args[0].asDouble() / this.args[1].asDouble();
            }
        }
        throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java double");
    }

    public String asString() throws ExprFormatException {
        this.prepareFromLoopback();
        if (this.type != 3 && this.type != 4) {
            throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java String");
        }
        return (String)this.val;
    }

    public BigInteger asBigInteger() throws ExprFormatException {
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: 
            case 2: {
                return BigInteger.valueOf(((Number)this.val).longValue());
            }
            case 7: {
                return (BigInteger)this.val;
            }
            case 8: {
                return ((BigDecimal)this.val).toBigInteger();
            }
        }
        throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java BigInteger");
    }

    public BigDecimal asBigDecimal() throws ExprFormatException {
        this.prepareFromLoopback();
        switch (this.type) {
            case 2: {
                return new BigDecimal((Double)this.val);
            }
            case 1: {
                return BigDecimal.valueOf((Long)this.val);
            }
            case 7: {
                return new BigDecimal((BigInteger)this.val);
            }
            case 8: {
                return (BigDecimal)this.val;
            }
        }
        throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java BigInteger");
    }

    public Object asArray(int n, int n2) throws ExprFormatException {
        this.prepareFromLoopback();
        if (n2 > 2) {
            throw new IllegalArgumentException("Depths > 2 are not supported in Expr.asArray()");
        }
        if (n != 1 && n != 2) {
            throw new IllegalArgumentException("Unsupported type in Expr.asArray(): " + n);
        }
        switch (this.type) {
            case 200: {
                if (n2 != 1 || n != 1) {
                    throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java array of the requested type and depth");
                }
                return (int[])((int[])this.val).clone();
            }
            case 201: {
                if (n2 != 1 || n != 2) {
                    throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java array of the requested type and depth");
                }
                return (double[])((double[])this.val).clone();
            }
            case 202: {
                if (n2 != 2 || n != 1) {
                    throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java array of the requested type and depth");
                }
                int[][] nArrayArray = new int[((int[][])this.val).length][];
                int n3 = 0;
                while (n3 < nArrayArray.length) {
                    nArrayArray[n3] = (int[])((int[][])this.val)[n3].clone();
                    ++n3;
                }
                return nArrayArray;
            }
            case 203: {
                if (n2 != 2 || n != 2) {
                    throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java array of the requested type and depth");
                }
                double[][] dArrayArray = new double[((double[][])this.val).length][];
                int n4 = 0;
                while (n4 < dArrayArray.length) {
                    dArrayArray[n4] = (double[])((double[][])this.val)[n4].clone();
                    ++n4;
                }
                return dArrayArray;
            }
            case 100: {
                if (n2 == 1) {
                    if (n == 1) {
                        int[] nArray = new int[this.args.length];
                        int n5 = 0;
                        while (n5 < this.args.length) {
                            if (!this.args[n5].integerQ()) {
                                throw new ExprFormatException("This Expr cannot be represented as a Java array of ints because some elements are not integers");
                            }
                            nArray[n5] = this.args[n5].asInt();
                            ++n5;
                        }
                        return nArray;
                    }
                    double[] dArray = new double[this.args.length];
                    int n6 = 0;
                    while (n6 < this.args.length) {
                        if (!this.args[n6].realQ() && !this.args[n6].integerQ()) {
                            throw new ExprFormatException("This Expr cannot be represented as a Java array of doubles because some elements are not real numbers");
                        }
                        dArray[n6] = this.args[n6].asDouble();
                        ++n6;
                    }
                    return dArray;
                }
                if (n == 1) {
                    int[][] nArrayArray = new int[this.args.length][];
                    int n7 = 0;
                    while (n7 < this.args.length) {
                        nArrayArray[n7] = (int[])this.args[n7].asArray(n, n2);
                        ++n7;
                    }
                    return nArrayArray;
                }
                double[][] dArrayArray = new double[this.args.length][];
                int n8 = 0;
                while (n8 < this.args.length) {
                    dArrayArray[n8] = (double[])this.args[n8].asArray(n, n2);
                    ++n8;
                }
                return dArrayArray;
            }
        }
        throw new ExprFormatException("This Expr is of type " + this.typeToString() + " and cannot be represented as a Java array of the requested type and depth");
    }

    public synchronized void put(MathLink mathLink) throws MathLinkException {
        block8: {
            if (this.link != null) {
                long l = this.link.createMark();
                try {
                    mathLink.transferExpression(this.link);
                    Object var5_4 = null;
                    mathLink.clearError();
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    mathLink.clearError();
                    this.link.seekMark(l);
                    this.link.destroyMark(l);
                    throw throwable;
                }
                this.link.seekMark(l);
                this.link.destroyMark(l);
                {
                    break block8;
                }
            }
            if (this.val != null) {
                if (this.type == 4) {
                    mathLink.putSymbol((String)this.val);
                } else {
                    mathLink.put(this.val);
                }
            } else {
                mathLink.putNext(70);
                mathLink.putArgCount(this.nonCopyingArgs().length);
                mathLink.put(this.head());
                int n = 0;
                while (n < this.args.length) {
                    mathLink.put(this.args[n]);
                    ++n;
                }
            }
        }
    }

    public Expr take(int n) {
        int n2;
        int n3 = Math.abs(n);
        if (n3 > (n2 = this.nonCopyingArgs().length)) {
            throw new IllegalArgumentException("Cannot take " + n + " elements from this Expr because it has length " + n2 + ".");
        }
        Expr[] exprArray = new Expr[n3];
        if (n >= 0) {
            System.arraycopy(this.args, 0, exprArray, 0, n3);
        } else {
            System.arraycopy(this.args, n2 - n3, exprArray, 0, n3);
        }
        return new Expr(this.head, exprArray);
    }

    public Expr delete(int n) {
        int n2 = this.nonCopyingArgs().length;
        if (n == 0 || Math.abs(n) > n2) {
            throw new IllegalArgumentException(n + " is an invalid deletion position in this Expr.");
        }
        Expr[] exprArray = new Expr[n2 - 1];
        if (n > 0) {
            System.arraycopy(this.args, 0, exprArray, 0, n - 1);
            System.arraycopy(this.args, n, exprArray, n - 1, n2 - n);
        } else {
            System.arraycopy(this.args, 0, exprArray, 0, n2 + n);
            System.arraycopy(this.args, n2 + n + 1, exprArray, n2 + n, -n - 1);
        }
        return new Expr(this.head, exprArray);
    }

    public Expr insert(Expr expr, int n) {
        int n2 = this.nonCopyingArgs().length;
        if (n == 0 || Math.abs(n) > n2 + 1) {
            throw new IllegalArgumentException(n + " is an invalid insertion position into this Expr.");
        }
        Expr[] exprArray = new Expr[n2 + 1];
        if (n > 0) {
            System.arraycopy(this.args, 0, exprArray, 0, n - 1);
            exprArray[n - 1] = expr;
            System.arraycopy(this.args, n - 1, exprArray, n, n2 - (n - 1));
        } else {
            System.arraycopy(this.args, 0, exprArray, 0, n2 + n + 1);
            exprArray[n2 + n + 1] = expr;
            System.arraycopy(this.args, n2 + n + 1, exprArray, n2 + n + 2, -n - 1);
        }
        return new Expr(this.head, exprArray);
    }

    private int type() {
        this.prepareFromLoopback();
        return this.type;
    }

    private synchronized void prepareFromLoopback() {
        if (this.link != null) {
            try {
                try {
                    this.fillFromLink(this.link);
                }
                catch (MathLinkException mathLinkException) {
                    Object var3_2 = null;
                    this.link.close();
                    this.link = null;
                }
                Object var3_1 = null;
                this.link.close();
                this.link = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.link.close();
                this.link = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void fillFromLink(MathLink mathLink) throws MathLinkException {
        int n = mathLink.getType();
        if (n != 70) {
            if (n == 43) return;
            if (n == 42) return;
            if (n == 34) return;
            if (n != 35) return;
            return;
        }
        try {
            block9: {
                int n2 = mathLink.getArgCount();
                this.head = Expr.createFromLink(mathLink, false);
                if (this.head.type == 4 && this.head.val.equals("Rational")) {
                    this.type = 5;
                    this.args = new Expr[2];
                    this.args[0] = Expr.createFromLink(mathLink, false);
                    this.args[1] = Expr.createFromLink(mathLink, false);
                    break block9;
                }
                if (this.head.type == 4 && this.head.val.equals("Complex")) {
                    this.type = 6;
                    this.args = new Expr[2];
                    this.args[0] = Expr.createFromLink(mathLink, false);
                    this.args[1] = Expr.createFromLink(mathLink, false);
                } else {
                    this.type = 100;
                    this.args = new Expr[n2];
                    int n3 = 0;
                    while (n3 < n2) {
                        this.args[n3] = Expr.createFromLink(mathLink, false);
                        ++n3;
                    }
                }
            }
            Object var6_6 = null;
            mathLink.clearError();
            return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            mathLink.clearError();
            throw throwable;
        }
    }

    private static Expr createFromLink(MathLink mathLink, boolean bl) throws MathLinkException {
        int n = mathLink.getNext();
        if (n == 43 || n == 42 || n == 34 || n == 35) {
            return Expr.createAtomicExpr(mathLink, n);
        }
        Expr expr = new Expr();
        if (bl && NativeLink.nativeLibraryLoaded) {
            expr.link = MathLinkFactory.createLoopbackLink();
            expr.link.transferExpression(mathLink);
            expr.type = 0;
        } else {
            expr.fillFromLink(mathLink);
        }
        return expr;
    }

    private static Expr createAtomicExpr(MathLink mathLink, int n) throws MathLinkException {
        Expr expr = null;
        switch (n) {
            case 43: {
                String string = mathLink.getString();
                if (string.equals("0")) {
                    expr = INT_ZERO;
                    break;
                }
                if (string.equals("1")) {
                    expr = INT_ONE;
                    break;
                }
                if (string.equals("-1")) {
                    expr = INT_MINUSONE;
                    break;
                }
                expr = new Expr();
                expr.head = SYM_INTEGER;
                try {
                    expr.val = new Long(string);
                    expr.type = 1;
                }
                catch (NumberFormatException numberFormatException) {
                    expr.val = new BigInteger(string);
                    expr.type = 7;
                }
                break;
            }
            case 42: {
                expr = new Expr();
                expr.head = SYM_REAL;
                String string = mathLink.getString();
                try {
                    expr.val = new Double(string);
                    expr.type = 2;
                }
                catch (NumberFormatException numberFormatException) {
                    expr.val = Utils.bigDecimalFromString(string);
                    expr.type = 8;
                }
                break;
            }
            case 34: {
                expr = new Expr();
                expr.type = 3;
                expr.head = SYM_STRING;
                expr.val = mathLink.getString();
                break;
            }
            case 35: {
                String string = mathLink.getSymbol();
                if (string.equals("List")) {
                    expr = SYM_LIST;
                    break;
                }
                if (string.equals("True")) {
                    expr = SYM_TRUE;
                    break;
                }
                if (string.equals("False")) {
                    expr = SYM_FALSE;
                    break;
                }
                expr = new Expr();
                expr.type = 4;
                expr.head = SYM_SYMBOL;
                expr.val = string;
                break;
            }
        }
        return expr;
    }

    private synchronized Expr[] nonCopyingArgs() {
        this.prepareFromLoopback();
        if (this.args == null) {
            if (this.type < 100) {
                this.args = new Expr[0];
            } else if (this.type >= 200) {
                this.args = new Expr[Array.getLength(this.val)];
                int n = 0;
                while (n < this.args.length) {
                    switch (this.type) {
                        case 200: {
                            this.args[n] = new Expr(((int[])this.val)[n]);
                            break;
                        }
                        case 202: {
                            this.args[n] = new Expr(((int[][])this.val)[n]);
                            break;
                        }
                        case 201: {
                            this.args[n] = new Expr(((double[])this.val)[n]);
                            break;
                        }
                        case 203: {
                            this.args[n] = new Expr(((double[][])this.val)[n]);
                            break;
                        }
                    }
                    ++n;
                }
            }
        }
        return this.args;
    }

    private int checkHeads(String string, int n, int n2) {
        if (this.args == null || n > n2 || !this.head().toString().equals(string)) {
            return n;
        }
        ++n;
        int n3 = 0;
        while (n3 < this.args.length) {
            int n4 = this.args[n3].checkHeads(string, n, n2);
            if (n4 < n2) {
                n2 = n4;
            }
            ++n3;
        }
        return n2;
    }

    private String typeToString() {
        this.prepareFromLoopback();
        switch (this.type) {
            case 1: {
                return "INTEGER";
            }
            case 4: {
                return "SYMBOL";
            }
            case 7: {
                return "BIGINTEGER";
            }
            case 8: {
                return "BIGDECIMAL";
            }
            case 2: {
                return "REAL";
            }
            case 3: {
                return "STRING";
            }
            case 5: {
                return "RATIONAL";
            }
            case 6: {
                return "COMPLEX";
            }
            case 100: {
                return "FUNCTION";
            }
            case 200: {
                return "INTARRAY1D";
            }
            case 201: {
                return "REALARRAY1D";
            }
            case 202: {
                return "INTARRAY2D";
            }
            case 203: {
                return "REALARRAY2D";
            }
        }
        return "BAD TYPE";
    }

    private static String doubleToInputFormString(double d) {
        String string = Double.toString(d);
        int n = string.lastIndexOf(69);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n) + "*^" + string.substring(n + 1);
    }
}

