/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkClassLoaderImpl;
import com.wolfram.jlink.JLinkClassLoaderImpl11;
import com.wolfram.jlink.Utils;

public class JLinkClassLoader {
    private static ClassLoader singleton;

    public static ClassLoader getInstance() {
        JLinkClassLoader.initSingleton();
        return singleton;
    }

    public static synchronized void addLocations(String[] stringArray, boolean bl) {
        JLinkClassLoader.initSingleton();
        if (stringArray != null) {
            if (Utils.isJava2OrLater()) {
                ((JLinkClassLoaderImpl)singleton).addLocations(stringArray, bl);
            } else {
                ((JLinkClassLoaderImpl11)singleton).addLocations(stringArray, bl);
            }
        }
    }

    public static synchronized String[] getClassPath() {
        JLinkClassLoader.initSingleton();
        return Utils.isJava2OrLater() ? ((JLinkClassLoaderImpl)singleton).getClassPath() : ((JLinkClassLoaderImpl11)singleton).getClassPath();
    }

    public static synchronized Class classFromName(String string) throws ClassNotFoundException {
        JLinkClassLoader.initSingleton();
        return Utils.isJava2OrLater() ? Class.forName(string, true, singleton) : JLinkClassLoader.load(string);
    }

    public static synchronized Class load(String string) throws ClassNotFoundException {
        JLinkClassLoader.initSingleton();
        return singleton.loadClass(string);
    }

    public static synchronized Class classFromBytes(String string, byte[] byArray) {
        JLinkClassLoader.initSingleton();
        Class clazz = null;
        clazz = Utils.isJava2OrLater() ? ((JLinkClassLoaderImpl)singleton).defClass(string, byArray, 0, byArray.length) : ((JLinkClassLoaderImpl11)singleton).defClass(string, byArray, 0, byArray.length);
        return clazz;
    }

    private JLinkClassLoader() {
    }

    protected static void initSingleton() {
        if (singleton == null) {
            singleton = Utils.isJava2OrLater() ? new JLinkClassLoaderImpl() : new JLinkClassLoaderImpl11();
        }
    }
}

