/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.COMUtilities;
import com.wolfram.jlink.Expr;
import com.wolfram.jlink.Install;
import com.wolfram.jlink.JLinkClassLoader;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MLFunction;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.MathLinkFactory;
import com.wolfram.jlink.MathLinkImpl;
import com.wolfram.jlink.NumberRangeException;
import com.wolfram.jlink.ObjectHandler;
import com.wolfram.jlink.Reader;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.ui.ConsoleWindow;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.util.Vector;

public abstract class KernelLinkImpl
extends MathLinkImpl
implements KernelLink {
    private ObjectHandler objectHandler = new ObjectHandler();
    private Object msgSync = new Object();
    private volatile int msg;
    protected boolean isManual = false;
    protected MathLink feServerLink = null;
    protected Throwable lastError;
    private StringBuffer accumulatingPS;
    private boolean lastPktWasMsg = false;
    static final String PACKAGE_PROTECTED_CONTEXT = "JLink`Package`";
    static final String MMA_OBJECTSYMBOLPREFIX = "JLink`Objects`JavaObject";
    static final String MMA_LOADCLASSANDCREATEINSTANCEDEFS = "JLink`Package`loadClassAndCreateInstanceDefs";
    static final String MMA_CREATEINSTANCEDEFS = "JLink`Package`createInstanceDefs";
    static final String MMA_LOADCLASS = "JLink`Package`loadClassFromJava";
    static final String MMA_PREPAREFORMANUALRETURN = "JLink`Package`prepareForManualReturn";
    static final String MMA_HANDLECLEANEXCEPTION = "JLink`Package`handleCleanException";
    static final String MMA_AUTOEXCEPTION = "JLink`Package`autoException";
    static final String MMA_MANUALEXCEPTION = "JLink`Package`manualException";
    static final String MMA_NODEFAULTCTOR = "JLink`Package`issueNoDefaultCtorMessage";
    static final int TYPE_OBJECT = -14;
    static final int TYPE_FLOATORINT = -15;
    static final int TYPE_DOUBLEORINT = -16;
    static final int TYPE_ARRAY1 = -17;
    static final int TYPE_ARRAY2 = -34;
    static final int TYPE_ARRAY3 = -51;
    static final int TYPE_ARRAY4 = -68;
    static final int TYPE_ARRAY5 = -85;
    static final int TYPE_BAD = -10000;
    static /* synthetic */ Class class$java$lang$String;

    protected KernelLinkImpl() {
    }

    public synchronized void evaluate(String string) throws MathLinkException {
        this.putFunction("EvaluatePacket", 1);
        this.putFunction("ToExpression", 1);
        this.put(string);
        this.endPacket();
        this.flush();
    }

    public synchronized void evaluate(Expr expr) throws MathLinkException {
        this.putFunction("EvaluatePacket", 1);
        this.put(expr);
        this.endPacket();
        this.flush();
    }

    public synchronized String evaluateToOutputForm(String string, int n) {
        return this.evalToString(string, n, "OutputForm");
    }

    public synchronized String evaluateToOutputForm(Expr expr, int n) {
        return this.evalToString(expr, n, "OutputForm");
    }

    public synchronized String evaluateToInputForm(String string, int n) {
        return this.evalToString(string, n, "InputForm");
    }

    public synchronized String evaluateToInputForm(Expr expr, int n) {
        return this.evalToString(expr, n, "InputForm");
    }

    public synchronized byte[] evaluateToTypeset(String string, int n, boolean bl) {
        return this.evalToTypeset(string, n, bl);
    }

    public synchronized byte[] evaluateToTypeset(Expr expr, int n, boolean bl) {
        return this.evalToTypeset(expr, n, bl);
    }

    public synchronized byte[] evaluateToImage(String string, int n, int n2) {
        return this.evalToImage(string, n, n2, 0, false);
    }

    public synchronized byte[] evaluateToImage(Expr expr, int n, int n2) {
        return this.evalToImage(expr, n, n2, 0, false);
    }

    public synchronized byte[] evaluateToImage(String string, int n, int n2, int n3, boolean bl) {
        return this.evalToImage(string, n, n2, n3, bl);
    }

    public synchronized byte[] evaluateToImage(Expr expr, int n, int n2, int n3, boolean bl) {
        return this.evalToImage(expr, n, n2, n3, bl);
    }

    public synchronized String evaluateToMathML(String string) {
        return this.evalToString(string, 0, "MathMLForm");
    }

    public synchronized String evaluateToMathML(Expr expr) {
        return this.evalToString(expr, 0, "MathMLForm");
    }

    public synchronized int waitForAnswer() throws MathLinkException {
        int n;
        this.accumulatingPS = null;
        while (true) {
            boolean bl;
            if (bl = this.notifyPacketListeners(n = this.nextPacket())) {
                this.handlePacket(n);
            }
            if (n == 3 || n == 8 || n == 4 || n == 16) break;
            this.newPacket();
        }
        return n;
    }

    public synchronized void discardAnswer() throws MathLinkException {
        int n = this.waitForAnswer();
        this.newPacket();
        while (n != 3 && n != 8) {
            n = this.waitForAnswer();
            this.newPacket();
        }
    }

    public Throwable getLastError() {
        int n = this.error();
        return n != 0 ? new MathLinkException(n, this.errorMessage()) : this.lastError;
    }

    public synchronized void putReference(Object object) throws MathLinkException {
        this.putReference(object, null);
    }

    public synchronized void putReference(Object object, Class clazz) throws MathLinkException {
        if (object == null) {
            this.putSymbol("Null");
        } else {
            this.objectHandler.putReference(this, object, clazz);
        }
    }

    public synchronized Object getObject() throws MathLinkException {
        try {
            return this.objectHandler.getObject(this.getSymbol());
        }
        catch (Exception exception) {
            throw new MathLinkException(1100);
        }
    }

    /*
     * Loose catch block
     */
    public synchronized void handleCallPacket() {
        block43: {
            int n = 0;
            try {
                n = this.getInteger();
                this.checkFunction("List");
            }
            catch (MathLinkException mathLinkException) {
                this.handleCleanException(mathLinkException);
                return;
            }
            StdLink.setup(this);
            StdLink.lastPktWasAllowUIComputations(false);
            this.clearInterrupt();
            switch (n) {
                case 1: {
                    this.callJava();
                    break;
                }
                case 2: {
                    this.loadClass();
                    break;
                }
                case 3: {
                    this.throwFromMathematica();
                    break;
                }
                case 4: {
                    this.runGC();
                    break;
                }
                case 5: {
                    this.releaseInstance();
                    break;
                }
                case 6: {
                    this.releaseAllInstances();
                    break;
                }
                case 7: {
                    this.unloadClass();
                    break;
                }
                case 8: {
                    this.val();
                    break;
                }
                case 9: {
                    this.callOnLoadClass();
                    break;
                }
                case 10: {
                    this.callOnUnloadClass();
                    break;
                }
                case 11: {
                    this.setComplexCls();
                    break;
                }
                case 12: {
                    this.getComplexCls();
                    break;
                }
                case 13: {
                    this.reflect();
                    break;
                }
                case 14: {
                    this.showInFront();
                    break;
                }
                case 15: {
                    this.sameObjectQ();
                    break;
                }
                case 16: {
                    this.instanceOf();
                    break;
                }
                case 17: {
                    this.allowRaggedArrays();
                    break;
                }
                case 18: {
                    this.connectToFEServer();
                    break;
                }
                case 19: {
                    this.disconnectToFEServer();
                    break;
                }
                case 20: {
                    this.peekClasses();
                    break;
                }
                case 21: {
                    this.peekObjects();
                    break;
                }
                case 24: {
                    this.setSleep();
                    break;
                }
                case 22: {
                    this.getClassPath();
                    break;
                }
                case 23: {
                    this.addToClassPath();
                    break;
                }
                case 26: {
                    this.uiThreadWaiting();
                    break;
                }
                case 25: {
                    this.allowUIComputations();
                    break;
                }
                case 27: {
                    this.forcePolling();
                    break;
                }
                case 28: {
                    this.yieldTime();
                    break;
                }
                case 29: {
                    this.getConsole();
                    break;
                }
                case 30: {
                    this.comQueryInterface();
                    break;
                }
                case 31: {
                    this.comGetObject();
                    break;
                }
            }
            Object var4_4 = null;
            StdLink.remove();
            this.clearError();
            this.newPacket();
            try {
                this.endPacket();
                this.flush();
            }
            catch (MathLinkException mathLinkException) {}
            break block43;
            {
                catch (Exception exception) {
                    Object var4_5 = null;
                    StdLink.remove();
                    this.clearError();
                    this.newPacket();
                    try {
                        this.endPacket();
                        this.flush();
                    }
                    catch (MathLinkException mathLinkException) {}
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                StdLink.remove();
                this.clearError();
                this.newPacket();
                try {
                    this.endPacket();
                    this.flush();
                }
                catch (MathLinkException mathLinkException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public synchronized void enableObjectReferences() throws MathLinkException {
        this.evaluate("Needs[\"JLink`\"]");
        this.discardAnswer();
        this.evaluate("InstallJava[$ParentLink]");
        this.flush();
        Install.install(this);
        this.discardAnswer();
    }

    public void handlePacket(int n) throws MathLinkException {
        switch (n) {
            case 3: {
                break;
            }
            case 8: {
                break;
            }
            case 4: {
                break;
            }
            case 16: {
                break;
            }
            case 6: {
                break;
            }
            case 5: {
                break;
            }
            case 7: {
                this.handleCallPacket();
                break;
            }
            case 11: 
            case 12: {
                if (this.getFEServerLink() == null) break;
                if (this.accumulatingPS == null) {
                    this.accumulatingPS = new StringBuffer(34000);
                }
                this.accumulatingPS.append(this.getString());
                if (n != 12) break;
                MathLink mathLink = this.getFEServerLink();
                mathLink.putFunction("FrontEnd`FrontEndExecute", 1);
                mathLink.putFunction("FrontEnd`NotebookWrite", 2);
                mathLink.putFunction("FrontEnd`SelectedNotebook", 0);
                mathLink.putFunction("Cell", 2);
                mathLink.putFunction("GraphicsData", 2);
                mathLink.put("PostScript");
                mathLink.put(this.accumulatingPS.toString());
                mathLink.put("Graphics");
                mathLink.flush();
                this.accumulatingPS = null;
                break;
            }
            case 2: 
            case 101: {
                MathLink mathLink = this.getFEServerLink();
                if (mathLink != null) {
                    mathLink.putFunction("FrontEnd`FrontEndExecute", 1);
                    mathLink.putFunction("FrontEnd`NotebookWrite", 2);
                    mathLink.putFunction("FrontEnd`SelectedNotebook", 0);
                    mathLink.putFunction("Cell", 2);
                    mathLink.transferExpression(this);
                    mathLink.put(this.lastPktWasMsg ? "Message" : "Print");
                    mathLink.flush();
                    break;
                }
                if (n != 101) break;
                this.getFunction();
                break;
            }
            case 100: {
                MathLink mathLink = this.getFEServerLink();
                if (mathLink != null) {
                    long l = this.createMark();
                    try {
                        MLFunction mLFunction = this.getFunction();
                        if (!mLFunction.name.equals("FrontEnd`FrontEndExecute")) {
                            mathLink.putFunction("FrontEnd`FrontEndExecute", 1);
                        }
                        Object var7_8 = null;
                        this.seekMark(l);
                        this.destroyMark(l);
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        this.seekMark(l);
                        this.destroyMark(l);
                        throw throwable;
                    }
                    mathLink.transferExpression(this);
                    mathLink.flush();
                    do {
                        try {
                            Thread.sleep(60L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (!mathLink.ready() && !this.ready());
                    if (!mathLink.ready()) break;
                    this.transferExpression(mathLink);
                    this.flush();
                    break;
                }
                this.getFunction();
                break;
            }
        }
        this.lastPktWasMsg = n == 5;
    }

    public void interruptEvaluation() {
        try {
            this.putMessage(2);
        }
        catch (MathLinkException mathLinkException) {
            // empty catch block
        }
    }

    public void abortEvaluation() {
        try {
            this.putMessage(3);
        }
        catch (MathLinkException mathLinkException) {
            // empty catch block
        }
    }

    public void terminateKernel() {
        try {
            this.putMessage(1);
        }
        catch (MathLinkException mathLinkException) {
            // empty catch block
        }
    }

    public void abandonEvaluation() {
        this.setYieldFunction(null, this, "bailoutYielder");
    }

    public boolean bailoutYielder() {
        this.setYieldFunction(null, null, null);
        return true;
    }

    public synchronized void print(String string) {
        try {
            this.putFunction("EvaluatePacket", 1);
            this.putFunction("Print", 1);
            this.put(string);
            this.endPacket();
            this.discardAnswer();
        }
        catch (MathLinkException mathLinkException) {
            this.clearError();
            this.newPacket();
        }
    }

    public synchronized void message(String string, String string2) {
        String[] stringArray = new String[]{string2};
        this.message(string, stringArray);
    }

    public synchronized void message(String string, String[] stringArray) {
        try {
            this.putFunction("EvaluatePacket", 1);
            this.putFunction("Apply", 2);
            this.putFunction("ToExpression", 1);
            this.put("Function[Null, Message[#1, ##2], HoldFirst]");
            this.putFunction("Join", 2);
            this.putFunction("ToHeldExpression", 1);
            this.put(string);
            this.putFunction("Hold", stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                this.put(stringArray[n]);
                ++n;
            }
            this.endPacket();
            this.discardAnswer();
        }
        catch (MathLinkException mathLinkException) {
            this.clearError();
            this.newPacket();
        }
    }

    public synchronized void beginManual() {
        this.setManual(true);
    }

    public boolean wasInterrupted() {
        int n = 0;
        Object object = this.msgSync;
        synchronized (object) {
            n = this.msg;
        }
        return n == 2 || n == 3;
    }

    public void clearInterrupt() {
        Object object = this.msgSync;
        synchronized (object) {
            this.msg = 0;
        }
    }

    protected void handleCleanException(Throwable throwable) {
        try {
            this.clearError();
            this.newPacket();
            if (this.wasInterrupted()) {
                this.putFunction("Abort", 0);
            } else {
                String string = Utils.createExceptionMessage(throwable);
                this.putFunction(MMA_HANDLECLEANEXCEPTION, 1);
                this.putFunction(MMA_AUTOEXCEPTION, 1);
                this.put(string);
            }
            this.endPacket();
            this.flush();
        }
        catch (MathLinkException mathLinkException) {
            try {
                this.endPacket();
            }
            catch (MathLinkException mathLinkException2) {
                // empty catch block
            }
        }
    }

    public void msgHandler(int n, int n2) {
        Object object = this.msgSync;
        synchronized (object) {
            this.msg = n;
        }
    }

    private String evalToString(Object object, int n, String string) {
        String string2 = null;
        this.lastError = null;
        try {
            try {
                Utils.writeEvalToStringExpression((MathLink)this, object, n, string);
                this.flush();
                this.waitForAnswer();
                string2 = this.getString();
            }
            catch (MathLinkException mathLinkException) {
                String string3 = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
                if (string3 != null && string3.equals("true")) {
                    System.err.println("Exception in evaluateTo" + string + ": " + mathLinkException.toString());
                }
                this.clearError();
                this.lastError = mathLinkException;
                Object var8_6 = null;
                this.newPacket();
            }
            Object var8_5 = null;
            this.newPacket();
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.newPacket();
            throw throwable;
        }
        return string2;
    }

    private byte[] evalToTypeset(Object object, int n, boolean bl) {
        byte[] byArray = null;
        this.lastError = null;
        try {
            this.putFunction("EvaluatePacket", 1);
            this.putFunction("Needs", 1);
            this.put("JLink`");
            this.flush();
            this.discardAnswerNoPacketListeners();
            Utils.writeEvalToTypesetExpression(this, object, n, bl);
            this.flush();
            this.waitForAnswer();
        }
        catch (MathLinkException mathLinkException) {
            String string = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
            if (string != null && string.equals("true")) {
                System.err.println("Exception in evaluateToTypeset: " + mathLinkException.toString());
            }
            this.clearError();
            this.lastError = mathLinkException;
            this.newPacket();
            return null;
        }
        try {
            block8: {
                try {
                    if (this.getNext() != 34) break block8;
                    byArray = this.getByteString(0);
                }
                catch (Throwable throwable) {
                    String string = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
                    if (string != null && string.equals("true")) {
                        System.err.println("Exception in evaluateToTypeset: " + throwable.toString());
                    }
                    this.clearError();
                    this.lastError = throwable;
                    Object var8_10 = null;
                    this.newPacket();
                }
            }
            Object var8_9 = null;
            this.newPacket();
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            this.newPacket();
            throw throwable;
        }
        return byArray;
    }

    private byte[] evalToImage(Object object, int n, int n2, int n3, boolean bl) {
        byte[] byArray = null;
        this.lastError = null;
        try {
            this.putFunction("EvaluatePacket", 1);
            this.putFunction("Needs", 1);
            this.put("JLink`");
            this.flush();
            this.discardAnswerNoPacketListeners();
            Utils.writeEvalToImageExpression(this, object, n, n2, n3, bl);
            this.flush();
            this.waitForAnswer();
        }
        catch (MathLinkException mathLinkException) {
            String string = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
            if (string != null && string.equals("true")) {
                System.err.println("Exception in evaluateToImage: " + mathLinkException.toString());
            }
            this.clearError();
            this.lastError = mathLinkException;
            this.newPacket();
            return null;
        }
        try {
            block8: {
                try {
                    if (this.getNext() != 34) break block8;
                    byArray = this.getByteString(0);
                }
                catch (Throwable throwable) {
                    String string = System.getProperty("JLINK_SHOW_INTERNAL_EXCEPTIONS");
                    if (string != null && string.equals("true")) {
                        System.err.println("Exception in evaluateToImage: " + throwable.toString());
                    }
                    this.clearError();
                    this.lastError = throwable;
                    Object var10_12 = null;
                    this.newPacket();
                }
            }
            Object var10_11 = null;
            this.newPacket();
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.newPacket();
            throw throwable;
        }
        return byArray;
    }

    MathLink getFEServerLink() {
        return this.feServerLink;
    }

    protected void setManual(boolean bl) {
        if (bl && !this.isManual) {
            try {
                this.putFunction(MMA_PREPAREFORMANUALRETURN, 1);
                this.putSymbol("$CurrentLink");
                this.flush();
            }
            catch (MathLinkException mathLinkException) {
                this.clearError();
            }
        }
        this.isManual = bl;
    }

    boolean isManual() {
        return this.isManual;
    }

    protected void throwFromMathematica() throws Exception {
        Exception exception = null;
        try {
            if (this.getType() == 100000) {
                Object object = this.getObject();
                this.getString();
                this.newPacket();
                exception = (Exception)object;
            } else {
                String string = this.getString();
                String string2 = this.getString();
                this.newPacket();
                Class clazz = JLinkClassLoader.classFromName(string);
                Object[] objectArray = null;
                Constructor constructor = null;
                if (string2.length() == 0) {
                    constructor = clazz.getConstructor(new Class[0]);
                    objectArray = new Object[]{};
                } else {
                    constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = KernelLinkImpl.class$("java.lang.String")) : class$java$lang$String);
                    objectArray = new Object[]{string2};
                }
                exception = (Exception)constructor.newInstance(objectArray);
            }
        }
        catch (Exception exception2) {
            this.handleCleanException(exception2);
            return;
        }
        this.putSymbol("Null");
        throw exception;
    }

    protected void loadClass() throws MathLinkException {
        int n;
        Object object = null;
        try {
            String string = this.getString();
            object = this.getObject();
            this.newPacket();
            n = this.objectHandler.loadClass(string, object);
        }
        catch (Throwable throwable) {
            this.handleCleanException(throwable);
            return;
        }
        this.objectHandler.putInfo(this, n, object);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    protected void callJava() throws MathLinkException {
        var4_1 = null;
        var5_2 = null;
        var6_3 = null;
        try {
            this.checkFunction("List");
            var2_4 = this.getInteger();
            var1_5 = this.getInteger();
            var4_1 = this.getObject();
            var5_2 = this.getIntArray1();
            var3_6 = this.getInteger() != 0;
            var7_7 = this.getInteger();
            var6_3 = new Object[var7_7];
            var8_11 = false;
            while (var8_11 < var7_7) {
                var6_3[var8_11] = this.getTypeObjectPair();
                var8_11 += 1;
            }
            this.newPacket();
        }
        catch (Exception var7_8) {
            this.handleCleanException(var7_8);
            return;
        }
        try {
            switch (var1_5) {
                case 1: {
                    var7_9 = null;
                    try {
                        var7_9 = this.objectHandler.callCtor(var2_4, var5_2, var6_3);
                    }
                    catch (NoSuchMethodException var8_12) {
                        this.putFunction("EvaluatePacket", 1);
                        this.putFunction("JLink`Package`issueNoDefaultCtorMessage", 1);
                        this.put(this.objectHandler.getComponentTypeName(var2_4));
                        this.endPacket();
                        this.discardAnswer();
                        this.handleCleanException(var8_12);
                        break;
                    }
                    catch (Exception var9_18) {
                        this.handleCleanException(var9_18);
                        break;
                    }
                    if (this.wasInterrupted()) {
                        this.putFunction("Abort", 0);
                        break;
                    }
                    this.putReference(var7_9);
                    break;
                }
                case 2: {
                    var7_7 = this.isManual();
                    this.setManual(false);
                    try {
                        try {
                            var8_13 = this.objectHandler.callMethod(var2_4, var4_1, var5_2, var6_3);
                            if (!this.isManual()) ** GOTO lbl56
                            this.putSymbol("Null");
                            ** GOTO lbl64
lbl56:
                            // 1 sources

                            if (!this.wasInterrupted()) ** GOTO lbl59
                            this.putFunction("Abort", 0);
                            ** GOTO lbl64
lbl59:
                            // 1 sources

                            if (!var3_6) ** GOTO lbl62
                            this.put(var8_13);
                            ** GOTO lbl64
lbl62:
                            // 1 sources

                            this.putReference(var8_13);
                        }
                        catch (InvocationTargetException var8_14) {
                            var9_19 = var8_14.getTargetException();
                            if (this.isManual()) {
                                this.clearError();
                                var9_19.printStackTrace();
                                var10_25 = Utils.createExceptionMessage(var9_19);
                                this.endPacket();
                                this.flush();
                                this.putFunction("JLink`Package`manualException", 1);
                                this.put(var10_25);
                            } else {
                                this.handleCleanException(var9_19);
                                if (var9_19 instanceof Error) {
                                    throw (Error)var9_19;
                                }
                            }
                            var12_22 = null;
                            this.setManual(var7_7);
                            break;
                        }
                        catch (Exception var9_20) {
                            this.handleCleanException(var9_20);
                            var12_23 = null;
                            this.setManual(var7_7);
                            break;
                        }
lbl64:
                        // 4 sources

                        var12_21 = null;
                        this.setManual(var7_7);
                        break;
                    }
                    catch (Throwable var11_26) {
                        var12_24 = null;
                        this.setManual(var7_7);
                        throw var11_26;
                    }
                }
                case 3: {
                    var7_7 = var5_2[var5_2.length - 1];
                    try {
                        if (var6_3.length == 0) {
                            var8_15 = this.objectHandler.getField(var2_4, var4_1, (int)var7_7);
                            if (var3_6) {
                                this.put(var8_15);
                                break;
                            }
                            this.putReference(var8_15);
                            break;
                        }
                        this.objectHandler.setField(var2_4, var4_1, (int)var7_7, var6_3[0]);
                        this.putSymbol("Null");
                        break;
                    }
                    catch (Exception var8_16) {
                        this.handleCleanException(var8_16);
                    }
                }
            }
        }
        catch (MathLinkException var7_10) {
            System.err.println("Serious error: MathLinkException trying to report results of previous exception.");
            this.clearError();
            try {
                this.endPacket();
            }
            catch (MathLinkException var8_17) {
                // empty catch block
            }
        }
    }

    protected void runGC() throws MathLinkException {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.freeMemory();
        runtime.gc();
        this.put((int)(runtime.freeMemory() - l));
    }

    protected void releaseInstance() throws MathLinkException {
        try {
            String[] stringArray = this.getStringArray1();
            this.newPacket();
            this.objectHandler.releaseInstance(stringArray);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    protected void releaseAllInstances() throws MathLinkException {
        int n = 0;
        try {
            n = this.getInteger();
            this.newPacket();
            this.objectHandler.releaseAllInstances(n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(n);
    }

    protected void unloadClass() throws MathLinkException {
        int n = 0;
        try {
            n = this.getInteger();
            this.newPacket();
            this.objectHandler.unloadClass(n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(n);
    }

    protected void val() throws MathLinkException {
        Object object = null;
        try {
            object = this.getObject();
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(object);
    }

    protected void sameObjectQ() throws MathLinkException {
        Object object = null;
        Object object2 = null;
        try {
            object = this.getObject();
            object2 = this.getObject();
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(object == object2);
    }

    protected void instanceOf() throws MathLinkException {
        boolean bl;
        try {
            Object object = this.getObject();
            String string = this.getString();
            this.newPacket();
            Class<?> clazz = Utils.isJava2OrLater() ? Class.forName(string, true, object.getClass().getClassLoader()) : JLinkClassLoader.classFromName(string);
            bl = clazz.isInstance(object);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.put(bl);
    }

    protected void allowRaggedArrays() throws MathLinkException {
        boolean bl = false;
        try {
            bl = this.getBoolean();
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        Utils.setRaggedArrays(bl);
        this.putSymbol("Null");
    }

    protected void setComplexCls() throws MathLinkException {
        String string;
        try {
            int n = this.getInteger();
            this.newPacket();
            Class clazz = this.objectHandler.classFromIndex(n);
            string = this.setComplexClass(clazz) ? "Null" : "$Failed";
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol(string);
    }

    protected void getComplexCls() throws MathLinkException {
        String string = null;
        try {
            this.newPacket();
            Class clazz = this.getComplexClass();
            if (clazz != null) {
                string = clazz.getName();
            }
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        if (string != null) {
            this.put(string);
        } else {
            this.putSymbol("Null");
        }
    }

    protected void callOnLoadClass() throws MathLinkException {
        try {
            int n = this.getInteger();
            this.newPacket();
            this.objectHandler.callOnLoadClass(this, n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putFunction("ReturnPacket", 1);
        this.putSymbol("Null");
        this.endPacket();
    }

    protected void callOnUnloadClass() throws MathLinkException {
        try {
            int n = this.getInteger();
            this.newPacket();
            this.objectHandler.callOnUnloadClass(this, n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putFunction("ReturnPacket", 1);
        this.putSymbol("Null");
        this.endPacket();
    }

    protected void reflect() throws MathLinkException {
        int n;
        int n2;
        boolean bl = true;
        int n3 = 0;
        try {
            n2 = this.getInteger();
            n = this.getInteger();
            bl = this.getSymbol().equals("True");
            this.newPacket();
            n3 = this.objectHandler.reflect(this, n2, n, bl, false);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putFunction("List", n3);
        this.objectHandler.reflect(this, n2, n, bl, true);
    }

    protected void showInFront() throws MathLinkException {
        try {
            Object object = this.getObject();
            this.newPacket();
            if (object instanceof Dialog) {
                Dialog dialog = (Dialog)object;
                dialog.show();
                if (!dialog.isModal()) {
                    dialog.toFront();
                }
            } else {
                Window window = (Window)object;
                ((Component)window).setVisible(true);
                if (Utils.isJava2OrLater() && window instanceof Frame) {
                    ((Frame)window).setState(0);
                }
                window.toFront();
            }
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    protected void connectToFEServer() throws MathLinkException {
        boolean bl;
        block6: {
            bl = false;
            try {
                String string = this.getString();
                this.newPacket();
                String string2 = "-linkmode connect -linkname " + string;
                this.feServerLink = MathLinkFactory.createMathLink(string2);
                if (this.feServerLink == null) break block6;
                try {
                    this.feServerLink.connect();
                    this.feServerLink.putFunction("InputNamePacket", 1);
                    this.feServerLink.put("In[1]:=");
                    this.feServerLink.flush();
                    while (true) {
                        MLFunction mLFunction = this.feServerLink.getFunction();
                        this.feServerLink.newPacket();
                        if (mLFunction.name.equals("EnterTextPacket") || mLFunction.name.equals("EnterExpressionPacket")) {
                            bl = true;
                            break;
                        }
                        if (!mLFunction.name.equals("EvaluatePacket")) continue;
                        this.feServerLink.putFunction("ReturnPacket", 1);
                        this.feServerLink.putSymbol("Null");
                    }
                }
                catch (MathLinkException mathLinkException) {
                    this.feServerLink.close();
                    this.feServerLink = null;
                }
            }
            catch (Exception exception) {
                this.handleCleanException(exception);
                return;
            }
        }
        this.putFunction("ReturnPacket", 1);
        this.put(bl);
        this.endPacket();
    }

    protected void disconnectToFEServer() throws MathLinkException {
        this.feServerLink.close();
        this.feServerLink = null;
        this.putFunction("ReturnPacket", 1);
        this.putSymbol("Null");
        this.endPacket();
    }

    protected void peekClasses() throws MathLinkException {
        this.objectHandler.peekClasses(this);
    }

    protected void peekObjects() throws MathLinkException {
        this.objectHandler.peekObjects(this);
    }

    protected void comGetObject() throws MathLinkException {
        String string = null;
        boolean bl = false;
        try {
            string = this.getString();
            bl = this.getSymbol().equals("True");
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        if (Utils.isMicrosoftVM()) {
            Object object = null;
            try {
                object = bl ? COMUtilities.getActiveObject(string) : COMUtilities.createObject(string);
            }
            catch (Exception exception) {
                this.handleCleanException(exception);
                return;
            }
            if (object != null) {
                this.putReference(object);
            } else {
                this.putSymbol("$Failed");
            }
        } else {
            this.putSymbol("$Failed");
        }
    }

    protected void comQueryInterface() throws MathLinkException {
        Object object = null;
        String string = null;
        try {
            object = this.getObject();
            string = this.getString();
            this.newPacket();
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        if (Utils.isMicrosoftVM()) {
            Object var3_4 = null;
            if (var3_4 != null) {
                this.putReference(var3_4);
            } else {
                this.putSymbol("$Failed");
            }
        } else {
            this.putSymbol("$Failed");
        }
    }

    protected void setSleep() throws MathLinkException {
        try {
            int n = this.getInteger();
            this.newPacket();
            Reader.setSleepInterval(n);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    protected void getClassPath() throws MathLinkException {
        this.put(JLinkClassLoader.getClassPath());
    }

    protected void addToClassPath() throws MathLinkException {
        try {
            String[] stringArray = (String[])this.getArray(-9, 1);
            boolean bl = this.getBoolean();
            this.newPacket();
            JLinkClassLoader.addLocations(stringArray, bl);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    protected void uiThreadWaiting() throws MathLinkException {
        this.newPacket();
        this.putSymbol(StdLink.uiThreadWaiting() ? "True" : "False");
    }

    protected void allowUIComputations() throws MathLinkException {
        try {
            boolean bl = this.getSymbol().equals("True");
            boolean bl2 = this.getSymbol().equals("True");
            this.newPacket();
            StdLink.allowUIComputations(bl, bl2);
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    protected void forcePolling() throws MathLinkException {
        try {
            boolean bl = this.getSymbol().equals("True");
            boolean bl2 = this.getSymbol().equals("True");
            this.newPacket();
            StdLink.forcePolling(bl);
            if (bl2) {
                this.setYieldFunction(null, this, "greenThreadsYielder");
            }
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    protected void yieldTime() throws MathLinkException {
        try {
            int n = this.getInteger();
            this.newPacket();
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (Exception exception) {
            this.handleCleanException(exception);
            return;
        }
        this.putSymbol("Null");
    }

    protected void getConsole() throws MathLinkException {
        this.putReference(ConsoleWindow.getInstance());
    }

    private void discardAnswerNoPacketListeners() throws MathLinkException {
        Vector vector = this.packetListeners;
        this.packetListeners = null;
        this.discardAnswer();
        this.packetListeners = vector;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Object getArray(int var1_1, int var2_2, String[] var3_3) throws MathLinkException {
        block13: {
            block11: {
                var4_4 = null;
                if (var1_1 != -14) break block11;
                var6_5 = null;
                var7_6 = this.createMark();
                try {
                    block12: {
                        var9_7 = this.getFunction();
                        var5_8 = 1;
                        if (var9_7.argCount != 0) ** GOTO lbl15
                        var6_5 = new Object();
                        break block12;
                        while ((var10_9 = this.getNext()) == 70) {
                            this.getFunction();
                            ++var5_8;
lbl15:
                            // 2 sources

                            if (var5_8 < 5) continue;
                        }
                        var6_5 = this.getObject();
                    }
                    var12_12 = null;
                    this.seekMark(var7_6);
                    this.destroyMark(var7_6);
                }
                catch (Throwable var11_14) {
                    var12_13 = null;
                    this.seekMark(var7_6);
                    this.destroyMark(var7_6);
                    throw var11_14;
                }
                var9_7 = var6_5.getClass();
                if (var5_8 < var2_2) {
                    throw new MathLinkException(1002);
                }
                if (var2_2 == 1) {
                    var10_10 = this.getFunction();
                    var4_4 = Array.newInstance(var9_7, var10_10.argCount);
                    var11_15 = 0;
                    while (var11_15 < var10_10.argCount) {
                        Array.set(var4_4, var11_15, this.getObject());
                        ++var11_15;
                    }
                    if (var3_3 != null) {
                        var3_3[0] = var10_10.name;
                    }
                } else {
                    var10_11 = "L" + var9_7.getName() + ";";
                    var11_16 = 1;
                    while (var11_16 < var5_8) {
                        var10_11 = "[" + var10_11;
                        ++var11_16;
                    }
                    var12_12 = null;
                    try {
                        var12_12 = Utils.isJava2OrLater() != false ? Class.forName(var10_11, true, var9_7.getClassLoader()) : (var9_7.getClassLoader() != null ? var9_7.getClassLoader().loadClass(var10_11) : Class.forName(var10_11));
                    }
                    catch (ClassNotFoundException var13_17) {
                        // empty catch block
                    }
                    var4_4 = this.getArraySlices(var1_1, var2_2, var3_3, 0, var12_12);
                }
                break block13;
            }
            var4_4 = super.getArray(var1_1, var2_2, var3_3);
        }
        return var4_4;
    }

    public synchronized Object getArray(int n, int n2) throws MathLinkException {
        return this.getArray(n, n2, null);
    }

    private Object getTypeObjectPair() throws MathLinkException, NumberRangeException {
        Object object = null;
        int n = this.getInteger();
        if (n % -17 == -15) {
            n = -7 + -17 * (n / -17);
        } else if (n % -17 == -16) {
            n = -8 + -17 * (n / -17);
        }
        switch (n) {
            case -5: {
                object = new Integer(this.getInteger());
                break;
            }
            case -6: {
                object = new Long(this.getLongInteger());
                break;
            }
            case -4: {
                int n2 = this.getInteger();
                if (n2 < Short.MIN_VALUE || n2 > Short.MAX_VALUE) {
                    throw new NumberRangeException(n2, "short");
                }
                object = new Short((short)n2);
                break;
            }
            case -2: {
                int n3 = this.getInteger();
                if (n3 < -128 || n3 > 127) {
                    throw new NumberRangeException(n3, "byte");
                }
                object = new Byte((byte)n3);
                break;
            }
            case -3: {
                int n4 = this.getInteger();
                if (n4 < 0 || n4 > 65535) {
                    throw new NumberRangeException(n4, "char");
                }
                object = new Character((char)n4);
                break;
            }
            case -15: 
            case -7: {
                double d = this.getDouble();
                if (d < -3.4028234663852886E38 || d > 3.4028234663852886E38) {
                    throw new NumberRangeException(d, "float");
                }
                object = new Float((float)d);
                break;
            }
            case -16: 
            case -8: {
                object = new Double(this.getDouble());
                break;
            }
            case -9: {
                int n5 = this.getType();
                if (n5 == 100000) {
                    object = this.getObject();
                    break;
                }
                object = this.getString();
                break;
            }
            case -1: {
                String string = this.getSymbol();
                if (string.equals("True")) {
                    object = new Boolean(true);
                    break;
                }
                object = new Boolean(false);
                break;
            }
            case -13: {
                long l = this.createMark();
                try {
                    int n6 = this.getNext();
                    if (n6 == 100000) {
                        object = this.getObject();
                    } else {
                        this.seekMark(l);
                        object = this.getComplex();
                    }
                    Object var8_16 = null;
                    this.destroyMark(l);
                    break;
                }
                catch (Throwable throwable) {
                    Object var8_17 = null;
                    this.destroyMark(l);
                    throw throwable;
                }
            }
            case -10: {
                int n7 = this.getType();
                if (n7 == 100000) {
                    object = this.getObject();
                    break;
                }
                object = new BigInteger(this.getString());
                break;
            }
            case -11: {
                int n8 = this.getType();
                if (n8 == 100000) {
                    object = this.getObject();
                    break;
                }
                object = Utils.bigDecimalFromString(this.getString());
                break;
            }
            case -12: {
                long l = this.createMark();
                try {
                    int n9 = this.getNext();
                    if (n9 == 100000 && (object = this.getObject()) != null) {
                        Object var10_19 = null;
                        this.destroyMark(l);
                        break;
                    }
                    this.seekMark(l);
                    object = this.getExpr();
                }
                catch (Throwable throwable) {
                    Object var10_21 = null;
                    this.destroyMark(l);
                    throw throwable;
                }
                Object var10_20 = null;
                this.destroyMark(l);
                break;
            }
            case -14: {
                object = this.getObject();
                break;
            }
            case -10000: {
                break;
            }
            default: {
                int n10 = this.getNext();
                object = n10 == 100000 || n10 == 35 ? this.getObject() : (n > -34 ? this.getArray(n - -17, 1) : (n > -51 ? this.getArray(n - -34, 2) : (n > -68 ? this.getArray(n - -51, 3) : (n > -85 ? this.getArray(n - -68, 4) : this.getArray(n - -85, 5)))));
            }
        }
        return object;
    }

    protected boolean isObject() {
        long l = 0L;
        try {
            try {
                l = this.createMark();
                boolean bl = this.getObject() != null;
                Object var6_4 = null;
                if (l != 0L) {
                    this.seekMark(l);
                    this.destroyMark(l);
                }
                return bl;
            }
            catch (MathLinkException mathLinkException) {
                this.clearError();
                boolean bl = false;
                Object var6_5 = null;
                if (l != 0L) {
                    this.seekMark(l);
                    this.destroyMark(l);
                }
                return bl;
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                if (l == 0L) break block6;
                this.seekMark(l);
                this.destroyMark(l);
            }
            throw throwable;
        }
    }

    private boolean greenThreadsYielder() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

