/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkOffscreenImage;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.StdLink;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.io.Serializable;

public class MathGraphicsDelegate
implements Serializable {
    private transient KernelLink ml;
    private Component comp;
    private boolean useFE;
    private boolean useTradForm;
    private int imageType = 0;
    private String mathCommand;
    private Image im;
    private MediaTracker tracker;
    public static final int GRAPHICS = 0;
    public static final int TYPESET = 1;

    public MathGraphicsDelegate(Component component) {
        this(component, StdLink.getLink());
    }

    public MathGraphicsDelegate(Component component, KernelLink kernelLink) {
        this.comp = component;
        this.ml = kernelLink;
        this.tracker = new MediaTracker(component);
    }

    public void setLink(KernelLink kernelLink) {
        this.ml = kernelLink;
    }

    public void setImageType(int n) {
        this.imageType = n;
    }

    public int getImageType() {
        return this.imageType;
    }

    public void setUsesFE(boolean bl) {
        this.useFE = bl;
    }

    public boolean getUsesFE() {
        return this.useFE;
    }

    public void setUsesTraditionalForm(boolean bl) {
        this.useTradForm = bl;
    }

    public boolean getUsesTraditionalForm() {
        return this.useTradForm;
    }

    public String getMathCommand() {
        return this.mathCommand;
    }

    public void setMathCommand(String string) {
        this.mathCommand = string;
        byte[] byArray = null;
        if (this.ml != null) {
            if (this.ml.equals(StdLink.getLink())) {
                StdLink.requestTransaction();
            }
            byArray = this.imageType == 0 ? this.ml.evaluateToImage(this.mathCommand, this.comp.getSize().width - 4, this.comp.getSize().height - 4, 0, this.useFE) : this.ml.evaluateToTypeset(this.mathCommand, this.comp.getSize().width, !this.useTradForm);
        }
        this.im = byArray != null ? this.comp.getToolkit().createImage(byArray) : null;
        this.comp.repaint();
    }

    public void setImage(Image image) {
        this.im = image != null && image.getClass().getName().equals("com.wolfram.jlink.JLinkOffscreenImage") ? ((JLinkOffscreenImage)image).getWrappedImage() : image;
        this.mathCommand = null;
        this.comp.repaint();
    }

    public Image getImage() {
        return this.im;
    }

    public void recompute() {
        if (this.mathCommand != null) {
            this.setMathCommand(this.mathCommand);
        }
    }

    public void ensureImageReady() {
        if (this.im != null && this.im.getWidth(null) == -1) {
            this.tracker.addImage(this.im, 0);
            try {
                this.tracker.waitForID(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.tracker.removeImage(this.im, 0);
        }
    }

    public void paintImage(Graphics graphics) {
        int n = this.im.getHeight(this.comp);
        int n2 = this.im.getWidth(this.comp);
        if (n2 != -1 && n != -1) {
            Dimension dimension = this.comp.getSize();
            int n3 = dimension.width;
            int n4 = dimension.height;
            Insets insets = this.comp instanceof Container ? ((Container)this.comp).getInsets() : new Insets(0, 0, 0, 0);
            int n5 = n3 - insets.left - insets.right;
            int n6 = n4 - insets.top - insets.bottom;
            int n7 = (n3 - n2) / 2;
            int n8 = (n4 - n) / 2;
            graphics.drawImage(this.im, n7, n8, this.comp);
            graphics.clearRect(insets.left, insets.top, n5, n8 - insets.top);
            graphics.clearRect(insets.left, n8, n7 - insets.left, n);
            graphics.clearRect(n7 + n2, n8, n3 - n2 - n7 - insets.right, n);
            graphics.clearRect(insets.left, n8 + n, n5, n4 - n - n8 - insets.bottom);
        }
    }
}

