/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkOffscreenImage;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathGraphicsDelegate;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import java.awt.Graphics;
import java.awt.Image;
import java.io.Serializable;
import javax.swing.JPanel;

public class MathGraphicsJPanel
extends JPanel
implements Serializable {
    private MathGraphicsDelegate delegate;
    public static final int GRAPHICS = 0;
    public static final int TYPESET = 1;

    public MathGraphicsJPanel() {
        this.delegate = new MathGraphicsDelegate(this);
    }

    public MathGraphicsJPanel(KernelLink kernelLink) {
        this.delegate = new MathGraphicsDelegate(this, kernelLink);
    }

    public void setLink(KernelLink kernelLink) {
        this.delegate.setLink(kernelLink);
    }

    public void setImageType(int n) {
        this.delegate.setImageType(n);
    }

    public int getImageType() {
        return this.delegate.getImageType();
    }

    public void setUsesFE(boolean bl) {
        this.delegate.setUsesFE(bl);
    }

    public boolean getUsesFE() {
        return this.delegate.getUsesFE();
    }

    public void setUsesTraditionalForm(boolean bl) {
        this.delegate.setUsesTraditionalForm(bl);
    }

    public boolean getUsesTraditionalForm() {
        return this.delegate.getUsesTraditionalForm();
    }

    public void setMathCommand(String string) {
        this.delegate.setMathCommand(string);
    }

    public String getMathCommand() {
        return this.delegate.getMathCommand();
    }

    public void setImage(Image image) {
        this.delegate.setImage(image);
    }

    public Image getImage() {
        return this.delegate.getImage();
    }

    public void recompute() {
        this.delegate.recompute();
    }

    public void repaintNow() {
        this.delegate.ensureImageReady();
        this.paintImmediately(this.getBounds(null));
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.delegate.getImage() != null) {
            this.delegate.paintImage(graphics);
        }
    }

    public Image createImage(int n, int n2) {
        Image image = super.createImage(n, n2);
        if (!Utils.isJava2OrLater() && !Utils.isMicrosoftVM() && StdLink.getLink() != null) {
            return new JLinkOffscreenImage(image);
        }
        return image;
    }
}

