/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkClassLoader;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.LoopbackLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.NativeLink;
import com.wolfram.jlink.NativeLoopbackLink;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.WrappedKernelLink;
import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.StringTokenizer;

public class MathLinkFactory {
    static /* synthetic */ Class class$java$lang$String;

    public static KernelLink createKernelLink(String string) throws MathLinkException {
        return MathLinkFactory.createKernelLink0(string, null);
    }

    public static KernelLink createKernelLink(String[] stringArray) throws MathLinkException {
        return MathLinkFactory.createKernelLink0(null, stringArray);
    }

    public static KernelLink createKernelLink(MathLink mathLink) throws MathLinkException {
        return new WrappedKernelLink(mathLink);
    }

    private static KernelLink createKernelLink0(String string, String[] stringArray) throws MathLinkException {
        String string2;
        if (string == null && stringArray == null) {
            throw new MathLinkException(1004, "Null argument to KernelLink constructor");
        }
        boolean bl = string != null;
        String string3 = string2 = bl ? MathLinkFactory.determineProtocol(string) : MathLinkFactory.determineProtocol(stringArray);
        if (!string2.equals("native")) {
            Serializable serializable;
            String string4 = null;
            try {
                string4 = System.getProperty("KernelLink." + string2);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string4 == null) {
                serializable = MathLinkFactory.loadProperties();
                string4 = ((Properties)serializable).getProperty("KernelLink." + string2);
            }
            if (string4 != null) {
                serializable = null;
                try {
                    serializable = JLinkClassLoader.load(string4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (serializable != null) {
                    try {
                        Object[] objectArray;
                        Class clazz = bl ? (class$java$lang$String == null ? (class$java$lang$String = MathLinkFactory.class$("java.lang.String")) : class$java$lang$String) : Class.forName("[Ljava.lang.String;");
                        Class clazz2 = clazz;
                        Constructor constructor = ((Class)serializable).getConstructor(clazz2);
                        if (bl) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = string;
                        } else {
                            Object[] objectArray3 = new Object[1];
                            objectArray = objectArray3;
                            objectArray3[0] = stringArray;
                        }
                        return (KernelLink)constructor.newInstance(objectArray);
                    }
                    catch (Exception exception) {
                        if (exception instanceof InvocationTargetException) {
                            throw new MathLinkException(((InvocationTargetException)exception).getTargetException(), "Error instantiating link object of class " + ((Class)serializable).getName());
                        }
                        throw new MathLinkException(exception, "Error instantiating link object of class " + ((Class)serializable).getName());
                    }
                }
            }
        }
        return new WrappedKernelLink(bl ? MathLinkFactory.createMathLink(string) : MathLinkFactory.createMathLink(stringArray));
    }

    public static MathLink createMathLink(String string) throws MathLinkException {
        return MathLinkFactory.createMathLink0(string, null);
    }

    public static MathLink createMathLink(String[] stringArray) throws MathLinkException {
        return MathLinkFactory.createMathLink0(null, stringArray);
    }

    private static MathLink createMathLink0(String string, String[] stringArray) throws MathLinkException {
        String string2;
        if (string == null && stringArray == null) {
            throw new MathLinkException(1004, "Null argument to MathLink constructor");
        }
        boolean bl = string != null;
        String string3 = string2 = bl ? MathLinkFactory.determineProtocol(string) : MathLinkFactory.determineProtocol(stringArray);
        if (!string2.equals("native")) {
            Serializable serializable;
            String string4 = null;
            try {
                string4 = System.getProperty("MathLink." + string2);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (string4 == null) {
                serializable = MathLinkFactory.loadProperties();
                string4 = ((Properties)serializable).getProperty("MathLink." + string2);
            }
            if (string4 != null) {
                serializable = null;
                try {
                    serializable = JLinkClassLoader.load(string4);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (serializable != null) {
                    try {
                        Object[] objectArray;
                        Class clazz = bl ? (class$java$lang$String == null ? (class$java$lang$String = MathLinkFactory.class$("java.lang.String")) : class$java$lang$String) : Class.forName("[Ljava.lang.String;");
                        Class clazz2 = clazz;
                        Constructor constructor = ((Class)serializable).getConstructor(clazz2);
                        if (bl) {
                            Object[] objectArray2 = new Object[1];
                            objectArray = objectArray2;
                            objectArray2[0] = string;
                        } else {
                            Object[] objectArray3 = new Object[1];
                            objectArray = objectArray3;
                            objectArray3[0] = stringArray;
                        }
                        return (MathLink)constructor.newInstance(objectArray);
                    }
                    catch (Exception exception) {
                        if (exception instanceof InvocationTargetException) {
                            throw new MathLinkException(((InvocationTargetException)exception).getTargetException(), "Error instantiating link object of class " + ((Class)serializable).getName());
                        }
                        throw new MathLinkException(exception, "Error instantiating link object of class " + ((Class)serializable).getName());
                    }
                }
                System.err.println("J/Link Warning: could not find any Java class that implements the requested " + string2 + " protocol. This protocol name will be passed to the MathLink library to " + "see if it has a native implementation.");
            }
        }
        return bl ? new NativeLink(string) : new NativeLink(stringArray);
    }

    public static LoopbackLink createLoopbackLink() throws MathLinkException {
        return new NativeLoopbackLink();
    }

    private static String determineProtocol(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string2 = "native";
        while (stringTokenizer != null && stringTokenizer.hasMoreTokens()) {
            if (!stringTokenizer.nextToken().toLowerCase().equals("-linkprotocol") || !stringTokenizer.hasMoreTokens()) continue;
            string2 = stringTokenizer.nextToken().toLowerCase();
            break;
        }
        return MathLinkFactory.isNative(string2) ? "native" : string2;
    }

    private static String determineProtocol(String[] stringArray) {
        String string = "native";
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length - 1) {
                if (stringArray[n].toLowerCase().equals("-linkprotocol")) {
                    string = stringArray[n + 1].toLowerCase();
                    break;
                }
                ++n;
            }
        }
        return MathLinkFactory.isNative(string) ? "native" : string;
    }

    private static boolean isNative(String string) {
        return string.equals("native") || string.equals("local") || string.equals("filemap") || string.equals("fm") || string.equals("ppc") || string.equals("tcp") || string.equals("pipes") || string.equals("sharedmemory") || string.equals("");
    }

    private static Properties loadProperties() {
        Properties properties = new Properties();
        try {
            String string = Utils.getJLinkJarDir();
            if (string != null) {
                FileInputStream fileInputStream = new FileInputStream(string + "JLink.properties");
                properties.load(fileInputStream);
                fileInputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

