/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.Expr;
import com.wolfram.jlink.JLinkClassLoader;
import com.wolfram.jlink.LoopbackLink;
import com.wolfram.jlink.MLFunction;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.Utils;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class MathLinkImplBase
implements MathLink {
    static final int DEBUGLEVEL = 0;
    private String[] headHolder = new String[1];
    static /* synthetic */ Class class$java$lang$String;

    public synchronized void activate() throws MathLinkException {
        this.connect();
    }

    public synchronized boolean getBoolean() throws MathLinkException {
        return this.getSymbol().equals("True");
    }

    public synchronized void putData(byte[] byArray) throws MathLinkException {
        this.putData(byArray, byArray.length);
    }

    public synchronized boolean[] getBooleanArray1() throws MathLinkException {
        return (boolean[])this.getArray(-1, 1);
    }

    public synchronized boolean[][] getBooleanArray2() throws MathLinkException {
        return (boolean[][])this.getArray(-1, 2);
    }

    public synchronized byte[] getByteArray1() throws MathLinkException {
        return (byte[])this.getArray(-2, 1);
    }

    public synchronized byte[][] getByteArray2() throws MathLinkException {
        return (byte[][])this.getArray(-2, 2);
    }

    public synchronized char[] getCharArray1() throws MathLinkException {
        return (char[])this.getArray(-3, 1);
    }

    public synchronized char[][] getCharArray2() throws MathLinkException {
        return (char[][])this.getArray(-3, 2);
    }

    public synchronized short[] getShortArray1() throws MathLinkException {
        return (short[])this.getArray(-4, 1);
    }

    public synchronized short[][] getShortArray2() throws MathLinkException {
        return (short[][])this.getArray(-4, 2);
    }

    public synchronized int[] getIntArray1() throws MathLinkException {
        return (int[])this.getArray(-5, 1);
    }

    public synchronized int[][] getIntArray2() throws MathLinkException {
        return (int[][])this.getArray(-5, 2);
    }

    public synchronized long[] getLongArray1() throws MathLinkException {
        return (long[])this.getArray(-6, 1);
    }

    public synchronized long[][] getLongArray2() throws MathLinkException {
        return (long[][])this.getArray(-6, 2);
    }

    public synchronized float[] getFloatArray1() throws MathLinkException {
        return (float[])this.getArray(-7, 1);
    }

    public synchronized float[][] getFloatArray2() throws MathLinkException {
        return (float[][])this.getArray(-7, 2);
    }

    public synchronized double[] getDoubleArray1() throws MathLinkException {
        return (double[])this.getArray(-8, 1);
    }

    public synchronized double[][] getDoubleArray2() throws MathLinkException {
        return (double[][])this.getArray(-8, 2);
    }

    public synchronized String[] getStringArray1() throws MathLinkException {
        return (String[])this.getArray(-9, 1);
    }

    public synchronized String[][] getStringArray2() throws MathLinkException {
        return (String[][])this.getArray(-9, 2);
    }

    public synchronized Object[] getComplexArray1() throws MathLinkException {
        return (Object[])this.getArray(-13, 1);
    }

    public synchronized Object[][] getComplexArray2() throws MathLinkException {
        return (Object[][])this.getArray(-13, 2);
    }

    public synchronized Expr getExpr() throws MathLinkException {
        return Expr.createFromLink(this);
    }

    public synchronized Expr peekExpr() throws MathLinkException {
        long l = this.createMark();
        try {
            Expr expr = Expr.createFromLink(this);
            Object var5_3 = null;
            this.seekMark(l);
            this.destroyMark(l);
            return expr;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.seekMark(l);
            this.destroyMark(l);
            throw throwable;
        }
    }

    public synchronized Object getArray(int n, int n2, String[] stringArray) throws MathLinkException {
        Object object = null;
        if (n2 == 1) {
            MLFunction mLFunction = this.getFunction();
            switch (n) {
                case -1: {
                    object = Array.newInstance(Boolean.TYPE, mLFunction.argCount);
                    int n3 = 0;
                    while (n3 < mLFunction.argCount) {
                        Array.setBoolean(object, n3, this.getBoolean());
                        ++n3;
                    }
                    break;
                }
                case -9: {
                    object = Array.newInstance(class$java$lang$String == null ? (class$java$lang$String = MathLinkImplBase.class$("java.lang.String")) : class$java$lang$String, mLFunction.argCount);
                    int n4 = 0;
                    while (n4 < mLFunction.argCount) {
                        Array.set(object, n4, this.getString());
                        ++n4;
                    }
                    break;
                }
                case -6: {
                    object = Array.newInstance(Long.TYPE, mLFunction.argCount);
                    int n5 = 0;
                    while (n5 < mLFunction.argCount) {
                        Array.setLong(object, n5, this.getLongInteger());
                        ++n5;
                    }
                    break;
                }
                case -13: {
                    object = Array.newInstance(this.getComplexClass(), mLFunction.argCount);
                    int n6 = 0;
                    while (n6 < mLFunction.argCount) {
                        Array.set(object, n6, this.getComplex());
                        ++n6;
                    }
                    break;
                }
                case -12: {
                    object = new Expr[mLFunction.argCount];
                    int n7 = 0;
                    while (n7 < mLFunction.argCount) {
                        Array.set(object, n7, this.getExpr());
                        ++n7;
                    }
                    break;
                }
                case -10: {
                    object = new BigInteger[mLFunction.argCount];
                    int n8 = 0;
                    while (n8 < mLFunction.argCount) {
                        Array.set(object, n8, new BigInteger(this.getString()));
                        ++n8;
                    }
                    break;
                }
                case -11: {
                    object = new BigDecimal[mLFunction.argCount];
                    int n9 = 0;
                    while (n9 < mLFunction.argCount) {
                        Array.set(object, n9, Utils.bigDecimalFromString(this.getString()));
                        ++n9;
                    }
                    break;
                }
            }
            if (stringArray != null) {
                stringArray[0] = mLFunction.name;
            }
        } else {
            object = this.getArraySlices(n, n2, stringArray, 0, null);
        }
        return object;
    }

    public synchronized Object getArray(int n, int n2) throws MathLinkException {
        return this.getArray(n, n2, null);
    }

    protected Object getArraySlices(int n, int n2, String[] stringArray, int n3, Class clazz) throws MathLinkException {
        Object object = null;
        if (n2 > 1) {
            int n4;
            Object object2;
            if (clazz == null) {
                object2 = "";
                n4 = 1;
                while (n4 < n2) {
                    object2 = (String)object2 + "[";
                    ++n4;
                }
                switch (n) {
                    case -1: {
                        object2 = (String)object2 + "Z";
                        break;
                    }
                    case -2: {
                        object2 = (String)object2 + "B";
                        break;
                    }
                    case -3: {
                        object2 = (String)object2 + "C";
                        break;
                    }
                    case -4: {
                        object2 = (String)object2 + "S";
                        break;
                    }
                    case -5: {
                        object2 = (String)object2 + "I";
                        break;
                    }
                    case -6: {
                        object2 = (String)object2 + "J";
                        break;
                    }
                    case -7: {
                        object2 = (String)object2 + "F";
                        break;
                    }
                    case -8: {
                        object2 = (String)object2 + "D";
                        break;
                    }
                    case -9: {
                        object2 = (String)object2 + "Ljava.lang.String;";
                        break;
                    }
                    case -10: {
                        object2 = (String)object2 + "Ljava.math.BigInteger;";
                        break;
                    }
                    case -11: {
                        object2 = (String)object2 + "Ljava.math.BigDecimal;";
                        break;
                    }
                    case -12: {
                        object2 = (String)object2 + "Lcom.wolfram.jlink.Expr;";
                        break;
                    }
                    case -13: {
                        object2 = (String)object2 + "L" + this.getComplexClass().getName() + ";";
                        break;
                    }
                }
                try {
                    clazz = JLinkClassLoader.classFromName((String)object2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            object2 = this.getFunction();
            if (stringArray != null) {
                stringArray[n3] = ((MLFunction)object2).name;
            }
            n4 = ((MLFunction)object2).argCount;
            object = Array.newInstance(clazz, n4);
            object2 = null;
            Class clazz2 = null;
            if (n2 > 2) {
                String string = clazz.getName().substring(1);
                try {
                    clazz2 = JLinkClassLoader.classFromName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            int n5 = 0;
            while (n5 < n4) {
                Array.set(object, n5, this.getArraySlices(n, n2 - 1, stringArray, n3 + 1, clazz2));
                ++n5;
            }
        } else {
            object = this.getArray(n, 1, stringArray != null ? this.headHolder : null);
            if (stringArray != null) {
                stringArray[n3] = this.headHolder[0];
            }
        }
        return object;
    }

    public synchronized void put(Object object) throws MathLinkException {
        if (object == null) {
            this.putSymbol("Null");
        } else if (object instanceof String) {
            this.putString((String)object);
        } else if (object.getClass().isArray()) {
            this.putArray(object, null);
        } else if (object instanceof Expr) {
            ((Expr)object).put(this);
        } else if (this.getComplexClass() != null && this.getComplexClass().isInstance(object)) {
            this.putComplex(object);
        } else if (object instanceof Number) {
            if (object instanceof Integer || object instanceof Short || object instanceof Byte) {
                this.put(((Number)object).intValue());
            } else if (object instanceof Double || object instanceof Float) {
                this.put(((Number)object).doubleValue());
            } else if (object instanceof Long || object instanceof BigInteger) {
                byte[] byArray = object.toString().getBytes();
                this.putNext(43);
                this.putSize(byArray.length);
                this.putData(byArray, byArray.length);
            } else {
                String string = object.toString();
                byte[] byArray = string.getBytes();
                boolean bl = string.indexOf(46) != -1;
                this.putNext(42);
                this.putSize(byArray.length + (bl ? 0 : 1));
                this.putData(byArray, byArray.length);
                if (!bl) {
                    this.putData(new byte[]{46}, 1);
                }
            }
        } else if (object instanceof Boolean) {
            this.putSymbol((Boolean)object != false ? "True" : "False");
        } else if (object instanceof Character) {
            this.put(((Character)object).charValue());
        } else {
            this.putReference(object);
        }
    }

    public synchronized void put(Object object, String[] stringArray) throws MathLinkException {
        if (object == null) {
            this.putSymbol("Null");
        } else if (object.getClass().isArray()) {
            this.putArray(object, stringArray);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected abstract void putArray(Object var1, String[] var2) throws MathLinkException;

    protected void putArrayPiecemeal(Object object, String[] stringArray, int n) throws MathLinkException {
        Class<?> clazz;
        Class<?> clazz2 = clazz = object != null ? object.getClass() : null;
        if (clazz != null && clazz.isArray()) {
            String string = stringArray != null && stringArray.length > n ? stringArray[n] : "List";
            int n2 = Array.getLength(object);
            this.putFunction(string, n2);
            ++n;
            int n3 = 0;
            while (n3 < n2) {
                this.putArrayPiecemeal(Array.get(object, n3), stringArray, n);
                ++n3;
            }
        } else {
            this.put(object);
        }
    }

    public synchronized Object getComplex() throws MathLinkException {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.getNext();
        switch (n) {
            case 42: 
            case 43: {
                d = this.getDouble();
                break;
            }
            case 70: {
                this.checkFunctionWithArgCount("Complex", 2);
                d = this.getDouble();
                d2 = this.getDouble();
                break;
            }
            default: {
                throw new MathLinkException(1003);
            }
        }
        if (this.getComplexClass() == null) {
            return null;
        }
        return this.constructComplex(d, d2);
    }

    protected synchronized void putComplex(Object object) throws MathLinkException {
        double d = 0.0;
        double d2 = 0.0;
        try {
            d = this.getRealPart(object);
            d2 = this.getImaginaryPart(object);
        }
        catch (Exception exception) {
            this.putSymbol("$Failed");
            return;
        }
        this.putFunction("Complex", 2);
        this.put(d);
        this.put(d2);
    }

    protected abstract Object constructComplex(double var1, double var3);

    protected abstract double getRealPart(Object var1) throws Exception;

    protected abstract double getImaginaryPart(Object var1) throws Exception;

    protected abstract void putString(String var1) throws MathLinkException;

    protected synchronized void putReference(Object object) throws MathLinkException {
        this.put(object.toString());
    }

    public abstract boolean removeMessageHandler(String var1);

    public abstract boolean addMessageHandler(Class var1, Object var2, String var3);

    public abstract boolean setYieldFunction(Class var1, Object var2, String var3);

    public abstract Class getComplexClass();

    public abstract boolean setComplexClass(Class var1);

    public abstract void destroyMark(long var1);

    public abstract void seekMark(long var1);

    public abstract long createMark() throws MathLinkException;

    public abstract boolean messageReady() throws MathLinkException;

    public abstract void putMessage(int var1) throws MathLinkException;

    public abstract int getMessage() throws MathLinkException;

    public abstract void transferToEndOfLoopbackLink(LoopbackLink var1) throws MathLinkException;

    public abstract void transferExpression(MathLink var1) throws MathLinkException;

    public abstract void checkFunctionWithArgCount(String var1, int var2) throws MathLinkException;

    public abstract int checkFunction(String var1) throws MathLinkException;

    public abstract void putFunction(String var1, int var2) throws MathLinkException;

    public abstract MLFunction getFunction() throws MathLinkException;

    public abstract void put(double var1) throws MathLinkException;

    public abstract double getDouble() throws MathLinkException;

    public abstract void put(long var1) throws MathLinkException;

    public abstract long getLongInteger() throws MathLinkException;

    public abstract void put(int var1) throws MathLinkException;

    public abstract int getInteger() throws MathLinkException;

    public abstract void put(boolean var1) throws MathLinkException;

    public abstract void putSymbol(String var1) throws MathLinkException;

    public abstract String getSymbol() throws MathLinkException;

    public abstract void putByteString(byte[] var1) throws MathLinkException;

    public abstract byte[] getByteString(int var1) throws MathLinkException;

    public abstract String getString() throws MathLinkException;

    public abstract byte[] getData(int var1) throws MathLinkException;

    public abstract void putData(byte[] var1, int var2) throws MathLinkException;

    public abstract int bytesToGet() throws MathLinkException;

    public abstract int bytesToPut() throws MathLinkException;

    public abstract void putSize(int var1) throws MathLinkException;

    public abstract void putArgCount(int var1) throws MathLinkException;

    public abstract int getArgCount() throws MathLinkException;

    public abstract void putNext(int var1) throws MathLinkException;

    public abstract int getType() throws MathLinkException;

    public abstract int getNext() throws MathLinkException;

    public abstract void flush() throws MathLinkException;

    public abstract boolean ready() throws MathLinkException;

    public abstract void setError(int var1);

    public abstract String errorMessage();

    public abstract boolean clearError();

    public abstract int error();

    public abstract void endPacket() throws MathLinkException;

    public abstract int nextPacket() throws MathLinkException;

    public abstract void newPacket();

    public abstract void connect(long var1) throws MathLinkException;

    public abstract void connect() throws MathLinkException;

    public abstract void close();

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

