/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.JLinkClassLoader;
import com.wolfram.jlink.JLinkSecurityManager;
import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.NativeLink;
import com.wolfram.jlink.StdLink;
import com.wolfram.jlink.Utils;
import com.wolfram.jlink.WrappedKernelLink;

public class Reader
extends Thread {
    private KernelLink ml;
    private boolean quitWhenLinkEnds = true;
    private boolean alwaysPoll = false;
    private boolean requestedStop = false;
    private static Reader reader;
    private static int sleepInterval;

    public static Thread startReader(KernelLink kernelLink, boolean bl, boolean bl2) {
        reader = new Reader(kernelLink, bl, bl2);
        reader.start();
        StdLink.setLink(kernelLink);
        StdLink.setHasReader(true);
        return reader;
    }

    public static Thread stopReader() {
        Reader.reader.requestedStop = true;
        StdLink.setHasReader(false);
        return reader;
    }

    protected Reader(KernelLink kernelLink, boolean bl, boolean bl2) {
        super("J/Link reader");
        if (Utils.isJava2OrLater()) {
            this.setContextClassLoader(JLinkClassLoader.getInstance());
        }
        this.ml = kernelLink;
        this.quitWhenLinkEnds = bl;
        this.alwaysPoll = bl2;
        kernelLink.addMessageHandler(null, this, "terminateMsgHandler");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        MathLink mathLink;
        boolean bl = false;
        if (Utils.isClassicMacintosh() && this.ml instanceof WrappedKernelLink && (mathLink = ((WrappedKernelLink)this.ml).getMathLink()) instanceof NativeLink) {
            bl = true;
        }
        long l = 0L;
        boolean bl2 = false;
        try {
            while (true) {
                if (this.requestedStop) {
                    Object var11_15 = null;
                    if (!this.quitWhenLinkEnds) return;
                    this.ml.close();
                    this.ml = null;
                    break;
                }
                if (this.alwaysPoll || bl2) {
                    boolean bl3 = false;
                    try {
                        boolean bl4 = bl3 = bl ? Reader.macReady(this.ml) : this.ml.ready();
                        if (!bl3) {
                            Thread.sleep((long)sleepInterval + Math.min(l++, 20L));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    KernelLink kernelLink = this.ml;
                    synchronized (kernelLink) {
                        try {
                            if (this.ml.error() != 0) {
                                throw new MathLinkException(this.ml.error(), this.ml.errorMessage());
                            }
                            if (bl3) {
                                l = 0L;
                                int n = this.ml.nextPacket();
                                this.ml.handlePacket(n);
                                this.ml.newPacket();
                                bl2 = StdLink.mustPoll();
                            }
                        }
                        catch (MathLinkException mathLinkException) {
                            if (mathLinkException.getErrCode() == 11 || !this.ml.clearError()) {
                                // MONITOREXIT @DISABLED, blocks:[0, 19, 7, 9, 12, 14] lbl40 : MonitorExitStatement: MONITOREXIT : var6_8
                                Object var11_13 = null;
                                if (!this.quitWhenLinkEnds) return;
                                this.ml.close();
                                this.ml = null;
                                StdLink.setLink(null);
                                JLinkSecurityManager.setAllowExit(true);
                                System.exit(0);
                                return;
                            }
                            this.ml.newPacket();
                        }
                        continue;
                    }
                }
                KernelLink kernelLink = this.ml;
                synchronized (kernelLink) {
                    try {
                        int n = this.ml.nextPacket();
                        this.ml.handlePacket(n);
                        this.ml.newPacket();
                        bl2 = StdLink.mustPoll();
                    }
                    catch (MathLinkException mathLinkException) {
                        if (mathLinkException.getErrCode() == 11 || !this.ml.clearError()) {
                            // MONITOREXIT @DISABLED, blocks:[0, 6, 10, 12, 13] lbl63 : MonitorExitStatement: MONITOREXIT : var5_6
                            Object var11_14 = null;
                            if (!this.quitWhenLinkEnds) return;
                            this.ml.close();
                            this.ml = null;
                            StdLink.setLink(null);
                            JLinkSecurityManager.setAllowExit(true);
                            System.exit(0);
                            return;
                        }
                        this.ml.newPacket();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (!this.quitWhenLinkEnds) throw throwable;
            this.ml.close();
            this.ml = null;
            StdLink.setLink(null);
            JLinkSecurityManager.setAllowExit(true);
            System.exit(0);
            throw throwable;
        }
        StdLink.setLink(null);
        JLinkSecurityManager.setAllowExit(true);
        System.exit(0);
    }

    static void setSleepInterval(int n) {
        sleepInterval = n;
    }

    public void terminateMsgHandler(int n, int n2) {
        if (n == 1) {
            this.stop();
            this.ml.setYieldFunction(null, this, "terminateYielder");
            this.requestedStop = true;
        }
    }

    private static boolean macReady(KernelLink kernelLink) throws MathLinkException {
        NativeLink nativeLink = (NativeLink)((WrappedKernelLink)kernelLink).getMathLink();
        int n = nativeLink.getMacSleepTime();
        try {
            nativeLink.setMacSleepTime(-1);
            boolean bl = kernelLink.ready();
            Object var5_4 = null;
            nativeLink.setMacSleepTime(n);
            return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            nativeLink.setMacSleepTime(n);
            throw throwable;
        }
    }

    boolean terminateYielder() {
        return true;
    }

    static {
        sleepInterval = 2;
    }
}

