/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink;

import com.wolfram.jlink.KernelLink;
import java.util.Hashtable;
import java.util.Stack;

public class StdLink {
    private static final int NONE = 0;
    private static final int JUST_ONE = 1;
    private static final int MODAL = 2;
    private static KernelLink mainLink;
    private static boolean mainLinkHasReader;
    private static boolean allowRaggedArrays;
    private static int allowUIComputations;
    private static boolean lastPktWasAllowUIComps;
    private static boolean forcePoll;
    private static boolean uiPermissionRequested;
    private static Hashtable stdLinkHash;
    private static Object stdLinkLock;
    private static Object uiLock;

    public static KernelLink getLink() {
        Object object = stdLinkLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            Stack stack = (Stack)stdLinkHash.get(thread);
            if (stack != null && !stack.empty()) {
                KernelLink kernelLink = (KernelLink)stack.peek();
                return kernelLink;
            }
            KernelLink kernelLink = mainLink;
            return kernelLink;
        }
    }

    public static void setLink(KernelLink kernelLink) {
        mainLink = kernelLink;
    }

    public static void requestTransaction() {
        Object object;
        if (mainLink == null || !mainLinkHasReader) {
            return;
        }
        Object object2 = stdLinkLock;
        synchronized (object2) {
            object = Thread.currentThread();
            Stack stack = (Stack)stdLinkHash.get(object);
            if (stack != null && !stack.empty()) {
                return;
            }
        }
        object = uiLock;
        synchronized (object) {
            uiPermissionRequested = true;
            while (allowUIComputations == 0) {
                try {
                    uiLock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (allowUIComputations == 1) {
                allowUIComputations = 0;
            }
            uiPermissionRequested = false;
        }
    }

    static void setHasReader(boolean bl) {
        mainLinkHasReader = bl;
    }

    static void setup(KernelLink kernelLink) {
        Object object = stdLinkLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            Stack<KernelLink> stack = (Stack<KernelLink>)stdLinkHash.get(thread);
            if (stack == null) {
                stack = new Stack<KernelLink>();
                stdLinkHash.put(thread, stack);
            }
            stack.push(kernelLink);
        }
    }

    static void remove() {
        Object object = stdLinkLock;
        synchronized (object) {
            Thread thread = Thread.currentThread();
            Stack stack = (Stack)stdLinkHash.get(thread);
            stack.pop();
        }
    }

    static void allowUIComputations(boolean bl, boolean bl2) {
        Object object = uiLock;
        synchronized (object) {
            if (bl) {
                StdLink.lastPktWasAllowUIComputations(true);
                if (bl2 || uiPermissionRequested) {
                    allowUIComputations = bl2 ? 2 : 1;
                    uiLock.notify();
                }
            } else {
                allowUIComputations = 0;
            }
        }
    }

    static boolean uiThreadWaiting() {
        Object object = uiLock;
        synchronized (object) {
            boolean bl = uiPermissionRequested;
            return bl;
        }
    }

    static void forcePolling(boolean bl) {
        forcePoll = bl;
    }

    static void lastPktWasAllowUIComputations(boolean bl) {
        lastPktWasAllowUIComps = bl;
    }

    static boolean mustPoll() {
        return forcePoll || lastPktWasAllowUIComps || allowUIComputations == 2;
    }

    static {
        mainLinkHasReader = false;
        allowRaggedArrays = false;
        allowUIComputations = 0;
        lastPktWasAllowUIComps = false;
        forcePoll = false;
        uiPermissionRequested = false;
        stdLinkHash = new Hashtable(4, 0.75f);
        stdLinkLock = new Object();
        uiLock = new Object();
    }
}

