/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink.ui;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathLinkException;
import com.wolfram.jlink.PacketArrivedEvent;
import com.wolfram.jlink.PacketListener;
import com.wolfram.jlink.ui.MathSessionTextPane;
import java.lang.reflect.InvocationTargetException;
import javax.swing.ImageIcon;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.StyleConstants;

class PktHandler
implements PacketListener {
    private JTextPane comp;
    private MathSessionTextPane.MTDocument doc;
    private boolean lastWasMessage = false;

    PktHandler(JTextPane jTextPane, MathSessionTextPane.MTDocument mTDocument) {
        this.comp = jTextPane;
        this.doc = mTDocument;
    }

    public boolean packetArrived(PacketArrivedEvent packetArrivedEvent) {
        KernelLink kernelLink = (KernelLink)packetArrivedEvent.getSource();
        try {
            switch (packetArrivedEvent.getPktType()) {
                case 2: 
                case 4: 
                case 5: 
                case 8: 
                case 9: {
                    String string = kernelLink.getString();
                    this.handleString(packetArrivedEvent.getPktType(), string, this.lastWasMessage);
                    break;
                }
                case 11: {
                    byte[] byArray = kernelLink.getByteString(0);
                    this.handleImage(byArray);
                    break;
                }
            }
        }
        catch (MathLinkException mathLinkException) {
            mathLinkException.printStackTrace();
            kernelLink.clearError();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.lastWasMessage = packetArrivedEvent.getPktType() == 5;
        return true;
    }

    private void handleString(final int n, final String string, final boolean bl) throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                try {
                    switch (n) {
                        case 8: {
                            PktHandler.this.doc.setLogicalStyle(PktHandler.this.doc.getLength(), PktHandler.this.comp.getStyle("prompt"));
                            if (PktHandler.this.doc.getLength() >= 2 && !PktHandler.this.doc.getText(PktHandler.this.doc.getLength() - 2, 2).equals("\n\n")) {
                                PktHandler.this.doc.insertString(PktHandler.this.doc.getLength(), "\n", null);
                            }
                            PktHandler.this.doc.insertString(PktHandler.this.doc.getLength(), string + "\n", null);
                            PktHandler.this.doc.setFirstEditPos(PktHandler.this.doc.getLength());
                            PktHandler.this.doc.setLogicalStyle(PktHandler.this.doc.getLength(), PktHandler.this.comp.getStyle("input"));
                            break;
                        }
                        case 9: {
                            PktHandler.this.doc.setLogicalStyle(PktHandler.this.doc.getLength(), PktHandler.this.comp.getStyle("prompt"));
                            PktHandler.this.doc.insertString(PktHandler.this.doc.getLength(), string + "\n", null);
                            break;
                        }
                        case 4: {
                            PktHandler.this.doc.setLogicalStyle(PktHandler.this.doc.getLength(), PktHandler.this.comp.getStyle("output"));
                            PktHandler.this.doc.insertString(PktHandler.this.doc.getLength(), string + "\n\n", null);
                            break;
                        }
                        case 2: {
                            String string2 = string;
                            if (bl) {
                                if (!string2.endsWith("\n")) {
                                    string2 = string2 + "\n";
                                }
                                if (!string2.endsWith("\n\n")) {
                                    string2 = string2 + "\n";
                                }
                            } else {
                                PktHandler.this.doc.setLogicalStyle(PktHandler.this.doc.getLength(), PktHandler.this.comp.getStyle("print"));
                            }
                            PktHandler.this.doc.insertString(PktHandler.this.doc.getLength(), string2, null);
                            break;
                        }
                        case 5: {
                            PktHandler.this.doc.setLogicalStyle(PktHandler.this.doc.getLength(), PktHandler.this.comp.getStyle("message"));
                        }
                    }
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }

    private void handleImage(final byte[] byArray) throws InvocationTargetException, InterruptedException {
        SwingUtilities.invokeAndWait(new Runnable(){

            public void run() {
                try {
                    PktHandler.this.doc.setLogicalStyle(PktHandler.this.doc.getLength(), PktHandler.this.comp.getStyle("graphics"));
                    MutableAttributeSet mutableAttributeSet = PktHandler.this.comp.getInputAttributes();
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                    StyleConstants.setIcon(mutableAttributeSet, new ImageIcon(byArray));
                    PktHandler.this.doc.insertString(PktHandler.this.doc.getLength(), " ", PktHandler.this.comp.getInputAttributes());
                    mutableAttributeSet.removeAttributes(mutableAttributeSet);
                    PktHandler.this.doc.insertString(PktHandler.this.doc.getLength(), "\n", null);
                }
                catch (BadLocationException badLocationException) {
                    badLocationException.printStackTrace();
                }
            }
        });
    }
}

