/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.jlink.ui;

import java.awt.TextArea;
import java.io.IOException;
import java.io.OutputStream;

class TextAreaOutputStream
extends OutputStream {
    protected TextArea ta;
    protected int maxLines;
    public int numLines;
    protected char[] buf = new char[256];
    protected int count;
    private boolean lastWasCR;

    public TextAreaOutputStream(TextArea textArea, int n) {
        this.ta = textArea;
        this.maxLines = n;
        this.reset();
    }

    public synchronized void write(int n) throws IOException {
        this.buf[this.count++] = (char)n;
        if (n == 13 || n == 10 && !this.lastWasCR) {
            ++this.numLines;
        }
        if (n == 10 && this.lastWasCR) {
            this.buf[this.count - 2] = 10;
            --this.count;
        }
        if (this.count == this.buf.length) {
            this.flush();
        }
        this.lastWasCR = n == 13;
    }

    public synchronized void flush() throws IOException {
        int n = this.numLines - this.maxLines;
        if (n > 0) {
            String string = this.ta.getText();
            int n2 = 0;
            int n3 = 0;
            while (n3 < string.length() && n > 0) {
                char c = string.charAt(n3);
                if (c == '\r') {
                    if (n3 < string.length() - 1 && string.charAt(n3 + 1) == '\n') {
                        --n;
                        ++n3;
                    }
                } else if (c == '\n') {
                    --n;
                }
                if (n == 0) {
                    n2 = n3 + 1;
                }
                ++n3;
            }
            if (n2 != 0) {
                this.ta.replaceRange("", 0, n2);
            }
            this.numLines = this.maxLines;
        }
        this.ta.append(new String(this.buf, 0, this.count));
        this.ta.repaint(200L);
        this.count = 0;
    }

    public synchronized void reset() {
        this.count = 0;
        this.numLines = 0;
        this.lastWasCR = false;
        this.ta.setText("");
    }
}

