/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import javaphotoeditor.ClickingTool;
import javaphotoeditor.JPEPanel;
import javaphotoeditor.MouseTool;

public class ClickingToolPolyLine
extends MouseTool
implements ClickingTool {
    private boolean doubleClicked = false;
    protected Color storedPenColor = null;
    protected float storedPenSize = 2.0f;
    protected Point storedStartPt = null;
    protected Point storedEndPt = null;

    public ClickingToolPolyLine(JPEPanel pnl) {
        super(pnl);
    }

    public ClickingToolPolyLine(JPEPanel pnl, Color col, Point p1, Point p2, float ps) {
        super(pnl);
        this.storedPenColor = col;
        this.storedStartPt = p1;
        this.storedEndPt = p2;
        this.storedPenSize = ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clicked(Point p) {
        if (!this.jpePanel.hasOffscreen()) {
            this.jpePanel.createOffscreen();
        } else {
            this.jpePanel.storeOffscreen();
        }
        if (this.doubleClicked) {
            this.removeAllPoints();
            this.doubleClicked = false;
        }
        this.addPoint(p);
        Graphics g = this.jpePanel.getOffscreenG();
        if (g != null) {
            try {
                g.setColor(super.getPenColor());
                g.setPaintMode();
                if (this.points.size() >= 2) {
                    this.drawPolyLine(g, (Point)this.points.elementAt(this.points.size() - 2), p, super.getPenSize());
                } else {
                    this.drawPolyLine(g, null, p, super.getPenSize());
                }
                this.jpePanel.repaintNow();
                Object var4_3 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                g.dispose();
                throw throwable;
            }
        }
        this.storedPenColor = new Color(super.getPenColor().getRGB());
        this.storedPenSize = super.getPenSize();
        this.storedStartPt = this.points.size() >= 2 ? new Point((Point)this.points.elementAt(this.points.size() - 2)) : null;
        this.storedEndPt = new Point(p);
        this.addUndoElement(new ClickingToolPolyLine(this.jpePanel, this.storedPenColor, this.storedStartPt, this.storedEndPt, this.storedPenSize));
        return false;
    }

    public boolean doubleClicked(Point p) {
        this.jpePanel.storeOffscreen();
        this.doubleClicked = true;
        return true;
    }

    public void interrupt() {
        this.removeAllPoints();
        this.jpePanel.storeOffscreen();
        this.doubleClicked = true;
    }

    public void drawPolyLine(Graphics g, Point p1, Point p2, float pen) {
        if (p1 != null) {
            this.drawShape(g, p1, p2, pen);
        }
        Point lt = new Point(p2);
        Point rb = new Point(p2);
        lt.x -= 2;
        lt.y -= 2;
        rb.x = lt.x + 4;
        rb.y = lt.y + 4;
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(pen);
        g2.setStroke(stroke);
        g2.draw(new Ellipse2D.Double(lt.x, lt.y, rb.x - lt.x, rb.y - lt.y));
        g2.setStroke(saved);
    }

    public void drawShape(Graphics g, Point p1, Point p2, float pen) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(pen);
        g2.setStroke(stroke);
        g2.draw(new Line2D.Double(p1.x, p1.y, p2.x, p2.y));
        g2.setStroke(saved);
    }

    public void restore(Graphics g) {
        g.setColor(this.storedPenColor);
        g.setPaintMode();
        this.drawPolyLine(g, this.storedStartPt, this.storedEndPt, this.storedPenSize);
    }
}

