/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import javaphotoeditor.ClickingTool;
import javaphotoeditor.JPEPanel;
import javaphotoeditor.MouseTool;
import javax.swing.JOptionPane;

public class ClickingToolText
extends MouseTool
implements ClickingTool {
    private String fixedText = null;
    private boolean doubleClicked = false;
    protected Color storedPenColor = null;
    protected float storedPenSize = 2.0f;
    protected Point storedPt = null;
    protected String storedText = null;

    public ClickingToolText(JPEPanel pnl) {
        super(pnl);
    }

    public ClickingToolText(JPEPanel pnl, String txt) {
        super(pnl);
        this.fixedText = txt;
    }

    public ClickingToolText(JPEPanel pnl, Color col, Point p, String s, float ps) {
        super(pnl);
        this.storedPenColor = col;
        this.storedPt = p;
        this.storedText = s;
        this.storedPenSize = ps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean clicked(Point p) {
        if (!this.jpePanel.hasOffscreen()) {
            this.jpePanel.createOffscreen();
        } else {
            this.jpePanel.storeOffscreen();
        }
        if (this.doubleClicked) {
            this.removeAllPoints();
            this.doubleClicked = false;
        }
        this.addPoint(p);
        Graphics g = this.jpePanel.getOffscreenG();
        String text = null;
        if (g != null) {
            try {
                g.setColor(super.getPenColor());
                g.setPaintMode();
                text = this.drawText(g, p, super.getPenSize());
                this.jpePanel.repaintNow();
                Object var5_4 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                g.dispose();
                throw throwable;
            }
        }
        this.storedPenColor = new Color(super.getPenColor().getRGB());
        this.storedPenSize = super.getPenSize();
        this.storedPt = new Point(p);
        this.storedText = text != null ? new String(text) : null;
        this.addUndoElement(new ClickingToolText(this.jpePanel, this.storedPenColor, this.storedPt, this.storedText, this.storedPenSize));
        return false;
    }

    public boolean doubleClicked(Point p) {
        this.jpePanel.storeOffscreen();
        this.doubleClicked = true;
        return true;
    }

    public void interrupt() {
        this.removeAllPoints();
        this.jpePanel.storeOffscreen();
    }

    public String drawText(Graphics g, Point pt, float pen) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(pen);
        g2.setStroke(stroke);
        String text = null;
        text = this.fixedText != null ? this.fixedText : JOptionPane.showInputDialog(this.jpePanel, new String("Input Text"), new String("Question"), 3);
        if (text == null) {
            g2.setStroke(saved);
            return null;
        }
        if (text != null && text.length() <= 0) {
            g2.setStroke(saved);
            return null;
        }
        AttributedString as = new AttributedString(text);
        Font font = new Font("sanserif", 1, 20);
        as.addAttribute(TextAttribute.FONT, font, 0, text.length());
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(text, font, frc);
        Rectangle2D bounds = tl.getBounds();
        tl.draw(g2, (float)(pt.getX() - bounds.getWidth() / 2.0), (float)(pt.getY() + bounds.getHeight() / 2.0));
        g2.setStroke(saved);
        return text;
    }

    public void drawText(Graphics g, Point pt, String s, float pen) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(pen);
        g2.setStroke(stroke);
        if (s == null) {
            g2.setStroke(saved);
            return;
        }
        if (s != null && s.length() <= 0) {
            g2.setStroke(saved);
            return;
        }
        AttributedString as = new AttributedString(s);
        Font font = new Font("sanserif", 1, 20);
        as.addAttribute(TextAttribute.FONT, font, 0, s.length());
        FontRenderContext frc = g2.getFontRenderContext();
        TextLayout tl = new TextLayout(s, font, frc);
        Rectangle2D bounds = tl.getBounds();
        tl.draw(g2, (float)(pt.getX() - bounds.getWidth() / 2.0), (float)(pt.getY() + bounds.getHeight() / 2.0));
        g2.setStroke(saved);
    }

    public void restore(Graphics g) {
        g.setColor(this.storedPenColor);
        g.setPaintMode();
        this.drawText(g, this.storedPt, this.storedText, this.storedPenSize);
    }
}

