/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.Vector;
import javaphotoeditor.DraggingTool;
import javaphotoeditor.JPEPanel;
import javaphotoeditor.MouseTool;

public class DraggingToolFillPoly
extends MouseTool
implements DraggingTool {
    protected Color storedPenColor = null;
    protected float storedPenSize = 2.0f;
    protected Vector storedPts = null;

    public DraggingToolFillPoly(JPEPanel pnl) {
        super(pnl);
    }

    public DraggingToolFillPoly(JPEPanel pnl, Color col, Vector pts, float ps) {
        super(pnl);
        this.storedPenColor = col;
        this.storedPts = new Vector();
        int i = 0;
        while (i < pts.size()) {
            this.storedPts.addElement(pts.elementAt(i));
            ++i;
        }
        this.storedPenSize = ps;
    }

    public void startDragging(Point p) {
        if (!this.jpePanel.hasOffscreen()) {
            this.jpePanel.createOffscreen();
        } else {
            this.jpePanel.storeOffscreen();
        }
        this.removeAllPoints();
        this.addPoint(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDragging(Point p) {
        this.addPoint(p);
        Graphics g = this.jpePanel.getOffscreenG();
        if (g != null) {
            try {
                g.setColor(super.getPenColor());
                Polygon poly = new Polygon();
                int i = 0;
                while (i < this.points.size()) {
                    Point pt = (Point)this.points.elementAt(i);
                    poly.addPoint(pt.x, pt.y);
                    ++i;
                }
                g.setPaintMode();
                g.drawPolygon(poly);
                this.drawShape2(g, poly, super.getPenSize());
                this.jpePanel.repaintNow();
                Object var7_7 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                g.dispose();
                throw throwable;
            }
        }
        this.storedPenColor = new Color(super.getPenColor().getRGB());
        this.storedPenSize = super.getPenSize();
        this.storedPts = new Vector();
        int k = 0;
        while (k < this.points.size()) {
            this.storedPts.addElement(this.points.elementAt(k));
            ++k;
        }
        this.addUndoElement(new DraggingToolFillPoly(this.jpePanel, this.storedPenColor, this.storedPts, this.storedPenSize));
        this.jpePanel.storeOffscreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whileDragging(Point lastP, Point newP) {
        this.addPoint(newP);
        Graphics g = this.jpePanel.getOffscreenG();
        if (g != null) {
            try {
                g.setColor(super.getPenColor());
                g.drawLine(lastP.x, lastP.y, newP.x, newP.y);
                this.jpePanel.repaintNow();
                Object var5_4 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                g.dispose();
                throw throwable;
            }
        }
    }

    public void interrupt() {
        this.removeAllPoints();
        this.jpePanel.storeOffscreen();
    }

    public void drawLine(Graphics g, Point p1, Point p2, float pen) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(pen);
        g2.setStroke(stroke);
        g2.draw(new Line2D.Double(p1.x, p1.y, p2.x, p2.y));
        g2.setStroke(saved);
    }

    public void drawShape2(Graphics g, Polygon poly, float pen) {
        Graphics2D g2 = (Graphics2D)g;
        float alpha = 0.5f;
        AlphaComposite ac = AlphaComposite.getInstance(3, alpha);
        g2.setComposite(ac);
        GeneralPath polygon = new GeneralPath(0, poly.xpoints.length);
        polygon.moveTo(poly.xpoints[0], poly.ypoints[0]);
        int index = 1;
        while (index < poly.xpoints.length) {
            if (poly.xpoints[index] != 0 || poly.ypoints[index] != 0) {
                polygon.lineTo(poly.xpoints[index], poly.ypoints[index]);
            }
            ++index;
        }
        polygon.closePath();
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(pen);
        g2.setStroke(stroke);
        g2.fill(polygon);
        g2.setStroke(saved);
        ac = AlphaComposite.getInstance(3, 1.0f);
        g2.setComposite(ac);
    }

    public Polygon getShape() {
        Polygon poly = new Polygon();
        int i = 0;
        while (i < this.points.size()) {
            Point pt = (Point)this.points.elementAt(i);
            poly.addPoint(pt.x, pt.y);
            ++i;
        }
        return poly;
    }

    public void restore(Graphics g) {
        g.setColor(this.storedPenColor);
        g.setPaintMode();
        Polygon poly = new Polygon();
        int i = 0;
        while (i < this.storedPts.size()) {
            Point pt = (Point)this.storedPts.elementAt(i);
            poly.addPoint(pt.x, pt.y);
            ++i;
        }
        g.setPaintMode();
        g.drawPolygon(poly);
        this.drawShape2(g, poly, super.getPenSize());
    }
}

