/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import javaphotoeditor.DraggingTool;
import javaphotoeditor.JPEPanel;
import javaphotoeditor.MouseTool;

public class DraggingToolLine
extends MouseTool
implements DraggingTool {
    protected Color storedPenColor = null;
    protected float storedPenSize = 2.0f;
    protected Point storedStartPt = null;
    protected Point storedEndPt = null;

    public DraggingToolLine(JPEPanel pnl) {
        super(pnl);
    }

    public DraggingToolLine(JPEPanel pnl, Color col, Point p1, Point p2, float ps) {
        super(pnl);
        this.storedPenColor = col;
        this.storedStartPt = p1;
        this.storedEndPt = p2;
        this.storedPenSize = ps;
    }

    public void startDragging(Point p) {
        if (!this.jpePanel.hasOffscreen()) {
            this.jpePanel.createOffscreen();
        } else {
            this.jpePanel.storeOffscreen();
        }
        this.removeAllPoints();
        this.addPoint(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDragging(Point p) {
        Graphics g = this.jpePanel.getOffscreenG();
        Point startP = null;
        Point lastP = null;
        if (g != null) {
            try {
                startP = (Point)this.points.firstElement();
                lastP = (Point)this.points.lastElement();
                g.setXORMode(this.jpePanel.getBackground());
                this.drawShape(g, startP, lastP, super.getPenSize());
                g.setColor(super.getPenColor());
                g.setPaintMode();
                this.drawShape(g, startP, p, super.getPenSize());
                this.jpePanel.repaintNow();
                Object var6_5 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                g.dispose();
                throw throwable;
            }
        }
        this.addPoint(p);
        this.storedPenColor = new Color(super.getPenColor().getRGB());
        this.storedPenSize = super.getPenSize();
        this.storedStartPt = new Point(startP);
        this.storedEndPt = new Point(p);
        this.addUndoElement(new DraggingToolLine(this.jpePanel, this.storedPenColor, this.storedStartPt, this.storedEndPt, this.storedPenSize));
        this.jpePanel.storeOffscreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whileDragging(Point lastP, Point newP) {
        this.addPoint(newP);
        Graphics g = this.jpePanel.getOffscreenG();
        if (g != null) {
            try {
                Point startP = (Point)this.points.firstElement();
                g.setXORMode(this.jpePanel.getBackground());
                this.drawShape(g, startP, lastP, super.getPenSize());
                this.drawShape(g, startP, newP, super.getPenSize());
                this.jpePanel.repaintNow();
                Object var6_5 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                g.dispose();
                throw throwable;
            }
        }
    }

    public void interrupt() {
        this.removeAllPoints();
        this.jpePanel.storeOffscreen();
    }

    public void drawShape(Graphics g, Point p1, Point p2, float pen) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(pen);
        g2.setStroke(stroke);
        g2.draw(new Line2D.Double(p1.x, p1.y, p2.x, p2.y));
        g2.setStroke(saved);
    }

    public void restore(Graphics g) {
        g.setColor(this.storedPenColor);
        g.setPaintMode();
        this.drawShape(g, this.storedStartPt, this.storedEndPt, this.storedPenSize);
    }
}

