/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import javaphotoeditor.DraggingTool;
import javaphotoeditor.JPEPanel;
import javaphotoeditor.MouseTool;

public class DraggingToolMarqueeRect
extends MouseTool
implements DraggingTool {
    public DraggingToolMarqueeRect(JPEPanel pnl) {
        super(pnl);
    }

    public void startDragging(Point p) {
        if (!this.jpePanel.hasOffscreen()) {
            this.jpePanel.createOffscreen();
        } else {
            this.jpePanel.removeOffscreen();
            this.jpePanel.createOffscreen();
        }
        this.removeAllPoints();
        this.addPoint(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDragging(Point p) {
        Graphics g = this.jpePanel.getOffscreenG();
        if (g != null) {
            try {
                Point startP = (Point)this.points.firstElement();
                Point lastP = (Point)this.points.lastElement();
                g.setXORMode(this.jpePanel.getBackground());
                this.drawShape(g, startP, lastP);
                g.setColor(super.getMarqueeColor());
                g.setPaintMode();
                this.drawShape(g, startP, p);
                this.drawShape2(g, startP, p);
                this.jpePanel.repaintNow();
                Object var6_5 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                g.dispose();
                throw throwable;
            }
        }
        this.addPoint(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whileDragging(Point lastP, Point newP) {
        this.addPoint(newP);
        Graphics g = this.jpePanel.getOffscreenG();
        if (g != null) {
            try {
                Point startP = (Point)this.points.firstElement();
                g.setXORMode(this.jpePanel.getBackground());
                this.drawShape(g, startP, lastP);
                this.drawShape(g, startP, newP);
                this.jpePanel.repaintNow();
                Object var6_5 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                g.dispose();
                throw throwable;
            }
        }
    }

    public void interrupt() {
        this.removeAllPoints();
        this.jpePanel.removeOffscreen();
    }

    public void drawShape(Graphics g, Point p1, Point p2) {
        Point lt = new Point(p1);
        Point rb = new Point(p2);
        if (p1.x < p2.x) {
            lt.x = p1.x;
            rb.x = p2.x;
        } else {
            lt.x = p2.x;
            rb.x = p1.x;
        }
        if (p1.y < p2.y) {
            lt.y = p1.y;
            rb.y = p2.y;
        } else {
            lt.y = p2.y;
            rb.y = p1.y;
        }
        g.drawRect(lt.x, lt.y, rb.x - lt.x, rb.y - lt.y);
    }

    public void drawShape2(Graphics g, Point p1, Point p2) {
        Point lt = new Point(p1);
        Point rb = new Point(p2);
        if (p1.x < p2.x) {
            lt.x = p1.x;
            rb.x = p2.x;
        } else {
            lt.x = p2.x;
            rb.x = p1.x;
        }
        if (p1.y < p2.y) {
            lt.y = p1.y;
            rb.y = p2.y;
        } else {
            lt.y = p2.y;
            rb.y = p1.y;
        }
        Graphics2D g2 = (Graphics2D)g;
        float alpha = 0.5f;
        AlphaComposite ac = AlphaComposite.getInstance(3, alpha);
        g2.setComposite(ac);
        g2.fill(new Rectangle2D.Double(lt.x, lt.y, rb.x - lt.x, rb.y - lt.y));
        ac = AlphaComposite.getInstance(3, 1.0f);
        g2.setComposite(ac);
    }

    public Rectangle getShape() {
        Point p1 = (Point)this.points.firstElement();
        Point p2 = (Point)this.points.lastElement();
        Point lt = new Point(p1);
        Point rb = new Point(p2);
        if (p1.x < p2.x) {
            lt.x = p1.x;
            rb.x = p2.x;
        } else {
            lt.x = p2.x;
            rb.x = p1.x;
        }
        if (p1.y < p2.y) {
            lt.y = p1.y;
            rb.y = p2.y;
        } else {
            lt.y = p2.y;
            rb.y = p1.y;
        }
        return new Rectangle(lt.x, lt.y, rb.x - lt.x, rb.y - lt.y);
    }

    public void restore(Graphics g) {
    }
}

