/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.util.Vector;
import javaphotoeditor.DraggingTool;
import javaphotoeditor.JPEPanel;
import javaphotoeditor.MouseTool;

public class DraggingToolPen
extends MouseTool
implements DraggingTool {
    protected Color storedPenColor = null;
    protected float storedPenSize = 2.0f;
    protected Vector storedPts = null;

    public DraggingToolPen(JPEPanel pnl) {
        super(pnl);
    }

    public DraggingToolPen(JPEPanel pnl, Color col, Vector pts, float ps) {
        super(pnl);
        this.storedPenColor = col;
        this.storedPts = new Vector();
        int i = 0;
        while (i < pts.size()) {
            this.storedPts.addElement(pts.elementAt(i));
            ++i;
        }
        this.storedPenSize = ps;
    }

    public void startDragging(Point p) {
        if (!this.jpePanel.hasOffscreen()) {
            this.jpePanel.createOffscreen();
        } else {
            this.jpePanel.storeOffscreen();
        }
        this.removeAllPoints();
        this.addPoint(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDragging(Point p) {
        this.addPoint(p);
        Graphics g = this.jpePanel.getOffscreenG();
        if (g != null) {
            try {
                g.setColor(super.getPenColor());
                g.setPaintMode();
                this.drawLine(g, (Point)this.points.elementAt(this.points.size() - 2), (Point)this.points.elementAt(this.points.size() - 1), super.getPenSize());
                Object var4_3 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                g.dispose();
                throw throwable;
            }
        }
        this.storedPenColor = new Color(super.getPenColor().getRGB());
        this.storedPenSize = super.getPenSize();
        this.storedPts = new Vector();
        int k = 0;
        while (k < this.points.size()) {
            this.storedPts.addElement(this.points.elementAt(k));
            ++k;
        }
        this.addUndoElement(new DraggingToolPen(this.jpePanel, this.storedPenColor, this.storedPts, this.storedPenSize));
        this.jpePanel.storeOffscreen();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void whileDragging(Point lastP, Point newP) {
        this.addPoint(newP);
        Graphics g = this.jpePanel.getOffscreenG();
        if (g != null) {
            try {
                g.setColor(super.getPenColor());
                this.drawLine(g, lastP, newP, super.getPenSize());
                Object var5_4 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                g.dispose();
                throw throwable;
            }
            this.jpePanel.repaintNow();
        }
    }

    public void interrupt() {
        this.removeAllPoints();
        this.jpePanel.storeOffscreen();
    }

    public void drawLine(Graphics g, Point p1, Point p2, float pen) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke saved = g2.getStroke();
        BasicStroke stroke = new BasicStroke(pen);
        g2.setStroke(stroke);
        g2.draw(new Line2D.Double(p1.x, p1.y, p2.x, p2.y));
        g2.setStroke(saved);
    }

    public void restore(Graphics g) {
        g.setColor(this.storedPenColor);
        int k = 1;
        while (k < this.storedPts.size()) {
            this.drawLine(g, (Point)this.storedPts.elementAt(k - 1), (Point)this.storedPts.elementAt(k), this.storedPenSize);
            ++k;
        }
    }
}

