/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.wolfram.jlink.MathJFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javaphotoeditor.ClickingTool;
import javaphotoeditor.DraggingTool;
import javaphotoeditor.JPEPanel;
import javaphotoeditor.LoadImageDialog;
import javaphotoeditor.MouseTool;
import javaphotoeditor.MouseToolManager;
import javaphotoeditor.beans.ColorPanelBean;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;

public class JPEFrame
extends MathJFrame
implements PropertyChangeListener {
    private JPEPanel jpePanel;
    private MouseToolManager toolManager;
    MyCellRenderer renderer;
    private int lastSelected = 1;
    private float selectedPenSize = 2.0f;
    Thread dlgTh = null;
    private JToggleButton brnClickTextPlusMinus;
    private JToggleButton btnDragPen;
    private JMenuItem itemLoad;
    private JToggleButton btnDragFillOval;
    private JLabel statusLabel;
    private JToggleButton btnClickTextDownArrow;
    private JScrollPane scrollPane;
    private JToggleButton btnDragRect;
    private JMenu menuHelp;
    private JToggleButton btnDragFillRect;
    private JButton btnUndo;
    private JToggleButton btnDragOval;
    private JToggleButton btnClickText;
    private JMenuItem itemSaveAs;
    private JToolBar toolBar;
    private JToggleButton btnDragMarqueeRect;
    private JMenu menuFile;
    private ButtonGroup group;
    private JToggleButton btnDragFillPoly;
    private JMenuBar menuBar;
    private ColorPanelBean colorPanelBean;
    private JToggleButton btnClickTextLeftArrow;
    private JToggleButton btnDragPoly;
    private JToggleButton btnClickPolyLine;
    private JToggleButton btnClickTextPlus;
    private JSeparator jSeparator1;
    private JToggleButton btnDragAreaSelection;
    private JComboBox penSizeCombo;
    private JToggleButton btnClickTextRightArrow;
    private JPanel statusPanel;
    private JToggleButton btnDragLine;
    private JMenuItem itemAbout;
    private JButton btnRedo;
    private JToggleButton btnClickTextUpArrow;
    static /* synthetic */ Class class$javaphotoeditor$LoadImageDialog;

    public JPEFrame() {
        this.initComponents();
        this.finishInit();
        this.setJMenuBar(this.menuBar);
    }

    public JPEFrame(String title) {
        super(title);
        this.initComponents();
        this.finishInit();
        this.setJMenuBar(this.menuBar);
    }

    public JPEFrame(int w, int h) {
        this.initComponents();
        this.finishInit(w, h);
        this.setJMenuBar(this.menuBar);
    }

    public void loadImage(URL url) {
        if (this.jpePanel.hasOffscreen()) {
            this.jpePanel.removeOffscreen();
        }
        try {
            ImageIcon icn = new ImageIcon(url);
            this.setTitle(icn.toString());
            Image img = icn.getImage();
            this.jpePanel.setImage(img);
            this.jpePanel.setPreferredSize(new Dimension(img.getWidth(this), img.getHeight(this)));
            this.jpePanel.revalidate();
            this.jpePanel.prepareForUndo(img);
        }
        catch (Exception e) {}
    }

    public void loadImage(File file) {
        if (this.jpePanel.hasOffscreen()) {
            this.jpePanel.removeOffscreen();
        }
        try {
            ImageIcon icn = new ImageIcon(file.getPath());
            this.setTitle(icn.toString());
            Image img = icn.getImage();
            this.jpePanel.setImage(img);
            this.jpePanel.setPreferredSize(new Dimension(img.getWidth(this), img.getHeight(this)));
            this.jpePanel.revalidate();
            this.jpePanel.prepareForUndo(img);
        }
        catch (Exception e) {}
    }

    public void loadImage(String path) {
        if (this.jpePanel.hasOffscreen()) {
            this.jpePanel.removeOffscreen();
        }
        try {
            ImageIcon icn = new ImageIcon(path);
            this.setTitle(icn.toString());
            Image img = icn.getImage();
            this.jpePanel.setImage(img);
            this.jpePanel.setPreferredSize(new Dimension(img.getWidth(this), img.getHeight(this)));
            this.jpePanel.revalidate();
            this.jpePanel.prepareForUndo(img);
        }
        catch (Exception e) {}
    }

    public void loadImage(Image img) {
        if (this.jpePanel.hasOffscreen()) {
            this.jpePanel.removeOffscreen();
        }
        try {
            this.setTitle("Java Photo Editor");
            this.jpePanel.setImage(img);
            this.jpePanel.setPreferredSize(new Dimension(img.getWidth(this), img.getHeight(this)));
            this.jpePanel.revalidate();
            this.jpePanel.prepareForUndo(img);
        }
        catch (Exception e) {}
    }

    public void setupPenSizeCombo() {
        Icon[] icons = new Icon[]{new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/pen1.gif")), new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/pen2.gif")), new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/pen4.gif")), new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/pen8.gif"))};
        this.renderer = new MyCellRenderer(icons);
        this.penSizeCombo.setRenderer(this.renderer);
        this.penSizeCombo.setSelectedIndex(2);
        this.jpePanel.setJPEFrame(this);
    }

    public float getSelectedPenSize() {
        return this.selectedPenSize;
    }

    public void finishInit() {
        this.jpePanel = new JPEPanel();
        this.jpePanel.setDoubleBuffered(true);
        this.scrollPane.setViewportView(this.jpePanel);
        this.scrollPane.setAutoscrolls(true);
        MouseToolHandler mouseToolHandler = new MouseToolHandler();
        this.jpePanel.addMouseListener(mouseToolHandler);
        this.jpePanel.addMouseMotionListener(mouseToolHandler);
        this.jpePanel.setColorPanelBean(this.colorPanelBean);
        this.setupPenSizeCombo();
        this.toolManager = new MouseToolManager(this.jpePanel);
        this.loadImage(this.getClass().getResource("/javaphotoeditor/img/fireworks.gif"));
    }

    public void finishInit(int w, int h) {
        this.jpePanel = new JPEPanel();
        this.jpePanel.setSize(w, h);
        this.jpePanel.setPreferredSize(new Dimension(w, h));
        this.jpePanel.setDoubleBuffered(true);
        this.scrollPane.setViewportView(this.jpePanel);
        this.scrollPane.setAutoscrolls(true);
        MouseToolHandler mouseToolHandler = new MouseToolHandler();
        this.jpePanel.addMouseListener(mouseToolHandler);
        this.jpePanel.addMouseMotionListener(mouseToolHandler);
        this.jpePanel.setColorPanelBean(this.colorPanelBean);
        this.setupPenSizeCombo();
        this.toolManager = new MouseToolManager(this.jpePanel);
    }

    public void enableUndoButton(boolean flag) {
        this.btnUndo.setEnabled(flag);
    }

    public void enableRedoButton(boolean flag) {
        this.btnRedo.setEnabled(flag);
    }

    private void initComponents() {
        this.group = new ButtonGroup();
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu();
        this.itemLoad = new JMenuItem();
        this.itemSaveAs = new JMenuItem();
        this.menuHelp = new JMenu();
        this.itemAbout = new JMenuItem();
        this.toolBar = new JToolBar();
        this.btnDragMarqueeRect = new JToggleButton();
        this.btnDragAreaSelection = new JToggleButton();
        this.jSeparator1 = new JSeparator();
        this.btnDragLine = new JToggleButton();
        this.btnDragOval = new JToggleButton();
        this.btnDragRect = new JToggleButton();
        this.btnDragPoly = new JToggleButton();
        this.btnDragPen = new JToggleButton();
        this.btnClickPolyLine = new JToggleButton();
        this.btnDragFillOval = new JToggleButton();
        this.btnDragFillRect = new JToggleButton();
        this.btnDragFillPoly = new JToggleButton();
        this.btnClickText = new JToggleButton();
        this.btnClickTextPlus = new JToggleButton();
        this.brnClickTextPlusMinus = new JToggleButton();
        this.btnClickTextLeftArrow = new JToggleButton();
        this.btnClickTextRightArrow = new JToggleButton();
        this.btnClickTextUpArrow = new JToggleButton();
        this.btnClickTextDownArrow = new JToggleButton();
        this.colorPanelBean = new ColorPanelBean();
        this.penSizeCombo = new JComboBox();
        this.scrollPane = new JScrollPane();
        this.statusPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.btnUndo = new JButton();
        this.btnRedo = new JButton();
        this.menuFile.setText("File");
        this.itemLoad.setText("Load...");
        this.itemLoad.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.itemLoadActionPerformed(evt);
            }
        });
        this.menuFile.add(this.itemLoad);
        this.itemSaveAs.setText("Save As JPEG...");
        this.itemSaveAs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.itemSaveAsActionPerformed(evt);
            }
        });
        this.menuFile.add(this.itemSaveAs);
        this.menuBar.add(this.menuFile);
        this.menuHelp.setText("Help");
        this.itemAbout.setText("About...");
        this.itemAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.itemAboutActionPerformed(evt);
            }
        });
        this.menuHelp.add(this.itemAbout);
        this.menuBar.add(this.menuHelp);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.setTitle("Java Photo Editor");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JPEFrame.this.exitForm(evt);
            }
        });
        this.toolBar.setFloatable(false);
        this.toolBar.setRollover(true);
        this.toolBar.setMaximumSize(new Dimension(32768, 36));
        this.toolBar.setMinimumSize(new Dimension(800, 36));
        this.toolBar.setPreferredSize(new Dimension(800, 36));
        this.btnDragMarqueeRect.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/RectOff.gif")));
        this.btnDragMarqueeRect.setToolTipText("Marquee Rect");
        this.group.add(this.btnDragMarqueeRect);
        this.btnDragMarqueeRect.setMaximumSize(new Dimension(36, 36));
        this.btnDragMarqueeRect.setMinimumSize(new Dimension(36, 36));
        this.btnDragMarqueeRect.setPreferredSize(new Dimension(36, 36));
        this.btnDragMarqueeRect.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/RectOn.gif")));
        this.btnDragMarqueeRect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragMarqueeRectActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragMarqueeRect);
        this.btnDragAreaSelection.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/PolyOff.gif")));
        this.btnDragAreaSelection.setToolTipText("Area Selection");
        this.group.add(this.btnDragAreaSelection);
        this.btnDragAreaSelection.setMaximumSize(new Dimension(36, 36));
        this.btnDragAreaSelection.setMinimumSize(new Dimension(36, 36));
        this.btnDragAreaSelection.setPreferredSize(new Dimension(36, 36));
        this.btnDragAreaSelection.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/PolyOn.gif")));
        this.btnDragAreaSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragAreaSelectionActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragAreaSelection);
        this.jSeparator1.setOrientation(1);
        this.toolBar.add(this.jSeparator1);
        this.btnDragLine.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/LineOff.gif")));
        this.btnDragLine.setSelected(true);
        this.btnDragLine.setToolTipText("Frame Line");
        this.group.add(this.btnDragLine);
        this.btnDragLine.setMaximumSize(new Dimension(36, 36));
        this.btnDragLine.setMinimumSize(new Dimension(36, 36));
        this.btnDragLine.setPreferredSize(new Dimension(36, 36));
        this.btnDragLine.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/LineOn.gif")));
        this.btnDragLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragLineActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragLine);
        this.btnDragOval.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/OvalOff.gif")));
        this.btnDragOval.setToolTipText("Frame Oval");
        this.group.add(this.btnDragOval);
        this.btnDragOval.setMaximumSize(new Dimension(36, 36));
        this.btnDragOval.setMinimumSize(new Dimension(36, 36));
        this.btnDragOval.setPreferredSize(new Dimension(36, 36));
        this.btnDragOval.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/OvalOn.gif")));
        this.btnDragOval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragOvalActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragOval);
        this.btnDragRect.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/RectOff.gif")));
        this.btnDragRect.setToolTipText("Frame Rect");
        this.group.add(this.btnDragRect);
        this.btnDragRect.setMaximumSize(new Dimension(36, 36));
        this.btnDragRect.setMinimumSize(new Dimension(36, 36));
        this.btnDragRect.setPreferredSize(new Dimension(36, 36));
        this.btnDragRect.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/RectOn.gif")));
        this.btnDragRect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragRectActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragRect);
        this.btnDragPoly.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/PolyOff.gif")));
        this.btnDragPoly.setToolTipText("Frame Poly");
        this.group.add(this.btnDragPoly);
        this.btnDragPoly.setMaximumSize(new Dimension(36, 36));
        this.btnDragPoly.setMinimumSize(new Dimension(36, 36));
        this.btnDragPoly.setPreferredSize(new Dimension(36, 36));
        this.btnDragPoly.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/PolyOn.gif")));
        this.btnDragPoly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragPolyActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragPoly);
        this.btnDragPen.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/PenOff.gif")));
        this.btnDragPen.setToolTipText("Pen");
        this.group.add(this.btnDragPen);
        this.btnDragPen.setMaximumSize(new Dimension(36, 36));
        this.btnDragPen.setMinimumSize(new Dimension(36, 36));
        this.btnDragPen.setPreferredSize(new Dimension(36, 36));
        this.btnDragPen.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/PenOn.gif")));
        this.btnDragPen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragPenActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragPen);
        this.btnClickPolyLine.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/PolyLineOff.gif")));
        this.btnClickPolyLine.setToolTipText("<html>Frame Poly Line<br>Click points, double click end point.</html>");
        this.group.add(this.btnClickPolyLine);
        this.btnClickPolyLine.setMaximumSize(new Dimension(36, 36));
        this.btnClickPolyLine.setMinimumSize(new Dimension(36, 36));
        this.btnClickPolyLine.setPreferredSize(new Dimension(36, 36));
        this.btnClickPolyLine.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/PolyLineOn.gif")));
        this.btnClickPolyLine.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnClickPolyLineActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnClickPolyLine);
        this.btnDragFillOval.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/FillOvalOff.gif")));
        this.btnDragFillOval.setToolTipText("Fill Oval");
        this.group.add(this.btnDragFillOval);
        this.btnDragFillOval.setMaximumSize(new Dimension(36, 36));
        this.btnDragFillOval.setMinimumSize(new Dimension(36, 36));
        this.btnDragFillOval.setPreferredSize(new Dimension(36, 36));
        this.btnDragFillOval.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/FillOvalOn.gif")));
        this.btnDragFillOval.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragFillOvalActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragFillOval);
        this.btnDragFillRect.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/FillRectOff.gif")));
        this.btnDragFillRect.setToolTipText("Fill Rect");
        this.group.add(this.btnDragFillRect);
        this.btnDragFillRect.setMaximumSize(new Dimension(36, 36));
        this.btnDragFillRect.setMinimumSize(new Dimension(36, 36));
        this.btnDragFillRect.setPreferredSize(new Dimension(36, 36));
        this.btnDragFillRect.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/FillRectOn.gif")));
        this.btnDragFillRect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragFillRectActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragFillRect);
        this.btnDragFillPoly.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/FillPolyOff.gif")));
        this.btnDragFillPoly.setToolTipText("Fill Poly");
        this.group.add(this.btnDragFillPoly);
        this.btnDragFillPoly.setMaximumSize(new Dimension(36, 36));
        this.btnDragFillPoly.setMinimumSize(new Dimension(36, 36));
        this.btnDragFillPoly.setPreferredSize(new Dimension(36, 36));
        this.btnDragFillPoly.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/FillPolyOn.gif")));
        this.btnDragFillPoly.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnDragFillPolyActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnDragFillPoly);
        this.btnClickText.setIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/TextOff.gif")));
        this.btnClickText.setToolTipText("Draw Text");
        this.group.add(this.btnClickText);
        this.btnClickText.setMaximumSize(new Dimension(36, 36));
        this.btnClickText.setMinimumSize(new Dimension(36, 36));
        this.btnClickText.setPreferredSize(new Dimension(36, 36));
        this.btnClickText.setSelectedIcon(new ImageIcon(this.getClass().getResource("/javaphotoeditor/toolicons/TextOn.gif")));
        this.btnClickText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnClickTextActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnClickText);
        this.btnClickTextPlus.setText("+");
        this.btnClickTextPlus.setToolTipText("+");
        this.group.add(this.btnClickTextPlus);
        this.btnClickTextPlus.setMaximumSize(new Dimension(36, 36));
        this.btnClickTextPlus.setMinimumSize(new Dimension(36, 36));
        this.btnClickTextPlus.setPreferredSize(new Dimension(36, 36));
        this.btnClickTextPlus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnClickTextPlusActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnClickTextPlus);
        this.brnClickTextPlusMinus.setText("\u00b1");
        this.brnClickTextPlusMinus.setToolTipText("\u00b1");
        this.group.add(this.brnClickTextPlusMinus);
        this.brnClickTextPlusMinus.setMaximumSize(new Dimension(36, 36));
        this.brnClickTextPlusMinus.setMinimumSize(new Dimension(36, 36));
        this.brnClickTextPlusMinus.setPreferredSize(new Dimension(36, 36));
        this.brnClickTextPlusMinus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.brnClickTextPlusMinusActionPerformed(evt);
            }
        });
        this.toolBar.add(this.brnClickTextPlusMinus);
        this.btnClickTextLeftArrow.setText("\u2190");
        this.btnClickTextLeftArrow.setToolTipText("\u2190");
        this.group.add(this.btnClickTextLeftArrow);
        this.btnClickTextLeftArrow.setMaximumSize(new Dimension(36, 36));
        this.btnClickTextLeftArrow.setMinimumSize(new Dimension(36, 36));
        this.btnClickTextLeftArrow.setPreferredSize(new Dimension(36, 36));
        this.btnClickTextLeftArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnClickTextLeftArrowActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnClickTextLeftArrow);
        this.btnClickTextRightArrow.setText("\u2192");
        this.btnClickTextRightArrow.setToolTipText("\u2192");
        this.group.add(this.btnClickTextRightArrow);
        this.btnClickTextRightArrow.setMaximumSize(new Dimension(36, 36));
        this.btnClickTextRightArrow.setMinimumSize(new Dimension(36, 36));
        this.btnClickTextRightArrow.setPreferredSize(new Dimension(36, 36));
        this.btnClickTextRightArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnClickTextRightArrowActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnClickTextRightArrow);
        this.btnClickTextUpArrow.setText("\u2191");
        this.btnClickTextUpArrow.setToolTipText("\u2191");
        this.group.add(this.btnClickTextUpArrow);
        this.btnClickTextUpArrow.setMaximumSize(new Dimension(36, 36));
        this.btnClickTextUpArrow.setMinimumSize(new Dimension(36, 36));
        this.btnClickTextUpArrow.setPreferredSize(new Dimension(36, 36));
        this.btnClickTextUpArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnClickTextUpArrowActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnClickTextUpArrow);
        this.btnClickTextDownArrow.setText("\u2193");
        this.btnClickTextDownArrow.setToolTipText("\u2193");
        this.group.add(this.btnClickTextDownArrow);
        this.btnClickTextDownArrow.setMaximumSize(new Dimension(36, 36));
        this.btnClickTextDownArrow.setMinimumSize(new Dimension(36, 36));
        this.btnClickTextDownArrow.setPreferredSize(new Dimension(36, 36));
        this.btnClickTextDownArrow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnClickTextDownArrowActionPerformed(evt);
            }
        });
        this.toolBar.add(this.btnClickTextDownArrow);
        this.colorPanelBean.setMaximumSize(new Dimension(32, 32));
        this.colorPanelBean.setMinimumSize(new Dimension(32, 32));
        this.colorPanelBean.setPreferredSize(new Dimension(32, 32));
        this.toolBar.add(this.colorPanelBean);
        this.penSizeCombo.setMaximumRowCount(4);
        this.penSizeCombo.setModel(new DefaultComboBoxModel<String>(new String[]{"", "", "", ""}));
        this.penSizeCombo.setMaximumSize(new Dimension(64, 32));
        this.penSizeCombo.setMinimumSize(new Dimension(64, 32));
        this.penSizeCombo.setPreferredSize(new Dimension(64, 32));
        this.penSizeCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.penSizeComboActionPerformed(evt);
            }
        });
        this.toolBar.add(this.penSizeCombo);
        this.getContentPane().add(this.toolBar);
        this.scrollPane.setDoubleBuffered(true);
        this.scrollPane.setMinimumSize(new Dimension(800, 22));
        this.scrollPane.setPreferredSize(new Dimension(800, 600));
        this.scrollPane.setAutoscrolls(true);
        this.scrollPane.setEnabled(false);
        this.getContentPane().add(this.scrollPane);
        this.statusPanel.setDoubleBuffered(false);
        this.statusPanel.setMaximumSize(new Dimension(Short.MAX_VALUE, 32));
        this.statusPanel.setMinimumSize(new Dimension(800, 32));
        this.statusPanel.setPreferredSize(new Dimension(800, 32));
        this.statusLabel.setText("Info:");
        this.statusPanel.add(this.statusLabel);
        this.btnUndo.setText("Undo");
        this.btnUndo.setEnabled(false);
        this.btnUndo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnUndoActionPerformed(evt);
            }
        });
        this.statusPanel.add(this.btnUndo);
        this.btnRedo.setText("Redo");
        this.btnRedo.setEnabled(false);
        this.btnRedo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JPEFrame.this.btnRedoActionPerformed(evt);
            }
        });
        this.statusPanel.add(this.btnRedo);
        this.getContentPane().add(this.statusPanel);
        this.pack();
    }

    private void btnDragPenActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolPen();
    }

    private void itemAboutActionPerformed(ActionEvent evt) {
        URL url = this.getClass().getResource("/javaphotoeditor/img/jpelogo.jpg");
        ImageIcon icon = new ImageIcon(url);
        String str = "Copyright (c) 2002, Junzo Sato. All rights reserved.";
        JLabel lbl = new JLabel(icon);
        lbl.setHorizontalTextPosition(0);
        lbl.setVerticalTextPosition(3);
        lbl.setText(str);
        JOptionPane.showMessageDialog(this.getContentPane(), lbl, "About", 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void itemSaveAsActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        int selected = chooser.showSaveDialog(this);
        if (selected == 0) {
            String path = chooser.getSelectedFile().getPath();
            String format = "jpeg";
            Image image = this.jpePanel.getSourceImage();
            Dimension d = this.jpePanel.getSourceImageSize();
            BufferedImage bf = new BufferedImage(d.width, d.height, 1);
            Graphics g = bf.getGraphics();
            if (g != null) {
                try {
                    g.setColor(Color.white);
                    g.drawImage(image, 0, 0, d.width, d.height, this);
                    Object var11_10 = null;
                    g.dispose();
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    g.dispose();
                    throw throwable;
                }
            }
            try {
                FileOutputStream dest = new FileOutputStream(path);
                JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder((OutputStream)dest);
                encoder.encode(bf);
                dest.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        if (selected == 1) {
            // empty if block
        }
    }

    private void itemLoadActionPerformed(ActionEvent evt) {
        LoadImageDialog dlg = new LoadImageDialog((Frame)this, true);
        dlg.addPropertyChangeListener(this);
        this.dlgTh = new Thread(dlg);
        this.dlgTh.start();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if (e.getSource().getClass().equals(class$javaphotoeditor$LoadImageDialog == null ? (class$javaphotoeditor$LoadImageDialog = JPEFrame.class$("javaphotoeditor.LoadImageDialog")) : class$javaphotoeditor$LoadImageDialog)) {
            LoadImageDialog dlg = (LoadImageDialog)e.getSource();
            boolean clickedOk = (Boolean)e.getNewValue();
            URL url = null;
            String path = null;
            if (clickedOk) {
                if (dlg.isURL()) {
                    path = dlg.getURLPath();
                    if (path != null && !path.equals("")) {
                        try {
                            url = new URL(path);
                        }
                        catch (MalformedURLException ex) {
                            url = null;
                        }
                    }
                } else {
                    File f;
                    path = dlg.getFilePath();
                    if (path != null && !path.equals("") && (f = new File(path)) != null) {
                        try {
                            url = f.toURL();
                        }
                        catch (MalformedURLException ex1) {
                            url = null;
                        }
                    }
                }
            } else {
                url = null;
            }
            dlg.setVisible(false);
            dlg.dispose();
            this.dlgTh.interrupt();
            this.dlgTh = null;
            if (url != null) {
                this.loadImage(url);
            }
            return;
        }
    }

    private void btnRedoActionPerformed(ActionEvent evt) {
        this.jpePanel.redo();
    }

    private void btnUndoActionPerformed(ActionEvent evt) {
        this.jpePanel.undo();
    }

    private void btnClickTextDownArrowActionPerformed(ActionEvent evt) {
        this.toolManager.setClickingToolText("\u2193");
    }

    private void btnClickTextUpArrowActionPerformed(ActionEvent evt) {
        this.toolManager.setClickingToolText("\u2191");
    }

    private void btnClickTextRightArrowActionPerformed(ActionEvent evt) {
        this.toolManager.setClickingToolText("\u2192");
    }

    private void btnClickTextLeftArrowActionPerformed(ActionEvent evt) {
        this.toolManager.setClickingToolText("\u2190");
    }

    private void brnClickTextPlusMinusActionPerformed(ActionEvent evt) {
        this.toolManager.setClickingToolText("\u00b1");
    }

    private void penSizeComboActionPerformed(ActionEvent evt) {
        if (this.renderer == null) {
            return;
        }
        this.lastSelected = this.renderer.getSelectedItem();
        switch (this.lastSelected) {
            case 0: {
                this.selectedPenSize = 1.0f;
                break;
            }
            case 1: {
                this.selectedPenSize = 2.0f;
                break;
            }
            case 2: {
                this.selectedPenSize = 4.0f;
                break;
            }
            case 3: {
                this.selectedPenSize = 8.0f;
            }
        }
    }

    private void btnDragAreaSelectionActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolAreaSelection();
    }

    private void btnDragPolyActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolPoly();
    }

    private void btnDragFillPolyActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolFillPoly();
    }

    private void btnDragFillRectActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolFillRect();
    }

    private void btnDragFillOvalActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolFillOval();
    }

    private void btnDragRectActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolRect();
    }

    private void btnDragOvalActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolOval();
    }

    private void btnDragMarqueeRectActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolMarqueeRect();
    }

    private void btnClickTextPlusActionPerformed(ActionEvent evt) {
        this.toolManager.setClickingToolText("+");
    }

    private void btnClickTextActionPerformed(ActionEvent evt) {
        this.toolManager.setClickingToolText();
    }

    private void btnClickPolyLineActionPerformed(ActionEvent evt) {
        this.toolManager.setClickingToolPolyLine();
    }

    private void btnDragLineActionPerformed(ActionEvent evt) {
        this.toolManager.setDraggingToolLine();
    }

    private void exitForm(WindowEvent evt) {
        System.exit(0);
    }

    public JPEPanel getJpePanel() {
        return this.jpePanel;
    }

    public void setJpePanel(JPEPanel jpePanel) {
        this.jpePanel = jpePanel;
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public MouseToolManager getToolManager() {
        return this.toolManager;
    }

    public String getStatus() {
        return this.statusLabel.getText();
    }

    public void setStatus(String s) {
        this.statusLabel.setText(s);
    }

    public void showPoint(Point p) {
        this.setStatus("Mouse: {x,y}={" + p.x + "," + p.y + "}");
    }

    public static void main(String[] args) {
        new JPEFrame().show();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class MouseToolHandler
    implements MouseListener,
    MouseMotionListener {
        int x = 0;
        int y = 0;
        boolean dragging = false;
        int lastx;
        int lasty;
        MouseTool mouseTool = null;

        public Dimension calcTopLeft() {
            Dimension panelSize = JPEFrame.this.jpePanel.getSize();
            Dimension imgSize = JPEFrame.this.jpePanel.getSourceImageSize();
            int dw = (panelSize.width - imgSize.width) / 2;
            int dh = (panelSize.height - imgSize.height) / 2;
            return new Dimension(dw, dh);
        }

        public Point adjustPoint(Point p) {
            Dimension d = this.calcTopLeft();
            return new Point(p.x - d.width, p.y - d.height);
        }

        public Point getMouse() {
            return this.adjustPoint(new Point(this.x, this.y));
        }

        public boolean isMouseInsideImage(int x, int y) {
            Dimension panelSize = JPEFrame.this.jpePanel.getSize();
            Dimension imgSize = JPEFrame.this.jpePanel.getSourceImageSize();
            int dw = (panelSize.width - imgSize.width) / 2;
            int dh = (panelSize.height - imgSize.height) / 2;
            boolean inside = dw <= x && x <= dw + imgSize.width && dh <= y && y <= dh + imgSize.height;
            return inside;
        }

        public void mouseEntered(MouseEvent evt) {
            this.x = evt.getX();
            this.y = evt.getY();
            JPEFrame.this.showPoint(this.getMouse());
        }

        public void mouseExited(MouseEvent evt) {
            this.x = evt.getX();
            this.y = evt.getY();
            JPEFrame.this.showPoint(this.getMouse());
        }

        public void mouseClicked(MouseEvent evt) {
            this.x = evt.getX();
            this.y = evt.getY();
            JPEFrame.this.showPoint(this.getMouse());
            if (!this.isMouseInsideImage(this.x, this.y)) {
                return;
            }
            if (JPEFrame.this.toolManager.isMarqueeRectOrAreaSelection()) {
                ((DraggingTool)((Object)JPEFrame.this.toolManager.getCurrentTool())).interrupt();
                return;
            }
            if (!JPEFrame.this.toolManager.isClickingTool()) {
                return;
            }
            this.mouseTool = JPEFrame.this.toolManager.getCurrentTool();
            if (evt.getClickCount() == 2) {
                if (((ClickingTool)((Object)this.mouseTool)).doubleClicked(this.adjustPoint(evt.getPoint()))) {
                    this.mouseTool = null;
                }
            } else if (evt.getClickCount() == 1 && ((ClickingTool)((Object)this.mouseTool)).clicked(this.adjustPoint(evt.getPoint()))) {
                this.mouseTool = null;
            }
        }

        public void mousePressed(MouseEvent evt) {
            this.x = evt.getX();
            this.y = evt.getY();
            JPEFrame.this.showPoint(this.getMouse());
        }

        public void mouseReleased(MouseEvent evt) {
            this.x = evt.getX();
            this.y = evt.getY();
            JPEFrame.this.showPoint(this.getMouse());
            if (this.dragging) {
                ((DraggingTool)((Object)this.mouseTool)).stopDragging(this.adjustPoint(evt.getPoint()));
                this.mouseTool = null;
                this.dragging = false;
            }
        }

        public void mouseMoved(MouseEvent evt) {
            this.x = evt.getX();
            this.y = evt.getY();
            JPEFrame.this.showPoint(this.getMouse());
        }

        public void mouseDragged(MouseEvent evt) {
            this.x = evt.getX();
            this.y = evt.getY();
            JPEFrame.this.showPoint(this.getMouse());
            if (!JPEFrame.this.toolManager.isDraggingTool()) {
                return;
            }
            if (!this.dragging) {
                if (!this.isMouseInsideImage(this.x, this.y)) {
                    return;
                }
                this.dragging = true;
                this.mouseTool = JPEFrame.this.toolManager.getCurrentTool();
                ((DraggingTool)((Object)this.mouseTool)).startDragging(this.adjustPoint(new Point(this.x, this.y)));
                this.lastx = this.x;
                this.lasty = this.y;
            } else if (this.lastx != this.x || this.lasty != this.y) {
                ((DraggingTool)((Object)this.mouseTool)).whileDragging(this.adjustPoint(new Point(this.lastx, this.lasty)), this.adjustPoint(new Point(this.x, this.y)));
                this.lastx = this.x;
                this.lasty = this.y;
            }
        }
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        Icon[] icons = null;
        int selectedItem;

        public int getSelectedItem() {
            return this.selectedItem;
        }

        public MyCellRenderer(Icon[] icons) {
            this.icons = icons;
            this.selectedItem = 1;
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(0);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            if (value != null) {
                String txt = value.toString();
                this.setText(txt);
            } else {
                this.setText(String.valueOf(index));
            }
            if (index != -1 && index < this.icons.length) {
                this.setIcon(this.icons[index]);
            } else {
                this.setIcon(this.icons[JPEFrame.this.lastSelected]);
            }
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
                this.selectedItem = index;
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }
    }
}

