/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor;

import com.wolfram.jlink.KernelLink;
import com.wolfram.jlink.MathGraphicsJPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.util.Vector;
import javaphotoeditor.JPEFrame;
import javaphotoeditor.MouseTool;
import javaphotoeditor.beans.ColorPanelBean;
import javax.swing.JScrollPane;

public class JPEPanel
extends MathGraphicsJPanel {
    private ColorPanelBean colorPanelBean = null;
    private JPEFrame jpeFrame = null;
    private Vector undoList = new Vector();
    private Vector redoList = new Vector();
    private Image offscreen = null;
    protected Image originalImage = null;

    public JPEFrame getJpeFrame() {
        return this.jpeFrame;
    }

    public Vector getUndoList() {
        return this.undoList;
    }

    public void enableUndoButton(boolean flag) {
        this.jpeFrame.enableUndoButton(flag);
    }

    public Vector getRedoList() {
        return this.redoList;
    }

    public void enableRedoButton(boolean flag) {
        this.jpeFrame.enableRedoButton(flag);
    }

    public JPEPanel() {
    }

    public JPEPanel(KernelLink ml) {
        super(ml);
    }

    public void setColorPanelBean(ColorPanelBean cp) {
        this.colorPanelBean = cp;
    }

    public Color getColorPanelColor() {
        if (this.colorPanelBean == null) {
            return Color.yellow;
        }
        return this.colorPanelBean.getPanelColor();
    }

    public void setJPEFrame(JPEFrame frm) {
        this.jpeFrame = frm;
    }

    public float getPenSize() {
        if (this.jpeFrame == null) {
            return 2.0f;
        }
        return this.jpeFrame.getSelectedPenSize();
    }

    public Image getImage() {
        return super.getImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(Image img) {
        if (img == null) {
            return;
        }
        this.ensureImageReady(img);
        Image im = this.createImage(img.getWidth(this), img.getHeight(this));
        this.ensureImageReady(im);
        Graphics g = im.getGraphics();
        if (g != null) {
            try {
                g.drawImage(img, 0, 0, this);
                Object var5_4 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                g.dispose();
                throw throwable;
            }
        }
        super.setImage(im);
        this.repaintNow();
    }

    public Image getSourceImage() {
        return this.getImage();
    }

    public void setSourceImage(Image img) {
        this.setImage(img);
        this.repaintNow();
    }

    public Dimension getSourceImageSize() {
        return new Dimension(this.getSourceImage().getWidth(this), this.getSourceImage().getHeight(this));
    }

    public void adjustPreferredSize() {
        this.setPreferredSize(this.getSourceImageSize());
        this.repaintNow();
    }

    public Dimension getPreferredSize() {
        return this.getSourceImageSize();
    }

    public void storeOffscreen() {
        if (this.hasOffscreen()) {
            this.addJavaImage(this.getOffscreen(), 0, 0);
            this.adjustPreferredSize();
        }
    }

    public Image getOffscreen() {
        return this.offscreen;
    }

    public void setOffscreen(Image img) {
        this.offscreen = img;
        this.repaintNow();
    }

    public boolean hasOffscreen() {
        return this.offscreen != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean createOffscreen() {
        Image sourceImage = this.getSourceImage();
        if (sourceImage == null) {
            this.offscreen = null;
            return false;
        }
        int imageHeight = sourceImage.getHeight(this);
        int imageWidth = sourceImage.getWidth(this);
        if (imageHeight != -1 && imageWidth != -1) {
            this.offscreen = this.createImage(imageWidth, imageHeight);
            if (this.offscreen == null) {
                System.out.println("Couldn't create offscreen.");
                return false;
            }
            this.ensureImageReady(this.offscreen);
            Graphics offscreenG = this.offscreen.getGraphics();
            if (offscreenG == null) {
                System.out.println("Couldn't get offscreen graphics.");
                this.offscreen = null;
                return false;
            }
            try {
                offscreenG.drawImage(sourceImage, 0, 0, this);
                Object var6_5 = null;
                offscreenG.dispose();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                offscreenG.dispose();
                throw throwable;
            }
            this.setPreferredSize(new Dimension(imageWidth, imageHeight));
            return true;
        }
        this.offscreen = null;
        return false;
    }

    public void removeOffscreen() {
        this.offscreen = null;
        this.repaintNow();
    }

    public Graphics getOffscreenG() {
        if (this.offscreen != null) {
            return this.offscreen.getGraphics();
        }
        return null;
    }

    public Image createImage(int width, int height) {
        Image superImage = super.createImage(width, height);
        return superImage;
    }

    public int[] calcImageSize(Image img) {
        int[] size = new int[]{img.getWidth(this), img.getHeight(this)};
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJavaImage(Image anImage, int x, int y) {
        if (anImage == null) {
            System.out.println("Couldn't addJavaImage.");
            return;
        }
        Image sourceImage = this.getSourceImage();
        if (sourceImage == null) {
            return;
        }
        Graphics g = sourceImage.getGraphics();
        if (g != null) {
            try {
                g.drawImage(anImage, x, y, this);
                Object var7_6 = null;
                g.dispose();
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                g.dispose();
                throw throwable;
            }
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        if (!this.hasOffscreen()) {
            super.paint(g);
            return;
        }
        Image sourceImage = this.getSourceImage();
        int imageHeight = sourceImage.getHeight(this);
        int imageWidth = sourceImage.getWidth(this);
        int totalWidth = this.getSize().width;
        int totalHeight = this.getSize().height;
        if (imageWidth != -1 && imageHeight != -1) {
            int left = (totalWidth - imageWidth) / 2;
            int top = (totalHeight - imageHeight) / 2;
            g.clearRect(0, 0, totalWidth, totalHeight);
            super.paint(g);
            g.drawImage(this.offscreen, left, top, this);
        } else {
            super.paint(g);
        }
    }

    public void ensureImageReady(Image im) {
        MediaTracker tracker = new MediaTracker(this);
        if (im != null && im.getWidth(null) == -1) {
            tracker.addImage(im, 0);
            try {
                tracker.waitForID(0);
            }
            catch (Exception e) {
                // empty catch block
            }
            tracker.removeImage(im, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepareForUndo(Image img) {
        this.undoList.removeAllElements();
        this.redoList.removeAllElements();
        this.enableUndoButton(false);
        this.enableRedoButton(false);
        if (img == null) {
            this.originalImage = null;
            return;
        }
        this.ensureImageReady(img);
        int imageHeight = img.getHeight(this);
        int imageWidth = img.getWidth(this);
        if (imageHeight != -1 && imageWidth != -1) {
            this.originalImage = this.createImage(imageWidth, imageHeight);
            if (this.originalImage == null) {
                System.out.println("Couldn't create originalImage.");
                return;
            }
            this.ensureImageReady(this.originalImage);
            Graphics originalImageG = this.originalImage.getGraphics();
            if (originalImageG == null) {
                System.out.println("Couldn't get originalImage graphics.");
                this.originalImage = null;
                return;
            }
            try {
                originalImageG.drawImage(img, 0, 0, this);
                Object var6_5 = null;
                originalImageG.dispose();
                return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                originalImageG.dispose();
                throw throwable;
            }
        }
        this.originalImage = null;
    }

    public void undo() {
        int s = this.undoList.size();
        if (s <= 0) {
            return;
        }
        this.redoList.addElement(this.undoList.lastElement());
        this.undoList.removeElementAt(s - 1);
        this.restoreImage();
        this.enableRedoButton(true);
        if (this.undoList.size() <= 0) {
            this.enableUndoButton(false);
        }
        this.jpeFrame.getToolManager().interruptCurrentTool();
    }

    public void redo() {
        int s = this.redoList.size();
        if (s <= 0) {
            return;
        }
        this.undoList.addElement(this.redoList.lastElement());
        this.redoList.removeElementAt(s - 1);
        this.restoreImage();
        this.enableUndoButton(true);
        if (this.redoList.size() <= 0) {
            this.enableRedoButton(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restoreImage() {
        Graphics offscreenG;
        if (!this.hasOffscreen()) {
            this.createOffscreen();
        }
        if ((offscreenG = this.offscreen.getGraphics()) != null) {
            try {
                offscreenG.drawImage(this.originalImage, 0, 0, this);
                int k = 0;
                while (k < this.undoList.size()) {
                    ((MouseTool)this.undoList.elementAt(k)).restore(offscreenG);
                    ++k;
                }
                Object var4_3 = null;
                offscreenG.dispose();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                offscreenG.dispose();
                throw throwable;
            }
        }
        this.storeOffscreen();
        this.repaintNow();
    }

    public void repaintNow() {
        JScrollPane scrl;
        if (this.jpeFrame != null && (scrl = this.jpeFrame.getScrollPane()) != null) {
            scrl.paintImmediately(new Rectangle(0, 0, scrl.getWidth(), scrl.getHeight()));
        }
        super.repaintNow();
    }
}

