/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor;

import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import javaphotoeditor.ClickingTool;
import javaphotoeditor.ClickingToolPolyLine;
import javaphotoeditor.ClickingToolText;
import javaphotoeditor.DraggingTool;
import javaphotoeditor.DraggingToolAreaSelection;
import javaphotoeditor.DraggingToolFillOval;
import javaphotoeditor.DraggingToolFillPoly;
import javaphotoeditor.DraggingToolFillRect;
import javaphotoeditor.DraggingToolLine;
import javaphotoeditor.DraggingToolMarqueeRect;
import javaphotoeditor.DraggingToolOval;
import javaphotoeditor.DraggingToolPen;
import javaphotoeditor.DraggingToolPoly;
import javaphotoeditor.DraggingToolRect;
import javaphotoeditor.JPEPanel;
import javaphotoeditor.MouseTool;

public class MouseToolManager {
    private JPEPanel jpePanel = null;
    private MouseTool currentTool = null;

    public MouseToolManager(JPEPanel pnl) {
        this.jpePanel = pnl;
        this.currentTool = new DraggingToolLine(this.jpePanel);
    }

    public MouseTool getCurrentTool() {
        return this.currentTool;
    }

    public boolean isClickingTool() {
        return this.currentTool instanceof ClickingTool;
    }

    public boolean isDraggingTool() {
        return this.currentTool instanceof DraggingTool;
    }

    public boolean isMarqueeRectOrAreaSelection() {
        return this.currentTool instanceof DraggingToolMarqueeRect || this.currentTool instanceof DraggingToolAreaSelection;
    }

    public Vector getPoints() {
        if (this.currentTool == null) {
            return null;
        }
        return this.currentTool.points;
    }

    public int[][] getPointsAsList() {
        if (this.currentTool == null) {
            return null;
        }
        Vector v = this.currentTool.points;
        int size = v.size();
        if (v.size() <= 0) {
            return null;
        }
        int[][] list = new int[2][size];
        int i = 0;
        while (i < size) {
            list[0][i] = ((Point)v.elementAt((int)i)).x;
            list[1][i] = ((Point)v.elementAt((int)i)).y;
            ++i;
        }
        return list;
    }

    public Rectangle getMarqueeRect() {
        if (this.currentTool == null) {
            return null;
        }
        if (this.currentTool instanceof DraggingToolMarqueeRect) {
            return ((DraggingToolMarqueeRect)this.currentTool).getShape();
        }
        return null;
    }

    public Polygon getAreaSelection() {
        if (this.currentTool == null) {
            return null;
        }
        if (this.currentTool instanceof DraggingToolAreaSelection) {
            return ((DraggingToolAreaSelection)this.currentTool).getShape();
        }
        return null;
    }

    public Object getShape() {
        if (this.currentTool == null) {
            return null;
        }
        if (this.currentTool instanceof DraggingToolRect) {
            return ((DraggingToolRect)this.currentTool).getShape();
        }
        if (this.currentTool instanceof DraggingToolOval) {
            return ((DraggingToolOval)this.currentTool).getShape();
        }
        if (this.currentTool instanceof DraggingToolPoly) {
            return ((DraggingToolPoly)this.currentTool).getShape();
        }
        if (this.currentTool instanceof DraggingToolFillRect) {
            return ((DraggingToolFillRect)this.currentTool).getShape();
        }
        if (this.currentTool instanceof DraggingToolFillOval) {
            return ((DraggingToolFillOval)this.currentTool).getShape();
        }
        if (this.currentTool instanceof DraggingToolFillPoly) {
            return ((DraggingToolFillPoly)this.currentTool).getShape();
        }
        return null;
    }

    public void removeCurrentTool() {
        if (this.currentTool != null) {
            this.currentTool.removeAllPoints();
            this.interruptCurrentTool();
            this.currentTool = null;
        }
    }

    public void interruptCurrentTool() {
        if (this.isClickingTool()) {
            ((ClickingTool)((Object)this.currentTool)).interrupt();
        } else if (this.isDraggingTool()) {
            ((DraggingTool)((Object)this.currentTool)).interrupt();
        }
    }

    public void setClickingToolPolyLine() {
        this.removeCurrentTool();
        this.currentTool = new ClickingToolPolyLine(this.jpePanel);
    }

    public void setClickingToolText() {
        this.removeCurrentTool();
        this.currentTool = new ClickingToolText(this.jpePanel);
    }

    public void setClickingToolText(String txt) {
        this.removeCurrentTool();
        this.currentTool = new ClickingToolText(this.jpePanel, txt);
    }

    public void setDraggingToolLine() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolLine(this.jpePanel);
    }

    public void setDraggingToolOval() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolOval(this.jpePanel);
    }

    public void setDraggingToolRect() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolRect(this.jpePanel);
    }

    public void setDraggingToolPoly() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolPoly(this.jpePanel);
    }

    public void setDraggingToolPen() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolPen(this.jpePanel);
    }

    public void setDraggingToolFillOval() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolFillOval(this.jpePanel);
    }

    public void setDraggingToolFillRect() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolFillRect(this.jpePanel);
    }

    public void setDraggingToolFillPoly() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolFillPoly(this.jpePanel);
    }

    public void setDraggingToolMarqueeRect() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolMarqueeRect(this.jpePanel);
    }

    public void setDraggingToolAreaSelection() {
        this.removeCurrentTool();
        this.currentTool = new DraggingToolAreaSelection(this.jpePanel);
    }
}

