/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor.beans;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ColorPanelBean
extends JPanel {
    private boolean entered = false;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    private Color panelColor;
    private JColorChooser cc;
    private JDialog dlg;

    public ColorPanelBean() {
        this.initComponents();
        this.panelColor = Color.yellow;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ColorPanelBean.this.formMouseClicked(evt);
            }

            public void mouseExited(MouseEvent evt) {
                ColorPanelBean.this.formMouseExited(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                ColorPanelBean.this.formMouseEntered(evt);
            }
        });
    }

    private void formMouseClicked(MouseEvent evt) {
        this.cc = new JColorChooser(this.panelColor);
        if (this.cc == null) {
            System.out.println("Couldn't create JColorChooser");
            return;
        }
        this.dlg = JColorChooser.createDialog(this, "Color Chooser", true, this.cc, new CCListener(), new CCListener());
        this.dlg.setVisible(true);
    }

    private void formMouseExited(MouseEvent evt) {
        this.entered = false;
        this.repaint();
    }

    private void formMouseEntered(MouseEvent evt) {
        this.entered = true;
        this.repaint();
    }

    public JColorChooser getCc() {
        return this.cc;
    }

    public void setCc(JColorChooser cc) {
        this.cc = cc;
    }

    public JDialog getDlg() {
        return this.dlg;
    }

    public void setDlg(JDialog dlg) {
        this.dlg = dlg;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public boolean isEntered() {
        return this.entered;
    }

    public void setEntered(boolean entered) throws PropertyVetoException {
        boolean oldEntered = this.entered;
        this.vetoableChangeSupport.fireVetoableChange("entered", new Boolean(oldEntered), new Boolean(entered));
        this.entered = entered;
        this.propertyChangeSupport.firePropertyChange("entered", new Boolean(oldEntered), new Boolean(entered));
    }

    public Color getPanelColor() {
        return this.panelColor;
    }

    public void setPanelColor(Color panelColor) throws PropertyVetoException {
        Color oldPanelColor = this.panelColor;
        this.vetoableChangeSupport.fireVetoableChange("panelColor", oldPanelColor, panelColor);
        this.panelColor = panelColor;
        this.propertyChangeSupport.firePropertyChange("panelColor", oldPanelColor, panelColor);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        g.setColor(Color.white);
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(this.panelColor);
        g.fillRect(2, 2, d.width - 4, d.height - 4);
        if (this.entered) {
            g.setColor(Color.black);
            g.drawRect(0, 0, d.width - 1, d.height - 1);
        }
    }

    class CCListener
    implements ActionListener {
        CCListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            JButton b = (JButton)evt.getSource();
            if (b.getText().equals("\u4e86\u89e3")) {
                try {
                    ColorPanelBean.this.setPanelColor(ColorPanelBean.this.cc.getColor());
                }
                catch (Exception e) {}
            } else if (b.getText().equals("\u53d6\u6d88\u3057")) {
                ColorPanelBean.this.dlg.dispose();
                ColorPanelBean.this.dlg = null;
                ColorPanelBean.this.cc = null;
            }
            ColorPanelBean.this.entered = false;
            ColorPanelBean.this.repaint();
        }
    }
}

