/*
 * Decompiled with CFR 0.152.
 */
package javaphotoeditor.beans;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class SelectFileBean
extends JPanel {
    private JPanel jPanel1;
    private JLabel lblTitle;
    private JTextField tfPath;
    private JButton jButton1;
    private String path;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);
    private String title;

    public SelectFileBean() {
        this.initComponents();
        this.path = "";
        this.title = this.lblTitle.getText();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblTitle = new JLabel();
        this.tfPath = new JTextField();
        this.jButton1 = new JButton();
        this.setLayout(new BoxLayout(this, 0));
        this.setMinimumSize(new Dimension(600, 40));
        this.jPanel1.setMaximumSize(new Dimension(Short.MAX_VALUE, 40));
        this.jPanel1.setMinimumSize(new Dimension(600, 40));
        this.jPanel1.setPreferredSize(new Dimension(600, 40));
        this.lblTitle.setText("File: ");
        this.jPanel1.add(this.lblTitle);
        this.tfPath.setPreferredSize(new Dimension(512, 21));
        this.jPanel1.add(this.tfPath);
        this.jButton1.setText("Choose...");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SelectFileBean.this.jButton1ActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.add(this.jPanel1);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser("/");
        if (chooser == null) {
            return;
        }
        chooser.setFileSelectionMode(0);
        int selected = chooser.showOpenDialog(this);
        if (selected == 0) {
            File file = chooser.getSelectedFile();
            try {
                this.setPath(file.getPath());
            }
            catch (PropertyVetoException ve) {
                // empty catch block
            }
            this.tfPath.setText(this.getPath());
            return;
        }
        if (selected == 1) {
            return;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.addVetoableChangeListener(l);
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.vetoableChangeSupport.removeVetoableChangeListener(l);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) throws PropertyVetoException {
        String oldPath = this.path;
        this.vetoableChangeSupport.fireVetoableChange("path", oldPath, path);
        this.path = path;
        this.propertyChangeSupport.firePropertyChange("path", oldPath, path);
        this.tfPath.setText(this.path);
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) throws PropertyVetoException {
        String oldTitle = this.title;
        this.vetoableChangeSupport.fireVetoableChange("title", oldTitle, title);
        this.title = title;
        this.propertyChangeSupport.firePropertyChange("title", oldTitle, title);
        this.lblTitle.setText(this.title);
    }
}

