/*
 * Decompiled with CFR 0.152.
 */
package MathSocket.MathJavaServer.JavaServer;

import MathSocket.MathJavaServer.JavaServer.SocketListener;
import com.wolfram.jlink.Expr;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JavaServerFrame
extends JFrame {
    private boolean isServing = false;
    int serverPort;
    ServerSocket serverSocket = null;
    Thread serverThread = null;
    SocketListener listener = null;
    JLabel jLabelServerPort = new JLabel();
    JTextField jTextFieldServerPort = new JTextField();
    JScrollPane jScrollPaneServerStatus = new JScrollPane();
    JTextArea jTextAreaServerStatus = new JTextArea();
    JButton jButtonStartStopServer = new JButton();
    JButton jButtonClearServerStatus = new JButton();
    JLabel jLabel1 = new JLabel();
    private boolean mShown = false;

    public void setSocketListener(SocketListener l) {
        this.listener = l;
    }

    public void initComponents() throws Exception {
        this.jLabelServerPort.setText("Server Port:");
        this.jLabelServerPort.setLocation(new Point(125, 50));
        this.jLabelServerPort.setVisible(true);
        this.jLabelServerPort.setSize(new Dimension(80, 30));
        this.jTextFieldServerPort.setText("2001");
        this.jTextFieldServerPort.setLocation(new Point(205, 50));
        this.jTextFieldServerPort.setVisible(true);
        this.jTextFieldServerPort.setSize(new Dimension(80, 30));
        this.jScrollPaneServerStatus.setLocation(new Point(5, 90));
        this.jScrollPaneServerStatus.setVisible(true);
        this.jScrollPaneServerStatus.setSize(new Dimension(480, 280));
        this.jScrollPaneServerStatus.getViewport().add(this.jTextAreaServerStatus);
        this.jTextAreaServerStatus.setText("Java Server Status");
        this.jTextAreaServerStatus.setAutoscrolls(false);
        this.jTextAreaServerStatus.setVisible(true);
        this.jButtonStartStopServer.setText("Start");
        this.jButtonStartStopServer.setLocation(new Point(295, 50));
        this.jButtonStartStopServer.setVisible(true);
        this.jButtonStartStopServer.setOpaque(false);
        this.jButtonStartStopServer.setSize(new Dimension(80, 30));
        this.jButtonClearServerStatus.setText("Clear");
        this.jButtonClearServerStatus.setLocation(new Point(215, 380));
        this.jButtonClearServerStatus.setVisible(true);
        this.jButtonClearServerStatus.setOpaque(false);
        this.jButtonClearServerStatus.setSize(new Dimension(80, 30));
        this.jLabel1.setText("Java Server");
        this.jLabel1.setForeground(new Color(200, 0, 0));
        this.jLabel1.setLocation(new Point(120, 10));
        this.jLabel1.setVisible(true);
        this.jLabel1.setFont(new Font("Application", 1, 24));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setSize(new Dimension(260, 30));
        this.setLocation(new Point(5, 40));
        this.setTitle("JavaServer.JavaServerFrame");
        this.getContentPane().setLayout(null);
        this.setSize(new Dimension(489, 415));
        this.getContentPane().add(this.jLabelServerPort);
        this.getContentPane().add(this.jTextFieldServerPort);
        this.getContentPane().add(this.jScrollPaneServerStatus);
        this.getContentPane().add(this.jButtonStartStopServer);
        this.getContentPane().add(this.jButtonClearServerStatus);
        this.getContentPane().add(this.jLabel1);
        this.jButtonStartStopServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaServerFrame.this.jButtonStartStopServerActionPerformed(e);
            }
        });
        this.jButtonClearServerStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaServerFrame.this.jButtonClearServerStatusActionPerformed(e);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JavaServerFrame.this.thisWindowClosing(e);
            }
        });
        this.printlnServerStatus("Launched server.");
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int jMenuBarHeight = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += jMenuBarHeight;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public void printlnServerStatus(String str) {
        Date date = new Date();
        if (date != null) {
            this.jTextAreaServerStatus.append(date.toString() + ": " + str + "\n");
        } else {
            this.jTextAreaServerStatus.append(str + "\n");
        }
    }

    public void startServer() {
        String portTxt = this.jTextFieldServerPort.getText();
        Integer intObj = new Integer(portTxt);
        this.serverPort = intObj;
        try {
            this.serverSocket = new ServerSocket(this.serverPort);
            this.printlnServerStatus("Created server socket. Port = " + String.valueOf(this.serverSocket.getLocalPort()));
        }
        catch (IOException e1) {
            this.printlnServerStatus("Couldn't create server socket.");
            return;
        }
        this.serverThread = new Thread(){

            public void run() {
                while (true) {
                    Socket clientSocket = null;
                    try {
                        clientSocket = JavaServerFrame.this.serverSocket.accept();
                        JavaServerFrame.this.printlnServerStatus("Accepted a client. Address = " + clientSocket.getInetAddress().getHostAddress() + ", Port = " + String.valueOf(clientSocket.getPort()));
                    }
                    catch (IOException e2) {
                        JavaServerFrame.this.printlnServerStatus("Couldn't accept a client.");
                        continue;
                    }
                    try {
                        Thread sessionThread = new Thread(new sessionProc(clientSocket));
                        sessionThread.start();
                    }
                    catch (IOException e3) {
                        if (clientSocket != null) {
                            try {
                                clientSocket.close();
                            }
                            catch (IOException e4) {
                                // empty catch block
                            }
                            clientSocket = null;
                        }
                        JavaServerFrame.this.printlnServerStatus("Couldn't start session thread.");
                        continue;
                    }
                    try {
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException e4) {
                        if (clientSocket == null) continue;
                        try {
                            clientSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        clientSocket = null;
                        continue;
                    }
                    break;
                }
            }
        };
        if (this.serverThread == null) {
            this.printlnServerStatus("Couldn't create server thread.");
            return;
        }
        this.serverThread.start();
        this.jButtonStartStopServer.setText("Stop");
        this.isServing = true;
    }

    public void stopServer() {
        String portTxt = String.valueOf(this.serverPort);
        if (this.serverThread != null) {
            if (this.serverThread.isAlive()) {
                this.serverThread.stop();
            }
            this.serverThread = null;
        }
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
                this.printlnServerStatus("Closed server socket.");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.serverSocket = null;
        }
        this.jButtonStartStopServer.setText("Start");
        this.isServing = false;
    }

    public void jButtonStartStopServerActionPerformed(ActionEvent e) {
        if (this.isServing) {
            this.stopServer();
        } else {
            this.startServer();
        }
    }

    public void jButtonClearServerStatusActionPerformed(ActionEvent e) {
        this.jTextAreaServerStatus.setText("");
    }

    class sessionProc
    extends Thread {
        Socket client = null;
        InputStream inStream = null;
        BufferedReader serverInputReader = null;
        OutputStream outStream = null;

        public sessionProc(Socket s) throws IOException {
            this.client = s;
            this.inStream = this.client.getInputStream();
            this.serverInputReader = new BufferedReader(new InputStreamReader(this.inStream));
            this.outStream = this.client.getOutputStream();
        }

        public void run() {
            String inputLine = null;
            String reply = "";
            try {
                while (!this.serverInputReader.ready()) {
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e1) {
                        break;
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            block15: while (true) {
                try {
                    while (this.serverInputReader.ready()) {
                        try {
                            inputLine = this.serverInputReader.readLine();
                        }
                        catch (IOException e) {
                            JavaServerFrame.this.printlnServerStatus("Couldn't read line.");
                            continue block15;
                        }
                        if (inputLine != null) {
                            JavaServerFrame.this.printlnServerStatus("<RCV> " + inputLine);
                            if (JavaServerFrame.this.listener != null) {
                                if (JavaServerFrame.this.listener.hasHandler()) {
                                    JavaServerFrame.this.printlnServerStatus("Calling Mathematica... ");
                                    JavaServerFrame.this.listener.stringArrived(inputLine);
                                    Expr result = JavaServerFrame.this.listener.getResult();
                                    if (result != null) {
                                        JavaServerFrame.this.printlnServerStatus("Returned Result...");
                                        reply = result.toString();
                                        result.dispose();
                                    }
                                    JavaServerFrame.this.listener.disposeResult();
                                } else {
                                    reply = inputLine.toUpperCase();
                                }
                            } else {
                                reply = inputLine.toUpperCase();
                            }
                            if (reply != null) {
                                reply = new String(reply + "\r\n");
                                try {
                                    this.outStream.write(reply.getBytes());
                                    this.outStream.flush();
                                    JavaServerFrame.this.printlnServerStatus("<SND> " + reply);
                                }
                                catch (IOException e) {
                                    JavaServerFrame.this.printlnServerStatus("Couldn't write");
                                }
                                continue;
                            }
                        }
                        try {
                            Thread.sleep(10L);
                            continue block15;
                        }
                        catch (InterruptedException e1) {
                            break block15;
                        }
                    }
                    break;
                }
                catch (IOException e) {
                    // empty catch block
                    break;
                }
            }
            this.stop();
            try {
                this.client.close();
                JavaServerFrame.this.printlnServerStatus("Closed client socket.\n");
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.client = null;
        }
    }
}

