/*
 * Decompiled with CFR 0.152.
 */
package MathSocket.MathJavaClient.JavaClient;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class JavaClientFrame
extends JFrame {
    private boolean isConnected = false;
    Socket clientSocket = null;
    String serverAddr = "0.0.0.0";
    int serverPort = 2001;
    JScrollPane jScrollPaneClientStatus = new JScrollPane();
    JTextArea jTextAreaClientStatus = new JTextArea();
    JButton jButtonClearClientStatus = new JButton();
    JLabel jLabelServerAddress = new JLabel();
    JLabel jLabelServerPort = new JLabel();
    JTextField jTextFieldServerAddress = new JTextField();
    JTextField jTextFieldServerPort = new JTextField();
    JButton jButtonConnect = new JButton();
    JTextField jTextFieldMessage = new JTextField();
    JLabel jLabelTitle = new JLabel();
    private boolean mShown = false;
    ClientSessionThread sessionThread = null;
    String result = "";

    public boolean connected() {
        return this.isConnected;
    }

    public void initComponents() throws Exception {
        this.jScrollPaneClientStatus.setLocation(new Point(5, 130));
        this.jScrollPaneClientStatus.setAutoscrolls(true);
        this.jScrollPaneClientStatus.setVisible(true);
        this.jScrollPaneClientStatus.setSize(new Dimension(480, 240));
        this.jScrollPaneClientStatus.getViewport().add(this.jTextAreaClientStatus);
        this.jTextAreaClientStatus.setText("Java Client Status");
        this.jTextAreaClientStatus.setVisible(true);
        this.jButtonClearClientStatus.setText("Clear");
        this.jButtonClearClientStatus.setLocation(new Point(215, 380));
        this.jButtonClearClientStatus.setVisible(true);
        this.jButtonClearClientStatus.setOpaque(false);
        this.jButtonClearClientStatus.setSize(new Dimension(80, 30));
        this.jLabelServerAddress.setText("Server Address:");
        this.jLabelServerAddress.setLocation(new Point(35, 50));
        this.jLabelServerAddress.setVisible(true);
        this.jLabelServerAddress.setSize(new Dimension(100, 30));
        this.jLabelServerPort.setText("Server Port:");
        this.jLabelServerPort.setLocation(new Point(265, 50));
        this.jLabelServerPort.setVisible(true);
        this.jLabelServerPort.setSize(new Dimension(80, 30));
        this.jTextFieldServerAddress.setText("127.0.0.1");
        this.jTextFieldServerAddress.setLocation(new Point(145, 50));
        this.jTextFieldServerAddress.setVisible(true);
        this.jTextFieldServerAddress.setSize(new Dimension(90, 30));
        this.jTextFieldServerPort.setText("2001");
        this.jTextFieldServerPort.setLocation(new Point(355, 50));
        this.jTextFieldServerPort.setVisible(true);
        this.jTextFieldServerPort.setSize(new Dimension(90, 30));
        this.jButtonConnect.setText("Connect");
        this.jButtonConnect.setLocation(new Point(405, 90));
        this.jButtonConnect.setVisible(true);
        this.jButtonConnect.setOpaque(false);
        this.jButtonConnect.setSize(new Dimension(80, 30));
        this.jTextFieldMessage.setText("Message");
        this.jTextFieldMessage.setLocation(new Point(5, 90));
        this.jTextFieldMessage.setVisible(true);
        this.jTextFieldMessage.setSize(new Dimension(390, 30));
        this.jLabelTitle.setText("Java Client");
        this.jLabelTitle.setForeground(new Color(0, 102, 153));
        this.jLabelTitle.setLocation(new Point(130, 10));
        this.jLabelTitle.setVisible(true);
        this.jLabelTitle.setFont(new Font("Application", 1, 24));
        this.jLabelTitle.setHorizontalAlignment(0);
        this.jLabelTitle.setSize(new Dimension(260, 30));
        this.setLocation(new Point(5, 40));
        this.setTitle("JavaClient.JavaClientFrame");
        this.getContentPane().setLayout(null);
        this.setSize(new Dimension(490, 416));
        this.getContentPane().add(this.jScrollPaneClientStatus);
        this.getContentPane().add(this.jButtonClearClientStatus);
        this.getContentPane().add(this.jLabelServerAddress);
        this.getContentPane().add(this.jLabelServerPort);
        this.getContentPane().add(this.jTextFieldServerAddress);
        this.getContentPane().add(this.jTextFieldServerPort);
        this.getContentPane().add(this.jButtonConnect);
        this.getContentPane().add(this.jTextFieldMessage);
        this.getContentPane().add(this.jLabelTitle);
        this.jButtonClearClientStatus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaClientFrame.this.jButtonClearClientStatusActionPerformed(e);
            }
        });
        this.jButtonConnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaClientFrame.this.jButtonConnectActionPerformed(e);
            }
        });
        this.jTextFieldMessage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JavaClientFrame.this.jTextFieldMessageActionPerformed(e);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                JavaClientFrame.this.thisWindowClosing(e);
            }
        });
    }

    public void addNotify() {
        super.addNotify();
        if (this.mShown) {
            return;
        }
        JMenuBar jMenuBar = this.getJMenuBar();
        if (jMenuBar != null) {
            int jMenuBarHeight = jMenuBar.getPreferredSize().height;
            Dimension dimension = this.getSize();
            dimension.height += jMenuBarHeight;
            this.setSize(dimension);
        }
        this.mShown = true;
    }

    void thisWindowClosing(WindowEvent e) {
        this.setVisible(false);
        this.dispose();
        System.exit(0);
    }

    public void jButtonConnectActionPerformed(ActionEvent e) {
        if (this.isConnected) {
            this.disconnect();
        } else {
            this.connect();
            this.sendRequest(null);
            this.disconnect();
        }
    }

    public void jButtonClearClientStatusActionPerformed(ActionEvent e) {
        this.jTextAreaClientStatus.setText("");
    }

    public void jTextFieldMessageActionPerformed(ActionEvent e) {
        this.jButtonConnectActionPerformed(e);
    }

    public void printlnClientStatus(String str) {
        Date date = new Date();
        if (date != null) {
            this.jTextAreaClientStatus.append(date.toString() + ": " + str + "\n");
        } else {
            this.jTextAreaClientStatus.append(str + "\n");
        }
    }

    public void connect() {
        if (this.sessionThread != null) {
            return;
        }
        String portTxt = null;
        Integer intObj = null;
        this.serverAddr = this.jTextFieldServerAddress.getText();
        portTxt = this.jTextFieldServerPort.getText();
        intObj = new Integer(portTxt);
        this.serverPort = intObj;
        try {
            this.clientSocket = new Socket(this.serverAddr, this.serverPort);
            this.printlnClientStatus("Client socket created: port = " + String.valueOf(this.clientSocket.getLocalPort()));
        }
        catch (IOException e) {
            this.printlnClientStatus("Couldn't create client socket.");
            return;
        }
        this.printlnClientStatus("Opened connection.");
        this.jButtonConnect.setText("Close");
        this.isConnected = true;
    }

    public String sendRequest(String request) {
        this.sessionThread = new ClientSessionThread(request);
        while (this.sessionThread.isAlive()) {
        }
        String answer = this.result;
        this.result = "";
        return answer;
    }

    public void disconnect() {
        if (this.sessionThread != null) {
            if (this.sessionThread.isAlive()) {
                this.sessionThread.stop();
                this.printlnClientStatus("Stopped session thread.");
            }
            this.sessionThread = null;
        }
        this.printlnClientStatus("Closed connection.");
        this.jButtonConnect.setText("Connect");
        this.isConnected = false;
    }

    class ClientSessionThread
    extends Thread {
        String request = null;

        public ClientSessionThread(String s) {
            this.request = s;
            this.start();
        }

        public void run() {
            BufferedReader clientInputReader;
            block17: {
                OutputStream outStream = null;
                InputStream inStream = null;
                clientInputReader = null;
                try {
                    outStream = JavaClientFrame.this.clientSocket.getOutputStream();
                    inStream = JavaClientFrame.this.clientSocket.getInputStream();
                    clientInputReader = new BufferedReader(new InputStreamReader(inStream));
                }
                catch (IOException e1) {
                    JavaClientFrame.this.printlnClientStatus("Failed to get stream.");
                    if (JavaClientFrame.this.clientSocket != null) {
                        try {
                            JavaClientFrame.this.clientSocket.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                        JavaClientFrame.this.clientSocket = null;
                    }
                    this.stop();
                    return;
                }
                try {
                    String msg = null;
                    msg = this.request == null ? JavaClientFrame.this.jTextFieldMessage.getText() : this.request;
                    msg = new String(msg + "\r\n");
                    if (msg != null) {
                        outStream.write(msg.getBytes());
                        outStream.flush();
                        JavaClientFrame.this.printlnClientStatus("<SND>" + msg);
                        break block17;
                    }
                    this.stop();
                    return;
                }
                catch (IOException e2) {
                    this.stop();
                    return;
                }
            }
            try {
                String reply = null;
                while (!clientInputReader.ready()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e3) {
                        // empty catch block
                    }
                }
                while (clientInputReader.ready()) {
                    reply = clientInputReader.readLine();
                    if (reply != null) {
                        JavaClientFrame.this.printlnClientStatus("<RCV> " + reply);
                        JavaClientFrame.this.result = JavaClientFrame.this.result + reply;
                        continue;
                    }
                    try {
                        Thread.sleep(10L);
                    }
                    catch (InterruptedException e4) {
                        // empty catch block
                    }
                }
                return;
            }
            catch (IOException e5) {
                return;
            }
        }
    }
}

