(*******************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which
typically will have the same name as this file except ending in
".nb" instead of ".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent
to using the Evaluate Initialization Cells menu command in the front
end.

DO NOT EDIT THIS FILE.  This entire file is regenerated
automatically each time the parent Notebook file is saved in the
Mathematica front end.  Any changes you make to this file will be
overwritten.
***********************************************************************)









(* :Title: JavaPhotoEditor *)
(* :Context: JLinkProgramming`JavaPhotoEditor`DIPSupport` *)
(* :Author: Junzo SATO *)
(* :Summary: Functions which uses DIP package are defined. *)
(* :Package Version: 1.0 *)
(* :Release Note: 
        Ver 1.0 Nov 2002 *)
(* :Mathematica Version: 4.1 *)
(* :Copyright: Copyright \[Copyright] 2000-2002, 
  Junzo SATO. All rights reserved. *)
(* :History: Ver 1.0 Nov 2002 *)
(* :Keywords: Java, JavaSwing, JavaPhotoEditor, DigitalImageProcessing *)
(* :Reference: *)
(* :Limitation: *)
(* :Discussion: *)



Off[Needs::nocont]





BeginPackage["JLinkProgramming`JavaPhotoEditor`DIPSupport`",
  {"JLinkProgramming`JavaPhotoEditor`JavaPhotoEditor`",
    "JLink`",
    "ImageProcessing`",
    "ImageProcessing`ImageData`",
    "ImageProcessing`PointOperators`",
    "ImageProcessing`BufferedImage`"
    }]

InstallJava[]

Unprotect[Evaluate[$Context<>"*"]]







GetAreaSelectionBoundsImageData::usage="GetAreaSelectionBoundsImageData[frame]\
 returns selected area as ImageData."

JavaImageToImageData::usage=
    "JavaImageToImageData[javaImage,x,y,width,height] creates ImageData from \
specified javaImage. Top left corner {x,y} and size {width, height} are \
options.";

JavaImageToGrayImageData::usage=
    "JavaImageToGrayImageData[javaImage,x,y,width,height] uses ToGrayLevel[] \
after generating ImageData from javaImage using JavaImageToImageData[].";

ImageDataToLegendJavaImage::usage=
    "ImageDataToLegendJavaImage[imageData] is used on pre-Java2 system to \
create Java Image object from ImageData.";

IsJava2OrLater::usage=
    "IsJava2OrLater[] returns True when Java version is 1.2 or later.";



ImageDataToJavaImage::usage=
    "ImageDataToJavaImage[imageData] creates Java Image from ImageData.";



Begin["`Private`"]

GetAreaSelectionBoundsImageData[frame_]:=Module[
    {rct,panel},
    rct=GetAreaSelectionBounds[frame];
    If[rct===Null||rct==={0,0,0,0},Return[Null]];
    panel=frame@getJpePanel[];
    Return[
      JavaImageToImageData[panel@getImage[],rct[[1]],rct[[2]],rct[[3]],
        rct[[4]]]]
    ]



JavaImageToImageData[img_:JavaObjectQ,x_:0,y_:0,w_:0,h_:0]:=Module[
    {pixels,d,width=w,height=h},
    JavaBlock[
      If[width\[LessEqual]0,width=img@getWidth[]];
      If[height\[LessEqual]0,height=img@getHeight[]];
      ];
    pixels=GrabPixels[img,x,y,width,height];
    ImageData[Reverse[pixels],
      PixelInterleave\[Rule]True,
      ColorFunction\[Rule]RGBColor]
    ]

JavaImageToGrayImageData[img_:JavaObjectQ,x_:0,y_:0,w_:0,h_:0]:=
  ToGrayLevel[JavaImageToImageData[img,x,y,w,h]]



LoadJavaClass["java.lang.System"];
IsJava2OrLater[]:=JavaBlock[Module[
      {txt,major,minor},
      txt=java`lang`System`getProperties[]@getProperty["java.version"];
      {major,minor}=
        Drop[ToExpression["{"<>StringReplace[txt,"."\[Rule]","]<>"}"],-1];
      Return[major+0.1minor>=1.2]
      ]]

color2pix[r_,g_,b_,a_:255]:=
  Round[a]*16777216+Round[r]*65536+Round[g]*256+Round[b]

gray2pix[gr_]:=color2pix[gr,gr,gr]







ImageDataToLegendJavaImage[
    imgData:ImageData[_,opts__?OptionQ]/;(PixelInterleave/.{opts})===None]:=
  Module[
    {pixels,imageW,imageH,model,bitmap,image},
    {imageH,imageW}=ImageDimensions[imgData];
    pixels=Map[
        gray2pix,
        Evaluate[Flatten[Reverse[imgData[[1]]]]]
        ];
    (**)
    pixels=Map[toSINT32,pixels];(*signed*)
    model=JavaNew["java.awt.image.DirectColorModel",32,0,0,0,255];
    bitmap=
      JavaNew["java.awt.image.MemoryImageSource",imageW,imageH,model,pixels,0,
        imageW];
    image=Toolkit`getDefaultToolkit[]@createImage[bitmap];
    ReleaseObject[model];
    ReleaseObject[bitmap];
    Return[image]
    ]



ImageDataToLegendJavaImage[
    imgData:ImageData[_,opts__?OptionQ]/;(PixelInterleave/.{opts})===True]:=
  Module[
    {pixels,imageW,imageH,model,bitmap,image},
    {imageH,imageW}=ImageDimensions[imgData];
    pixels=Map[
        Apply[color2pix,#]&,
        Evaluate[Flatten[Reverse[imgData[[1]]],1]]
        ];
    (**)
    pixels=Map[toSINT32,pixels];(*signed*)
    model=JavaNew["java.awt.image.DirectColorModel",32,0,0,0,255];
    bitmap=
      JavaNew["java.awt.image.MemoryImageSource",imageW,imageH,model,pixels,0,
        imageW];
    image=Toolkit`getDefaultToolkit[]@createImage[bitmap];
    ReleaseObject[model];
    ReleaseObject[bitmap];
    Return[image]
    ]



ImageDataToLegendJavaImage[
    imgData:ImageData[_,opts__?OptionQ]/;(PixelInterleave/.{opts})===False]:=
  Module[
    {pixels,imageW,imageH,model,bitmap,image},
    {imageH,imageW}=ImageDimensions[imgData];
    pixels=Map[
        Apply[color2pix,#]&,
        Evaluate[Flatten[Reverse[MeshedImageData[imgData][[1]]],1]]
        ];
    (**)
    pixels=Map[toSINT32,pixels];(*signed*)
    model=JavaNew["java.awt.image.DirectColorModel",32,0,0,0,255];
    bitmap=
      JavaNew["java.awt.image.MemoryImageSource",imageW,imageH,model,pixels,0,
        imageW];
    image=Toolkit`getDefaultToolkit[]@createImage[bitmap];
    ReleaseObject[model];
    ReleaseObject[bitmap];
    Return[image]
    ]



















ImageDataToJavaImage[imgData_]:=If[IsJava2OrLater[],
    ImageDataToBufferedImage[imgData],
    ImageDataToLegendJavaImage[imgData]
    ]



End[]



EndPackage[]

On[Needs::nocont]