(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     23181,        780]*)
(*NotebookOutlinePosition[     24026,        807]*)
(*  CellTagsIndexPosition[     23982,        803]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Style Definitions", "Subtitle"],

Cell["\<\
Modify the definitions below to change the default appearance of \
all cells in a given style.
Make modifications to any definition using commands in the Format menu.\
\>", \
"Text"],

Cell[CellGroupData[{

Cell["Style Environment Names", "Section"],

Cell[StyleData[All, "Working"],
  CellBracketOptions->{"Color"->RGBColor[0.771908, 0.399634, 0.262867]},
  ScriptMinSize->9],

Cell[StyleData[All, "Printout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}],

Cell[StyleData[All, "ColorPrintout"],
  PageWidth->PaperWidth,
  PrivateFontOptions->{"FontType"->"Outline"}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Notebook Options", "Section"],

Cell["\<\
The options defined for the style below will be used at the \
Notebook level.\
\>", "Text"],

Cell[StyleData["Notebook"],
  PageHeaders->{{Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"], None, Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"]}, {Cell[ 
          TextData[ {
            ValueBox[ "FileName"]}], "Header"], None, Cell[ 
          TextData[ {
            CounterBox[ "Page"]}], "PageNumber"]}},
  StyleMenuListing->None,
  Background->RGBColor[0.720516, 0.926879, 0.809964]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Styles for Headings", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Title"],
  CellMargins->{{36, 20}, {2, 10}},
  CellGroupingRules->{"TitleGrouping", 0},
  PageBreakBelow->False,
  CellFrameMargins->{{100, 4}, {8, 10}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  TextAlignment->Center,
  LineSpacing->{1, -5},
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}},
  FontSize->60,
  FontSlant->"Italic",
  FontColor->RGBColor[0.520516, 0.66688, 0.889967]],

Cell[StyleData["Title", "Printout"],
  TextAlignment->Center,
  FontSize->48,
  FontColor->GrayLevel[0.4]],

Cell[StyleData["Title", "ColorPrintout"],
  TextAlignment->Center,
  FontSize->48]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subtitle"],
  CellMargins->{{144, 20}, {2, 10}},
  CellGroupingRules->{"TitleGrouping", 10},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  TextAlignment->Center,
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}},
  FontSize->24,
  FontSlant->"Italic",
  FontColor->RGBColor[0.326787, 0.658763, 0.400732]],

Cell[StyleData["Subtitle", "Printout"],
  TextAlignment->Center,
  FontSize->18,
  FontColor->GrayLevel[0.300008]],

Cell[StyleData["Subtitle", "ColorPrintout"],
  TextAlignment->Center,
  FontSize->18]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subsubtitle"],
  CellMargins->{{144, 20}, {2, 2}},
  CellGroupingRules->{"TitleGrouping", 20},
  PageBreakBelow->False,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  TextAlignment->Center,
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}},
  FontFamily->"Helvetica",
  FontSize->14,
  FontSlant->"Italic"],

Cell[StyleData["Subsubtitle", "Printout"],
  TextAlignment->Center,
  FontSize->12],

Cell[StyleData["Subsubtitle", "ColorPrintout"],
  TextAlignment->Center,
  FontSize->12]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Section"],
  CellFrame->{{0, 0}, {0, 0.25}},
  CellMargins->{{36, 20}, {10, 20}},
  CellGroupingRules->{"SectionGrouping", 30},
  PageBreakBelow->False,
  CellFrameMargins->{{10, 4}, {6, 2}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}},
  FontSize->14,
  FontWeight->"Bold",
  FontColor->RGBColor[0.771908, 0.399634, 0.262867]],

Cell[StyleData["Section", "Printout"],
  FontSize->14,
  FontColor->GrayLevel[0.300008]],

Cell[StyleData["Section", "ColorPrintout"],
  FontSize->14]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subsection"],
  CellDingbat->"\[FilledSmallSquare]",
  CellMargins->{{36, 20}, {Inherited, 18}},
  CellGroupingRules->{"SectionGrouping", 40},
  PageBreakBelow->False,
  CellFrameMargins->{{2, 12}, {0, 12}},
  CellFrameLabelMargins->6,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}},
  FontSize->12,
  FontWeight->"Bold"],

Cell[StyleData["Subsection", "Printout"]],

Cell[StyleData["Subsection", "ColorPrintout"]]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Subsubsection"],
  CellDingbat->"\[EmptySquare]",
  CellMargins->{{36, Inherited}, {Inherited, 12}},
  CellGroupingRules->{"SectionGrouping", 50},
  PageBreakBelow->False,
  CellFrameLabelMargins->6,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  CounterIncrements->"Subsubsection",
  FontFamily->"Helvetica",
  FontSize->10],

Cell[StyleData["Subsubsection", "Printout"]],

Cell[StyleData["Subsubsection", "ColorPrintout"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Styles for Body Text", "Section"],

Cell[CellGroupData[{

Cell[StyleData["Text"],
  CellFrame->False,
  CellMargins->{{36, 20}, {4, 4}},
  CellFrameMargins->{{4, 10}, {6, 0}},
  CellFrameLabelMargins->4,
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  Hyphenation->True,
  LineSpacing->{1, 6},
  CounterIncrements->"Text"],

Cell[StyleData["Text", "Printout"],
  LineSpacing->{1, 5},
  FontSize->10],

Cell[StyleData["Text", "ColorPrintout"],
  LineSpacing->{1, 5},
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["SmallText"],
  CellMargins->{{100, 38}, {4, 4}},
  InputAutoReplacements->{"TeX"->StyleBox[ 
          RowBox[ {"T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "LaTeX"->StyleBox[ 
          RowBox[ {"L", 
            StyleBox[ 
              AdjustmentBox[ 
              "A", BoxMargins -> {{-0.36, -0.1}, {0, -0}}, 
                BoxBaselineShift -> -0.2], FontSize -> Smaller], "T", 
            AdjustmentBox[ 
            "E", BoxMargins -> {{-0.075, -0.085}, {0, 0}}, BoxBaselineShift -> 
              0.5], "X"}]], "mma"->"Mathematica", "Mma"->"Mathematica", 
      "MMA"->"Mathematica"},
  Hyphenation->True,
  LineSpacing->{1.25, 1},
  CounterIncrements->"SmallText",
  FontSize->10],

Cell[StyleData["SmallText", "Printout"],
  FontSize->9],

Cell[StyleData["SmallText", "ColorPrintout"],
  FontSize->9]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Styles for Input/Output", "Section"],

Cell["\<\
The cells in this section define styles used for input and output \
to the kernel.  Be careful when modifying, renaming, or removing these \
styles, because the front end associates special meanings with these style \
names.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Input"],
  CellMargins->{{36, 0}, {0, Inherited}},
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultInputFormatType,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  LinebreakAdjustments->{0.85, 2, 10, 0, 1},
  CounterIncrements->"Input",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->None],

Cell[StyleData["Input", "Printout"],
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->10],

Cell[StyleData["Input", "ColorPrintout"],
  LinebreakAdjustments->{0.85, 2, 10, 1, 1},
  FontSize->10]
}, Open  ]],

Cell[StyleData["InlineInput"],
  Evaluatable->True,
  CellGroupingRules->"InputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  DefaultFormatType->DefaultInputFormatType,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  AutoItalicWords->{},
  FormatType->InputForm,
  ShowStringCharacters->True,
  NumberMarks->True,
  CounterIncrements->"Input",
  FontWeight->"Bold",
  Background->None],

Cell[CellGroupData[{

Cell[StyleData["Output"],
  CellMargins->{{36, 0}, {Inherited, 0}},
  CellEditDuplicate->True,
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  LanguageCategory->"Formula",
  FormatType->InputForm,
  CounterIncrements->"Output",
  FontColor->GrayLevel[0],
  Background->None],

Cell[StyleData["Output", "Printout"],
  FontSize->10],

Cell[StyleData["Output", "ColorPrintout"],
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Message"],
  CellDingbat->"\[LongDash]",
  CellMargins->{{64, Inherited}, {Inherited, Inherited}},
  CellGroupingRules->"OutputGrouping",
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  CounterIncrements->"Message",
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->10,
  FontSlant->"Oblique",
  Background->None],

Cell[StyleData["Message", "Printout"],
  FontSize->8],

Cell[StyleData["Message", "ColorPrintout"],
  FontSize->8]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Print"],
  CellMargins->{{36, 20}, {3, 3}},
  CellGroupingRules->"OutputGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GroupPageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  CellLabelMargins->{{3, Inherited}, {Inherited, Inherited}},
  DefaultFormatType->DefaultOutputFormatType,
  TextAlignment->Left,
  HyphenationOptions->{"HyphenationCharacter"->"\[Continuation]"},
  FormatType->InputForm,
  CounterIncrements->"Print",
  StyleMenuListing->None,
  Background->None],

Cell[StyleData["Print", "Printout"],
  FontSize->10],

Cell[StyleData["Print", "ColorPrintout"],
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["Graphics"],
  CellMargins->{{36, 0}, {0, 0}},
  CellGroupingRules->"GraphicsGrouping",
  CellHorizontalScrolling->True,
  PageBreakWithin->False,
  GeneratedCell->True,
  CellAutoOverwrite->True,
  ShowCellLabel->False,
  DefaultFormatType->DefaultOutputFormatType,
  FormatType->InputForm,
  CounterIncrements->"Graphics",
  ImageMargins->{{35, Inherited}, {Inherited, 0}},
  Background->None],

Cell[StyleData["Graphics", "Printout"],
  FontSize->10],

Cell[StyleData["Graphics", "ColorPrintout"],
  FontSize->10]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["CellLabel"],
  StyleMenuListing->None,
  FontFamily->"Helvetica",
  FontSize->9,
  FontColor->RGBColor[0.551492, 0.231144, 0.313466],
  Background->None],

Cell[StyleData["CellLabel", "Printout"],
  FontSize->8,
  FontColor->GrayLevel[0]],

Cell[StyleData["CellLabel", "ColorPrintout"],
  FontSize->8]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Hyperlink Styles", "Section"],

Cell["\<\
The cells below define styles useful for making hypertext \
ButtonBoxes.  The \"Hyperlink\" style is for links within the same Notebook, \
or between Notebooks.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["Hyperlink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookLocate[ #2]}]&),
  Active->True,
  ButtonNote->ButtonData}],

Cell[StyleData["Hyperlink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["Hyperlink", "ColorPrintout"],
  FontSize->10,
  FontVariations->{"Underline"->False}]
}, Open  ]],

Cell["\<\
The following styles are for linking automatically to the on-line \
help system.\
\>", "Text"],

Cell[CellGroupData[{

Cell[StyleData["MainBookLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "MainBook", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["MainBookLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["MainBookLink", "ColorPrintout"],
  FontSize->10,
  FontVariations->{"Underline"->False}]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["AddOnsLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "AddOns", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["AddOnsLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["AddOnsLink", "ColorPrintout"],
  FontSize->10,
  FontVariations->{"Underline"->False}]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["RefGuideLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontFamily->"Courier",
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "RefGuide", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["RefGuideLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["RefGuideLink", "ColorPrintout"],
  FontSize->10,
  FontVariations->{"Underline"->False}]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["GettingStartedLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "GettingStarted", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["GettingStartedLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["GettingStartedLink", "ColorPrintout"],
  FontSize->10,
  FontVariations->{"Underline"->False}]
}, Open  ]],

Cell[CellGroupData[{

Cell[StyleData["OtherInformationLink"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  FontColor->RGBColor[0, 0, 1],
  FontVariations->{"Underline"->True},
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`HelpBrowserLookup[ "OtherInformation", #]}]&),
  Active->True,
  ButtonFrame->"None"}],

Cell[StyleData["OtherInformationLink", "Printout"],
  FontSize->10,
  FontColor->GrayLevel[0],
  FontVariations->{"Underline"->False}],

Cell[StyleData["OtherInformationLink", "ColorPrintout"],
  FontSize->10,
  FontVariations->{"Underline"->False}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Palette Styles", "Section"],

Cell["\<\
The cells below define styles that define standard ButtonFunctions, \
for use in palette buttons.\
\>", "Text"],

Cell[StyleData["Paste"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, After]}]&)}],

Cell[StyleData["Evaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["EvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionMove[ 
        FrontEnd`InputNotebook[ ], All, Cell, 1], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluate"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluate[ 
        FrontEnd`InputNotebook[ ], All]}]&)}],

Cell[StyleData["CopyEvaluateCell"],
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic,
  ButtonBoxOptions->{ButtonFunction:>(FrontEndExecute[ {
      FrontEnd`SelectionCreateCell[ 
        FrontEnd`InputNotebook[ ], All], 
      FrontEnd`NotebookApply[ 
        FrontEnd`InputNotebook[ ], #, All], 
      FrontEnd`SelectionEvaluateCreateCell[ 
        FrontEnd`InputNotebook[ ], All]}]&)}]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 1024}, {0, 748}},
WindowSize->{520, 626},
WindowMargins->{{16, Automatic}, {Automatic, 40}},
MacintoshSystemPageSetup->"\<\
0080001804P000000bH2;oo^onh3>091P0<5NP?P0040009H0UP000006SXB=000
0000I0000000000000000BL?00400@0000000000000004e<BE00000000000000
000000006H4J0001000000RP001A00H0\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 37, 0, 62, "Subtitle"],
Cell[1779, 53, 192, 5, 46, "Text"],

Cell[CellGroupData[{
Cell[1996, 62, 42, 0, 50, "Section"],
Cell[2041, 64, 124, 2, 37, 31, 0, "StyleData", "All", "Working"],
Cell[2168, 68, 104, 2, 37, 32, 0, "StyleData", "All", "Printout"],
Cell[2275, 72, 109, 2, 37, 37, 0, "StyleData", "All", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2421, 79, 35, 0, 50, "Section"],
Cell[2459, 81, 101, 3, 30, "Text"],
Cell[2563, 86, 452, 11, 53, 27, 0, "StyleData", "Notebook", "All",
  StyleMenuListing->None]
}, Open  ]],

Cell[CellGroupData[{
Cell[3052, 102, 38, 0, 50, "Section"],

Cell[CellGroupData[{
Cell[3115, 106, 1099, 26, 94, 24, 0, "StyleData", "Title", "All",
  CounterIncrements->"Title",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subtitle", 0}, {"Subsubtitle", 0}}],
Cell[4217, 134, 106, 3, 82, 36, 0, "StyleData", "Title", "Printout"],
Cell[4326, 139, 82, 2, 82, 41, 0, "StyleData", "Title", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4445, 146, 1026, 24, 56, 27, 0, "StyleData", "Subtitle", "All",
  CounterIncrements->"Subtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}, {
      "Subsubtitle", 0}}],
Cell[5474, 172, 114, 3, 49, 39, 0, "StyleData", "Subtitle", "Printout"],
Cell[5591, 177, 85, 2, 49, 44, 0, "StyleData", "Subtitle", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5713, 184, 978, 23, 37, 30, 0, "StyleData", "Subsubtitle", "All",
  CounterIncrements->"Subsubtitle",
  CounterAssignments->{{"Section", 0}, {"Equation", 0}, {"Figure", 0}}],
Cell[6694, 209, 83, 2, 35, 42, 0, "StyleData", "Subsubtitle", "Printout"],
Cell[6780, 213, 88, 2, 35, 47, 0, "StyleData", "Subsubtitle", \
"ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6905, 220, 1039, 24, 65, 26, 0, "StyleData", "Section", "All",
  CounterIncrements->"Section",
  CounterAssignments->{{"Subsection", 0}, {"Subsubsection", 0}}],
Cell[7947, 246, 88, 2, 65, 38, 0, "StyleData", "Section", "Printout"],
Cell[8038, 250, 59, 1, 65, 43, 0, "StyleData", "Section", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8134, 256, 1014, 24, 53, 29, 0, "StyleData", "Subsection", "All",
  CounterIncrements->"Subsection",
  CounterAssignments->{{"Subsubsection", 0}}],
Cell[9151, 282, 41, 0, 53, 41, 0, "StyleData", "Subsection", "Printout"],
Cell[9195, 284, 46, 0, 53, 46, 0, "StyleData", "Subsection", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9278, 289, 940, 22, 44, 32, 0, "StyleData", "Subsubsection", "All",
  CounterIncrements->"Subsubsection"],
Cell[10221, 313, 44, 0, 44, 44, 0, "StyleData", "Subsubsection", "Printout"],
Cell[10268, 315, 49, 0, 44, 49, 0, "StyleData", "Subsubsection", \
"ColorPrintout"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10366, 321, 39, 0, 50, "Section"],

Cell[CellGroupData[{
Cell[10430, 325, 862, 21, 37, 23, 0, "StyleData", "Text", "All",
  CounterIncrements->"Text"],
Cell[11295, 348, 74, 2, 36, 35, 0, "StyleData", "Text", "Printout"],
Cell[11372, 352, 79, 2, 36, 40, 0, "StyleData", "Text", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11488, 359, 805, 19, 36, 28, 0, "StyleData", "SmallText", "All",
  CounterIncrements->"SmallText"],
Cell[12296, 380, 55, 1, 35, 40, 0, "StyleData", "SmallText", "Printout"],
Cell[12354, 383, 60, 1, 35, 45, 0, "StyleData", "SmallText", "ColorPrintout"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12463, 390, 42, 0, 50, "Section"],
Cell[12508, 392, 248, 5, 62, "Text"],

Cell[CellGroupData[{
Cell[12781, 401, 640, 18, 35, 24, 0, "StyleData", "Input", "All",
  CounterIncrements->"Input"],
Cell[13424, 421, 97, 2, 32, 36, 0, "StyleData", "Input", "Printout"],
Cell[13524, 425, 102, 2, 32, 41, 0, "StyleData", "Input", "ColorPrintout"]
}, Open  ]],
Cell[13641, 430, 462, 14, 39, 30, 0, "StyleData", "InlineInput", "All",
  CounterIncrements->"Input"],

Cell[CellGroupData[{
Cell[14128, 448, 582, 16, 33, 25, 0, "StyleData", "Output", "All",
  CounterIncrements->"Output"],
Cell[14713, 466, 53, 1, 32, 37, 0, "StyleData", "Output", "Printout"],
Cell[14769, 469, 58, 1, 32, 42, 0, "StyleData", "Output", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14864, 475, 629, 18, 36, 26, 0, "StyleData", "Message", "All",
  CounterIncrements->"Message",
  StyleMenuListing->None],
Cell[15496, 495, 53, 1, 33, 38, 0, "StyleData", "Message", "Printout"],
Cell[15552, 498, 58, 1, 33, 43, 0, "StyleData", "Message", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15647, 504, 561, 16, 35, 24, 0, "StyleData", "Print", "All",
  CounterIncrements->"Print",
  StyleMenuListing->None],
Cell[16211, 522, 52, 1, 34, 36, 0, "StyleData", "Print", "Printout"],
Cell[16266, 525, 57, 1, 34, 41, 0, "StyleData", "Print", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16360, 531, 410, 12, 29, 27, 0, "StyleData", "Graphics", "All",
  CounterIncrements->"Graphics"],
Cell[16773, 545, 55, 1, 28, 39, 0, "StyleData", "Graphics", "Printout"],
Cell[16831, 548, 60, 1, 28, 44, 0, "StyleData", "Graphics", "ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16928, 554, 169, 5, 35, 28, 0, "StyleData", "CellLabel", "All",
  StyleMenuListing->None],
Cell[17100, 561, 82, 2, 33, 40, 0, "StyleData", "CellLabel", "Printout"],
Cell[17185, 565, 60, 1, 33, 45, 0, "StyleData", "CellLabel", "ColorPrintout"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17294, 572, 35, 0, 30, "Section"],
Cell[17332, 574, 184, 4, 52, "Text"],

Cell[CellGroupData[{
Cell[17541, 582, 302, 8, 40, 28, 0, "StyleData", "Hyperlink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[17846, 592, 123, 3, 37, 40, 0, "StyleData", "Hyperlink", "Printout"],
Cell[17972, 597, 101, 2, 37, 45, 0, "StyleData", "Hyperlink", \
"ColorPrintout"]
}, Open  ]],
Cell[18088, 602, 104, 3, 30, "Text"],

Cell[CellGroupData[{
Cell[18217, 609, 316, 8, 40, 31, 0, "StyleData", "MainBookLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[18536, 619, 126, 3, 37, 43, 0, "StyleData", "MainBookLink", "Printout"],
Cell[18665, 624, 104, 2, 37, 48, 0, "StyleData", "MainBookLink", \
"ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18806, 631, 337, 9, 40, 29, 0, "StyleData", "AddOnsLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19146, 642, 124, 3, 36, 41, 0, "StyleData", "AddOnsLink", "Printout"],
Cell[19273, 647, 102, 2, 36, 46, 0, "StyleData", "AddOnsLink", \
"ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19412, 654, 341, 9, 37, 31, 0, "StyleData", "RefGuideLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[19756, 665, 126, 3, 36, 43, 0, "StyleData", "RefGuideLink", "Printout"],
Cell[19885, 670, 104, 2, 36, 48, 0, "StyleData", "RefGuideLink", \
"ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20026, 677, 328, 8, 37, 37, 0, "StyleData", "GettingStartedLink", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20357, 687, 132, 3, 36, 49, 0, "StyleData", "GettingStartedLink", \
"Printout"],
Cell[20492, 692, 110, 2, 36, 54, 0, "StyleData", "GettingStartedLink", \
"ColorPrintout"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20639, 699, 332, 8, 37, 39, 0, "StyleData", "OtherInformationLink", \
"All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[20974, 709, 134, 3, 36, 51, 0, "StyleData", "OtherInformationLink", \
"Printout"],
Cell[21111, 714, 112, 2, 36, 56, 0, "StyleData", "OtherInformationLink", \
"ColorPrintout"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21272, 722, 33, 0, 50, "Section"],
Cell[21308, 724, 121, 3, 30, "Text"],
Cell[21432, 729, 226, 5, 37, 24, 0, "StyleData", "Paste", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[21661, 736, 295, 7, 37, 27, 0, "StyleData", "Evaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[21959, 745, 400, 9, 37, 31, 0, "StyleData", "EvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[22362, 756, 387, 9, 37, 31, 0, "StyleData", "CopyEvaluate", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic],
Cell[22752, 767, 401, 9, 37, 35, 0, "StyleData", "CopyEvaluateCell", "All",
  StyleMenuListing->None,
  ButtonStyleMenuListing->Automatic]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

