(*******************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which
typically will have the same name as this file except ending in
".nb" instead of ".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent
to using the Evaluate Initialization Cells menu command in the front
end.

DO NOT EDIT THIS FILE.  This entire file is regenerated
automatically each time the parent Notebook file is saved in the
Mathematica front end.  Any changes you make to this file will be
overwritten.
***********************************************************************)









(* :Title: JavaSwing *)
(* :Context: JLinkProgramming`JavaSwing`JavaSwing` *)
(* :Author: Junzo SATO *)
(* :Summary: 
      This package provides wrapper functions to use JavaSwing components \
within MATHEMATICA. *)
(* :Package Version: 1.1.5 *)
(* :Release Note:
        Ver 1.0 Sep 2000 for JLink 1.0.1
      Ver 1.1 Feb 2001 for JLink 1.1.2
      Ver 1.1.1 Sep 2001 for JLinkProgramming`JLinkSupport`.
          Reproduced with Mathematica 4.1 in Jul 2001 
      Ver 1.1.2 Oct 2001 NewJInternalFrame is modified to make it visible. 
          Ver 1.1.3 Feb 2002 $JavaSwingMaterial supports MacOS X
      Ver 1.1.4 Aug 2002 JLink 2.0.1 
        Ver 1.1.5 Nov 2002 LoadJavaSwingClasses[] were added instead of \
loading classes at the beginning of the package.*)
(* :Mathematica Version: 4.1 *)
(* :Copyright: Copyright \[Copyright] 2000-2002, 
  Junzo Sato. All rights reserved. *)
(* :History:
      Ver 1.0 Sep 2000 for JLink 1.0.1
        Ver 1.1 Feb 2001 for JLink 1.1.2
        Ver 1.1.4 Aug 2002 for JLink 2.0.1 *)
(* :Keywords: Java, Swing, JavaSwing *)
(* :Reference: [1] "Pure JFC Swing" by Satyaraj Pantham, 1999, 
  Sams Publishing *)
(* :Limitation: *)
(* :Discussion: *)

Print["Loading JavaSwing..."]



BeginPackage["JLinkProgramming`JavaSwing`JavaSwing`",{"JLink`"}]

InstallJava[]





Unprotect[Evaluate[$Context<>"*"]]



$JavaSwingMaterial:=StringJoin[
    Switch[$OperatingSystem,
      "Unix",
      $TopDirectory,
      "MacOS",
      StringJoin["/",StringReplace[$TopDirectory,":"\[Rule]"/"]],
      "MacOSX",
      StringJoin[$InitialDirectory,"/Library/Mathematica/",
        ToString[$VersionNumber]],
      _,
      If[StringMatchQ[$OperatingSystem,"Windows*"],
        StringReplace[$TopDirectory,{"C:\\"\[Rule]"/","\\"->"/"}],
        $TopDirectory]
      ],
    "/AddOns/Applications/JLinkProgramming/JavaSwing/Material/"]



LoadJavaSwingClasses::usage=
    "LoadJavaSwingClasses[] preloads most of JFC Swing classes using \
LoadJavaClass[].";

SleepThread::usage="SleepThread[msec] sleeps specified milliseconds.";

FindChar::usage=
    "FindChar[x] returns a first character code of x using ToCharacterCode[] \
if the x is a String. Otherwise, it returns a character using \
FromCharacterCode[]";



DeleteJObject::usage=
    "DeleteJObject[container,obj,doRepaint] removes an obj from the \
container.If doRepaint is True, it sends repaint() message to the container.";

NewMathJFrame::usage=
    "NewMathJFrame[title,w,h,x,y] creates a MathJFrame object with the \
specified title, sets the location of the frame to {x,y}, and resize the \
frame to {w,h}. Where {x,y} is the top left corner of the frame on the \
current graphics coordinates and {w,h} is {width,height} of the frame. By \
default, {x,y} is {0,0}.";

CenterizeFrameOnScreen::usage=
    "CenterizeFrameOnScreen[frame] locates the frame to the center of the \
main screen.";

NewImageIcon::usage=
    "NewImageIcon[path] creates an ImageIcon from the specified file.";

swTop::usage="javax`swing`SwingConstants`TOP";
swLeft::usage="javax`swing`SwingConstants`LEFT";
swBottom::usage="javax`swing`SwingConstants`BOTTOM";
swRight::usage="javax`swing`SwingConstants`RIGHT";
swNorth::usage="javax`swing`SwingConstants`NORTH";
swNorthEast::usage="javax`swing`SwingConstants`NORTHUEAST";
swEast::usage="javax`swing`SwingConstants`EAST";
swSouthEast::usage="javax`swing`SwingConstants`SOUTHUEAST";
swSouth::usage="javax`swing`SwingConstants`SOUTH";
swSouthWest::usage="javax`swing`SwingConstants`SOUTHUWEST";
swWest::usage="javax`swing`SwingConstants`WEST";
swNothWest::usage="javax`swing`SwingConstants`NORTHUWEST";
swCenter::usage="javax`swing`SwingConstants`CENTER";
swHorizontal::usage="javax`swing`SwingConstants`HORIZONTAL";
swVertical::usage="javax`swing`SwingConstants`VERTICAL";

NewJDesktopPane::usage=
    "NewJDesktopPane[container,tip] creates a JDesktopPane object. If the \
container isn't null, the object is added to the container. The tip is a tool \
tip text.";

NewJInternalFrame::usage=
    "NewJInternalFrame[container,layerConst,title,x,y,width,height,resizable,\
closable,maximizable,iconifiable,icon,tip] creates a JInternalFrame object \
with the specified title. By default, the location {x,y} is set to {0,0}, the \
size {height,width} is {0,0}, the flags {resizable, closable, maximizable, \
iconifiable} are all True, and the frame icon icon is Null. The tip is a tool \
tip text.";

NewJSplitPane::usage=
    "NewJSplitPane[container,orientation,continuous,dividerSize,tip] creates \
a JSplitPane object with parameters orientation and continuous. If the \
container is not null, the object is added to it. By default, orientation is \
set to javax`swing`JSplitPane`VERTICALUSPLIT, continuous is True, and \
dividerSize is 8. The tip is a tool tip text.";

NewJTabbedPane::usage=
    "NewJTabbedPane[container,placement,tip] creates a JTabbledPane object \
with the specified tab placement. If the container is not null, the object is \
added to it. By default, the placement is set to javax`swing`JTabbedPane`TOP. \
The tip is a tool tip text.";

NewJLabel::usage=
    "NewJLabel[container,title,icon,x,y,width,height,horizontalAlignment,tip] \
creates a JLabel object with the specified title. If the container is not \
null, the object is added to it. By default, the icon is null. The bounds \
{x,y,width,height} is set when both width and height are positive. The tip is \
a tool tip text.";

NewJPanelEmptyBorder::usage=
    "NewJPanelEmptyBorder[container,top,left,bottom,right,tip,addLabel] \
creates a JPanel object with the EmptyBorder. If the container is not null, \
the object is added to it. The default insets {top,left,bottom.right} is set \
to {1,1,1,1}. The tip is a tool tip text. The flag addLabel is set to False. \
When it is set to True, a JLabel which has a border name is added to the \
panel.";

NewJPanelEtchedBorder::usage=
    "NewJPanelEtchedBorder[container,isRaised,highlight,shadow,tip,addLabel] \
creates a JPanel with the EtchedBorder. If the container is not null, the \
object is added to it. By default, the etch type flag isRaised is set to \
True. When two colors highlight and shadow are not null, these colors are \
applied. The flag addLabel is set to False. When it is set to True, a JLabel \
which has a border name is added to the panel.";

NewJPanelBevelBorder::usage=
    "NewJPanelBevelBorder[container,isRaised,highlightOuter,highlightInner,\
shadowOuter,shadowInner,tip,addLabel] creates a JPanel with the BevelBorder. \
If the container is not null, the object is added to it. By default, the etch \
type flag isRaised is set to True. When colors for highlight {highlightOuter, \
highlightInner} and/or shadow {shadowOuter, shadowInner} are not null, these \
colors are applied. The flag addLabel is set to False. When it is set to \
True, a JLabel which has a border name is added to the panel.";

NewJPanelSoftBevelBorder::usage=
    "NewJPanelSoftBevelBorder[container,isRaised,highlightOuter,\
highlightInner,shadowOuter,shadowInner,tip,addLabel] creates a JPanel with \
the SoftBevelBorder. If the container is not null, the object is added to it. \
By default, the etch type flag isRaised is set to True. When colors for \
highlight {highlightOuter, highlightInner} and/or shadow {shadowOuter, \
shadowInner} are not null, these colors are applied. The flag addLabel is set \
to False. When it is set to True, a JLabel which has a border name is added \
to the panel.";

NewJPanelMatteBorder::usage=
    "NewJPanelMatteBorder[container,top,left,bottom,right,color,tip,addLabel] \
creates a JPanel object with the MatteBorder. If the container is not null, \
the object is added to it. By default, the border insets \
{top,left,bottom,right} are set to {4,4,4,4}. The matte color is set to \
java`awt`Color`gray. The tip a tool tip text. The flag addLabel is set to \
False. When it is set to True, a JLabel which has a border name is added to \
the panel.";

NewJPanelMatteBorderTileIcon::usage=
    "NewJPanelMatteBorderTileIcon[container,titleIcon,tip,addLabel] creates a \
JPanel object with the MatteBorder which has the titleIcon. If the container \
is not null, the object is added to it. The tip is a tool tip text. The flag \
addLabel is set to False. When it is set to True, a JLabel which has a border \
name is added to the panel.";

NewJPanelLineBorder::usage=
    "NewJPanelLineBorder[container,thickness,color,tip,addLabel] creates a \
JPanel object with the LineBorder. If the container is not null, the object \
is added to it. By default, the thickness is set to 1 and the color is \
java`awt`Color`gray. The tip is a tool tip text. The flag addLabel is set to \
False. When it is set to True, a JLabel which has a border name is added to \
the panel.";

NewJPanelCompoundBorder::usage=
    "NewJPanelCompoundBorder[container,outsideBorder,insideBorder,tip,\
addLabel] creates a JPanel object with the CompoundBorder. If the container \
is not null, the object is added to it. When both outsizeBorder and \
insideBorder are not null, the object is constructed with these two borders. \
The tip is a tool tip text. The flag addLabel is set to False. When it is set \
to True, a JLabel which has a border name is added to the panel.";

NewJPanelTitledBorder::usage=
    "NewJPanelTitledBorder[container,title,border,tip,addLabel] creates a \
JPanel object with the TitledBorder whose title string is assigned in the \
parmeter title. If the border is not null, the object which has the border is \
constructed. The tip is a tool tip text. The flag addLabel is set to False. \
When it is set to True, a JLabel which has a border name is added to the \
panel.";

NewJButton::usage=
    "NewJButton[container,title,icon,x,y,width,height,tip] creates a JButton \
object with the specified title. If the container is not null, the object is \
added to it. If the icon is not null, it is added to the object. When both \
width and height are positive, the bounds of the button is set. By default, \
the location {x,y} of the object is {0,0}. The tip is a tool tip text.";

NewJToggleButton::usage=
    "NewJToggleButton[container,title,selected,icon,x,y,width,height,tip] \
creates a JToggleButton object with the specified title. If the container is \
not null, the object is added to it. The default value of the flag selected \
is False. If the icon is not null, it is added to the object. When both width \
and height are positive, the bounds of the button is set. By default, the \
location {x,y} of the object is {0,0}. The tip is a tool tip text.";

NewJCheckBox::usage=
    "NewJCheckBox[container,title,selected,icon,x,y,width,height,tip] creates \
a NewJCheckBox object with the specified title. If the container is not null, \
the object is added to it. The default value of the flag selected is False. \
If the icon is not null, it is added to the object. When both width and \
height are positive, the bounds of the button is set. By default, the \
location {x,y} of the object is {0,0}. The tip is a tool tip text.";

NewJRadioButton::usage=
    "NewJRadioButton[container,title,selected,icon,x,y,width,height,tip] \
creates a NewJRadioButton object with the specified title. If the container \
is not null, the object is added to it. The default value of the flag \
selected is False. If the icon is not null, it is added to the object. When \
both width and height are positive, the bounds of the button is set. By \
default, the location {x,y} of the object is {0,0}. The tip is a tool tip \
text.";

NewBasicArrowButton::usage=
    "NewBasicArrowButton[container,direction,x,y,width,height,tip] creates a \
javax.swing.plaf.basic.BasicArrowButton object with the specified direction. \
If the container is not null, the object is added to it. The default bounds \
{x,y,width,height} are set to {0,0,20,20}. The tip is a tool tip text.";

NewJList::usage=
    "NewJList[container,data,tip] creates a JList object with the specified \
data. If the container is not null, the object is added to it. The tip is a \
tool tip text.";

NewJComboBox::usage=
    "NewJComboBox[container,items,tip] creates a JComboBox object with the \
specified items. If the container is not null, the object is added to it. The \
tip is a tool tip text.";

NewJTable::usage=
    "NewJTable[container,rowData,columnNames,tip] creates a JTable object \
with the specified rowData and columnNames. If the container is not null, the \
table header with java`awt`BorderLayout`NORTH and the object are added to it. \
The column selection is allowed and the cell selection is enabled. The tip is \
a tool tip text.";

NewJTextField::usage=
    "NewJTextField[container,text,columns,doc,tip] creates a JTextField \
object with the specified text and the number of columns. By default the \
columns is set to 0. If the Document doc is not null, the specified text \
storage is used. If the container is not null, the object is added to it. The \
tip is a tool tip text.";

NewJPasswordField::usage=
    "NewJPasswordField[container,text,columns,doc,tip] creates a \
NewJPasswordField object with the specified text and the number of columns. \
By default the columns is set to 0. If the Document doc is not null, the \
specified text storage is used. If the container is not null, the object is \
added to it. The tip is a tool tip text.";

NewJTextArea::usage=
    "NewJTextArea[container,text,rows,columns,doc,tip] creates JTextArea \
object with the specified text, the number of rows, and the number of \
columns. If the Document doc is not null, the specified model is used. If the \
container is not null, the object is added to it. The tip is a tool tip \
text.";

JTextAreaInsert::usage=
    "JTextAreaInsert[textArea,text] inserts the text to the textArea at the \
current caret position.";

JTextAreaDelete::usage=
    "JTextAreaDelete[textArea] deletes selected text on the textArea.";

JTextAreaCut::usage=
    "JTextAreaCut[textArea] cut the selected text on the textArea.";

JTextAreaCopy::usage=
    "JTextAreaCopy[textArea] copies selected text on the textArea.";

JTextAreaPaste::usage=
    "JTextAreaPaste[textArea] pastes the text to the textArea.";

NewJEditorPane::usage=
    "NewJEditorPane[container,url,tip] creates a JEditorPane object with the \
specified url. If the container is not null, the object is added to it. The \
tip is a tool tip text.";

NewJTextPane::usage=
    "NewJTextPane[container,doc,tip] creates a JTextPane object. If the \
StyledDocument doc is not null, hte specified document model is used. If the \
container is not null, the object is added to it. The tip is a tool tip \
text.";

NewJScrollBar::usage="NewJScrollBar[container,
    orientation_:javax`swing`JScrollBar`VERTICAL,
    value_:0,extent_:10,minimum_:0,maximum_:100,
    tip] creates a JScrollBar object with the specified values; orientation, \
value, extent, munimum, and maximum. If the container is not null, the object \
is added to it. By default the orientation is set to \
javax`swing`JScrollBar`VERTICAL, the value is 0, the extent is 10, the \
minimum is 0, and the maximum is 100. The tip is a tool tip text.";

NewJScrollPane::usage=
    "NewJScrollPane[container,view,vsbPolicy,hsbPolicy,tip] creates a \
JScrollPane object with the specified view. The vertical scroll bar policy \
vsbPolicy and the holizontal scroll bar policy hsbPolicy are set to \
_AS_NEEDED by default. The tip is a tool tip text.";

NewJSlider::usage=
    "NewJSlider[container,orientation,min,max,value,doPaintTicks,\
majorTickSpacing,minorTickSpacing,labelIncrement,tip] creates a JSlider \
object with the specified orientation, min, max, and value. If the container \
is not null, the object is added to it. By default, the min is 0, the max is \
100, and the value is 50. If the flag doPaintTicks is True, the ticks are \
painted. By default, the ticks which  majorTickSpacing is 10, \
minorTickSpacing is 2, and labelIncrement is 10, is painted. The tip is a \
tool tip text.";

NewJMenuBar::usage=
    "NewJMenuBar[frame] creates a JMenuBar object with the raised bevel \
border. If the frame is not null, the object is set to it.";

NewJMenu::usage=
    "NewJMenu[menubar,title,mnemonic,enabled] creates a JMenu object with the \
specified title. If the mnemonic is not the empty string, it is set to the \
the object. The object is enabled by default. If the menubar is not null, the \
object is set to it.";

NewJMenuItem::usage=
    "NewJMenuItem[menu,title,mnemonic,enabled] creates a JMenuItem object \
with the specified title. If the mnemonic is not the empty string, it is set \
to the the object. The object is enabled by default. If the menu is not null, \
the object is added to it.";

NewJCheckBoxMenuItem::usage=
    "NewJCheckBoxMenuItem[menu,title,mnemonic,checked,enabled] creates a \
JCheckBoxMenuItem object with the specified title. If the mnemonic is not the \
empty string, it is set to the object. The object is not checked and is \
enabled by default. If the menu is not null, the object is added to it.";

NewJRadioButtonMenuItem::usage=
    "NewJRadioButtonMenuItem[menu,title,mnemonic,enabled] creates a \
NewJRadioButtonMenuItem object with the specified title. If the mnemonic is \
not the empty string, it is set to the the object. The object is enabled by \
default. If the menu is not null, the object is added to it.";

NewJToolBar::usage=
    "NewJToolBar[container,orientation,floatable,layout,tip] creates a \
JToolBar object. By default, the object is horizontal and floatable. The \
layout is set to java`awt`BorderLayout`NORTH. The tip is a tool tip text.";

ShowMessageDialog::usage=
    "ShowMessageDialog[parent,message,options,title,messageType,optionType,\
icon,tip] creates a message dialog with the specified message, options, \
title, and optionType. By default, the messageType is \
javax`swing`JOptionPane`INFORMATION_MESSAGE and the optionType is \
javax`swing`JOptionPane`DEFAULT_OPTION. If the icon is not null, it is \
assigned to the object. The tip is a tool tip text. The parent is a parent \
component of the object.";

ShowConfirmDialog::usage=
    "ShowConfirmDialog[parent,message,optionType,title,messageType,icon] \
creates a confirm dialog with the specified message, optionType, title, and \
messageType. By default, the optionType is \
javax`swing`JOptionPane`YES_NO_OPTION and the messageType is \
javax`swing`JOptionPane`QUESTION_MESSAGE. If the icon is not null, it is \
assigned to the object. The tip is a tool tip text. The parent is a parent \
component of the object.";

ShowInputDialog::usage=
    "ShowInputDialog[parent,message,selections,initial,title,messageType,icon]\
 creates an input dialog with the specified message and title. If the \
selections is not null, the object is shown having the selection items whose \
initially selected item is specified by the parameter initial. By default, \
the initial is 1 and messageType is javax`swing`JOptionPane`QUESTION_MESSAGE. \
If the icon is not null, it is assigned to the object. The tip is a tool tip \
text. The parent is a parent component of the object.";

ShowFileChooser::usage=
    "ShowFileChooser[title,okText,dir] creates a file chooser dialog with the \
specified title. The okText is a caption of the Ok button. The dir is the \
current directory path. ShowFileChooser returns the full path of the \
specified file.";

GetFilePathAndName::usage=
    "GetFilePathAndName[title,okText,dir] creates a file chooser dialog with \
the specified title. The okText is a caption of the Ok button. The dir is the \
current directory path. GetFilePathAndName returns the list of the full path \
of the specified file and the file name.";

NewJColorChooser::usage=
    "NewJColorChooser[container,color,tip] creates a color chooser dialog \
with the specified color. By default, the color is set to \
java`awt`Color`white. The tip is a tool tip text.";

ShowColorChooser::usage=
    "ShowColorChooser[color,title] showes a color chooser dialog with the \
specified color and title. By default, the color is set to \
java`awt`Color`black. ShowColorChooser returns the result color in the form \
of three unsigned 8 bit integers {R,G,B}.";

NewJTree::usage=
    "NewJTree[container,rootObj,leafIcon,openIcon,closedIcon,tip] creates a \
JTree object with the specified rootObj, leafIcon, openIcon, and closedIcon. \
The tip is a tool tip text.";

ShowProgressBar::usage=
    "ShowProgressBar[title,caption,percent] creates a progress bar with the \
specified title and caption. The completion percentage is set to the percent. \
ShowProgressBar returns the JProgressBar object.";

DestroyProgressBar::usage=
    "DestroyProgressBar[bar] disposes the JProgressBar object bar.";

ShowProgressMonitor::usage=
    "ShowProgressMonitor[container,message,note,min_,max] creates a progress \
monitor with the specified message and note. By default, the min is set to 0 \
and the max is set to 100. The container is the container component of the \
object. ShowProgressMonitor returns the ProgressMonitor object.";

DestroyProgressMonitor::usage=
    "DestroyProgressMonitor[monitor] disposes the ProgressMoninor object.";



Begin["`Private`"]

LoadJavaSwingClasses[] := (
    LoadJavaClass["java.lang.Thread"];
    LoadJavaClass["java.lang.String"];
    LoadJavaClass["java.lang.Character"];
    
    LoadJavaClass["com.wolfram.jlink.MathJFrame"];
    LoadJavaClass["com.wolfram.jlink.MathActionListener"];
    
    LoadJavaClass["java.awt.Toolkit"];
    LoadJavaClass["java.awt.BorderLayout"];
    LoadJavaClass["java.awt.FlowLayout"];
    LoadJavaClass["java.awt.Color"];
    LoadJavaClass["java.awt.event.ActionEvent"];
    
    LoadJavaClass["javax.swing.ImageIcon"];
    LoadJavaClass["javax.swing.SwingConstants"];
    LoadJavaClass["javax.swing.JDesktopPane"];
    LoadJavaClass["javax.swing.JInternalFrame"];
    LoadJavaClass["javax.swing.JSplitPane"];
    LoadJavaClass["javax.swing.JTabbedPane"];
    LoadJavaClass["javax.swing.JLabel"];
    LoadJavaClass["javax.swing.JPanel"];
    LoadJavaClass["javax.swing.border.EmptyBorder"];
    LoadJavaClass["javax.swing.border.EtchedBorder"];
    LoadJavaClass["javax.swing.border.BevelBorder"];
    LoadJavaClass["javax.swing.border.SoftBevelBorder"];
    LoadJavaClass["javax.swing.border.MatteBorder"];
    LoadJavaClass["javax.swing.border.LineBorder"];
    LoadJavaClass["javax.swing.border.CompoundBorder"];
    LoadJavaClass["javax.swing.border.TitledBorder"];
    LoadJavaClass["javax.swing.JButton"];
    LoadJavaClass["javax.swing.JToggleButton"];
    LoadJavaClass["javax.swing.JCheckBox"];
    LoadJavaClass["javax.swing.JRadioButton"];
    LoadJavaClass["javax.swing.plaf.basic.BasicArrowButton"];
    LoadJavaClass["javax.swing.JList"];
    LoadJavaClass["javax.swing.JComboBox"];
    LoadJavaClass["javax.swing.JTable"];
    LoadJavaClass["javax.swing.JTextField"];
    LoadJavaClass["javax.swing.JPasswordField"];
    LoadJavaClass["javax.swing.JTextArea"];
    LoadJavaClass["javax.swing.JEditorPane"];
    LoadJavaClass["javax.swing.JTextPane"];
    LoadJavaClass["javax.swing.JScrollBar"];
    LoadJavaClass["javax.swing.ScrollPaneConstants"];
    LoadJavaClass["javax.swing.JScrollPane"];
    LoadJavaClass["javax.swing.JSlider"];
    LoadJavaClass["javax.swing.JMenuBar"];
    LoadJavaClass["javax.swing.JMenu"];
    LoadJavaClass["javax.swing.JMenuItem"];
    LoadJavaClass["javax.swing.JCheckBoxMenuItem"];
    LoadJavaClass["javax.swing.JRadioButtonMenuItem"];
    LoadJavaClass["javax.swing.JToolBar"];
    LoadJavaClass["javax.swing.JOptionPane"];
    LoadJavaClass["javax.swing.JFileChooser"];
    LoadJavaClass["javax.swing.JColorChooser"];
    LoadJavaClass["javax.swing.JProgressBar"];
    LoadJavaClass["javax.swing.JFrame"];
    LoadJavaClass["javax.swing.SwingUtilities"];
    LoadJavaClass["javax.swing.ProgressMonitor"];
    )





SleepThread[msec_]:=JavaBlock[Module[
      {},
      InstallJava[];
      LoadJavaClass["java.lang.Thread"];
      java`lang`Thread`currentThread[]@sleep[msec];
      ]]

















FindChar[x_:""]:=If[Head[x]===String,
    First[ToCharacterCode[x]],
    FromCharacterCode[x]]



































DeleteJObject[container_,obj_,doRepaint_:True]:=JavaBlock[Module[
      {},
      InstallJava[];
      container@remove[obj];
      If[doRepaint===True,
        container@repaint[]
        ];
      ReleaseObject[obj];
      ]]



NewMathJFrame[title_String:"MathJFrame",
    w_:0,h_:0,x_:0,y_:0]:=Module[
    {frame},
    InstallJava[];
    frame=JavaNew["com.wolfram.jlink.MathJFrame",title];
    JavaBlock[
      frame@setLocation[x,y];
      If[w>0&&h>0,
        frame@setSize[w,h]
        ];
      ];
    Return[frame]
    ]

CenterizeFrameOnScreen[frame_]:=JavaBlock[Module[
      {screen,size,newX,newY},
      InstallJava[];
      LoadJavaClass["java.awt.Toolkit"];
      screen=java`awt`Toolkit`getDefaultToolkit[]@getScreenSize[];
      size=frame@getSize[];
      newX=Round[(screen@width-size@width)/2];
      newY=Round[(screen@height-size@height)/2];
      frame@setLocation[newX,newY];
      ]]



NewImageIcon[path_:Null]:=Module[
    {icon},
    InstallJava[];
    icon=JavaNew["javax.swing.ImageIcon",path];
    Return[icon]
    ]



LoadJavaClass["javax.swing.SwingConstants"]

swTop=javax`swing`SwingConstants`TOP

swLeft=javax`swing`SwingConstants`LEFT

swBottom=javax`swing`SwingConstants`BOTTOM

swRight=javax`swing`SwingConstants`RIGHT

swNorth=javax`swing`SwingConstants`NORTH

swNorthEast=javax`swing`SwingConstants`NORTHUEAST

swEast=javax`swing`SwingConstants`EAST

swSouthEast=javax`swing`SwingConstants`SOUTHUEAST

swSouth=javax`swing`SwingConstants`SOUTH

swSouthWest=javax`swing`SwingConstants`SOUTHUWEST

swWest=javax`swing`SwingConstants`WEST

swNothWest=javax`swing`SwingConstants`NORTHUWEST

swCenter=javax`swing`SwingConstants`CENTER

swHorizontal=javax`swing`SwingConstants`HORIZONTAL

swVertical=javax`swing`SwingConstants`VERTICAL



NewJDesktopPane[container_:Null,
    tip_String:"JDesktopPane"]:=Module[
    {desktop},
    InstallJava[];
    desktop=JavaNew["javax.swing.JDesktopPane"];
    JavaBlock[
      If[container =!= Null,
        container@add[desktop]
        ];
      desktop@setToolTipText[tip];
      ];
    Return[desktop]
    ]



NewJInternalFrame[container_:Null,
    layerConst_:Null,
    title_String:"JInternalFrame",
    x_:0,y_:0,width_:0,height_:0,
    resizable_:True,
    closable_:True,
    maximizable_:True,
    iconifiable_:True,
    icon_:Null,
    tip_String:"JInternalFrame"]:=Module[
    {frame},
    InstallJava[];
    frame=JavaNew["javax.swing.JInternalFrame",
        title,resizable,closable,maximizable,iconifiable];
    JavaBlock[
      If[layerConst=!=Null,
        If[container =!= Null,
          container@add[frame,layerConst]
          ],
        If[container =!= Null,
          container@add[frame]
          ]
        ];
      frame@setLocation[x,y];
      If[width>0&&height>0,
        frame@setSize[width,height]
        ];
      If[icon=!=Null,
        frame@setFrameIcon[icon]
        ];
      frame@setToolTipText[tip];
      frame@setVisible[True];
      ];
    Return[frame]
    ]



InstallJava[];
LoadJavaClass["javax.swing.JSplitPane"];

NewJSplitPane[container_:Null,
    orientation_:javax`swing`JSplitPane`VERTICALUSPLIT,
    continuous_:True,
    dividerSize_:8,
    tip_String:"JSplitPane"]:=Module[
    {split},
    InstallJava[];
    split=JavaNew["javax.swing.JSplitPane",
        orientation,continuous];
    JavaBlock[
      If[container =!= Null,
        container@add[split]
        ];
      split@setDividerSize[dividerSize];
      split@setToolTipText[tip];
      ];
    Return[split]
    ]



InstallJava[];
LoadJavaClass["javax.swing.JTabbedPane"];

NewJTabbedPane[container_:Null,
    placement_:javax`swing`JTabbedPane`TOP,
    tip_String:"JTabbedPane"]:=Module[
    {pane},
    InstallJava[];
    pane=JavaNew["javax.swing.JTabbedPane",placement];
    JavaBlock[
      If[container =!= Null,
        container@add[pane]
        ];
      pane@setToolTipText[tip];
      ];
    Return[pane]
    ]



InstallJava[];
LoadJavaClass["javax.swing.JLabel"];

NewJLabel[container_:Null,
    title_String:"JLabel",
    icon_:Null,
    x_Integer:0,y_Integer:0,width_Integer:0,height_Integer:0,
    horizontalAlignment_:javax`swing`JLabel`CENTER,tip_String:"JLabel"]:=
  Module[
    {label},
    InstallJava[];
    If[icon=!=Null,
      label=JavaNew["javax.swing.JLabel",title,icon,horizontalAlignment],
      label=JavaNew["javax.swing.JLabel",title,horizontalAlignment]
      ];
    JavaBlock[
      If[container =!= Null,
        container@add[label]
        ];
      If[width>0&&height>0,
        label@setBounds[x,y,width,height]
        ];
      label@setToolTipText[tip];
      ];
    Return[label]
    ]





NewJPanelEmptyBorder[container_:Null,
    top_Integer:1,
    left_Integer:1,
    bottom_Integer:1,
    right_Integer:1,
    tip_String:"JPanel(EmptyBorder)",
    addLabel_:False]:=Module[
    {panel,border,string,name,label},
    InstallJava[];
    panel=JavaNew["javax.swing.JPanel"];
    JavaBlock[
      panel@setLayout[JavaNew["java.awt.BorderLayout"]];
      border=JavaNew["javax.swing.border.EmptyBorder",top,left,bottom,right];
      
      If[addLabel,
        string=JavaNew["java.lang.String",border@getClass[]@toString[]];
        name=string@substring[string@lastIndexOf["."]+1];
        LoadJavaClass["javax.swing.JLabel"];
        label=JavaNew["javax.swing.JLabel",name,javax`swing`JLabel`CENTER];
        panel@add[label];
        ];
      
      panel@setBorder[border];
      If[container =!= Null,
        container@add[panel];
        container@repaint[];
        ];
      
      panel@setToolTipText[tip];
      ];
    Return[panel]
    ]



NewJPanelEtchedBorder[container_:Null,
    isRaised_:True,
    highlight_:Null,shadow_:Null,
    tip_String:"JPanel(EtchedBorder)",
    addLabel_:False]:=Module[
    {panel,border,string,name,label},
    InstallJava[];
    panel=JavaNew["javax.swing.JPanel"];
    JavaBlock[
      panel@setLayout[JavaNew["java.awt.BorderLayout"]];
      LoadJavaClass["javax.swing.border.EtchedBorder"];
      etchType=Evaluate[
          If[isRaised,
            javax`swing`border`EtchedBorder`RAISED,
            javax`swing`border`EtchedBorder`LOWERED]];
      If[highlight=!=Null&&shadow=!=Null,
        border=JavaNew["javax.swing.border.EtchedBorder",
            etchType,highlight,shadow],
        border=JavaNew["javax.swing.border.EtchedBorder",
            etchType]];
      
      If[addLabel,
        string=JavaNew["java.lang.String",border@getClass[]@toString[]];
        name=string@substring[string@lastIndexOf["."]+1];
        LoadJavaClass["javax.swing.JLabel"];
        label=JavaNew["javax.swing.JLabel",name,javax`swing`JLabel`CENTER];
        panel@add[label];
        ];
      
      panel@setBorder[border];
      If[container =!= Null,
        container@add[panel];
        container@repaint[];
        ];
      
      panel@setToolTipText[tip];
      ];
    Return[panel]
    ]



NewJPanelBevelBorder[container_:Null,isRaised_:True,
    highlightOuter_:Null,highlightInner_:Null,
    shadowOuter_:Null,shadowInner_:Null,
    tip_String:"JPanel(BevelBorder)",
    addLabel_:False]:=Module[
    {panel,border,bevelType,string,name,label},
    InstallJava[];
    panel=JavaNew["javax.swing.JPanel"];
    JavaBlock[
      panel@setLayout[JavaNew["java.awt.BorderLayout"]];
      
      LoadJavaClass["javax.swing.border.BevelBorder"];
      bevelType=Evaluate[
          If[isRaised,
            javax`swing`border`BevelBorder`RAISED,
            javax`swing`border`BevelBorder`LOWERED]];
      
      If[highlightOuter=!=Null&&highlightInner=!=Null,
        If[shadowOuter=!=Null&&shadowInner=!=Null,
          border=JavaNew[
              "javax.swing.border.BevelBorder",
              bevelType,highlightOuter,highlightInner,
              shadowOuter,shadowInner
              ],
          border=JavaNew[
              "javax.swing.border.BevelBorder",
              bevelType,highlightOuter,highlightInner
              ]
          ],
        border=JavaNew[
            "javax.swing.border.BevelBorder",
            bevelType
            ]
        ];
      
      If[addLabel,
        string=JavaNew["java.lang.String",border@getClass[]@toString[]];
        name=string@substring[string@lastIndexOf["."]+1];
        LoadJavaClass["javax.swing.JLabel"];
        label=JavaNew["javax.swing.JLabel",name,javax`swing`JLabel`CENTER];
        panel@add[label];
        ];
      
      panel@setBorder[border];
      If[container =!= Null,
        container@add[panel];
        container@repaint[];
        ];
      
      panel@setToolTipText[tip];
      ];
    Return[panel]
    ]



Needs["JLink`"];
NewJPanelSoftBevelBorder[container_:Null,isRaised_:True,
    highlightOuter_:Null,highlightInner_:Null,
    shadowOuter_:Null,shadowInner_:Null,
    tip_String:"JPanel(SoftBevelBorder)",
    addLabel_:False]:=Module[
    {panel,border,bevelType,string,name,label},
    InstallJava[];
    panel=JavaNew["javax.swing.JPanel"];
    JavaBlock[
      panel@setLayout[JavaNew["java.awt.BorderLayout"]];
      
      LoadJavaClass["javax.swing.border.SoftBevelBorder"];
      bevelType=Evaluate[
          If[isRaised,
            javax`swing`border`SoftBevelBorder`RAISED,
            javax`swing`border`SoftBevelBorder`LOWERED]];
      
      If[highlightOuter=!=Null&&highlightInner=!=Null,
        If[shadowOuter=!=Null&&shadowInner=!=Null,
          border=JavaNew[
              "javax.swing.border.SoftBevelBorder",
              bevelType,highlightOuter,highlightInner,
              shadowOuter,shadowInner
              ],
          border=JavaNew[
              "javax.swing.border.SoftBevelBorder",
              bevelType,highlightOuter,highlightInner
              ]
          ],
        border=JavaNew[
            "javax.swing.border.SoftBevelBorder",
            bevelType
            ]
        ];
      
      If[addLabel,
        string=JavaNew["java.lang.String",border@getClass[]@toString[]];
        name=string@substring[string@lastIndexOf["."]+1];
        LoadJavaClass["javax.swing.JLabel"];
        label=JavaNew["javax.swing.JLabel",name,javax`swing`JLabel`CENTER];
        panel@add[label];
        ];
      
      panel@setBorder[border];
      If[container =!= Null,
        container@add[panel];
        container@repaint[];
        ];
      
      panel@setToolTipText[tip];
      ];
    Return[panel]
    ]



InstallJava[];
LoadJavaClass["java.awt.Color"];

NewJPanelMatteBorder[container_:Null,
    top_:4,left_:4,bottom_:4,right_:4,color_:java`awt`Color`gray,
    tip_String:"JPanel(MatteBorder)",
    addLabel_:False]:=Module[
    {panel,border,string,name,label},
    InstallJava[];
    panel=JavaNew["javax.swing.JPanel"];
    JavaBlock[
      panel@setLayout[JavaNew["java.awt.BorderLayout"]];
      
      border=
        JavaNew["javax.swing.border.MatteBorder",top,left,bottom,right,
          color];
      
      If[addLabel,
        string=JavaNew["java.lang.String",border@getClass[]@toString[]];
        name=string@substring[string@lastIndexOf["."]+1];
        LoadJavaClass["javax.swing.JLabel"];
        label=JavaNew["javax.swing.JLabel",name,javax`swing`JLabel`CENTER];
        panel@add[label];
        ];
      
      panel@setBorder[border];
      If[container =!= Null,
        container@add[panel];
        container@repaint[];
        ];
      
      panel@setToolTipText[tip];
      ];
    Return[panel]
    ]

NewJPanelMatteBorderTileIcon[container_:Null,
    titleIcon_:Null,
    tip_String:"JPanel(MatteBorder)",
    addLabel_:False]:=Module[
    {panel,border,string,name,label},
    InstallJava[];
    panel=JavaNew["javax.swing.JPanel"];
    JavaBlock[
      panel@setLayout[JavaNew["java.awt.BorderLayout"]];
      
      border=JavaNew["javax.swing.border.MatteBorder",titleIcon];
      
      If[addLabel,
        string=JavaNew["java.lang.String",border@getClass[]@toString[]];
        name=string@substring[string@lastIndexOf["."]+1];
        LoadJavaClass["javax.swing.JLabel"];
        label=JavaNew["javax.swing.JLabel",name,javax`swing`JLabel`CENTER];
        panel@add[label];
        ];
      
      panel@setBorder[border];
      If[container =!= Null,
        container@add[panel];
        container@repaint[];
        ];
      
      panel@setToolTipText[tip];
      ];
    Return[panel]
    ]



InstallJava[];
LoadJavaClass["java.awt.Color"];

NewJPanelLineBorder[container_:Null,
    thickness_:1,color_:java`awt`Color`gray,tip_String:"JPanel(LineBorder)",
    addLabel_:False]:=Module[
    {panel,border,string,name,label},
    InstallJava[];
    panel=JavaNew["javax.swing.JPanel"];
    JavaBlock[
      panel@setLayout[JavaNew["java.awt.BorderLayout"]];
      border=JavaNew["javax.swing.border.LineBorder",color,thickness];
      
      If[addLabel,
        string=JavaNew["java.lang.String",border@getClass[]@toString[]];
        name=string@substring[string@lastIndexOf["."]+1];
        LoadJavaClass["javax.swing.JLabel"];
        label=JavaNew["javax.swing.JLabel",name,javax`swing`JLabel`CENTER];
        panel@add[label];
        ];
      
      panel@setBorder[border];
      If[container =!= Null,
        container@add[panel];
        container@repaint[];
        ];
      
      panel@setToolTipText[tip];
      ];
    Return[panel]
    ]



NewJPanelCompoundBorder[container_:Null,
    outsideBorder_:Null,
    insideBorder_:Null,
    tip_String:"JPanel(CompoundBorder)",
    addLabel_:False]:=Module[
    {panel,border,string,name,label},
    InstallJava[];
    panel=JavaNew["javax.swing.JPanel"];
    JavaBlock[
      panel@setLayout[JavaNew["java.awt.BorderLayout"]];
      If[outsideBorder=!=Null&&insideBorder=!=Null,
        border=JavaNew[
            "javax.swing.border.CompoundBorder",outsideBorder,insideBorder],
        border=JavaNew[
            "javax.swing.border.CompoundBorder"]
        ];
      
      If[addLabel,
        string=JavaNew["java.lang.String",border@getClass[]@toString[]];
        name=string@substring[string@lastIndexOf["."]+1];
        LoadJavaClass["javax.swing.JLabel"];
        label=JavaNew["javax.swing.JLabel",name,javax`swing`JLabel`CENTER];
        panel@add[label];
        ];
      
      panel@setBorder[border];
      If[container =!= Null,
        container@add[panel];
        container@repaint[];
        ];
      
      panel@setToolTipText[tip];
      ];
    Return[panel]
    ]



NewJPanelTitledBorder[container_:Null,
    title_String:"Title",
    border_:Null,
    tip_String:"JPanel(TitledBorder)",
    addLabel_:False]:=Module[
    {panel,titledBorder,string,name,label},
    InstallJava[];
    panel=JavaNew["javax.swing.JPanel"];
    JavaBlock[
      panel@setLayout[JavaNew["java.awt.BorderLayout"]];
      If[border=!=Null,
        titledBorder=JavaNew["javax.swing.border.TitledBorder",border,title],
        titledBorder=JavaNew["javax.swing.border.TitledBorder",title]
        ];
      
      If[addLabel,
        string=JavaNew["java.lang.String",titledBorder@getClass[]@toString[]];
        name=string@substring[string@lastIndexOf["."]+1];
        LoadJavaClass["javax.swing.JLabel"];
        label=JavaNew["javax.swing.JLabel",name,javax`swing`JLabel`CENTER];
        panel@add[label];
        ];
      
      panel@setBorder[titledBorder];
      If[container =!= Null,
        container@add[panel];
        container@repaint[];
        ];
      
      panel@setToolTipText[tip];
      ];
    Return[panel]
    ]



NewJButton[container_:Null,
    title_String:"JButton",
    icon_:Null,
    x_Integer:0,y_Integer:0,width_Integer:0,height_Integer:0,
    tip_String:"JButton"]:=Module[
    {button},
    InstallJava[];
    If[icon=!=Null,
      button=JavaNew["javax.swing.JButton",title,icon],
      button=JavaNew["javax.swing.JButton",title]
      ];
    JavaBlock[
      If[container =!= Null,
        container@add[button]
        ];
      If[width>0&&height>0,
        button@setBounds[x,y,width,height]
        ];
      button@setToolTipText[tip];
      ];
    Return[button]
    ]



NewJToggleButton[container_:Null,
    title_String:"JToggleButton",
    selected_:False,
    icon_:Null,
    x_Integer:0,y_Integer:0,width_Integer:0,height_Integer:0,
    tip_String:"JToggleButton"]:=Module[
    {button},
    InstallJava[];
    If[icon=!=Null,
      button=JavaNew["javax.swing.JToggleButton",title,icon,selected],
      button=JavaNew["javax.swing.JToggleButton",title,selected]
      ];
    JavaBlock[
      If[container =!= Null,
        container@add[button]
        ];
      If[width>0&&height>0,
        button@setBounds[x,y,width,height]
        ];
      button@setToolTipText[tip];
      ];
    Return[button]
    ]



NewJCheckBox[container_:Null,
    title_String:"JCheckBox",
    selected_:False,
    icon_:Null,
    x_Integer:0,y_Integer:0,width_Integer:0,height_Integer:0,
    tip_String:"JCheckBox"]:=Module[
    {button},
    InstallJava[];
    If[icon=!=Null,
      button=JavaNew["javax.swing.JCheckBox",title,icon,selected],
      button=JavaNew["javax.swing.JCheckBox",title,selected]
      ];
    JavaBlock[
      If[container =!= Null,
        container@add[button]
        ];
      If[width>0&&height>0,
        button@setBounds[x,y,width,height]
        ];
      button@setToolTipText[tip];
      ];
    Return[button]
    ]



NewJRadioButton[container_:Null,
    title_String:"JRadioButton",
    selected_:False,
    icon_:Null,
    x_Integer:0,y_Integer:0,width_Integer:0,height_Integer:0,
    tip_String:"JRadioButton"]:=Module[
    {button},
    InstallJava[];
    If[icon=!=Null,
      button=JavaNew["javax.swing.JRadioButton",title,icon,selected],
      button=JavaNew["javax.swing.JRadioButton",title,selected]
      ];
    JavaBlock[
      If[container =!= Null,
        container@add[button]
        ];
      If[width>0&&height>0,
        button@setBounds[x,y,width,height]
        ];
      button@setToolTipText[tip];
      ];
    Return[button]
    ]



NewBasicArrowButton[container_:Null,direction_Integer,x_Integer:0,y_Integer:0,
    width_Integer:20,height_Integer:20,tip_String:"BasicArrowButton"]:=
  Module[
    {button},
    InstallJava[];
    button=JavaNew["javax.swing.plaf.basic.BasicArrowButton",direction];
    JavaBlock[
      If[container =!= Null,
        container@add[button]
        ];
      button@setBounds[x,y,width,height];
      button@setToolTipText[tip];
      ];
    Return[button]
    ]



NewJList[container_:Null,
    data_:Null,
    tip_String:"JList"]:=Module[
    {list},
    InstallJava[];
    list=JavaNew["javax.swing.JList",data];
    JavaBlock[
      If[container=!=Null,
        container@add[list]
        ];
      list@setToolTipText[tip];
      ];
    Return[list]
    ]



NewJComboBox[container_:Null,
    items_:Null,
    tip_String:"JComboBox"]:=Module[
    {box},
    InstallJava[];
    box=JavaNew["javax.swing.JComboBox",items];
    JavaBlock[
      If[container=!=Null,
        container@add[box]
        ];
      box@setToolTipText[tip];
      ];
    Return[box]
    ]



NewJTable[container_:Null,
    rowData_,columnNames_,
    tip_String:"JComboBox"]:=Module[
    {table},
    InstallJava[];
    table=JavaNew["javax.swing.JTable",rowData,columnNames];
    JavaBlock[
      If[container=!=Null,
        LoadJavaClass["java.awt.BorderLayout"];
        container@add[
            table@getTableHeader[],
            JavaNew["java.lang.String",java`awt`BorderLayout`NORTH]
            ];
        container@add[table];
        ];
      
      table@setColumnSelectionAllowed[True];
      table@setCellSelectionEnabled[True];
      
      table@setToolTipText[tip];
      ];
    Return[table]
    ]



NewJTextField[container_:Null,
    text_:"",
    columns_:0,
    doc_:Null,
    tip_String:"JTextField"]:=Module[
    {field},
    InstallJava[];
    If[doc=!=Null,field=JavaNew["javax.swing.JTextField",doc,text,columns],
      field=JavaNew["javax.swing.JTextField",text,columns]
      ];
    JavaBlock[
      If[container=!=Null,
        container@add[field];
        ];
      field@setToolTipText[tip];
      ];
    Return[field]
    ]



NewJPasswordField[container_:Null,
    text_:"",
    columns_:0,
    doc_:Null,
    tip_String:"JPasswordField"]:=Module[
    {field},
    InstallJava[];
    If[doc=!=Null,
      field=JavaNew["javax.swing.JPasswordField",doc,text,columns],
      field=JavaNew["javax.swing.JPasswordField",text,columns]
      ];
    JavaBlock[
      If[container=!=Null,
        container@add[field];
        ];
      field@setToolTipText[tip];
      ];
    Return[field]
    ]



NewJTextArea[container_:Null,
    text_:"",
    rows_:0,
    columns_:0,
    doc_:Null,
    tip_String:"JTextArea"]:=Module[
    {area},
    InstallJava[];
    If[doc=!=Null,
      area=JavaNew["javax.swing.JTextArea",doc,text,rows,columns],
      area=JavaNew["javax.swing.JTextArea",text,rows,columns]
      ];
    JavaBlock[
      If[container=!=Null,
        container@add[area];
        ];
      area@setToolTipText[tip];
      ];
    Return[area]
    ]

JTextAreaInsert[textArea_,text_]:=Module[
    {},
    JavaBlock[
      textArea@insert[text,textArea@getCaretPosition[]]
      ]
    ]

JTextAreaDelete[textArea_]:=Module[
    {},
    JavaBlock[
      textArea@replaceSelection[""]
      ]
    ]

JTextAreaCut[textArea_]:=Module[
    {},
    JavaBlock[
      textArea@cut[]
      ]
    ]

JTextAreaCopy[textArea_]:=Module[
    {},
    JavaBlock[
      textArea@copy[]
      ]
    ]

JTextAreaPaste[textArea_]:=Module[
    {},
    JavaBlock[
      textArea@paste[]
      ]
    ]



NewJEditorPane[container_:Null,
    url_:Null,
    tip_String:"JEditorPane"]:=Module[
    {editor},
    InstallJava[];
    If[url=!=Null,editor=JavaNew["javax.swing.JEditorPane",url],
      editor=JavaNew["javax.swing.JEditorPane"]
      ];
    JavaBlock[
      If[container=!=Null,
        container@add[editor];
        ];
      editor@setToolTipText[tip];
      ];
    Return[editor]
    ]



NewJTextPane[container_:Null,
    doc_:Null,
    tip_String:"JTextPane"]:=Module[
    {textPane},
    InstallJava[];
    If[doc=!=Null,textPane=JavaNew["javax.swing.JTextPane",doc],
      textPane=JavaNew["javax.swing.JTextPane"]
      ];
    JavaBlock[
      If[container=!=Null,
        container@add[textPane];
        ];
      textPane@setToolTipText[tip];
      ];
    Return[textPane]
    ]



InstallJava[];
LoadJavaClass["javax.swing.JScrollBar"];

NewJScrollBar[container_:Null,
    orientation_:javax`swing`JScrollBar`VERTICAL,
    value_:0,extent_:10,minimum_:0,maximum_:100,
    tip_String:"JScrollBar"]:=Module[
    {bar},
    InstallJava[];
    bar=JavaNew["javax.swing.JScrollBar",
        orientation,value,extent,minimum,maximum];
    JavaBlock[
      If[container=!=Null,
        container@add[bar];
        ];
      bar@setToolTipText[tip];
      ];
    Return[bar]
    ]



InstallJava[];
LoadJavaClass["javax.swing.ScrollPaneConstants"];

NewJScrollPane[container_:Null,
    view_:Null,
    vsbPolicy_:javax`swing`ScrollPaneConstants`VERTICALUSCROLLBARUASUNEEDED,
    hsbPolicy_:javax`swing`ScrollPaneConstants`HORIZONTALUSCROLLBARUASUNEEDED,\

    tip_String:"JScrollPane"]:=Module[
    {pane},
    InstallJava[];
    If[view=!=Null,
      pane=JavaNew["javax.swing.JScrollPane",
          view,vsbPolicy,hsbPolicy],
      pane=JavaNew["javax.swing.JScrollPane",
          vsbPolicy,hsbPolicy]
      ];
    JavaBlock[
      If[container =!= Null,
        container@add[pane]
        ];
      pane@setToolTipText[tip];
      ];
    Return[pane]
    ]



InstallJava[];
LoadJavaClass["javax.swing.JSlider"];

NewJSlider[container_:Null,
    orientation_:javax`swing`JSlider`HORIZONTAL,
    min_:0,max_:100,value_:50,
    doPaintTicks_:True,
    majorTickSpacing_:10,
    minorTickSpacing_:2,
    labelIncrement_:10,
    tip_String:"JSlider"]:=Module[
    {slider},
    InstallJava[];
    slider=JavaNew["javax.swing.JSlider",
        orientation,min,max,value];
    JavaBlock[
      If[container=!=Null,
        container@add[slider];
        ];
      
      slider@setPaintTicks[doPaintTicks];
      slider@setMajorTickSpacing[majorTickSpacing];
      slider@setMinorTickSpacing[minorTickSpacing];
      
      If[labelIncrement>0,
        slider@setLabelTable[slider@createStandardLabels[labelIncrement]];
        slider@setPaintLabels[True];
        ];
      
      slider@setToolTipText[tip];
      ];
    Return[slider]
    ]



NewJMenuBar[frame_:Null]:=Module[
    {menubar},
    InstallJava[];
    menubar=JavaNew["javax.swing.JMenuBar"];
    JavaBlock[
      LoadJavaClass["javax.swing.border.BevelBorder"];
      menubar@
        setBorder[
          JavaNew["javax.swing.border.BevelBorder",
            javax`swing`border`BevelBorder`RAISED]];
      menubar@setBorderPainted[True];
      If[frame=!=Null,frame@setJMenuBar[menubar]];
      ];
    Return[menubar]
    ]



NewJMenu[menubar_:Null,
    title_:"JMenu",mnemonic_:"",enabled_:True]:=Module[
    {menu},
    InstallJava[];
    menu=JavaNew["javax.swing.JMenu"];
    JavaBlock[
      menu@setText[title];
      menu@setEnabled[enabled];
      If[mnemonic=!="",menu@setMnemonic[FindChar[mnemonic]]];
      If[menubar=!=Null,menubar@add[menu]];
      ];
    Return[menu]
    ]



NewJMenuItem[menu_:Null,
    title_:"JMenuItem",mnemonic_:"",enabled_:True]:=Module[
    {item},
    InstallJava[];
    item=JavaNew["javax.swing.JMenuItem"];
    JavaBlock[
      item@setText[title];
      item@setEnabled[enabled];
      If[mnemonic=!="",item@setMnemonic[FindChar[mnemonic]]];
      If[menu=!=Null,menu@add[item]];
      ];
    Return[item]
    ]



NewJCheckBoxMenuItem[menu_:Null,
    title_:"JCheckBoxMenuItem",mnemonic_:"",checked_:False,enabled_:True]:=
  Module[
    {item},
    InstallJava[];
    item=JavaNew["javax.swing.JCheckBoxMenuItem"];
    JavaBlock[
      item@setText[title];
      item@setState[checked];
      item@setEnabled[enabled];
      If[mnemonic=!="",item@setMnemonic[FindChar[mnemonic]]];
      If[menu=!=Null,menu@add[item]];
      ];
    Return[item]
    ]



NewJRadioButtonMenuItem[menu_:Null,
    title_:"JRadioButtonMenuItem",mnemonic_:"",enabled_:True]:=Module[
    {item},
    InstallJava[];
    item=JavaNew["javax.swing.JRadioButtonMenuItem"];
    JavaBlock[
      item@setText[title];
      item@setEnabled[enabled];
      If[mnemonic=!="",item@setMnemonic[FindChar[mnemonic]]];
      If[menu=!=Null,menu@add[item]];
      ];
    Return[item]
    ]





InstallJava[];
LoadJavaClass["javax.swing.JToolBar"];
LoadJavaClass["java.awt.BorderLayout"];

NewJToolBar[container_:Null,
    orientation_:javax`swing`JToolBar`HORIZONTAL,
    floatable_:True,
    layout_:java`awt`BorderLayout`NORTH,
    tip_String:"JToolBar"]:=Module[
    {bar},
    InstallJava[];
    bar=JavaNew["javax.swing.JToolBar",orientation];
    JavaBlock[
      bar@setFloatable[floatable];
      If[container=!=Null,
        container@add[bar,JavaNew["java.lang.String",layout]];
        ];
      bar@setToolTipText[tip];
      ];
    Return[bar]
    ]



InstallJava[];
LoadJavaClass["javax.swing.JOptionPane"];

ShowMessageDialog[parent_:Null,
    message_:Null,
    options_:Null,
    title_:"Message",
    messageType_:javax`swing`JOptionPane`INFORMATIONUMESSAGE,
    optionType_:javax`swing`JOptionPane`DEFAULTUOPTION,
    icon_:Null,
    tip_String:"JOptionPane"]:=JavaBlock[Module[
      {option,dialog},
      InstallJava[];
      option=JavaNew["javax.swing.JOptionPane",
          message,messageType,optionType,icon,options];
      option@setToolTipText[tip];
      If[ClassName[parent]==="com.wolfram.jlink.MathJFrame",
        JavaShow[parent]
        ];
      dialog=option@createDialog[parent,title];
      dialog@show[];
      ]]

InstallJava[];
LoadJavaClass["javax.swing.JOptionPane"];

ShowConfirmDialog[parent_:Null,
    message_:Null,
    optionType_:javax`swing`JOptionPane`YESUNOUOPTION,
    title_:"Question",
    messageType_:javax`swing`JOptionPane`QUESTIONUMESSAGE,
    icon_:Null]:=Module[
    {result=$Failed},
    InstallJava[];
    JavaBlock[
      If[ClassName[parent]==="com.wolfram.jlink.MathJFrame",
        JavaShow[parent]
        ];
      result=
        javax`swing`JOptionPane`showConfirmDialog[parent,message,title,
          optionType,messageType,icon];
      ];
    Return[result]
    ]

InstallJava[];
LoadJavaClass["javax.swing.JOptionPane"];

ShowInputDialog[parent_:Null,
    message_:Null,
    selections_:Null,
    initial_:1,
    title_:"Question",
    messageType_:javax`swing`JOptionPane`QUESTIONUMESSAGE,
    icon_:Null]:=Module[
    {result=$Failed},
    InstallJava[];
    JavaBlock[
      If[ClassName[parent]==="com.wolfram.jlink.MathJFrame",
        JavaShow[parent]
        ];
      If[selections=!=Null,
        result=javax`swing`JOptionPane`showInputDialog[parent,
            message,title,messageType,icon,selections,selections[[initial]]],
        result=javax`swing`JOptionPane`showInputDialog[parent,
            message]
        ];
      ];
    Return[result]
    ]



ShowFileChooser[
    title_String:"Select a file:",
    okText_String:"Open",
    dir_String:""]:=JavaBlock[Module[
      {directory=Directory[],dlg,chosenFile,result=Null},
      InstallJava[];
      dlg=JavaNew["javax.swing.JFileChooser"];
      If[dir=!="",directory=dir];
      dlg@setCurrentDirectory[JavaNew["java.io.File",directory]];
      dlg@setDialogTitle[title];
      If[dlg@showDialog[Null,okText]===
          javax`swing`JFileChooser`APPROVEUOPTION,
        chosenFile=dlg@getSelectedFile[];
        If[chosenFile=!=Null,result=chosenFile@getPath[]]
        ];
      result
      ]]

GetFilePathAndName[
    title_String:"Select a file:",
    okText_String:"Open",
    dir_String:""]:=JavaBlock[Module[
      {directory=Directory[],dlg,chosenFile,result=Null},
      InstallJava[];
      dlg=JavaNew["javax.swing.JFileChooser"];
      If[dir=!="",directory=dir];
      dlg@setCurrentDirectory[JavaNew["java.io.File",directory]];
      dlg@setDialogTitle[title];
      If[dlg@showDialog[Null,okText]===
          javax`swing`JFileChooser`APPROVEUOPTION,
        chosenFile=dlg@getSelectedFile[];
        If[chosenFile=!=Null,
          result={chosenFile@getPath[],chosenFile@getName[]}]
        ];
      result
      ]]



InstallJava[];
LoadJavaClass["java.awt.Color"];

NewJColorChooser[container_:Null,
    color_:java`awt`Color`white,
    tip_String:"JColorChooser"]:=Module[
    {chooser},
    InstallJava[];
    chooser=JavaNew["javax.swing.JColorChooser",color];
    JavaBlock[
      If[container =!= Null,
        container@add[chooser]
        ];
      chooser@setToolTipText[tip];
      ];
    Return[chooser]
    ]

InstallJava[];
LoadJavaClass["java.awt.Color"];

ShowColorChooser[color_:java`awt`Color`black,
    title_:"Color Chooser"]:=Module[
    {frm,pane,chooser,panel,
      button1,buttonListener1,buttonFunc1,
      button2,buttonListener2,buttonFunc2,
      button3,buttonListener3,buttonFunc3,
      result=Null},
    JavaBlock[
      InstallJava[];
      LoadJavaClass["java.awt.event.ActionEvent"];
      
      frm=JavaNew["com.wolfram.jlink.MathJFrame",title];
      pane=frm@getContentPane[];
      
      LoadJavaClass["javax.swing.BoxLayout"];
      pane@setLayout[
          JavaNew["javax.swing.BoxLayout",
            pane,
            javax`swing`BoxLayout`YUAXIS]
          ];
      
      (**)
      chooser=NewJColorChooser[pane,color];
      panel=NewJPanelEmptyBorder[pane];
      (**)
      
      LoadJavaClass["java.awt.FlowLayout"];
      panel@setLayout[JavaNew["java.awt.FlowLayout",
            java`awt`FlowLayout`CENTER,5,5]
          ];
      button1=NewJButton[panel,"OK"];
      button2=NewJButton[panel,"Cancel"];
      button3=NewJButton[panel,"Reset"];
      
      (**)
      buttonListener1=JavaNew["com.wolfram.jlink.MathActionListener"];
      buttonListener1@setHandler["actionPerformed",ToString[buttonFunc1]];
      button1@addActionListener[buttonListener1];
      
      buttonListener2=JavaNew["com.wolfram.jlink.MathActionListener"];
      buttonListener2@setHandler["actionPerformed",ToString[buttonFunc2]];
      button2@addActionListener[buttonListener2];
      
      buttonListener3=JavaNew["com.wolfram.jlink.MathActionListener"];
      buttonListener3@setHandler["actionPerformed",ToString[buttonFunc3]];
      button3@addActionListener[buttonListener3];
      
      buttonFunc1[event_,command_]:=JavaBlock[Module[
            {c=Null},
            EndModal[];
            c=chooser@getColor[];
            If[c=!=$Failed&&c=!=Null,
              result={c@getRed[],c@getGreen[],c@getBlue[]};
              frm@dispose[],
              result=Null
              ];
            ReleaseObject[event];
            ]];
      
      buttonFunc2[event_,command_]:=JavaBlock[Module[
            {},
            EndModal[];
            result=Null;
            frm@dispose[];
            ReleaseObject[event];
            ]];
      
      buttonFunc3[event_,command_]:=JavaBlock[Module[
            {},
            chooser@setColor[color];
            result=Null;
            ReleaseObject[event];
            ]];
      
      frm@pack[];
      JavaShow[frm];
      frm@setModal[];
      DoModal[];
      ];
    Return[result]
    ]



NewJTree[container_:Null,
    rootObj_:Null,
    leafIcon_:Null,
    openIcon_:Null,
    closedIcon_:Null,
    tip_String:"JTree"]:=Module[
    {tree,renderer,h={},max},
    InstallJava[];
    If[rootObj=!=Null,
      tree=JavaNew["javax.swing.JTree",rootObj],
      tree=JavaNew["javax.swing.JTree"]
      ];
    JavaBlock[
      If[leafIcon=!=Null,AppendTo[h,leafIcon@getIconHeight[]]];
      If[openIcon=!=Null,AppendTo[h,openIcon@getIconHeight[]]];
      If[closedIcon=!=Null,AppendTo[h,closedIcon@getIconHeight[]]];
      max=If[{}=!=Select[h,NumberQ],
          Max[Select[h,NumberQ]],
          0];
      If[max>0,tree@setRowHeight[max]];
      
      renderer=tree@getCellRenderer[];
      If[leafIcon=!=Null,renderer@setLeafIcon[leafIcon]];
      If[openIcon=!=Null,renderer@setOpenIcon[openIcon]];
      If[closedIcon=!=Null,renderer@setClosedIcon[closedIcon]];
      
      If[container =!= Null,
        container@add[tree]
        ];
      tree@setToolTipText[tip];
      ];
    Return[tree]
    ]





ShowProgressBar[title_String:"Computation Progress",
    caption_String:"Percent complete:",
    percent_Integer:0]:=Module[
    {frame,panel,label,bar},
    InstallJava[];
    bar=JavaNew["javax.swing.JProgressBar"];
    JavaBlock[
      frame=JavaNew["javax.swing.JFrame",title];
      frame@setSize[300,110];
      frame@setResizable[False];
      frame@setLocation[400,400];
      
      panel=JavaNew["javax.swing.JPanel"];
      panel@setLayout[Null];
      frame@getContentPane[]@add[panel];
      
      label=JavaNew["javax.swing.JLabel",caption];
      label@setBounds[20,10,260,20];
      panel@add[label];
      
      bar@setBounds[20,40,260,30];
      bar@setMinimum[0];
      bar@setMaximum[100];
      bar@setValue[percent];
      panel@add[bar];
      
      JavaShow[frame];
      bar
      ]
    ]

InstallJava[];
LoadJavaClass["javax.swing.SwingUtilities"];

DestroyProgressBar[bar_?JavaObjectQ]:=JavaBlock[
    SwingUtilities`windowForComponent[bar]@dispose[];
    ReleaseObject[bar]
    ]



ShowProgressMonitor[
    container_:Null,
    message_:Null,
    note_String:"Note",
    min_Integer:0,
    max_Integer:100]:=Module[
    {monitor},
    InstallJava[];
    monitor=JavaNew["javax.swing.ProgressMonitor",
        container,message,note,min,max];
    JavaBlock[
      monitor@setMillisToPopup[5000];
      ];
    Return[monitor]
    ]

InstallJava[];
LoadJavaClass["javax.swing.SwingUtilities"];

DestroyProgressMonitor[monitor_?JavaObjectQ]:=JavaBlock[Module[
      {},
      SwingUtilities`windowForComponent[monitor]@dispose[];
      ReleaseObject[monitor]
      ]]





End[]

Protect[ Evaluate[ $Context <> "*" ] ]

EndPackage[];

Print["Finished loading JavaSwing"]