(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[  16132238,     255597]*)
(*NotebookOutlinePosition[  16133463,     255636]*)
(*  CellTagsIndexPosition[  16133384,     255630]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
J/Link Programming:
JavaSwing Example\
\>", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell[TextData[StyleBox["J/Link enables us to handle Java objects within \
MATHEMATICA. The MATHEMATICA package \"JavaSwing.m\" was designed as \
collection of wrapper functions for the Java Swing classes. All basic aspects \
of these functions are shown in this Notebook.", "Subtitle",
  FontSize->16]], "Text",
  FontSlant->"Italic"],

Cell["Copyright \[Copyright] 2000-2002, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Loading the JavaSwing ",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["MATHEMATICA",
    FontSlant->"Italic",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox[" package",
    FontColor->RGBColor[1, 0, 0]]
}], "Section"],

Cell[BoxData[
    \(Off[General::spell, General::spell1]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[
    \("Loading JavaSwing..."\)], "Print"],

Cell[BoxData[
    \("Finished loading JavaSwing"\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[">>> com.wolfram.jlink.MathJFrame <<< ",
  FontColor->RGBColor[1, 0, 0]]], "Section"],

Cell[CellGroupData[{

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:00001h1P00`40o`00
0?l0003oo`000?l00022000000000hS0^4R@R4R@R03oB928odR@R7i8T8P1
000000000hS0^<SPf8S0^03oR<2hohS0^7f8`;P1B9280@00000000>8`;S8
h=R8`;P0ohS0^?n8`;QmR<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000003R<2hb>3HR<2h0?n8`;SoR<2hOHS0^058T8P10000
000018S0^<SPf8S0^8S0^1H0080300600P02P00400:100>100>100>10`04
P@801H401005PP06PP06PP06PP801h800`47PP48PP48PP020@R30`49P`<1
2X<00`4;P`4;Q04;Q0030@b40`4=Q0<13XD30Pn50`8@Q@@24HH30Q:60P8C
QP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<I
R0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`4
12><00@498`498d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>
00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`
T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7
=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`Po
UP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH
00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/3
2TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN
0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<
GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R3F:R008=
HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[
YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X
0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/3
47^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh0
0a62[P<APjh00a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa
4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?
/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG
]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN
^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/3
5ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn
5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/klf6;C00XS0^058T8P1
0000000018S0^<SPf8S0^8S0^0@008000i^WlC=3YC=3Y@09<d>U1P00P0<0
0H0200:000@00X400h400h400h4300B10P05P@0400F200J200J200J20P07
PP030@N20@R20@R2008128<30@V30`4:P`030@^30@^40@^400<138@30@f4
0`4>Q@<23hD30Q25108AQP<24XH20Q>600@24hL258L258L258L30QF70P8F
Q`040aJ80aN80aN80aN80`<HR0030aV80aV90aV900@36XT30a^90`<LRP<3
7HX311j:0`@OR`<488/3126;0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd3
1BJ=00<59hd59hh59hh00`DXSP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6
;I031Rj@0PH_T0041RnA1S2A1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHc
TP86=9800`LdTPLeTPLeTP021cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD
0`LjU0<7>iD323bE0`PmU@@8?YH323nF0PQ0UP04242G246G246G246G0`Q2
U`88@iL010U3V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9
BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd2
2e:M0`]CW@032eBM2eBN2eBN00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;
FIl335ZP0`aKX08<G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<
H:8<H:82366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@0
0`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^
Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?
MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/111m[00447j/47j]47j]
47n]0Q5o[@<AP:d00a61[A61[Q61[P034H:^0a63[P034HB^4HB_4HB_00<A
QJl44HJ_0a:7/0<BR;024XV`00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb
4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d
4i:d00<CTk@34iBd0a>E]@<DU[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLD
VkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@E
XKT35J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[
_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa
_`035k:o0aNc_cHH]<02R<2h0DR@R04000000004R<2hb>3HR<2hR<2h0`00
P007VjOaooooSWZfYY_4/jWBZ9g8/jWB00:VVl@01KbhgNk^m>[YlOoooc=3
Y@0500200`01P0800X001002P@03P@03P@03P@<0184200F100@01H801X80
1X801X8200N200<11h81288128800P48P`<12H<30@Z300<12h<12h@12h@0
0`4<Q0<13H@30@j50`8?Q@<248D40Q660`8BQP824hH0108CQ`8DQ`8DQ`8D
Q`<25HL20QJ700@35XP35hP35hP35hP30aR800<36HP36HT36HT010<JR@<3
6hT30ab:0`<MRP<47XX311n;0`@PR`<48H/312:<10@SS00412B<12B=12B=
12F=0PDUS@<59Xd00`DWS@DWSPDWSP031BR>0`DYSP031BZ>1BZ?1BZ?00<5
:hl41Bb?0`H]T0<6;Y021Rn@00@6;i46<946<946<9431S6A0PHbT@041S:B
1S>B1S>B1S>B0PHdTP031cBB1cFB1cFB0087=I<31cJC0`LgT`031cRC1cRD
1cRD00<7>I@31cZD0`LkU@<8?9D323fE10PnUP<8?iH2242F00@8@9L8@IL8
@IL8@IL324:G0PQ3U`042D>H2DBH2DBH2DBH0`U5V0032DJH2DJI2DJI00@9
AiT32DRI0`U9VP<9BYX32T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`010YAW0YA
W@YAW@YBW@8;DYd32e>M00<;E9d;E9h;E9h00`]EWP<;EYh00`]GWP]GW`]G
W`032eRO10]IW`<<FZ0335^P0PaLX00435bQ35fQ35fQ35fQ0`aNX@8<Gj40
10aOXPaPXPaPXPaPXP8<HJ800`eQXPeRXPeRXP023F:S0`eSX`<=I:<00`eU
X`eUY0eUY0033FJT0`eWY0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]YP043VfW
3VjW3VjW3VjW0`i_Y`8>L:L010m`Z0maZ0maZ0maZ0<?LZP00`mcZ0mcZ@mc
Z@043gBY0`meZ@<?MZX33gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`447f/00@@
OZ`@OZd@OZd@Ojd24Gn]0a60[@034H6]4H6^4H6^00<APZh34H>^00<AQ:hA
Q:lAQ:l00a65[`@AQZl34XN`0a:8/08BRK0011:9/A::/A::/A::/@<BRk42
4Xba00@BS;8BSK8BSK8BSK824Xjb00<CS[8CSk8CSk800Q>?/`<CT;<34i6c
00<CT[<CT[@CT[@00a>C]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI]P8DV[H0
11BJ]aBK]aBK]aBK]`<DW;L259fg00@EWKPEW[PEW[PEW[P35Inh00<EX;PE
X;TEX;T011FQ^@<EX[T35J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/35ZVl11JZ
_0045Z^l5Z^m5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn0aN`_P03
5k6n5k6o5k6o00<G/[l35k>o0QRd`20000026;C04000008H]<02R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h0P00P004VjOaooooK5ZU[jG:0[bhg@0:
oogo/jWBoooooooo_;SMUhZlZ9g8i^K/oooo<d>U1000P0<00H0200:000@0
0X400h400h400h4300B10P05P@0400F200J200J200J20P07PP030@N20@R2
0@R2008128<30@V30`4:P`030@^30@^40@^400<138@30@f40`4>Q@<23hD3
0Q25108AQP<24XH20Q>600@24hL258L258L258L30QF70P8FQ`040aJ80aN8
0aN80aN80`<HR0030aV80aV90aV900@36XT30a^90`<LRP<37HX311j:0`@O
R`<488/3126;0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=00<59hd5
9hh59hh00`DXSP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_
T0041RnA1S2A1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=9800`Ld
TPLeTPLeTP021cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD3
23bE0`PmU@@8?YH323nF0PQ0UP04242G246G246G246G0`Q2U`88@iL010U3
V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;
VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]CW@03
2eBM2eBN2eBN00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aK
X08<G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R
00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@3
3FRU0`iYY@<>JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W
00@?L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mg
ZP<@N:X347V[0a1jZ`<@Nj/347b/111m[00447j/47j]47j]47n]0Q5o[@<A
P:d00a61[A61[Q61[P034H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7
/0<BR;024XV`00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb
0Q:>/P034hjb4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@3
4iBd0a>E]@<DU[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg
0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS
^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G
[;d35jfm00<G[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc
_`8H]<000lSPf4R@R4R@R00<B92800<00038h=Q8T8P03DR@R00400006;C0
6;C0b>3H3TR@R00300006;C06;C000:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;P2002000^KYo7ooonXWLSoooncZM9PC9Z>N[IhIJjXWLSooooooOl0
0oooo`03<d>U0020002000<0080300600P02P00400:100>100>100>10`04
P@801H401005PP06PP06PP06PP801h800`47PP48PP48PP020@R30`49P`<1
2X<00`4;P`4;Q04;Q0030@b40`4=Q0<13XD30Pn50P8@Q@?oool20Q660`8B
QP824hH0108CQ`8DQ`8DQ`8DQ`<25HL20QJ700@35XP35hP35hP35hP30aR8
00<36HP36HT36HT010<JR@<36hT30ab:0`<MRP<47XX311n;0`@PR`<48H/3
12:<10@SS00412B<12B=12B=12F=0PDUS@<59Xd00`DWS@DWSPDWSP031BR>
0`DYSP031BZ>1BZ?1BZ?00<5:hl41Bb?0`H]T0<6;Y021Rn@00@6;i46<946
<946<9431S6A0PHbT@041S:B1S>B1S>B1S>B0PHdTP031cBB1cFB1cFB0087
=I<31cJC0`LgT`031cRC1cRD1cRD00<7>I@31cZD0`LkU@<8?9D323fE10Pn
UP<8?iH2242F00@8@9L8@IL8@IL8@IL324:G0PQ3U`042D>H2DBH2DBH2DBH
0`U5V0032DJH2DJI2DJI00@9AiT32DRI0`U9VP<9BYX32T^J0`Y<V`<:CI/3
2TjK0`Y?W0@:D9`010YAW0YAW@YAW@YBW@8;DYd32e>M00<;E9d;E9h;E9h0
0`]EWP<;EYh00`]GWP]GW`]GW`032eRO10]IW`<<FZ0335^P0PaLX00435bQ
35fQ35fQ35fQ0`aNX@8<Gj4010aOXPaPXPaPXPaPXP8<HJ800`eQXPeRXPeR
XP023F:S0`eSX`<=I:<00`eUX`eUY0eUY0033FJT0`eWY0<=J:D33VVU0`iZ
Y@@>JjH33VbV0Pi]YP043VfW3VjW3VjW3VjW0`i_Y`8>L:L010m`Z0maZ0ma
Z0maZ0<?LZP00`mcZ0mcZ@mcZ@043gBY0`meZ@<?MZX33gNZ0a1hZP<@NJ/3
47Z[0a1kZ`<@O:`447f/00@@OZ`@OZd@OZd@Ojd24Gn]0a60[@034H6]4H6^
4H6^00<APZh34H>^00<AQ:hAQ:lAQ:l00a65[`@AQZl34XN`0a:8/08BRK00
11:9/A::/A::/A::/@<BRk424Xba00@BS;8BSK8BSK8BSK824Xjb00<CS[8C
Sk8CSk800Q>?/`<CT;<34i6c00<CT[<CT[@CT[@00a>C]0<CU;@34iFe0aBF
]@<DUkD459Rf0aBI]P8DV[H011BJ]aBK]aBK]aBK]`<DW;L259fg00@EWKPE
W[PEW[PEW[P35Inh00<EX;PEX;TEX;T011FQ^@<EX[T35J>j0aFT^P<FYKX3
5ZJk0aJW^`<FZ;/35ZVl11JZ_0045Z^l5Z^m5Z^m5Zbm0QN/_@<G[Kd00aN^
_AN^_QN^_P035jnn0aN`_P035k6n5k6o5k6o00<G/[l35k>o0QRd`003b>3H
R<2hR<2h00^8`;P00dR@R0000<SPf00=R<2h00E8T8P0000H]<0H]<38h=P0
3HS0^004B92800006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0
^08008003Y^WlOooooooom_Lk61<VY>5^[>Yd[bhgF1<VYV?_ZJKa<S3gooo
oc=3Y@H00803oooo0P02P00300:1oooooooo00;oool200B100<01H7oool0
1H800`06PPCoool00`48PP48Poooo`03oooo0`4:P`06oooo0@^40@^40@b4
oooo0@b40P4=Q004oooo0@j5oooo0@j50P8?Q@04oooo0Q25oooo0Q250P8A
QP03oooo0Q660Q:600824XH20Q>600@24hL258L258L258L30QF70P8FQ`04
0aJ80aN80aN80aN80`<HR0030aV80aV90aV900@36XT30a^90`<LRP<37HX3
11j:0`@OR`<488/3126;0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=
00<59hd59hh59hh00`DXSP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I03
1Rj@0PH_T0041RnA1S2A1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86
=9800`LdTPLeTPLeTP021cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`Lj
U0<7>iD323bE0`PmU@@8?YH323nF0PQ0UP04242G246G246G246G0`Q2U`88
@iL010U3V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX3
2DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M
0`]CW@032eBM2eBN2eBN00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl3
35ZP0`aKX08<G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<
H:82366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eV
Y0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>
KjL23W2W00@?L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT3
3gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/111m[00447j/47j]47j]47n]
0Q5o[@<AP:d00a61[A61[Q61[P034H:^0a63[P034HB^4HB_4HB_00<AQJl4
4HJ_0a:7/0<BR;024XV`00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb
4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d
00<CTk@34iBd0a>E]@<DU[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLD
VkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT3
5J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[
_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`03
5k:o0aNc_`8H]<001<SPf8S0^8S0^8S0^0H00004R<2h00=8T8P00038h=P0
0XS0^0T00002R<2h00E8T8P0000H]<0H]<38h=P03HS0^004B92800006;C0
6;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^0<008003Y^WlOoookbh
gIV?__ooomKAgM_Lk??nojJKa>k^m8Ef/9>5^_oooc=3Y@@008001oooo`01
P001P001P?ooo`02P?ooo`0300>100Koool0184018401H7oool01H8200J2
00Soool01h801h811h;oool128;oool128<30@V300Coool12X<12X?oool2
0@^400<138Coool138@00P4=Q004oooo0@j5oooo0@j50P8?Q@03oooo0Q25
oooo00?oool20Q660`8BQP824hH0108CQ`8DQ`8DQ`8DQ`<25HL20QJ700@3
5XP35hP35hP35hP30aR800<36HP36HT36HT010<JR@<36hT30ab:0`<MRP<4
7XX311n;0`@PR`<48H/312:<10@SS00412B<12B=12B=12F=0PDUS@<59Xd0
0`DWS@DWSPDWSP031BR>0`DYSP031BZ>1BZ?1BZ?00<5:hl41Bb?0`H]T0<6
;Y021Rn@00@6;i46<946<946<9431S6A0PHbT@041S:B1S>B1S>B1S>B0PHd
TP031cBB1cFB1cFB0087=I<31cJC0`LgT`031cRC1cRD1cRD00<7>I@31cZD
0`LkU@<8?9D323fE10PnUP<8?iH2242F00@8@9L8@IL8@IL8@IL324:G0PQ3
U`042D>H2DBH2DBH2DBH0`U5V0032DJH2DJI2DJI00@9AiT32DRI0`U9VP<9
BYX32T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`010YAW0YAW@YAW@YBW@8;DYd3
2e>M00<;E9d;E9h;E9h00`]EWP<;EYh00`]GWP]GW`]GW`032eRO10]IW`<<
FZ0335^P0PaLX00435bQ35fQ35fQ35fQ0`aNX@8<Gj4010aOXPaPXPaPXPaP
XP8<HJ800`eQXPeRXPeRXP023F:S0`eSX`<=I:<00`eUX`eUY0eUY0033FJT
0`eWY0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]YP043VfW3VjW3VjW3VjW0`i_
Y`8>L:L010m`Z0maZ0maZ0maZ0<?LZP00`mcZ0mcZ@mcZ@043gBY0`meZ@<?
MZX33gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`447f/00@@OZ`@OZd@OZd@Ojd2
4Gn]0a60[@034H6]4H6^4H6^00<APZh34H>^00<AQ:hAQ:lAQ:l00a65[`@A
QZl34XN`0a:8/08BRK0011:9/A::/A::/A::/@<BRk424Xba00@BS;8BSK8B
SK8BSK824Xjb00<CS[8CSk8CSk800Q>?/`<CT;<34i6c00<CT[<CT[@CT[@0
0a>C]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI]P8DV[H011BJ]aBK]aBK]aBK
]`<DW;L259fg00@EWKPEW[PEW[PEW[P35Inh00<EX;PEX;TEX;T011FQ^@<E
X[T35J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/35ZVl11JZ_0045Z^l5Z^m5Z^m
5Zbm0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn0aN`_P035k6n5k6o5k6o00<G
/[l35k>o0QRd`004b>3HR<2hR<2hR<2h1P0000B8`;P00dR@R0000<SPf002
R<2h00<00028`;R8`;P01HS0^0050000R<2hR<2hB9280000008H]<001<SP
f8S0^8S0^8S0^0800004R<2h0P0000:8`;P014R@R00001Rd`1Rd`0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;P3002000nKYo7ooonISkjGR[cDdnS_
[;?oMW_^Wj]KF:FVVlBFWm9PC9Zl^=gooolc@jD00`00P007oooo00600060
0060oooo00:0oooo00<00h401_ooo`04P@04POooo`05POooo`801X802?oo
o`07PP07PP47P_ooo`48P_ooo`48P`<12H<02Oooo`4:Poooo`4;Poooo`4;
Q?ooo`4<Q?ooo`020@f400Coool13XGoool13XD20Pn500Coool248Goool2
48D40Q660`8BQP824hH0108CQ`8DQ`8DQ`8DQ`<25HL20QJ700@35XP35hP3
5hP35hP30aR800<36HP36HT36HT010<JR@<36hT30ab:0`<MRP<47XX311n;
0`@PR`<48H/312:<10@SS00412B<12B=12B=12F=0PDUS@<59Xd00`DWS@DW
SPDWSP031BR>0`DYSP031BZ>1BZ?1BZ?00<5:hl41Bb?0`H]T0<6;Y021Rn@
00@6;i46<946<946<9431S6A0PHbT@041S:B1S>B1S>B1S>B0PHdTP031cBB
1cFB1cFB0087=I<31cJC0`LgT`031cRC1cRD1cRD00<7>I@31cZD0`LkU@<8
?9D323fE10PnUP<8?iH2242F00@8@9L8@IL8@IL8@IL324:G0PQ3U`042D>H
2DBH2DBH2DBH0`U5V0032DJH2DJI2DJI00@9AiT32DRI0`U9VP<9BYX32T^J
0`Y<V`<:CI/32TjK0`Y?W0@:D9`010YAW0YAW@YAW@YBW@8;DYd32e>M00<;
E9d;E9h;E9h00`]EWP<;EYh00`]GWP]GW`]GW`032eRO10]IW`<<FZ0335^P
0PaLX00435bQ35fQ35fQ35fQ0`aNX@8<Gj4010aOXPaPXPaPXPaPXP8<HJ80
0`eQXPeRXPeRXP023F:S0`eSX`<=I:<00`eUX`eUY0eUY0033FJT0`eWY0<=
J:D33VVU0`iZY@@>JjH33VbV0Pi]YP043VfW3VjW3VjW3VjW0`i_Y`8>L:L0
10m`Z0maZ0maZ0maZ0<?LZP00`mcZ0mcZ@mcZ@043gBY0`meZ@<?MZX33gNZ
0a1hZP<@NJ/347Z[0a1kZ`<@O:`447f/00@@OZ`@OZd@OZd@Ojd24Gn]0a60
[@034H6]4H6^4H6^00<APZh34H>^00<AQ:hAQ:lAQ:l00a65[`@AQZl34XN`
0a:8/08BRK0011:9/A::/A::/A::/@<BRk424Xba00@BS;8BSK8BSK8BSK82
4Xjb00<CS[8CSk8CSk800Q>?/`<CT;<34i6c00<CT[<CT[@CT[@00a>C]0<C
U;@34iFe0aBF]@<DUkD459Rf0aBI]P8DV[H011BJ]aBK]aBK]aBK]`<DW;L2
59fg00@EWKPEW[PEW[PEW[P35Inh00<EX;PEX;TEX;T011FQ^@<EX[T35J>j
0aFT^P<FYKX35ZJk0aJW^`<FZ;/35ZVl11JZ_0045Z^l5Z^m5Z^m5Zbm0QN/
_@<G[Kd00aN^_AN^_QN^_P035jnn0aN`_P035k6n5k6o5k6o00<G/[l35k>o
0QRd`003b>3HR<2hR<2h00^8`;P00dR@R0000<SPf002R<2h00<00028`;R8
`;P01HS0^0050000R<2hR<2hB9280000008H]<000lSPf8S0^8S0^002R<2h
0P0000:8`;P200000hS0^004B92800006;C06;C00XS0^058T8P100000000
18S0^<SPf8S0^8S0^08008002Y^WlOoooiN:_7Y/Z[?7j:U^X<S3gi>5^U]6
TiV?_P9hIJh0148WQJnUb_oooc=3Y@@00803006000?oool00X000X401?oo
o`8018400oooo`05POooo`0300J21?ooo`030@R20@R30@R300<12H<02Ooo
o`4:Poooo`4;Poooo`4;Q?ooo`4<Q?ooo`020@f400Coool13XGoool13XD2
0Pn500?oool248Goool00oooo`824HH30Q:60P8CQP040Q>70QB70QB70QB7
0`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<IR0<IR@<IR@040aZ90`<K
R@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`412><00@498`498d498d4
9Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>00<5:Xh5:Xl5:Xl00`D[
S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`T@<6<I421S:A00@6<Y86
<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7=Y<31cNC00<7>9<7>9@7
>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`PoUP88@9H010Q0U`Q1U`Q1
U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH00<9AYP9AYT9AYT010U7
V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/32TnL10Y@W0042U6L2U6M
2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN0`]FWP032eNN2eNO2eNO
00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<GJ4<GJ4335jQ0PaOX@04
35nR362R362R362R0PaQXP033F6R3F:R3F:R008=HZ<33F>S0`eTX`033FFS
3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[YP<>K:H23VfV00@>KJL>
KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X0`mbZ0033g>X3g>Y3g>Y
00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/347^[0a1l[0@@OJ`0111n
[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh00a62[P<APjh00a64[Q64
[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa4XZa4XZa4XZa0a:;/@8B
S;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?/P024hnc0a>@/`<CTK<0
0a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG]@@DV;H359Vf0QBJ]P04
59Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN^1FN^0<EWkP00aFP^1FP
^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/35ZNk0aJX^`<FZK`45ZZl
00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn5jjn00<G[kh35k2n00<G
/KhG/KlG/Kl00aNb_`<G/kl26;C000?8h=R8`;R8`;P02hS0^003B9280000
b>3H00:8`;P00`0008S0^8S0^005R<2h00D00028`;R8`;Q8T8P000000QRd
`003b>3HR<2hR<2h00>8`;P4000018S0^004B92800006;C06;C00XS0^058
T8P10000000018S0^<SPf8S0^8S0^08008000i^WlOooooooo`02oooo00[o
[K3oMW_icMCmkNkooonVVlB5M[2l^=gooolc@jD500200`01P003oooo00:0
00:100<00h400oooo`04POooo`0200F100@01H;oool01X801X8200N200<1
1h;oool128800P48P`?oool20@Z300Ooool12h?oool12hCoool138Coool0
0P4=Q004oooo0@j5oooooooo0P8?Q@06oooo0Q25oooo0Q250Q66oooo0P8A
QP<24XH20Q>600@24hL258L258L258L30QF70P8FQ`040aJ80aN80aN80aN8
0`<HR0030aV80aV90aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3
126;0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh0
0`DXSP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA
1S2A1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLe
TP021cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`Pm
U@@8?YH323nF0PQ0UP04242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4
V0U4V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/3
2TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN
2eBN00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:00
10aLX@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=
HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iY
Y@<>JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?
LJP?LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X3
47V[0a1jZ`<@Nj/347b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61
[A61[Q61[P034H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;02
4XV`00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P03
4hjb4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E
]@<DU[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`04
5Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X3
5ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm
00<G[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_`8H]<00
0lSPf8S0^8S0^00;R<2h00=8T8P00038h=P00XS0^0030000R<2hR<2h00F8
`;P01@0008S0^8S0^4R@R00000026;C000?8h=R8`;R8`;P018S0^0800005
R<2h00A8T8P0000H]<0H]<02R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
0`00P00:XJcbnLgDhRHlm;FohRHlm6emo>?YoooooNg^ojf`0_ooo`03<d>U
0020002000@00803006000?oool00X000X400oooo`8018401Oooo`05P@05
P@05P_ooo`0200J20oooo`8128800`48Poooo`49P`020@V30P4:P`04oooo
0@^30@^4oooo0P4<Q007oooo0@f40@f4oooo0@j5oooo0@j500;oool00`8?
Q@8@Q@8@Q@04oooo00@24HH24XH24XH24XH20Q>600@24hL258L258L258L3
0QF70P8FQ`040aJ80aN80aN80aN80`<HR0030aV80aV90aV900@36XT30a^9
0`<LRP<37HX311j:0`@OR`<488/3126;0`@RS0@48h`010@TS0@TS@@TS@@U
S@859Hd31BJ=00<59hd59hh59hh00`DXSP<5:Hh00`DZSPDZS`DZS`031B^?
10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A1S2A0`HaT@86<Y4010HbTPHc
TPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC0`LfT`<7=i<00`LhT`LhU0Lh
U0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH323nF0PQ0UP04242G246G246G
246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6V@042DNI
0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:
DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;EIh32eJN00<;Eih;Eil;Eil0
0`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ00@<
Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=
IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>KJH010i]Y`i^
Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?LjT0
10mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/111m[00447j/
47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61[P034H:^0a63[P034HB^4HB_
4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@BRK4BR[4BR[4BR[434X^a0Q:<
/@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008CSk<34i2c0a>A/`03
4i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D359Ne11BH]P<DVKH259Zf00@D
V[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i
5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`0
11J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h00aN__P<G/;h00aNa
_QNa_aNa_`035k:o0aNc_`8H]<000lSPf8S0^8S0^00;R<2h00=8T8P00038
h=P00XS0^0030000R<2hR<2h00F8`;P01@0008S0^8S0^4R@R00000026;C0
00?8h=R8`;R8`;P00hS0^0@00004R<2h00A8T8P0000H]<0H]<02R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h0P00P00=VjOaoNg^hRHlo_GhmhVGm69^
lj2^m69^oogoojf`o>?Yoooo<d>U00L00803006000?oool00X000X400`03
P@<0184200F100@01H801X801X801X8200N200D11h81288128;oool128<0
0`49P`<12X<00`4;P`4;Q04;Q0030@b40`4=Q0<13XD30Pn50`8@Q@@24HH3
0Q:60P8CQP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<3
68P00`<IR0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@Q
R`<48X`412><00@498`498d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5
:8h31BV>00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`
T@H`T@H`T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7=987=I87=I80
0PLeT`<7=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID4
23jF0`PoUP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9
A9P32DFH00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=
V`<:CY/32TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]D
WP032eFN0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<
G:4<GJ4<GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R
3F:R008=HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD3
3VZU10i[YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X
3g6X3g6X0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1i
Z`<@NZ/347^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdA
PJhAPJh00a62[P<APjh00a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9
/0044XVa4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>
/Q>?/Q>?/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD3
59Je0aBG]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM
^1FN^1FN^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU
^P<FY[/35ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@03
5jjm5jjn5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/kl26;C000?8
h=R8`;R8`;P02hS0^003B9280000b>3H00:8`;P00`0008S0^8S0^005R<2h
00D00028`;R8`;Q8T8P000000QRd`003b>3HR<2hR<2h00:8`;P200000XS0
^0800003R<2h00A8T8P0000H]<0H]<02R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h0P00P003VjOam/S<hRHl00;o[K001mlT;_nTW_JlaOn]/>ikS?oo
oc=3Y@0800200`01P003oooo00:000:100<00h4300B10P05P@0400F200J2
00J200J20P07PP050@N20@R20@R2oooo0@R300<12H<01?ooo`4:P`4:P`4;
P`812h@30@b40`4=Q0<13XD30Pn50`8@Q@@24HH30Q:60P8CQP040Q>70QB7
0QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<IR0<IR@<IR@04
0aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`412><00@498`4
98d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>00<5:Xh5:Xl5
:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`T@<6<I421S:A
00@6<Y86<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7=Y<31cNC00<7
>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`PoUP88@9H010Q0
U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH00<9AYP9AYT9
AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/32TnL10Y@W004
2U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN0`]FWP032eNN
2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<GJ4<GJ4335jQ
0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R3F:R008=HZ<33F>S0`eT
X`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[YP<>K:H23VfV
00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X0`mbZ0033g>X
3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/347^[0a1l[0@@
OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh00a62[P<APjh0
0a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa4XZa4XZa4XZa
0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?/P024hnc0a>@
/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG]@@DV;H359Vf
0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN^1FN^0<EWkP0
0aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/35ZNk0aJX^`<F
ZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn5jjn00<G[kh3
5k2n00<G/KhG/KlG/Kl00aNb_`<G/kl26;C000?8h=R8`;R8`;P02hS0^003
B9280000b>3H00:8`;P900000XS0^005B92800006;C06;C0b>3H00>8`;P2
000018S0^0800002R<2h00A8T8P0000H]<0H]<02R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h0P00P003VjOanLgDmhVG00;oool01on]/>4F=?mfNonT
W^8V??n9Oc=3Y@0800200`01P003oooo00:000:100<00h4300B10P05P@04
00F200J200J200J20P07PP040@N20@R20@R20@R31?ooo`<12X<00`4;P`4;
Q04;Q0030@b40P4=Q004oooo0@j50@j50@j50`8?Q@<248D40Q660`8BQP82
4hH0108CQ`8DQ`8DQ`8DQ`<25HL20QJ700@35XP35hP35hP35hP30aR800<3
6HP36HT36HT010<JR@<36hT30ab:0`<MRP<47XX311n;0`@PR`<48H/312:<
10@SS00412B<12B=12B=12F=0PDUS@<59Xd00`DWS@DWSPDWSP031BR>0`DY
SP031BZ>1BZ?1BZ?00<5:hl41Bb?0`H]T0<6;Y021Rn@00@6;i46<946<946
<9431S6A0PHbT@041S:B1S>B1S>B1S>B0PHdTP031cBB1cFB1cFB0087=I<3
1cJC0`LgT`031cRC1cRD1cRD00<7>I@31cZD0`LkU@<8?9D323fE10PnUP<8
?iH2242F00@8@9L8@IL8@IL8@IL324:G0PQ3U`042D>H2DBH2DBH2DBH0`U5
V0032DJH2DJI2DJI00@9AiT32DRI0`U9VP<9BYX32T^J0`Y<V`<:CI/32TjK
0`Y?W0@:D9`010YAW0YAW@YAW@YBW@8;DYd32e>M00<;E9d;E9h;E9h00`]E
WP<;EYh00`]GWP]GW`]GW`032eRO10]IW`<<FZ0335^P0PaLX00435bQ35fQ
35fQ35fQ0`aNX@8<Gj4010aOXPaPXPaPXPaPXP8<HJ800`eQXPeRXPeRXP02
3F:S0`eSX`<=I:<00`eUX`eUY0eUY0033FJT0`eWY0<=J:D33VVU0`iZY@@>
JjH33VbV0Pi]YP043VfW3VjW3VjW3VjW0`i_Y`8>L:L010m`Z0maZ0maZ0ma
Z0<?LZP00`mcZ0mcZ@mcZ@043gBY0`meZ@<?MZX33gNZ0a1hZP<@NJ/347Z[
0a1kZ`<@O:`447f/00@@OZ`@OZd@OZd@Ojd24Gn]0a60[@034H6]4H6^4H6^
00<APZh34H>^00<AQ:hAQ:lAQ:l00a65[`@AQZl34XN`0a:8/08BRK0011:9
/A::/A::/A::/@<BRk424Xba00@BS;8BSK8BSK8BSK824Xjb00<CS[8CSk8C
Sk800Q>?/`<CT;<34i6c00<CT[<CT[@CT[@00a>C]0<CU;@34iFe0aBF]@<D
UkD459Rf0aBI]P8DV[H011BJ]aBK]aBK]aBK]`<DW;L259fg00@EWKPEW[PE
W[PEW[P35Inh00<EX;PEX;TEX;T011FQ^@<EX[T35J>j0aFT^P<FYKX35ZJk
0aJW^`<FZ;/35ZVl11JZ_0045Z^l5Z^m5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^
_QN^_P035jnn0aN`_P035k6n5k6o5k6o00<G/[l35k>o0QRd`003b>3HR<2h
R<2h00^8`;P00dR@R0000<SPf002R<2h2@0000:8`;P01DR@R00001Rd`1Rd
`<SPf00=R<2h00A8T8P0000H]<0H]<02R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h0P00P007VjOaoooolj2^m69^oooomhVGnLgD00;oool00o>P[_oo
oc=3Y@0800200`01P0800X001002P@03P@03P@03P@<0184200F100@01H80
1X801X801X8200N200<11h81288128800P48P`<12H<30@Z300<12h<12h@1
2h@00`4<Q0<13H@30@j50`8?Q@<248D40Q660`8BQP824hH0108CQ`8DQ`8D
Q`8DQ`<25HL20QJ700@35XP35hP35hP35hP30aR800<36HP36HT36HT010<J
R@<36hT30ab:0`<MRP<47XX311n;0`@PR`<48H/312:<10@SS00412B<12B=
12B=12F=0PDUS@<59Xd00`DWS@DWSPDWSP031BR>0`DYSP031BZ>1BZ?1BZ?
00<5:hl41Bb?0`H]T0<6;Y021Rn@00@6;i46<946<946<9431S6A0PHbT@04
1S:B1S>B1S>B1S>B0PHdTP031cBB1cFB1cFB0087=I<31cJC0`LgT`031cRC
1cRD1cRD00<7>I@31cZD0`LkU@<8?9D323fE10PnUP<8?iH2242F00@8@9L8
@IL8@IL8@IL324:G0PQ3U`042D>H2DBH2DBH2DBH0`U5V0032DJH2DJI2DJI
00@9AiT32DRI0`U9VP<9BYX32T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`010YA
W0YAW@YAW@YBW@8;DYd32e>M00<;E9d;E9h;E9h00`]EWP<;EYh00`]GWP]G
W`]GW`032eRO10]IW`<<FZ0335^P0PaLX00435bQ35fQ35fQ35fQ0`aNX@8<
Gj4010aOXPaPXPaPXPaPXP8<HJ800`eQXPeRXPeRXP023F:S0`eSX`<=I:<0
0`eUX`eUY0eUY0033FJT0`eWY0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]YP04
3VfW3VjW3VjW3VjW0`i_Y`8>L:L010m`Z0maZ0maZ0maZ0<?LZP00`mcZ0mc
Z@mcZ@043gBY0`meZ@<?MZX33gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`447f/
00@@OZ`@OZd@OZd@Ojd24Gn]0a60[@034H6]4H6^4H6^00<APZh34H>^00<A
Q:hAQ:lAQ:l00a65[`@AQZl34XN`0a:8/08BRK0011:9/A::/A::/A::/@<B
Rk424Xba00@BS;8BSK8BSK8BSK824Xjb00<CS[8CSk8CSk800Q>?/`<CT;<3
4i6c00<CT[<CT[@CT[@00a>C]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI]P8D
V[H011BJ]aBK]aBK]aBK]`<DW;L259fg00@EWKPEW[PEW[PEW[P35Inh00<E
X;PEX;TEX;T011FQ^@<EX[T35J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/35ZVl
11JZ_0045Z^l5Z^m5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn0aN`
_P035k6n5k6o5k6o00<G/[l35k>o0QRd`003b>3HR<2hR<2h00^8`;P00dR@
R0000<SPf00=R<2h00E8T8P0000H]<0H]<38h=P03HS0^004B92800006;C0
6;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^0<008002i^WlOoooon9
Oooooo>P[_6CXOooooomoo>P[_oko3=3Y@0800200`01P0800X001002P@03
P@03P@03P@<0184200F100@01H801X801X801X8200N200<11h8128812880
0P48P`<12H<30@Z300<12h<12h@12h@00`4<Q0<13H@30@j50`8?Q@<248D4
0Q660`8BQP824hH0108CQ`8DQ`8DQ`8DQ`<25HL20QJ700@35XP35hP35hP3
5hP30aR800<36HP36HT36HT010<JR@<36hT30ab:0`<MRP<47XX311n;0`@P
R`<48H/312:<10@SS00412B<12B=12B=12F=0PDUS@<59Xd00`DWS@DWSPDW
SP031BR>0`DYSP031BZ>1BZ?1BZ?00<5:hl41Bb?0`H]T0<6;Y021Rn@00@6
;i46<946<946<9431S6A0PHbT@041S:B1S>B1S>B1S>B0PHdTP031cBB1cFB
1cFB0087=I<31cJC0`LgT`031cRC1cRD1cRD00<7>I@31cZD0`LkU@<8?9D3
23fE10PnUP<8?iH2242F00@8@9L8@IL8@IL8@IL324:G0PQ3U`042D>H2DBH
2DBH2DBH0`U5V0032DJH2DJI2DJI00@9AiT32DRI0`U9VP<9BYX32T^J0`Y<
V`<:CI/32TjK0`Y?W0@:D9`010YAW0YAW@YAW@YBW@8;DYd32e>M00<;E9d;
E9h;E9h00`]EWP<;EYh00`]GWP]GW`]GW`032eRO10]IW`<<FZ0335^P0PaL
X00435bQ35fQ35fQ35fQ0`aNX@8<Gj4010aOXPaPXPaPXPaPXP8<HJ800`eQ
XPeRXPeRXP023F:S0`eSX`<=I:<00`eUX`eUY0eUY0033FJT0`eWY0<=J:D3
3VVU0`iZY@@>JjH33VbV0Pi]YP043VfW3VjW3VjW3VjW0`i_Y`8>L:L010m`
Z0maZ0maZ0maZ0<?LZP00`mcZ0mcZ@mcZ@043gBY0`meZ@<?MZX33gNZ0a1h
ZP<@NJ/347Z[0a1kZ`<@O:`447f/00@@OZ`@OZd@OZd@Ojd24Gn]0a60[@03
4H6]4H6^4H6^00<APZh34H>^00<AQ:hAQ:lAQ:l00a65[`@AQZl34XN`0a:8
/08BRK0011:9/A::/A::/A::/@<BRk424Xba00@BS;8BSK8BSK8BSK824Xjb
00<CS[8CSk8CSk800Q>?/`<CT;<34i6c00<CT[<CT[@CT[@00a>C]0<CU;@3
4iFe0aBF]@<DUkD459Rf0aBI]P8DV[H011BJ]aBK]aBK]aBK]`<DW;L259fg
00@EWKPEW[PEW[PEW[P35Inh00<EX;PEX;TEX;T011FQ^@<EX[T35J>j0aFT
^P<FYKX35ZJk0aJW^`<FZ;/35ZVl11JZ_0045Z^l5Z^m5Z^m5Zbm0QN/_@<G
[Kd00aN^_AN^_QN^_P035jnn0aN`_P035k6n5k6o5k6o00<G/[l35k>o0QRd
`0o8h=P00`000<SPf<SPf00=b>3H00<0000H]<0H]<003lSPf00300006;C0
6;C000:8`;P1B9280@00000000B8`;S8h=R8`;R8`;P400200i^Wl@06oooo
lj2^m;Fom[c5nmWJ<d>U2@00P0<00H0200:000@00X400h400h400h4300B1
0P05P@0400F200J200J200J20P07PP030@N20@R20@R2008128<30@V30`4:
P`030@^30@^40@^400<138@30@f40`4>Q@<23hD30Q25108AQP<24XH20Q>6
00@24hL258L258L258L30QF70P8FQ`040aJ80aN80aN80aN80`<HR0030aV8
0aV90aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;0`@RS0@4
8h`010@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DXSP<5:Hh0
0`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A1S2A
0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC0`Lf
T`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH323nF
0PQ0UP04242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9AIP0
0`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:
Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;EIh3
2eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aMX@aM
X@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ800PeR
X`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V
0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP3
3g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@
Nj/347b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61[P03
4H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@BRK4B
R[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb
008CSk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D359Ne
11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh
5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV^`<F
Yk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG
[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_cHH]<02R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h5P00P0<00H0200:000@00X400h400h400h43
00B10P05P@0400F200J200J200J20P07PP030@N20@R20@R2008128<30@V3
0`4:P`030@^30@^40@^400<138@30@f40`4>Q@<23hD30Q25108AQP<24XH2
0Q>600@24hL258L258L258L30QF70P8FQ`040aJ80aN80aN80aN80`<HR003
0aV80aV90aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;0`@R
S0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DXSP<5
:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A
1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC
0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH3
23nF0PQ0UP04242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9
AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>
V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;
EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aM
X@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ80
0PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD4
3V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?
LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1j
Z`<@Nj/347b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61
[P034H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@B
RK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb
4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D3
59Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh
5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV
^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG
[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_cHH]<02R<2h0DR@
R04000000003R<2hb>3HR<2h0?n8`;SoR<2hOHS0^058T8P1000000000hS0
^<SPf8S0^03oR<2hohS0^7f8`;P1B9280@00000000>8`;S8h=S8h=P0olSP
f?o8h=Qmb>3H0DR@R04000000?n8`;SoR<2hPHS0^04000000001\
\>"], "Graphics",
  ImageSize->{640, 480},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:00001h2000`400?l00000o`00003o00?ok^k^
ooooooo^k^h00oo^k^h00oooooook^k^onk^kP0Eonk^kP03ooooooo^k^kok^k^00Wok^k^00Cooooo
onk^k_o^k^kooooo1oo^k^h01Oooooook^k^onk^k_o^k^kooooo00Gok^k^00?oooooonk^k_o^k^h0
0oo^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^k^kok^k^00Gok^k^00Goooooonk^k_o^k^ko
k^k^ooooo`04onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h04?o^k^h01Ooooooo
k^k^onk^k_o^k^kooooo00?ok^k^00?oooooonk^k_o^k^h00_o^k^h00oooooook^k^onk^kP03onk^
kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h01oo^k^h00oooooook^k^onk^kP04onk^
kP05ooooooo^k^kok^k^onk^k_ooool02_o^k^h00oooooook^k^onk^kP08onk^kP03ooooooo^k^ko
k^k^00;ok^k^00?oooooonk^k_o^k^h03?o^k^h01Oooooook^k^onk^k_o^k^kooooo00Ook^k^00?o
ooooonk^k_o^k^h00oo^k^h00oooooook^k^onk^kP07onk^kP05ooooooo^k^kok^k^onk^k_ooool0
3oo^k^h01?ooooook^k^onk^k_oooolConk^kP05ooooooo^k^kok^k^onk^k_ooool02_o^k^h00ooo
ooook^k^onk^kP03onk^kP04ooooooo^k^kok^k^ooooo`ook^k^00Coooooonk^k_o^k^kooooo0oo^
k^h00oooooook^k^onk^kP06onk^kP03ooooooo^k^kok^k^00Kok^k^00?oooooonk^k_o^k^h01Oo^
k^h00oooooook^k^onk^kP0Ionk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h00oo^
k^h01?ooooook^k^onk^k_ooool>onk^kP03ooooooo^k^kok^k^00Wok^k^00Goooooonk^k_o^k^ko
k^k^ooooo`0:onk^kP04ooooooo^k^kok^k^ooooo`Cok^k^00?oooooonk^k_o^k^h01_o^k^h00ooo
ooook^k^onk^kP06onk^kP03ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^k^h01oo^k^h01Ooo
ooook^k^onk^k_o^k^kooooo00Ook^k^00?oooooonk^k_o^k^h07_o^k^h01Oooooook^k^onk^k_o^
k^kooooo01?ok^k^00?oooooonk^k_o^k^h02?o^k^h01?ooooook^k^onk^k_ooool4onk^kP03oooo
ooo^k^kok^k^00Wok^k^00?oooooonk^k_o^k^h01_o^k^h00oooooook^k^onk^kP05onk^kP03oooo
ooo^k^kok^k^00cok^k^00Goooooonk^k_o^k^kok^k^ooooo`06onk^kP03ooooooo^k^kok^k^00Co
k^k^00?ogMgMooooooooool03?ooool000Sok^k^00Coooooonk^k_o^k^kooooo0oo^k^h00ooooooo
k^k^onk^kP05onk^kP05ooooooo^k^kok^k^onk^k_ooool01?o^k^h01Oooooook^k^onk^k_o^k^ko
oooo00[ok^k^00?oooooonk^k_o^k^h02Oo^k^h00oooooook^k^onk^kP04onk^kP03ooooooo^k^ko
k^k^00;ok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^onk^kP0Eonk^kP03ooooooo^k^ko
k^k^00?ok^k^00?oooooonk^k_o^k^h05_o^k^h00oooooook^k^onk^kP0Lonk^kP03ooooooo^k^ko
k^k^00;ok^k^00?oooooonk^k_o^k^h01Oo^k^h01Oooooook^k^onk^k_o^k^kooooo00_ok^k^00Co
ooooonk^k_o^k^kooooo3Oo^k^h01?ooooook^k^onk^k_ooool;onk^kP03ooooooo^k^kok^k^013o
k^k^00?oooooonk^k_o^k^h00_o^k^h00oooooook^k^onk^kP09onk^kP05ooooooo^k^kok^k^onk^
k_ooool01?o^k^h00oooooook^k^onk^kP08onk^kP04ooooooo^k^kok^k^oooooa7ok^k^00Gooooo
onk^k_o^k^kok^k^ooooo`03onk^kP03ooooooo^k^kok^k^00Ook^k^00?oooooonk^k_o^k^h00_o^
k^h00oooooook^k^onk^kP07onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h02?o^
k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP03
ooooooo^k^kok^k^00cok^k^00?oooooonk^k_o^k^h01oo^k^h01Oooooook^k^onk^k_o^k^kooooo
00cok^k^00?oooooonk^k_o^k^h03Oo^k^h00oooooook^k^onk^kP08onk^kP05ooooooo^k^kok^k^
onk^k_ooool01?o^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^k^kok^k^00_ok^k^00?ooooo
onk^k_o^k^h03Oo^k^h00oooooook^k^onk^kP03onk^kP05ooooooo^k^kok^k^onk^k_ooool01?o^
k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00Coooooonk^k_o^k^kooooo3oo^k^h01Ooooooo
k^k^onk^k_o^k^kooooo00Kok^k^00Coooooonk^k_o^k^kooooo1_o^k^h00oooooook^k^onk^kP02
onk^kP03ooooooo^k^kok^k^013ok^k^00?oooooonk^k_o^k^h01?o^k^h00oooooook^k^onk^kP06
onk^kP03ooooooo^k^kok^k^00Kok^k^00Coooooonk^k_o^k^kooooo3_o^k^h00oooooook^k^onk^
kP03onk^kP03ooooooo^k^kok^k^00;ok^k^00CogMgMooooooooooook^k^0oooool01OoMgMgooooo
oooooooooooogMgM00?ooooo0004onk^kP03ooooooo^k^kok^k^00kok^k^00?oooooonk^k_o^k^h0
3_o^k^h00oooooook^k^onk^kP08onk^kP03ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^k^h0
0oo^k^h00oooooook^k^onk^kP0=onk^kP03ooooooo^k^kok^k^00;ok^k^00Goooooonk^k_o^k^ko
k^k^ooooo`03onk^kP05ooooooo^k^kok^k^onk^k_ooool00_o^k^h01Oooooook^k^onk^k_o^k^ko
oooo00Cok^k^00?oooooonk^k_o^k^h01_o^k^h00oooooook^k^onk^kP06onk^kP03ooooooo^k^ko
k^k^00;ok^k^00?oooooonk^k_o^k^h02?o^k^h00oooooook^k^onk^kP02onk^kP03ooooooo^k^ko
k^k^00;ok^k^00Goooooonk^k_o^k^kok^k^ooooo`02onk^kP03ooooooo^k^kok^k^00;ok^k^00?o
ooooonk^k_o^k^h02oo^k^h00oooooook^k^onk^kP08onk^kP03ooooooo^k^kok^k^00;ok^k^00?o
ooooonk^k_o^k^h01_o^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^k^kok^k^00Wok^k^00?o
ooooonk^k_o^k^h02?o^k^h00oooooook^k^onk^kP02onk^kP03ooooooo^k^kok^k^00;ok^k^00Co
ooooonk^k_o^k^kooooo3_o^k^h00oooooook^k^onk^kP08onk^kP03ooooooo^k^kok^k^00;ok^k^
00Goooooonk^k_o^k^kok^k^ooooo`0:onk^kP05ooooooo^k^kok^k^onk^k_ooool00_o^k^h00ooo
ooook^k^onk^kP0?onk^kP03ooooooo^k^kok^k^00cok^k^00?oooooonk^k_o^k^h00_o^k^h00ooo
ooook^k^onk^kP0:onk^kP05ooooooo^k^kok^k^onk^k_ooool05oo^k^h01Oooooook^k^onk^k_o^
k^kooooo00gok^k^00?oooooonk^k_o^k^h01_o^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^
k^kok^k^00Cok^k^00?oooooonk^k_o^k^h00_o^k^h01Oooooook^k^onk^k_o^k^kooooo00[ok^k^
00?oooooonk^k_o^k^h03_o^k^h00oooooook^k^onk^kP07onk^kP03ooooooo^k^kok^k^00Sok^k^
00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^onk^kP0<onk^kP03ooooooo^k^kok^k^017ok^k^
00Coooooonk^k_o^k^kooooo0oo^k^h00oooooook^k^onk^kP07onk^kP03ooooooo^k^kok^k^01So
k^k^00?oooooonk^k_o^k^h00_o^k^h01?ooooook^k^onk^k_ooool4onk^kP03ooooooo^k^kok^k^
00Gok^k^00?oooooonk^k_o^k^h01oo^k^h01?ooooook^k^onk^k_ooool8onk^kP03ooooooo^k^ko
k^k^00Cok^k^00?oooooonk^k_o^k^h02oo^k^h03_ooooooc<c<oooooooMgMgoR8R8omgMgOoooooo
gMgMohR8R?o^k^koooooomgMgOn8R8Sok^k^0_ooool00003onk^k_ooooook^k^00?ok^k^00?ooooo
onk^k_o^k^h01?o^k^h00oooooook^k^onk^kP02onk^kP03ooooooo^k^kok^k^00?ok^k^00?ooooo
onk^k_o^k^h00_o^k^h00oooooook^k^onk^kP08onk^kP04ooooooo^k^kok^k^ooooo`Sok^k^00?o
ooooonk^k_o^k^h02Oo^k^h00oooooook^k^onk^kP02onk^kP05ooooooo^k^kok^k^onk^k_ooool0
9Oo^k^h00oooooook^k^onk^kP05onk^kP03ooooooo^k^kok^k^00Gok^k^00?oooooonk^k_o^k^h0
0_o^k^h00oooooook^k^onk^kP08onk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h0
4?o^k^h00oooooook^k^onk^kP02onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h0
4Oo^k^h01Oooooook^k^onk^k_o^k^kooooo00Gok^k^00?oooooonk^k_o^k^h02oo^k^h00ooooooo
k^k^onk^kP0<onk^kP03ooooooo^k^kok^k^00Kok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^
kP03ooooooo^k^kok^k^00;ok^k^00Goooooonk^k_o^k^kok^k^ooooo`0?onk^kP03ooooooo^k^ko
k^k^017ok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^onk^kP06onk^kP03ooooooo^k^ko
k^k^00Cok^k^00?oooooonk^k_o^k^h01?o^k^h00oooooook^k^onk^kP06onk^kP03ooooooo^k^ko
k^k^00cok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP05ooooooo^k^kok^k^onk^k_ooool0
1?o^k^h00oooooook^k^onk^kP08onk^kP05ooooooo^k^kok^k^onk^k_ooool00_o^k^h00ooooooo
k^k^onk^kP04onk^kP03ooooooo^k^kok^k^00Gok^k^00?oooooonk^k_o^k^h00_o^k^h00ooooooo
k^k^onk^kP0=onk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h00oo^k^h00ooooooo
k^k^onk^kP04onk^kP03ooooooo^k^kok^k^00[ok^k^00?oooooonk^k_o^k^h01_o^k^h01Ooooooo
k^k^onk^k_o^k^kooooo00Gok^k^00?oooooonk^k_o^k^h01_o^k^h01?ooooook^k^onk^k_ooool;
onk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h01?o^k^h00oooooook^k^onk^kP0<
onk^kP03ooooooo^k^kok^k^00Gok^k^00?oooooonk^k_o^k^h00oo^k^h01Oooooook^k^onk^k_o^
k^kooooo00?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP03ooooooo^k^kok^k^013ok^k^
00?oooooonk^k_o^k^h01_o^k^h00oooooook^k^onk^kP0=onk^kP05ooooooo^k^kok^k^onk^k_oo
ool01_o^k^h01?ooooook^k^onk^k_ooool9onk^kP0>omgMgOooooooooooomgMgOn8R8SogMgMoooo
oooMgMgoR8R8onk^k_oooooogMgMohR8R?oMgMd1ooooo`002_o^k^h00oooooook^k^onk^kP03onk^
kP03ooooooo^k^kok^k^013ok^k^00?oooooonk^k_o^k^h02?o^k^h00oooooook^k^onk^kP09onk^
kP03ooooooo^k^kok^k^01;ok^k^00?oooooonk^k_o^k^h00oo^k^h01Oooooook^k^onk^k_o^k^ko
oooo00?ok^k^00?oooooonk^k_o^k^h01?o^k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00?o
ooooonk^k_o^k^h00_o^k^h01Oooooook^k^onk^k_o^k^kooooo00Cok^k^00?oooooonk^k_o^k^h0
2oo^k^h01?ooooook^k^onk^k_ooool=onk^kP03ooooooo^k^kok^k^00Cok^k^00Goooooonk^k_o^
k^kok^k^ooooo`04onk^kP03ooooooo^k^kok^k^00[ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03
onk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h03oo^k^h01Oooooook^k^onk^k_o^
k^kooooo00?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP05ooooooo^k^kok^k^onk^k_oo
ool02oo^k^h00oooooook^k^onk^kP0Fonk^kP03ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^
k^h01oo^k^h00oooooook^k^onk^kP02onk^kP03ooooooo^k^kok^k^00Cok^k^00Goooooonk^k_o^
k^kok^k^ooooo`03onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h01?o^k^h00ooo
ooook^k^onk^kP0>onk^kP03ooooooo^k^kok^k^00;ok^k^00Coooooonk^k_o^k^kooooo0oo^k^h0
1Oooooook^k^onk^k_o^k^kooooo01Ook^k^00Goooooonk^k_o^k^kok^k^ooooo`0=onk^kP03oooo
ooo^k^kok^k^01;ok^k^00Coooooonk^k_o^k^kooooo0oo^k^h00oooooook^k^onk^kP0?onk^kP03
ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^k^h01?o^k^h00oooooook^k^onk^kP03onk^kP05
ooooooo^k^kok^k^onk^k_ooool03_o^k^h01Oooooook^k^onk^k_o^k^kooooo00Wok^k^00Gooooo
onk^k_o^k^kok^k^ooooo`04onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h00_o^
k^h00oooooook^k^onk^kP05onk^kP04ooooooo^k^kok^k^ooooo`Kok^k^00?oooooonk^k_o^k^h0
0oo^k^h00oooooook^k^onk^kP0Fonk^kP05ooooooo^k^kok^k^onk^k_ooool00_o^k^h00ooooooo
k^k^onk^kP0:onk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h01_o^k^h00ooooooo
k^k^onk^kP09onk^kP03ooooooo^k^kok^k^00Ook^k^00Coooooonk^k_o^k^kooooo0_o^k^h03OoM
gMgooooooooooooooooogMgMohR8R?o^k^koooooomgMgOn8R8SogMgMoooooooMgMd00_ooool00005
ooooooo^k^kok^k^onk^k_ooool04Oo^k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00?ooooo
onk^k_o^k^h01Oo^k^h00oooooook^k^onk^kP09onk^kP03ooooooo^k^kok^k^00?ok^k^00?ooooo
onk^k_o^k^h00oo^k^h01Oooooook^k^onk^k_o^k^kooooo00Sok^k^00?oooooonk^k_o^k^h00oo^
k^h00oooooook^k^onk^kP0<onk^kP03ooooooo^k^kok^k^01[ok^k^00?oooooonk^k_o^k^h00_o^
k^h00oooooook^k^onk^kP08onk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h01oo^
k^h00oooooook^k^onk^kP0>onk^kP05ooooooo^k^kok^k^onk^k_ooool03oo^k^h01Oooooook^k^
onk^k_o^k^kooooo00Ook^k^00?oooooonk^k_o^k^h07?o^k^h00oooooook^k^onk^kP03onk^kP03
ooooooo^k^kok^k^00?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`04onk^kP05ooooooo^k^kok^k^
onk^k_ooool01?o^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^k^kok^k^00?ok^k^00Gooooo
onk^k_o^k^kok^k^ooooo`0;onk^kP03ooooooo^k^kok^k^00Ook^k^00?oooooonk^k_o^k^h00oo^
k^h00oooooook^k^onk^kP02onk^kP03ooooooo^k^kok^k^00Cok^k^00Goooooonk^k_o^k^kok^k^
ooooo`02onk^kP03ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^k^h04_o^k^h00oooooook^k^
onk^kP02onk^kP05ooooooo^k^kok^k^onk^k_ooool00oo^k^h00oooooook^k^onk^kP0<onk^kP03
ooooooo^k^kok^k^00cok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP05ooooooo^k^kok^k^
onk^k_ooool04?o^k^h00oooooook^k^onk^kP04onk^kP03ooooooo^k^kok^k^00cok^k^00?ooooo
onk^k_o^k^h03_o^k^h01Oooooook^k^onk^k_o^k^kooooo00;ok^k^00?oooooonk^k_o^k^h03?o^
k^h00oooooook^k^onk^kP0Ionk^kP03ooooooo^k^kok^k^01Kok^k^00Goooooonk^k_o^k^kok^k^
ooooo`03onk^kP05ooooooo^k^kok^k^onk^k_ooool01_o^k^h00oooooook^k^onk^kP0:onk^kP05
ooooooo^k^kok^k^onk^k_ooool03?o^k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00?ooooo
onk^k_o^k^h03oo^k^h00oooooook^k^onk^kP05onk^kP03omgMgOoooooooooo00;ooooo00OogMgM
ohR8R?oMgMgoooooomgMgOn8R8Sok^k^00?ooooo0008onk^kP05ooooooo^k^kok^k^onk^k_ooool0
1oo^k^h00oooooook^k^onk^kP0:onk^kP03ooooooo^k^kok^k^00Wok^k^00Coooooonk^k_o^k^ko
oooo1?o^k^h00oooooook^k^onk^kP04onk^kP03ooooooo^k^kok^k^00Gok^k^00Goooooonk^k_o^
k^kok^k^ooooo`0>onk^kP05ooooooo^k^kok^k^onk^k_ooool02_o^k^h01Oooooook^k^onk^k_o^
k^kooooo00?ok^k^00?oooooonk^k_o^k^h00oo^k^h01Oooooook^k^onk^k_o^k^kooooo00kok^k^
00?oooooonk^k_o^k^h03Oo^k^h00oooooook^k^onk^kP05onk^kP04ooooooo^k^kok^k^ooooo`?o
k^k^00?oooooonk^k_o^k^h00_o^k^h00oooooook^k^onk^kP0:onk^kP03ooooooo^k^kok^k^00;o
k^k^00?oooooonk^k_o^k^h02_o^k^h00oooooook^k^onk^kP03onk^kP05ooooooo^k^kok^k^onk^
k_ooool00oo^k^h01Oooooook^k^onk^k_o^k^kooooo00Kok^k^00?oooooonk^k_o^k^h00_o^k^h0
0oooooook^k^onk^kP04onk^kP03ooooooo^k^kok^k^02_ok^k^00Goooooonk^k_o^k^kok^k^oooo
o`0Monk^kP03ooooooo^k^kok^k^017ok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^onk^
kP02onk^kP03ooooooo^k^kok^k^013ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP03oooo
ooo^k^kok^k^00Sok^k^00?oooooonk^k_o^k^h01?o^k^h00oooooook^k^onk^kP0Eonk^kP05oooo
ooo^k^kok^k^onk^k_ooool01?o^k^h01?ooooook^k^onk^k_ooool5onk^kP05ooooooo^k^kok^k^
onk^k_ooool00_o^k^h00oooooook^k^onk^kP07onk^kP04ooooooo^k^kok^k^ooooo`?ok^k^00?o
ooooonk^k_o^k^h03?o^k^h00oooooook^k^onk^kP05onk^kP03ooooooo^k^kok^k^00?ok^k^00?o
ooooonk^k_o^k^h01?o^k^h00oooooook^k^onk^kP02onk^kP04ooooooo^k^kok^k^ooooo`?ok^k^
00?oooooonk^k_o^k^h01_o^k^h00oooooook^k^onk^kP04onk^kP04ooooooo^k^kok^k^ooooo`?o
k^k^00?oooooonk^k_o^k^h00oo^k^h00oooooook^k^onk^kP0?onk^kP03ooooooo^k^kok^k^00_o
k^k^00?oooooonk^k_o^k^h01oo^k^h01Oooooook^k^onk^k_o^k^kooooo017ok^k^00Coooooonk^
k_o^k^kooooo1?o^k^h00oooooook^k^onk^kP0:onk^kP03omgMgOoooooooooo00?ooooo00OogMgM
ohR8R?o^k^koooooomgMgOn8R8Sok^k^00;ooooo0002onk^kP03ooooooo^k^kok^k^00Wok^k^00Co
ooooonk^k_o^k^kooooo1Oo^k^h01Oooooook^k^onk^k_o^k^kooooo00Sok^k^00Goooooonk^k_o^
k^kok^k^ooooo`0Fonk^kP03ooooooo^k^kok^k^00[ok^k^00?oooooonk^k_o^k^h01Oo^k^h00ooo
ooook^k^onk^kP07onk^kP05ooooooo^k^kok^k^onk^k_ooool03_o^k^h00oooooook^k^onk^kP07
onk^kP05ooooooo^k^kok^k^onk^k_ooool01?o^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^
k^kok^k^00;ok^k^00?oooooonk^k_o^k^h00_o^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^
k^kok^k^017ok^k^00Goooooonk^k_o^k^kok^k^ooooo`0<onk^kP03ooooooo^k^kok^k^00Gok^k^
00?oooooonk^k_o^k^h05Oo^k^h00oooooook^k^onk^kP08onk^kP03ooooooo^k^kok^k^00Wok^k^
00Coooooonk^k_o^k^kooooo1?o^k^h01Oooooook^k^onk^k_o^k^kooooo00Gok^k^00?oooooonk^
k_o^k^h00oo^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^k^kok^k^00gok^k^00Goooooonk^
k_o^k^kok^k^ooooo`02onk^kP03ooooooo^k^kok^k^00Gok^k^00?oooooonk^k_o^k^h00oo^k^h0
0oooooook^k^onk^kP07onk^kP03ooooooo^k^kok^k^00Kok^k^00?oooooonk^k_o^k^h02?o^k^h0
0oooooook^k^onk^kP08onk^kP05ooooooo^k^kok^k^onk^k_ooool01?o^k^h00oooooook^k^onk^
kP0@onk^kP05ooooooo^k^kok^k^onk^k_ooool01Oo^k^h00oooooook^k^onk^kP05onk^kP05oooo
ooo^k^kok^k^onk^k_ooool00oo^k^h00oooooook^k^onk^kP03onk^kP04ooooooo^k^kok^k^oooo
oakok^k^00Goooooonk^k_o^k^kok^k^ooooo`0<onk^kP04ooooooo^k^kok^k^ooooo`gok^k^00?o
ooooonk^k_o^k^h02_o^k^h00oooooook^k^onk^kP0@onk^kP03ooooooo^k^kok^k^00Kok^k^00?o
ooooonk^k_o^k^h02oo^k^h00oooooook^k^onk^kP03onk^kP05ooooooo^k^kok^k^onk^k_ooool0
0oo^k^h00oooooook^k^onk^kP0:onk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h0
0oo^k^h00oooooook^k^onk^kP0;onk^kP05ooooooo^k^kok^k^onk^k_ooool01oo^k^h00ooooooo
k^k^onk^kP06onk^kP05ooooooo^k^kok^k^onk^k_ooool01oo^k^h01?ooooook^k^onk^k_oMgMd6
ooooo`07omgMgOn8R8SogMgMoooooooMgMgoR8R8onk^kP01ooooo`002_o^k^h00oooooook^k^onk^
kP0Conk^kP03ooooooo^k^kok^k^00Ook^k^00?oooooonk^k_o^k^h01_o^k^h00oooooook^k^onk^
kP02onk^kP03ooooooo^k^kok^k^00_ok^k^00Goooooonk^k_o^k^kok^k^ooooo`05onk^kP03oooo
ooo^k^kok^k^00Ook^k^00?oooooonk^k_o^k^h02oo^k^h00oooooook^k^onk^kP02onk^kP03oooo
ooo^k^kok^k^00Ook^k^00?oooooonk^k_o^k^h01oo^k^h00oooooook^k^onk^kP08onk^kP03oooo
ooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h04?o^k^h00oooooook^k^onk^kP02onk^kP03oooo
ooo^k^kok^k^00[ok^k^00?oooooonk^k_o^k^h00_o^k^h00oooooook^k^onk^kP06onk^kP03oooo
ooo^k^kok^k^00Gok^k^00Coooooonk^k_o^k^kooooo0oo^k^h01?ooooook^k^onk^k_ooool4onk^
kP03ooooooo^k^kok^k^00Sok^k^00?oooooonk^k_o^k^h01?o^k^h00oooooook^k^onk^kP02onk^
kP03ooooooo^k^kok^k^017ok^k^00?oooooonk^k_o^k^h00oo^k^h00oooooook^k^onk^kP03onk^
kP03ooooooo^k^kok^k^00?ok^k^00Coooooonk^k_o^k^kooooo1?o^k^h00oooooook^k^onk^kP0<
onk^kP03ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^k^h02Oo^k^h00oooooook^k^onk^kP03
onk^kP04ooooooo^k^kok^k^ooooo`?ok^k^00?oooooonk^k_o^k^h01?o^k^h00oooooook^k^onk^
kP06onk^kP03ooooooo^k^kok^k^00Ook^k^00?oooooonk^k_o^k^h01?o^k^h00oooooook^k^onk^
kP03onk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h01oo^k^h00oooooook^k^onk^
kP03onk^kP03ooooooo^k^kok^k^00ook^k^00?oooooonk^k_o^k^h02Oo^k^h01?ooooook^k^onk^
k_ooool7onk^kP04ooooooo^k^kok^k^ooooo`?ok^k^00?oooooonk^k_o^k^h04?o^k^h00ooooooo
k^k^onk^kP08onk^kP05ooooooo^k^kok^k^onk^k_ooool00oo^k^h01Oooooook^k^onk^k_o^k^ko
oooo00?ok^k^00?oooooonk^k_o^k^h02_o^k^h00oooooook^k^onk^kP06onk^kP03ooooooo^k^ko
k^k^00?ok^k^00?oooooonk^k_o^k^h02_o^k^h01Oooooook^k^onk^k_o^k^kooooo01Kok^k^00?o
ooooonk^k_o^k^h00_o^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^k^kok^k^00[ok^k^00?o
ooooonk^k_o^k^h00_o^k^h00oooooook^k^onk^kP0:onk^kP03ooooooo^k^kok^k^00Gok^k^00?o
ooooonk^k_o^k^h02Oo^k^h00oooooook^k^onk^kP04onk^kP03olc<c?oooooooooo00Gooooo00Go
gMgMohR8R?o^k^koooooomgMg@02ooooo`0000Goooooonk^k_o^k^kok^k^ooooo`02onk^kP03oooo
ooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h00oo^k^h01?ooooook^k^onk^k_ooool3onk^kP04
ooooooo^k^kok^k^ooooo`Gok^k^00Coooooonk^k_o^k^kooooo1_o^k^h00oooooook^k^onk^kP07
onk^kP05ooooooo^k^kok^k^onk^k_ooool00_o^k^h01Oooooook^k^onk^k_o^k^kooooo00cok^k^
00Goooooonk^k_o^k^kok^k^ooooo`09onk^kP04ooooooo^k^kok^k^ooooo`Cok^k^00?oooooonk^
k_o^k^h02?o^k^h00oooooook^k^onk^kP07onk^kP04ooooooo^k^kok^k^ooooo`Wok^k^00?ooooo
onk^k_o^k^h03Oo^k^h00oooooook^k^onk^kP02onk^kP04ooooooo^k^kok^k^ooooo`Sok^k^00?o
ooooonk^k_o^k^h00_o^k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00?oooooonk^k_o^k^h0
0_o^k^h01Oooooook^k^onk^k_o^k^kooooo00Cok^k^00?oooooonk^k_o^k^h01?o^k^h00ooooooo
k^k^onk^kP0Aonk^kP04ooooooo^k^kok^k^ooooo`?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`07
onk^kP05ooooooo^k^kok^k^onk^k_ooool01oo^k^h01?ooooook^k^onk^k_oooolRonk^kP04oooo
ooo^k^kok^k^ooooo`?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP03ooooooo^k^kok^k^
00?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`0Donk^kP03ooooooo^k^kok^k^00Gok^k^00Gooooo
onk^k_o^k^kok^k^ooooo`03onk^kP05ooooooo^k^kok^k^onk^k_ooool03?o^k^h00oooooook^k^
onk^kP08onk^kP04ooooooo^k^kok^k^ooooo`kok^k^00Goooooonk^k_o^k^kok^k^ooooo`02onk^
kP05ooooooo^k^kok^k^onk^k_ooool02Oo^k^h00oooooook^k^onk^kP09onk^kP03ooooooo^k^ko
k^k^00_ok^k^00?oooooonk^k_o^k^h00_o^k^h01?ooooook^k^onk^k_ooool3onk^kP03ooooooo^
k^kok^k^00?ok^k^00?oooooonk^k_o^k^h00oo^k^h00oooooook^k^onk^kP0Bonk^kP04ooooooo^
k^kok^k^ooooo`?ok^k^00?oooooonk^k_o^k^h00oo^k^h01?ooooook^k^onk^k_ooool5onk^kP03
ooooooo^k^kok^k^00?ok^k^00Coooooonk^k_o^k^kooooo0oo^k^h00oooooook^k^onk^kP07onk^
kP03ooooooo^k^kok^k^00?ok^k^00Coooooonk^k_o^k^kooooo1?o^k^h01Oooooook^k^onk^k_o^
k^kooooo00Gok^k^00?oooooonk^k_o^k^h02oo^k^h01Oooooook^k^onk^k_o^k^kooooo00Wok^k^
00Coooooonk^k_o^k^kooooo1?o^k^h00oooooook^k^onk^kP0:onk^kP03ooooooo^k^kok^k^00Go
k^k^00Goooooonk^k_o^k^kok^k^ooooo`04onk^kP03omgMgOoooooooooo00Kooooo00?ogMgMohR8
R?oMgMd00oooool000ook^k^00?oooooonk^k_o^k^h07Oo^k^h01?ooooook^k^onk^k_oooolAonk^
kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h02oo^k^h00oooooook^k^onk^kP0?onk^
kP04ooooooo^k^kok^k^ooooo`Kok^k^00Coooooonk^k_o^k^kooooo3?o^k^h00oooooook^k^onk^
kP03onk^kP03ooooooo^k^kok^k^00;ok^k^00?oooooonk^k_o^k^h00_o^k^h00oooooook^k^onk^
kP03onk^kP03ooooooo^k^kok^k^00Gok^k^00?oooooonk^k_o^k^h08_o^k^h00oooooook^k^onk^
kP08onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h07?o^k^h01?ooooook^k^onk^
k_ooool9onk^kP03ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^k^h00oo^k^h00oooooook^k^
onk^kP03onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h07oo^k^h00oooooook^k^
onk^kP03onk^kP03ooooooo^k^kok^k^00_ok^k^00?oooooonk^k_o^k^h05?o^k^h01?ooooook^k^
onk^k_ooool9onk^kP03ooooooo^k^kok^k^00gok^k^00?oooooonk^k_o^k^h00_o^k^h00ooooooo
k^k^onk^kP0Aonk^kP03ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^k^h01?o^k^h00ooooooo
k^k^onk^kP08onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h06?o^k^h01Ooooooo
k^k^onk^k_o^k^kooooo00Sok^k^00?oooooonk^k_o^k^h02_o^k^h00oooooook^k^onk^kP0Monk^
kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h05oo^k^h00oooooook^k^onk^kP03onk^
kP03ooooooo^k^kok^k^00Sok^k^00?oooooonk^k_o^k^h03oo^k^h01?ooooook^k^onk^k_ooool9
onk^kP03ooooooo^k^kok^k^00Wok^k^00?ogMgMooooooooool01oooool00ooMgMgoR8R8onk^kP02
ooooo`0000?ok^k^ooooooo^k^h01oo^k^h00oooooook^k^onk^kP09onk^kP03ooooooo^k^kok^k^
00Kok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^onk^kP0;onk^kP03ooooooo^k^kok^k^
00Kok^k^00?oooooonk^k_o^k^h02_o^k^h00oooooook^k^onk^kP05onk^kP03ooooooo^k^kok^k^
00?ok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^onk^kP0Ionk^kP03ooooooo^k^kok^k^
02Cok^k^00?oooooonk^k_o^k^h00oo^k^h01Oooooook^k^onk^k_o^k^kooooo00Sok^k^00?ooooo
onk^k_o^k^h01_o^k^h00oooooook^k^onk^kP0:onk^kP03ooooooo^k^kok^k^00Cok^k^00?ooooo
onk^k_o^k^h00oo^k^h00oooooook^k^onk^kP05onk^kP03ooooooo^k^kok^k^00Kok^k^00Cooooo
onk^k_o^k^kooooo4_o^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^k^kok^k^00?ok^k^00?o
ooooonk^k_o^k^h00oo^k^h00oooooook^k^onk^kP03onk^kP03ooooooo^k^kok^k^00?ok^k^00?o
ooooonk^k_o^k^h01Oo^k^h00oooooook^k^onk^kP0:onk^kP03ooooooo^k^kok^k^00Gok^k^00?o
ooooonk^k_o^k^h00oo^k^h00oooooook^k^onk^kP03onk^kP04ooooooo^k^kok^k^ooooo`[ok^k^
00Goooooonk^k_o^k^kok^k^ooooo`08onk^kP03ooooooo^k^kok^k^00[ok^k^00?oooooonk^k_o^
k^h01_o^k^h00oooooook^k^onk^kP05onk^kP05ooooooo^k^kok^k^onk^k_ooool02Oo^k^h00ooo
ooook^k^onk^kP0;onk^kP03ooooooo^k^kok^k^00Wok^k^00?oooooonk^k_o^k^h01?o^k^h01Ooo
ooook^k^onk^k_o^k^kooooo00Kok^k^00?oooooonk^k_o^k^h02?o^k^h01Oooooook^k^onk^k_o^
k^kooooo00Ook^k^00?oooooonk^k_o^k^h03?o^k^h00oooooook^k^onk^kP0:onk^kP03ooooooo^
k^kok^k^00[ok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^onk^kP05onk^kP03ooooooo^
k^kok^k^01Cok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^onk^kP05onk^kP03ooooooo^
k^kok^k^00?ok^k^00?oooooonk^k_o^k^h00oo^k^h00oooooook^k^onk^kP07onk^kP03ooooooo^
k^kok^k^00Gok^k^00?oooooonk^k_o^k^h02oo^k^h01Oooooook^k^onk^k_o^k^kooooo00_ok^k^
00Coooooonk^k_o^k^kogMgM2_ooool00ooMgMgoR8R8omgMg@01ooooo`001_o^k^h00oooooook^k^
onk^kP09onk^kP03ooooooo^k^kok^k^00Kok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^
onk^kP05onk^kP03ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^k^h01_o^k^h00oooooook^k^
onk^kP0:onk^kP03ooooooo^k^kok^k^00Gok^k^00?oooooonk^k_o^k^h02oo^k^h00oooooook^k^
onk^kP05onk^kP03ooooooo^k^kok^k^00Ook^k^00?oooooonk^k_o^k^h01oo^k^h00oooooook^k^
onk^kP04onk^kP03ooooooo^k^kok^k^00;ok^k^00Coooooonk^k_o^k^kooooo1?o^k^h01?oooooo
k^k^onk^k_ooool4onk^kP04ooooooo^k^kok^k^ooooo`Cok^k^00Coooooonk^k_o^k^kooooo1Oo^
k^h00oooooook^k^onk^kP0:onk^kP03ooooooo^k^kok^k^00Kok^k^00?oooooonk^k_o^k^h02_o^
k^h00oooooook^k^onk^kP0Bonk^kP03ooooooo^k^kok^k^00Kok^k^00?oooooonk^k_o^k^h02Oo^
k^h00oooooook^k^onk^kP07onk^kP03ooooooo^k^kok^k^02?ok^k^00?oooooonk^k_o^k^h01_o^
k^h01Oooooook^k^onk^k_o^k^kooooo00Ook^k^00?oooooonk^k_o^k^h05?o^k^h01?ooooook^k^
onk^k_ooool<onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h00oo^k^h00ooooooo
k^k^onk^kP06onk^kP03ooooooo^k^kok^k^00Gok^k^00?oooooonk^k_o^k^h02oo^k^h00ooooooo
k^k^onk^kP04onk^kP04ooooooo^k^kok^k^ooooo`?ok^k^00?oooooonk^k_o^k^h01_o^k^h01?oo
ooook^k^onk^k_ooool6onk^kP03ooooooo^k^kok^k^01?ok^k^00?oooooonk^k_o^k^h02Oo^k^h0
0oooooook^k^onk^kP03onk^kP04ooooooo^k^kok^k^ooooo`Gok^k^00?oooooonk^k_o^k^h01Oo^
k^h00oooooook^k^onk^kP02onk^kP03ooooooo^k^kok^k^00[ok^k^00?oooooonk^k_o^k^h01Oo^
k^h00oooooook^k^onk^kP05onk^kP03ooooooo^k^kok^k^00Cok^k^00Goooooonk^k_o^k^kok^k^
ooooo`04onk^kP03ooooooo^k^kok^k^00Cok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^
onk^kP05onk^kP03ooooooo^k^kok^k^01?ok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^
onk^kP05onk^kP03ooooooo^k^kok^k^00?ok^k^00?oooooonk^k_o^k^h02Oo^k^h01Oooooook^k^
onk^k_o^k^kooooo00Gok^k^00?oooooolc<c?ooool02_ooool1omgMg@7ooooo0Oooool00005oooo
ooo^k^kok^k^onk^k_ooool00oo^k^h00oooooook^k^onk^kP02onk^kP04ooooooo^k^kok^k^oooo
o`?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`04onk^kP05ooooooo^k^kok^k^onk^k_ooool00oo^
k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00?oooooonk^k_o^k^h00oo^k^h00oooooook^k^
onk^kP02onk^kP05ooooooo^k^kok^k^onk^k_ooool00_o^k^h01?ooooook^k^onk^k_ooool2onk^
kP05ooooooo^k^kok^k^onk^k_ooool00oo^k^h01Oooooook^k^onk^k_o^k^kooooo00;ok^k^00Co
ooooonk^k_o^k^kooooo0oo^k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00Goooooonk^k_o^
k^kok^k^ooooo`02onk^kP04ooooooo^k^kok^k^ooooo`?ok^k^00Coooooonk^k_o^k^kooooo0_o^
k^h01Oooooook^k^onk^k_o^k^kooooo00Kok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^
onk^kP05onk^kP03ooooooo^k^kok^k^00Gok^k^00?oooooonk^k_o^k^h01Oo^k^h00oooooook^k^
onk^kP03onk^kP05ooooooo^k^kok^k^onk^k_ooool00oo^k^h00oooooook^k^onk^kP02onk^kP05
ooooooo^k^kok^k^onk^k_ooool01?o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^ko
k^k^ooooo`?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`02onk^kP04ooooooo^k^kok^k^ooooo`;o
k^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP03ooooooo^k^kok^k^00;ok^k^00Goooooonk^
k_o^k^kok^k^ooooo`02onk^kP05ooooooo^k^kok^k^onk^k_ooool01?o^k^h01?ooooook^k^onk^
k_ooool2onk^kP05ooooooo^k^kok^k^onk^k_ooool00_o^k^h01?ooooook^k^onk^k_ooool2onk^
kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^
k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^
kP03ooooooo^k^kok^k^00;ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP05ooooooo^k^ko
k^k^onk^k_ooool00_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;o
k^k^00Goooooonk^k_o^k^kok^k^ooooo`06onk^kP05ooooooo^k^kok^k^onk^k_ooool01?o^k^h0
1Oooooook^k^onk^k_o^k^kooooo00Kok^k^00?oooooonk^k_o^k^h00oo^k^h00oooooook^k^onk^
kP02onk^kP05ooooooo^k^kok^k^onk^k_ooool00oo^k^h01Oooooook^k^onk^k_o^k^kooooo00?o
k^k^00?oooooonk^k_o^k^h00_o^k^h00oooooook^k^onk^kP02onk^kP03ooooooo^k^kok^k^00Oo
k^k^00Goooooonk^k_o^k^kok^k^ooooo`02onk^kP03ooooooo^k^kok^k^00Kok^k^00?oooooonk^
k_o^k^h01?o^k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00Coooooonk^k_o^k^kooooo0_o^
k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP05
ooooooo^k^kok^k^onk^k_ooool02?o^k^h00oooooook^k^onk^kP03onk^kP05ooooooo^k^kok^k^
onk^k_ooool01?o^k^h01Oooooook^k^onk^k_o^k^kooooo00;ok^k^00Coooooonk^k_o^k^kooooo
0_o^k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^
kP05ooooooo^k^kok^k^onk^k_ooool01_o^k^h00oooooook^k^onk^kP02onk^kP05ooooooo^k^ko
k^k^onk^k_ooool00_o^k^h01Oooooook^k^onk^k_o^k^kooooo00?ok^k^00Goooooonk^k_o^k^ko
k^k^ooooo`03onk^kP05ooooooo^k^kok^k^onk^k_ooool00_o^k^h01?ooooook^k^onk^k_ooool2
onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0oo^k^h01Oooooook^k^
onk^k_o^k^kooooo00?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`03onk^kP03ooooooo^k^kok^k^
00?ok^k^00Goooooonk^k_o^k^kok^k^ooooo`07onk^kP05ooooooo^k^kok^k^onk^k_ooool01?o^
k^h00ooMgMgoooooooooo`0<ooooo`00ooo^k^koonk^kW?ok^k^1_oMgMd00oo<c<cogMgMomgMg@06
omgMg@00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000:onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h0PooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0=omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP1momgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h07ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^
omgMgOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^037ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^02_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0=ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^
k_ook^k^P_o^k^h000;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0AomgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h00ooMgMgok^k^omgMg@02onk^kP0LomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h05ooMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgM
g@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^ko
gMgM0_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^02GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^03oogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^
k^kogMgM0_o^k^h05_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^
omgMgOo^k^kogMgM0_o^k^h0=_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgM
g@;ok^k^02?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01SogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0SomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^ko
k^k^omgMgOo^k^kogMgM0_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h1omgMg@7ok^k^0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooo
oooooh;ooooo003oonk^k_ook^k^P_o^k^h0000@onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00oogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h08?oMgMgok^k^onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^
k^h04?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^013ogMgMonk^k_o^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02?oMgMgok^k^onk^k_oM
gMgok^k^omgMgOo^k^kogMgM0_o^k^h0AooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00oogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^02;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0;OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0/omgMgOo^k^kok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h0;ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h06OoMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h09_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM0_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0MomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03_oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0
0?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000:onk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00oogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h07OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01CogMgMonk^
k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@;ok^k^07gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0BomgMgOo^k^kok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
0_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^
k^kok^k^omgMgOo^k^kogMgM0_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^023ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP0`omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP0comgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^
k_oMgMd2onk^kP0PomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?o
gMgMonk^k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0:_oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01?ogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^0OoMgMd00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^
k_ook^k^P_o^k^h000;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP1;omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01CogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h06ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0:omgMgOo^k^kok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMg@;o
k^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02GogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^02gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01WogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0KOoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00OogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h0=OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01CogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP7ogMgM0Oo^k^h00?ook^k^ooo^k^j2
onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000@onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01OogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h06?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00_ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^017o
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP0>omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP0BomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgM
g@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0eomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h02_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2
onk^kP0oomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h06OoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^
k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01KogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0PomgMgOo^k^kok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^
k^kok^k^omgMgOo^k^kogMgM0_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^
k_oMgMd00_o^k^h0=ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
1_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0S
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0
000:onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00oogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooM
gMgok^k^omgMg@02onk^kP0LomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP1?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h05ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03?oMgMgok^k^
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0CooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP0DomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0<omgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0AomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h0?OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01[ogMgMonk^
k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01WogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^
omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^03OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_o^k^h00OoMgMd00?ook^k^ooo^k^j2onk^kP00oooo
oooooooooh;ooooo003oonk^k_ook^k^P_o^k^h000;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03ooM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP0QomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^02WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP1;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h05OoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP0VomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h05?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02OoMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP1FomgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP1=omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP0lomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0<_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00[ogMgMonk^k_o^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM0_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@01
onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP00013o
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM0_o^k^h0>OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP0UomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^
00cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgM
gOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP05omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03
omgMgOo^k^kogMgM00;ok^k^01cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM0_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^ko
k^k^omgMgOo^k^kogMgM0_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0?OoM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0JOoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP0[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP10omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0SomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h1omgMg@00ooo^k^koonk^kX;ok^k^003oooooooooooooP_oo
ool00?ook^k^ooo^k^j2onk^kP0000[ok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM0_o^k^h07OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0>omgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM
00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^
omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h03OoMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04OoMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01go
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h06?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^04oogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^02gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^
k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oM
gMd2onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^
k_o^k^kogMgMonk^k_oMgMd2onk^kP0oomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h03ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h08?oMgMgok^k^onk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooM
gMgok^k^omgMg@02onk^kP0TomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM007ok^k^003oonk^k_oo
k^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^0002onk^kP03omgMgOo^k^ko
gMgM00;ok^k^00oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oM
gMd00_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02GogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0BOoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02
onk^kP0IomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0[omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^
k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;o
k^k^00?ogMgMonk^k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^
k^h05_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0oomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^03go
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^03GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0momgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0/omgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0AomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h1omgMg@00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^
k^j2onk^kP00013ok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM0_o^k^h0JOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0IomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^
01OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP08omgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
<ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0<omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00Go
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^06oogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0IomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0?OoM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h0:ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
6OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00Oo^k^h00?ook^k^ooo^k^j2
onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000:onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01CogMgMonk^k_o^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
01_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0;ooM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0B_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0;OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;o
k^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^05GogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06
omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0<OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^
k^kogMgM00;ok^k^02WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP0NomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM0_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^
omgMg@02onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^
kP000_o^k^h00ooMgMgok^k^omgMg@02onk^kP0SomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooM
gMgok^k^omgMg@02onk^kP0>omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0@omgM
gOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^03?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP0eomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP1KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01OoM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^
omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^
k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^
onk^k_oMgMgok^k^omgMg@;ok^k^03OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0homgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^03KogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool0
0?ook^k^ooo^k^j2onk^kP00013ok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^ko
gMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP10omgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;o
k^k^02oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP0<omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h0:OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^02OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0=omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^ko
gMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0BomgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0
3?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^0=OogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP0ZomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM0_o^k^h03?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;o
k^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^0OoMgMd1onk^kP00ooo^k^koonk^
kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0000[ok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0KOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h07?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd2onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0ComgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^
k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^03cogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0@omgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
01OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP05omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^05OogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgM
g@;ok^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0jomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^02WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h04?oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd2onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM007ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^
kX;ok^k^0002onk^kP03omgMgOo^k^kogMgM00;ok^k^02_ogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02?oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^013ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0DomgMgOo^k^kok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2
onk^kP0eomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02
onk^kP0IomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP2AomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0komgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^
k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01SogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^
k^kogMgM0_o^k^h0;?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h0:OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP00ooo^k^koonk^kX;ok^k^003ooooooooo
ooooP_ooool00?ook^k^ooo^k^j2onk^kP00013ok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h00ooMgMgok^k^omgMg@02onk^kP0VomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP0BomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM0_o^k^h0<ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^
k^kok^k^omgMgOo^k^kogMgM0_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h05OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP0domgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP11omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h05ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgo
k^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMd2onk^kP2<omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;o
k^k^02cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h1omgMg@00ooo^
k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0000[ok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0H_oMgMgok^k^
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0FomgMgOo^k^kok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0EomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^023ogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^013o
gMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^
k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h02ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^0<7ogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h08ooMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^017ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@01onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^
ooo^k^j2onk^kP000_o^k^h00ooMgMgok^k^omgMg@02onk^kP1]omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP03omgMgOo^k^kogMgM00;ok^k^00kogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^03SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@;ok^k^01_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h0>ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^02oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP1NomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0@omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP08omgM
gOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP1HomgMgOo^k^kok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP0PomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@7ok^k^003oonk^k_ook^k^P_o^k^h0
0?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^00004?o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0OomgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06
omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02?oMgMgok^k^
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
02oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01?ogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
05KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^
k_o^k^kogMgMonk^k_oMgMd2onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h0AooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^03So
gMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01GogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h0;_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0E?oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00Oo^
k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000:onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01OogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^073ogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM0_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^
kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h04ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h0;OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^017ogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0N
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oM
gMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP1comgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP08omgMgOo^k^kok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0VomgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?oo
k^k^ooo^k^j2onk^kP000_o^k^h00ooMgMgok^k^omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^
k^kogMgMonk^k_oMgMd2onk^kP1OomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h05_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0GomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^03?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^
omgMgOo^k^kogMgM0_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP1comgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0:omgMgOo^k^kok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^07WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oM
gMd2onk^kP0FomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^003oonk^k_ook^k^P_o^k^h0
0?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^00004?o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0QomgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^
omgMg@02onk^kP0:omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?o
gMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01CogMgMonk^k_o^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
01OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP1aomgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0;omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0;_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0lomgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h07ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
1_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^02gogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h1omgMg@7o
k^k^0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0
00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0<ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0DooMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01CogMgMonk^k_o^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h06_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02GogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^
k_oMgMd00_o^k^h04_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^04WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h03?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
3OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
6OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0<_oMgMgok^k^onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^037ogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
02OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h02_oMgMgok^k^onk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd1onk^kP00ooo^k^koonk^kX;ok^k^003ooooooooooooo
P_ooool00?ook^k^ooo^k^j2onk^kP0000Kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0IomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h0@_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02?ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgo
k^k^omgMg@;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02
onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^04gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^023ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0;_oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0@ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02
onk^kP0QomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03ooMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP00ooo^k^ko
onk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP000_o^k^h04OoMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h06?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0komgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02
onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0MomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
GOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP0WomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0?ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP0]omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP1;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^03OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00?ogMgMonk^k_oMgMd00Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^
k_ook^k^P_o^k^h0000>onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP0momgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
1_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP0:omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01_ogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03OoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02
onk^kP0_omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0
8_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^
omgMgOo^k^kogMgM0_o^k^h02ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^037ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02kogMgMonk^k_o^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02
onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oM
gMd00_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP0IomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0<_oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0PomgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP07
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP7ogMgM003oonk^k_ook^k^P_o^k^h00?oo
oooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^0002onk^kP0momgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^ko
k^k^omgMgOo^k^kogMgM0_o^k^h0CooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
3?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0QomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01CogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^04Co
gMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0Z
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^02gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0QomgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h09ooMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00Go
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP0OomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00oo
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h00006
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h05_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2
onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0<omgM
gOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0<OoMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h09OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h07ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06
omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0?OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0]omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^03kogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0AooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0;_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0GomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h1omgMg@00ooo^k^koonk^kX;ok^k^003oooooooooooooP_oo
ool00?ook^k^ooo^k^j2onk^kP000_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0:ooMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP1comgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0IomgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h07OoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oM
gMd00_o^k^h0:ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oM
gMd2onk^kP0:omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01gogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03
omgMgOo^k^kogMgM00;ok^k^02OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h07OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0=ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0FomgMgOo^k^kok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP7ogMgM0Oo^k^h00?ook^k^ooo^
k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000lonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP08omgMgOo^k^kok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h04OoM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^02WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
5ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
1_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00[ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM0_o^k^h09OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP0@omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^08gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^023ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00OogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0<omgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02?oMgMgok^k^onk^k_oM
gMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;o
k^k^02_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP0[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@01onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2
onk^kP000_o^k^h0IooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h0:OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^017ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
2OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0:omgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00go
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01Go
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0BOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h0:OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01GogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0IOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM
00;ok^k^02_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP00ooo^k^koonk^kX;ok^k^003ooooo
ooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0000Kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
1_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^04gogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP1ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^
kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00oogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP05
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^
omgMgOo^k^kogMgM0_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0:?oMgMgok^k^onk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00cogMgMonk^k_o^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0AomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
8OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP0aomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;o
k^k^01_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
0?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h000;ok^k^03Oo
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^027ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0>omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^
k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0;_oMgMgok^k^
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP1IomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^07oogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0YomgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00_ogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^
017ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00[ogMgMonk^k_o^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM0_o^k^h0>ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h06ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h1omgMg@7ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00
ooo^k^koonk^kX;ok^k^0000A?o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0F
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02WogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgM
g@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00Wo
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h08ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^01OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP08omgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01ooM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0QomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^02_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0comgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^03kogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgo
k^k^omgMg@;ok^k^01kogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00oogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00Oo^k^h00?ook^k^ooo^k^j2
onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000nonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP1AomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h09OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP05omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h0AOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^013ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^04OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0SomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03
omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^
omgMgOo^k^kogMgM0_o^k^h0;_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0GomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h1omgMg@00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2
onk^kP000_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02OogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP07
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h09ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0comgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02_ogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h0:?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0<omgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h04?oMgMgok^k^onk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0QomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^017ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^02_ogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^
k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^07GogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP7ogMgM0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooo
oooooh;ooooo003oonk^k_ook^k^P_o^k^h0001Honk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h07ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP1PomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h06ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0;omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0D?oMgMgok^k^onk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
0_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0;ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02?o
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP0DomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^
k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^03[ogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP05omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0Oo^
k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h000;ok^k^
047ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^
k^kogMgMonk^k_oMgMd2onk^kP10omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^01;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h05OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00_ogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06
omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
01cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0
4OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^03?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0eomgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0@_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0fomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^
P_o^k^h0000Lonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^01gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0ZomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
0_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^017ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0WomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0<OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP0SomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h0:OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0EomgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h05?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0>omgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^
k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP15omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0>?oMgMgok^k^onk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^0OoMgMd1onk^kP00ooo^k^koonk^kX;ok^k^003ooooo
ooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0000Cok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0<omgM
gOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^
onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0XomgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
8ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^07gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0;omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0<OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP0OomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0_omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h02?oMgMgok^k^onk^k_oM
gMgok^k^omgMgOo^k^kogMgM0_o^k^h09ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP13omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP08omgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP0>omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@01onk^
kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP000_o^k^h0
AooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^
k_oMgMd00_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h09OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h0A?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^
k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03
omgMgOo^k^kogMgM00;ok^k^013ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0>omgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0SomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0WomgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^057ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooM
gMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^
k^kogMgM00;ok^k^03WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
?_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0XomgMgOo^k^kok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^0OoMgMd00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo
003oonk^k_ook^k^P_o^k^h0000Lonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0Q
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP05
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oM
gMd2onk^kP0:omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00cogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP08omgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
5OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0SomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
2?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^013ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM0_o^k^h0;_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00[ogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?o
gMgMonk^k_oMgMd00_o^k^h0HOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0<?oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^017ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
9_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@01onk^kP00ooo^k^koonk^kX;o
k^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0001Kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^02OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h0_?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgo
k^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0;omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0=ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h0@_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP0XomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^ko
gMgM00;ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^
0002onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0@
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^02CogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgM
gOo^k^kogMgM00;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP17omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0:omgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
0_o^k^h0<_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h07OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgM
gOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgM
gOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0:_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^03oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^
kP0SomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;o
oooo003oonk^k_ook^k^P_o^k^h0000Jonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd2onk^kP0UomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^ko
gMgM00;ok^k^06cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0:omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0ComgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^03KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02?oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0AOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP0>omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h0?ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^
k_oMgMd2onk^kP0nomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^02gogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00?ook^k^
ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h000;ok^k^01?ogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^02GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^017ogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0@omgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^
k_oMgMd00_o^k^h0:?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0R
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^02WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^02OogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
<?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@;ok^k^03oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0<OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^ko
k^k^omgMgOo^k^kogMgM0_o^k^h09OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h02?oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgM
gOo^k^kogMgM007ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^
kX;ok^k^00008_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0jomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0=ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h07ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h0A_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP0<omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
=OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^
k_oMgMd2onk^kP0homgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0IomgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^04;o
gMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^01[ogMgMonk^k_o^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^003oonk^k_ook^k^P_o^k^h00?oo
oooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^00001?o^k^kogMgMonk^k_oMgMd2onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
00cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0=omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0komgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^
k_oMgMd00_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgM
g@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^ko
gMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01?ogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP15omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02?oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^
k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0IomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP1KomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgM
gOo^k^kogMgM00;ok^k^02KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^0OoMgMd0
0?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h000;ok^k^01Go
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h08ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00Wo
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06?oMgMgok^k^onk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
02?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0QomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00[ogMgMonk^k_o^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h07OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01[ogMgMonk^k_o^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h09?oMgMgok^k^
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^07oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00oogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0comgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0<_oMgMgok^k^onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h1omgMg@7ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00
ooo^k^koonk^kX;ok^k^0000L?o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^
k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00OogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h08OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01kogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0SomgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h0:OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00GogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP0IomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h07OoM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP13omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0IomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooM
gMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^02;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
00[ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0Oo^k^h00?ook^k^ooo^k^j2
onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000Nonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgM
g@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h02OoMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP1ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP0OomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP0LomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02
onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01OogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
5OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h0=_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd0
0_o^k^h0?ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0K_oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0SomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^
k^h000;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^017ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^02?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0SomgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h07?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP03omgMgOo^k^kogMgM00;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP0RomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP03omgMgOo^k^kogMgM00;ok^k^01gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0GomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h07_oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00_ogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oM
gMd2onk^kP0JomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0T
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0=ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01_ogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;o
oooo003oonk^k_ook^k^P_o^k^h0000Jonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd2onk^kP0YomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h0>OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h08ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
01gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP1YomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0<ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP0QomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02ooMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^04?ogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^
omgMg@02onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h08_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP7ogMgM0Oo^k^h0
0?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000fonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01[ogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd0
0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oM
gMd2onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^
k_oMgMd2onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0QomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^01_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^02CogMgMonk^
k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP15omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0;ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01SogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h06ooM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003o
onk^k_ook^k^P_o^k^h000;ok^k^01oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h08ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^027ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0OomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^ko
gMgM00;ok^k^01KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h03?oMgMgok^k^onk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
6_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^
omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h0<_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^
kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01Co
gMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^023ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^03_ogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0<omgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h07OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^003oonk^k_ook^k^P_o^k^h0
0?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^00001_o^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^ko
gMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0YomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h0@OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^027ogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^03kogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02cogMgMonk^k_o^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01oogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^03OogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP0GomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP08omgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0jomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01_ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h07OoMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00gogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00CogMgMonk^k_o^k^ko
gMgM0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0
00;ok^k^067ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00GogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0<ooMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h07OoMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd0
0_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01kogMgMonk^k_o^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0iomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^033ogMgMonk^k_o^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd2onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0LomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP07omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0MomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooo
oooooh;ooooo003oonk^k_ook^k^P_o^k^h0000`onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgM
g@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h07_oMgMgok^k^onk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00kogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h03?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0LomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgM
g@02onk^kP0_omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0>omgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^
omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01_ogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0<OoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0>ooM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
01[ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^
k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h03ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0<
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00?ook^k^
ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000Nonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h06ooMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^
k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^05GogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^03GogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^02GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0FomgMgOo^k^kok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^033ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h09?oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0SomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0<?oMgMgok^k^onk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01_o
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h07OoMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00go
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00Co
gMgMonk^k_o^k^kogMgM0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^
k_ook^k^P_o^k^h000;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP1:omgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0[omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0[omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0HomgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0DooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h09OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01;o
gMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0KomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP08omgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h0>OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0I
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@01onk^kP00ooo^k^koonk^kX;o
k^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0006Sok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0;_oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0ComgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00_ogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01oogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01go
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h0?OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h06?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
01?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^017ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oM
gMd00_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0[omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^
k^kogMgM0_o^k^h05_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM
00;ok^k^01gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^
kP00033ok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMg@;o
k^k^00?ogMgMonk^k_oMgMd00_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
??oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^ko
gMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01?ogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^01oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^01;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0@omgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01SogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0]omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd0
0_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^01KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^
omgMg@02onk^kP0UomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP0aomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP05omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h0;OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP0JomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h05OoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oM
gMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2oooo
o`00ooo^k^koonk^kX;ok^k^0002onk^kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
03SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02gogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
@OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0:OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02[ogMgMonk^k_o^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h05?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h05_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd2onk^kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0AOoMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0DomgMgOo^k^kok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^027o
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h0DOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP00ooo^k^koonk^
kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0000Kok^k^omgMgOo^k^kogMgM
onk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^06CogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^
k^h00ooMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0]
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0momgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^01[ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^047ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00cogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0OomgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^01;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP0SomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^
omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h04ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h1omgMg@00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^
kP000_o^k^h0CooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^02oo
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^ko
gMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0EomgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^01_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h0<ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02?oMgMgok^k^
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0:ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^ko
k^k^omgMgOo^k^kogMgM0_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0;ooM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h09ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@01onk^kP00ooo^k^koonk^kX;ok^k^003ooooooooo
ooooP_ooool00?ook^k^ooo^k^j2onk^kP00033ok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^
omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^
k^kogMgMonk^k_oMgMd2onk^kP0FomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02oogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP0<omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h09?oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01SogMgMonk^k_o^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h0:ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^
00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0<omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM0_o^k^h0UooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0@?oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06
omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP00ooo^k^ko
onk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0001[ok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^0:CogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h08ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^02KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMd2onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^
01;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP1[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00GogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h05OoMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP0GomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^037ogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01?o
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM007ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^
k^koonk^kX;ok^k^0002onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^
k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0@ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h07OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^
k^kok^k^omgMgOo^k^kogMgM0_o^k^h0;?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP1=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02
onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0GomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0GomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h0@ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^
onk^k_oMgMgok^k^omgMg@;ok^k^00cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^02oogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0EomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0domgM
gOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^
omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0JomgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP7ogMgM003oonk^k_ook^k^P_o^k^h00?oooooo
oooooon2ooooo`00ooo^k^koonk^kX;ok^k^0000C?o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^
013ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP03omgMgOo^k^kogMgM00;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h0=OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^
k_o^k^kogMgMonk^k_oMgMd2onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^04?ogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^03GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP08
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^027o
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h0<ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00[ogMgMonk^k_o^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM0_o^k^h07ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0;omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^033ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00Oo^
k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0000Ponk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd2onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0D_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd2onk^kP0eomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgM
g@02onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM
00;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0;ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01SogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^09Wo
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^037ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00
ooo^k^koonk^kX;ok^k^0002onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00kogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^03;o
gMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^033ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0WomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^04WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgM
g@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h04_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^067ogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd0
0_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0<
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02ooMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01GogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h0AooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h1omgMg@00ooo^k^koonk^kX;o
k^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0000Kok^k^omgMgOo^k^kogMgMonk^
k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0@?oMgMgok^k^onk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2
onk^kP03omgMgOo^k^kogMgM00;ok^k^00oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0<omgMgOo^k^kok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP0[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP03omgMgOo^k^kogMgM00;ok^k^01oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^03[ogMgMonk^k_o^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0;ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00OogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02_oMgMgok^k^onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oM
gMd2onk^kP0gomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0;omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^02?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM
00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0
00;ok^k^03OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^037ogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^02kogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
02SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02_oMgMgok^k^onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h07OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h05?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h09OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^08GogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01oogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^037ogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
1?oMgMgok^k^onk^k_oMgMd2onk^kP7ogMgM0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooo
oh;ooooo003oonk^k_ook^k^P_o^k^h0000Honk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
1OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03_oMgMgok^k^onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^
onk^k_oMgMgok^k^omgMg@;ok^k^04;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP07omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0BooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^
k^kogMgM0_o^k^h02ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h07OoMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00oogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgM
g@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^06Wo
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0MomgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0@?oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM007ok^k^
003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^0002onk^kP0A
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h0?ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^01_ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^
kP0UomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0IomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP0YomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02?ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00kogMgMonk^k_o^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01;ogMgMonk^k_o^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0momgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP05omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h03OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^ko
gMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06OoMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0:?oMgMgok^k^onk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
3OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^0OoMgMd00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^
k_ook^k^P_o^k^h00006onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^01OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP17omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgM
g@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01OogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP0>omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^02_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0;ooM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd2onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^00?ogMgMonk^k_oMgMd00_o^k^h0EOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0XomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@;ok^k^01KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0:_oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@7ok^k^003oonk^k_ook^k^
P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^0002onk^kP0_omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h00ooMgMgok^k^omgMg@02onk^kP0@omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0:ooMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^01;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0QomgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM0_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^
k^kogMgM0_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0WomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^
k_oMgMd2onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^05?ogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP0;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h0>?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooM
gMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgM
g@02onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP00
01Kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgM
g@;ok^k^00cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h03?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^063ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP1?omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06
omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^017o
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^
k^kok^k^omgMgOo^k^kogMgM0_o^k^h0;?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP03omgMgOo^k^kogMgM00;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h0>_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06?oMgMgok^k^onk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2oooo
o`00ooo^k^koonk^kX;ok^k^0002onk^kP0UomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP0]omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
01SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;o
k^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0IomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMd2onk^kP0WomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
027ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0bomgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd2onk^kP0[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^02_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^01;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^03?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
:_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0:omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^02?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP7ogMgM003oonk^k_ook^k^P_o^
k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^00001_o^k^kogMgMonk^k_oMgMgok^k^
omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP1PomgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^03gogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0AooM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^03[ogMgMonk^k_o^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgM
g@02onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03_oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP1IomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^02Oo
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0@_oMgMgok^k^onk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@7ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;o
k^k^0002onk^kP0GomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd0
0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^02gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00kogMgMonk^
k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^02?ogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP0TomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h06_oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0?omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h06ooMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0YomgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP19omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd0
0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0`omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgM
g@02onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^
omgMgOo^k^kogMgM0_o^k^h1omgMg@7ok^k^0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooo
oh;ooooo003oonk^k_ook^k^P_o^k^h0000Nonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^
k^kogMgM00;ok^k^06WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
02?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0YomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0PomgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgM
gOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0;ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^
k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0AooMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00[ogMgMonk^k_o^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^01KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP06
omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h09OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0]omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h02_oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0PomgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP00ooo^
k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP000_o^k^h01OoMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^ko
gMgM00;ok^k^03GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0;omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgo
k^k^omgMg@;ok^k^01[ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;o
k^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h0<_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^
k^kok^k^omgMgOo^k^kogMgM0_o^k^h0:OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^02GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01oogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^00?ogMgMonk^k_oMgMd00_o^k^h0>ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h07?oMgMgok^k^onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP07omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP0WomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP15omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^01OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP03omgMgOo^k^kogMgM00;ok^k^03SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^0OoMgMd00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_oo
k^k^P_o^k^h0000Jonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP0eomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h05OoMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP0komgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0PomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;o
k^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^02GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01_ogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^
omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^01_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h00ooMgMgok^k^omgMg@02onk^kP0DomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^ko
k^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^017ogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP11omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgM
gOo^k^kogMgM00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^
k_o^k^kogMgMonk^k_oMgMd2onk^kP0>omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0GomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h0A?oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^0OoMgMd00?ook^k^ooo^k^j2onk^
kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h000;ok^k^027ogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP1BomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
1_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^
omgMg@;ok^k^02GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00gogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02GogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0>?oMgMgok^k^onk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0<omgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h04OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^04WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^013ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h07OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0:OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^02gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^
k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h1omgMg@7ok^k^
0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h00006
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP0[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP21omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02gogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooM
gMgok^k^omgMg@02onk^kP0DomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP07omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^
k_oMgMd2onk^kP0DomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0??oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^00cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0;
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^
omgMg@02onk^kP0NomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM0_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^02;ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo
003oonk^k_ook^k^P_o^k^h000;ok^k^05?ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgM
g@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0/omgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP08omgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0BomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^
omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0B?oMgMgok^k^onk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01ooM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0ComgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP0QomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02;ogMgMonk^k_o^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0
9?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^03gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^0OoMgMd00?ook^k^ooo^k^j2
onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h00014onk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^027ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h08ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01GogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0PomgMgOo^k^kok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0A
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h08?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0:ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04OoM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0@ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0_omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02
onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
2?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^04WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM007ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^ko
onk^kX;ok^k^00008_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
=ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^02SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
0_o^k^h0;OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h02?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h02?oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;o
k^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP0JomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03
omgMgOo^k^kogMgM00;ok^k^05_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP0IomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0GomgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h09OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0comgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
1_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^0OoMgMd1onk^kP00ooo^k^koonk^kX;ok^k^003o
ooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP000_o^k^h00ooMgMgok^k^omgMg@02onk^kP06
omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0komgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0;omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0GOoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0@omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP1UomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^
k^h08ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h02ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h06_oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM
00;ok^k^01OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM
00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^ko
gMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^02;ogMgMonk^k_o^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0Oo^
k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h0001@onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^01_ogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06
omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h05OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^00oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h05?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h06ooMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0gomgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0=omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
6ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h07ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h05ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^01cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0?omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0GomgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0oomgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00?ogMgMonk^k_o^k^h00OoMgMd00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;o
oooo003oonk^k_ook^k^P_o^k^h000;ok^k^03oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h02?oMgMgok^k^onk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0DOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h06ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h02ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0:OoMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01WogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP1NomgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^01gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP0ComgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0[omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP13omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM007ok^k^
003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^00007?o^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^
k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;o
k^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^02?ogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP0eomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0EOoMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oM
gMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0>?oMgMgok^k^onk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0>ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02GogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^03CogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0:OoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^03kogMgMonk^k_o^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^
k_oMgMd00_o^k^h04?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?oo
k^k^ooo^k^j2onk^kP0000Cok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP10omgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;o
k^k^00?ogMgMonk^k_oMgMd00_o^k^h06OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0oomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03?oMgMgok^k^onk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00;ok^k^02[ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP0gomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^ko
gMgM00;ok^k^03OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
1_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h00ooMgMgok^k^omgMg@02onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h05_oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^
k^kogMgMonk^k_oMgMd2onk^kP0>omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00oogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^
onk^k_oMgMgok^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP05omgMgOo^k^ko
gMgMonk^k_oMgMd00_o^k^h05_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^
k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;o
k^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00SogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01[ogMgMonk^k_o^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@;ok^k^0OoMgMd1onk^kP7ok^k^003oonk^k_ook^k^P_o^k^h00?oo
oooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^0002onk^kP1?omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP0MomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2
onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgM
g@;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP08
omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^ko
gMgM0_o^k^h04OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^01GogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooM
gMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h02ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^04gogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h05?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0DooMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^01_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0;OoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP13omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@01
onk^kP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP0003co
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2
onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP1JomgM
gOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^
k^h0<OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h08OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h09_oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP3oomgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^000GomgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00?ook^k^ooo^k^j2onk^kP00oooooooo
oooooh;ooooo003oonk^k_ook^k^P_o^k^h0000Jonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^
k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgo
k^k^omgMg@;ok^k^02OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^01KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^
k^h0;OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@02onk^kP0IomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0E
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^02gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^
k^kogMgM0_o^k^h06?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgM
onk^k_o^k^kogMgMonk^k_oMgMd2onk^kP1;omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h05?oMgMgo
k^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP0;omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0FomgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h03OoMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgM
g@02onk^kP0FomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h02ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h05_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^ko
gMgM00;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^ko
gMgM00;ok^k^00SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00[ogMgMonk^k_o^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@01onk^kP00ooo^
k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP000_o^k^h00ooMgMgo
k^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oM
gMgok^k^omgMg@;ok^k^03_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^01[ogMgMonk^k_o^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP07omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00cogMgMonk^k_o^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP09omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^
k^kogMgM00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00WogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0LOoMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0AomgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^
omgMg@02onk^kP0@omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^01KogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oM
gMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h04ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0@omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01KogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00gogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oM
gMd00_o^k^h0:ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h1omgMg@00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2
onk^kP0003cok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP03omgMgOo^k^kogMgM00;ok^k^03gogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01OogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01OogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^01Oo
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP1;omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h0oooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@001_o^k^kogMgMonk^k_oMgMgok^k^omgMg@7ok^k^003oonk^k_ook^k^
P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^0000ooo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^kP00;ooMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^
k^h0oooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@00:_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP08omgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP7ogMgM003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00
ooo^k^koonk^kX;ok^k^0002onk^kP0EomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP0:omgMgOo^k^kok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0TomgMgOo^
k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM0_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd0
0_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgo
k^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^
k_o^k^kogMgMonk^k_oMgMd2onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00Go
gMgMonk^k_oMgMgok^k^omgMg@02onk^kP07omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oM
gMd2onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00SogMgMonk^k_o^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0IomgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^
01cogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0
5ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h0
3OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h0
0ooMgMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h02ooMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h04?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h04?oMgMgok^k^onk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h02ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^
omgMg@;ok^k^00_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^
kP03omgMgOo^k^kogMgM00;ok^k^013ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^013ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00_ogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0JomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd2onk^kP7ogMgM0Oo^k^h00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;o
oooo003oonk^k_ook^k^P_o^k^h00006onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^033ogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgM
gOo^k^kogMgM0_o^k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^
omgMg@02onk^kP3iomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP09
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^
k^h01ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h03ooMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0HomgMgOo^k^kok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h05?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h06?oM
gMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^01CogMgMonk^k_o^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^01SogMgMonk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP0DomgMgOo^k^ko
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP0HomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0
5?oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h0<_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0Oo^k^h00?ook^k^
ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h000;ok^k^0?oogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd005[ok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^
kP3oomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM000Jonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP05omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h1omgMg@00ooo^k^koonk^kX;ok^k^003oooooooooooooP_oo
ool00?ook^k^ooo^k^j2onk^kP0001[ok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00?ogMgMonk^k_oMgMd00_o^k^h07OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM00;ok^k^0<oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP05omgMgOo^k^kogMgMonk^k_oM
gMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oM
gMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^02GogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM00;ok^k^0?oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00cogMgM
onk^k_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP7ogMgM0Oo^k^h0
0?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h000;ok^k^00?o
gMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgo
k^k^omgMg@02onk^kP0KomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0:omgMgOo^k^kok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^017ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;o
k^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP03omgMgOo^k^kogMgM00;ok^k^00?ogMgM
onk^k_oMgMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^ko
gMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^
k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^ko
k^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^
k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgo
k^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgM
gOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h0
1_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^
kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;o
k^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h0:ooMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd0
0_o^k^h00ooMgMgok^k^omgMg@02onk^kP08omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMd2
onk^kP03omgMgOo^k^kogMgM00;ok^k^00OogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^
00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h01OoMgMgok^k^omgMgOo^
k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00_o^k^h00ooMgMgok^k^omgMg@02onk^kP06omgMgOo^
k^kok^k^omgMgOo^k^kogMgM0_o^k^h02_oMgMgok^k^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgo
k^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^
00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0:omgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^ko
k^k^omgMgOo^k^kogMgM0_o^k^h01OoMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00?ogMgMonk^k_oM
gMd00_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00[ogMgMonk^k_o^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgM0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00Ko
gMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd00_o^k^h00ooM
gMgok^k^omgMg@02onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h02_oMgMgok^k^onk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM
0_o^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgMg@;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP03omgMgOo^k^kogMgM00;ok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd2onk^kP0:omgM
gOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@;ok^k^00KogMgMonk^k_o^k^kogMgM
onk^k_oMgMd2onk^kP06omgMgOo^k^kok^k^omgMgOo^k^kogMgM0_o^k^h07OoMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM007ok^k^003oonk^k_ook^k^
P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^00008_o^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd2
onk^kP0[omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02
onk^kP3oomgMgOo^k^kok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^003oomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgM000^onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@;ok^k^0OoMgMd00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo
003oonk^k_ook^k^P_o^k^h0000Lonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMg@;ok^k^02_ogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00;ok^k^0?oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd001[ok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMg@;ok^k^0?oogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMd001[ok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^
k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@7ok^k^003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^0000
3_o^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM0_o^
k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP0OomgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@02onk^kP3N
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^0_oMgMd06Oo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^h00_oMgMd02Oo^k^kogMgMonk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Wok^k^omgMgOo^k^ko
gMgMonk^k_oMgMgok^k^omgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@0Donk^k_oMgMgo
k^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^ko
gMgMonk^k_oMgMd2onk^kP3oomgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^
k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oM
gMgok^k^omgMgOo^k^kogMgM000:onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgM
g@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h1omgMg@7ok^k^003oonk^k_ook^k^P_o^k^h00?oo
oooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^0005onk^kP03omgMgOo^k^kok^k^00Cok^k^00Co
gMgMonk^k_o^k^kogMgM0_o^k^h00ooMgMgok^k^onk^kP03onk^kP05omgMgOo^k^kogMgMonk^k_oM
gMd00oo^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP03omgMgOo^k^kok^k^00Gok^k^00GogMgMonk^
k_o^k^kok^k^omgMg@05onk^kP05omgMgOo^k^kogMgMonk^k_oMgMd01?o^k^h01OoMgMgok^k^onk^
k_o^k^kogMgM00;ok^k^00?ogMgMonk^k_oMgMd00oo^k^h01_oMgMgok^k^onk^k_oMgMgok^k^omgM
g@?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kok^k^
00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kogMgM
00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kok^k^
00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kogMgM
00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kok^k^
00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kogMgM
00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kok^k^
00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kogMgM
00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kok^k^
00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kogMgM
00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kok^k^
00Wok^k^00?ogMgMonk^k_o^k^h01oo^k^h00ooMgMgok^k^onk^kP0=onk^kP03omgMgOo^k^kok^k^
00cok^k^00?ogMgMonk^k_o^k^h02_o^k^h00ooMgMgok^k^onk^kP04onk^kP03omgMgOo^k^kogMgM
00Gok^k^00KogMgMonk^k_o^k^kogMgMonk^k_oMgMd3onk^kP03omgMgOo^k^kok^k^00;ok^k^00?o
gMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgMg@04onk^kP03omgMgOo^k^kogMgM00?ok^k^00?o
gMgMonk^k_o^k^h00_o^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kogMgM00Cok^k^00?o
gMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^onk^kP02onk^kP03omgMgOo^k^kogMgM00?ok^k^00?o
gMgMonk^k_oMgMd01?o^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kok^k^00;ok^k^00?o
gMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgMg@04onk^kP03omgMgOo^k^kogMgM00?ok^k^00?o
gMgMonk^k_o^k^h00_o^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kogMgM00Cok^k^00?o
gMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^onk^kP02onk^kP03omgMgOo^k^kogMgM00?ok^k^00?o
gMgMonk^k_oMgMd01?o^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kok^k^00;ok^k^00?o
gMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgMg@04onk^kP03omgMgOo^k^kogMgM00?ok^k^00?o
gMgMonk^k_o^k^h00_o^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kogMgM00Cok^k^00?o
gMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^onk^kP02onk^kP03omgMgOo^k^kogMgM00?ok^k^00?o
gMgMonk^k_oMgMd01?o^k^h00ooMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kok^k^00;ok^k^00?o
gMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgMg@04onk^kP03omgMgOo^k^kogMgM00?ok^k^00?o
gMgMonk^k_o^k^h00_o^k^h00ooMgMgok^k^omgMg@07onk^kP03omgMgOo^k^kok^k^00;ok^k^00?o
gMgMonk^k_oMgMd00_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP0000?oR8R8ogMgMomgMgL00_mg
MgL00on8R8SoMgMgogMgM`04ogMgM`04ohR8R?mgMgOoMgMgohR8R0;oMgMg00?oR8R8ogMgMomgMgL0
0omgMgL01On8R8SoMgMgohR8R?mgMgOoR8R800?oMgMg00CoR8R8ogMgMomgMgOoR8R80_mgMgL00on8
R8SoMgMgohR8R005ogMgM`05ohR8R?mgMgOoMgMgogMgMon8R8P01OmgMgL01on8R8SoMgMgohR8R?mg
MgOoR8R8ogMgMon8R8P00_mgMgL01On8R8SoMgMgogMgMomgMgOoR8R800;oMgMg00OoR8R8ogMgMon8
R8SoMgMgohR8R?mgMgOoR8R800;oMgMg00?oR8R8ogMgMon8R8P00omgMgL01?n8R8SoMgMgogMgMon8
R8P2ogMgM`03ohR8R?mgMgOoR8R800?oMgMg00CoR8R8ogMgMomgMgOoR8R80_mgMgL00on8R8SoMgMg
ohR8R003ogMgM`04ohR8R?mgMgOoMgMgohR8R0;oMgMg00?oR8R8ogMgMon8R8P00omgMgL01?n8R8So
MgMgogMgMon8R8P2ogMgM`03ohR8R?mgMgOoR8R800?oMgMg00CoR8R8ogMgMomgMgOoR8R80_mgMgL0
0on8R8SoMgMgohR8R003ogMgM`04ohR8R?mgMgOoMgMgohR8R0;oMgMg00?oR8R8ogMgMon8R8P00omg
MgL01?n8R8SoMgMgogMgMon8R8P2ogMgM`03ohR8R?mgMgOoR8R800?oMgMg00CoR8R8ogMgMomgMgOo
R8R80_mgMgL00on8R8SoMgMgohR8R003ogMgM`04ohR8R?mgMgOoMgMgohR8R0;oMgMg00?oR8R8ogMg
Mon8R8P00omgMgL01?n8R8SoMgMgogMgMon8R8P2ogMgM`03ohR8R?mgMgOoR8R800?oMgMg00CoR8R8
ogMgMomgMgOoR8R80_mgMgL00on8R8SoMgMgohR8R003ogMgM`04ohR8R?mgMgOoMgMgohR8R0;oMgMg
00?oR8R8ogMgMon8R8P00omgMgL01?n8R8SoMgMgogMgMon8R8P2ogMgM`03ohR8R?mgMgOoR8R800?o
MgMg00CoR8R8ogMgMomgMgOoR8R80_mgMgL00on8R8SoMgMgohR8R003ogMgM`04ohR8R?mgMgOoMgMg
ohR8R0;oMgMg00?oR8R8ogMgMon8R8P00omgMgL01?n8R8SoMgMgogMgMon8R8P2ogMgM`03ohR8R?mg
MgOoR8R800?oMgMg00CoR8R8ogMgMomgMgOoR8R82?mgMgL00on8R8SoMgMgogMgM`07ogMgM`03ohR8
R?mgMgOoMgMg00koMgMg00?oR8R8ogMgMomgMgL02omgMgL00on8R8SoMgMgogMgM`0;ogMgM`03ohR8
R?mgMgOoMgMg00?oMgMg00?oR8R8ogMgMon8R8P01OmgMgL03?n8R8SoMgMgogMgMon8R8SoMgMgohR8
R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R0;oMgMg00_oR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8
ogMgMon8R8SoMgMgohR8R002ogMgM`09ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8
00;oMgMg00_oR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R002ogMgM`09
ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R800;oMgMg00_oR8R8ogMgMon8R8SoMgMg
ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R002ogMgM`09ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMg
ohR8R?mgMgOoR8R800;oMgMg00_oR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8ogMgMon8R8SoMgMg
ohR8R002ogMgM`09ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R800;oMgMg00_oR8R8
ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R002ogMgM`09ohR8R?mgMgOoR8R8
ogMgMon8R8SoMgMgohR8R?mgMgOoR8R800;oMgMg00_oR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8
ogMgMon8R8SoMgMgohR8R002ogMgM`09ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8
00;oMgMg00_oR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R002ogMgM`09
ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R800;oMgMg00_oR8R8ogMgMon8R8SoMgMg
ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R002ogMgM`09ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMg
ohR8R?mgMgOoR8R800;oMgMg00_oR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8ogMgMon8R8SoMgMg
ohR8R002ogMgM`09ohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R?mgMgOoR8R800;oMgMg00_oR8R8
ogMgMon8R8SoMgMgohR8R?mgMgOoR8R8ogMgMon8R8SoMgMgohR8R002ogMgM`09ohR8R?mgMgOoR8R8
ogMgMon8R8SoMgMgohR8R?mgMgOoR8R800;oMgMg00?oR8R8ogMgMon8R8P01omgMgL00on8R8SoMgMg
ohR8R002ogMgM`03ohR8R?mgMgOoR8R800;oMgMg00CoR8R8ogMgMomgMgOoR8R80_mgMgL000;ok^k^
oooMgMeIomgMg@03olc<c?oMgMgogMgM0?oogMgM8_oMgMd2onk^kP0000Gok^k^omgMgOo^k^kogMgM
olc<c007omgMg@;oc<c<00?ogMgMolc<c?o<c<`00_o<c<`5omgMg@04olc<c?oMgMgogMgMolc<c0Co
gMgM00?oc<c<omgMgOoMgMd01_o<c<`5omgMg@03olc<c?oMgMgogMgM00OogMgM1oo<c<`6omgMg@04
olc<c?oMgMgogMgMolc<c0;ogMgM00Coc<c<omgMgOoMgMgoc<c<0ooMgMd00oo<c<cogMgMomgMg@02
omgMg@04olc<c?oMgMgogMgMolc<c0?ogMgM00?oc<c<omgMgOoMgMd00_oMgMd01?o<c<cogMgMomgM
gOo<c<`3omgMg@03olc<c?oMgMgogMgM00;ogMgM00Coc<c<omgMgOoMgMgoc<c<0ooMgMd00oo<c<co
gMgMomgMg@02omgMg@04olc<c?oMgMgogMgMolc<c0?ogMgM00?oc<c<omgMgOoMgMd00_oMgMd01?o<
c<cogMgMomgMgOo<c<`3omgMg@03olc<c?oMgMgogMgM00;ogMgM00Coc<c<omgMgOoMgMgoc<c<0ooM
gMd00oo<c<cogMgMomgMg@02omgMg@04olc<c?oMgMgogMgMolc<c0?ogMgM00?oc<c<omgMgOoMgMd0
0_oMgMd01?o<c<cogMgMomgMgOo<c<`3omgMg@03olc<c?oMgMgogMgM00;ogMgM00Coc<c<omgMgOoM
gMgoc<c<0ooMgMd00oo<c<cogMgMomgMg@02omgMg@04olc<c?oMgMgogMgMolc<c0?ogMgM00?oc<c<
omgMgOoMgMd00_oMgMd01?o<c<cogMgMomgMgOo<c<`3omgMg@03olc<c?oMgMgogMgM00;ogMgM00Co
c<c<omgMgOoMgMgoc<c<0ooMgMd00oo<c<cogMgMomgMg@02omgMg@04olc<c?oMgMgogMgMolc<c0?o
gMgM00?oc<c<omgMgOoMgMd00_oMgMd01?o<c<cogMgMomgMgOo<c<`3omgMg@03olc<c?oMgMgogMgM
00;ogMgM00Coc<c<omgMgOoMgMgoc<c<0ooMgMd00oo<c<cogMgMomgMg@02omgMg@04olc<c?oMgMgo
gMgMolc<c0?ogMgM00?oc<c<omgMgOoMgMd00_oMgMd01?o<c<cogMgMomgMgOo<c<`4omgMg@05olc<
c?oMgMgoc<c<omgMgOo<c<`06_oMgMd00oo<c<cogMgMomgMg@0;omgMg@03olc<c?oMgMgogMgM00So
gMgM1Oo<c<`00ooMgMgoc<c<omgMg@02omgMg@03olc<c?oMgMgogMgM00?ogMgM00Goc<c<omgMgOoM
gMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002
omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oM
gMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM
00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoM
gMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002
omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oM
gMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM
00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoM
gMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002
omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oM
gMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM
00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoM
gMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002
omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oM
gMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM
00Goc<c<omgMgOoMgMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoM
gMgogMgMolc<c002omgMg@03olc<c?oMgMgoc<c<00;ogMgM00Goc<c<omgMgOoMgMgogMgMolc<c008
omgMg@03olc<c?oMgMgoc<c<00?ogMgM00?oc<c<omgMgOoMgMd00ooMgMd00oo<c<cogMgMonk^kP01
onk^kP000_o^k^h2omgMg@03onk^k_oMgMgogMgM00CogMgM0_o<c<`00onk^k_oZZZZok^k^`02ok^k
^`;oc<c<1?oMgMd01?o^k^kogMgMomgMgOo^k^h5omgMg@;oc<c<1Onk^k/2olc<c0?ogMgM00?ok^k^
omgMgOoMgMd02?oMgMd01?o<c<co^k^kok^k^onZZZX2ok^k^`;oc<c<1OoMgMd01?o^k^kogMgMomgM
gOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP?ogMgM00Kok^k^omgMgOoMgMgok^k^omgMgOo^k^h2
omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@05onk^k_oM
gMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@05onk^k_oMgMgogMgMomgMgOo^
k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^
k^kogMgMonk^kP02omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02
omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@05onk^k_oM
gMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@05onk^k_oMgMgogMgMomgMgOo^
k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^
k^kogMgMonk^kP02omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02
omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@05onk^k_oM
gMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@05onk^k_oMgMgogMgMomgMgOo^
k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^
k^kogMgMonk^kP02omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02
omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@03onk^k_oM
gMgogMgM00?ogMgM00?oc<c<omgMgOoMgMd0=OoMgMd01?o<c<cogMgMomgMgOo<c<`5omgMg@04onk^
k_oMgMgogMgMonk^kP;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^
00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^
omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgM
onk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03
onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^
00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^
omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgM
onk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03
onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^
00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^
omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgM
onk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03
onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^
00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^
omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgM
onk^kP02omgMg@03onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03
onk^k_oMgMgok^k^00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP02omgMg@03onk^k_oMgMgok^k^
00;ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP05omgMg@06onk^k_oMgMgogMgMonk^k_oMgMgok^k^
0ooMgMd00oo^k^kogMgMomgMg@03omgMg@03onk^k_oMgMgok^k^007ok^k^000:onk^kP03omgMgOo<
c<coZZZZ00;oR8R800KoVFIVogMgMon8R8SoZZZZok^k^ooMgMd;onk^kP05omgMgOo<c<coVIVIoiVI
VOmVIYT00_mgMgL01?n8R8SoZZZZolc<c?o<c<`4onk^kP03ooooooo^k^kok^k^00Cok^k^00[ogMgM
ok^k^onZZZ[oR8R8ogMgMon8R8SoMgMgohR8R?nZZZ[oc<c<0_oMgMd00oo^k^koooooonk^kP3Konk^
kP?ogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd5onk^kP03omgMgOo^k^kok^k^00?ok^k^00CogMgM
onk^k_o^k^kogMgM0oo^k^h00ooMgMgok^k^onk^kP0Ionk^kP06ojZZZ_mgMgOoIVIVofIVI_nk^k_o
gMgMooo^k^h?onk^kP03ooooooo^k^kok^k^00cok^k^00?oooooonk^k_o^k^h00oo^k^h00004oooo
ooo^k^kogMgMonk^kP;ogMgM00Ook^k^omgMgOo^k^koc<c<ojZZZ_n8R8SoIVIV00;oA4A400Ko<c=V
odA4A?mEEEGoIVIVohR8R?nZZZX2omgMg@03onk^k_oMgMgok^k^00;ogMgM0_o^k^h01OoMgMgoc<c<
ok^k^on8R8SoIVIV00GoA4A400CoIVIVohR8R?nk^k_oc<c<0_oMgMd00oo^k^kogMgMomgMg@02onk^
kP?ogMgM00?oZZZZoiVIVOmEEED00_mEEED01_lc<c?oA4A4oeEEEOmVIVKoVIVIojZZZP?ogMgM00Ko
k^k^omgMgOo^k^kok^k^omgMgOo^k^h2omgMg@;ok^k^0_oMgMd2onk^kP04omgMgOo^k^kogMgMonk^
kP;ogMgM0_o^k^h2omgMg@;ok^k^00CogMgMonk^k_oMgMgok^k^0_oMgMd2onk^kP;ogMgM0_o^k^h0
1?oMgMgok^k^omgMgOo^k^h2omgMg@;ok^k^0_oMgMd2onk^kP04omgMgOo^k^kogMgMonk^kP;ogMgM
0_o^k^h2omgMg@;ok^k^00CogMgMonk^k_oMgMgok^k^0_oMgMd2onk^kP;ogMgM0_o^k^h01?oMgMgo
k^k^omgMgOo^k^h2omgMg@;ok^k^0_oMgMd2onk^kP04omgMgOo^k^kogMgMonk^kP;ogMgM0_o^k^h2
omgMg@;ok^k^00CogMgMonk^k_oMgMgok^k^0_oMgMd2onk^kP;ogMgM0_o^k^h01?oMgMgok^k^omgM
gOo^k^h2omgMg@;ok^k^0_oMgMd2onk^kP04omgMgOo^k^kogMgMonk^kP;ogMgM0_o^k^h2omgMg@;o
k^k^00CogMgMonk^k_oMgMgok^k^0_oMgMd2onk^kP;ogMgM0_o^k^h01?oMgMgok^k^omgMgOo^k^h2
omgMg@;ok^k^0_oMgMd2onk^kP04omgMgOo^k^kogMgMonk^kP;ogMgM0_o^k^h2omgMg@;ok^k^00Co
gMgMonk^k_oMgMgok^k^0_oMgMd2onk^kP;ogMgM0_o^k^h01?oMgMgok^k^omgMgOo^k^h2omgMg@;o
k^k^0_oMgMd2onk^kP04omgMgOo^k^kogMgMonk^kP;ogMgM0_o^k^h2omgMg@;ok^k^00CogMgMonk^
k_oMgMgok^k^0_oMgMd2onk^kP08omgMgOo^k^kogMgMonk^k_nk^k_o8R8RodA4A?nIVIT4omgMg@;o
c<c<00?ogMgMolc<c?oMgMd02OoMgMd02Oo<c<cogMgMolc<c?oMgMgoc<c<omgMgOo<c<cogMgMolc<
c005omgMg@05olc<c?oMgMgogMgMomgMgOo<c<`04?oMgMd02omgMgOoIVIVohR8R?mEEEGo0000ojZZ
Z_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgM
gOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;o
k^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgM
gOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;o
k^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgM
gOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;o
k^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgM
gOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;o
k^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^
k_oMgMgok^k^omgMg@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgM
g@02onk^kP03omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP03omgM
gOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgMg@02onk^kP04omgMgOo^k^kogMgMonk^
kP;ogMgM00gok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
00;ogMgM1?o^k^h000?ok^k^0_oMgMd04_o^k^kogMgMomgMgOo<c<co^k^koiVIVOmEEEGoIS<coiUV
<oo<IVKoc9UVolaVI_nIIS?oIS<coeEEEOn8R8So^k^kolc<c0CogMgM00Wok^k^omgMgOoMgMgoc<c<
ok^k^on8R8SoEEEEofIV<onIVC<00oo<c3<01OnIVC?oIVHcoeEEEOn8R8So^k^k00CogMgM01?ok^k^
omgMgOoMgMgogMgMolc<c?nk^k_oR8R8oeEEEOlcIS?oIYTcofK<<oo<c6KoVL`cofJI<olcIS?oA4A4
oiVII_nk^k_oc<c<00SogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP07omgMg@05onk^k_oMgMgogMgM
omgMgOo^k^h01ooMgMd01Oo^k^kogMgMomgMgOoMgMgok^k^00OogMgM00Gok^k^omgMgOoMgMgogMgM
onk^kP07omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h01ooMgMd01Oo^k^kogMgMomgMgOoMgMgok^k^
00OogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP07omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h01ooM
gMd01Oo^k^kogMgMomgMgOoMgMgok^k^00OogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP07omgMg@05
onk^k_oMgMgogMgMomgMgOo^k^h01ooMgMd01Oo^k^kogMgMomgMgOoMgMgok^k^00OogMgM00Gok^k^
omgMgOoMgMgogMgMonk^kP07omgMg@05onk^k_oMgMgogMgMomgMgOo^k^h01ooMgMd01Oo^k^kogMgM
omgMgOoMgMgok^k^00OogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP07omgMg@05onk^k_oMgMgogMgM
omgMgOo^k^h01ooMgMd00oo^k^kogMgMomgMg@04omgMg@07olc<c?nIVIWoVIVIoa4A4On8R8Soc<c<
omgMg@02olc<c004omgMgOo<c<coc<c<olc<c0;ogMgM0oo<c<`2omgMg@04olc<c?oMgMgoc<c<omgM
g@?oc<c<0_oMgMd02?o<c<co^k^kolc<c?oMgMgoc<c<omgMgOo<c<cogMgM0_o<c<`2omgMg@;oc<c<
0_oMgMd01_o<c<cogMgMomgMgOo<c<cogMgMolc<c0?ogMgM00?oc<c<omgMgOoMgMd00oo<c<`00ooM
gMgoA4A4oc<c<`3oomgMgA3ogMgM00Gok^k^omgMgOoMgMgogMgMonk^kP0:omgMg@04onk^k_oMgMgo
gMgMonk^kP7ooooo00000oooooook^k^omgMg@02onk^kP0OomgMgOo^k^kogMgMolc<c?nIVIWoEEEE
oiTc<oooIVKooiVIooo<VOooVIWoolbIoonIVOooIVKoVC<coeEEEOnZZZ[oc<c<omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo<c<coVIVIofIVI_nIIS?ool`cooooIP03ooooV@0CooooI_o<c3?oVFHc
ofIVI_nIVIWoc<c<onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_o<c<coVIVIofIVI_mVIS?oVOmV
olcoIP03olcoV@07olcoI_nIc6KoIYTcoc=VI_nZZZ[oc<c<omgMg@03onk^kP0;omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00oo^k^h02OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@03onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
00?ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00oo^k^h02OoMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@03onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgM00?ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00oo^
k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@03onk^kP09omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgM00?ok^k^00WogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMd00oo^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMg@03onk^kP09
omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00?ok^k^00WogMgMonk^k_oMgMgok^k^
omgMgOo^k^kogMgMonk^k_oMgMd00oo^k^h02OoMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMgok^k^
omgMg@03onk^kP09omgMgOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00?ok^k^00WogMgM
onk^k_oMgMgok^k^omgMgOo^k^kogMgMonk^k_oMgMd00oo^k^h02OoMgMgok^k^omgMgOo^k^kogMgM
onk^k_oMgMgok^k^omgMg@03onk^kP03omgMgOo^k^kogMgM00;ok^k^00CogMgMonk^k_oMgMgogMgM
0_o^k^h00ooMgMgoEEEEoeEEE@02omgMg@06odA4A?l0003o4A4AohR8R?lA4A7oA4A40_oMgMd00onI
VIWo0000oiVIV@03omgMg@07oc<c<ol0003o4A4AohR8R?lA4A7oEEEEok^k^`02o`0000;o8R8R00[o
MgMgomgMgOoMgMgoc<c<o`000?mVIVKogMgMolc<c?mEEEGo4A4A0ooMgMd01_mEEEGoA4A4onk^k_oM
gMgo8R8RohR8R0;ogMgM00[oMgMgoc<c<ooMgMgogMgMolc<c?mEEEGo<c<cofIVI_n8R8So8R8R0_oM
gMd3onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h00ooMgMgok^k^omgM
g@03onk^kP03omgMgOo^k^kogMgM00?ok^k^00?ogMgMonk^k_oMgMd00oo^k^h02ooMgMgok^k^omgM
gOo^k^kogMgMonk^k_oMgMgok^k^omgMgOo^k^kogMgM00;ok^k^00GogMgMonk^k_oMgMgok^k^omgM
g@04onk^kP0000Kok^k^ooooooooooooooooonk^k_ooool2onk^kP05olc<c?nIVIWoIS<coomVI_oo
VFH00_ooVIT02?ooc<coolbIoonIVOooVIWoc6IVoiTc<onIVIWoc<c<0_o^k^h00oooooook^k^oooo
o`02onk^kP07olc<c?n8R8SoVFHcolc<<oooc6KooonIooooIP03ooooV@0Cooo<I_ooc3?oVFHcohR8
R?o<c<cok^k^ooooooo^k^koooooonk^k_ooooook^k^olc<c?n8R8So<iTcofK<<onIc6Koc?nIolco
IP03olcoV@07olcoI_mVc3?oIVHcohR8R?o<c<cok^k^ooooo`02onk^kP3Aooooooo^k^koooooonk^
k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^oooo
ooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^
k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^oooo
ooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^
k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^oooo
ooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^
k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^oooo
ooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^
k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^oooo
ooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^
k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^oooo
ooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^
k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^oooo
ooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooool00_o^k^h5ooooo`;ok^k^00Wo
R8R8oa4A4Oo^k^koc<c<o`000?nk^k_ogMgMoeEEEOl000000oo^k^h00omEEEGo4A4Aoc<c<`02onk^
kP09ok^k^ol0003oc<c<olc<c?mEEEGo4A4Aonk^k_oMgMgoZZZZ00;ok^k^00Go^k^ko`000?nk^k_o
k^k^ok^k^`02oa4A4@;ok^k^00?o<c<co`000?nZZZX00_o^k^h0oomVIVKoEEEEonk^k_o^k^ko8R8R
ohR8R?o^k^koooooohR8R?lR8R;ok^k^oooooom4A4Co8R8RoiVIVOmgMgOo8R8Roa4A4Oo^k^kooooo
onk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^
ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^kooooo
onk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^
ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^kooooo
onk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^
ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^kooooo
onk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^
ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^kooooo
onk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^
ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^kooooo
onk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^
ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^kooooo
onk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^
ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^kooooo
onk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^
ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^kP00:?ooooook^k^ooooooo^k^ko
ooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_oooooo
k^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^koooooonk^k_ooooook^k^ooooooo^k^ko
ooooonk^k_ooooook^k^ooooooo^k^h4ooooo`09onk^k_ooooook^k^ooooooo^k^koooooonk^k_oo
ooook^k^007ooooo00000oooooook^k^onk^kP04onk^kP05omgMgOnk^k_oIVHcol`c<oo<IVH01_oo
VIT01_ooIVKooiUVol`c<omEEEGoc<c<omgMg@Gok^k^00OogMgMok^k^onIIVKooiT0oonII_ooc6Ko
oomV00;ooonI0_ooofH2ooo<IP04oonI0?mVIVKo^k^komgMg@Gok^k^00OogMgMok^k^olcIVKoIYT0
oiW<I_nIofKoc?mV00;oc?nI00SoVOmVolcoVOnIofKoVLaVoc?<0?mVIVKo^k^komgMgMKok^k^00?o
gMgMonk^k_o^k^h01?o^k^h02_mgMgOo8R8Ronk^k_o<c<co0000ojZZZ_oMgMgoVIVIoa4A4Oo^k^h2
omgMg@0>o`000?nZZZ[o0000olc<c?oMgMgo^k^ko`000?nk^k_ok^k^ogMgMolR8R;ok^k^omgMgOo^
k^h2omgMg@0<olc<c?l0003oR8R8omgMgOmVIVKoA4A4oc<c<onZZZ[o^k^ko`000?mgMgOoEEEE0_oM
gMd2oeEEE@04onk^k_oMgMgo8R8RohR8R0;ogMgM00[oMgMgoc<c<ooMgMgoc<c<o`000?nZZZ[ogMgM
onk^k_mgMgOo4A4Aooo^k^hFonk^kP03omgMgOo^k^kok^k^00[ok^k^0Oooool00005ooooooo^k^ko
k^k^omgMgOo^k^h00ooMgMd02?nk^k_oIS<col`c<oooIVKoc6IVoonII_ooVIWooiUV0_ooVIT01Ooo
VFKoc6IVol`c<omV<c?oZZZZ00?ogMgM00cok^k^omgMgOoMgMgogMgMok^k^onIIS?oc9Tcooo<<ooo
c6KooomVooo<I_ooofH3ooo<IP04ooo<<oo<VC?oVFHcok^k^`?ogMgM01?ok^k^omgMgOoMgMgogMgM
ok^k^olcIS?oIYTcoiW<<onIofKoVLaVoiWoVOo<ofKoc<bIoiWoI_nIc3?oVLaVofJI<olcIS?oZZZZ
00;ogMgM00?ok^k^omgMgOo^k^h00_oMgMd00oo^k^kogMgMonk^kP02omgMg@04onk^k_oMgMgogMgM
onk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^
k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2
omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgM
omgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd0
1?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgo
k^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^
omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;o
gMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgo
gMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04
onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^
k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^ko
gMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oM
gMd01?o^k^kogMgMomgMgOo^k^h2omgMg@06onk^k_oMgMgogMgMonk^k_oMgMgok^k^1?oMgMd02oo^
k^kogMgMogMgMolA4A7oc<c<onk^k_nIVIWo<c<cob8R8_lc<c?o4A4A00;ogMgM00GoR8R8oa4A4OoM
gMgoEEEEofIVIP02omgMg@05oiVIVOlR8R;o8R8Roc<c<olR8R800ooMgMd2olc<c00<ofIVI_l0003o
^k^komgMgOlR8R;oR8R8ogMgMomVIVKoR8R8oc<c<oo<c<co00000_oMgMd03_mEEEGoA4A4omgMgOoM
gMgo8R8RohR8R?o<c<cogMgMogMgMolR8R;ogMgMojZZZ_l0003oc<c<0_oMgMd00on8R8So4A4AomgM
g@03omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^ko
gMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oM
gMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoM
gMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Co
k^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^
kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oM
gMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgM
g@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgM
gOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^
k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^
0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgM
gOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM
00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgM
onk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^
k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgMomgMgOo^k^h2
omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd01?o^k^kogMgM
omgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kP;ogMgM00Cok^k^omgMgOoMgMgok^k^0_oMgMd0
1?o^k^kogMgMomgMgOo^k^h2omgMg@04onk^k_oMgMgogMgMonk^kPCogMgM00Cok^k^omgMgOoMgMgo
k^k^0_oMgMd1onk^kP7ooooo0Oooool000;ooooo1Oo^k^h01OoMgMgo^k^kogL00?o<<c?oc6IV00;o
ofIV00?ooiUVoonIVOo<VFH00_ooIVH01Oo<IS?oc3<cogL00?o<c<cogMgM00Gok^k^00KogMgMok^k
^onI<`3ooiTcolbI<oooc3<3ooo<IP03ooooI_ooc6Kool`c00;ooiTc00?oVC<0ok^k^ooMgMd01Oo^
k^h04OoMgMgo^k^koc=V0?mVVC?oI/`coiW<<onIc6KoVOmVoiW<I_o<ofKoI/aVoiW<I_mVVC?oI/`c
o`140?o<c<cogMgM0=_ok^k^00OogMgMonk^k_mgMgOo8R8Ronk^k_oMgMgok^k^00;ogMgM00_oR8R8
oa4A4Oo^k^kogMgMoc<c<omgMgOok^k^ojZZZ_lA4A7ogMgMonk^kP03omgMg@0<ogMgMolR8R;ok^k^
onk^k_oMgMgo^k^kob8R8_l0003oVIVIonk^k_o<c<co00000_o<c<`01olR8R;oEEEEogMgMoo^k^ko
8R8RojZZZ_o^k^h00_mEEED03?oMgMgok^k^ob8R8_mVIVKok^k^omgMgOmgMgOo<c<conk^k_nk^k_o
0000ojZZZP;ogMgM00?oVIVIoa4A4Oo^k^h0ooo^k^hRonk^kP7ooooo0007ooooo`03onk^k_oMgMgo
E@0000;oc3<c00Ooc6HcolaVI_o<IVKoc6IVoomVI_o<IVKoc6Hc00;oc3<c00?oIP00olc<c?o^k^h0
1Oooool01?o^k^kogMgMoiTc0?o<VC<3oonI<`04ooo<<oo<c3?ooiUVooo<<`;ooiTc00Coc9TcoiTc
0?oMgMgok^k^1Oooool01?o^k^kogMgMo`140?lcVC<2ofJI<`0;oiW<<omVc3?oVLaVofK<I_nIc3?o
I/`cofK<0?mVVC?o05D0olc<c?o^k^h0gOooool03On8R8So4A4Aonk^k_oooooo^k^kolc<c?oooooo
IVIVodA4A?o^k^kogMgMo`000?oMgMd00_ooool01_lR8R;oZZZZoooooonZZZ[ogMgMooooo`;oEEEE
00Kok^k^oooooonIVIWo0000oc<c<oo<c<`2ooooo`0=oiVIVOlR8R;ooooooooooolR8R;o0000ok^k
^oooooooR8R8oeEEEOooooooIVIVoeEEE@02ooooo`06ob8R8_lA4A7oR8R8omgMgOm4A4CoEEEE0_oo
ool01_lc<c?oA4A4omgMgOo^k^koEEEEoa4A4Ooooooo9?ooool000;ooooo1_o^k^h02Oo<c<coIS<c
oiTc<oo<<`3oc3<colaV<oo<<c?oc6IVolaV<`03ol`c<`03oiTc<omV<c?oc<c<00Ook^k^00Koc<c<
oiT0<oo<VC?oc9T0oonI0?o<VC<2oonI<`07ooo<<oooV@3ooiTcolbI0?o<IS?oVC<colc<c007onk^
kP0;olc<c?lR8R;o<iTcoc>I0?mVVC?oI/`coiVI<omVc3?oVITcofK<<omVV@000_lcVC<00olR8R;o
gMgMonk^kP3Lonk^kP03omgMgOmgMgOo8R8R00;ok^k^00SoMgMgoc<c<ol0003o<c<cojZZZ_oooooo
MgMgodA4A0?ok^k^01;oR8R8oeEEEOo^k^koIVIVob8R8_l0003oA4A4ok^k^oo^k^kogMgMoa4A4OmV
IVKogMgMonk^k_oMgMgok^k^oeEEEOmgMgL2onk^kP09ofIVI_lR8R;ok^k^onk^k_o<c<co8R8Ronk^
k_mVIVKoEEEE00;ok^k^00Ko<c<cohR8R?mEEEGo0000oc<c<oo<c<`2onk^kP06olc<c?lc<c?o0000
ob8R8_mVIVKo8R8Rooo^k^hRonk^kP;ooooo00000oooooook^k^onk^kP04onk^kP04omgMgOo^k^ko
IS<cofHc<`;oVC<c00Goc3<colaVI_o<IS?oc3=VolaV<`03oiTc<`04odA4A?oMgMgok^k^omgMg@Co
k^k^0_oMgMd01onIIS?oVC<colaV<oo<VC?ooiTcolbI<oooVC<00_o<VC<01?o<IS?oc9TcoiTc<onI
<c<2omgMg@?ok^k^00OogMgMonk^k_o^k^kogMgModA4A?lcIS?o<iTc00;oIYTc00?oI/`cofJI<omV
c3<00_mVVC<00olcVC?o<fHcodA4A002omgMg@;ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?ok^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgo
k^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00Kok^k^00?oR8R8oa4A4OoMgMd00oo^k^h01?oMgMgo
k^k^onk^k_oMgMd5onk^kP03omgMgOo^k^kok^k^00?ok^k^00KogMgMonk^k_o^k^kogMgMo`000?nk
^k/2omgMg@05onk^k_oMgMgok^k^onk^k_oMgMd01oo^k^h01OoMgMgok^k^onk^k_o^k^kogMgM00Go
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00?o
k^k^00?ogMgMonk^k_o^k^h00oo^k^h00ooMgMgok^k^onk^kP03onk^kP03omgMgOo^k^kok^k^00go
k^k^0_ooool000;ooooo1oo^k^h01?n8R8SoIS<coiUVI_o<IVH2olbIV@07oonIVOo<VIWoc9VIolaV
I_nIIVKoA000oiVIV@09onk^kP07ohR8R?nI<c?oc6IVolbII_o<c9WoolbIolc<V@02ooo<V@04olbI
I_nIIVKoVC<0oiVIV@Wok^k^00CoR8R8ob8R8_mVVFKoIYUV0_nIc9T01oo<c9WoVLbIoiW<VOmVVFKo
EEEEob8R8_n8R8P0goo^k^h00omgMgOo8R8Ronk^kP0Fonk^kP05oeEEEOlR8R;oR8R8ofIVI_lc<c<0
3?o^k^h2ofIVI_ook^k^<_o^k^h2ooooo`002_ooool00omVIVKoIS<coiVIV@02ooo<c006onk^k_oM
gMgoolc<olbIVOmV<c?oIVIV2oooool02onIIVKoIS<colbIVOooc<cogMgMooooooooc<coc<c<olbI
VOnI<c?oIVIV00[ooooo00Gok^k^ogMgMolc<c?oVIVIolc<c002onk^kP05olcoc?o<c<coVIVIodA4
A?mVIVH0h?ooool00oo<c<coVIVIooooo`0Gooooo`04olc<c?mVIVKoMgMgojZZZPcooooo0_nk^k_o
ooooocCooooo0003ooooo`?ok^k^00ooooooonk^k_o^k^kok^k^omgMgOmVIVKo<c<coiVIVOnk^k_o
gMgMok^k^on8R8So<c<cofIVI_oMgMd00_o^k^h01?ooooook^k^onk^k_ooool2onk^kP0>ooooooo^
k^kok^k^omgMgOnIIVKoIS<colbIVOooc<coc<c<ooo<c?o<VIWoIS<coiUVI_oMgMd3onk^kP04oooo
ooo^k^kok^k^ooooo`;ok^k^00goooooonk^k_o<c<coIVIVoc<c<onIVIWo^k^komgMgOnk^k_oR8R8
oc<c<omVIVKogMgM00;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2
onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^
onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h0
1?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^ko
oooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Cooooo
onk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;o
k^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^ko
k^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04
ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_oo
ool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?oooooo
k^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^
k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^
k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Co
ooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^oooo
o`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^
k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^
kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^
k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?oo
ooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo
0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^
k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^
00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^
ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04oooo
ooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2
onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^
onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h0
1?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^ko
oooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Cooooo
onk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;o
k^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^ko
k^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04
ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_oo
ool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?oooooo
k^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^
k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^
k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Co
ooooonk^k_o^k^kooooo2?o^k^h2ooooo`7ok^k^00000oo^k^koooooooooo`03onk^kP04omgMgOo^
k^kok^k^omgMg@;ok^k^00WoVIVIoeEEEOlR8R;o0000ob8R8_mEEEGoVIVIonk^k_oMgMd00_o^k^h0
1?oMgMgok^k^onk^k_oMgMd2onk^kP0<omgMgOo^k^kok^k^omgMgOo^k^koVIVIoeEEEOlR8R;oA000
ob8R8_mEEEGoR8R80_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@?o
k^k^00WoVIVIoeEEEOlR8R;o0000ob8R8_mEEEGoVIVIonk^k_oMgMd00_o^k^h01?oMgMgok^k^onk^
k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oM
gMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM
0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^
k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^
00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^
omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgM
gOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2
onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^
onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h0
1?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^ko
gMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgM
onk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;o
k^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^ko
k^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04
omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oM
gMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgo
k^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^
k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^
k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00Co
gMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgM
g@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^
k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^
kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^
k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oM
gMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM
0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^
k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^
00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^
omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgM
gOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2
onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^
onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h0
1?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgMonk^k_o^k^ko
gMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;ok^k^00CogMgM
onk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP04omgMgOo^k^kok^k^omgMg@;o
k^k^00CogMgMonk^k_o^k^kogMgM0_o^k^h01?oMgMgok^k^onk^k_oMgMd2onk^kP03omgMgOo^k^ko
k^k^00?ok^k^0_ooool1omgMg@0000?oc<c<ooooooooool00oo^k^h01?ooooook^k^onk^k_ooool2
onk^kP03ooooooo^k^kok^k^00;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^
k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00?oooooonk^k_o^k^h00_o^k^h01?oooooo
k^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo1Oo^
k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^
k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Co
ooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^oooo
o`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^
k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^
kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^
k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?oo
ooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo
0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^
k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^
00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^
ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04oooo
ooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2
onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^
onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h0
1?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^ko
oooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Cooooo
onk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;o
k^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^ko
k^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04
ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_oo
ool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?oooooo
k^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^
k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^
k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Co
ooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^oooo
o`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^
k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^
kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^
k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?oo
ooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo
0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Coooooonk^
k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^
00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04ooooooo^k^kok^k^
ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2onk^kP04oooo
ooo^k^kok^k^ooooo`;ok^k^00Coooooonk^k_o^k^kooooo0_o^k^h01?ooooook^k^onk^k_ooool2
onk^kP04ooooooo^k^kok^k^ooooo`;ok^k^00Soooooonk^k_o^k^kok^k^ooooooo^k^koooooonk^
kP7oVIVI0002olc<c?oooooooooooommooooo`7ok^k^0OnZZZX1ojZZZP0000?oooooolc<c?o<c<`0
ooooooooooooog[ooooo00Cok^k^omgMgOnZZZ[oZZZZ0Oo<c<`00001\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{640, 480},
  ImageMargins->{{0, 0}, {0, 1}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create", "Subsection"],

Cell["A MathJFrame is created.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(frame = NewMathJFrame["\<JavaSwing\>", 640, 480, 360, 0]\), "\n", 
    \(If[frame === $Failed, Abort[]]\)}], "Input"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "com.wolfram.jlink.MathJFrame"] \[RightGuillemet]\),
      JLink`Objects`JavaObject49780801667073]], "Output"]
}, Open  ]],

Cell["\<\
A frame has four panes in its JRootPane. The content pane is one of \
the most important object among these. Glass pane, layered pane, and menu bar \
are the rest of these. The menu bar is null by default.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(pane = frame@getContentPane[]\), "\n", 
    \(glass = frame@getGlassPane[]\), "\n", 
    \(layer = frame@getLayeredPane[]\), "\n", 
    \(menubar = frame@getJMenuBar[]\)}], "Input"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "javax.swing.JPanel"] \[RightGuillemet]\),
      JLink`Objects`JavaObject122481645977601]], "Output"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "javax.swing.JPanel"] \[RightGuillemet]\),
      JLink`Objects`JavaObject122773552758785]], "Output"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "javax.swing.JLayeredPane"] \[RightGuillemet]\),
      JLink`Objects`JavaObject102833848320001]], "Output"]
}, Open  ]],

Cell[TextData[{
  "The ",
  StyleBox["frame",
    FontWeight->"Bold"],
  " is located to the center of the main screen and is shown."
}], "Text"],

Cell[BoxData[{
    \(CenterizeFrameOnScreen[frame]\), "\[IndentingNewLine]", 
    \(JavaShow[frame]\)}], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["<<< SimpleMathJFrame >>>",
  FontColor->RGBColor[0, 0, 1]]], "Section"],

Cell[CellGroupData[{

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40001`0000=AP00`40o`00
0?l0003oL000000000>8`;Q8T8Q8T8P0K4R@R04000000003R<2hb>3HR<2h
06^8`;P1B9280@00000000>8`;S8h=R8`;P0JhS0^058T8P1000000001HS0
^<SPf8S0^8S0^<c<c00coooo00?<c<coooooool0<Oooo`:8`;P1B9280@00
000000J8`;S8h=R8`;R8`;QVIVK<c<`aIVIV00?ooomVIVK<c<`0<FIVIP04
ooooR<2hR<2hB9280@00000000J8`;S8h=R8`;R8`;QVIVKoool`c<c<00=V
IVKooomVIVH0<Oooo`05IVIVooooR<2hR<2hB928004000000006R<2hb>3H
R<2hR<2hIVIVoooo<<c<c003IVIVooooIVIV037oool01FIVI_ooohS0^8S0
^4R@R001000000001XS0^<SPf8S0^8S0^6IVI_oooa3<c<`@VIW<4<c<c003
IVIVooooIVIV037oool01FIVI_ooohS0^8S0^4R@R001000000001XS0^<SP
f8S0^8S0^6IVI_oooa3<c<`00iVIc<c<c<c<c00<c<c<00>IVLc<c<c<c<`0
3/c<c003IVIVooooIVIV037oool01FIVI_ooohS0^8S0^4R@R00100000000
1XS0^<SPf8S0^8S0^6IVI_oooa3<c<`00iVIc<c<c<c<c00<c<c<00>IVLc<
c<c<c<`03/c<c003IVIVooooIVIV037oool01FIVI_ooohS0^8S0^4R@R001
000000001XS0^<SPf8S0^8S0^6IVI_oooa3<c<`00iVIc<c<c<c<c00<c<c<
00>IVLc<c<c<c<`03/c<c003IVIVooooIVIV037oool01FIVI_ooohS0^8S0
^4R@R001000000001XS0^<SPf8S0^8S0^6IVI_oooa3<c<`00iVIc<c<c<c<
c00<c<c<00>IVLc<c<c<c<`03/c<c003IVIVooooIVIV00?oool30000:ooo
o`05IVIVooooR<2hR<2hB928004000000006R<2hb>3HR<2hR<2hIVIVoooo
4<c<c003VIW<c<c<c<c<00800005c<c<0P0000?<c<`00iVIc<c<c<c<c00>
c<c<00=VIVKooomVIVH00_ooo`050000oooooooooooo000002[oool01FIV
I_ooohS0^8S0^4R@R001000000001XS0^<SPf8S0^8S0^6IVI_oooa3<c<`0
0iVIc<c<c<c<c00200001Lc<c0800003c<c<00>IVLc<c<c<c<`03/c<c003
IVIVooooIVIV00Koool00`000?ooooooo`0Xoooo00EVIVKooon8`;R8`;Q8
T8P00@00000000J8`;S8h=R8`;R8`;QVIVKoool@c<c<00>IVL`000000000
10000003c<c<0000000000@000000lc<c9VIc<c<c00?c<c<00=VIVKooomV
IVH01_ooo`030000oooooooo02Soool01FIVI_ooohS0^8S0^4R@R0010000
00001XS0^<SPf8S0^8S0^6IVI_oooa3<c<`00iVIc<c<c<c<c00200001Lc<
c0800003c<c<00>IVLc<c<c<c<`03/c<c003IVIVooooIVIV00;oool01@00
0?ooooooooooo`00000Zoooo00EVIVKooon8`;R8`;Q8T8P00@00000000J8
`;S8h=R8`;R8`;QVIVKoool@c<c<00>IVLc<c<c<c<`00P0000G<c<`20000
0lc<c003VIW<c<c<c<c<00k<c<`00fIVI_ooofIVIP02oooo100002_oool0
1FIVI_ooohS0^8S0^4R@R001000000001XS0^<SPf8S0^8S0^6IVI_oooa3<
c<`00iVIc<c<c<c<c00<c<c<00>IVLc<c<c<c<`03/c<c003IVIVooooIVIV
00;oool00`000?ooooooo`0/oooo00EVIVKooon8`;R8`;Q8T8P00@000000
00J8`;S8h=R8`;R8`;QVIVKoool@c<c<00>IVLc<c<c<c<`03<c<c003VIW<
c<c<c<c<00k<c<`00fIVI_ooofIVIP03oooo00<0003oooooool0:oooo`05
IVIVooooR<2hR<2hB928004000000006R<2hb>3HR<2hR<2hIVIVoooo4<c<
c003VIW<c<c<c<c<00c<c<`00iVIc<c<c<c<c00>c<c<00=VIVKooomVIVH0
0oooo`@0000Zoooo00EVIVKooon8`;R8`;Q8T8P00@00000000J8`;S8h=R8
`;R8`;QVIVKoool@c<c<00>IVLc<c<c<c<`03<c<c003VIW<c<c<c<c<00k<
c<`00fIVI_ooofIVIP0aoooo00EVIVKooon8`;R8`;Q8T8P00@00000000J8
`;S8h=R8`;R8`;QVIVKoool@c<c<00>IVLc<c<c<c<`03<c<c003VIW<c<c<
c<c<00k<c<`00fIVI_ooofIVIP0aoooo00EVIVKooon8`;R8`;Q8T8P00@00
000000J8`;S8h=R8`;R8`;QVIVKoool@c<c<00>IVLc<c<c<c<`03<c<c003
VIW<c<c<c<c<00k<c<`00fIVI_ooofIVIP0aoooo00EVIVKooon8`;R8`;Q8
T8P00@00000000J8`;S8h=R8`;R8`;QVIVKoool@c<c<00>IVLc<c<c<c<`0
3<c<c003VIW<c<c<c<c<00k<c<`00fIVI_ooofIVIP0aoooo00EVIVKooon8
`;R8`;Q8T8P00@00000000J8`;S8h=R8`;R8`;QVIVKoool@c<c<49VIc13<
c<`00fIVI_ooofIVIP0aoooo00EVIVKooon8`;R8`;Q8T8P00@00000000J8
`;S8h=R8`;R8`;QVIVKoool`c<c<00=VIVKooomVIVH0<Oooo`05IVIVoooo
R<2hR<2hB928004000000006R<2hb>3HR<2hR<2hIVIVoooo<<c<c003IVIV
ooooIVIV037oool01FIVI_ooohS0^8S0^4R@R001000000001HS0^<SPf8S0
^8S0^6IVIP0aoooo00?<c<cooomVIVH0<Oooo`05c<c<ooooR<2hR<2hB928
004000000004R<2hb>3HR<2hR<2h<fIVIP03c<c<IVIVIVIV035VIVH01<c<
c8S0^8S0^4R@R04000000003R<2hb>3HR<2h06^8`;P1B9280@00000000B8
`;S8h=R8`;R8`;PC002001l01H812h@248H35XP378X48H`59hh6;I06<Y87
>9@8?IH9@iP9BIX:CY`;E9h<FZ0<Gj8=IJ@>JZH?L:P?MZX@Nj`APJhBQk0B
S;8CT[@DUkHEWKPEXkXFZ;`G[[h0=QRd`0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;P4002000>KYo4c@jDc@jD02C=3Y@<008007`05PP4;Q08@QP<F
R0<LRP@QS0DWSPH]T0HbTPLhU0PmUPU3V0U9VPY>W0]DWPaJX0aOXPeUY0iZ
YPm`Z0mfZQ1k[161[Q:7/1:</Q>B]1BG]QFM^1FS^QJX_1N^_P0f6;C00XS0
^058T8P10000000018S0^<SPf8S0^8S0^0<008001i^WlOooohij]ZJKa;>Y
dZRMb;>YdP02YY_400Fl^=g^k_CZjO7ooolc@jD00P00P00O00F20@^40Q26
0aJ80ab:126<1BN>1Rf@1S:B1cRD23fF2D>H2DVJ2TjL2eBN35ZP35nR3FFT
3VZV3g2X3gJZ47^/4H6^4XN`4Xbb4i:d59Nf5Ifh5J>j5ZRl5jjn008H]<0P
00000QRd`10000026;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^080
080019^WlOooofaJYJnUbP:l^=d0:_omok>Yd_oooooookbhgIN:_:RMb>KV
k?oooc=3Y@00P005PP4;Q08@QP<FR0<LRP@QS0DWSPH]T0HbTPLhU0PmUPU3
V0U9VPY>W0]DWPaJX0aOXPeUY0iZYPm`Z0mfZQ1k[161[Q:7/1:</Q>B]1BG
]QFM^1FS^QJX_1N^_P8H]<000lSPf4R@R4R@R00<B92800<00038h=Q8T8P0
3DR@R00400006;C06;C0b>3H3TR@R00300006;C06;C000:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;P2002000^KYo7ooonXWLSoooncZM9PC9Z>N[Ih
IJjXWLSooooooOl00oooo`0R<d>U0020002000F20@^40Q260aJ80ab:126<
1BN>1Rf@1S:B1cRD23fF2D>H2DVJ2TjL2eBN35ZP35nR3FFT3VZV3g2X3gJZ
47^/4H6^4XN`4Xbb4i:d59Nf5Ifh5J>j5ZRl5jjn0QRd`003b>3HR<2hR<2h
00^8`;P00dR@R0000<SPf00=R<2h00E8T8P0000H]<0H]<38h=P03HS0^004
B92800006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^0800800
3Y^WlOooooooom_Lk61<VY>5^[>Yd[bhgF1<VYV?_ZJKa<S3gooooc=3Y@<0
08007`05PP4;Q08@QP<FR0<LRP@QS0DWSPH]T0HbTPLhU0PmUPU3V0U9VPY>
W0]DWPaJX0aOXPeUY0iZYPm`Z0mfZQ1k[161[Q:7/1:</Q>B]1BG]QFM^1FS
^QJX_1N^_P026;C000C8h=R8`;R8`;R8`;P6000018S0^003B9280000b>3H
00:8`;P900000XS0^005B92800006;C06;C0b>3H00f8`;P014R@R00001Rd
`1Rd`0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;P3002000jKYo7ooonl
^=fISkkooooFdMgKg>cco_nVVlC^k_B5M[2CQK[ooolc@jD2002001l01H81
2h@248H35XP378X48H`59hh6;I06<Y87>9@8?IH9@iP9BIX:CY`;E9h<FZ0<
Gj8=IJ@>JZH?L:P?MZX@Nj`APJhBQk0BS;8CT[@DUkHEWKPEXkXFZ;`G[[h0
0QRd`004b>3HR<2hR<2hR<2h1P0000B8`;P00dR@R0000<SPf002R<2h00<0
0028`;R8`;P01HS0^0050000R<2hR<2hB9280000008H]<001<SPf8S0^8S0
^8S0^0800004R<2h0P0000:8`;P014R@R00001Rd`1Rd`0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;P3002002nKYo7ooonISkjGR[cDdnS_[;?oMW_^
Wj]KF:FVVlBFWm9PC9Zl^=gooolc@jD008001H812h@248H35XP378X48H`5
9hh6;I06<Y87>9@8?IH9@iP9BIX:CY`;E9h<FZ0<Gj8=IJ@>JZH?L:P?MZX@
Nj`APJhBQk0BS;8CT[@DUkHEWKPEXkXFZ;`G[[h00QRd`003b>3HR<2hR<2h
00^8`;P00dR@R0000<SPf002R<2h00<00028`;R8`;P01HS0^0050000R<2h
R<2hB9280000008H]<000lSPf8S0^8S0^002R<2h0P0000:8`;P200000hS0
^004B92800006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^080
08002Y^WlOoooiN:_7Y/Z[?7j:U^X<S3gi>5^U]6TiV?_P9hIJh0948WQJnU
b_oooc=3Y@00P005PP4;Q08@QP<FR0<LRP@QS0DWSPH]T0HbTPLhU0PmUPU3
V0U9VPY>W0]DWPaJX0aOXPeUY0iZYPm`Z0mfZQ1k[161[Q:7/1:</Q>B]1BG
]QFM^1FS^QJX_1N^_P8H]<000lSPf8S0^8S0^00;R<2h00=8T8P00038h=P0
0XS0^0030000R<2hR<2h00F8`;P01@0008S0^8S0^4R@R00000026;C000?8
h=R8`;R8`;P00hS0^0@00004R<2h00A8T8P0000H]<0H]<02R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h0P00P003VjOaoooooooo00;oool02_n]/?mf
NoW=e?g]k_ooojJKa8Ef/;bhgOoooc=3Y@8008007`05PP4;Q08@QP<FR0<L
RP@QS0DWSPH]T0HbTPLhU0PmUPU3V0U9VPY>W0]DWPaJX0aOXPeUY0iZYPm`
Z0mfZQ1k[161[Q:7/1:</Q>B]1BG]QFM^1FS^QJX_1N^_P026;C000?8h=R8
`;R8`;P02hS0^003B9280000b>3H00:8`;P00`0008S0^8S0^005R<2h00D0
0028`;R8`;Q8T8P000000QRd`003b>3HR<2hR<2h00B8`;P200001HS0^004
B92800006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^0<00800
2Z6/l_W=e>8V??Be_n8V??A]OOcSjOoooog]k_n]/0;oool08c=3Y@00P000
P000P005PP4;Q08@QP<FR0<LRP@QS0DWSPH]T0HbTPLhU0PmUPU3V0U9VPY>
W0]DWPaJX0aOXPeUY0iZYPm`Z0mfZQ1k[161[Q:7/1:</Q>B]1BG]QFM^1FS
^QJX_1N^_P026;C000?8h=R8`;R8`;P02hS0^003B9280000b>3H00:8`;P0
0`0008S0^8S0^005R<2h00D00028`;R8`;Q8T8P000000QRd`003b>3HR<2h
R<2h00>8`;P4000018S0^004B92800006;C06;C00XS0^058T8P100000000
18S0^<SPf8S0^8S0^08008003I^WlOg]k^8V??ken?N9UoARK_>P[_ARK_om
oon]/?cSjOoooc=3Y@04002001l01H812h@248H35XP378X48H`59hh6;I06
<Y87>9@8?IH9@iP9BIX:CY`;E9h<FZ0<Gj8=IJ@>JZH?L:P?MZX@Nj`APJhB
Qk0BS;8CT[@DUkHEWKPEXkXFZ;`G[[h00QRd`003b>3HR<2hR<2h00^8`;P0
0dR@R0000<SPf002R<2h00<00028`;R8`;P01HS0^0050000R<2hR<2hB928
0000008H]<000lSPf8S0^8S0^002R<2h0P0000:8`;P200000hS0^004B928
00006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^08008000i^W
lOK8c>8V?002ojf`00OO92koY9kf_<Go[K3^Nhcooolc@jD01@00P00O00F2
0@^40Q260aJ80ab:126<1BN>1Rf@1S:B1cRD23fF2D>H2DVJ2TjL2eBN35ZP
35nR3FFT3VZV3g2X3gJZ47^/4H6^4XN`4Xbb4i:d59Nf5Ifh5J>j5ZRl5jjn
008H]<000lSPf8S0^8S0^00;R<2h00=8T8P00038h=P00XS0^0T00002R<2h
00E8T8P0000H]<0H]<38h=P00hS0^0800004R<2h0P0000:8`;P014R@R000
01Rd`1Rd`0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;P2002000>KYo7i
cMCgRIL00_ooo`07ojf`hAHdogIkojBNhRHlohUo<d>U00D008007`05PP4;
Q08@QP<FR0<LRP@QS0DWSPH]T0HbTPLhU0PmUPU3V0U9VPY>W0]DWPaJX0aO
XPeUY0iZYPm`Z0mfZQ1k[161[Q:7/1:</Q>B]1BG]QFM^1FS^QJX_1N^_P02
6;C000?8h=R8`;R8`;P02hS0^003B9280000b>3H00:8`;P900000XS0^005
B92800006;C06;C0b>3H00f8`;P014R@R00001Rd`1Rd`0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;P2002000NKYo7oooocX:kdHVkoooogRIOicM@0
0_ooo`03lj2^oooo<d>U00D008007`05PP4;Q08@QP<FR0<LRP@QS0DWSPH]
T0HbTPLhU0PmUPU3V0U9VPY>W0]DWPaJX0aOXPeUY0iZYPm`Z0mfZQ1k[161
[Q:7/1:</Q>B]1BG]QFM^1FS^QJX_1N^_P026;C000?8h=R8`;R8`;P02hS0
^003B9280000b>3H00f8`;P01DR@R00001Rd`1Rd`<SPf00=R<2h00A8T8P0
000H]<0H]<02R<2h0DR@R04000000004R<2hb>3HR<2hR<2h0`00P00;VjOa
ooooohUooooolj2^lI>Qoooooogolj2^oo_l<d>U00D008007`05PP4;Q08@
QP<FR0<LRP@QS0DWSPH]T0HbTPLhU0PmUPU3V0U9VPY>W0]DWPaJX0aOXPeU
Y0iZYPm`Z0mfZQ1k[161[Q:7/1:</Q>B]1BG]QFM^1FS^QJX_1N^_P026;C0
3lSPf0030000b>3Hb>3H00g8h=P00`0001Rd`1Rd`00?b>3H00<0000H]<0H
]<000XS0^058T8P10000000018S0^<SPf8S0^8S0^0@00803VjOa00Kooooc
X:kd]Kof_<GkfMXc@jD6002001l01H812h@248H35XP378X48H`59hh6;I06
<Y87>9@8?IH9@iP9BIX:CY`;E9h<FZ0<Gj8=IJ@>JZH?L:P?MZX@Nj`APJhB
Qk0BS;8CT[@DUkHEWKPEXkXFZ;`G[[h0=QRd`0:8`;P1B9280@00000000B8
`;S8h=R8`;R8`;PC002001l01H812h@248H35XP378X48H`59hh6;I06<Y87
>9@8?IH9@iP9BIX:CY`;E9h<FZ0<Gj8=IJ@>JZH?L:P?MZX@Nj`APJhBQk0B
S;8CT[@DUkHEWKPEXkXFZ;`G[[h0=QRd`0:8`;P1B9280@00000000>8`;S8
h=R8`;P0JhS0^058T8P1000000000hS0^<SPf8S0^01[R<2h0DR@R0400000
0003R<2hb>3Hb>3H06_8h=P1B9280@000000KhS0^04000000001\
\>"], "Graphics",
  ImageSize->{112, 53},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40002X0000?b000`400?l0
0000o`00003oZ?o`l?000:Sol?3`002Xoo3`l000Z?o`l?000:Sol?3`002X
oo3`l000Z?o`l?000:Sol?3`002Xoo3`l000Z?o`l?000:Sol?3`002Xoo3`
l000Z?o`l?000:Sol?3`002Xoo3`l00000goooooookno_ono_koo?clooWi
nOoemOGol?3`on[Zj_oMg]koc/o@ok^m_on`/kKoZJfa00;oZ:f`00?oYjb_
okFg^On//;<01?nW[:l01?n//;?o]KNiokFg^On//;<4ojN/[`04ojb`/one
]kWo]KNiojb`/`CoYjb_00Co[;2cokFg^One]kWo[;2c1?nW[:l01?n//;?o
]KNiokFg^On//;<4ojN/[`04ojb`/one]kWo]KNiojb`/`CoYjb_00Co[;2c
okFg^One]kWo[;2c0_nW[:l2ojR]/00:ojV]/On`/kKo^kfoolk?d?oMg]ko
j^[Zoo3`l?oemOGonOWiooclo0;oo_kn0_ooool00ond];Coclo?olo?c`1?
olo?c`7oaLG50Ond];@000;okNg]00coj^[ZonOWiooQhN7odm?Col;3`on[
[JooVIfQohZAU_moR93oN8>=ogF2SOmePHd2ogF1S003ogf5SOmfPH_oM82;
00?oM82;00CoMX6;ogf5SOmmQHgoMX6;1?mdP8/01?mfPH_oOHF=ogf5SOmf
PH/4ogB0R`04ogJ1RommQHgoOHF=ogJ1R`CoM82;00CoMX6;ogf5SOmmQHgo
MX6;1?mdP8/01?mfPH_oOHF=ogf5SOmfPH/4ogB0R`05ogJ1RommQHgoOHF=
ogJ1RomdP8/00_mePH`03?mePHgoMH:=ogR3SOmoR93oRY6FoiVMXOn[[Joo
`/?3om?CdooQhN7oinOWon[ZjP;okNg]00?ok^k^okVi^OoMgMd01Oo/k>a6
onk^kPGok>c/0OoMgMd1okVi^@0000coiNGUon;Rh_oNg]kof=SHolW9b_n^
[k3oTiNKogj6S_m_O8OoIWJ3of1bPOmML842oe]^P0;oFFio00?oG6ekoeU^
OomIKWl01?mIKWl2oea]N`KoFFio0_mLKG/6oeU^O`;oG6ek1_mIKWl2oea]
N`KoFFio0_mLKG/6oeU^O`;oG6ek1?mIKWl2oe]^P00;oee`POmPLX7oIWJ3
ofmlQomnQXkoTiNKojj_/?o9bL[of=SHomkNg_oRh^800_oUiND00oni^KWo
hn?SooGem@04ooOgmdKon_[j1OogmoL1on?Sh`7o^KVi00003?o[jn_oinOW
on3Ph?o>cloo/[>dohnDVOmdOhWoHgB3oea]O?mHJ7CoF6E_oeUSK0;oFF9Z
0_mGHFT00omAGV[oE61ZoeMQJ@03oeMQJ@04oeAPJ_mAGV[oDEiZoeAPJPCo
Ef5Y00CoE61Zoe5NJ_mAGV[oE61Z1?mGHFT01?mDH6[oDEiZoe5NJ_mDH6X4
oeMQJ@04oeAPJ_mAGV[oDEiZoeAPJPCoEf5Y00CoE61Zoe5NJ_mAGV[oE61Z
1?mGHFT01?mDH6[oDEiZoe5NJ_mDH6X3oeMQJ@;oFF9Z013oFF=/oeQUKomH
J7CoG6elof=dPomdOhWoSiBIok:c]?o>clooh>3PonOWioo[jn_okNg]okVi
^OoShn?omOGeC_ooool1ooOgm`7ohn?S0Oni^KT0000DooWinOobl_;ogmoP
okjo`?nFVj3oN8>;ofMdOomZMGkoQhfCoj^^/?o;c<goj>SYooKfm_ogmoOo
nOWiooShn?oinOWon_[jooWinOogmoL3ooShn0;onOWi00?on_[jooWinOog
moL00oohn?P2ooWin@03oo[jn_oinOWomoOg00?on?Sh0_oinOT00oojn_[o
nOWiooOgm`03ooShn0;onOWi00?on_[jooWinOogmoL00oohn?P2ooWin@03
oo[jn_oinOWomoOg00?on?Sh0_oinOT05_ojn_[onOWiooShn?oinOWon?Sh
ooOgmooZj^_oc<g>ojb^/On7SI?oJWEnofMdOomhPh_oUY^Pokjo`?oOgn3o
l_;booWinOomoOgo^KVion?ShooemOE>ooooo`7omoOg0OoShn<1okVi^@00
00coi>CTom?Cdond]KKoSiFIog9mQOmSKgWoPhV>ok^m_oo^k^kom_Kfoocl
o?ono_hkooooo`0@ookno_olo?comoOgono_konl_/3oQ8Z?of=_NOmbOHGo
SiFIokBe]_oCdm?oi>CTon[Zj_ni^KWohn?SooGemDkooooo0OogmoL1on?S
h`7o^KVi00002_oBd];o]KJgoi2EV_mcOXKoIg=mohjDUooNg]kojn_[ooCd
m?okno/oooooo`0>oo_knooclo?ok>c/on7QhOnAUY[oIg=mog=nQ_n@UI[o
]KJgom;Bd_oOgmoo^KVion?ShooemOE>ooooo`7omoOg0OoShn<1okVi^@00
00[obLW:oijRY_mhQ8koJ7J1ohbAUOoDe=Coh>3Ponc/k?oemOGooOgm?ooo
ool03_ono_kom_Kfonc/k?oRh^;ofMWIohnDVOmXMX7oN8B>oijRY_o9bL[o
i>CTokVi^OoShn?on_[jC_ooool1oo[jnP7ohn?S0Oni^KT0000;okbo`On?
V:7oKh2?ogn8Soo6a/Koe=CDon3Ph?o/k>col_;booclo?ono_h0?_ooool0
3_ojn_[om?Cdon[Zj_oShn?oemOGolg=cOn2RY7oKh2?ohnHXOnl_l7ojn_[
okVi^OoShn?on_[j0oooool00oofm_Koe]KFono_k`18ooooo`7on_[j0OoS
hn<1okVi^@0000ooW::WogJ6TomYNXOoVifPolK6a_oBd];og=cLonKVi_o/
k>comOGeooShn?ojn_[ooOgmooooooolo?`02?ooool00oomoOgooooooooo
o`05ooooo`06oogmoOoooooooooooooooonb/[;oGEeM0_ooool00oomoOgo
ooooooooo`03ooooo`03ok:b/_mMGEgooOgm00Oooooo00?ooOgmoooooooo
ool01Oooool00oomoOgoooooooooo`02ooooo`0CoogmoOoooooooOgmoo_k
noohn?Som?Cdong]kOoVi^KogmoOomKFe_o<c<coXJ>VofYkR?mfQY?oW::W
olo@d?ni^KWohn?Soo[jnP03ooooo`05ogemOOli>CWo=SHfod51@Onl_;`0
A_ooool1oo[jnP7ohn?S0Oni^KT0000CohVCVom[P9;oMGn8okJf]_o3`l?o
clo?omKFe_oOgmooi^KVon[Zj_o_knoolo?cooCdm?oemOGomoOgooKfm_og
moOom_KfooShn002ooOgm`;om_Kf0_ogmoL01?ofm_Kon?ShooOgmoogmoL2
ooKfmP;omoOg00Com_KfooShn?n/[:coFUYJ0_ofm_H2ooOgm`06ooKfm_oh
n?SomoOgooOgmon[Zj_oFEUI0_ogmoL01?ofm_Kon?ShooOgmoogmoL2ooKf
mP;omoOg00Com_KfooShn?ogmoOomoOg0_ofm_H2ooOgm`0FooKfm_ohn?So
m_KfooOgmoofm_Kom?Cdoo;bl_o`l?3ojn_[onKVi_oQhN7of][Jom?Cdoo9
bLWo_knoogV4S?m[P9;oRI>KokFg^?ni^KWohn?Soo[jnPKooooo00?oRHV9
oa8B4_olo?`0AOooool1oo[jnP7ohn?S0Oni^KT0000;ohFBW?mZPIGoQ8Z?
ok>c/oo0`<3obLW9om?CdooIfMWogMgMon;Rh_oUiND00_oZj^X00oo/k>co
kNg]ong]k@07onk^kP03oo3`l?o^k^kok^k^00Gok^k^00Kol?3`onk^k_o^
k^kok^k^ojJVY_mFEUH2onk^kP03oo3`l?o^k^kok^k^00?ok^k^00?oYZJV
oeIFE_o`l?001oo^k^h00oo`l?3ok^k^onk^kP05onk^kP04oo3`l?o^k^ko
k^k^onk^kP;okNg]0_o/k>`04?oYjNWoi^KVon?ShooPh>3ofm_KomGEeOo=
cLgoaLG5ok^k^on:T9GoJX6EohFBW?na];Oo^KVion?Shoojn_X6ooooo`03
omGEeOl0003oh^;R04Gooooo0Oojn_X1on?Sh`7o^KVi00003On;V:CoJhBI
ohjAU?n/[:co^k^kolK6a_o=cLgodm?ComOGeooKfm_ogmoOon7QhOoRh^80
0_oShn<7onGUi@;oi^KV1_oUiND2onKViP05ohB4Q?m1@D7o@D51obd];OlG
5aL00_m1@D401?m>CTkoiNGUonGUiOn4Q8@2od51@@05obd];OlG5aOo@D51
od51@Om>CTh01?oUiND2onKViPKoiNGU0_oVi^H3onGUi@;oi>CT0_oShn<0
4?oRh^;oh>3PomcLg?oIfMWoe]KFom3@d?o9bLWo`L71okFe]OnGVIcoJhBI
oh^HY?ni_<3o^KVion?Shoojn_X6ooooo`03oginO_lA4A7ooOgm04Gooooo
0Oojn_X1on?Sh`7o^KVi00003On4TYkoJX>Hohn?T?nWYjOo][Jfol30`?o6
a/Koc<c<om7AdOoDe=CoemOGom[Jf_oKfm/00ooLg=`2omkNgP?ogMgM00?o
g]kNomgMgOoMgMd00_oNg]h3omgMg@0;omkNg_oMgMgogMgMol30`?n[Zj_o
ZZZZogIfM_lm?CgoZj^[ojZZZ_n_[jl00_oNg]h02?no_kooZZZZojZZZ_mg
MgOo?CdmojZZZ_n[Zj_o[jn_0ooMgMd00ooNg]kogMgMomgMg@02omkNgP?o
gMgM00?og]kNomgMgOoMgMd00_oNg]h2omgMg@;og=cL017ofm_Kom[Jf_oH
f=Soe]KFom;Bd_o@d=3ob/[:olG5aOnm_Kgo/;2`oi^KW?mZPiSoQ9:Nojfa
]Oni^KWohn?Soo[jnP03ooooo`05ol[:b_m/K6co<C4aobl_;one]KD0A_oo
ool1oo[jnP7ohn?S0Oni^KT0000=oh:?Vom[Q9[oQhR9oijNW_n][Jgo^KVi
ol;2`_o7alOoc<c<om3@d?oBd];oeMGEomKFeP02omOGe`03omSHf?oIfMWo
fMWI017ofMWI00?oUiNGodm?CooIfMT01ooIfMT00onGUiOoCdm?omWIf@0C
omWIf@;of=SH0_oGemL04?oEeMGodm?Com3@d?o>c/kob/[:olG5aOno_koo
]KFeojVYZOnCU9GoJhBJoh:?VonY[:oo^KVion?Shoojn_X3ooooo`03oi^K
Vom2@T;oh>3P04Sooooo0Oojn_X1on?Sh`7o^KVi00003On7UJ7oKhVPogUm
P?nCTi?oXZ:Rojn_[onj^[[o`L71olO7aoo;bl_oc/k>om3@d?oAdM400_oC
dm<3omCDe0;oeMGE00Coe]KFomGEeOoFe]KoeMGD0_oDe=@2omGEe@04omKF
e_oEeMGoe]KFomGEe0;oe=CD00KoeMGEoiBDU?m>CTkoeMGEomKFe_oEeM@2
omCDe0;oeMGE00Coe]KFoiBDU?m>CTkoeMGD0_oDe=@2omGEe@04omKFe_oE
eMGoe]KFomGEe0;oe=CD0_oEeMD01?oFe]KoeMGEomKFe_oEeM@2omCDe0;o
eMGE01?oe=CDom?CdooCdm?odM7Aom3@d?o=cLgob/[:ol?3`onn_[ko][Jf
oj^[ZonMWIgoPXF8ofn9X?n7UJ7o[k>fokVi^OoShn?on_[j00?ooooo00?o
Vi^Kof5QHOooool0B?ooool1oo[jnP7ohn?S0Oni^KT0000BoiBQZomgTJKo
M7Z1ohV9ROnGUiOoYJFUok:b/_no_koobl_;om7AdOoEeMGoemOGomWIfOoJ
f][ofm_Kom[Jf_oKfm_og=cL1ooKfm/00ooLg=cofm_Kom_Kf`05om_Kf`04
omcLg?oKfm_o^KVioi:BTPCofm_K00Kog=cLom_KfooKfm_ofm_KokVi^OnB
TY82om_Kf`03omcLg?oKfm_ofm_K00Gofm_K00?og=cLom_KfooKfm/01OoK
fm/05_oLg=cofm_Kom_KfooKfm_of][JomWIfOoHf=Soe]KFom?Cdoo=cLgo
`/;2okJf]_n/[:coWinOoi2@T?mjP8KoMi6VoiBQZoo3a/Wo^KVion?Shooj
n_X3ooooo`03oi^KVom0@43oZZZZ00;oZZZZA_ooool1oo[jnP7ohn?S0Oni
^KT0000;oiVQZOmjT:;oKgZ4ogYjN_n8R8SoUYJFojZZZ_o4a<CoeMGEom_K
fooNg]h00_oPh>03on;RhP03onCTi?oShn?ohn?S00Gohn?S00?oi>CTon?S
hooShn<01OoShn<00ooTi>Cohn?Son?Sh`05on?Sh`03onCTi?oShn?ohn?S
00Gohn?S00?oi>CTon?ShooShn<01OoShn<00ooTi>Cohn?Son?Sh`05on?S
h`04onCTi?oShn?ohn?Son?Sh`;oh^;R017ohN7Qon3Ph?oOgmoog=cLomOG
eoo5aLGo[:b/oijNW_n@T93oPX:2og9mQomjT:;oVJ6Yol;4aOni^KWohn?S
oo[jnP03ooooo`05okbl_?mCDe?oDe=Coe=CDomEEED0A_ooool1oo[jnP7o
hn?S0Oni^KT0000>ojZ^/On7U:3oM8FCofM[L?mhN7SoQXJ6oinOWoo5aLGo
f=SHomgMgOoOgmoohN7Qon;Rh_oShn<3onCTi0CoiNGU0_oTi>@00ooUiNGo
i>CTonGUi@03onGUi@;oi>CT00?oiNGUonCTi?oUiND00ooUiND2onCTi003
onGUiOoTi>CoiNGU00?oiNGU0_oTi>@00ooUiNGoi>CTonGUi@03onGUi@;o
i>CT00?oiNGUonCTi?oUiND00ooUiND2onCTi004onGUiOoTi>CoiNGUonGU
i@?oi>CT017ohn?Son7QhOoPh>3ogmoOom[Jf_o6a/KoXJ6Qohf=SOn0P83o
L7=hogF6U?n7U:3oZZjaolo@d?ni^KWohn?Soo[jnP1>ooooo`7on_[j0OoS
hn<1okVi^@0000_ocLk>oj2W[On6UJ;oJgV4ofEUIOmcLg?oSHf=ok^k^ooD
e=Cof][JomgMg@02omoOg`03on3Ph?oQhN7ohN7Q00GohN7Q00?oh^;Ron7Q
hOoQhN401OoQhN400ooRh^;ohN7Qon7Qh@05on7Qh@03on;Rh_oQhN7ohN7Q
00GohN7Q00?oh^;Ron7QhOoQhN401OoQhN400ooRh^;ohN7Qon7Qh@05on7Q
h@03on;Rh_oQhN7ohN7Q00KohN7Q017oh>3PomoOgooMgMgog=cLomGEeOni
^KWoSXj>og]kNom^KVkoKW^7ohJEX_nPYjgocLk>onGUiOni^KWohn?SooGe
m@1>ooooo`7omoOg0OoShn<1okVi^@0000comOGeol[=conOZK7oPiNXofQb
NomRHV;oMWIfojBTY?o7alOod];BomGEeOoHf=P2om[JfP?ofm_K1ooLg=`0
0ooKfm_og=cLomcLg005omcLg003om_KfooLg=cog=cL00Gog=cL00?ofm_K
omcLg?oLg=`01OoLg=`00ooKfm_og=cLomcLg005omcLg003om_KfooLg=co
g=cL00Gog=cL01Oofm_KomcLg?oLg=cofm_KomcLg?oKfm_of][JomWIfOoH
f=Sodm?ColG5aOnLW9coMGEeofMWIom[MGgoPiNXoinY/Oo:cLoomOGeookn
o_ni^KWohn?SooGem@1>ooooo`7omoOg0OoShn<1okVi^@0000kokNg]omKG
eonb]KWoSi^Vogb>WOmSKGGoFUYJog]kNonSXj?o_;blolK6a_o;bl_ocLg=
olo?c`;odM7A1OoBd]800ooAdM7od];Bom7Ad@05om;BdP03om7AdOoBd];o
dM7A00God];B00?odM7Aom;Bd_oAdM401OoBd]800ooAdM7od];Bom7Ad@05
om;BdP03om7AdOoBd];odM7A00God];B00?odM7Aom;Bd_oAdM400ooBd]82
om7Ad@0=om3@d?o?clooc<c<olS8b?nk^k_oW9bLog9bL_mKFe_oIVmhogb>
WOn?VjKo/[FiomKGe`02ong]k@03okVi^OoShn?omOGe04kooooo0OogmoL1
on?Sh`7o^KVi00004?oUiNGog]kNolS8bOnW[;3oRiRSogfBXomSLWooF5eQ
ofQXJ?n3Ph?oUiNGoj>SXon/[:co[jn_ok6a/Onb/[82okBd]0;o][Jf0_nd
];@01?ne]KGo][JdokBd]?nd];@2okJf]P;o];Bd00Co]KFeokJf]?nd];Co
];Bd0_nf][H2okBd]004okFe]Onf][Co];BdokBd]0;o][Jf0_nd];@01?ne
]KGo][JdokBd]?nd];@2okJf]P;o];Bd00Co]KFeokJf]?nd];Co];Bd0_nf
][H2okBd]00IokFe]Onf][Co];BdokBd]?nf][Ko/k>cok:b/_nc/k?o[jn_
ojZZZ_nLW9coPX:2of9RH_mIGV;oIWB2ogfBXon;V:?oYjb`olS8bOoNg]ko
iNGUonKVi_ni^KWohn?SooGem@04ooooodKon_[j1?ooool1ooOgm`7ohn?S
0Oni^KT0000Bonk^k_o]kNgoi^KVom3@dOnc][WoUj6ZohJGY_mfRYcoIGF2
oe]TK?mJGV;oGUmPofUYJOmbLW;oM7AdogUiNOmlO7coNg]k0_mmOGd01_ml
O7coNg]kogalO?mmOGcoO7alog]kN`;oOGem00KoO7alog]kNomlO7coOGel
ogalO?mkNg/2ogemO@06ogalO?mkNg_oO7alogemO?mlO7coNg]k0_mmOGd0
1_mlO7coNg]kogalO?mmOGcoO7alog]kN`;oOGem00KoO7alog]kNomlO7co
OGelogalO?mkNg/2ogemO@07ogalO?mkNg_oO7alogemO?mlO7coNg]kogem
O@02ogYjNP0=ogMgMomdM7CoJ6UZoemTIomLIVkoIGF2ogJ;WOn6UjKoUj6Z
ok>f^Oo@d=7oi^KVong]k@02onk^kP03okVi^OoMgMgoj^[Z00Coj^[ZA_o`
l?05on[ZjP7ogMgM0Oni^KT000;ooooo00_oo_knooOgmooXjNWoc<k@okFj
_onLYk7oSYj]oh>K[omoVk;oO9ZcogbI/`03og^I/P03oh6I[OmkVK;oNiVb
00CoNiVb0_n1VJd6og^I/P;oPIV]1_mkVK82oh6I[@KoNiVb0_n1VJd6og^I
/P;oPIV]1_mkVK82oh6I[@GoNiVb00_oO9VcogbJ/omoVk;oPi^_ohjN[OnL
Yk7o]KZoolc>d?oXjNWomoOgooknoP03ooooo`03oiZJV_ni^KWo`/;200Co
`/;2A_o3`l<5ol;2`P7o^KVi0OnJVYX000Cok^k^00OokNg]onKVi_oHfMWo
_/32ojZ`]?nIXj_oTIjX00;oSifY0on>W:P00onLY:_oT9fXohjLZ003ohjL
Z004oi2MZ?nLY:_oW:B[oi2MZ0CoSYbX00CoT9fXoibTZonLY:_oT9fX1?n>
W:P01?n@WJSoW:B[oibTZon@WJP4ohjLZ004oi2MZ?nLY:_oW:B[oi2MZ0Co
SYbX00CoT9fXoibTZonLY:_oT9fX1?n>W:P01?n@WJSoW:B[oibTZon@WJP4
ohjLZ0;oSifY00OoTIjXoiVSZonZ/;Co_/32omSIfOoVi^KokNg]00Gok^k^
00?oJFUYogMgMomkNg/01?mkNg]6ogalO0GoNg]k0OmgMgL1ofUYJ@00Z?mo
Ogl00004on_[jooVi^Koh^;RomkNgPCogMgM0ooNg]h00ooLg=cog]kNomgM
g@02omgMg@2<omkNg_oLg=cog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kN
omgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMko
g]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oM
gMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkN
g_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgM
omkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]ko
gMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oN
g]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgM
gOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kN
omgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgo
g]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oM
gMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkN
g_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMh3omkNgP03omgMgOoNg]ko
g]kN00?ogMgM0OoQhN41onOWi`7oj^[Z00000oo/k>coi^KVon3Ph007omWI
f@04omSHf?oFe]Kodm?Com3@d0?ocLg=00Cod=3@om?CdooGemOof=SH2ooI
fMT01?oHf=SoemOGom?Cdoo@d=03olg=c@04om3@d?oCdm?oemOGomSHf0_o
fMWI00Cof=SHomOGeooCdm?od=3@0oo=cLd01?o@d=3odm?ComOGeooHf=QK
omWIf@03omSHf?oIfMWofMWI00KofMWI0OoNg]h1onKViP7ok>c/00001oo^
k^kojNWYonCTi?oPh>3ohN7Qon3Ph?oRh^800_oQhN403OoNg]kofm_Kom?C
doo7alOo^k^kok:b/_n][Jgo/[:bok^k^oo7alOodm?Com_KfooOgml02OoQ
hN403OoOgmoofm_Kom?Cdoo7alOo^k^kok:b/_n^[Zko/[:bok^k^oo7alOo
dm?Com_KfooOgml02OoQhN403OoOgmoofm_Kom?Cdoo7alOo^k^kok:b/_n^
[Zko/[:bok^k^oo7alOodm?Com_KfooOgml0G?oQhN400ooRh^;ohN7Qon;R
hP04on7Qh@7oi>CT0OoYjNT1ong]k@0000?ol?3`ono_kooalO400oo`l?00
W_o_knool?3`onk^k_oYjNWofm_Kol71`OnTY:CoS8b<ogYjN_mgMgOoNg]k
ohb<S?nTY:Co`/;1om[Jf_oZj^[okNg]oo7alOo_knoolO7aono_kooalNoo
kno_oo7alOo]kNgoj^[Zom[Jf_o2`/;oY:BTohb<RomkNg_oMgMgog]kNon<
S8coY:BTol;2`_oJf][oj^[Xong]kOoalO7okno_oo7alOo_knoolO7aono_
kooalNookNg]on[Zj_oJf][o`/;2ojBTY?n<S8coNg]kogMgM_mkNg_oS8b<
ojBTY?o2`/;of][Jon[Zj_o]kNgolO7_ono_kooalO7okno_oo7alOo_knoo
lO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_
knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7a
lOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_
oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7o
kno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooa
lO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_
kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7a
ono_kooalO7okno_oo7akoo`l?3okno_oo3`l?o_knool?3`ono_koo`l?3o
kno_1?o`l?000003oo;bl_o^k^koinOW00CoiNGU013oi>CTomoOgooAdM7o
/K6aohZ:R_mUIFGoDE5AodE5AOm2@T;oADE5oe5ADOmVIVKoRXZ9ok6a/OoA
dM7og]kN0_oTi>@00ooUiNGoi>CTonGUi002onCTi00?omkNg_oAdM7o/K6a
ohZ:R_mVIVKoDE5AodE5AOm2@T;oADE5oe5ADOmVIVKoRXZ:ok6a/OoAdM3o
g]kN00;oi>CT06koiNGUonCTi?oUiNGoi>CTonCThooNg]kodM7Aok6a/On:
RX[oIVIVoe5ADOm5ADGo@T92odE5AOmADE7oIVIVohZ:R_na/K7odM7AomkN
g_oTi>?oi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGU
onCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>Co
iNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oT
i>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGU
iOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CT
onGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGo
i>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oU
iNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCT
i0CoiNGU00Koi>CTonGUiOoUiNGoiNGUonSXj?o]kNd1oo;blP0000?om?Cd
ong]kOoWinL00_oPh>004ooQhN7ogmoOomkNg_oBd];o];BdohN7QomLG5co
KC/eoii>@_o=KUkojH=_ole_GonMCD?oKC/foeaLG?n7QhOo];Bdom;Bd_oN
g]h01OoPh>004OoNg]kod];BokBd]?n7QhOoG5aLofeP;?nNURkocLdoonWY
COo=cCooWYX_ofeS;OmLG5coQhN7okBd]?oBd];og]kN00Goh>3P017og]kN
om;Bd_nd];CoQhN7oeaLG?m7IbkoJ9hcoi7=AonZjEGoTLe7ofZN=?m9JRoo
G5aLohN7Qond];Cod];BomkNgP1Hon3Ph003omoOgooPh>3ogmoO00;ogmoO
0ooPh>000ooQhN7oinOWonc/k001ooCdm00000?om_Kfoo;bl_o[jn/00ooX
j>P04ooWinOoh^;Rolg=cOnOWiooJUiNohlf;_o/L67onIf@oofaYOom_:oo
oKBWooVOToo]M6?oTSL_of]OGonOWioocLg=on;Rh_oWinL00ooXj>P04ooW
inOoh^;Rolg=cOnOWiooKVIOoi=b8_o]dDConO=doogmSOomoIGooOf>ooWh
M_o]edOoTg<RofiWGonOWioocLg=on;Rh_oWinL00ooXj>P04ooWinOoh^;R
olg=cOnOWiooH6QOod]l8onBhD_o_OUkom3mT_oHoI_oe?fEol3iO_nHj4go
CH0Tof1YGonOWioocLg=on;Rh_oWinL0H?oXj>P1onc/k07ol_;b0Oofm_H0
0003ooOgmoohn?Son?Sh00?on?Sh01?omoOgonk^k_o>c/koT92@ohD_:ooY
I5Koni:7oojVVoon/JGookNZoojcY_onZ9conYB9oniXFOn9<B_oT92@olk>
c_o^k^komoOg00?on?Sh01?omoOgonk^k_o>c/koT92@oiUY:oo`_Cgonn1^
ookdP_onoX[ooonBooknS?onn8?onnE`oo32?_nIJR_oT92@olk>c_o^k^ko
moOg00?on?Sh01?omoOgonk^k_o>c/koT92@od9c:on4cT?o[Nmcol;nR?o>
oY3oe_nGom3nT_o6oXWo/_EdohSC@om4MB_oT92@olk>c_o^k^komoOg05Wo
n?Sh00?omoOgooShn?ohn?P00_ohn?P01?ogmoOonOWiooOgmoogmoL1ooSh
n00000?on_[jooGemOo^k^h00_o/k>`0Uoo[jn_ojNWYomoOgonj^[[oN59B
oklb9?oVLfSooHUnoonGRoonXYKoojRLoojTV?ooVXgooXYoonifJ_o3<bCo
NE9BokZj^_oOgmooj^[Zon_[joo/k>cojn_/on[Zj_oOgmoo^[ZjohQUD_oR
TAconL=@oogJHooojW;oo_=nooojP_onmWooonacookNI?ojae7ohY8LohUV
Donj^[[ogmoOon[Zj_o[jn_ok>c/on_[jooZj^[ogmoOokZj^_mBKE;oDJ<L
oi7BEOnVif[o^?Ujol3nP_o7ohWo`oj4okWmNonWk6coU=IGoe:V7?mBKE;o
^[ZjomoOgooZj^[ojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[
jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/
k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/
onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>co
jn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/
k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[
joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/
on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jn`0
1_o[jn/01Oo/k>cojn_[on_[joo^k^kom_Kf007onOWi00000ookno_olo?c
ong]k@02onGUi@2GonKVi_oTi>CofMWIok:b/_mi;Rkob48con=ZG?odNVgo
oHQloojGR_onVhkooYR;ooj:O_odNfgoif]MolY2=?mk;Rko/[:bomSHf?oT
i>CoiNGUonKVi_oUiNKoi>CTomSHf?nb/[;oUUD^onZL:ook_4Coo/aCoogH
H_onhg;oo^UeookVLoonffGooLaCoo_1AOo^WR_oVEH^ok:b/_oHf=Soi>CT
onGUiOoVi^KoiNGUonCTi?oHf=Wo/[:bobiR;_mS[B_oQlY8oiOLFOnUiFWo
/_=gokSfNondmGWoYnY[oiSLFOn9cd_oHjh[obiS;_nb/[;of=SIonCTi?oU
iNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKV
i_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGV
onKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^Ko
iNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoV
i^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGU
iOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KV
onGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKo
i^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUiP02onKViP03onGUiOoV
i^Koi^KV00?oi^KV00?oiNGUong]kOodm?@00Oojn_X00003ooclo?ohn?So
lO7a00?ok^k^01?ojn_[on7QhOnl_;coNQLGol<o<_oCETWoi6QJonmgK?od
PgWomhMlooF4N_ocNFgoiFUKomUHB_o4?c;oO1LGokbl_?oQhN7ok>c/00?o
k^k^01?ok>c/on7QhOnl_;coYDLGonJG<_oe[33ooKa1oog9Doomd63onm=U
oogBH?oncECooKe2ooZ_<_oYVc;oYDHGokbl_?oQhN7ok>c/00?ok^k^01?o
k>c/on7QhOnl_;co5eTGoenX<_mf_COoQ/e7oiKFF_nRh6GoXn1Yoj?QIonG
fUcoQ/i7ogNo=omOZc;o5eTGokbl_?oQhN7ok>c/05ook^k^00?okNg]oo;b
l_ohn?P00Oolo?`000?ooOgm01Koo?cloogmoOomoOgoo?cloo?clooAdM7o
J0L7okPd=?o7?c?odU13omYREOoSKV;oi79TonA_H_oLI5Oode53ola1=?ni
=3CoJ`L7om;Bd_oclo?oo?cl0oomoOd04oolo?colo?com;Bd_nN:`OofXXd
on^K6OoeZ2Won;@oooVmB_oh_dgon[m:ooVh?oofZR[okihIom^;=?nR;@Oo
d];Boo?cloolo?`00oomoOd04oolo?colo?com;Bd_l7@0OoCIXdoen[8?m`
^2ooOl=3oh[=D?n=cE;oR/i@oh77A?ma^BooHZhPodjK=?l7@POod];Boo?c
loolo?`0GOomoOd00oolo?cooOgmooclo003oogmo@0003[ooOgmoo[jn_oc
lo?ok^k^oo3`l?o_knook^k^onWYjOoCdm?oFQ`Loj8d=?nd:1go`CT/olM9
??o?ET[od5M;om1GB_o:BSko`c/^okHX7OnR=3CoG1dMom?CdooZj^[ok^k^
oo3`l?o_knool?3_onk^k_oZj^[odm?Coh`U7Oo8LCCofH@MonBD5OoWWBCo
kZPcoo2Z=?o_ZS?ok:0UonNG5OoLR1gob74doh`U7OoCdm?oj^[Zonk^k_o`
l?3okno_oo3`l?o^k^koj^[Yom?CdolM>1go=88dodNE7OmJYA_oJJdZ0_md
^3P0HOme^CSoJk4[oe^W7?m8VQgo=88doadh7OoCdm?oj^[Yonk^k_o`l?3o
kno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`
l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_
koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`
ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knoo
l?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_
knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`
l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_
oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knl00_o`l?06ono_k`7o
lo?c0OoinOT1ooknoP0000?oo_knooOgmoo`l?001?oYjNT04OoWinOofm_K
of=;Bon1<S;oYSDeokHd;Oo2CD7o`eA9olAEB_o3E4Wo`Te1okHd;OnU=CGo
PC8bof=;BooKfm_oinOW00GojNWY017oinOWom_Kfon9Bd_o[d/boleg=OoF
Rbgoh9`^on2P<_oQX3Coh:0bomnJ;_oFRbgobWDeojm;<_n9Bd_ofm_KonOW
i`05onWYj@0AonOWiooKfm_oBd];oc9P<_ljRCGoDi/]of^[;om`[CSoKjhj
og2]>?mZZRooDi/]ocV8=OlbH3;oBd];om_KfooWinL0F_oYjNT00ooXj>So
jNWYonWYj@04onWYj@7ol?3`0OogmoL1ooknoP0000Goo_knoo[jn_odm?Co
kno_oo7al@02oo3`l00Aono_koo[jn_oUIBDodlS8onEE5Co^g=com>EUOoJ
W9cofYjLomVLW?oDUIGo^g=coiEDE?m?8b?oUIBDon[Zj_o_knl01Oo`l?00
4Oo_knooj^[ZojVDU?n18b?o^VYDomBJLooT_9Goj/NLonW7W?oZaicoiKbE
omBJLonkJUCoPB<SojZDU?oZj^[okno_00Gol?3`017okno_on[Zj_nDU9Co
8bXSoeAjE?mcYG?oW/JEojc>W?n]cYco[<jLoik6UOmcYG?oE7YDob<Z8onD
U9Coj^[Zono_k`1Ooo3`l004oo7alOo`l?3om?Cdoo[jnP7oo_kn00001?o/
k_3oooooooooooono_h2ooooo`;oo_kn09OooOgmooShn?m^KVkoFSlook6@
T?oNbLWol>CToo?Vi_o`i>Cog/W9ok6@T?mJ?cooKFe]ooShn?olo?cooooo
ookno_ooooooo_knooooo_ono_koooooooclo?ohn?SoSFe]ohXo?oo9TI3o
jM39ooCYi?ofjnKom>WTonW@bOo9TI3oRCloohe]KOohn?Ooo?clooooooon
o_koooooookno_ooooooo_knooooo_olo?con?Shofe]KOlo?cooT9f@olWE
bOoTk>Coi^kVonC/i?o9eLWoT9f@oclo?om]KFgon?Shooclo?ooookoo_kn
ooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_oooooo
o_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_oo
ookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookn
o_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_kooooo
ookno_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_ko
ooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooon
o_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knoooo
o_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_kn
00;ooooo00?oo_knooooooooool00oooool1onc^l00000Co`LS>ookno_oj
n_[om?Cd1OoalO403Oo_knooe]KFof][Jom3?CgoVhb<olJj^_oFc<coakZj
oi^<S?m3?CgoJf][omKFe_o_knl02OoalO403Oo_knooemKFoh=[Jomd?Cgo
]Hb<omFj^_oQc<coe[ZjokJ<S?mb?CgoPF][omOFe_o_knl02OoalO403Oo_
knooe]KFof][Jolm?CgoS8b<okZj^_o<cLco^[Zjohb<S?lm?CgoJf][omKF
e_o_knl0F_oalO401?o`l?3olO7aoo7alOo`l?04oo7al@03ooCdm?ojn_[o
o_kn007o_lG;00001On4SiWooOgmooShn?o`l?3ojn_[00?oj^[Z00gojNWY
on[Zj_oYjNWoj>SXoi^KVomIFEWo9RHVo`T92OlV9RKoFEUIoi^KVooXj>So
jNWY00_oj^[Z00_ojNWYonSXj?nPVi_oJUUIod<V9_l]2@Wo@RHVofUIFOnP
Vi_oj>SXonWYj@0;on[ZjP0;onWYjOoXj>SoVi^KoeUIFOlV9RKo2@T9obHV
9_mIFEWoVi^KonSXj?oYjNT0H_oZj^X01?o[jn_ol?3`ooOgmoomoOd1ogn9
U00000Co=TIAokS0aOoinOWom?Cd2?oalO42oo3`l0?okno_0_o`l?0?oo7a
l@;ol?3`0oo_knl2oo3`l0oolO7a0_o`l?03ono_k`;ol?3`H?oalO400oo`
l?3olO7aoo7al@02oo7al@03ooGemOojn_[o]Kc3007o;ci<00000olM;coo
C5USokVoa@2Rooooo`7o][c10Om7Del1oaHX=`0000Ko72hmoaXY=Olb?4Ko
OXR@okg3b?o[k>jLooooo`05on[[kOnk`<GoNH>;obdh@olE8bl00OlH:CL0
0001\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{168, 63},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[BoxData[
    StyleBox[
      ButtonBox["SimpleMathJFrame",
        ButtonData:>{"SimpleMathJFrame.nb", None},
        ButtonStyle->"Hyperlink"],
      FontWeight->"Bold"]], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(SimpleMathJFrame[]\)], "Input"],

Cell[BoxData[
    \("Final value was 5."\)], "Print"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[">>> javax.swing.JLayeredPane, JInternalFrame <<<",
  FontColor->GrayLevel[0.500008]]], "Section"],

Cell[CellGroupData[{

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:00001h1P00`40o`00
0?l0003oo`000?l00022000000000hS0^4R@R4R@R03oB928odR@R7i8T8P1
000000000hS0^<SPf8S0^03oR<2hohS0^7f8`;P1B9280@00000000>8`;S8
h=R8`;P0ohS0^?n8`;QmR<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<
c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<
N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Qnc<c<aVIVVOo<c<`ec<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^7g<c<`?IVJI[9VIc0eVIYWoc<c<=<c<c0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;Qmc<c<3VIVVJ`0000>IVJIolc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2hOLc<c<QVIYWoc<c<=<c<c0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;Qmc<c<b6IVVOo<c<`dc<c<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^7g<c<`5IVJI_/c<c0EVIYWoc<c<=<c<c0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;Qmc<c<1FIVVKk<c<`5IVJIolc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hOLc<c0EVIYVnc<c<1FIVVOo<
c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^7g<c<`5IVJI_/c<
c0EVIYWoc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Qmc<c<
1FIVVKk<c<`5IVJIolc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hOLc<c0EVIYVnc<c<1FIVVOo<c<`dc<c<0XS0^058T8P10000000018S0
^<SPf8S0^8S0^7g<c<`5IVJI_/c<c0EVIYWoc<c<=<c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Qmc<c<1FIVVKk<c<`5IVJIolc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2hOLc<c0=VIYT00iVIc6IVVLc<c02m
c<c<0fIVV@03VIW<IVJIc<c<0?o<c<`cc<c<0XS0^058T8P10000000018S0
^<SPf8S0^8S0^7g<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VI
c6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Qmc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hOLc<c09VIYT00`0009VIc6IV
V@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^7g<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`00
09VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Qm
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hOLc<c09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^7g<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT0
0`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Qmc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<
c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hOLc<c09VIYT00`00
09VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^7g<c<`2IVJI00<0002IVLaVIYT0_/c<c09V
IYT00`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;Qmc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hILc<c1YVIYT0
0`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^6C<c<`?IVJI2YVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^6C<c<`>IVJI2`00009VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0
^<SPf8S0^8S0^6C<c<`KIVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VI
c6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;QTc<c<
6fIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<c0EVIYTDc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2hI<c<c0EVIYTDc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2hI<c<c0EVIYTDc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2hI<c<c0EVIYTDc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hI<c<c0EVIYTDc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<
c0EVIYTDc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<c0EVIYTD
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<c0EVIYTDc<c<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2hI<c<c0=VIYT00iVIc6IVVLc<c00C
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hI<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2hI<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2hI<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2hI<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<
c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
I<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2hC<c<c1YVIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hBlc<c0mVIYT:VIW<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@3oc<c<=<c<c0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;c<c<3VIVV@/00002IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<
IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^4_<c<`K
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^4_<c<`KIVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^4_<c<`5IVJI5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2hBlc<c0EVIYTDc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@3o
c<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;c<c<1FIVVAC<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^4_<c<`5IVJI5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hBlc<c0EVIYTDc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@3oc<c<
=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;c<c<1FIVVAC<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^4_<c<`5IVJI5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2hBlc<c0EVIYTDc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@3oc<c<=<c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;c<c<0fIVV@03VIW<IVJI
c<c<01?<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0
^<SPf8S0^8S0^4_<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hBlc<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT0_/c<c09VIYT00`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;Q;c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^4_<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2hBlc<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09V
IYT00`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;Q;c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`d
c<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^4_<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hBlc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IV
V@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;c<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^4_<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
Blc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@3oc<c<=<c<c0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;Pcc<c<6VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^3;<c<`?IVJI2YVIc09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VI
c6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Pbc<c<
3VIVV@/00002IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h</c<c1]VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
_/c<c09VIYT00`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8
`;S8h=R8`;R8`;Pbc<c<6fIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^3;<c<`5IVJI
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@3oc<c<=<c<c0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;Pbc<c<1FIVVAC<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h</c<c0EVIYTDc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^3;<c<`5IVJI5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IV
V@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Pbc<c<1FIV
VAC<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h</c<c0EVIYTDc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^3;<c<`5IVJI5<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09V
IYT00`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;Pbc<c<1FIVVAC<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h</c<c0=V
IYT00iVIc6IVVLc<c00Cc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<
IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^3;<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VI
c6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Pbc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h</c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^3;<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`00
09VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Pb
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
</c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^3;<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09VIYT0
0`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;Pbc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h</c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^3;<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<c09V
IYT00`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;Pbc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6/c<c1YVIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^1W<c<`?IVJI2YVIc09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^1W<c<`>IVJI2`00009VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0
^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`KIVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@3oc<c<=<c<c0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<6fIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c0EVIYTDc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c0EVIYTD
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c0EVIYTDc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c0EVIYTDc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c0EVIYTDc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c0EVIYTDc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c0EVIYTD
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c0EVIYTDc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c0=VIYT00iVIc6IVVLc<c00Cc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<
c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<
c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<
c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<
c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<
c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<
c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002I
VLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<
c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0olc<c3C<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI0<1VIYT00`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<o`9VIYT00`0009VI
c6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT0_/c<o`9VIYT00`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0_/c<o`9VIYT00`0009VIc6IV
V@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT01Lc<o`03ooooR8R8A4A400I4A4@00c<c<dA4A4A4A003A4A400>IVIW<
c?o<c?l0BLc<o`05IVJIc<coc<coc<coIVJI00?<c?l01FIVVLc<olc<olc<
ofIVV@03c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`03IVJIc<coc<co04?<
c?l2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI00G<c?l00oooodA4A6IVIP03MgMg00=VIVIg
MgMgMgL01GMgM`03<c<cc<c<c<co01W<c?l400004/c<o`<0000Gc<co00Go
ooo<c?o<c?o<c?ooool00lc<o`05ooooc<coc<coc<cooooo00?<c?l01Ooo
olc<olc<olc<ooooo`03c<co00?oooo<c?o<c?l01/c<o`Ooool;c<co2_oo
oa3<c?l>oooo1<c<o`9VIYT00`0009VIc6IVV@3oc<c<=<c<c0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT01Lc<o`0<oooo<c<ck^k^
k^k^^k^kMgMgZZZZooook^k^gMgMMgMggMgM0^k^kP03MgMgc<c<c<co01S<
c?l010000<c<olc<olc<o`80000Cc<co0P0001G<c?l01FIVVLc<olc<olc<
ofIVV@03c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`05IVJIc<coc<coc<co
IVJI00?<c?l00fIVVLc<olc<o`06c<co00<0001VIYUVIYT016IVV@03oooo
c<coc<co00S<c?l00`0006IVVFIVV@07IVJI00?oooo<c?o<c?l03Lc<o`03
0000IVJIIVJI00]VIYT00oooolc<olc<o`02c<co0VIVV@030000VIW<IVJI
0?o<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@05c<co00Kooolc<c?oooo^k^igMgL0<l`2<c<000Q4A4@c03<0029V06Ig
MgOooomgMgNk^k/5c<co1@0000?<c?l200001<c<o`D00002c<co0P000003
c<co0000000000C<c?l600000/c<o`D00002c<co0`0000?<c?l400000/c<
o`800008c<co00Goooo<c?o<c?o<c?ooool00lc<o`05ooooc<coc<coc<co
oooo00?<c?l01Oooolc<olc<olc<ooooo`03c<co00?oooo<c?o<c?l01lc<
o`030000IVJIIVJI00<000000fIVVOooolc<o`09c<co00<0001VIYUVIYT0
0VIVV@@000000fIVVOooolc<o`0>c<co00<0001VIYUVIYT02P000003IVJI
ooooc<co00?<c?l2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI00G<c?l04?ooogMgMnk^k^k^
kVIVIP1Vo`1Vc4A4A3<0<c<c<gMgMc<0<hR8R>k^kVIVI/c<c0G<c?l20000
0/c<o`800002c<co0P0000?<c?l200000/c<o`8000001<c<o`0000000<c<
o`<00004c<co0P0000G<c?l200000/c<o`800002c<co0`0000;<c?l20000
0/c<o`8000000lc<o`000000000;c<co00EVIYW<c?o<c?o<c?mVIYT00lc<
o`05IVJIc<coc<coc<coIVJI00?<c?l01FIVVLc<olc<olc<ofIVV@03c<co
00=VIYW<c?o<c?l01<c<o`030000IVJIoooo00;<c?l00`0006IVVOooo`0:
c<co00D0001VIYUVIYUVIYWoool00lc<o`030000IVJIoooo00o<c?l00`00
06IVVLc<o`07c<co00Goooo<c?l0001VIYWoool01<c<o`9VIYT00`0009VI
c6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT01Lc<o`05oooo<c<ck^k^gMgM4A4A0080I_l02C=Vc28R8XR8R9VI
VB8R8]gMgNk^kWMgMlc<c005c<co0P0000?<c?l2000000?<c?l000000000
0lc<o`800002c<co0P000003c<co0000000000;<c?l200001<c<o`800005
c<co0P0000;<c?l2000000C<c?l00000003<c?l2000000?<c?l000000000
1Lc<o`80000:c<co00Goooo<c?o<c?o<c?ooool00lc<o`05ooooc<coc<co
c<cooooo00?<c?l01Oooolc<olc<olc<ooooo`03c<co00?oooo<c?o<c?l0
1Lc<o`030000IVJIoooo00;<c?l00`0006IVVOooo`0:c<co00<0001VIYT0
00000VIVV@06ooooc<coc<co0000IVJIoooo3lc<o`060000IVJIc<coc<co
IVJIoooo0lc<o`06IVJIoooooooo0000IVJIoooo1<c<o`9VIYT00`0009VI
c6IVV@3oc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT01Lc<o`06oooo<c<ck^k^<c<c<`0c000A0R8R8P0803<c<`0c4@00
0000<c<c^k^kMgMg^k^k1Lc<o`800003c<co0P000003c<co0000000000C<
c?l2000000C<c?l00000003<c?l200000/c<o`800004c<co0P0000K<c?l2
000000C<c?l00000003<c?l2000000C<c?l00000003<c?l6000000?<c?l0
000000002Lc<o`05IVJIc<coc<coc<coIVJI00?<c?l01FIVVLc<olc<olc<
ofIVV@03c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`03IVJIc<coc<co00K<
c?l00`0006IVVOooo`02oooo0VIVV@03ooooc<coc<co00S<c?l0100006IV
VOooo`00009VIYT01Oooolc<o`0006IVVOooo`0?c<co00@0001VIYW<c?l0
0002IVJI0_ooo`=VIYT01<c<o`0006IVVOooo`C<c?l2IVJI00<0002IVLaV
IYT0olc<c3C<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI00G<c?l04?ooogMgMfHcIVHcIWMgMhR8R6IVIS<c000cc01Vc3<0IP00
06HcIS<c<gMgMlc<c0G<c?l200000lc<o`8000000lc<o`0000000005c<co
10000003c<co0000000000;<c?l200001<c<o`800007c<co10000004c<co
00000000c<co0P000003c<co0000000000;<c?l2000000?<c?l000000000
2<c<o`05ooooc<coc<coc<cooooo00?<c?l01Oooolc<olc<olc<ooooo`03
c<co00Goooo<c?o<c?o<c?ooool00lc<o`03ooooc<coc<co00O<c?l00`00
06IVVFIVV@04IVJI2lc<o`050000IVJIooooc<co0000009VIYT01?ooofIV
VFIVVOooo`o<c?l01@0006IVVLc<olc<o`000005IVJI0/c<o`030000IVJI
oooo00C<c?l2IVJI00<0002IVLaVIYT0olc<c3C<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI00G<c?l02OooodA4A3<0<l`0c6Hc
IVIVIQ4009UV0<bI000206K<0YT0V@03^k^kMgMgc<c<00G<c?l200000lc<
o`8000000lc<o`0000000003c<co00@0003<c?o<c?o<c?l2000000C<c?l0
0000003<c?l300001<c<o`800005c<co00@0003<c?o<c?o<c?l400000lc<
o`@00002c<co0P000003c<co0000000000_<c?l01FIVVLc<olc<olc<ofIV
V@03c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`05IVJIc<coc<coc<coIVJI
00?<c?l00fIVVLc<olc<o`04c<co1`000003c<cooooooooo00Coool4c<co
00<0001VIYWoool00/c<o`030000IVJIIVJI009VIYT00oooolc<olc<o`0=
c<co00<0001VIYW<c?l00/c<o`050000IVJIIVJIIVJIoooo00;<c?l00`00
06IVVOooo`04c<co0VIVV@030000VIW<IVJI0?o<c<`dc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0006IVVFIVV@05c<co00Cooolc<c?<c<a4
A4@2000000Xc03=VIP3oc02IIP1V06K<0?mV06IV<fIgMgNk^k/5c<co0P00
00?<c?l2000000?<c?l0000000000P0000;<c?l400000lc<o`8000000lc<
o`0000000004c<co0P0000K<c?l4000000?<c?l0000000000lc<o`800000
0lc<o`000000000200000/c<o`@00008c<co00Goooo<c?o<c?o<c?ooool0
0lc<o`05ooooc<coc<coc<cooooo00?<c?l01Oooolc<olc<olc<ooooo`03
c<co00?oooo<c?o<c?l03<c<o`030000IVJIIVJI00=VIYT00oooolc<olc<
o`02c<co00<0001VIYWoool00oooo`050000IVJIIVJIIVJIoooo00;<c?l2
oooo2lc<o`030000IVJIc<co00;<c?l4IVJI00Koooo<c?o<c?l0001VIYWo
ool4c<co0VIVV@030000IVJIIVJI0?o<c<`dc<c<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c0EVIYT5c<co00OooomgMgO^k^k^k^hR8R:I09UV<fH00VH0IP07
<`0cVFH04A4Ac<c<k^k^MgMgc<c<00G<c?l200000/c<o`80000Hc<co0P00
02C<c?l01FIVVLc<olc<olc<ofIVV@03c<co00EVIYW<c?o<c?o<c?mVIYT0
0lc<o`05IVJIc<coc<coc<coIVJI00?<c?l00fIVVLc<olc<o`0=c<co00@0
001VIYUVIYUVIYT200001Lc<o`030000IVJIIVJI00MVIYT2oooo0VIVV@03
ooooc<coc<co00W<c?l0100006IVVLc<olc<o`=VIYT0200006IVVFIVVOoo
olc<o`0006IVVOooo`C<c?l5IVJIolc<c3C<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<1FIVV@G<c?l01_ooodA4A>k^kYVIVA4A4DA4A0;<0<`019T0V@0c
I/bI07MgM`;^k^h00gMgMlc<c<c<o`04c<co1@0001W<c?l200008lc<o`05
ooooc<coc<coc<cooooo00?<c?l01Oooolc<olc<olc<ooooo`03c<co00Go
ooo<c?o<c?o<c?ooool00lc<o`03ooooc<coc<co00k<c?l01@0006IVVFIV
VFIVVOooo`06c<co2@00009VIYT01?ooofIVVFIVVOooo`_<c?l0100006IV
VLc<o`00009VIYT2c<co00L0001VIYUVIYW<c?l0001VIYWoool01<c<o`EV
IYWoc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`5IVJI1Lc<o`09oooo
<c<ck^k^MgMg<c<cIVIV<c<cc03<A4A40080<fH01GMgMnk^k^k^kWMgMk^k
^`1;c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`05IVJIc<coc<coc<coIVJI
00?<c?l01FIVVLc<olc<olc<ofIVV@03c<co00=VIYW<c?o<c?l02lc<o`03
0000IVJI0000009VIYT00oooolc<olc<o`0<c<co00<0001VIYUVIYT00VIV
V@03ooooc<coc<co00W<c?l01@0006IVVLc<olc<o`000004c<co00H0003<
c?o<c?l0001VIYWoool4c<co1FIVVOo<c<`dc<c<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c0EVIYT5c<co00?ooomgMgO^k^h00nk^kP06^k^kIS=Vooook^k^
VIVIR8R80^k^kP03MgMgc<c<c<co04W<c?l01Oooolc<olc<olc<ooooo`03
c<co00Goooo<c?o<c?o<c?ooool00lc<o`05ooooc<coc<coc<cooooo00?<
c?l00oooolc<olc<o`0<c<co00@0001VIYWoool00002IVJI00?oooo<c?o<
c?l02lc<o`03oooo0000IVJI009VIYT00oooolc<olc<o`09c<co00<0001V
IYW<c?l02Lc<o`9VIYT00oooolc<olc<o`02c<co1FIVVOo<c<`dc<c<0XS0
^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0002IVLaVIYT05<c<c0EVIYT5c<co00?ooolc<c?oool02nk^kP03
MgMgc<c<c<co04S<c?l01FIVVLc<olc<olc<ofIVV@03c<co00EVIYW<c?o<
c?o<c?mVIYT00lc<o`05IVJIc<coc<coc<coIVJI00?<c?l00fIVVLc<olc<
o`0=c<co0P0000;<c?l00`0006IVVFIVV@0<c<co00<0001VIYUVIYT00fIV
V@03ooooc<coc<co00W<c?l00`0006IVVFIVV@0;IVJI00?oooo<c?o<c?l0
0/c<o`EVIYWoc<c<=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PI
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`5IVJI1Lc<
o`03oooo<c<cMgMg00agMgL00oooolc<olc<o`16c<co00Goooo<c?o<c?o<
c?ooool00lc<o`05ooooc<coc<coc<cooooo00?<c?l01Oooolc<olc<olc<
ooooo`03c<co00?oooo<c?o<c?l04lc<o`030000c<coc<co00_<c?l60000
3<c<o`h00005c<co1FIVVOo<c<`dc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c0EVIYVnc<co1FIVVOo<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c0EV
IYVnc<co1FIVVOo<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c0IVIYVl
c<co1VIVVOo<c<`dc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c<QVIYWoc<c<
=<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`?IVJI[9VIc0eVIYWoc<c<=<c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI029VIYV/00003VIVVOo<c<`dc<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<olQVIYWoc<c<=<c<c0:8`;P1B9280@00000000B8
`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI
01C<c?l00lc<c6IVVFIVV@34IVJIolc<c3G<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000
VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IV
V@2nc<co0VIVV@030000VIW<IVJI0?o<c<a=c<c<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT01Lc<o`03ooooR8R8A4A400I4A4@00c<c<dA4A4A4A003A4A400>IVIW<
c?o<c?l0D/c<o`05IVJIc<coc<coc<coIVJI00?<c?l01FIVVLc<olc<olc<
ofIVV@18c<co0VIVV@030000VIW<IVJI0?o<c<a=c<c<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT01Lc<o`03ooooA4A4IVIV00=gMgL00fIVIWMgMgMgM`05MgMg00<c
<c?<c<c<c?l04lc<o`80000<c<co0P0001G<c?l300005lc<o`05ooooc<co
c<coc<cooooo00?<c?l01Oooolc<olc<olc<ooooo`0;c<co1oooo`_<c?l:
oooo4<c<o`koool4c<co0VIVV@030000VIW<IVJI0?o<c<a=c<c<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT01Lc<o`0<oooo<c<ck^k^k^k^^k^kMgMgZZZZooook^k^
gMgMMgMggMgM0^k^kP03MgMgc<c<c<co01?<c?l200003<c<o`80000Gc<co
0P0001G<c?l01FIVVLc<olc<olc<ofIVV@03c<co00EVIYW<c?o<c?o<c?mV
IYT00lc<o`03IVJIc<coc<co00G<c?l00`0006IVVFIVV@04IVJI00?oooo<
c?o<c?l02<c<o`030000IVJIIVJI00MVIYT00oooolc<olc<o`0=c<co00<0
001VIYUVIYT02fIVV@03ooooc<coc<co00;<c?l2IVJI00<0002IVLaVIYT0
olc<c4g<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@05c<co00Kooolc<c?oooo^k^ig
MgL0<l`2<c<000Q4A4@c03<0029V06IgMgOooomgMgNk^k/5c<co0P0000O<
c?l400000/c<o`8000000lc<o`0000000003c<co0P000004c<co00000000
c<co0P000003c<co0000000000G<c?l600000/c<o`D00002c<co0`0000?<
c?l400000/c<o`800008c<co00Goooo<c?o<c?o<c?ooool00lc<o`05oooo
c<coc<coc<cooooo00?<c?l00oooolc<olc<o`06c<co00<0001VIYUVIYT0
0`000003IVJIooooc<co00W<c?l00`0006IVVFIVV@02IVJI10000003IVJI
ooooc<co00k<c?l00`0006IVVFIVV@0:000000=VIYWoooo<c?l00lc<o`9V
IYT00`0009VIc6IVV@3oc<c<CLc<c0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI00G<c?l0
4?ooogMgMnk^k^k^kVIVIP1Vo`1Vc4A4A3<0<c<c<gMgMc<0<hR8R>k^kVIV
I/c<c0G<c?l200001/c<o`800002c<co0P000005c<co000000000000c<co
008000001<c<o`0000000<c<o`<000001Lc<o`00000000000<c<o`020000
1<c<o`800005c<co0P0000;<c?l200000/c<o`<00002c<co0P0000;<c?l2
000000?<c?l0000000002lc<o`05IVJIc<coc<coc<coIVJI00?<c?l01FIV
VLc<olc<olc<ofIVV@09c<co00<0001VIYWoool00/c<o`030000IVJIoooo
00[<c?l01@0006IVVFIVVFIVVOooo`03c<co00<0001VIYWoool03lc<o`03
0000IVJIc<co00O<c?l01Oooolc<o`0006IVVOooo`04c<co0VIVV@030000
VIW<IVJI0?o<c<a=c<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT01Lc<o`05oooo<c<c
k^k^gMgM4A4A0080I_l02C=Vc28R8XR8R9VIVB8R8]gMgNk^kWMgMlc<c005
c<co0P0000K<c?l200000/c<o`8000000lc<o`0000000002c<co0P000003
c<co0000000000;<c?l2000000?<c?l0000000000/c<o`800004c<co0P00
00G<c?l200000/c<o`8000001<c<o`0000000<c<o`8000000lc<o`000000
0005c<co0P0000[<c?l01Oooolc<olc<olc<ooooo`03c<co00Goooo<c?o<
c?o<c?ooool02/c<o`030000IVJIoooo00;<c?l00`0006IVVOooo`0:c<co
00<0001VIYT000000VIVV@06ooooc<coc<co0000IVJIoooo3lc<o`060000
IVJIc<coc<coIVJIoooo0lc<o`06IVJIoooooooo0000IVJIoooo1<c<o`9V
IYT00`0009VIc6IVV@3oc<c<CLc<c0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI00G<c?l0
1_oooc<c<nk^kS<c<c<0<`004@8R8R80200c<c<0<a40000003<c<k^k^gMg
Mk^k^`G<c?l600000/c<o`800002c<co0P000003c<co0000000000;<c?l2
000000?<c?l0000000000/c<o`8000000lc<o`0000000002c<co0P0000C<
c?l200001/c<o`8000001<c<o`0000000<c<o`8000001<c<o`0000000<c<
o`H000000lc<o`0000000009c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`05
IVJIc<coc<coc<coIVJI00?<c?l00fIVVLc<olc<o`05c<co00<0001VIYWo
ool00_ooo`9VIYT00oooolc<olc<o`08c<co00@0001VIYWoool00002IVJI
00Goooo<c?l0001VIYWoool03lc<o`040000IVJIc<co00000VIVV@;oool3
IVJI00C<c?l0001VIYWoool4c<co0VIVV@030000VIW<IVJI0?o<c<a=c<c<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT01Lc<o`0@ooooMgMgIS=VIS=VMgMgR8R8IVIV
<c<003?<06K<<`1V0000IS=V<c<cMgMgc<c<1Lc<o`800003c<co0P000003
c<co0000000000;<c?l2000000?<c?l0000000000/c<o`8000000lc<o`00
00000002c<co0P000003c<co0000000000;<c?l200001<c<o`800007c<co
10000004c<co00000000c<co0P000003c<co0000000000;<c?l2000000?<
c?l0000000002<c<o`05ooooc<coc<coc<cooooo00?<c?l01Oooolc<olc<
olc<ooooo`03c<co00?oooo<c?o<c?l01/c<o`030000IVJIIVJI00AVIYT;
c<co00D0001VIYWoooo<c?l000000VIVV@04ooooIVJIIVJIoooo3lc<o`05
0000IVJIc<coc<co000000EVIYT2c<co00<0001VIYWoool01<c<o`9VIYT0
0`0009VIc6IVV@3oc<c<CLc<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI00G<c?l02Ooo
odA4A3<0<l`0c6HcIVIVIQ4009UV0<bI000206K<0YT0V@03^k^kMgMgc<c<
00G<c?l200000lc<o`800002c<co00<0003<c?o<c?l00P000005c<co0000
00000000c<co008000000lc<o`0000000002c<co0P000005c<co00000000
0000c<co00800004c<co0P0000G<c?l010000<c<olc<olc<o`@00003c<co
100000;<c?l2000000?<c?l0000000002lc<o`05IVJIc<coc<coc<coIVJI
00?<c?l01FIVVLc<olc<olc<ofIVV@09c<co1`000003c<cooooooooo00Co
ool4c<co00<0001VIYWoool00/c<o`030000IVJIIVJI009VIYT00oooolc<
olc<o`0=c<co00<0001VIYW<c?l00/c<o`050000IVJIIVJIIVJIoooo00;<
c?l00`0006IVVOooo`04c<co0VIVV@030000VIW<IVJI0?o<c<a=c<c<0XS0
^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2
IVJI00<0001VIYUVIYT01Lc<o`04oooo<c<cc<c<A4A40P00000:<`0cIVH0
ol`0VFH0IP1Vc03oIP1VIS=VMgMg^k^k1Lc<o`800003c<co0P0000;<c?l4
00000/c<o`8000000lc<o`0000000002c<co0P0000;<c?l2000000C<c?l0
0000003<c?l200001Lc<o`800006c<co10000003c<co0000000000?<c?l2
000000?<c?l0000000000P0000;<c?l400002<c<o`05ooooc<coc<coc<co
oooo00?<c?l01Oooolc<olc<olc<ooooo`0Ac<co00<0001VIYUVIYT00fIV
V@03ooooc<coc<co00;<c?l00`0006IVVOooo`03oooo00D0001VIYUVIYUV
IYWoool00/c<o`;oool;c<co00<0001VIYW<c?l00/c<o`AVIYT01_ooolc<
olc<o`0006IVVOooo`C<c?l2IVJI00<0001VIYUVIYT0olc<c4g<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c0EV
IYT5c<co00OooomgMgO^k^k^k^hR8R:I09UV<fH00VH0IP07<`0cVFH04A4A
c<c<k^k^MgMgc<c<00G<c?l200000lc<o`80000Pc<co0P0002C<c?l01FIV
VLc<olc<olc<ofIVV@03c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`03IVJI
c<coc<co00c<c?l0100006IVVFIVVFIVV@800005c<co00<0001VIYUVIYT0
1fIVV@;oool2IVJI00?oooo<c?o<c?l02Lc<o`040000IVJIc<coc<co0fIV
V@080000IVJIIVJIooooc<co0000IVJIoooo1<c<o`EVIYWoc<c<CLc<c0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
1FIVV@G<c?l01_ooodA4A>k^kYVIVA4A4DA4A0;<0<`019T0V@0cI/bI07Mg
M`;^k^h00gMgMlc<c<c<o`04c<co1P00027<c?l200008lc<o`05ooooc<co
c<coc<cooooo00?<c?l01Oooolc<olc<olc<ooooo`03c<co00?oooo<c?o<
c?l03Lc<o`050000IVJIIVJIIVJIoooo00K<c?l900000VIVV@04ooooIVJI
IVJIoooo2lc<o`040000IVJIc<co00000VIVV@;<c?l01`0006IVVFIVVLc<
o`0006IVVOooo`04c<co1FIVVOo<c<a=c<c<0XS0^058T8P10000000018S0
^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`5IVJI1Lc<o`09oooo<c<c
k^k^MgMg<c<cIVIV<c<cc03<A4A40080<fH01GMgMnk^k^k^kWMgMk^k^`1D
c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`05IVJIc<coc<coc<coIVJI013<
c?l00`0006IVV@000002IVJI00?oooo<c?o<c?l03<c<o`030000IVJIIVJI
009VIYT00oooolc<olc<o`09c<co00D0001VIYW<c?o<c?l000001<c<o`06
0000c<coc<co0000IVJIoooo1<c<o`EVIYWoc<c<CLc<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<1FIVV@G<c?l0
0oooogMgMnk^kP03k^k^00Jk^k]V<fKoooo^k^jIVIV8R8P2k^k^00=gMgO<
c<c<c?l0D/c<o`05ooooc<coc<coc<cooooo00?<c?l01Oooolc<olc<olc<
ooooo`0Ac<co00@0001VIYWoool00002IVJI00?oooo<c?o<c?l02lc<o`03
oooo0000IVJI009VIYT00oooolc<olc<o`09c<co00<0001VIYW<c?l02Lc<
o`9VIYT00oooolc<olc<o`02c<co1FIVVOo<c<a=c<c<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`5IVJI1Lc<o`03
oooo<c<coooo00_^k^h00gMgMlc<c<c<o`1Ac<co00EVIYW<c?o<c?o<c?mV
IYT00lc<o`05IVJIc<coc<coc<coIVJI00?<c?l00fIVVLc<olc<o`0<c<co
0P0000;<c?l00`0006IVVFIVV@0<c<co00<0001VIYUVIYT00fIVV@03oooo
c<coc<co00W<c?l00`0006IVVFIVV@0;IVJI00?oooo<c?o<c?l00/c<o`EV
IYWoc<c<CLc<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@0Dc<c<1FIVV@G<c?l00ooooc<c<gMgM`0<MgMg00?oooo<c?o<
c?l0Clc<o`05ooooc<coc<coc<cooooo00?<c?l01Oooolc<olc<olc<oooo
o`03c<co00?oooo<c?o<c?l04/c<o`030000c<coc<co00_<c?l600003<c<
o`h00005c<co1FIVVOo<c<a=c<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0D
c<c<0VIVV@030000VIW<IVJI01C<c<`5IVJI_/c<o`EVIYWoc<c<CLc<c0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI
01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
1FIVVKk<c?l5IVJIolc<c4g<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c0IVIYVlc<co1VIVVOo<c<a=c<c<0XS0
^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<c8
IVJIolc<c4g<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c0mVIYV/VIW<3FIVVOo<c<a=c<c<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT0
0`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI029VIYV/00003VIVVOo<
c<a=c<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c?o8IVJIolc<c4g<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<o`03c<c<IVJIIVJI0<AVIYWoc<c<C/c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@2n
c<co0VIVV@030000VIW<IVJI0?o<c<aVc<c<0XS0^058T8P10000000018S0
^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI00G<c?l00oooohR8R4A4A006A4A4
00<c<c=4A4A4A4@00dA4A003VIVIc<coc<co053<c?l01FIVVLc<olc<olc<
ofIVV@03c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`03IVJIc<coc<co04C<
c?l2IVJI00<0002IVLaVIYT0olc<c6K<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT01Lc<o`03ooooA4A4IVIV00=gMgL0
0fIVIWMgMgMgM`05MgMg00<c<c?<c<c<c?l0=/c<o`<0000Gc<co00Goooo<
c?o<c?o<c?ooool00lc<o`05ooooc<coc<coc<cooooo00?<c?l00oooolc<
olc<o`07c<co1oooo`_<c?l:oooo4<c<o`koool4c<co0VIVV@030000VIW<
IVJI0?o<c<aVc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2
IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI00G<c?l03?oooc<c<nk^k^k^k[^k^gMgMjZZZ_ooonk^k]gM
gGMgMmgMg@;^k^h00gMgMlc<c<c<o`0hc<co0P0001G<c?l01FIVVLc<olc<
olc<ofIVV@03c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`03IVJIc<coc<co
00O<c?l00`0006IVVFIVV@04IVJI00?oooo<c?o<c?l02<c<o`030000IVJI
IVJI00MVIYT00oooolc<olc<o`0=c<co00<0001VIYUVIYT02fIVV@03oooo
c<coc<co00;<c?l2IVJI00<0002IVLaVIYT0olc<c6K<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT01Lc<o`06oooo<c<c
ooook^k^MgMg03?<0S<c0008A4A4<`0c000RIP1VMgMgooooMgMg^k^k1Lc<
o`800002c<co00<0003<c?o<c?l00P0000;<c?l400000lc<o`8000000lc<
o`0000000002c<co1@000003c<co0000000000C<c?l600000/c<o`D00002
c<co0`0000?<c?l400000/c<o`800008c<co00Goooo<c?o<c?o<c?ooool0
0lc<o`05ooooc<coc<coc<cooooo00?<c?l00oooolc<olc<o`08c<co00<0
001VIYUVIYT00`000003IVJIooooc<co00W<c?l00`0006IVVFIVV@02IVJI
10000003IVJIooooc<co00k<c?l00`0006IVVFIVV@0:000000=VIYWoooo<
c?l00lc<o`9VIYT00`0009VIc6IVV@3oc<c<I/c<c0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@05c<co013ooomgMgO^k^k^
k^iVIVH0I_l0I/a4A4@c03<c<c=gMgLc03>8R8S^k^iVIVK<c<`5c<co0P00
0005c<co000000000000c<co008000000lc<o`0000000002c<co0P000004
c<co00000000c<co0`000003c<co0000000000;<c?l2000000?<c?l00000
00001<c<o`800005c<co0P0000;<c?l200000/c<o`<00002c<co0P0000;<
c?l2000000?<c?l0000000002lc<o`05IVJIc<coc<coc<coIVJI00?<c?l0
1FIVVLc<olc<olc<ofIVV@03c<co00=VIYW<c?o<c?l01Lc<o`030000IVJI
oooo00;<c?l00`0006IVVOooo`0:c<co00D0001VIYUVIYUVIYWoool00lc<
o`030000IVJIoooo00o<c?l00`0006IVVLc<o`07c<co00Goooo<c?l0001V
IYWoool01<c<o`9VIYT00`0009VIc6IVV@3oc<c<I/c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI
00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@05c<co00Gooolc<c?^
k^kMgMdA4A400P1Vo`09<fK<8R8RR8R8VIVI8R8RgMgMk^k^MgMgc<c<00G<
c?l2000000G<c?l000000000003<c?l00P000003c<co0000000000;<c?l2
000000?<c?l0000000000/c<o`8000000lc<o`0000000002c<co0P000003
c<co0000000000C<c?l200001Lc<o`800002c<co0P000004c<co00000000
c<co0P000003c<co0000000000G<c?l200002/c<o`05ooooc<coc<coc<co
oooo00?<c?l01Oooolc<olc<olc<ooooo`03c<co00?oooo<c?o<c?l01/c<
o`030000IVJIoooo00;<c?l00`0006IVVOooo`0:c<co00<0001VIYT00000
0VIVV@06ooooc<coc<co0000IVJIoooo3lc<o`060000IVJIc<coc<coIVJI
oooo0lc<o`06IVJIoooooooo0000IVJIoooo1<c<o`9VIYT00`0009VIc6IV
V@3oc<c<I/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIV
V@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`00
09VIc6IVV@05c<co00Kooolc<c?^k^hc<c<c03<001428R8R00P0<c<c03<A
0000000c<c>k^k]gMgNk^k/5c<co0P000005c<co0000c<co0000c<co0080
00000lc<o`0000000002c<co0P000003c<co0000000000;<c?l200000/c<
o`8000001<c<o`0000000<c<o`800004c<co0P0000K<c?l2000000C<c?l0
0000003<c?l2000000C<c?l00000003<c?l6000000?<c?l0000000002Lc<
o`05IVJIc<coc<coc<coIVJI00?<c?l01FIVVLc<olc<olc<ofIVV@03c<co
00=VIYW<c?o<c?l01lc<o`030000IVJIoooo00;oool2IVJI00?oooo<c?o<
c?l02<c<o`040000IVJIoooo00000VIVV@05ooooc<co0000IVJIoooo00o<
c?l0100006IVVLc<o`00009VIYT2oooo0fIVV@04c<co0000IVJIoooo1<c<
o`9VIYT00`0009VIc6IVV@3oc<c<I/c<c0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@05c<co013ooomgMgMV<fIV<fIgMgN8
R8QVIVHc<`00<l`0I/`c06H0001V<fHc<c=gMgO<c<`5c<co0P000005c<co
0000c<co0000c<co008000000lc<o`0000000002c<co0P000003c<co0000
000000;<c?l200000lc<o`@000000lc<o`0000000004c<co0P0000O<c?l4
000000C<c?l00000003<c?l2000000?<c?l0000000000/c<o`8000000lc<
o`0000000008c<co00Goooo<c?o<c?o<c?ooool00lc<o`05ooooc<coc<co
c<cooooo00?<c?l00oooolc<olc<o`08c<co00<0001VIYUVIYT016IVV@_<
c?l01@0006IVVOooolc<o`000002IVJI00CooomVIYUVIYWoool?c<co00D0
001VIYW<c?o<c?l000001FIVV@;<c?l00`0006IVVOooo`04c<co0VIVV@03
0000VIW<IVJI0?o<c<aVc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI00G<c?l02OooodA4A3<0<l`0c6HcIVIVIQ4009UV
0<bI000206K<0YT0V@03^k^kMgMgc<c<00G<c?l4000000?<c?l000000000
0P0000;<c?l00`000<c<olc<o`02000000C<c?l00000003<c?l3000000?<
c?l0003<c?l00/c<o`8000000lc<o`0000000004c<co0P0000G<c?l01000
0<c<olc<olc<o`@00003c<co100000;<c?l2000000?<c?l0000000002lc<
o`05IVJIc<coc<coc<coIVJI00?<c?l01FIVVLc<olc<olc<ofIVV@03c<co
00=VIYW<c?o<c?l01Lc<o`L000000lc<ooooooooo`04oooo1<c<o`030000
IVJIoooo00;<c?l00`0006IVVFIVV@02IVJI00?oooo<c?o<c?l03Lc<o`03
0000IVJIc<co00;<c?l01@0006IVVFIVVFIVVOooo`02c<co00<0001VIYWo
ool01<c<o`9VIYT00`0009VIc6IVV@3oc<c<I/c<c0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0
002IVLaVIYT05<c<c09VIYT00`0006IVVFIVV@05c<co00Cooolc<c?<c<a4
A4@2000000Xc03=VIP3oc02IIP1V06K<0?mV06IV<fIgMgNk^k/5c<co1000
0003c<co0000000000800002c<co100000?<c?l2000000?<c?l000000000
0/c<o`@00002c<co0P0000C<c?l200001/c<o`@000000lc<o`0000000003
c<co0P000003c<co0000000000800002c<co100000S<c?l01Oooolc<olc<
olc<ooooo`03c<co00Goooo<c?o<c?o<c?ooool00lc<o`03ooooc<coc<co
00g<c?l00`0006IVVFIVV@03IVJI00?oooo<c?o<c?l00/c<o`030000IVJI
oooo00?oool01@0006IVVFIVVFIVVOooo`02c<co0_ooo`_<c?l00`0006IV
VLc<o`02c<co16IVV@06ooooc<coc<co0000IVJIoooo1<c<o`9VIYT00`00
06IVVFIVV@3oc<c<I/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PI
c<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT05<c<c0EV
IYT5c<co00OooomgMgO^k^k^k^hR8R:I09UV<fH00VH0IP07<`0cVFH04A4A
c<c<k^k^MgMgc<c<00G<c?l300000lc<o`<0000<c<co0P0000S<c?l20000
1<c<o`80000Tc<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`05IVJIc<coc<co
c<coIVJI00?<c?l00fIVVLc<olc<o`0>c<co00@0001VIYUVIYUVIYT20000
1Lc<o`030000IVJIIVJI00MVIYT2oooo0VIVV@03ooooc<coc<co00W<c?l0
100006IVVLc<olc<o`=VIYT0200006IVVFIVVOooolc<o`0006IVVOooo`C<
c?l5IVJIolc<c6K<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`5IVJI
1Lc<o`06ooooA4A4k^k^VIVI4A4AA4A40/`0c004V@2I03=Vc9T0MgMg0^k^
kP03MgMgc<c<c<co00C<c?l300000lc<o`<0000<c<co0P0000S<c?l20000
1<c<o`80000Sc<co00Goooo<c?o<c?o<c?ooool00lc<o`05ooooc<coc<co
c<cooooo00?<c?l00oooolc<olc<o`0?c<co00D0001VIYUVIYUVIYWoool0
1/c<o`T00002IVJI00CooomVIYUVIYWoool;c<co00@0001VIYW<c?l00002
IVJI0/c<o`070000IVJIIVJIc<co0000IVJIoooo00C<c?l5IVJIolc<c6K<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`5IVJI1Lc<o`09oooo<c<c
k^k^MgMg<c<cIVIV<c<cc03<A4A40080<fH01GMgMnk^k^k^kWMgMk^k^`1B
c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`05IVJIc<coc<coc<coIVJI00?<
c?l00fIVVLc<olc<o`0<c<co00<0001VIYT000000VIVV@03ooooc<coc<co
00c<c?l00`0006IVVFIVV@02IVJI00?oooo<c?o<c?l02Lc<o`050000IVJI
c<coc<co000000C<c?l01P000<c<olc<o`0006IVVOooo`C<c?l5IVJIolc<
c6K<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`00
09VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`5IVJI1Lc<o`03oooo
MgMgk^k^00?^k^h01[^k^fHcI_ooonk^kYVIVHR8R0;^k^h00gMgMlc<c<c<
o`1@c<co00Goooo<c?o<c?o<c?ooool00lc<o`05ooooc<coc<coc<cooooo
00?<c?l00oooolc<olc<o`0=c<co00@0001VIYWoool00002IVJI00?oooo<
c?o<c?l02lc<o`03oooo0000IVJI009VIYT00oooolc<olc<o`09c<co00<0
001VIYW<c?l02Lc<o`9VIYT00oooolc<olc<o`02c<co1FIVVOo<c<aVc<c<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaV
IYT05<c<c09VIYT00`0009VIc6IVV@0Dc<c<1FIVV@G<c?l00ooooc<c<ooo
o`0;k^k^00=gMgO<c<c<c?l0Clc<o`05IVJIc<coc<coc<coIVJI00?<c?l0
1FIVVLc<olc<olc<ofIVV@03c<co00=VIYW<c?o<c?l03/c<o`800002c<co
00<0001VIYUVIYT03<c<o`030000IVJIIVJI00=VIYT00oooolc<olc<o`09
c<co00<0001VIYUVIYT02fIVV@03ooooc<coc<co00;<c?l5IVJIolc<c6K<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<c<0VIVV@030000VIW<IVJI01C<c<`5IVJI1Lc<o`03oooo<c<c
MgMg00agMgL00oooolc<olc<o`1=c<co00Goooo<c?o<c?o<c?ooool00lc<
o`05ooooc<coc<coc<cooooo00?<c?l00oooolc<olc<o`0Dc<co00<0003<
c?o<c?l02lc<o`H0000<c<co3P0000G<c?l5IVJIolc<c6K<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`5IVJI_/c<o`EVIYWoc<c<I/c<c0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT05<c<c0EVIYVnc<co1FIVVOo<c<aVc<c<0XS0
^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@0Dc<c<1VIVVKc<c?l6IVJIolc<c6K<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI01C<c<c8IVJIolc<c6K<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c<`?IVJI[9VIc0eVIYWoc<c<I/c<c0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT08VIVVJ`0000>IVJIolc<c6K<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI01C<c?o8IVJIolc<c6K<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIVV@03
0000VIW<IVJI01C<c?l00lc<c6IVVFIVV@34IVJIolc<c6O<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<
0VIVV@030000VIW<IVJI0;k<c?l2IVJI00<0002IVLaVIYT0olc<c7o<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<0VIVV@030000VIW<IVJI00G<c?l00oooohR8R4A4A006A4A400<c
<c=4A4A4A4@00dA4A003VIVIc<coc<co05K<c?l01FIVVLc<olc<olc<ofIV
V@03c<co00=VIYW<c?o<c?l0A/c<o`9VIYT00`0009VIc6IVV@3oc<c<Olc<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<
IVJI01C<c<`2IVJI00<0002IVLaVIYT01Lc<o`03ooooA4A4IVIV00=gMgL0
0fIVIWMgMgMgM`05MgMg00<c<c?<c<c<c?l0?<c<o`<0000Gc<co00Goooo<
c?o<c?o<c?ooool00lc<o`03ooooc<coc<co00W<c?l7oooo2lc<o`[oool@
c<co3_ooo`C<c?l2IVJI00<0002IVLaVIYT0olc<c7o<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<0VIV
V@030000VIW<IVJI00G<c?l03?oooc<c<nk^k^k^k[^k^gMgMjZZZ_ooonk^
k]gMgGMgMmgMg@;^k^h00gMgMlc<c<c<o`0nc<co0P0001G<c?l01FIVVLc<
olc<olc<ofIVV@03c<co00EVIYW<c?o<c?o<c?mVIYT01lc<o`030000IVJI
IVJI00AVIYT00oooolc<olc<o`08c<co00<0001VIYUVIYT01fIVV@03oooo
c<coc<co00g<c?l00`0006IVVFIVV@0;IVJI00?oooo<c?o<c?l00/c<o`9V
IYT00`0009VIc6IVV@3oc<c<Olc<c0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<c<`2IVJI00<0002IVLaVIYT0
1Lc<o`06oooo<c<cooook^k^MgMg03?<0S<c0008A4A4<`0c000RIP1VMgMg
ooooMgMg^k^k1Lc<o`800007c<co1@000003c<co0000000000;<c?l40000
0lc<o`800002c<co0P0000;<c?l400001Lc<o`H00002c<co1@0000;<c?l3
00000lc<o`@00002c<co0P0000S<c?l01Oooolc<olc<olc<ooooo`03c<co
00Goooo<c?o<c?o<c?ooool02<c<o`030000IVJIIVJI00<000000fIVVOoo
olc<o`09c<co00<0001VIYUVIYT00VIVV@@000000fIVVOooolc<o`0>c<co
00<0001VIYUVIYT02P000003IVJIooooc<co00?<c?l2IVJI00<0002IVLaV
IYT0olc<c7o<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09V
IYT00`0009VIc6IVV@0Dc<c<0VIVV@030000VIW<IVJI00G<c?l04?ooogMg
Mnk^k^k^kVIVIP1Vo`1Vc4A4A3<0<c<c<gMgMc<0<hR8R>k^kVIVI/c<c0G<
c?l200001/c<o`800002c<co0P000004c<co00000000c<co0P0000;<c?l2
000000?<c?l0000000000/c<o`800002c<co0P0000;<c?l200001<c<o`80
0005c<co0P0000;<c?l200000/c<o`<00002c<co0P0000;<c?l2000000?<
c?l0000000002lc<o`05IVJIc<coc<coc<coIVJI00?<c?l00fIVVLc<olc<
o`07c<co00<0001VIYWoool00/c<o`030000IVJIoooo00[<c?l01@0006IV
VFIVVFIVVOooo`03c<co00<0001VIYWoool03lc<o`030000IVJIc<co00O<
c?l01Oooolc<o`0006IVVOooo`04c<co0VIVV@030000VIW<IVJI0?o<c<ao
c<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002I
VLaVIYT05<c<c09VIYT00`0009VIc6IVV@05c<co00Gooolc<c?^k^kMgMdA
4A400P1Vo`09<fK<8R8RR8R8VIVI8R8RgMgMk^k^MgMgc<c<00G<c?l20000
1/c<o`800002c<co0P000004c<co00000000c<co0P0000G<c?l200000/c<
o`800002c<co0P0000S<c?l200001Lc<o`800002c<co0P000004c<co0000
0000c<co0P000003c<co0000000000G<c?l200002/c<o`05ooooc<coc<co
c<cooooo00?<c?l00oooolc<olc<o`08c<co00<0001VIYWoool00/c<o`03
0000IVJIoooo00[<c?l00`0006IVV@000002IVJI00Koooo<c?o<c?l0001V
IYWoool?c<co00H0001VIYW<c?o<c?mVIYWoool3c<co00IVIYWoooooool0
001VIYWoool4c<co0VIVV@030000VIW<IVJI0?o<c<aoc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IYT00`0009VIc6IVV@05c<co00Kooolc<c?^k^hc<c<c03<001428R8R00P0
<c<c03<A0000000c<c>k^k]gMgNk^k/5c<co1P0000?<c?l2000000C<c?l0
0000003<c?l2000000?<c?l00000000010000003c<co0000000000;<c?l2
00000/c<o`H00004c<co0P0000K<c?l2000000C<c?l00000003<c?l20000
00C<c?l00000003<c?l6000000?<c?l0000000002Lc<o`05IVJIc<coc<co
c<coIVJI00?<c?l01FIVVLc<olc<olc<ofIVV@07c<co00<0001VIYWoool0
0_ooo`9VIYT00oooolc<olc<o`08c<co00@0001VIYWoool00002IVJI00Go
ooo<c?l0001VIYWoool03lc<o`040000IVJIc<co00000VIVV@;oool3IVJI
00C<c?l0001VIYWoool4c<co0VIVV@030000VIW<IVJI0?o<c<aoc<c<0XS0
^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT0
5<c<c09VIYT00`0009VIc6IVV@05c<co013ooomgMgMV<fIV<fIgMgN8R8QV
IVHc<`00<l`0I/`c06H0001V<fHc<c=gMgO<c<`5c<co0P0000?<c?l20000
0lc<o`@000001<c<o`0000000<c<o`800002c<co0P000003c<co00000000
00;<c?l200000/c<o`800002c<co0P0000C<c?l200001lc<o`@000001<c<
o`0000000<c<o`8000000lc<o`0000000002c<co0P000003c<co00000000
00S<c?l01Oooolc<olc<olc<ooooo`03c<co00Goooo<c?o<c?o<c?ooool0
2<c<o`030000IVJIIVJI00AVIYT;c<co00D0001VIYWoooo<c?l000000VIV
V@04ooooIVJIIVJIoooo3lc<o`050000IVJIc<coc<co000000EVIYT2c<co
00<0001VIYWoool01<c<o`9VIYT00`0009VIc6IVV@3oc<c<Olc<c0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI01C<
c<`2IVJI00<0002IVLaVIYT01Lc<o`09ooooA4A4<`0cc03<IS=VIVIV4@00
VFH0c9T00080I/`2V@2I00>k^k]gMgO<c<`01Lc<o`800003c<co0P000003
c<co0000c<co00;<c?l2000000C<c?l00000003<c?l200000/c<o`800000
0lc<o`0000000002c<co0P0000;<c?l200000/c<o`800004c<co0P0000G<
c?l010000<c<olc<olc<o`@00003c<co100000;<c?l2000000?<c?l00000
00002lc<o`05IVJIc<coc<coc<coIVJI00?<c?l00fIVVLc<olc<o`07c<co
1`000003c<cooooooooo00Coool4c<co00<0001VIYWoool00/c<o`030000
IVJIIVJI009VIYT00oooolc<olc<o`0=c<co00<0001VIYW<c?l00/c<o`05
0000IVJIIVJIIVJIoooo00;<c?l00`0006IVVOooo`04c<co0VIVV@030000
VIW<IVJI0?o<c<aoc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<
c<`2IVJI00<0002IVLaVIYT05<c<c09VIYT00`0006IVVFIVV@05c<co00Co
oolc<c?<c<a4A4@2000000Xc03=VIP3oc02IIP1V06K<0?mV06IV<fIgMgNk
^k/5c<co0P0000?<c?l200000/c<o`@00002c<co0P0000;<c?l4000000?<
c?l0000000001P0000;<c?l400001Lc<o`800006c<co10000003c<co0000
000000?<c?l2000000?<c?l0000000000P0000;<c?l400002<c<o`05oooo
c<coc<coc<cooooo00?<c?l00oooolc<olc<o`0?c<co00<0001VIYUVIYT0
0fIVV@03ooooc<coc<co00;<c?l00`0006IVVOooo`03oooo00D0001VIYUV
IYUVIYWoool00/c<o`;oool;c<co00<0001VIYW<c?l00/c<o`AVIYT01_oo
olc<olc<o`0006IVVOooo`C<c?l2IVJI00<0001VIYUVIYT0olc<c7o<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@0Dc<c<1FIVV@G<c?l01oooogMgMnk^k^k^kR8R8YT0VFHcIP02IP1V00Lc
03>IIP0A4A7<c<c^k^igMgO<c<`01Lc<o`800003c<co0P0000S<c?l20000
2<c<o`800002c<co0P0000c<c?l200009<c<o`05IVJIc<coc<coc<coIVJI
00?<c?l01FIVVLc<olc<olc<ofIVV@0>c<co00@0001VIYUVIYUVIYT20000
1Lc<o`030000IVJIIVJI00MVIYT2oooo0VIVV@03ooooc<coc<co00W<c?l0
100006IVVLc<olc<o`=VIYT0200006IVVFIVVOooolc<o`0006IVVOooo`C<
c?l5IVJIolc<c7o<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<1FIVV@G<c?l01_ooodA4A>k^kYVIVA4A
4DA4A0;<0<`019T0V@0cI/bI07MgM`;^k^h00gMgMlc<c<c<o`04c<co1P00
00W<c?l200002Lc<o`050000c<coc<coc<co000000c<c?l200008lc<o`05
ooooc<coc<coc<cooooo00?<c?l01Oooolc<olc<olc<ooooo`0?c<co00D0
001VIYUVIYUVIYWoool01/c<o`T00002IVJI00CooomVIYUVIYWoool;c<co
00@0001VIYW<c?l00002IVJI0/c<o`070000IVJIIVJIc<co0000IVJIoooo
00C<c?l5IVJIolc<c7o<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<1FIVV@G<c?l02Ooooc<c<nk^kWMg
Mc<c<fIVIS<c<l`0c4A4A00203=V00EgMgO^k^k^k^igMgNk^k/0F<c<o`05
IVJIc<coc<coc<coIVJI00?<c?l00fIVVLc<olc<o`0>c<co00<0001VIYT0
00000VIVV@03ooooc<coc<co00c<c?l00`0006IVVFIVV@02IVJI00?oooo<
c?o<c?l02Lc<o`050000IVJIc<coc<co000000C<c?l01P000<c<olc<o`00
06IVVOooo`C<c?l5IVJIolc<c7o<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<1FIVV@G<c?l00oooogMg
Mnk^kP03k^k^00Jk^k]V<fKoooo^k^jIVIV8R8P2k^k^00=gMgO<c<c<c?l0
E/c<o`05ooooc<coc<coc<cooooo00?<c?l00oooolc<olc<o`0?c<co00@0
001VIYWoool00002IVJI00?oooo<c?o<c?l02lc<o`03oooo0000IVJI009V
IYT00oooolc<olc<o`09c<co00<0001VIYW<c?l02Lc<o`9VIYT00oooolc<
olc<o`02c<co1FIVVOo<c<aoc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<c0EVIYT5c<co00?ooolc<c?o
ool02nk^kP03MgMgc<c<c<co05G<c?l01FIVVLc<olc<olc<ofIVV@03c<co
00EVIYW<c?o<c?o<c?mVIYT03/c<o`800002c<co00<0001VIYUVIYT03<c<
o`030000IVJIIVJI00=VIYT00oooolc<olc<o`09c<co00<0001VIYUVIYT0
2fIVV@03ooooc<coc<co00;<c?l5IVJIolc<c7o<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<1FIVV@G<
c?l00ooooc<c<gMgM`0<MgMg00?oooo<c?o<c?l0Dlc<o`05ooooc<coc<co
c<cooooo00?<c?l01Oooolc<olc<olc<ooooo`0Dc<co00<0003<c?o<c?l0
2lc<o`H0000<c<co3P0000G<c?l5IVJIolc<c7o<c<`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<1FIVVKk<
c?l5IVJIolc<c7o<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<
c09VIYT00`0009VIc6IVV@0Dc<c<1FIVVKk<c?l5IVJIolc<c7o<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0D
c<c<1VIVVKc<c?l6IVJIolc<c7o<c<`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@0Dc<c<b6IVVOo<c<aoc<c<0XS0
^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT0
5<c<c0mVIYV/VIW<3FIVVOo<c<aoc<c<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT08VIVVJ`0000>IVJIolc<c7o<
c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VI
c6IVV@0Dc<cob6IVVOo<c<aoc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^1W<c<`2IVJI00<0002IVLaVIYT05<c<o`03c<c<IVJIIVJI0<AVIYWo
c<c<P<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@03
0000VIW<IVJI0;k<c?l2IVJI00<0002IVLaVIYT0olc<c9S<c<`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IVV@05c<co
00?ooon8R8Q4A4@01TA4A003<c<cA4A4A4A400=4A4@00iVIVLc<olc<o`1F
c<co00EVIYW<c?o<c?o<c?mVIYT00lc<o`03IVJIc<coc<co04K<c?l2IVJI
00<0002IVLaVIYT0olc<c9S<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c09VIYT00`0009VIc6IVV@05c<co00?ooom4A4AVIVH00gMgM`03
IVIVMgMgMgMg00EgMgL00c<c<lc<c<c<o`0lc<co0`0001O<c?l01Oooolc<
olc<olc<ooooo`03c<co00?oooo<c?o<c?l02Lc<o`Ooool;c<co2_oooa3<
c?l>oooo1<c<o`9VIYT00`0009VIc6IVV@3oc<c<V<c<c0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI00G<c?l03?oo
oc<c<nk^k^k^k[^k^gMgMjZZZ_ooonk^k]gMgGMgMmgMg@;^k^h00gMgMlc<
c<c<o`0nc<co0P0001G<c?l01FIVVLc<olc<olc<ofIVV@03c<co00EVIYW<
c?o<c?o<c?mVIYT01lc<o`030000IVJIIVJI00AVIYT00oooolc<olc<o`08
c<co00<0001VIYUVIYT01fIVV@03ooooc<coc<co00g<c?l00`0006IVVFIV
V@0;IVJI00?oooo<c?o<c?l00/c<o`9VIYT00`0009VIc6IVV@3oc<c<V<c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<
IVJI00G<c?l01_oooc<c<oooonk^kWMgM`0cc08c<`0024A4A3<0<`008VH0
IWMgMoooogMgMk^k^`G<c?l500001<c<o`@00002c<co0P0000?<c?l50000
0/c<o`8000001<c<o`0000000<c<o`800002c<co0P0000C<c?l600000/c<
o`D00002c<co0`0000?<c?l400000/c<o`800008c<co00Goooo<c?o<c?o<
c?ooool00lc<o`05ooooc<coc<coc<cooooo00S<c?l00`0006IVVFIVV@03
000000=VIYWoooo<c?l02Lc<o`030000IVJIIVJI009VIYT4000000=VIYWo
ooo<c?l03/c<o`030000IVJIIVJI00X000000fIVVOooolc<o`03c<co0VIV
V@030000VIW<IVJI0?o<c<bHc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^1W<c<`2IVJI00<0002IVLaVIYT01Lc<o`0@ooooMgMgk^k^k^k^IVIV
06Ko06K<A4A4<`0c<c<cMgMg<`0cR8R8k^k^IVIVc<c<1Lc<o`800002c<co
0P0000;<c?l200000/c<o`8000000lc<o`0000000002c<co0P0000;<c?l2
000000C<c?l00000003<c?l3000000C<c?l00000003<c?l200001Lc<o`80
0005c<co0P0000;<c?l200000/c<o`<00002c<co0P0000;<c?l2000000?<
c?l0000000002lc<o`05IVJIc<coc<coc<coIVJI00?<c?l00fIVVLc<olc<
o`07c<co00<0001VIYWoool00/c<o`030000IVJIoooo00[<c?l01@0006IV
VFIVVFIVVOooo`03c<co00<0001VIYWoool03lc<o`030000IVJIc<co00O<
c?l01Oooolc<o`0006IVVOooo`04c<co0VIVV@030000VIW<IVJI0?o<c<bH
c<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002I
VLaVIYT01Lc<o`05oooo<c<ck^k^gMgM4A4A0080I_l02C=Vc28R8XR8R9VI
VB8R8]gMgNk^kWMgMlc<c005c<co0P0000?<c?l2000000?<c?l000000000
1Lc<o`800002c<co0P0000;<c?l2000000?<c?l0000000000/c<o`800000
1<c<o`0000000<c<o`800005c<co0P0000G<c?l200000/c<o`8000001<c<
o`0000000<c<o`8000000lc<o`0000000005c<co0P0000[<c?l01Oooolc<
olc<olc<ooooo`03c<co00?oooo<c?o<c?l02<c<o`030000IVJIoooo00;<
c?l00`0006IVVOooo`0:c<co00<0001VIYT000000VIVV@06ooooc<coc<co
0000IVJIoooo3lc<o`060000IVJIc<coc<coIVJIoooo0lc<o`06IVJIoooo
oooo0000IVJIoooo1<c<o`9VIYT00`0009VIc6IVV@3oc<c<V<c<c0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000VIW<IVJI00G<
c?l01_oooc<c<nk^kS<c<c<0<`004@8R8R80200c<c<0<a40000003<c<k^k
^gMgMk^k^`G<c?l200000lc<o`8000000lc<o`0000000004000000?<c?l0
000000000lc<o`8000001<c<o`0000000<c<o`800002c<co0P000004c<co
00000000c<co0P0000G<c?l200001/c<o`8000001<c<o`0000000<c<o`80
00001<c<o`0000000<c<o`H000000lc<o`0000000009c<co00EVIYW<c?o<
c?o<c?mVIYT00lc<o`05IVJIc<coc<coc<coIVJI00O<c?l00`0006IVVOoo
o`02oooo0VIVV@03ooooc<coc<co00S<c?l0100006IVVOooo`00009VIYT0
1Oooolc<o`0006IVVOooo`0?c<co00@0001VIYW<c?l00002IVJI0_ooo`=V
IYT01<c<o`0006IVVOooo`C<c?l2IVJI00<0002IVLaVIYT0olc<c9S<c<`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c09VIYT00`0009VIc6IV
V@05c<co013ooomgMgMV<fIV<fIgMgN8R8QVIVHc<`00<l`0I/`c06H0001V
<fHc<c=gMgO<c<`5c<co0P0000?<c?l2000000?<c?l0000000000/c<o`80
00000lc<o`0000000004c<co10000003c<co0000000000;<c?l2000000C<
c?l00000003<c?l200001Lc<o`800007c<co10000004c<co00000000c<co
0P000003c<co0000000000;<c?l2000000?<c?l0000000002<c<o`05oooo
c<coc<coc<cooooo00?<c?l01Oooolc<olc<olc<ooooo`08c<co00<0001V
IYUVIYT016IVV@_<c?l01@0006IVVOooolc<o`000002IVJI00CooomVIYUV
IYWoool?c<co00D0001VIYW<c?o<c?l000001FIVV@;<c?l00`0006IVVOoo
o`04c<co0VIVV@030000VIW<IVJI0?o<c<bHc<c<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^1W<c<`2IVJI00<0002IVLaVIYT01Lc<o`09ooooA4A4
<`0cc03<IS=VIVIV4@00VFH0c9T00080I/`2V@2I00>k^k]gMgO<c<`01Lc<
o`800003c<co0P000003c<co0000000000;<c?l2000000?<c?l000000000
0/c<o`040000c<coc<coc<co0P000003c<co0000000000;<c?l2000000C<
c?l00000003<c?l200001Lc<o`800005c<co00@0003<c?o<c?o<c?l40000
0lc<o`@00002c<co0P000003c<co0000000000_<c?l01FIVVLc<olc<olc<
ofIVV@03c<co00=VIYW<c?o<c?l01lc<o`L000000lc<ooooooooo`04oooo
1<c<o`030000IVJIoooo00;<c?l00`0006IVVFIVV@02IVJI00?oooo<c?o<
c?l03Lc<o`030000IVJIc<co00;<c?l01@0006IVVFIVVFIVVOooo`02c<co
00<0001VIYWoool01<c<o`9VIYT00`0009VIc6IVV@3oc<c<V<c<c0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;PIc<c<0VIVV@030000IVJIIVJI00G<
c?l01?oooc<c<lc<c4A4A08000002S<0<fIV0?o<09UV06H0I/`0ofH0IVHc
IWMgMk^k^`G<c?l200000lc<o`800002c<co10000003c<co000000000080
0002c<co100000;<c?l200000/c<o`8000000lc<o`000000000400001<c<
o`800006c<co10000003c<co0000000000?<c?l2000000?<c?l000000000
0P0000;<c?l400002<c<o`05ooooc<coc<coc<cooooo00?<c?l00oooolc<
olc<o`0?c<co00<0001VIYUVIYT00fIVV@03ooooc<coc<co00;<c?l00`00
06IVVOooo`03oooo00D0001VIYUVIYUVIYWoool00/c<o`;oool;c<co00<0
001VIYW<c?l00/c<o`AVIYT01_ooolc<olc<o`0006IVVOooo`C<c?l2IVJI
00<0001VIYUVIYT0olc<c9S<c<`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6Lc<c0EVIYT5c<co00OooomgMgO^k^k^k^hR8R:I09UV<fH00VH0IP07
<`0cVFH04A4Ac<c<k^k^MgMgc<c<00G<c?l200000/c<o`800009c<co0P00
013<c?l2000000?<c?l0000000001Lc<o`80000Tc<co00EVIYW<c?o<c?o<
c?mVIYT00lc<o`05IVJIc<coc<coc<coIVJI00k<c?l0100006IVVFIVVFIV
V@800005c<co00<0001VIYUVIYT01fIVV@;oool2IVJI00?oooo<c?o<c?l0
2Lc<o`040000IVJIc<coc<co0fIVV@080000IVJIIVJIooooc<co0000IVJI
oooo1<c<o`EVIYWoc<c<V<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PIc<c<1FIVV@G<c?l01_ooodA4A>k^kYVIVA4A4DA4A0;<0<`019T0V@0c
I/bI07MgM`;^k^h00gMgMlc<c<c<o`04c<co1@0000_<c?l300003/c<o`80
0002c<co00<0003<c?o<c?l00lc<o`80000Sc<co00Goooo<c?o<c?o<c?oo
ool00lc<o`05ooooc<coc<coc<cooooo00o<c?l01@0006IVVFIVVFIVVOoo
o`06c<co2@00009VIYT01?ooofIVVFIVVOooo`_<c?l0100006IVVLc<o`00
009VIYT2c<co00L0001VIYUVIYW<c?l0001VIYWoool01<c<o`EVIYWoc<c<
V<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<1FIVV@G<c?l0
2Ooooc<c<nk^kWMgMc<c<fIVIS<c<l`0c4A4A00203=V00EgMgO^k^k^k^ig
MgNk^k/0F<c<o`05IVJIc<coc<coc<coIVJI00?<c?l00fIVVLc<olc<o`0>
c<co00<0001VIYT000000VIVV@03ooooc<coc<co00c<c?l00`0006IVVFIV
V@02IVJI00?oooo<c?o<c?l02Lc<o`050000IVJIc<coc<co000000C<c?l0
1P000<c<olc<o`0006IVVOooo`C<c?l5IVJIolc<c9S<c<`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6Lc<c0EVIYT5c<co00?ooomgMgO^k^h00nk^
kP06^k^kIS=Vooook^k^VIVIR8R80^k^kP03MgMgc<c<c<co05K<c?l01Ooo
olc<olc<olc<ooooo`03c<co00?oooo<c?o<c?l03lc<o`040000IVJIoooo
00000VIVV@03ooooc<coc<co00_<c?l00oooo`0006IVV@02IVJI00?oooo<
c?o<c?l02Lc<o`030000IVJIc<co00W<c?l2IVJI00?oooo<c?o<c?l00/c<
o`EVIYWoc<c<V<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<
1FIVV@G<c?l00ooooc<c<oooo`0;k^k^00=gMgO<c<c<c?l0ELc<o`05IVJI
c<coc<coc<coIVJI00?<c?l01FIVVLc<olc<olc<ofIVV@0>c<co0P0000;<
c?l00`0006IVVFIVV@0<c<co00<0001VIYUVIYT00fIVV@03ooooc<coc<co
00W<c?l00`0006IVVFIVV@0;IVJI00?oooo<c?o<c?l00/c<o`EVIYWoc<c<
V<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<1FIVV@G<c?l0
0ooooc<c<gMgM`0<MgMg00?oooo<c?o<c?l0Dlc<o`05ooooc<coc<coc<co
oooo00?<c?l01Oooolc<olc<olc<ooooo`0Dc<co00<0003<c?o<c?l02lc<
o`H0000<c<co3P0000G<c?l5IVJIolc<c9S<c<`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6Lc<c0EVIYVnc<co1FIVVOo<c<bHc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^1W<c<`5IVJI_/c<o`EVIYWoc<c<V<c<c0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<1VIVVKc<c?l6IVJIolc<
c9S<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c<QVIYWoc<c<
V<c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIc<c<3fIVVJbIVL`=
IVJIolc<c9S<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6Lc<c0iV
IYV/00003VIVVOo<c<bHc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^1W<c<c8IVJIolc<c9S<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6/c<c<IVIYWoc<c<VLc<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;So
c<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<
c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;So
c<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<
c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;So
c<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<
c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;So
c<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<
c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;So
c<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<
c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^?o<c<coc<c<N/c<c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;So
c<c<olc<c7[<c<`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<
c<ajc<c<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?o<c<coc<c<N/c<
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Soc<c<olc<c7[<c<`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2holc<c?o<c<ajc<c<0XS0^058T8P1
000000000hS0^<SPf8S0^03oR<2hohS0^7f8`;P1B9280@00000000B8`;S8
h=R8`;R8`;PF00200`01P0800X001002P@03P@03P@03P@<0184200F100@0
1H801X801X801X8200N200<11h81288128800P48P`<12H<30@Z300<12h<1
2h@12h@00`4<Q0<13H@30@j50`8?Q@<248D40Q660`8BQP824hH0108CQ`8D
Q`8DQ`8DQ`<25HL20QJ700@35XP35hP35hP35hP30aR800<36HP36HT36HT0
10<JR@<36hT30ab:0`<MRP<47XX311n;0`@PR`<48H/312:<10@SS00412B<
12B=12B=12F=0PDUS@<59Xd00`DWS@DWSPDWSP031BR>0`DYSP031BZ>1BZ?
1BZ?00<5:hl41Bb?0`H]T0<6;Y021Rn@00@6;i46<946<946<9431S6A0PHb
T@041S:B1S>B1S>B1S>B0PHdTP031cBB1cFB1cFB0087=I<31cJC0`LgT`03
1cRC1cRD1cRD00<7>I@31cZD0`LkU@<8?9D323fE10PnUP<8?iH2242F00@8
@9L8@IL8@IL8@IL324:G0PQ3U`042D>H2DBH2DBH2DBH0`U5V0032DJH2DJI
2DJI00@9AiT32DRI0`U9VP<9BYX32T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`0
10YAW0YAW@YAW@YBW@8;DYd32e>M00<;E9d;E9h;E9h00`]EWP<;EYh00`]G
WP]GW`]GW`032eRO10]IW`<<FZ0335^P0PaLX00435bQ35fQ35fQ35fQ0`aN
X@8<Gj4010aOXPaPXPaPXPaPXP8<HJ800`eQXPeRXPeRXP023F:S0`eSX`<=
I:<00`eUX`eUY0eUY0033FJT0`eWY0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]
YP043VfW3VjW3VjW3VjW0`i_Y`8>L:L010m`Z0maZ0maZ0maZ0<?LZP00`mc
Z0mcZ@mcZ@043gBY0`meZ@<?MZX33gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`4
47f/00@@OZ`@OZd@OZd@Ojd24Gn]0a60[@034H6]4H6^4H6^00<APZh34H>^
00<AQ:hAQ:lAQ:l00a65[`@AQZl34XN`0a:8/08BRK0011:9/A::/A::/A::
/@<BRk424Xba00@BS;8BSK8BSK8BSK824Xjb00<CS[8CSk8CSk800Q>?/`<C
T;<34i6c00<CT[<CT[@CT[@00a>C]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI
]P8DV[H011BJ]aBK]aBK]aBK]`<DW;L259fg00@EWKPEW[PEW[PEW[P35Inh
00<EX;PEX;TEX;T011FQ^@<EX[T35J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/3
5ZVl11JZ_0045Z^l5Z^m5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn
0aN`_P035k6n5k6o5k6o00<G/[l35k>o=QRd`0:8`;P1B9280@00000000B8
`;S8h=R8`;R8`;P4002000>KYo4c@jDc@jD02C=3Y@H0080300600P02P004
00:100>100>100>10`04P@801H401005PP06PP06PP06PP801h800`47PP48
PP48PP020@R30`49P`<12X<00`4;P`4;Q04;Q0030@b40`4=Q0<13XD30Pn5
0`8@Q@@24HH30Q:60P8CQP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<G
R0<GR0<GR0<368P00`<IR0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<4
7h/3122;0`@QR`<48X`412><00@498`498d498d49Hd21BF=0`DVS@031BN=
1BN>1BN>00<5:8h31BV>00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086
;i0010H_T@H`T@H`T@H`T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7
=987=I87=I800PLeT`<7=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E
0`PlU@<8?ID423jF0`PoUP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9
@iP9A9P9A9P9A9P32DFH00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:
BiX32TbK0`Y=V`<:CY/32TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did0
0`]DW@]DWP]DWP032eFN0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<
Fj0235bP00@<G:4<GJ4<GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQ
XP033F6R3F:R3F:R008=HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT
0`eXY@<>JJD33VZU10i[YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`
Y`043g2X3g6X3g6X3g6X0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?
MjX347RZ0a1iZ`<@NZ/347^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd3
4H2]00<APJdAPJhAPJh00a62[P<APjh00a64[Q64[a64[`034HF_1166[`<B
Qk034XR`0Q:9/0044XVa4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=
/P8BS[800a>>/Q>?/Q>?/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d
0a>D]0<CUKD359Je0aBG]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL
]`8DWKL011FM^1FN^1FN^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<E
XkX35JBj0aJU^P<FY[/35ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d2
5jbm0aN]_@035jjm5jjn5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G
/klf6;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^0<008001i^WlOoo
ohij]ZJKa;>YdZRMb;>YdP02YY_400Fl^=g^k_CZjO7ooolc@jD01@00P0<0
0H0200:000@00X400h400h400h4300B10P05P@0400F200J200J200J20P07
PP030@N20@R20@R2008128<30@V30`4:P`030@^30@^40@^400<138@30@f4
0`4>Q@<23hD30Q25108AQP<24XH20Q>600@24hL258L258L258L30QF70P8F
Q`040aJ80aN80aN80aN80`<HR0030aV80aV90aV900@36XT30a^90`<LRP<3
7HX311j:0`@OR`<488/3126;0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd3
1BJ=00<59hd59hh59hh00`DXSP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6
;I031Rj@0PH_T0041RnA1S2A1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHc
TP86=9800`LdTPLeTPLeTP021cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD
0`LjU0<7>iD323bE0`PmU@@8?YH323nF0PQ0UP04242G246G246G246G0`Q2
U`88@iL010U3V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9
BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd2
2e:M0`]CW@032eBM2eBN2eBN00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;
FIl335ZP0`aKX08<G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<
H:8<H:82366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@0
0`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^
Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?
MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/111m[00447j/47j]47j]
47n]0Q5o[@<AP:d00a61[A61[Q61[P034H:^0a63[P034HB^4HB_4HB_00<A
QJl44HJ_0a:7/0<BR;024XV`00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb
4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d
4i:d00<CTk@34iBd0a>E]@<DU[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLD
VkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@E
XKT35J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[
_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa
_`035k:o0aNc_`8H]<0P00000QRd`10000026;C00XS0^058T8P100000000
18S0^<SPf8S0^8S0^080080019^WlOooofaJYJnUbP:l^=d02_omok>Yd_oo
oooookbhgIN:_:RMb>KVk?oooc=3Y@@0080300600P02P00400:100>100>1
00>10`04P@801H401005PP06PP06PP06PP801h800`47PP48PP48PP020@R3
0`49P`<12X<00`4;P`4;Q04;Q0030@b40`4=Q0<13XD30Pn50`8@Q@@24HH3
0Q:60P8CQP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<3
68P00`<IR0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@Q
R`<48X`412><00@498`498d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5
:8h31BV>00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`
T@H`T@H`T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7=987=I87=I80
0PLeT`<7=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID4
23jF0`PoUP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9
A9P32DFH00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=
V`<:CY/32TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]D
WP032eFN0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<
G:4<GJ4<GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R
3F:R008=HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD3
3VZU10i[YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X
3g6X3g6X0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1i
Z`<@NZ/347^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdA
PJhAPJh00a62[P<APjh00a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9
/0044XVa4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>
/Q>?/Q>?/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD3
59Je0aBG]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM
^1FN^1FN^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU
^P<FY[/35ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@03
5jjm5jjn5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/kl26;C000?8
h=Q8T8Q8T8P034R@R0030000b>3HB92800e8T8P0100001Rd`1Rd`<SPf0i8
T8P00`0001Rd`1Rd`002R<2h0DR@R04000000004R<2hb>3HR<2hR<2h0P00
P00;VjOaooooZ9g8oooo/jWBH4bJSWZfN6F^Z9g8oooooogo00?oool00c=3
Y@00P000P00300200`01P0800X001002P@03P@03P@03P@<0184200F100@0
1H801X801X801X8200N200<11h81288128800P48P`<12H<30@Z300<12h<1
2h@12h@00`4<Q0<13H@30@j50`8?Q@8248D3oooo0P8AQP<24XH20Q>600@2
4hL258L258L258L30QF70P8FQ`040aJ80aN80aN80aN80`<HR0030aV80aV9
0aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;0`@RS0@48h`0
10@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DXSP<5:Hh00`DZ
SPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A1S2A0`Ha
T@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC0`LfT`<7
=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH323nF0PQ0
UP04242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9AIP00`U6
V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`4
2U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;EIh32eJN
00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aMX@aMX@aM
X@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ800PeRX`<=
Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/
YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP33g:X
00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/3
47b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61[P034H:^
0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@BRK4BR[4B
R[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008C
Sk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D359Ne11BH
]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh
0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/3
5ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h0
0aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_`8H]<000lSPf8S0^8S0^00;
R<2h00=8T8P00038h=P03HS0^005B92800006;C06;C0b>3H00f8`;P014R@
R00001Rd`1Rd`0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;P2002000jK
Yo7ooooooooKg>aPC9ZCQKZcZM:l^=ePC9ZISkjVVlC8`moooolc@jD60020
0oooo`800X000`02POooooooo`02oooo0P04P@0300F1oooo00F200<01X84
oooo00<1288128?oool00oooo`<12X<01_ooo`4;Q04;Q04<Q?ooo`4<Q081
3H@01?ooo`4>QOooo`4>Q@823hD01?ooo`8@QOooo`8@Q@824HH00oooo`8A
QP8BQP020Q:60P8CQP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<GR0<G
R0<GR0<368P00`<IR0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<47h/3
122;0`@QR`<48X`412><00@498`498d498d49Hd21BF=0`DVS@031BN=1BN>
1BN>00<5:8h31BV>00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i00
10H_T@H`T@H`T@H`T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7=987
=I87=I800PLeT`<7=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`Pl
U@<8?ID423jF0`PoUP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9
A9P9A9P9A9P32DFH00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX3
2TbK0`Y=V`<:CY/32TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]D
W@]DWP]DWP032eFN0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj02
35bP00@<G:4<GJ4<GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQXP03
3F6R3F:R3F:R008=HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eX
Y@<>JJD33VZU10i[YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`04
3g2X3g6X3g6X3g6X0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX3
47RZ0a1iZ`<@NZ/347^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]
00<APJdAPJhAPJh00a62[P<APjh00a64[Q64[a64[`034HF_1166[`<BQk03
4XR`0Q:9/0044XVa4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8B
S[800a>>/Q>?/Q>?/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D
]0<CUKD359Je0aBG]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8D
WKL011FM^1FN^1FN^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX3
5JBj0aJU^P<FY[/35ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm
0aN]_@035jjm5jjn5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/kl2
6;C000C8h=R8`;R8`;R8`;P6000018S0^003B9280000b>3H00:8`;P90000
0XS0^005B92800006;C06;C0b>3H00f8`;P014R@R00001Rd`1Rd`0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;P3002000jKYo7ooonl^=fISkkooooF
dMgKg>cco_nVVlC^k_B5M[2CQK[ooolc@jD4002000Ooool00H000H000H3o
ool00X3oool00`03P@06oooo00B100B100F1oooo00F20P06PP08oooo00N2
00N20@N2oooo0@R2oooo0@R30`49P`04oooo0@Z30@Z3oooo0P4;Q0030@b4
oooo0@b400813H@01?ooo`4>QOooo`4>Q@823hD00oooo`8@QOooo`03oooo
0P8AQP<24XH20Q>600@24hL258L258L258L30QF70P8FQ`040aJ80aN80aN8
0aN80`<HR0030aV80aV90aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<4
88/3126;0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh5
9hh00`DXSP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T004
1RnA1S2A1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLe
TPLeTP021cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE
0`PmU@@8?YH323nF0PQ0UP04242G246G246G246G0`Q2U`88@iL010U3V0U4
V0U4V0U4V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:
C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM
2eBN2eBN00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<
G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=
HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU
0`iYY@<>JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?
L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@
N:X347V[0a1jZ`<@Nj/347b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d0
0a61[A61[Q61[P034H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<B
R;024XV`00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>
/P034hjb4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd
0a>E]@<DU[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM
]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<E
Y;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d3
5jfm00<G[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_`8H
]<001<SPf8S0^8S0^8S0^0H00004R<2h00=8T8P00038h=P00XS0^0030000
R<2hR<2h00F8`;P01@0008S0^8S0^4R@R00000026;C000C8h=R8`;R8`;R8
`;P2000018S0^0800002R<2h00A8T8P0000H]<0H]<02R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h0`00P00?VjOaooooVHnnUhZle=?XkjbcogIkkYn[
FeRUYY_4UYoBH4bJ_;SMoooo<d>U00<008001oooo`01P001P001P?ooo`02
P?ooo`0300>100Koool01840187oool01H7oool200J200Soool01h801h81
1h;oool128;oool128<30@V300Woool12X?oool12h?oool12hCoool138Co
ool00P4=Q004oooo0@j5oooo0@j50P8?Q@04oooo0Q25oooo0Q25108AQP<2
4XH20Q>600@24hL258L258L258L30QF70P8FQ`040aJ80aN80aN80aN80`<H
R0030aV80aV90aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;
0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DX
SP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A
1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP02
1cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8
?YH323nF0PQ0UP04242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4
V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK
0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN
00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aL
X@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=
HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>
JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?
LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[
0a1jZ`<@Nj/347b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61
[Q61[P034H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`
00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb
4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<D
U[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh
5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj
0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G
[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_`8H]<000lSP
f8S0^8S0^00;R<2h00=8T8P00038h=P00XS0^0030000R<2hR<2h00F8`;P0
1@0008S0^8S0^4R@R00000026;C000?8h=R8`;R8`;P00XS0^0800002R<2h
0P0000>8`;P014R@R00001Rd`1Rd`0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;P2002000ZKYo7ooonGR[ajK:ZcanRYKZ38`mnCQKYKAY>ISkh2N6F^
00A29hF_YL[ooolc@jD400200`01P003oooo00:000:100Coool200B100?o
ool01H7oool00`06PPCoool00`48PP48P`48P`030@V300Woool12X?oool1
2h?oool12hCoool138Coool00P4=Q004oooo0@j5oooo0@j50P8?Q@03oooo
0Q25oooo00?oool20Q660`8BQP824hH0108CQ`8DQ`8DQ`8DQ`<25HL20QJ7
00@35XP35hP35hP35hP30aR800<36HP36HT36HT010<JR@<36hT30ab:0`<M
RP<47XX311n;0`@PR`<48H/312:<10@SS00412B<12B=12B=12F=0PDUS@<5
9Xd00`DWS@DWSPDWSP031BR>0`DYSP031BZ>1BZ?1BZ?00<5:hl41Bb?0`H]
T0<6;Y021Rn@00@6;i46<946<946<9431S6A0PHbT@041S:B1S>B1S>B1S>B
0PHdTP031cBB1cFB1cFB0087=I<31cJC0`LgT`031cRC1cRD1cRD00<7>I@3
1cZD0`LkU@<8?9D323fE10PnUP<8?iH2242F00@8@9L8@IL8@IL8@IL324:G
0PQ3U`042D>H2DBH2DBH2DBH0`U5V0032DJH2DJI2DJI00@9AiT32DRI0`U9
VP<9BYX32T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`010YAW0YAW@YAW@YBW@8;
DYd32e>M00<;E9d;E9h;E9h00`]EWP<;EYh00`]GWP]GW`]GW`032eRO10]I
W`<<FZ0335^P0PaLX00435bQ35fQ35fQ35fQ0`aNX@8<Gj4010aOXPaPXPaP
XPaPXP8<HJ800`eQXPeRXPeRXP023F:S0`eSX`<=I:<00`eUX`eUY0eUY003
3FJT0`eWY0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]YP043VfW3VjW3VjW3VjW
0`i_Y`8>L:L010m`Z0maZ0maZ0maZ0<?LZP00`mcZ0mcZ@mcZ@043gBY0`me
Z@<?MZX33gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`447f/00@@OZ`@OZd@OZd@
Ojd24Gn]0a60[@034H6]4H6^4H6^00<APZh34H>^00<AQ:hAQ:lAQ:l00a65
[`@AQZl34XN`0a:8/08BRK0011:9/A::/A::/A::/@<BRk424Xba00@BS;8B
SK8BSK8BSK824Xjb00<CS[8CSk8CSk800Q>?/`<CT;<34i6c00<CT[<CT[@C
T[@00a>C]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI]P8DV[H011BJ]aBK]aBK
]aBK]`<DW;L259fg00@EWKPEW[PEW[PEW[P35Inh00<EX;PEX;TEX;T011FQ
^@<EX[T35J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/35ZVl11JZ_0045Z^l5Z^m
5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn0aN`_P035k6n5k6o5k6o
00<G/[l35k>o0QRd`003b>3HR<2hR<2h00^8`;P00dR@R0000<SPf002R<2h
00<00028`;R8`;P01HS0^0050000R<2hR<2hB9280000008H]<000lSPf8S0
^8S0^003R<2h100000B8`;P014R@R00001Rd`1Rd`0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;P2002000>KYo7oooooool00_ooo`0:ojf`ogIknLgD
oNg^ooooYY_4QGJ`_;SMoooo<d>U1@00P0<00H000oooo`02P002P@0300>1
00?oool0187oool00P05P@0400F2oooo00J200J20P07PP030@N2oooo0@R2
008128<3oooo0P4:P`07oooo0@^3oooo0@^4oooo0@b4oooo00813H@01?oo
o`4>QOooooooo`823hD01_ooo`8@QOooo`8@Q@8AQ_ooo`824HH30Q:60P8C
QP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<I
R0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`4
12><00@498`498d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>
00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`
T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7
=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`Po
UP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH
00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/3
2TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN
0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<
GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R3F:R008=
HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[
YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X
0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/3
47^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh0
0a62[P<APjh00a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa
4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?
/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG
]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN
^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/3
5ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn
5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/kl26;C000?8h=R8`;R8
`;P02hS0^003B9280000b>3H00:8`;P00`0008S0^8S0^005R<2h00D00028
`;R8`;Q8T8P000000QRd`003b>3HR<2hR<2h00B8`;P200001HS0^004B928
00006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^0<008002Z6/
l_W=e>8V??Be_n8V??A]OOcSjOoooog]k_n]/0;oool00c=3Y@00P000P004
00200`01P003oooo00:000:100?oool200B100Goool01H401H401H;oool0
0P06PP?oool20@R200<128?oool12H<00P49P`812X<01?ooo`4;P`4;Q?oo
o`8138@01oooo`4=Q04=Q?ooo`4>QOooo`4>Q@02oooo00<23hD248D248D0
1?ooo`040Q660Q:60Q:60Q:60P8CQP040Q>70QB70QB70QB70`8EQ`825XL0
10<FR0<GR0<GR0<GR0<368P00`<IR0<IR@<IR@040aZ90`<KR@<378X30af:
0`@NRP<47h/3122;0`@QR`<48X`412><00@498`498d498d49Hd21BF=0`DV
S@031BN=1BN>1BN>00<5:8h31BV>00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@
0`H^T086;i0010H_T@H`T@H`T@H`T@<6<I421S:A00@6<Y86<i86<i86<i82
1SBB00<7=987=I87=I800PLeT`<7=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7
>Y@31c^E0`PlU@<8?ID423jF0`PoUP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL2
24>G00@9@iP9A9P9A9P9A9P32DFH00<9AYP9AYT9AYT010U7V@<9B9T32DVJ
0`U:VP<:BiX32TbK0`Y=V`<:CY/32TnL10Y@W0042U6L2U6M2U6M2U:M0P]B
W@<;Did00`]DW@]DWP]DWP032eFN0`]FWP032eNN2eNO2eNO00<;F9l42eVO
0`aJX0<<Fj0235bP00@<G:4<GJ4<GJ4<GJ4335jQ0PaOX@0435nR362R362R
362R0PaQXP033F6R3F:R3F:R008=HZ<33F>S0`eTX`033FFS3FFT3FFT00<=
IZ@33FNT0`eXY@<>JJD33VZU10i[YP<>K:H23VfV00@>KJL>KZL>KZL>KZL3
3VnW0Pi`Y`043g2X3g6X3g6X3g6X0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY
0`mfZP<?MjX347RZ0a1iZ`<@NZ/347^[0a1l[0@@OJ`0111n[11n[A1n[A1o
[@8AOjd34H2]00<APJdAPJhAPJh00a62[P<APjh00a64[Q64[a64[`034HF_
1166[`<BQk034XR`0Q:9/0044XVa4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=
/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?/P024hnc0a>@/`<CTK<00a>B/a>B]1>B
]0034i>d0a>D]0<CUKD359Je0aBG]@@DV;H359Vf0QBJ]P0459Zg59^g59^g
59^g0aBL]`8DWKL011FM^1FN^1FN^1FN^0<EWkP00aFP^1FP^AFP^@045J6i
0aFR^@<EXkX35JBj0aJU^P<FY[/35ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdF
ZkdF[;d25jbm0aN]_@035jjm5jjn5jjn00<G[kh35k2n00<G/KhG/KlG/Kl0
0aNb_`<G/kl26;C000?8h=R8`;R8`;P02hS0^003B9280000b>3H00:8`;P0
0`0008S0^8S0^005R<2h00D00028`;R8`;Q8T8P000000QRd`003b>3HR<2h
R<2h00>8`;P4000018S0^004B92800006;C06;C00XS0^058T8P100000000
18S0^<SPf8S0^8S0^08008003I^WlOg]k^8V??ken?N9UoARK_>P[_ARK_om
oon]/?cSjOoooc=3Y@0700200`01P003oooo00:000:100<00h4300B10P05
P@0400F200J200J200J20P07PP050@N20@R20@R2oooo0@R300<12H<30@Z3
00<12h<12h@12h@00`4<Q0<13H@30@j50`8?Q@<248D40Q660`8BQP824hH0
108CQ`8DQ`8DQ`8DQ`<25HL20QJ700@35XP35hP35hP35hP30aR800<36HP3
6HT36HT010<JR@<36hT30ab:0`<MRP<47XX311n;0`@PR`<48H/312:<10@S
S00412B<12B=12B=12F=0PDUS@<59Xd00`DWS@DWSPDWSP031BR>0`DYSP03
1BZ>1BZ?1BZ?00<5:hl41Bb?0`H]T0<6;Y021Rn@00@6;i46<946<946<943
1S6A0PHbT@041S:B1S>B1S>B1S>B0PHdTP031cBB1cFB1cFB0087=I<31cJC
0`LgT`031cRC1cRD1cRD00<7>I@31cZD0`LkU@<8?9D323fE10PnUP<8?iH2
242F00@8@9L8@IL8@IL8@IL324:G0PQ3U`042D>H2DBH2DBH2DBH0`U5V003
2DJH2DJI2DJI00@9AiT32DRI0`U9VP<9BYX32T^J0`Y<V`<:CI/32TjK0`Y?
W0@:D9`010YAW0YAW@YAW@YBW@8;DYd32e>M00<;E9d;E9h;E9h00`]EWP<;
EYh00`]GWP]GW`]GW`032eRO10]IW`<<FZ0335^P0PaLX00435bQ35fQ35fQ
35fQ0`aNX@8<Gj4010aOXPaPXPaPXPaPXP8<HJ800`eQXPeRXPeRXP023F:S
0`eSX`<=I:<00`eUX`eUY0eUY0033FJT0`eWY0<=J:D33VVU0`iZY@@>JjH3
3VbV0Pi]YP043VfW3VjW3VjW3VjW0`i_Y`8>L:L010m`Z0maZ0maZ0maZ0<?
LZP00`mcZ0mcZ@mcZ@043gBY0`meZ@<?MZX33gNZ0a1hZP<@NJ/347Z[0a1k
Z`<@O:`447f/00@@OZ`@OZd@OZd@Ojd24Gn]0a60[@034H6]4H6^4H6^00<A
PZh34H>^00<AQ:hAQ:lAQ:l00a65[`@AQZl34XN`0a:8/08BRK0011:9/A::
/A::/A::/@<BRk424Xba00@BS;8BSK8BSK8BSK824Xjb00<CS[8CSk8CSk80
0Q>?/`<CT;<34i6c00<CT[<CT[@CT[@00a>C]0<CU;@34iFe0aBF]@<DUkD4
59Rf0aBI]P8DV[H011BJ]aBK]aBK]aBK]`<DW;L259fg00@EWKPEW[PEW[PE
W[P35Inh00<EX;PEX;TEX;T011FQ^@<EX[T35J>j0aFT^P<FYKX35ZJk0aJW
^`<FZ;/35ZVl11JZ_0045Z^l5Z^m5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^_QN^
_P035jnn0aN`_P035k6n5k6o5k6o00<G/[l35k>o0QRd`003b>3HR<2hR<2h
00^8`;P00dR@R0000<SPf002R<2h00<00028`;R8`;P01HS0^0050000R<2h
R<2hB9280000008H]<000lSPf8S0^8S0^002R<2h0P0000:8`;P200000hS0
^004B92800006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^080
08000i^WlOK8c>8V?002ojf`00OO92koY9kf_<Go[K3^Nhcooolc@jD02000
P0<00H000oooo`02P002P@0300>10`04P@801H401005PP06PP06PP06PP80
1h801@47PP48PP48P_ooo`48P`030@V300Coool12X<12X<12h<20@^40`4<
Q0<13H@30@j50`8?Q@<248D40Q660`8BQP824hH0108CQ`8DQ`8DQ`8DQ`<2
5HL20QJ700@35XP35hP35hP35hP30aR800<36HP36HT36HT010<JR@<36hT3
0ab:0`<MRP<47XX311n;0`@PR`<48H/312:<10@SS00412B<12B=12B=12F=
0PDUS@<59Xd00`DWS@DWSPDWSP031BR>0`DYSP031BZ>1BZ?1BZ?00<5:hl4
1Bb?0`H]T0<6;Y021Rn@00@6;i46<946<946<9431S6A0PHbT@041S:B1S>B
1S>B1S>B0PHdTP031cBB1cFB1cFB0087=I<31cJC0`LgT`031cRC1cRD1cRD
00<7>I@31cZD0`LkU@<8?9D323fE10PnUP<8?iH2242F00@8@9L8@IL8@IL8
@IL324:G0PQ3U`042D>H2DBH2DBH2DBH0`U5V0032DJH2DJI2DJI00@9AiT3
2DRI0`U9VP<9BYX32T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`010YAW0YAW@YA
W@YBW@8;DYd32e>M00<;E9d;E9h;E9h00`]EWP<;EYh00`]GWP]GW`]GW`03
2eRO10]IW`<<FZ0335^P0PaLX00435bQ35fQ35fQ35fQ0`aNX@8<Gj4010aO
XPaPXPaPXPaPXP8<HJ800`eQXPeRXPeRXP023F:S0`eSX`<=I:<00`eUX`eU
Y0eUY0033FJT0`eWY0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]YP043VfW3VjW
3VjW3VjW0`i_Y`8>L:L010m`Z0maZ0maZ0maZ0<?LZP00`mcZ0mcZ@mcZ@04
3gBY0`meZ@<?MZX33gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`447f/00@@OZ`@
OZd@OZd@Ojd24Gn]0a60[@034H6]4H6^4H6^00<APZh34H>^00<AQ:hAQ:lA
Q:l00a65[`@AQZl34XN`0a:8/08BRK0011:9/A::/A::/A::/@<BRk424Xba
00@BS;8BSK8BSK8BSK824Xjb00<CS[8CSk8CSk800Q>?/`<CT;<34i6c00<C
T[<CT[@CT[@00a>C]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI]P8DV[H011BJ
]aBK]aBK]aBK]`<DW;L259fg00@EWKPEW[PEW[PEW[P35Inh00<EX;PEX;TE
X;T011FQ^@<EX[T35J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/35ZVl11JZ_004
5Z^l5Z^m5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn0aN`_P035k6n
5k6o5k6o00<G/[l35k>o0QRd`003b>3HR<2hR<2h00^8`;P00dR@R0000<SP
f002R<2h2@0000:8`;P01DR@R00001Rd`1Rd`<SPf003R<2h0P0000B8`;P2
00000XS0^004B92800006;C06;C00XS0^058T8P10000000018S0^<SPf8S0
^8S0^08008000i^WlOW=e?N9U`02oooo00Oo[K3Q5SCoMW_oY9kR9ScoRGlc
@jD02000P0<00H000oooo`02P002P@0300>10`04P@801H401005PP06PP06
PP06PP801h801047PP48PP48PP48P`Coool30@Z300<12h<12h@12h@00`4<
Q0813H@01?ooo`4>Q@4>Q@4>Q@<23hD30Q25108AQP<24XH20Q>600@24hL2
58L258L258L30QF70P8FQ`040aJ80aN80aN80aN80`<HR0030aV80aV90aV9
00@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;0`@RS0@48h`010@T
S0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DXSP<5:Hh00`DZSPDZ
S`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A1S2A0`HaT@86
<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC0`LfT`<7=i<0
0`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH323nF0PQ0UP04
242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9AIP00`U6V0U6
V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L
00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;EIh32eJN00<;
Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aMX@aMX@aMX@<<
GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<3
3FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>
KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP33g:X00<?
LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/
111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61[P034H:^0a63
[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@BRK4BR[4BR[4B
R[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008CSk<3
4i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D359Ne11BH]P<D
VKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO
^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk
0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h00aN_
_P<G/;h00aNa_QNa_aNa_`035k:o0aNc_`8H]<000lSPf8S0^8S0^00;R<2h
00=8T8P00038h=P00XS0^0T00002R<2h00E8T8P0000H]<0H]<38h=P03HS0
^004B92800006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^080
08001i^WlOoooo>P[_ARK_ooooN9UoW=e002oooo00?cX:kooolc@jD02000
P0<00H0200:000@00X400h400h400h4300B10P05P@0400F200J200J200J2
0P07PP030@N20@R20@R2008128<30@V30`4:P`030@^30@^40@^400<138@3
0@f40`4>Q@<23hD30Q25108AQP<24XH20Q>600@24hL258L258L258L30QF7
0P8FQ`040aJ80aN80aN80aN80`<HR0030aV80aV90aV900@36XT30a^90`<L
RP<37HX311j:0`@OR`<488/3126;0`@RS0@48h`010@TS0@TS@@TS@@US@85
9Hd31BJ=00<59hd59hh59hh00`DXSP<5:Hh00`DZSPDZS`DZS`031B^?10D/
S`<6;I031Rj@0PH_T0041RnA1S2A1S2A1S2A0`HaT@86<Y4010HbTPHcTPHc
TPHcTP86=9800`LdTPLeTPLeTP021cFC0`LfT`<7=i<00`LhT`LhU0LhU003
1cVD0`LjU0<7>iD323bE0`PmU@@8?YH323nF0PQ0UP04242G246G246G246G
0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6V@042DNI0`U8
V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:
DYd22e:M0`]CW@032eBM2eBN2eBN00<;EIh32eJN00<;Eih;Eil;Eil00`]H
W`@;FIl335ZP0`aKX08<G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<
H:8<H:8<H:82366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=
IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^
Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?LjT010md
Z@<?MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/111m[00447j/47j]
47j]47n]0Q5o[@<AP:d00a61[A61[Q61[P034H:^0a63[P034HB^4HB_4HB_
00<AQJl44HJ_0a:7/0<BR;024XV`00@BRK4BR[4BR[4BR[434X^a0Q:</@04
4Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008CSk<34i2c0a>A/`034i:c
4i:d4i:d00<CTk@34iBd0a>E]@<DU[D359Ne11BH]P<DVKH259Zf00@DV[LD
VkLDVkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i
00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[
_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h00aN__P<G/;h00aNa_QNa
_aNa_`035k:o0aNc_`8H]<000lSPf8S0^8S0^00;R<2h00=8T8P00038h=P0
3HS0^005B92800006;C06;C0b>3H00f8`;P014R@R00001Rd`1Rd`0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;P3002000^KYo7oooooRGooooocX:ka
Tj7ooooooOocX:kono`c@jD02000P0<00H0200:000@00X400h400h400h43
00B10P05P@0400F200J200J200J20P07PP030@N20@R20@R2008128<30@V3
0`4:P`030@^30@^40@^400<138@30@f40`4>Q@<23hD30Q25108AQP<24XH2
0Q>600@24hL258L258L258L30QF70P8FQ`040aJ80aN80aN80aN80`<HR003
0aV80aV90aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;0`@R
S0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DXSP<5
:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A
1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC
0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH3
23nF0PQ0UP04242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9
AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>
V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;
EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aM
X@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ80
0PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD4
3V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?
LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1j
Z`<@Nj/347b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61
[P034H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@B
RK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb
4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D3
59Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh
5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV
^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG
[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_`8H]<0?b>3H00<0
0038h=S8h=P03LSPf00300006;C06;C000o8h=P00`0001Rd`1Rd`002R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h1000P0>KYo401_oooo>P[_Be_oJl
aO_IfS=3Y@T0080300600P02P00400:100>100>100>10`04P@801H401005
PP06PP06PP06PP801h800`47PP48PP48PP020@R30`49P`<12X<00`4;P`4;
Q04;Q0030@b40`4=Q0<13XD30Pn50`8@Q@@24HH30Q:60P8CQP040Q>70QB7
0QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<IR0<IR@<IR@04
0aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`412><00@498`4
98d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>00<5:Xh5:Xl5
:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`T@<6<I421S:A
00@6<Y86<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7=Y<31cNC00<7
>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`PoUP88@9H010Q0
U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH00<9AYP9AYT9
AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/32TnL10Y@W004
2U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN0`]FWP032eNN
2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<GJ4<GJ4335jQ
0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R3F:R008=HZ<33F>S0`eT
X`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[YP<>K:H23VfV
00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X0`mbZ0033g>X
3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/347^[0a1l[0@@
OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh00a62[P<APjh0
0a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa4XZa4XZa4XZa
0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?/P024hnc0a>@
/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG]@@DV;H359Vf
0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN^1FN^0<EWkP0
0aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/35ZNk0aJX^`<F
ZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn5jjn00<G[kh3
5k2n00<G/KhG/KlG/Kl00aNb_`<G/klf6;C00XS0^058T8P10000000018S0
^<SPf8S0^8S0^1H0080300600P02P00400:100>100>100>10`04P@801H40
1005PP06PP06PP06PP801h800`47PP48PP48PP020@R30`49P`<12X<00`4;
P`4;Q04;Q0030@b40`4=Q0<13XD30Pn50`8@Q@@24HH30Q:60P8CQP040Q>7
0QB70QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<IR0<IR@<I
R@040aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`412><00@4
98`498d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>00<5:Xh5
:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`T@<6<I42
1S:A00@6<Y86<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7=Y<31cNC
00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`PoUP88@9H0
10Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH00<9AYP9
AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/32TnL10Y@
W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN0`]FWP03
2eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<GJ4<GJ43
35jQ0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R3F:R008=HZ<33F>S
0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[YP<>K:H2
3VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X0`mbZ003
3g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/347^[0a1l
[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh00a62[P<A
Pjh00a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa4XZa4XZa
4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?/P024hnc
0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG]@@DV;H3
59Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN^1FN^0<E
WkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/35ZNk0aJX
^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn5jjn00<G
[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/klf6;C00XS0^058T8P100000000
0hS0^<SPf8S0^03oR<2hohS0^7f8`;P1B9280@00000000>8`;S8h=R8`;P0
ohS0^?n8`;QmR<2h0DR@R04000000003R<2hb>3Hb>3H0?o8h=Sob>3HOLSP
f058T8P10000003oR<2hohS0^868`;P100000000\
\>"], "Graphics",
  ImageSize->{640, 480},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:00001h2000`400?l00000o`00003oooo`l?3o
oo3`l8;ol?3`003ooo3`l?ool?3`P_o`l?000?ool?3`ooo`l?22oo3`l000ooo`l?3ooo3`l8;ol?3`
003ooo3`l?ool?3`P_o`l?000?ool?3`ooo`l?22oo3`l000ooo`l?3ooo3`l8;ol?3`003ooo3`l?oo
l?3`P_o`l?000?ool?3`ooo`l?22oo3`l000ooo`l?3ooo3`l8;ol?3`003ooo3`l?ool?3`P_o`l?00
0?ool?3`ooo`l?22oo3`l000ooo`l?3ooo3`l8;ol?3`003ooo3`l?ool?3`P_o`l?000?ool?3`ooo`
l?22oo3`l000oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h00?ooi^KVoooVi^J2onKViP00
ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP00oooVi^KoonKV
iX;oi^KV003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^003o
onKVi_ooi^KVP_oVi^H00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^
P_o^k^h00?ooi^KVoooVi^J2onKViP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?oo
k^k^ooo^k^j2onk^kP00oooVi^KoonKViX;oi^KV003oonk^k_ook^k^P_o^k^h00?oooooooooooon2
ooooo`00ooo^k^koonk^kX;ok^k^003oonKVi_ooi^KVP_oVi^H00?ook^k^ooo^k^j2onk^kP00oooo
oooooooooh;ooooo003oonk^k_ook^k^P_o^k^h00?ooi^KVoooVi^J2onKViP00ooo^k^koonk^kX;o
k^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP00oooVi^KoonKViX;oi^KV003oonk^
k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^003oonKVi_ooi^KVP_oV
i^H00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h00?ooi^KV
oooVi^J2onKViP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^
kP00oooVi^KoonKViX;oi^KV001monk^k/SoRXZ:ooo^k^hlonk^kP00OOooooo8ogmoOooooooo??oo
ool007gok^k^00?oOgmoooooooooool0]Oooool00ooIfMWoooooooooo`0<ooooo`03ogmoOoo^k^ko
k^k^0?ook^k^>_o^k^h007goi^KV00?oOgmoooooooooool0]Oooool01?oIfMWooooooooooooUiND3
ooooo`05onGUiOoooooooooooooooooUiND00oooool00omoOgooi^KVonKViP3oonKViS[oi^KV001m
onk^kP03ogmoOooooooooooo0;Gooooo00gofMWIoooooooJf][oSHf=onGUiOoooooof][Johf=SOoU
iNGoooooom[Jf_n=SHgoiNGU00;ooooo00?oOgmoonk^k_o^k^h0ooo^k^hjonk^kP00OOooool00omo
Ogooooooooooo`2eooooo`0@omWIfOooooooooooom[Jf_n=SHgoiNGUoooooooJf][oSHf=onGUiOoo
oooof][Johf=SOoUiNGoooooogmoOooooooo??ooool007gok^k^00?oOgmoooooooooool0]Oooool0
3OoIfMWooooooooooooooooof][Johf=SOoUiNGoooooom[Jf_n=SHgoiNGUoooooooJf]X00_ooool0
0omoOgook^k^onk^kP3oonk^kS[ok^k^001monKViP03ogmoOooooooooooo0;Gooooo00?ofMWIoooo
ooooool00_ooool01ooJf][oSHf=onGUiOoooooof][Johf=SOoUiND00oooool00omoOgooi^KVonKV
iP3oonKViS[oi^KV001monk^kP03ogmoOooooooooooo0;Gooooo00?ofMWIooooooooool00oooool0
1ooJf][oSHf=onGUiOoooooof][Johf=SOoUiND00_ooool00omoOgook^k^onk^kP3oonk^kS[ok^k^
001mooooo`03ogmoOooooooooooo0;Gooooo00?ofMWIooooooooool01?ooool02OoJf][oSHf=onGU
iOoooooog=cLohf=SOoUiNGoooooogmoO`3ooooooccooooo001monk^kP03ogmoOooooooooooo0;Go
oooo00?ofMWIooooooooool01Oooool01OoJf][oSHf=onGUiOoooooog=cL00;ooooo00?oOgmoonk^
k_o^k^h0ooo^k^hjonk^kP00OOoVi^H00omoOgooooooooooo`2eooooo`03omWIfOoooooooooo00Ko
oooo00?og=cLohf=SOoUiND00oooool00omoOgooi^KVonKViP3oonKViS[oi^KV001monk^kP03ogmo
Oooooooooooo0;Gooooo00?ofMWIooooooooool01oooool00ooLg=coSHf=onGUi@02ooooo`03ogmo
Ooo^k^kok^k^0?ook^k^>_o^k^h007gooooo00?oOgmoooooooooool0]Oooool00ooIfMWooooooooo
o`08ooooo`05omcLg?n=SHgoiNGUoooooomoOgl0oooooollooooo`00OOo^k^h00omoOgoooooooooo
o`2eooooo`03omWIfOoooooooooo00Wooooo00Cog=cLooooooooooooOgmoooo^k^hlonk^kP00OOoV
i^H00omoOgooooooooooo`2eooooo`03omWIfOoooooooooo00cooooo00?oOgmoonKVi_oVi^H0oooV
i^HjonKViP00OOo^k^h00omoOgooooooooooo`2eooooo`oofMWI00?oOgmoonk^k_o^k^h0ooo^k^hj
onk^kP00OOooool00omoOgooooooooooo`34ooooo`03ogmoOooooooooooo0?oooooo>_ooool007go
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001monKViP03ogmo
OooVi^Koi^KV0<Coi^KV00?oOgmoonKVi_oVi^H0oooVi^HjonKViP00OOo^k^h00omoOgook^k^onk^
kP34onk^kP03ogmoOoo^k^kok^k^0?ook^k^>_o^k^h007gooooo00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`3ooooooc[ooooo001monk^kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoonk^
k_o^k^h0ooo^k^hjonk^kP00OOoVi^H00omoOgooi^KVonKViP34onKViP03ogmoOooVi^Koi^KV0?oo
i^KV>_oVi^H007gok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
001ToooooaWoRXZ:00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo001T
onk^kQ[oOgmoa_o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001TonKViP03ogmoOooooooooooo
01Kooooo00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV001Tonk^kP03
ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[o
k^k^001Tooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoooooo
ooooo`3ooooooc[ooooo001Tonk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^
k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001TonKViP03ogmoOooooooooooo01Kooooo00?oOgmo
onKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV001Tonk^kP03ogmoOooooooooooo
01Kooooo00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001Tooooo`03
ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[o
oooo001Tonk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP3oonk^kS[ok^k^001TonKViP03ogmoOooooooooooo01Kooooo00?oOgmoonKVi_oVi^H0a?oV
i^H00omoOgooi^KVonKViP3oonKViS[oi^KV001Tonk^kP03ogmoOooooooooooo01Kooooo00?oOgmo
onk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001Tooooo`03ogmoOooooooooooo
01Kooooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo001Tonk^kP03
ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[o
k^k^001TonKViP03ogmoOooooooooooo01Kooooo00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KV
onKViP3oonKViS[oi^KV001Tonk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^
k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001Tooooo`03ogmoOooooooooooo01Kooooo00?oOgmo
ooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo001Tonk^kP03ogmoOoo^k^kok^k^
01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001TonKViP03
ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[o
i^KV001Tonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP3oonk^kS[ok^k^001Tooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?oo
ool00omoOgooooooooooo`3ooooooc[ooooo001Tonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmo
onk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001TonKViP03ogmoOooVi^Koi^KV
01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV001Tonk^kP03
ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[o
k^k^001Tooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoooooo
ooooo`3ooooooc[ooooo001;onk^kQWoRXZ:00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP34onk^kP03ogmoOoo^k^kok^k^0?ook^k^>_o^k^h004_oi^KV6_moOglHonKViP03ogmoOooVi^Ko
i^KV0<Coi^KV00?oOgmoonKVi_oVi^H0oooVi^HjonKViP00Boo^k^h00omoOgooooooooooo`0Foooo
o`03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^
kS[ok^k^001;ooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgoo
ooooooooo`34ooooo`03ogmoOooooooooooo0?oooooo>_ooool004_ok^k^00?oOgmoooooooooool0
5_ooool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoonk^k_o^k^h0
ooo^k^hjonk^kP00BooVi^H00omoOgooooooooooo`0Fooooo`03ogmoOooVi^Koi^KV01Koi^KV00?o
OgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV001;onk^kP03ogmoOooooooo
oooo01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP34onk^kP03ogmoOoo^k^ko
k^k^0?ook^k^>_o^k^h004_ooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Foooo
o`03ogmoOooooooooooo0<Cooooo00?oOgmoooooooooool0ooooooljooooo`00Boo^k^h00omoOgoo
ooooooooo`0Fooooo`03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo
k^k^onk^kP3oonk^kS[ok^k^001;onKViP03ogmoOooooooooooo01Kooooo00?oOgmoonKVi_oVi^H0
5_oVi^H00omoOgooi^KVonKViP34onKViP03ogmoOooVi^Koi^KV0?ooi^KV>_oVi^H004_ok^k^00?o
Ogmoooooooooool05_ooool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^0<Cok^k^00?o
Ogmoonk^k_o^k^h0ooo^k^hjonk^kP00Boooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooo
oooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo001;onk^
kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP34onk^
kP03ogmoOoo^k^kok^k^0?ook^k^>_o^k^h004_oi^KV00?oOgmoooooooooool05_ooool00omoOgoo
i^KVonKViP0FonKViP03ogmoOooVi^Koi^KV0<Coi^KV00?oOgmoonKVi_oVi^H0oooVi^HjonKViP00
Boo^k^h00omoOgooooooooooo`0Fooooo`03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0
a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001;ooooo`03ogmoOooooooooooo01Kooooo00?o
Ogmoooooooooool05_ooool00omoOgooooooooooo`34ooooo`03ogmoOooooooooooo0?oooooo>_oo
ool004_ok^k^00?oOgmoooooooooool05_ooool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^ko
k^k^0<Cok^k^00?oOgmoonk^k_o^k^h0ooo^k^hjonk^kP00BooVi^H00omoOgooi^KVonKViP0FonKV
iP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKV
iS[oi^KV001;onk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgoo
k^k^onk^kP34onk^kP03ogmoOoo^k^kok^k^0?ook^k^>_o^k^h004_ooooo00?oOgmoooooooooool0
5_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo0<Cooooo00?oOgmoooooooooool0
ooooooljooooo`00Boo^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^001;onKViP03ogmoOooVi^Ko
i^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP34onKViP03ogmoOooVi^Ko
i^KV0?ooi^KV>_oVi^H004_ok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^
kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoonk^k_o^k^h0ooo^k^hjonk^kP00Boooool00omoOgoo
ooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoo
ooooooooo`3ooooooc[ooooo001;onk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0
5_o^k^h00omoOgook^k^onk^kP34onk^kP03ogmoOoo^k^kok^k^0?ook^k^>_o^k^h003;oi^KV6On:
RXX00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oV
i^H00omoOgooi^KVonKViP3oonKViS[oi^KV000bonk^kQ[oOgmo6?o^k^h00omoOgook^k^onk^kP0F
onk^kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoonk^k_o^k^h0ooo^k^hjonk^kP00<_ooool00omo
Ogooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omo
Ogooooooooooo`34ooooo`03ogmoOooooooooooo0?oooooo>_ooool003;ok^k^00?oOgmooooooooo
ool05_ooool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000bonKViP03ogmoOooooooooooo01Kooooo
00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV0<Coi^KV
00?oOgmoonKVi_oVi^H0oooVi^HjonKViP00<_o^k^h00omoOgooooooooooo`0Fooooo`03ogmoOoo^
k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP34onk^kP03ogmoOoo^
k^kok^k^0?ook^k^>_o^k^h003;ooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0F
ooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3o
oooooc[ooooo000bonk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h00omo
Ogook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoonk^k_o^k^h0ooo^k^hjonk^
kP00<_oVi^H00omoOgooooooooooo`0Fooooo`03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oV
i^H05_oVi^H00omoOgooi^KVonKViP34onKViP03ogmoOooVi^Koi^KV0?ooi^KV>_oVi^H003;ok^k^
00?oOgmoooooooooool05_ooool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^
00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000booooo`03ogmoOooo
oooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooo
oooooooo0<Cooooo00?oOgmoooooooooool0ooooooljooooo`00<_o^k^h00omoOgooooooooooo`0F
ooooo`03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP34
onk^kP03ogmoOoo^k^kok^k^0?ook^k^>_o^k^h003;oi^KV00?oOgmoooooooooool05_ooool00omo
Ogooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omo
Ogooi^KVonKViP3oonKViS[oi^KV000bonk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^
k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoonk^k_o^
k^h0ooo^k^hjonk^kP00<_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo
00?oOgmoooooooooool05_ooool00omoOgooooooooooo`34ooooo`03ogmoOooooooooooo0?oooooo
>_ooool003;ok^k^00?oOgmoooooooooool05_ooool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^
k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000b
onKViP03ogmoOooooooooooo01Kooooo00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0F
onKViP03ogmoOooVi^Koi^KV0<Coi^KV00?oOgmoonKVi_oVi^H0oooVi^HjonKViP00<_o^k^h00omo
Ogook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omo
Ogook^k^onk^kP34onk^kP03ogmoOoo^k^kok^k^0?ook^k^>_o^k^h003;ooooo00?oOgmooooooooo
ool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooooooo
ool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000bonk^kP03ogmoOoo^k^kok^k^01Kok^k^
00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^0<Cok^k^
00?oOgmoonk^k_o^k^h0ooo^k^hjonk^kP00<_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooV
i^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP34onKViP03ogmoOooV
i^Koi^KV0?ooi^KV>_oVi^H003;ok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0F
onk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3o
onk^kS[ok^k^000booooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omo
Ogooooooooooo`0Fooooo`03ogmoOooooooooooo0<Cooooo00?oOgmoooooooooool0ooooooljoooo
o`00<_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^
k^h05_o^k^h00omoOgook^k^onk^kP34onk^kP03ogmoOoo^k^kok^k^0?ook^k^>_o^k^h003;oi^KV
00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV
00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kQWoRXZ:00?o
Ogmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Ioooooa[oOgmo6?ooool0
0omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooooooooooo01Ko
oooo00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmo
Oooooooooooo01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgoooooooooo
o`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoooooooooo
o`3ooooooc[ooooo000Ionk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooooooooooo01Kooooo00?oOgmoonKV
i_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOooooooooooo01Ko
oooo00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo
000Ionk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000IonKViP03ogmoOooooooooooo01Kooooo00?oOgmoonKVi_oVi^H05_oVi^H0
0omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmo
Oooooooooooo01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000IonKViP03ogmoOooooooooooo01Kooooo00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKV
iP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKV
iP3oonKViS[oi^KV000Ionk^kP03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool0
0omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgoooooooooo
o`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoooooooooo
o`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H0
0omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKV
iP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKV
iP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool0
0omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgoooooooooo
o`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoooooooooo
o`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H0
0omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKV
iP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKV
iP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool0
0omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgoooooooooo
o`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoooooooooo
o`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H0
0omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKV
iP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKV
iP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool0
0omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgoooooooooo
o`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoooooooooo
o`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H0
0omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^
000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKV
iP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKV
iP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool0a?ooool00omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^
kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool0
0omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgook^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oPH61onk^k_o^k^h0a?o^k^h00on1PH7ok^k^onk^kP3oonk^kS[ok^k^
000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgoooooooooo
o`0Fooooo`03ogmoOooooooooooo01Kooooo00?oQ8B4ooooooooool0a?ooool00on4Q8Cooooooooo
o`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oQXJ6onk^k_o^k^h0a?o^k^h0
0on6QXKok^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oRHV9onKV
i_oVi^H0a?oVi^H00on9RHWoi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oRh^;onk^k_o^k^h0a?o^k^h00on;Rh_ok^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmo
Oooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmo
Oooooooooooo01Kooooo00?oSXj>ooooooooool0a?ooool00on>SXkoooooooooo`3ooooooc[ooooo
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oT92@onk^k_o^k^h0a?o^k^h00on@T93ok^k^onk^
kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H0
0omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oTi>ConKVi_oVi^H0a?oVi^H0
0onCTi?oi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oUIFEonk^
k_o^k^h0a?o^k^h00onEUIGok^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Ko
oooo00?oV9RHooooooooool0a?ooool00onHV9Soooooooooo`3ooooooc[ooooo000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oVYZJonk^k_o^k^h0a?o^k^h00onJVY[ok^k^onk^kP3oonk^kS[ok^k^
000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKV
iP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oWIfMonKVi_oVi^H0a?oVi^H00onMWIgoi^KVonKV
iP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oWinOonk^k_o^k^h0a?o^k^h0
0onOWiook^k^onk^kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oXZ:Roooo
ooooool0a?ooool00onRXZ;oooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oY:BTonk^k_o^k^h0a?o^k^h00onTY:Cok^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oYjNWonKVi_oVi^H0a?oVi^H00onWYjOoi^KVonKViP3oonKViS[oi^KV
000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oZJVYonk^k_o^k^h0a?o^k^h00onYZJWok^k^onk^
kP3oonk^kS[ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool0
0omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?o[:b/ooooooooool0a?ooool0
0on/[:coooooooooo`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o[Zj^onk^
k_o^k^h0a?o^k^h00on^[Zkok^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?o/K6aonKVi_oVi^H0a?oVi^H00ona/K7oi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?o/k>conk^k_o^k^h0a?o^k^h00onc/k?ok^k^onk^kP3oonk^kS[ok^k^
000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgoooooooooo
o`0Fooooo`03ogmoOooooooooooo01Kooooo00?o][Jfooooooooool0a?ooool00onf][Kooooooooo
o`3ooooooc[ooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o^;Rhonk^k_o^k^h0a?o^k^h0
0onh^;Sok^k^onk^kP3oonk^kS[ok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?o^k^kogmo
OomoOgl0a?moOgl00onk^k_oi^KVonKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00Go_Kfmon_[jooVi^Koh^;RomkNgP04omgMg@?og]kN0:oogMgMomkNg_oMgMgog]kNomgMgOoN
g]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oM
gMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoN
g]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oM
gMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oN
g]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oM
gMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoN
g]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMojNWYomaLG;oE5ADofQXJ?nc/k?ogMgMomkNg_oM
gMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoN
g]kogMgMomkNg_oMgMko`l?3ofe]KOoGemOogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oM
gMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoN
g]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oM
gMgog]kNomgMgOoNg]kogMgM00?og]kN00?ogMgMomkNg_oNg]h00ooMgMd01?oQhN7oinOWon[Zj_nm
_Kgoonk^kScok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool0
0omoOgooooooooooo`0Fooooo`03oh61POoooooooooo01Kooooo00Co`<30onc/k?oVi^Koh>3P1ooI
fMT01?oHf=Soe]KFom?Cdoo@d=03olg=c@04om3@d?oCdm?oemOGomSHf0_ofMWI00Cof=SHomOGeooC
dm?od=3@0oo=cLd01?o@d=3odm?ComOGeooHf=P;omWIf@04omSHf?oGemOodm?Com3@d0?ocLg=00Co
d=3@om?CdooGemOof=SH<OoIfMT01_mdM7CoI6ATohb<S?mDE5Co2@T9oinOWaCofMWI00?oeMGEoaPH
6?n<S8`0:ooIfMT00ooHf=SofMWIomWIf@06omWIf@04omkNg_oVi^Kok>c/ol30`?oooooo??ooool0
01Wok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^
01Kok^k^00?oQ8B4onk^k_o^k^h05_o^k^h02?o2`/;ok^k^onWYjOoTi>Coh>3Pon7QhOoPh>3oh^;R
0_oQhN403OoNg]kog=cLom?Cdoo7alOo^k^kok:b/_n^[Zko/[:bok^k^oo7alOodm?Com_KfooOgml0
2OoQhN403OoOgmoofm_Kom?Cdoo7alOo^k^kok:b/_n^[Zko/[:bok^k^oo7alOodm?Com_KfooOgml0
2OoQhN403OoOgmoofm_Kom?Cdoo7alOo^k^kok:b/_n^[Zko/[:bok^k^oo7alOodm?Com_KfooOgml0
:_oQhN400oo@d=3ogmoOon7Qh@02omOGe`GohN7Q00?oCdm?ochn?_oQhN403OoQhN400oo@d=3ogmoO
on7Qh@02omOGe`;ohN7Q00?oNWYjocHf=_oQhN401OoQhN400ooGemOoc<c<on7Qh@0Ton7Qh@03on;R
h_oQhN7oh^;R00CohN7Q00Coi>CTonWYjOo]kNgo`/;2ooo^k^hlonk^kP006OoVi^H00omoOgooi^KV
onKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00on6QXKoi^KV
onKViP0FonKViP04olG5aOo`l?3okno_oo7al@?ol?3`05Ookno_oo3`l?o^k^kojNWYom_Kfoo1`L7o
Y:BTohb<S?mkNg_oMgMgog]kNon<S8coY:BTol;2`OoJf][oj^[Zong]kOoalO7okno_oo7alOo_knoo
lO7_ono_kooalO7okNg]on[Zj_oJf][o`/;2ojBTY?n<S8_oNg]kogMgMomkNg_oS8b<ojBTY?o2`/;o
f][Jon[Zj?o]kNgolO7aono_kooalO7okno_oo7alOo_knoolO7_ong]kOoZj^[of][Jol;2`_nTY:Co
S8b<og]kNomgMgKoNg]kohb<S?nTY:Co`/;2om[Jf_oZj^[okNg]oo7akoo_knoolO7aono_kooalO7o
kno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoo
lO7aono_kooalO7okno_oo7akolb<S800_l000008?l71`Oo;2`/ofa/K?oShn?olO7_ono_kooalO7o
>c/kogQhN?o_knoolO7aono_kom<C4_o1`L7oaPH6?nBTY;o4A4Aoe5ADOoalO7of=SHoeMGEole=CGo
Lg=coi>CTolL71cokno_oo7alOo_knoolO7_ono_kooalO7o<S8b1?l00000?olf=SKokno_oda<C?l7
1`Oo61PHoi:BT_lA4A7oDE5Aoo7akoo_knooRHV9o`000?o;bl_okno_oo7alOo_knoof][HodE5AOl2
0P;o820PoaDE5Ond];ColO7aoc/k>omhN7Ookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_
knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooa
lNookno_oo7alOo_knoolO7aono_kooalO7ol?3`ono_koo`l?3okno_oo3`l?o_knool?3`ono_k`04
oo3`l003olG5aOoVi^Koi^KV0?ooi^KV>_oVi^H001Wok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omo
Ogook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oRHV9onk^k_o^k^h05_o^k^h01?o7
alOol_;bonk^k_oWinL4onGUi@0@onCTi?oOgmoodM7Aok6a/On:RX[oIVIVoe5ADOm5ADGo@T92odE5
AOmADE7oIVIVohZ:ROna/K7odM7AomkNgP;oi>CT00?oiNGUonCTi?oUiN@00_oTi>@03ooNg]kodM7A
ok6a/On:RX[oIVIVoe5ADOm5ADGo@T92odE5AOmADE7oIVIVohZ:R_na/K7odM7@omkNgP02onCTi02<
onGUiOoTi>CoiNGUonCTi?oTi>?og]kNom7AdOna/K7oRXZ:ofIVI_mADE7oADE5od92@_m5ADGoDE5A
ofIVI_n:RX[o/K6aom7AdOoNg]koi>CSonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGT
oc0`<?mXJ6Soi>CTomcLg?nf][Ko?CdmoadM7OoGemKoi>CTonGUiOli>CWoLW9bonCTi?oUiNGo/K6a
o`<30oo5aLGoc/k>oe5ADOl?3`ooi>CTonGUiOm4A4Co:BTYoi2@T?m_Kfoo:2PXoa4A4OoTi>CoiNGU
onCTi?oUiNCoi>CTonGUiOl`<33oJ6QXonCTi?oUiNGoi>CTonGUi?na/K7o0`<3olG5aOo>c/koDE5A
o`l?3ooTi>CoiNGTonCTi?lZ:R[o20P8ofEUIOoTi>CoiNGUonCTi?lm?Cco>CTiolS8b?oTi>Cof][J
omSHf?oUiNGo>CTiog9bLOoTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGU
onCTi?oUiNGoi>CTonGUiOoTi>@4onGUi@08onCTi?oUiNGoiNGUonGUiOoXj>SokNg]oo;bl_o7alOo
onk^kScok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omo
Ogooooooooooo`0Fooooo`03oh^;Rooooooooooo01Kooooo00Cob/[:ooCdm?o]kNgoinOW0_oPh>00
4ooQhN7ogmoOomkNg_oBd];o];BdohN7QomLG5coKC/eoii>@_o=KeoojH=_ole_GonNCT?oKC/foeaL
G?n7QhOo];Bdom;Bd_oNg]h01OoPh>004OoNg]kod];BokBd]?n7QhOoG5aLofeP;?nNURkocLdoonWY
COo=cCooWYX_ofeS;OmLG5coQhN7okBd]?oBd];og]kN00Goh>3P017og]kNom;Bd_nd];CoQhN7oeaL
G?m7IbkoJ9hcoi7=AonZjEGoTLe7ofZN=?m9JRooG5aLohN7Qond];Cod];BomkNgP07on3Ph003oooo
oon8R8SoA4A400KoA4A400?o<c<codA4A?m4A4@00om4A4@01?nIVIWoh>3Pobl_;omUIFD3on3Ph003
om_KfolK6a_oHf=S00;oh>3P00ko>3Phofm_KooPh>3oh>3Pokjn__l20P;oYZJVon3Ph?n;Rh_o71`L
on3Ph?oHf=So1`L7oj:RXP;oh>3P00?oPh>3o`h>3_oPh>001OoPh>000ol_;booIFEUon3Ph003on3P
h006okjn__l20P;oYZJVon3Ph?n;Rh_o71`L0_oPh>002Onc/k?o0000oh^;Rol@413ofMWIon3Ph?o2
`/;o0000oj6QX@05on3Ph003ocPh>?m_Kfooh>3P01goh>3P00?ogmoOon3Ph?oOgml00_oOgml3on3P
h005on7QhOoWinOok>c/ooCdm?o:b/X0oooooollooooo`006Oo^k^h00omoOgook^k^onk^kP0Fonk^
kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00on>SXkok^k^onk^kP0Fonk^
kP04olc<c?ofm_Kol_;bon_[j`?oj>SX01?oinOWon;Rh_o=cLgoWinOof]OGon?=RkokG5QooVMT?om
/JGooKb_oofdYooiWi?okGASoi8g;om[GeooWinOolg=cOoRh^;oinOW00?oj>SX01?oinOWon;Rh_o=
cLgoWinOofiVGonCLR;okM54ooWcM?omoHgooOfEoogmS_oin7KokMM7oi=c8_m^IeooWinOolg=cOoR
h^;oinOW00?oj>SX01?oinOWon;Rh_o=cLgoWinOof1XGom;O2?oT^5;okgiNoo@oI;of?fKomCmUOo0
nGkoV>Q=odf09?mPJEooWinOolg=cOoRh^;oinOW00Koj>SX00?oooooodA4A?mVIVH00omgMgL00omV
IVKoMgMgogMgM`05ogMgM`05oc<c<oo<c<coj>SXoc4a<OmYJFT01?oXj>P01_m`L73o7QhNonSXj?oX
j>So>SXjog=cL`?oj>SX00WoWIfMobd];Ol^;Rko<C4aoadM7OoXj>So/;2`o`000?oAdM400_oXj>P0
0onLW9co3`l?onSXj005onSXj003oc4a<OmYJFWoj>SX00Coj>SX00GoWIfMobd];Ol^;Rko<C4aoadM
7@02onSXj009oemOGolk>c_oj>SXob@T9?nEUIGoj>SXojb/[?l0003o=cLg00?o>CTi00Co/[:bonSX
j?lj>S[oLg=c9ooXj>P01?o/k>col_;booKfm_o<c<coonk^kScok^k^000IonKViP03ogmoOooVi^Ko
i^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03oi2@T?oVi^Ko
i^KV01Koi^KV00?oclo?ooOgmoohn?P01?ohn?P04oogmoOok^k^olk>c_n@T93oQBl[onUTE_okTXOo
oZJKoojaYOoo^:_oo[>VoojXW?okU8WokVQIohTa:on@T93oc/k>onk^k_ogmoL00oohn?P04oogmoOo
k^k^olk>c_n@T93oVFT[oo2m?Ookh6koo_B2ooknR_oooi;oo_j<ookhPookiG3ol<8noiUZ:on@T93o
c/k>onk^k_ogmoL00oohn?P04oogmoOok^k^olk>c_n@T93o@W<[ohC>@on]kg?o`_j8olknT?oFoiOo
d?jBolKnROnbmGCoR==3odAe:on@T93oc/k>onk^k_ogmoL01_ohn?P03?oooooo<c<conk^k_o^k^ko
^k^kogMgMonZZZ[oooooonk^k_oMgMgoMgMgomgMg@;ok^k^00GoMgMgolc<c?ohn?So=3@dog1`L004
ooShn006oiVIVOl20P;ol_;booShn?ln?SkoIVIV1Oohn?P01oofm_KoShn?ob0P8?ohn?Soe=CDo`00
0?n`/;000_ohn?P00onWYjOo410@ooShn005ooShn003oc@d=?m`L73on?Sh00Kon?Sh01Gom_Kfohn?
SolP823on?Shono_kol>3PkoWIfMooShn?n<S8co?3`looShn?oDe=Co0000ojJVY_o9bLWo`L71o`82
0_oNg]kon?Shochn?_mVIVH08?ohn?P00oogmoOon?ShooShn002ooShn006ooOgmooinOWomoOgooOg
moohn?Soclo?oooVi^HlonKViP006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^
01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00onCTi?ok^k^onk^kP0Fonk^kP04om7AdOojn_[omOGe
onk^kP;ok>c/04cojn_[onWYjOoOgmoo^[ZjogUBD_no<RCoigAYoof9O_ooV8cooZ:FoonXW?onY9So
oiZ=ooj:Ooo^MV[o`c<TogUBD_nj^[[ogmoOon[Zj_o[jn_ok>c/on_[k?oZj^[ogmoOokZj^_n8IE;o
hY4LooW3D?omfV?oonYbookcO_oonX;oo_Ioooo/LoongVCon/MAon:B7?n9IU?o^[ZjomoOgooZj^[o
jn_[onc/k?o[jn_oj^[ZomoOgonj^[[oDVeBoe6S7?nAdUGoY^MZokSiN_o0oX;oaon9ol?nQ?nioG_o
Yna/oiCFEomBYQcoDVeBokZj^_oOgmooj^[Zon_[joo/k>cojn_[onc/k?o[jn_ok>c/oooooolc<c?o
ooooonk^k_mgMgOo03?<0_lc<`00I_m4A4Co<`0co`008_mV06KoMgMgoooooomgMgOo^k^kon_[k?la
<C7oJVYZonc/k?o[jn_ok>c/on_[jon5QHGo10@4onSXj?o[jn_o>c/koa4A4On6QXKod];Bon[Zj_nU
YJKobLW9onSXj?mIFEWoCDe=onc/k?o[jn_o=SHfod10@?oAdM7og]kNodm?Col?3`ook>c/on_[joo/
k>cojn_/onc/k?o[jn_o<C4aofYZJ_o/k>cojn_[onc/k?o[jncok>c/ojFUYOo9bLWoj>SXoeUIFOm=
CDgok>c/oiJFU_l<30cohN7Qonc/k?oKfm_o20P8olK6a_o/k>co>SXjof=SHooShn?oTY:BobLW9oo/
k>cojn_[oc/k>olA4A7oQXJ6om;Bd_o/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[
jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/
k>cojn_[onc/k0Oojn_[00Ook>c/on_[joo[jn_ok^k^ooKfm_oinOWodM7A0?ook^k^??o^k^h001Wo
oooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Ko
oooo00?oUIFEooooooooool05_ooool01?oDe=Cono_koo?cloo]kNd2onGUi@18onKVi_oTi>CofMWI
ok:b/_mi;Rkob48don=ZG?odNVgooHQloojGR_onVhkooYR;ooj:O_odNfgoif]MolY2=?mk;Rko/[:b
omSHf?oTi>CoiNGUonKVi_oUiNKoi>CTomSHf?nb/[;oUUD^onZL:ook_4Coo/aCoogHH_onhg;oo^Ue
ookVLoonffGooLaCoo_1AOo^WR_oVEH^ok:b/_oHf=Soi>CTonGUiOoVi^KoiNGUonCTi?oHf=Wo/[:b
obiR;_mS[B_oQlY8oiOLFOnUiFWo/_=gokSfNondmGWoYnY[oiSLFOn9cd_oHjh[obiS;_nb/[;of=SI
onCTi?oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_ooooooMgMg0_o^k^h0JomVIVKo06Koo`1Vc?m4A4Co
<`0coc<c<omgMgOo<`0cohR8R?o^k^koIVIVolc<c?oUiNKo<30`ofQXJ?oVi^KoiNGUonKVi_oUiNGo
BDU9obLW9ooVi^KoiNGUod];BomkNg_oDe=Co`P82?oHf=SoNg]lobd];Ol>3Pko<c<cok2`/?oVi^Ko
iNGUolc<c?lm?Cgo2@T9ob@T9?mZJV[o9BDUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUoc0`<?mXJ6So
i^KVonGUiOoVi^KoiNGVonKVi_mkNg_o;Bd]o`h>3_lc<c?o/;2`onKVi_m@D57oIFEUonGUiOoVi^Ko
iNGUof5QHOmgMgOoi^KVolk>com0@43o2`/;oaTI6OnTY:Coi^KVonGUiOm;Bd_oNg]koe=CDol820So
i^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^Ko
iNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGU00;oi^KV00?o
iNGUonKVi_oVi^H00ooVi^H01OoUiNGokNg]ooCdm?okno_oe=CD0?oooooo??ooool001Wok^k^00?o
Ogmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o
V9RHonk^k_o^k^h05_o^k^h01?oFe]Koo?clooShn?oalO43onk^kP0Con_[jooQhN7o_;blogXG5oo3
?c;odeI9onAXF_o_Mfcom8=iooR7O?oeQ7[olgU]onEYFooIF4[oa3lbog`G5onl_;cohN7Qonc/k003
onk^kP0Conc/k?oQhN7o_;blojE75ooVUc;omJ``oofl@OombE?ooM1Poo_CIOomdV3oo/eDoofm@_oj
[c;ojI/bojE65onl_;cohN7Qonc/k003onk^kP0Conc/k?oQhN7o_;bloaMI5omOZ3;oM[dgohK=AonF
eU[oX^1Uoj?PJOnShFOoUmYLohK>Aomg_cOoGj/boaMI5onl_;cohN7Qonc/k006onk^kP05oooooolc
<c?ok^k^omgMgOlA4A400_l0I_l03?lcI/co8R8RohR8R?nIVIWo8R8RomgMgOo^k^koMgMgolc<c?o^
k^ko<S8bofa/K0?ok^k^00?oU9BDo`000?nFUYH01Oo^k^h01Oo[jn_ok^k^onk^k_o^k^kok>c/00Ko
k^k^00?ok>c/onk^k_o^k^h01oo^k^h00olb<S;oK6a/onk^kP06onk^kP03onc/k?o^k^kok^k^00_o
k^k^00?ojn_[onk^k_o^k^h01Oo^k^h00oo[jn_ok^k^onk^kP0Ronk^kP05ong]kOobl_;on?Shoocl
o?oFe]H0ooo^k^hlonk^kP006OoVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H05_oVi^H00onJVY[oi^KVonKViP0FonKViP05omWIfOomoOgooOgmoogm
oOolo?`00_omoOd04oolo?colo?com7AdOmX1`Oo^3@dolLo<ooBD4?ofV9Eon=^H_oTLVCoi6mRomaT
EooCDD?oc44dokTd=?m[1`Ood];Boo?cloolo?`00oomoOd04oolo?colo?com;Bd_nN:`OofXXdon^K
6OoeZ2Won;@oooVmB_oh_dgon[m:ooVh?oofZR[okihIom^;=?nR;@Ood];Boo?cloolo?`00oomoOd0
4oolo?colo?com;Bd_l7@0OoCIXdoen[8?m`^2ooOl=3oh[=D?n=cE;oR/i@oh77A?ma^BooHZhPodjK
=?l7@POod];Boo?cloolo?`01_omoOd01_oooooo<c<conk^k_lc<c?o<`0co`004@;o8R8R017o03<c
oc<0<olA003o0000oc<c<onk^k_oMgMgok^k^oomoOgo=CDeobd];OmSHf?oCTi>ob`/;?l61PKoSHf=
ooclo00Joogmo@03ocDe=OmcLg?ooOgm03oooOgm00?oo?cloogmoOolo?`00oomoOd00ooIfMWoi^KV
onKViP3oonKViS[oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^
k^h00omoOgook^k^onk^kP0Fonk^kP03oifMWOo^k^kok^k^01Kok^k^03_ofm_KoogmoOojn_[olo?c
onk^k_o`l?3okno_onk^k_oYjNWodm?Coe/M7OnR=3Co]2PMol4j;Oo7BCcoceI:om1GBoo@Ed[obTXn
ol<k;_nf:1goXS@doe`M7OoCdm?oj^[Zonk^k_o`l?3okno_oo3`koo^k^koj^[Zom?Cdon<9Agob74d
omV47OoTU1GoiidTonjX<oo`ZSCokjXconbP9OoWUaGog8PMolQa=?n<9Agodm?Con[Zj_o^k^kol?3`
ono_koo`l?3ok^k^on[ZjOoCdm?o7CPMocB2=?m7UAgoFZDKofV]:P02ogBh>00AogFi>?m[/B_oFjLL
odRJ7OldPSCo7CPMom?CdooZj^Wok^k^oo3`l?o_knool?3`ono_koo`l?3okno_oooooomgMgL00_mV
<fH03_mgMgOoR8R8ofIVI_lc<`3o03?<o`1Vc?lc06Ko0000ofHcI_lc<c?oMgMgolc<c?o`l>ooY:BT
0_n@T900G?nHV9So]kNgomgMgOo_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>oo
kno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knoo
l?3_ono_koo`l?3oY:BTokbl_?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3o
kno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knoo
l?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3o
kno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knoo
l?3`ono_koo`l?3okno_0_o`l?06ono_k`04oo?clooinOWoo_knom_Kfoook^k^??o^k^h001Wooooo
00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo
00?oWinOooooooooool05_ooool01?oNg]koo_knooOgmoo`l?04onWYj@0AonOWiooKfm_oHd];oh4b
<_nV=CGo]S@]ol9=@Oo3E4Woa5E:ol=DBOo2CD7o]S@]ojDe=On1<S;oHd];om_KfooWinL01OoYjNT0
4OoWinOofm_KohU;Bon_Bc;ocGLeomJ;;OoPW2koh:0bon6P=?oPX3;ogiX^omJ;;Oo:MCGo[d/bohU;
BooKfm_oinOW00GojNWY017oinOWom_Kfom;Bd_o<V0bocZ9=OmCVbgoJj/_og2]>?m_[S[oL:dhofZZ
;omCVbgo>HPeoc9P<_m;Bd_ofm_KonOWi`07onWYj@09oooooom4A4Co<`0col`0c?mV<fKoIVIVoa40
0?nIIP3oc9T000;o06K<0_nI09T00onk^k_oMgMgolc<c01QonWYj@03onSXj?oYjNWojNWY00CojNWY
00Col?3`ooOgmoono_kog]kNoooooollooooo`006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00onRXZ;ok^k^onk^kP0Fonk^kP06on3P
h?ono_kon_[jooCdm?o_knoolO7a0_o`l?004Oo_knoojn_[oiFDU?m?8b?oUEADok]cLooCUIGofYbL
omZNW?oIW9coe9FEok]cLonEE5CoCb<SoiFDU?oZj^[okno_00Gol?3`017okno_on[Zj_nYU9CoPB<S
okYZE?oDVW?oi;bEon[7W?oYaicoj/NLonFlUOoDVW?o^fYDoh4S8onZU9Coj^[Zono_k`05oo3`l00A
ono_kooZj^[oU9BDob<Z8omDNUCoLjEcoik6UOn/cYco[LjLojc>W?nNaYGoLjEcoeAjE?lS:R?oU9BD
on[Zj_o_knl01oo`l?001?oooooo<c<colc<c?m4A4@2o`00000:oc<0<omVIP3ool`0oiUV0?mV06Ko
c03oofH0I_mV<fKoMgMgok^k^fKol?3`00KolO7aoo3`l?odm?Con_[jookno_oPh>3oonk^kScok^k^
000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKV
iP0FonKViP03ojBTY?oVi^Koi^KV01Koi^KV00Gohn?Sooclo?ooooooooooooknoP02ooooo`;oo_kn
04GooOgmooShn?m^KVkoFSlook6@T?oNbLWol>CToo?Vi_o`i>Cog/W9ok6@T?mJ?cooKFe]ooShn?ol
o?coooooookno_ooooooo_knooooo_ono_koooooooclo?ohn?SoSFe]ohXo?oo9TI3ojM39ooCYi?of
jnKom>WTonW@bOo9TI3oRCloohe]KOohn?Ooo?clooooooono_koooooookno_ooooooo_knooooo_ol
o?con?Shofe]KOlo?cooT9f@olWEbOoTk>Coi^kVonC/i?o9eLWoT9f@oclo?om]KFgon?Shooclo?oo
ookoo_knooooooono_koooooookno_ooooooo_knoooooomgMgL00_o^k^h00olR8R;oV@2IofHcIP02
ofH0IP1Yoc<0<onIIP3o4A4Aolc<c?o^k^koMgMgolc<c?ooookoo_knooooooono_koooooookno_oo
ooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooon
o_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_oo
ooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knooooooon
o_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_oo
ooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_on
o_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_oo
ooooo_kn00;ooooo00?oo_knooooooooool00oooool00oolo?cohn?SonKViP3oonKViS_oi^KV000I
onk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0F
onk^kP03ojNWYoo^k^kok^k^01Ook^k^00Com_Kfookno_ojn_[om?Cd1OoalO403Oo_knooe]KFof][
Jom3?CgoVhb<olJj^_oFc<coakZjoi^<S?m3?CgoJf][omKFe_o_knl02OoalO403Oo_knooemKFoh=[
Jomd?Cgo]Hb<omFj^_oQc<coe[ZjokJ<S?mb?CgoPF][omOFe_o_knl02OoalO403Oo_knooe]KFof][
Jolm?CgoS8b<okZj^_o<cLco^[Zjohb<S?lm?CgoJf][omKFe_o_knl02OoalO401_ooooooA4A4onk^
k_nIVIWo4A4AodA4A0;oc03<00CoV@2Io`0cI_o<V@3oMgMg0_o^k^h00omgMgOoc<c<oo7al@1Noo7a
l@04oo3`l?oalO7olO7aoo3`l0ColO7a00Com?Cdoo[jn_ono_kom_Kfooo^k^hmonk^kP006Oooool0
0omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool0
0onYZJWoooooooooo`0Gooooo`05onk^k_omoOgon?Shoo3`l?o[jn/00ooZj^X03OoYjNWoj^[ZonWY
jOoXj>SoVi^KoeUIFOlV9RKo2@T9obHV9_mIFEWoVi^KonSXj?oYjNT02ooZj^X02ooYjNWoj>SXoj2K
VomZFEWo@bHVobd92Om29RKoJEUIoj2KVooXj>SojNWY00_oj^[Z00_ojNWYonSXj?nKVi_oFEUIobHV
9_l92@Wo9RHVoeUIFOnKVi_oj>SXonWYj@0:on[ZjP09oooooolc<c?ok^k^ogMgMolc<c?oIVIVoc<c
<oo<0<coA4A400;o03=V00GoMgMgonk^k_o^k^koMgMgok^k^`1Von[ZjP05on_[joo`l?3on?Shoogm
oOo^k^h0oooooolmooooo`006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00on/[:cok^k^onk^kP0Gonk^kP04ono_koodm?Con_[jooCd
m0SolO7a0_o`l?03ono_k`;ol?3`3ooalO42oo3`l0?okno_0_o`l?0?oo7al@;ol?3`0oo_knl2oo3`
l0colO7a00?oooooogMgMoo^k^h00oo^k^h01_nk^k_oIS=Vooooooo^k^koVIVIohR8R0;ok^k^00?o
MgMgolc<c?oalO40HOoalO400oo`l?3olO7aoo7al@02oo7al@04ooGemOojn_[om?Cdono_koook^k^
?Oo^k^h001Woi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooV
i^Koi^KV01Koi^KV00?o[Zj^onKVi_oVi^H06?oVi^H00oo[jn_omOGeooooo`18ooooo`03oc<c<ooo
ooook^k^00[ok^k^00?oMgMgolc<c?ooool0Ioooool00ooemOGojn_[onKViP3oonKViSgoi^KV000I
onk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0F
onk^kP03ok6a/Oo^k^kok^k^01Wok^k^00Cokno_onk^k_ofm_KooOgmA_ooool00olc<c?oMgMgogMg
M`0;ogMgMfKooooo00CooOgmooKfm_o^k^kokno_ooo^k^hoonk^kP006Oooool00omoOgoooooooooo
o`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00onc/k?ooooooooo
o`0Loooookcohn?Soooooom2ooooo`006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^ko
k^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00onf][Kok^k^onk^kP34onk^kP03okJf]_o^k^ko
k^k^0?ook^k^Doo^k^h001Woi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKV
iP03ogmoOooVi^Koi^KV01Koi^KV00?o^;RhonKVi_oVi^H0a?oVi^H00onh^;Soi^KVonKViP3oonKV
iU?oi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgoo
k^k^onk^kP0Fonk^kP03ok^k^omoOgooOgmo0<CoOgmo00?o^k^konk^k_o^k^h0ooo^k^iConk^kP00
6Oooool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0
5_ooool01Onm_Kgol?3`onc/k?oYjNWoi^KV00CoiNGU0ooVi^H01OoUiNGoi^KVonGUiOoUiNGoi>CT
00;oiNGU01Coi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KV
onGUiOoVi^KoiNGUonKVi_oUiNKoiNGUonCTi0;oiNGU017oi^KVonGUiOoVi^KoiNGVonKVi_oUiNGo
i^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKViP02onGUi@1oonCTiOoUiNGo
iNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKo
i^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^Ko
iNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGo
i^KVokjn__o;bl_oiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^Ko
iNGUonKVi_nn_[kobl_;onGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGo
i^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVomWIfOna/K7o
h^;RonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGo
i^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVolC4a?oVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^Ko
iNGUonKVi_oUiNGoi^KVonGUi@03onKViP03onGUiOoVi^Koi^KV00?oiNGU00Coj>SXong]kOo_knoo
_KfmoooooomEooooo`006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^
00?oPH61onk^k_o^k^h05_o^k^h01?o0`<3ojn_[onOWiooRh^88omgMg@;ofm_K00OofMWIomSHf?oH
f=Sof=SHomWIfOoKfm_og=cL00gogMgM00?og=cLom_KfooIfMT00ooHf=P00ooIfMWofm_KomcLg00=
omgMg@03omcLg?oKfm_ofMWI00?of=SH00?ofMWIom_KfooLg=`0:ooMgMd00onFUYKo[Jf]omgMg@0=
omgMg@03oiJFU_n][JgogMgM01OogMgM00?ofm_KohV9ROnk^k/05OoMgMd00oo2`/;ogMgMomgMg@0:
omgMg@03omcLg?oMgMgogMgM00KogMgM00CohN7QonOWioo[jn_o`<30ooo^k^iEonk^kP006OoVi^H0
0omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oQ8B4onKVi_oVi^H05_oVi^H0
2?o2`/;ojn_[onOWiooShn?oh>3Pon7QhOoPh>3oh^;R0_oQhN403OoOgmooh>3Pom_KfooGemOodm?C
om3@d?o?clood=3@om?CdooGemOofm_KomoOgooPh>002OoQhN403OoPh>3ogmoOom_KfooGemOodm?C
om3@d?o?clood=3@om?CdooGemOofm_KomoOgooPh>002OoQhN403OoPh>3ogmoOom_KfooGemOodm?C
om3@d?o?clood=3@om?CdooGemOofm_KomoOgooPh>008ooQhN400ooIfMWof][Jon7Qh@03on7Qh@05
oiNGUon_[jooh>3PomOGeooPh>001?oQhN400ooOgmoof][Jon7Qh@04on7Qh@05oiNGUon_[jooh>3P
omOGeooPh>003ooQhN400ooIfMWoh>3Pon7Qh@02omcLg0;ohN7Q00?o];BdoiJFU_oQhN401OoQhN40
0ooLg=cof=SHon7Qh@0<on7Qh@03olW9bOoQhN7ohN7Q00cohN7Q00?oh^;Ron7QhOoRh^801?oQhN40
1?oShn?oinOWon[Zj_o2`/;oonKViUGoi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmo
onk^k_o^k^h05_o^k^h00on6QXKok^k^onk^kP0Fonk^kP04olG5aOo^k^kok^k^ono_k`Gok^k^083o
kNg]on_[jooVi^Kog]kNom?Cdoo;bl_oa<C4ol?3`oo4a<Cobl_;om?CdooOgmkoi^KVonc/k?o]kNgo
kno_onk^k_o_knook^k^ono_k_o^k^kokno_ong]kOo/k>coi^KVomoOgooCdm?obl_:olC4a?o3`l?o
a<C4ol_;booCdm?ogmoOonKVi_o/k>_okNg]ono_koo^k^kokno_onk^k_o_knook^k^ono_k_o]kNgo
k>c/onKVi_oOgmoodm?Col_;boo4a<Co`l?3olC4a?o;bl_odm?ComoOgooVi^Kok>c/ong]kOo_knko
k^k^ono_koo^k^kokno_onk^k_o_knook^k^ono_k_o^k^kokno_onk^k_o_knook^k^ono_koo^k^ko
kno^onk^k_o_knook^k^ono_koo^k^kokno_onk^k_o_knkoUYJFok>c/oo^k^kokno_onk^k_o_knoo
k^k^omoOg_nFUYKoQHF5ohB4Q?nHV9Sog]kNono_koo^k^koVi^JoinOWon?ShooRXZ:ohR8R?o@d=3o
kno_onk^k_oBd];oRXZ:oh:2P_nRXZ;o^KVioi>CToo_knook^k^oi^KV_nOWiooShn?ohZ:R_n8R8So
d=3@ono_koo^k^kokno^onk^k_o_knook^k^oiJFUPCoOgmo02koV9RHono_konRXZ;oPX:2ohZ:R_o3
`l?oQhN7ojFUY?o^k^kokno_okjn__moOgoog=cLono_koo^k^kokno^on?ShonOWiooP820ohj>S_n9
RHWodm?Conk^k_nKVi[o][Jfono_koo^k^kokno_onk^k_o_knook^k^ono_k_o^k^koeMGEonk^k_o_
knook^k^ono_koo^k^kokno^onk^k_o_knook^k^ono_koo^k^kokno_3?o^k^h00oo5aLGok^k^onk^
kP3oonk^kU?ok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool0
0on9RHWoooooooooo`0Fooooo`04olO7aooemOGol_;bong]k@Gojn_[067ojNWYon?ShooHf=SobLW9
okbl_?ne]KGo/;2`ojn_[on`/;3o]KFeokbl_?o9bLSoemOGon?ShooXj>Sojn_[on[Zj_o[jn_oj^[Z
on_[j_oZj^[ojn_[onSXj?oShn?oemOGolW9bOnl_;co]KFdok2`/?n_[joo/;2`okFe]Onl_;cobLW9
omOGeooShn;oj>SXon_[jooZj^[ojn_[on[Zj_o[jn_oj^[Zon_[j_oXj>Sohn?SomOGeoo9bLWo_;bl
okFe]On`/;3o[jn^ok2`/?ne]KGo_;blolW9bOoGemOohn?SonSXj?o[jn[oj^[Zon_[jooZj^[ojn_[
on[Zj_o[jn_oj^[Zon_[j_oZj^[ojn_[on[Zj_o[jn_oj^[Zon_[jooZj^[ojn_Zon[Zj_o[jn_oj^[Z
on_[jooZj^[ojn_[on[Zj_o[jn[oUIFEok6a/OoZj^[ojn_[on[Zj_o[jn_ojNWYoiFEU?nQXJ7ohn?S
on;Rh_nSXj?oUIFE00;oj^[Z053oVYZIoi^KVooTi>Coj>SXok>c/on6QXKoiNGUon[Zj_nRXZ;oY:BT
onOWioo1`L7oQHF5oi>CToo[jn_oj^[ZoiZJVOnKVi_oi>CTonSXj?nc/k?oQXJ6onGUiOoZj^[ojn_Z
on[Zj_o[jn_oj^[ZoiFEUOn_[joojn_[on[Zj_o[jn[oj^[Zom;Bd_n0P83og=cLomoOgonUYJGoQXJ6
on_[j_oZj^[ojn_[oi:BT_n2PX;o[Zj^on_[jooZj^[ojn_Zoi^KVonJVY[og=cLon_[jooTi>CoiNGU
on[Zj_nJVYWo];Bdon_[jooZj^[ojn_[on[Zj_o[jn_oj^[Zon_[j_oZj^[ocLg=on[Zj_o[jn_oj^[Z
on_[jooZj^[ojn_Zon[Zj_o[jn_oj^[Zon_[jooZj^[ojn_[on[ZjPCojn_[00Soj^[Zon_[joo[jn_o
jn_[ong]kOoalO7omOGeolO7aoooooooEOooool001Wok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omo
Ogook^k^onk^kP0Fonk^kP03oh^;Roo^k^kok^k^01Kok^k^00Cob/[:oo7alOo/k>coj>SX0_oRh^80
4ooShn?oh^;Ron7QhOoLg=cod];Bol;2`_nc/k?o]kNgol[:b_oLg=coiNGUomcLg?o:b/[o^;Rhok>c
/oo2`/;od];BomcLg?oQhN401OoRh^804OoQhN7og=cLom;Bd_o2`/;o/k>cokNg]oo:b/[og=cLonGU
iOoLg=cob/[:okRh^?nc/k?o`/;2om;Bd_oLg=cohN7Q00Goh^;R017ohN7QomcLg?oBd];o`/;2ok>c
/ong]kOob/[:omcLg?oUiNGog=cLol[:b_nh^;So/k>col;2`_oBd];og=cLon7Qh@07on;RhP03oooo
oon8R8SoA4A400KoA4A400?o<c<codA4A?m4A4@00om4A4@01?nIVIWoh^;Roi>CTon][Jd4on;RhP03
om;Bd_moOgooa/K600;oh^;R00Koa/K6ogmoOooDe=Coh^;RoiNGUon`/;02on;RhP06omSHf?moOgoo
`/;2on;Rh_n@T93o][Jf0_oRh^801_n^[ZkoTI6Aon;Rh_oRh^;oUiNGok2`/0;oh^;R00?of=SHogmo
Ooo2`/801OoRh^800onCTi?o[:b/on;RhP03on;RhP06om?Cdon0P83ob<S8on;Rh_nl_;coRh^;0_oR
h^802Oo>c/koOgmookbl_?n6QXKogmoOon;Rh_oDe=CoOgmoolK6aP05on;RhP03oiNGUon`/;3oh^;R
00Ooh^;R00?obLW9on;Rh_oRh^804_oRh^801OoShn?oj>SXon_[jooalO7ob/[:0?ook^k^EOo^k^h0
01Woi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ohj>S_oVi^Koi^KV
01Koi^KV00Coc<c<oo7alOo^k^kojNWY1?oVi^H01ooTi>Cog=cLolc<c?ni^KWo`/;2onGUiOo/k>`0
0oo]kNd01oo/k>coinOWol?3`onj^[[oc<c<omcLg?oTi>@01OoVi^H01ooTi>Cog=cLolc<c?ni^KWo
`/;2onGUiOo/k>`00oo]kNd01oo/k>coinOWol?3`onj^[[oc<c<omcLg?oTi>@01OoVi^H01ooTi>Co
g=cLolc<c?ni^KWo`/;2onGUiOo/k>`00oo]kNd01oo/k>coinOWol?3`onj^[[oc<c<omcLg?oTi>@0
1ooVi^H00oooooooA4A4ofIVIP03ogMgM`03ofIVI_mgMgOoMgMg00GoMgMg00Oo<c<colc<c?oVi^Ko
U9BDoj:RX_o?cloog]kN00;oi^KV00?obl_;ogmoOooKfm/00_oVi^H01_oKfm_oOgmoolc<c?oVi^Ko
V9RHok:b/P?oi^KV00GoQhN7okVi^OoVi^KoT92@okZj^P02onKViP06okRh^?nBTY;oi^KVonKVi_nH
V9So/[:b0ooVi^H00on7QhOo^KVionKViP04onKViP03oiBDU?n][Jgoi^KV00Coi^KV00Goa<C4oi>C
TonCTi?oU9BDoh^;R`02onKViP09ojVYZOnIVIWoi^KVohn?Soo1`L7oi^KVol_;bomoOgooUiNG00?o
V9RH00Coc/k>onKVi_nHV9So/[:b2?oVi^H00oo@d=3oi^KVonKViP0ConKViP04onWYjOo^k^kolO7a
olc<c?ooi^KVEOoVi^H001Wok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^
kP03oi2@T?o^k^kok^k^01Kok^k^00?oclo?ooCdm?odm?@01Oodm?@01_o`l?3oiNGUolo?coo9bLWo
j>SXoo;blP;om_Kf00WomoOgooKfm_ofm_Kom?Cdon[Zj_o9bLWoclo?onGUiOo`l?001Oodm?@01_o`
l?3oiNGUolo?coo9bLWoj>SXoo;blP;om_Kf00WomoOgooKfm_ofm_Kom?Cdon[Zj_o9bLWoclo?onGU
iOo`l?001Oodm?@01_o`l?3oiNGUolo?coo9bLWoj>SXoo;blP;om_Kf00WomoOgooKfm_ofm_Kom?Cd
on[Zj_o9bLWoclo?onGUiOo`l?001oodm?@03?oooooo<c<conk^k_o^k^ko^k^kogMgMonZZZ[ooooo
onk^k_oMgMgoMgMgomgMg@;ok^k^00coMgMgolc<c?odm?CoUiNGohb<S?n>SXkoOgmoojRXZ?o^k^ko
hn?SogmoOooAdM42ooCdm006om3@d?moOgooiNGUooCdm?nLW9co][Jf0_odm?@01_o[jn_oOgmoomSH
f?odm?CoTi>Col;2`P;om?Cd00Ko`<30oiFEUOodm?Com?CdoibLW?nf][H2ooCdm003on_[jomoOgoo
f=SH00Gom?Cd00?oUiNGokBd]?odm?@01_odm?@05Ooclo?o`/;2ohj>S_odm?Cokno_ohF5QOo9bLWo
m?Cdol71`OnKVi_om?Cdon?ShomoOgoocLg=omgMgOoJf][oP820onSXj?odm?CoW9bLojn_[`08ooCd
m003omgMgOodm?Com?Cd01;om?Cd00GomOGeooCdm?odm?Com?Cdolo?c`3oonk^kUGok^k^000Ioooo
o`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00onCTi?oooooooooo`0Foooo
o`04om7AdOokno_omoOgoo;blP?ol?3`00[okno_on_[jooNg]koa<C4omWIfOoWinOok^k^oo?clood
m?ComOGe0_odm?@01oo_knoojNWYom[Jf_o4a<Cog]kNon_[joo_knl00oo`l?002_o_knoojn_[omkN
g_o4a<CofMWIonOWioo^k^kolo?cooCdm?oemOD2ooCdm007ono_kooYjNWof][JolC4a?oNg]kojn_[
ono_k`03oo3`l00:ono_koo[jn_og]kNolC4a?oIfMWoinOWonk^k_oclo?om?CdooGem@;om?Cd00Oo
kno_onWYjOoJf][oa<C4omkNg_o[jn_okno_00Kol?3`00Kooooooc<c<oooooook^k^ogMgMol0<l`2
oc<c000FodA4A?lc03?o000RofH0I_mgMgOoooooogMgMonk^k_ol?3`oiJFU_nc/k?ol?3`omcLg?n4
Q8Co[Jf]oo3`l?nKVi_oWYjNon7QhOoPh>3oWYjNoifMW@;ol?3`00[oVi^KohZ:R_o1`L7oh>3Pojf]
[On6QXKok^k^oo3`l?nBTY;o`<300_o`l?002onn_[koU9BDoo3`l?o`l?3oVi^KohZ:R_o1`L7oh>3P
ojf][On6QXKok^k^00Gol?3`00?oUYJFok:b/_o`l?001?o`l?004oo>c/kogmoOonk^k_nYZJWoY:BT
oo3`l?o7alOoQHF5on_[joo`l?3oj>SXoh:2P_oNg]kol?3`oiZJV_n^[Zkok>c/olG5aOnBTY800_o`
l?001?nKVi_oQhN7okno_ooTi>@6oo3`l003omCDe?o`l?3ol?3`01?ol?3`00Col_;booShn?ojn_[o
dM7AoooooomEooooo`006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^
00?oUIFEonk^k_o^k^h05_o^k^h01?oDe=ComoOgoo7alOo/k>`2onKViP09onOWiooVi^Koh^;RomCD
e?nk^k_oe]KFomoOgooUiNGoi^KV00;ojn_[00Sok>c/onOWiooUiNGoh>3QomOGeonk^k_oe=CDon7Q
h@;oi^KV00[oinOWonKViooVi^KohN7QomCDe?nk^k_oe]KFomkNg_oUiNGoi^KW0_o[jn/02?o/k>co
inOWonGUiOoPh>3oemOGok^k^ooDe=CohN7Q0_oVi^H05?oWinOoi^KVonKVi_oQhN;oe=CDok^k^ooF
e]Kog]kNonGUiOoVi^Kojn_[on_[k?o/k>coinOWonGUiOoPh>3oemOGok^k^ooDe=CohN7R0_oVi^H0
1ooWinOoi^KVonOWiooVi^KoinOWoooooomgMgL00_o^k^h05_mVIVKo06Koo`1Vc?m4A4Co<`0coc<c
<omgMgOo<`0cohR8R?o^k^koIVIVolc<c?oVi^OoUIFEojn_[ooWinOoi^KVojVYZOn;Rh_oinOWomcL
gOnPX:02ohF5Q@1Coj2PX?oNg]koi^KVonOWionPX:7o]kNgojNWYon4Q8CoRHV9ol?3`ooVi^KoinOW
oiZJV_no_kooi^KVonOWionm_KgoVi^KonKVi_oWinOoX:2QokNg]onWYjOoQ8B4ohV9ROo3`l?oi^KV
onOWiooVi^OoinOWonKVi_oWinOoU9BDojj^[_oVi^KoinOWonKViooWinOoi^KVokNg]onCTi?oQHF5
oiJFU_o>c/koi^KWoj>SXon/[:coinOWonKVi_oWinOoZZZZokFe]OoVi^Oog=cLoi^KVon4Q8CoRXZ:
olW9bOoVi^KoinOWoj2PXOnf][KoY:BToh:2P_oVi^KoinOWonKVi_oWinOoi^KWonOWioo@d=3oinOW
onKVi_oWinOoi^KVonOWiooVi^OoinOWonKVi_oWinOoi^KVonOWiooVi^H00_oWinL00ooVi^KoinOW
onOWi`03onOWi`05onKVi_o/k>colO7aooOgmooDe=@0ooo^k^iEonk^kP006OoVi^H00omoOgooi^KV
onKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oV9RHonKVi_oVi^H05_oVi^H01?oFe]KomOGe
oo;bl_o]kNd3on_[j`08onWYjOoVi^KofMWIokfm_OoHf=SogMgMon?ShooVi^H3onWYj@08onOWiooS
hn?ogmoOomWIfOnm_KgofMWIonKVi_oZj^X3on_[j`08on[Zj_oVi^KofMWIokfm_OoHf=Sog]kNon?S
hooVi^H3onWYj@08onOWiooShn?ogmoOomWIfOnm_KgofMWIonKVi_oZj^X3on_[j`08on[Zj_oVi^Ko
fMWIokfm_OoHf=Sog]kNon?ShooVi^H3onWYj@08onOWiooShn?ogmoOomWIfOnm_KgofMWIonKVi_oZ
j^X6on_[j`05oooooolc<c?ok^k^omgMgOlA4A400_l0I_l03?lcI/co8R8RohR8R?nIVIWo8R8RomgM
gOo^k^koMgMgolc<c?o[jn_oUIFEok6a/@;ojn_[00?oW9bLoi^KVoo[jn/00_o[jn/2on[ZjPOojn_[
00?oj^[Zon_[joo[jn/03Oo[jn/00ooZj^[ojn_[on_[j`06on_[j`03oiFEUOn`/;3ojn_[00Kojn_[
00?oj^[Zon_[joo[jn/02oo[jn/00ooYjNWojn_[on_[j`05on_[j`03onWYjOo[jn_ojn_[00Cojn_[
00?of=SHon_[joo[jn/04_o[jn/01OoZj^[ok^k^oo;bl_oemOGoe]KF0?ooi^KVEOoVi^H001Wok^k^
00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03oiZJV_o^k^kok^k^01Kok^k^
00GofMWIooShn?ohn?Son?ShooOgm`03ooShn007ooCdm?oXj>So_Kfmom_KfooQhN7oi>CTonSXj003
on_[j`07onWYjOoUiNGoh^;RomcLg?nn_[kojNWYooCdm005ooShn007ooCdm?oYjNWo_Kfmom_KfooQ
hN7oi>CTonSXj003on_[j`07onWYjOoUiNGoh^;RomcLg?nn_[kojNWYooCdm005ooShn007ooCdm?oY
jNWo_Kfmom_KfooQhN7oi>CTonSXj003on_[j`07onWYjOoUiNGoh^;RomcLg?nn_[kojNWYooCdm007
ooShn006oooooolc<c?ok^k^oc<c<olc03?o000A0_lR8R803ol0<c?o<`0coa400?l0003o<c<cok^k
^omgMgOo^k^kooShn?nHV9SoUIFEojVYZOnATI7oOgmoom7Ad@0UooShn003oiRHV?nf][Kon?Sh02?o
n?Sh00?ohn?SooShn?ohn?P04?ohn?P00oogmoOon?ShooOgm`03ooShn003omWIfOo^k^kok^k^0?oo
k^k^Doo^k^h001Wooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03oifM
WOoooooooooo01Kooooo00Gofm_KoogmoOokno_om_Kfoo;blP03oo?cl`07oo7alOoXj>So];Bdom7A
dOoGemOog=cLomkNgP02on7Qh@08on;Rh_oOgmoog=cLomSHf?oAdM7o];BdonSXj?oalO45oo?cl`07
oo7alOoXj>So];Bdom7AdOoGemOog=cLomkNgP02on7Qh@08on;Rh_oOgmoog=cLomSHf?oAdM7o];Bd
onSXj?oalO45oo?cl`07oo7alOoXj>So];Bdom7AdOoGemOog=cLomkNgP02on7Qh@08on;Rh_oOgmoo
g=cLomSHf?oAdM7o];BdonSXj?oalO47oo?cl`0BoooooomgMgOoIS=VofHcI_mgMgOoR8R8ofIVI_lc
<`3o03?<o`1Vc?lc06Ko0000ofHcI_lc<c?oMgMgolc<c?oclo?oclo?0_o5aLD00oo=cLgohn?Soo?c
l`0Uoo?cl`03olo?cooIfMWolo?c02?olo?c00?of][Joo?clooclo<04ooclo<01?ofm_Kon_[jookn
o_oKfm_ooooooeGooooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^
k^h00onOWiook^k^onk^kP0Fonk^kP04omkNg_oinOWom?Cdonk^kPCojNWY00Koj>SXon?Shonb/[;o
_knoolc<c?oBd]82omOGe`09omSHf?oGemOoe]KFom;Bd_o;bl_o_[jnok6a/OoShn?oj>SX00GojNWY
00Koj>SXon?Shona/K7o_[jnolc<c?oBd]82omOGe`09omSHf?oGemOoe]KFom;Bd_o;bl_o_[jnok6a
/OoShn?oj>SX00GojNWY00Koj>SXon?Shona/K7o_[jnolc<c?oBd]82omOGe`09omSHf?oGemOoe]KF
om;Bd_o;bl_o_[jnok6a/OoShn?oj>SX00OojNWY00WoooooodA4A?lc03?oc03<ofHcI_mVIVKo4@00
oiUV0?o<V@000_l0I/`2oiT0V@03ok^k^omgMgOoc<c<05;ojNWY00?oeMGEonWYjOoYjNT03?oYjNT0
0ooXj>SojNWYonWYj@04onWYj@04onk^k_odm?ConOWiomkNg_ook^k^EOo^k^h001Woi^KV00?oOgmo
onKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03oj:RX_oVi^Koi^KV01Koi^KV00Koh>3P
ooOgmoodm?Cokno_onc/k?o]kNd3onc/k006on_[joo;bl_o[Jf]olW9bOoGemOohN7Q0ooShn<01_oQ
hN7oemOGolW9bOn][Jgobl_;on[ZjPOok>c/00Koj^[Zol_;bon][JgobLW9omOGeooQhN43on?Sh`06
on7QhOoGemOobLW9ojf][Oo;bl_oj^[Z1oo/k>`01_oZj^[obl_;ojf][Oo9bLWoemOGon7Qh@?ohn?S
00KohN7QomOGeoo9bLWo[Jf]ol_;booZj^X8onc/k004oooooolc<c?oc<c<odA4A0;o000000[o<`0c
ofIV0?ooc03oVFH0ofH0I_o<0?ooIP1VofHcI_mgMgOo^k^kD_o/k>`00ooKfm_ok>c/onc/k00Aonc/
k006ong]kOo/k>cokno_ooCdm?ogmoOoh>3PoooVi^IEonKViP006Oo^k^h00omoOgook^k^onk^kP0F
onk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oY:BTonk^k_o^k^h05_o^k^h01OoShn?onOWioo[jn_oj
n_[onOWi00;on_[j0ooinOT0A?ogmoOobLW9okfm_OoMgMgok^k^ooGemOofm_KomOGeonk^k_oMgMgo
_KfmolS8b?ogmoOon?Shoo[jn_oinOWon_[jooWinOojn_WonOWioo[jn_ohn?SomoOgolS8b?nm_Kgo
gMgMonk^k_oemOGom_KfooGemOo^k^kogMgMokfm_Oo8b<SomoOfooShn?ojn_[onOWioo[jn_oinOWo
n_[jooWinOojn_Won?ShooOgmoo8b<So_KfmomgMgOo^k^komOGeooKfm_oemOGok^k^omgMgOnm_Kgo
b<S8ooOgmoohn?Son_[iooWinOojn_[onOWioo[jn_oinOWon_[jooWinOooooooMgMg0_o^k^h00olR
8R;oV@2IofHcIP02ofH0IP1Yoc<0<onIIP3o4A4Aolc<c?o^k^koMgMgolc<c?ojn_WonOWioo[jn_oi
nOWon_[jooWinOojn_[onOWioo[jnOoinOWon_[jooWinOojn_[onOWioo[jn_oinOWon_[iooWinOoj
n_[onOWioo[jn_oinOWon_[jooWinOojn_WonOWioo[jn_oinOWon_[jooWinOojn_[onOWioo[jnOoi
nOWon_[jooWinOojn_[onOWioo[jn_oinOWon_[iooWinOojn_[onOWioo[jn_oinOWon_[jooWinOoj
n_WonOWioo[jn_oinOWon_[jooWinOojn_[onOWioo[jnOoinOWon_[jooWinOojn_[onOWioo[jn_oi
nOWon_[iooWinOojn_[onOWioo[jn_oinOWon_[jooWinOojn_WonOWioo[jn_oinOWon_[jooWinOoj
n_[onOWioo[jnOoinOWoj>SXooWinOojn_[onOWioo[jn_oinOWon_[iooWinOojn_[onOWioo[jn_oi
nOWon_[jooWinOojn_[onOWi00;on_[j00?onOWioo[jn_ojn_X00oojn_X00ooinOWohn?Sonk^kP3o
onk^kUCok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00onW
YjOoooooooooo`0Gooooo`04oo7alOono_kono_kooKfmPGom?Cd00golo?con[Zj_o5aLGo^KViomCD
e?oRh^;oj>SXon;Rh_oDe=Co^KViolG5aOoZj^[olo?c00Wom?Cd00golo?con[Zj_o5aLGo^KViomCD
e?oRh^;oj>SXon;Rh_oDe=Co^KViolG5aOoZj^[olo?c00Wom?Cd00golo?con[Zj_o5aLGo^KViomCD
e?oRh^;oj>SXon;Rh_oDe=Co^KViolG5aOoZj^[olo?c00Wom?Cd00KoooooodA4A?o^k^koVIVIoa4A
4Om4A4@2ol`0c004oiT0VOl0<fKoc9T0ogMgM`;ok^k^00?oMgMgolc<c?odm?@0DOodm?@00ooMgMgo
m?CdooCdm00:ooCdm004oo?cloodm?Com?Cdoo?cl`Com?Cd00Com_Kfoo_knoono_kolO7aoooooomF
ooooo`006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oZJVYonk^
k_o^k^h05oo^k^h01Oo/k>con?ShooCdm?o^k^kojn_[00?oj^[Z00cojNWYon[Zj_oZj^[ojNWYolg=
cOng]kOoYJFUoibLW?nUYJGo]kNgolg=cOoYjNT=on[ZjP09onWYjOo=cLgo]kNgojFUYOnLW9coYJFU
okNg]oo=cLgojNWY00goj^[Z00WojNWYolg=cOng]kOoYJFUoibLW?nUYJGo]kNgolg=cOoYjNT02ooZ
j^X02Ooooooo<c<conk^k_mgMgOo<c<cofIVI_lc<c?oc03<odA4A002o`0cIP05ogMgMoo^k^kok^k^
ogMgMonk^k/0D_oZj^X00ooIfMWoj^[Zon[ZjP0Aon[ZjP05on_[joo^k^kom?CdooShn?o/k>`0ooo^
k^iFonk^kP006OoVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?o[:b/
onKVi_oVi^H05ooVi^H01?oXj>Sol?3`ooCdm?o_knl:ong]k@?ok>c/4oo]kNd3onc/k1?okNg]0oo/
k>`>ong]k@03oooooomgMgOok^k^00?ok^k^00Ko^k^kofHcI_ooooook^k^oiVIVOn8R8P2onk^kP03
ogMgMoo<c<cokNg]057okNg]00?ogmoOong]kOo]kNd03Oo]kNd00oo/k>cokNg]ong]k@02ong]k@04
oo3`l?odm?Col?3`onSXj?ooi^KVE_oVi^H001Wok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgoo
k^k^onk^kP0Fonk^kP03ojj^[_o^k^kok^k^01Sok^k^00?ol?3`oo7alOojn_X0Aoojn_X00ooooooo
<c<cooooo`0;onk^kP03ogMgMoo<c<con_[j057on_[j00?oj^[Zoo[jn_ojn_X04oojn_X00ooalO7o
l?3`onk^kP3oonk^kUKok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0
5_ooool00ona/K7oooooooooo`0Jooooo`03onc/k?oalO7ooooo04Kooooo00?o<c<cogMgMomgMgL0
2omgMgMCooooo`03on_[jooooooooooo017ooooo00?olO7aonc/k?ooool0oooooomHooooo`006Oo^
k^h00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o/k>conk^k_o^k^h07?o^
k^jlon?Shoook^k^Foo^k^h001Woi^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0F
onKViP03okJf]_oVi^Koi^KV0<Coi^KV00?o][JfonKVi_oVi^H0oooVi^I/onKViP006Oo^k^h00omo
Ogook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o^;Rhonk^k_o^k^h0a?o^k^h00onh
^;Sok^k^onk^kP3oonk^kVcok^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?oOgmooooooooo
ool05_ooool00onk^k_oOgmoogmoO`34ogmoO`03ok^k^ooooooooooo0?ooooooK?ooool001Wok^k^
00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP05okfm_Oo[jn_oinOWonCTi?oQ
hN401?oPh>03on7Qh@05on3Ph?oQhN7oh>3Pon3Ph?oOgml00_oPh>005?oQhN7oh>3Qon7QhOoPh>3o
hN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Qon3PhOoPh>3o
gmoO0_oPh>004OoQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Qon3PhOoQ
hN7oh>3Pon7QhOoPh>3ohN7Q00;oh>3P07oogmoPon3Ph?oPh>3ohN7Qon3Ph?oQhN7oh>3Pon7QhOoP
h>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Qon3PhOoQhN7oh>3Pon7QhOoPh>3ohN7Qon3Ph?oQ
hN7oh>3Qon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoP
h>3ohN7Qon3PhOoQhN7oh>3Pon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Qon7QhOoPh>3ohN7Qon3Ph?oQ
hN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Qon3PhOoQhN7oh>3Pon7QhOoP
h>3ohN7Qon3Ph?oQhN7oh>3Qon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQ
hN7oh>3Pon7QhOoPh>3ohN7Qon3PhOoEeMGo[Zj^omkNg_oPh>3ohN7Qon3Ph?oQhN7oh>3Qon7QhOoP
h>3ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Qon3PhOoQ
hN7oa<C4on7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Qon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3P00?ohN7Q
00?oh>3Pon7QhOoQhN400ooPh>001?oShn?oj>SXon[Zj_nm_Kgoonk^kVkok^k^000IonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oPH61onKVi_oVi^H05_oVi^H01?o0`<3ojNWYonGUiOoPh>08om_Kf`;o
fMWI00OoemOGomKFe_oFe]Koe]KFomOGeooIfMWof][J00gofm_K00?of][JomWIfOoGemL00ooFe]H0
0ooGemOofMWIom[JfP0=om_Kf`03om[Jf_oIfMWoemOG00?oe]KF00?oemOGomWIfOoJf]X0E?oKfm/0
0ooIfMWoRHV9okZj^P0Fom_Kf`03ol;2`_oKfm_ofm_K00[ofm_K00?of][Jom_KfooKfm/01_oKfm/0
1?oOgmooiNGUonWYjOo0`<3oonKViVkoi^KV000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oQ8B4
onk^k_o^k^h05_o^k^h02?o2`/;okNg]onWYjOoUiNGoh^;Ron?ShooRh^;oi>CT0_oShn<03OoQhN7o
h^;RomgMgOoIfMWoeMGEom;Bd_oAdM7od];BomGEeOoIfMWogMgMon7QhOoRh^802OoShn<03OoRh^;o
hN7QomgMgOoIfMWoeMGEom;Bd_oAdM7od];BomGEeOoIfMWogMgMon7QhOoRh^802OoShn<03OoRh^;o
hN7QomgMgOoIfMWoeMGEom;Bd_oAdM7od];BomGEeOoIfMWogMgMon7QhOoRh^809ooShn<00ooKfm_o
g=cLon?Sh`04on?Sh`03on7QhOoIfMWohn?S00Gohn?S00?ofm_Kon;Rh_oShn<00_oNg]hAon?Sh`03
om_KfooRh^;ohn?S00;og]kN0_oShn<00one]KGoUiNGon?Sh`05on?Sh`03omkNg_oIfMWohn?S00go
hn?S00?obLW9on?ShooShn<03?oShn<00ooTi>Cohn?SonCTi004on?Sh`04onGUiOoYjNWok>c/ol;2
`_ook^k^K_o^k^h001Wooooo00?oOgmoooooooooool05_ooool00on6QXKoooooooooo`0Fooooo`04
olG5aOoclo?olo?cooCdm0Golo?c07ool_;boo3`l?o[jn_oh^;RomSHf?o?cloobLW9olO7aoo9bLWo
clo?omSHf?oShn;ojn_[oo7alOobl_;om?Cdoo?cloodm?Colo?cooCdlooclo?om?Cdoo;bl_oalO7o
jn_[on?ShooHf=Soclo>olW9bOo7alOobLW9olo?cooHf=Sohn?Son_[jooalO3ol_;booCdm?oclo?o
m?Cdoo?cloodm?Colo?cooCdloobl_;olO7aon_[jooShn?of=SHolo?coo9bLWoalO7olW9bOo?cloo
f=SHon?Shoo[jn_olO7aoo;bl_odm??olo?cooCdm?oclo?om?Cdoo?cloodm?Colo?cooCdlooclo?o
m?Cdoo?cloodm?Colo?cooCdm?oclo?om?Ccoo?cloodm?Colo?cooCdm?oclo?om?Cdoo?cloodm??o
UiNGol[:b_oclo?ojn_[olO7aooZj^[olo?comKFeOmoOgoom?Cdoo?clooShn?oUiNGohF5QOn4Q8Co
VIVHon?Shoodm?Colo?com;Bd_n5QHGoOgmooi>CToo2`/7oQXJ6ooCdm?oclo?oY:BToh:2P_n:RX[o
aLG5ohN7QonVYZKom?CdoibLW?ni^KWolo?cooCdm?oclo?om?Ccoo?cloodm?CoUiNG00CoOgmo02oo
VIVIoo?clonTY:CoPX:2ohZ:R_o5aLGoQhN7ojJVY_odm??olo?col71`OmoOgoohN7Qoo?cloodm?Co
lo?conSXj?nPX:3oP820ohj>S_n9RHWoe]KFooCdm?nLW9co^KVhoo?cloodm?Colo?cooCdm?oclo?o
m?Cdoo?cloodm??olo?comGEeOoclo?om?Cdoo?cloodm?Colo?cooCdlooclo?om?Cdoo?cloodm?Co
lo?cooCdm00<oo?cl`03olG5aOoooooooooo0?ooooooK?ooool001Wok^k^00?oOgmoonk^k_o^k^h0
5_o^k^h00on9RHWok^k^onk^kP0Fonk^kP04olO7aoo`l?3okNg]onSXj0Goi^KV06Goi>CTomkNg_oC
dm?oaLG5okRh^?na/K7o[:b/oj^[Zon/[:co/K6aokRh^?o5aLCodm?ComkNg_oShn?oi^KVonGUiOoV
i^KoiNGUonKViOoUiNGoi^KVon?ShooNg]kodm?ColG5aOnh^;So/K6`ojb/[?n[Zj_o[:b/ok6a/Onh
^;SoaLG5om?CdooNg]gohn?SonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKViOoShn?og]kNom?Cdoo5
aLGo^;Rhok6a/On/[:coZj^Zojb/[?na/K7o^;RholG5aOoCdm?og]kNon?ShooVi^GoiNGUonKVi_oU
iNGoi^KVonGUiOoVi^KoiNGUonKViOoUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KUonGUiOoV
i^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^GoU9BDol71`OoUiNGo^;RhogmoOond];CoiNGUolc<bomo
Ogooi^KVonCTi?nDU9CoWinOomoOgooNg]koXJ6QoiBDU002onGUi@1<oi>CTonSXj?og]kNolo?conA
TI7oQHF5onKVi_o>c/koP820omOGeooKfm_oXj>SohF5QOoUiNGoi^KVoiRHV?nb/[;oiNGUonKVi_oU
iNGoi^KUonGUiOoVi^KoU9BDojf][OoUiNGoi^KVonGUiOoVi^Goc/k>oh20P?oGemOofm_Koj>SXon5
QHGoiNGUonKViOoUiNGoTI6Aoh:2P_n/[:coiNGUonKVi_oUiNGoVYZJoiRHV?oIfMWoiNGUon7QhOoO
gmooi^KVoiRHV?nb/[7oiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKViOoUiNGocLg=onGUiOoV
i^KoiNGUonKVi_oUiNGoi^KUonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi@Coi^KV00SoiNGUonKV
i_oVi^Koi^KVonSXj?o/k>col?3`olO7aoook^k^K_o^k^h001Woi^KV00?oOgmoonKVi_oVi^H05_oV
i^H00on;Rh_oi^KVonKViP0FonKViP04ol[:b_o_knooj^[ZonKViP;oh>3P01?ohN7Qon3Ph?oOgmoo
f][Jom7AdOo1`L7o/K6aokFe]Oo9bLWof][JonCTi?oJf][obLW9okJf]_na/K7o`<30om7AdOoJf][o
gmoO00Goh>3P017ogmoOom[Jf_oAdM7o`<30ok6a/One]KGobLW9om[Jf_oTi>Cof][JolW9bOnf][Ko
/K6aol30`?oAdM7of][JomoOg`05on3Ph00AomoOgooJf][odM7Aol30`?na/K7o]KFeolW9bOoJf][o
i>CTom[Jf_o9bLWo][Jfok6a/Oo0`<3odM7Aom[Jf_oOgml01ooPh>000oooooooR8R8odA4A006odA4
A003oc<c<om4A4CoA4A400?oA4A400ooVIVIon3Ph?nCTi?o_Kfmon3Ph?nBTY;oVYZJohf=SOoPh>3o
alO7ogmoOooPh>3odM7AogmoOoo4a<@00_oPh>001_o4a<CoOgmoom;Bd_oGemOoOgmoolW9b@;oh>3P
00Wo`<30ohF5QOoPh>3odM7Aoh20P?o6a/Koh>3Pok^k^on;Rh/00_oPh>000onGUiOo[jn_on3Ph005
on3Ph003oi>CTon[Zj_oh>3P00?oh>3P00KodM7Aoh20P?o6a/Koh>3Pok^k^on;Rh/2on3Ph009olc<
c?moOgoo^k^kohJ6Q_oMgMgoh>3Pom?CdomoOgooa<C400Goh>3P00?oUiNGojn_[ooPh>002?oPh>00
0oo9bLWoh>3Pon3Ph00Bon3Ph005on7QhOoVi^KojNWYono_koo:b/X0oooVi^I^onKViP006Oo^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ohj>S_o^k^kok^k^01Kok^k^00Coc<c<oo?cloo`l?3ojn_[1?oX
j>P01ooVi^KogMgMolk>c_nj^[[oa<C4onOWioo^k^h00oo_knl01oo^k^kojNWYolG5aOnk^k_oc/k>
omgMgOoVi^H01OoXj>P01ooVi^KogMgMolk>c_nj^[[oa<C4onOWioo^k^h00oo_knl01oo^k^kojNWY
olG5aOnk^k_oc/k>omgMgOoVi^H01OoXj>P01ooVi^KogMgMolk>c_nj^[[oa<C4onOWioo^k^h00oo_
knl01oo^k^kojNWYolG5aOnk^k_oc/k>omgMgOoVi^H01ooXj>P00oooooooA4A4ofIVIP03ogMgM`03
ofIVI_mgMgOoMgMg00GoMgMg013o<c<colc<c?oXj>SoUIFEol;2`_oGemOoOgmoomKFe_n@T93odM7A
olg=cOmoOgooj>SXolg=cOmoOgoogMgM0_oXj>P01_oLg=coOgmoolk>c_o>c/koOgmoomgMg@;oj>SX
00WoaLG5ohJ6Q_oXj>Soj>SXolK6a_nCTi?oU9BDoiFEUOn<S8`00_oXj>P00onIVIWo/k>conSXj005
onSXj003oiFEUOn^[Zkoj>SX00Coj>SX00Goa/K6oi>CTonDU9CoUIFEohb<S002onSXj008ojZZZ_nI
VIWoj>SXohn?Soo2`/;oj>SXolg=cOmoOgl4oiRHV004olo?cooXj>SoVIVIok>c/`Woj>SX00?od=3@
onSXj?oXj>P04ooXj>P01?o[jn_ol?3`oo?cloo<c<coonk^kVkok^k^000Iooooo`03ogmoOooooooo
oooo01Kooooo00?oT92@ooooooooool05_ooool00oo?cloonOWiooWin@05ooWin@06ooGemOoZj^[o
dm?Colc<c?o/k>com_Kf0_ojn_X02Ookno_on_[joo[jn_ohn?Sok^k^olc<c?oCdm?oj^[ZooGem@05
ooWin@06ooGemOoZj^[odm?Colc<c?o/k>com_Kf0_ojn_X02Ookno_on_[joo[jn_ohn?Sok^k^olc<
c?oCdm?oj^[ZooGem@05ooWin@06ooGemOoZj^[odm?Colc<c?o/k>com_Kf0_ojn_X02Ookno_on_[j
oo[jn_ohn?Sok^k^olc<c?oCdm?oj^[ZooGem@07ooWin@0<oooooolc<c?ok^k^onk^k_nk^k_oMgMg
ojZZZ_ooooook^k^omgMgOmgMgOogMgM0_o^k^h04?mgMgOoc<c<ooWinOnHV9SocLg=okZj^_nEUIGo
nOWiol30`?na/K7of][JogmoOooinOWoj>SXogmoOooEeMD2ooWin@06omCDe?moOgooj^[Zon[Zj_mo
Ogooe=CD0_oinOT00ooAdM7oQhN7ooWin@03ooWin@03ooShn?o5aLGoSXj>00;onOWi00?oWIfMok^k
^ooinOT01OoinOT00onHV9So][JfooWin@06ooWin@0EooShn?o5aLGoSXj>ooWinOodm?CoQXJ6olc<
c?oinOWo`l?3oibLW?oinOWoinOWogmoOoo@d=3oh^;RomkNg_n0P83ok>c/ooWinOnMWIgo/K6a00Wo
nOWi00?ogMgMooWinOoinOT04_oinOT01Oojn_[onOWiooWinOoinOWoclo?0?ooooooK_ooool001Wo
k^k^00?oOgmoonk^k_o^k^h05_o^k^h00onCTi?ok^k^onk^kP0Fonk^kP04om7AdOofm_Kol_;bong]
k@?ojn_[00[oj^[ZonKVi_oIfMWo`<30omKFe_oTi>Cojn_[oo3`l?oalO7ol_;b0_oalO401oo/k>co
i^KVomOGeoo0`<3ofMWIonKVi_oZj^X00oo[jn/02_oZj^[oi^KVomWIfOo0`<3oe]KFonCTi?o[jn_o
l?3`oo7alOobl_82oo7al@07onc/k?oVi^KoemOGol30`?oIfMWoi^KVon[ZjP03on_[j`0:on[Zj_oV
i^KofMWIol30`?oFe]Koi>CTon_[joo`l?3olO7aoo;blP;olO7a00Ook>c/onKVi_oGemOo`<30omWI
fOoVi^Koj^[Z00Kojn_[00Kooooooc<c<oooooook^k^ogMgMol0<l`2oc<c000BodA4A?lc03?o000R
ofH0I_mgMgOoooooogMgMonk^k_ojn_[oiFEUOo4a<CoS8b<okVi^Oo[jn_ogmoOohN7Qoo<c<coOgmo
0_o[jn/01_nJVY[oWIfMomgMgOoLg=coWIfMoi^KV`;ojn_[00KoVi^KoibLW?oOgmooh^;Roj6QXOn6
QXH2on_[j`05ol_;booKfm_ojNWYojRXZ?nRXZ800_o[jn/00onJVY[o];Bdon_[j`05on_[j`03oiFE
UOn`/;3ojn_[00Cojn_[01?obl_;om_KfooYjNWoZ:RXoj:RX_o[jn_oa<C4ohB4Q?oVi^Kojn_[on?S
hon2PX;of][Jon_[jonIVIWo[:b/onOWioo1`L7oTI6A00;ojn_[00CoVYZJohN7Qonl_;cogmoO1oo[
jn/00ooDe=Cojn_[on_[j`0Con_[j`04ong]kOoclo?omOGeom7AdOook^k^K_o^k^h001Woi^KV00?o
OgmoonKVi_oVi^H05_oVi^H00onEUIGoi^KVonKViP0FonKViP04omCDe?oemOGokno_on[ZjP;oi>CT
00WoiNGUonCTi?oPh>3odm?CokZj^_oEeMGog]kNonCTi?oUiND00_oZj^X02?o[jn_oi^KVonCTi?oO
gn3oe]KFokVi^OoCdm?ogmoO0_oTi>@02_oUiNGoi>CUonCTi?oOgmoodm?CokVi^OoEeMGogMgMonCT
i?oUiNH2on[ZjP08on_[jooVi^Koi>CTomoOgooFe]Ko^KVjom?CdooOgml2onCTi00DonGUiOoTi>Co
i>CTomoOh?oCdm?o^KViomGEeOoMgMgoi>CTonGUiOoZj^[oj^[[on_[jooVi^Koi>CTomoOgooFe]Ko
^KViom?CdooOgn02onCTi007onGUiOoTi>CoiNGUonCTi?oUiNGoooooogMgM`02onk^kP1[ofIVI_l0
I_oo06K<odA4A?lc03?o<c<cogMgMolc03?oR8R8onk^k_mVIVKoc<c<onCTiOnDU9CoZ:RXogmoOooI
fMWoiNGUonCTi?nKVi_oZJVZogmoOooTi>CoiNGUom[Jf_nOWiooQ8B4ohF5QOnPX:3og=cLonCTi?oU
iNGof][JoiZJV_n3Ph?oShn?ojZZZ_n5QHGoi>CTonGUiOne]KGoTi>CohF5QOnEUIGoc<c=onGUiOoT
i>CoV9RHok6a/OoUiNGoi>CTonGUiOoTi>GoiNGUonCTi?nDU9Co[:b/onGUiOoTi>CoiNGUonCTiOoU
iNGo]KFeoi>CTon5QHGoUIFEolc<c?oUiNGoXZ:Sojb/[?oTi>CoiNGUonCTi?nZZZ[o/k>conGUiOoJ
f]_oVi^KohB4Q?n:RX[oalO7onGUiOoTi>CoX:2PokFe]OnTY:CoPX:2onGUiOoTi>CoiNGUonCTi?oU
iNGoi>CUonGUiOo@d=3oiNGUonCTi?oUiNGoi>CTonGUiOoTi>GoiNGUonCTi?oUiNGoi>CTonGUiOoT
i>@00_oUiND00ooTi>CoiNGUonGUi@03onGUi@05onCTi?oZj^[okno_ooGemOoDe=@0oooVi^I^onKV
iP006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03oiRHV?o^k^kok^k^01Kok^k^00Coe]KFooOgmood
m?Cokno_0oo]kNd02?o[jn_oj>SXom_Kfonn_[kof][JomkNg_oTi>CoinOW0ooZj^X02?oXj>Soi>CT
on3Ph?oJf][o_[jnom_KfooXj>Sok>c/0oo]kNd02?o/k>coj>SXom_Kfonn_[kofMWIomoOgooTi>Co
inOW0ooZj^X02?oXj>Soi>CTon3Ph?oJf][o_[jnom_KfooXj>Sok>c/0oo]kNd02?o/k>coj>SXom_K
fonn_[kofMWIomoOgooTi>CoinOW0ooZj^X02?oXj>Soi>CTon3Ph?oJf][o_[jnom_KfooXj>Sok>c/
1_o]kNd01Ooooooo<c<conk^k_oMgMgo4A4A00;o06Ko00go<fK<ob8R8_n8R8SoVIVIob8R8_oMgMgo
k^k^ogMgMoo<c<cokNg]oiJFU_n7QhOoVi^K00?okNg]00?oaLG5ohN7QomoOgl01?o]kNd2onc/k0Ko
kNg]00Cok>c/ong]kOo9bLWoQXJ61?o]kNd00oo/k>cokNg]ong]k@02ong]k@03oiZJV_ne]KGokNg]
00GokNg]00?oUYJFok6a/Oo]kNd01_o]kNd00oo/k>cokNg]ong]k@0;ong]k@03on_[joo]kNgokNg]
00GokNg]00?ojn_[ong]kOo]kNd01Oo]kNd00ooHf=SokNg]ong]k@0Bong]k@05onc/k?o`l?3om?Cd
ooOgmooFe]H0ooo^k^i^onk^kP006Oooool00omoOgooooooooooo`0Fooooo`03oiZJV_oooooooooo
01Kooooo00GofMWIoogmoOomoOgooOgmooclo003oogmo@07ooWinOo]kNgo`<30omkNg_oTi>CoinOW
on_[j`03onk^kP07onc/k?oXj>SoiNGUomoOgoo1`L7ok^k^ooWin@05oogmo@07ooWinOo^k^ko`<30
omkNg_oTi>CoinOWon_[j`03onk^kP07onc/k?oXj>SoiNGUomoOgoo1`L7ok^k^ooWin@05oogmo@07
ooWinOo^k^ko`<30omkNg_oTi>CoinOWon_[j`03onk^kP07onc/k?oXj>SoiNGUomoOgoo1`L7ok^k^
ooWin@07oogmo@06oooooolc<c?ok^k^oc<c<olc03?o000A0_lR8R803?l0<c?o<`0coa400?l0003o
<c<cok^k^omgMgOo^k^koogmoOnIVIWoOgmoolg=c@?ooOgm00?on?ShohB4Q?moOgl03_omoOd00ooC
dm?oQhN7oogmo@08oogmo@03oijNW_nm_KgooOgm00GooOgm00?oVIVIokRh^?omoOd09?omoOd00ooS
hn?ooOgmoogmo@0@oogmo@03ooclo?omoOgoo?cl00?ooOgm00?ofMWIooooooooool0oooooom/oooo
o`006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03oifMWOo^k^kok^k^01Kok^k^00Gofm_KooShn?of
m_KolO7aong]k@03onk^kP07onc/k?oShn?o/K6aolk>c_oDe=CofMWIom_Kf`02omkNgP08omoOgooL
g=cofMWIomGEeOo>c/ko/K6aon?Shoo/k>`5onk^kP07onc/k?oShn?o/K6aolk>c_oDe=CofMWIom_K
f`02omkNgP08omoOgooLg=cofMWIomGEeOo>c/ko/K6aon?Shoo/k>`5onk^kP07onc/k?oShn?o/K6a
olk>c_oDe=CofMWIom_Kf`02omkNgP08omoOgooLg=cofMWIomGEeOo>c/ko/K6aon?Shoo/k>`7onk^
kP0DoooooomgMgOoIS=VofHcI_mgMgOoR8R8ofIVI_lc<`3o03?<o`1Vc?lc06Ko0000ofHcI_lc<c?o
MgMgolc<c?o^k^kobl_;ol;2`_oXj>P4onk^kP03olk>c_o2`/;ok^k^00gok^k^00?obLW9ohJ6Q_o^
k^h02?o^k^h00onJVY[o][Jfonk^kP05onk^kP03ol_;booFe]Kok^k^02Cok^k^00?of][Jonk^k_o^
k^h04oo^k^h01?oalO7omOGeooWinOoKfm_oonk^kVkok^k^000IonKViP03ogmoOooVi^Koi^KV01Ko
i^KV00?oWinOonKVi_oVi^H05_oVi^H01?oNg]komoOgoo;bl_o/k>`4onOWi`06onKVi_oQhN7o/;2`
okjn__o;bl_odM7A0_oFe]H02OoGemOoe]KFomGEeOoAdM7ob/[:okfm_On_[joohN7QonKViP05onOW
i`06onKVi_oQhN7o[jn_okfm_Oo;bl_odM7A0_oFe]H02OoGemOoe]KFomGEeOoAdM7ob/[:okfm_On_
[joohN7QonKViP05onOWi`06onKVi_oQhN7o[jn_okfm_Oo;bl_odM7A0_oFe]H02OoGemOoe]KFomGE
eOoAdM7ob/[:okfm_On_[joohN7QonKViP07onOWi`09oooooom4A4Co<`0col`0c?mV<fKoIVIVoa40
0?nIIP3oc9T000;o06K<0_nI09T00onk^k_oMgMgolc<c00HonOWi`03onKVi_oTi>CoinOW00SoinOW
00?oiNGUonKVi_oWinL0;?oWinL00ooEeMGoinOWonOWi`0<onOWi`03onKVi_oWinOoinOW00CoinOW
00Cok>c/oo;bl_ogmoOog]kNoooVi^I^onKViP006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03oj:R
X_o^k^kok^k^01Kok^k^00Koh>3PooWinOofm_KolO7aonk^k_o_knl3onk^kP06ong]kOo=cLgo[jn_
ol_;booIfMWohn?S0ooUiND01_oShn?ofMWIol_;bon_[joocLg=onc/k0Ook^k^00Kok>c/olg=cOn_
[joobl_;omWIfOoShn<3onGUi@06on?ShooIfMWobl_;ojn_[oo=cLgok>c/1oo^k^h01_o/k>cocLg=
ojn_[oo;bl_ofMWIon?Sh`?oiNGU00Kohn?SomWIfOo;bl_o[jn_olg=cOo/k>`8onk^kP04oooooolc
<c?oc<c<odA4A0;o000000[o<`0cofIV0?ooc03oVFH0ofH0I_o<0?ooIP1VofHcI_mgMgOo^k^kD_o^
k^h00ooKfm_ok^k^onk^kP0Aonk^kP06ono_koo^k^kolO7aooKfm_oinOWoh>3Pooo^k^i^onk^kP00
6Oooool00omoOgooooooooooo`0Fooooo`03ojBTY?oooooooooo01Kooooo00Gohn?Soooooooooooo
ooooooknoP02ooooo`?oo_kn04Coo?clolg=cOo0`<3oh>3Poo;bl_ohn?Son_[jooShn?obl_;oh>3P
ol71`?o<c<coo?cloogmoOooooooo_knooooooono_koooonookno_oooooooOgmooclo?o<c<co`L71
on3Ph?obl_7on?Shoo[jn_ohn?Sol_;bon3Ph?o1`L7oc<c<ooclnoomoOgoooooookno_ooooooo_kn
ooooooono_koooonoogmoOolo?coc<c<ol71`OoPh>3ol_;booShn?ojn_Won?Shoo;bl_oPh>3o`L71
olc<c?olo?cooOgmooooo_ono_koooooookno_ooooooo_knooooooono_koooooogMgM`;ok^k^00?o
8R8RoiT0VOmV<fH00_mV06H0JOlc03?oVFH0oa4A4Oo<c<cok^k^ogMgMoo<c<coooonookno_oooooo
o_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_ko
ooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_ooooko
o_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_ko
ooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_oooooo
o_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_ko
ooooookno_ooookoo_knonSXj?ono_koooooookno_ooooooo_knooooo_ono_koooooookno_oooooo
o_knooooooono_koooooooknoP02ooooo`03ookno_oooooooooo00Cooooo00?ohn?Sooooooooool0
oooooom/ooooo`006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03ojNWYoo^k^kok^k^01Ook^k^00Co
lO7aooWinOofm_KolO7a1Oo_knl03Oo^k^koiNGUol71`Onf][KodM7AomoOgooUiNGogmoOom7AdOnf
][Ko`L71onGUiOo^k^h02Oo_knl03Oo^k^koiNGUol71`Onf][KodM7AomoOgooUiNGogmoOom7AdOnf
][Ko`L71onGUiOo^k^h02Oo_knl03Oo^k^koiNGUol71`Onf][KodM7AomoOgooUiNGogmoOom7AdOnf
][Ko`L71onGUiOo^k^h02Oo_knl01_ooooooA4A4onk^k_nIVIWo4A4AodA4A0;oc03<00CoV@2Io`0c
I_o<V@3oMgMg0_o^k^h00omgMgOoc<c<ono_k`1Aono_k`03omgMgOo_knookno_00[okno_00Cok^k^
ono_koo_knook^k^1?o_knl01?oalO7om_KfooWinOoalO7oonk^kVook^k^000IonKViP03ogmoOooV
i^Koi^KV01Koi^KV00?oZJVYonKVi_oVi^H05ooVi^H01Oo/k>com_Kfoo;bl_o/k>cojNWY00?oj>SX
00coinOWonSXj?oXj>SoinOWol_;bonf][KoY:BToi^KVonTY:Co][Jfol_;booWinL=onSXj009onOW
ioo;bl_o][JfojBTY?nKVi_oY:BTokJf]_o;bl_oinOW00goj>SX00WoinOWol_;bonf][KoY:BToi^K
VonTY:Co][Jfol_;booWinL02ooXj>P02Ooooooo<c<conk^k_mgMgOo<c<cofIVI_lc<c?oc03<odA4
A002o`0cIP05ogMgMoo^k^kok^k^ogMgMonk^k/0D_oXj>P00ooIfMWoj>SXonSXj00AonSXj005onWY
jOo/k>col_;booKfm_o/k>`0oooVi^I_onKViP006Oo^k^h00omoOgook^k^onk^kP0Fonk^kP03ojb/
[?o^k^kok^k^01Ook^k^00Cokno_oo3`l?ofm_KolO7a2_o_knl3onk^kQ?okno_0oo^k^hCono_k`?o
k^k^3_o_knl00oooooooMgMgonk^kP03onk^kP06ok^k^omV<fKoooooonk^k_nIVIWoR8R80_o^k^h0
0omgMgOoc<c<ono_k`1Aono_k`03omoOgoo_knookno_00gokno_00?ok^k^ono_koo_knl00_o_knl0
1?obl_;om_Kfoo3`l?o_knooonk^kVook^k^000Iooooo`03ogmoOooooooooooo01Kooooo00?o[Zj^
ooooooooool06Oooool00ooalO7oooooooooo`17ooooo`03oc<c<oooooook^k^00[ok^k^00?oMgMg
olc<c?ooool0DOooool00ooZj^[oooooooooo`0Cooooo`03oo7alOoooooooooo0?ooooooKoooool0
01Wok^k^00?oOgmoonk^k_o^k^h05_o^k^h00ona/K7ok^k^onk^kP0Ionk^kP04ono_koo/k>colO7a
ooWinDGon_[j00?ooooooc<c<omgMgL03?mgMgL00ooooooon_[joo[jnP1@oo[jnP03on_[joojn_[o
n_[j013on_[j00ConOWioo7alOo/k>cokno_ooo^k^iaonk^kP006OoVi^H00omoOgooi^KVonKViP0F
onKViP03ok>c/ooVi^Koi^KV01coi^KV_?oShn?oonKViWCoi^KV000Ionk^kP03ogmoOoo^k^kok^k^
01Kok^k^00?o][Jfonk^k_o^k^h0a?o^k^h00onf][Kok^k^onk^kP3oonk^kXGok^k^000Iooooo`03
ogmoOooooooooooo01Kooooo00?o^;Rhooooooooool0a?ooool00onh^;Soooooooooo`3oooooohGo
oooo000Ionk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o^k^kogmoOomoOgl0a?moOgl00onk^k_ok^k^
onk^kP3oonk^kXGok^k^000IonKViP03ogmoOooVi^Koi^KV01Koi^KV00Go_KfmonWYjOoUiNGoh^;R
omoOg`04omkNgP?ogmoO00Gog]kNomoOgooNg]kog]kNomgMg@02omkNgP0DomoOgooNg]oogmoOomkN
g_oOgmoog]kNomoOgooNg]kogmoOomkNgooOgmoog]kNomoOgooNg]kogmoOomkNg_oOgmoog]kOomkN
g_oMgMd2omkNgP0AomoOgooNg]kogmoOomkNgooOgmoog]kNomoOgooNg]kogmoOomkNg_oOgmoog]kO
omoOgooNg]kogmoOomkNg_oOgml00_oNg]h0OooMgMkog]kNomkNg_oOgmoog]kNomoOgooNg]kogmoO
omkNgooOgmoog]kNomoOgooNg]kogmoOomkNg_oOgmoog]kOomoOgooNg]kogmoOomkNg_oOgmoog]kN
omoOgooNg]oogmoOomkNg_oOgmoog]kNomoOgooNg]kogmoOomkNgooOgmoog]kNomoOgooNg]kogmoO
omkNg_oOgmoog]kOomoOgooNg]kogmoOomkNg_oOgmoog]kNomoOgooNg]oogmoOomkNg_oOgmoog]kN
omoOgooNg]kogmoOomkNgooOgmoog]kNomoOgooNg]kogmoOomkNg_oOgmoog]kOomoOgooNg]kogmoO
omkNg_oOgmoog]kNomoOgooNg]oogmoOomkNg_oOgmoog]kNomoOgooNg]kogmoOomkNgooOgmoog]kN
omoOgooNg]kogmoOomkNg_oOgmoog]kOomoOgooNg]kogmoOomkNg_oCdm?o[Jf]omcLg?oNg]oogmoO
omkNg_oOgmoog]kNomoOgooNg]kogmoOomkNgooOgmoog]kNomoOgooNg]kogmoOomkNg_oOgmoog]kO
omoOgoo4a<CogmoOomkNg_oOgmoog]kNomoOgooNg]oogmoOomkNg_oOgmoog]kNomoOgooNg]h00ooO
gml00ooNg]kogmoOomoOg`03omkNgP04on7QhOoVi^Koj>SXokfm_Oooi^KVQooVi^H001Wok^k^00?o
PH61onk^k_o^k^h05_o^k^h01?o0`<3ojn_[onOWiooRh^88omgMg@;ofm_K00OofMWIomSHf?oHf=So
f=SHomWIfOoKfm_og=cL00gogMgM00?og=cLom_KfooIfMT00ooHf=P00ooIfMWofm_KomcLg00=omgM
g@03omcLg?oKfm_ofMWI00?of=SH00?ofMWIom_KfooLg=`0F?oMgMd00ooKfm_oRHV9ok^k^`0BomgM
g@03ol;2`_oMgMgogMgM00[ogMgM00?og=cLomgMgOoMgMd01_oMgMd01?oQhN7oinOWon_[joo0`<3o
onk^kXOok^k^000Iooooo`03ohB4Q?oooooooooo01Kooooo00So`/;2oo;bl_o^k^koj^[ZonOWiooX
j>SoinOWonWYj@;oj>SX00goi^KVonOWiooRh^;ogMgMom[Jf_oFe]KoeMGEomKFe_oJf][ogMgMon;R
h_oVi^KoinOW00Woj>SX00goinOWonKVi_oRh^;ogMgMom[Jf_oFe]KoeMGEomKFe_oJf][ogMgMon;R
h_oVi^KoinOW00Woj>SX00goinOWonKVi_oRh^;ogMgMom[Jf_oFe]KoeMGEomKFe_oJf][ogMgMon;R
h_oVi^KoinOW02;oj>SX00?oh>3PonOWiooXj>P00_oShn<7onSXj003on?ShooNg]koj>SX00Coj>SX
00?ogMgMonOWiooXj>P00_oXj>P00ooMgMgoinOWonSXj002onSXj003on?ShooNg]koj>SX00koj>SX
00?oh>3PonOWiooXj>P00_oShn<2onSXj003okRh^?nHV9Soj>SX00Goj>SX00?ohn?SomkNg_oXj>P0
2OoXj>P00oo9bLWoj>SXonSXj00<onSXj003onWYjOoXj>SojNWY00Coj>SX00Coj^[Zonk^k_oalO7o
`/;2oooooon7ooooo`006Oo^k^h00on6QXKok^k^onk^kP0Fonk^kP04olG5aOo^k^kok^k^ono_k`Go
k^k^08?okNg]on_[jooVi^Kog]kNom?Cdoo;bl_oa<C4ol?3`oo4a<Cobl_;om?CdooOgmkoi^KVonc/
k?o]kNgokno_onk^k_o_knook^k^ono_k_o^k^kokno_ong]kOo/k>coi^KVomoOgooCdm?obl_:olC4
a?o3`l?oa<C4ol_;booCdm?ogmoOonKVi_o/k>_okNg]ono_koo^k^kokno_onk^k_o_knook^k^ono_
k_o]kNgok>c/onKVi_oOgmoodm?Col_;boo4a<Co`l?3olC4a?o;bl_odm?ComoOgooVi^Kok>c/ong]
kOo_knkok^k^ono_koo^k^kokno_onk^k_o_knook^k^ono_k_o^k^kokno_onk^k_o_knook^k^ono_
koo^k^kokno^onk^k_o_knook^k^ono_koo^k^kokno_onk^k_o_knkoUYJFok>c/oo^k^kokno_onk^
k_o_knook^k^oj:RX_n2PX;oRXZ:ol;2`_n7QhOoY:BTono_konJVY[o][Jfonk^k_o_knoohn?SoinO
Won0P83oSXj>ohV9ROoCdm?ok^k^om_Kfon?ShooS8b<olo?coo_knoof][John?Son<S8cod=3@onk^
k_oTi>CoWinOoh20P?n>SXkoRHV9om?Cdoo_knook^k^ono_koo^k^kokno_oiJFUP04ogmoO`0[oiRH
V?o^k^koXZ:Roh:2P_n:RX[o`/;2ohN7QonTY:Cokno_onk^k_no_kooOgmoomgMg?o^k^kokno_onk^
k_oTi>CoWinOoh20P?n>SXkoRHV9om?Cdoo_knooVYZJono_koo^k^kokno_onk^k_o_knkok^k^omGE
eOo^k^kokno_onk^k_o_knook^k^ono_k_o^k^kokno_onk^k_o_knook^k^ono_k`0<onk^kP03olG5
aOo^k^kok^k^0?ook^k^QOo^k^h001Woi^KV00?oRHV9onKVi_oVi^H05_oVi^H01?o7alOok^k^on_[
jooVi^H5onCTi01_on;Rh_oLg=cod];Bol?3`onf][Ko/;2`ojZZZ_nYZJWoZZZZok2`/?nf][Ko`l?2
om7AdOoLg=cohN7QonCTi?oShn?oi>CTon?ShooTi>?ohn?SonCTi?oQhN7og=cLom7AdOo3`l?o][Jf
ok2`[onZZZ[oZJVYojZZZ_n`/;3o][Jfol?3`ooAdM7og=cKon7QhOoTi>Cohn?SonCTi?oShn?oi>CT
on?ShooTi>?ohN7QomcLg?oAdM7o`l?3okJf]_n`/;3oZZZZojVYZOnZZZ[o/;2`okJf]_o3`l?odM7A
omcLg?oQhN7oi>CSon?ShooTi>Cohn?SonCTi?oShn?oi>CTon?ShooTi>?ohn?SonCTi?oShn?oi>CT
on?ShooTi>Cohn?SonCThooShn?oi>CTon?ShooTi>Cohn?SonCTi?oShn?oi>CSoiBDU?n^[Zkohn?S
onCTi?oShn?oi>CTolc<c?n0P83oeMGEom[Jf_nRXZ;oQHF5on?ShooTi>CoV9RHok6a/?oShn?oi>CT
oiVIVOnHV9Soe]KFonCTi?oNg]kog]kMon?Shon[Zj_oV9RH00;ohn?S04;oi>CToj^[ZonHV9Soh^;R
onCTi?oShn?oVIVIoiRHV?oGemOohn?SomoOg_oMgMgoi>CTon?ShooTi>Cohn?SonCTi?nDU9Co[:b/
on?ShooTi>Cohn?SonCTi?o<c<coP820omGEeOoJf]WoXZ:RohF5QOoShn?oi>CTon?ShonATI7oPX:2
oj^[ZooShn?oi>CTon?ShonIVIWoV9RHomOGeooShn?ogmoNomgMgOoTi>CoV9RHonCTi?oShn?oi>CT
on?ShooTi>?ohn?Solg=cOoShn?oi>CTon?ShooTi>Cohn?SonCThooShn?oi>CTon?ShooTi>Cohn?S
onCTi?oShn<4onCTi008on?ShooTi>Coi>CTonCTi?oVi^Koj^[Zonk^k_o7alOoonKViXOoi^KV000I
onk^kP03oh^;Roo^k^kok^k^01Kok^k^00Cob/[:oo7alOo/k>coj>SX0_oRh^804ooShn?oh^;Ron7Q
hOoLg=cod];Bol;2`_nc/k?o]kNgol[:b_oLg=coiNGUomcLg?o:b/[o^;Rhok>c/oo2`/;od];BomcL
g?oQhN401OoRh^804OoQhN7og=cLom;Bd_o2`/;o/k>cokNg]oo:b/[og=cLonGUiOoLg=cob/[:okRh
^?nc/k?o`/;2om;Bd_oLg=cohN7Q00Goh^;R017ohN7QomcLg?oBd];o`/;2ok>c/ong]kOob/[:omcL
g?oUiNGog=cLol[:b_nh^;So/k>col;2`_oBd];og=cLon7Qh@07on;RhP03oooooon8R8SoA4A400Ko
A4A400?o<c<codA4A?m4A4@00om4A4@01?nIVIWoh^;Roi>CTon][Jd4on;RhP06om?Cdon0P83ob<S8
on;Rh_nl_;coRh^;0_oRh^801_nGUiOo/;2`on;Rh_oDe=CoOgmoolK6aPGoh^;R00?oW9bLoj^[ZooR
h^800_oRh^801onLW9coZj^[on;Rh_oRh^;oe=CDogmoOoo6a/H02OoRh^800onCTi?o[:b/on;RhP03
on;RhP06om?Cdon0P83ob<S8on;Rh_nl_;coRh^;0_oRh^802Oo>c/koOgmookbl_?n6QXKogmoOon;R
h_oDe=CoOgmoolK6aP05on;RhP03oiNGUooRh^;oh^;R00Coh^;R00?obLW9on;Rh_oRh^804_oRh^80
1OoShn?oj>SXon_[jooalO7ob/[:0?ook^k^Qoo^k^h001Wooooo00?oSXj>ooooooooool05_ooool0
1?o<c<con?ShooGemOo`l?04ong]k@07on_[jooRh^;od];Bokjn__o7alOoj^[Zoo7al@03oo;blP07
oo7alOo/k>cob<S8okno_ooBd];oh^;Ron_[j`05ong]k@07on_[jooRh^;od];Bokjn__o7alOoj^[Z
oo7al@03oo;blP07oo7alOo/k>cob<S8okno_ooBd];oh^;Ron_[j`05ong]k@07on_[jooRh^;od];B
okjn__o7alOoj^[Zoo7al@03oo;blP07oo7alOo/k>cob<S8okno_ooBd];oh^;Ron_[j`07ong]k@03
oooooom4A4CoIVIV00?oMgMg00?oIVIVogMgMomgMgL01OmgMgL01olc<c?oc<c<ong]kOnFUYKoY:BT
omGEeOoTi>@00oo]kNd01Oo9bLWoU9BDoiFEUOnFUYKoS8b<00;okNg]00KoVYZJokFe]Oo]kNgod=3@
ogmoOonIVIT3oiZJVP04om?Cdoo]kNgoX:2Pok2`/0?okNg]00OoX:2Pok2`/?o]kNgokNg]om3@d?mo
OgooVIVI00?oVYZJ00?odm?Cong]kOo]kNd00oo]kNd00onFUYKo/K6aong]k@04ong]k@05olW9bOnD
U9CoUIFEoiJFU_n<S8`00_o]kNd02On/[:coVi^Kong]kOn@T93oaLG5ong]kOo@d=3oOgmooiVIV@03
oiZJVP03om?Cdoo]kNgoVYZJ00KokNg]00?od=3@ong]kOo]kNd04oo]kNd01?o`l?3omOGeooShn?o<
c<coooooohOooooo000Ionk^kP03oi2@T?o^k^kok^k^01Kok^k^00?oclo?ooCdm?odm?@01Oodm?@0
1_o`l?3oiNGUolo?coo9bLWoj>SXoo;blP;om_Kf00WomoOgooKfm_ofm_Kom?Cdon[Zj_o9bLWoclo?
onGUiOo`l?001Oodm?@01_o`l?3oiNGUolo?coo9bLWoj>SXoo;blP;om_Kf00WomoOgooKfm_ofm_Ko
m?Cdon[Zj_o9bLWoclo?onGUiOo`l?001Oodm?@01_o`l?3oiNGUolo?coo9bLWoj>SXoo;blP;om_Kf
00WomoOgooKfm_ofm_Kom?Cdon[Zj_o9bLWoclo?onGUiOo`l?001oodm?@03?oooooo<c<conk^k_o^
k^ko^k^kogMgMonZZZ[oooooonk^k_oMgMgoMgMgomgMg@;ok^k^00WoMgMgolc<c?odm?CoUiNGohb<
S?n>SXkoOgmoojRXZ?o^k^h00oodm?@00ooclo?o`/;2ohj>SP02ooCdm00=oibLW?ni^KWom?Cdon?S
homoOgoocLg=omgMgOoJf][oP820onSXj?odm?CoXZ:Rok>c/`03ooCdm00;oj:RX_nc/k?om?CdooCd
m?oShn?oOgmoolg=cOoMgMgof][Joh20P?oXj>P01Oodm?@00onGUiOo];BdooCdm006ooCdm00Doo?c
loo2`/;oSXj>ooCdm?o_knooQHF5olW9bOodm?Co`L71oi^KVoodm?Cohn?SogmoOoo=cLgogMgMom[J
f_n0P83oj>SXooCdm?nLW9`6ooCdm003omgMgOodm?Com?Cd01;om?Cd00GomOGeooCdm?odm?Com?Cd
olo?c`3oonk^kXOok^k^000IonKViP03oi>CTooVi^Koi^KV01Koi^KV00CodM7AooCdm?o`l?3ojn_[
0ooYjNT02_oXj>Soi>CTomOGeono_kooe=CDon;Rh_oYjNWok^k^ono_koo`l?02ono_k`07on[Zj_oT
i>CoeMGEokno_ooGemOoi>CTonSXj003onWYj@0:onSXj?oTi>CoemOGokno_ooDe=Coh^;RonWYjOo^
k^kokno_oo3`l0;okno_00Ooj^[ZonCTi?oEeMGo_knoomOGeooTi>Coj>SX00?ojNWY00[oj>SXonCT
i?oGemOo_knoomCDe?oRh^;ojNWYonk^k_o_knool?3`0_o_knl01ooZj^[oi>CTomGEeOno_kooemOG
onCTi?oXj>P01_oYjNT01_oooooo<c<cooooooo^k^koMgMgo`0cc0;o<c<001GoA4A4oc<0<ol002;o
IP1VogMgMoooooooMgMgok^k^ooYjNWoUIFEok2`/?oYjNWoe]KFoh>3Pon[Zj_ojNWYolW9bOoIfMWo
inOWojNWYonQXJ400_oYjNT06_nIVIWo/k>conWYjOoYjNWoVIVIoj^[ZooUiNGo`<30oi2@T?oYjNWo
i^KVoifMWOn/[:coi>CTonOWiooVi^KoWIfMojb/[?oTi>CoinOWonWYjOnIVIWoZj^[onGUiOo0`<3o
T92@1_oYjNT00onEUIGo[jn_onWYj@04onWYj@0ColW9bOoIfMWoinOWojNWYonQXJ7ojNWYol;2`_n4
Q8Coi>CTonWYjOoQhN7oPX:2omSHf?oYjNWoVIVIoj^[ZooUiNGo`<30oi2@T002onWYj@03oiVIVOoY
jNWojNWY00CojNWY00?oe=CDonWYjOoYjNT04ooYjNT01?o[jn_olO7aoo?clooAdM7oonKViXOoi^KV
000Ionk^kP03oiFEUOo^k^kok^k^01Kok^k^00Coe=CDooOgmooalO7ok>c/0_oVi^H02OoWinOoi^KV
on;Rh_oDe=Co^k^komKFe_oOgmooiNGUonKViP02on_[j`08onc/k?oWinOoiNGUon3PhOoGemOo^k^k
omCDe?oQhN42onKViP0:onOWiooVi^Ooi^KVon7QhOoDe=Co^k^komKFe_oNg]koiNGUonKVi`;ojn_[
00Sok>c/onOWiooUiNGoh>3PomOGeonk^k_oe=CDon7Qh@;oi^KV01CoinOWonKVi_oVi^KohN7RomCD
e?nk^k_oe]KFomkNg_oUiNGoi^KVon_[joo[jncok>c/onOWiooUiNGoh>3PomOGeonk^k_oe=CDon7Q
hP;oi^KV00OoinOWonKVi_oWinOoi^KVonOWioooooooMgMg00;ok^k^06_oIVIVo`1Vool0I/coA4A4
oc<0<olc<c?oMgMgoc<0<on8R8Sok^k^ofIVI_o<c<coi^KWoiFEUOn_[jooinOWonKVi_nYZJWoRh^;
onOWionf][OoTi>CohF5QOnFUYKoc/k>onOWiooVi^KoVIVIok:b/_oWinOoi^KVomcLg?nKVi_oQ8B4
ohZ:R_o9bLWoi^KWok:b/_n2PX;oPh>3ohV9ROo5aLGo/[:boh:2P_n3Ph?oRXZ:olG5aOoWinOofm_K
oi^KVon4Q8CoRXZ:olS8bOoWinOoi^KVonOWiooVi^KoinOWonKVi_nEUIGo[Jf^onOWiooVi^KoinOW
onKVi_oWinOo][Jfoi>CTon5QHGoUYJFolk>c_oWinOoXj>Sojf][OoVi^KoinOWonKVion[Zj_o];Bd
onOWiooKfm_oVi^KohB4Q?n:RX[ob<S9onOWiooVi^KoXJ6QonKVi_oWinOoi^KVonOWiooVi^OoinOW
om3@d?oWinOoi^KVonOWiooVi^KoinOWonKViooWinOoi^KVonOWiooVi^KoinOWonKViP02onOWi`03
onKVi_oWinOoinOW00?oinOW00Goi^KVonc/k?oalO7omoOgomCDe03oonk^kXOok^k^000Iooooo`03
oiRHV?oooooooooo01Kooooo00Coe]KFooclo?oinOWom?Cd0oobl_802?o`l?3okNg]omoOgoo2`/;o
gMgMon7QhOoWinOoj^[Z0oo]kNd02?o[jn_oinOWon?ShooMgMgo`/;2omoOgoo]kNgolO7a0oobl_80
2?oalO7okNg]omoOgoo2`/;og=cLon;Rh_oWinOoj^[Z0oo]kNd02?o[jn_oinOWon?ShooMgMgo`/;2
omoOgoo]kNgolO7a0oobl_802?oalO7okNg]omoOgoo2`/;og=cLon;Rh_oWinOoj^[Z0oo]kNd02?o[
jn_oinOWon?ShooMgMgo`/;2omoOgoo]kNgolO7a1_obl_801Ooooooo<c<conk^k_oMgMgo4A4A00;o
06Ko00co<fK<ob8R8_n8R8SoVIVIob8R8_oMgMgok^k^ogMgMoo<c<col_;boiNGUond];@2oo;blP03
oijNW_nMWIgol_;b00;ol_;b00?olO7aoo;bl_obl_800_obl_800onKVi_o^;Rhoo;blP03oo;blP03
oo3`l?obl_;ol_;b00;ol_;b00?oXJ6Qok:b/_obl_800_obl_800onQXJ7o/[:boo;blP04oo;blP03
oo3`l?obl_;ol_;b00Kol_;b00?oUiNGok>c/oobl_801_obl_800ooalO7ol_;boo;blP0;oo;blP03
oo3`l?obl_;ol_;b00Wol_;b00?of=SHoo;bl_obl_804_obl_801OoalO7omOGeooWinOolo?coe]KF
0?ooooooQoooool001Wok^k^00?oVYZJonk^k_o^k^h05_o^k^h01OoIfMWon?ShooShn?ohn?SomoOg
00?on?Sh00Oom?CdonSXj?nm_Kgofm_Kon7QhOoTi>Coj>SX00?ojn_[00OojNWYonGUiOoRh^;og=cL
okjn__oYjNWom?Cd00Gon?Sh00Oom?CdonWYjOnm_Kgofm_Kon7QhOoTi>Coj>SX00?ojn_[00OojNWY
onGUiOoRh^;og=cLokjn__oYjNWom?Cd00Gon?Sh00Oom?CdonWYjOnm_Kgofm_Kon7QhOoTi>Coj>SX
00?ojn_[00OojNWYonGUiOoRh^;og=cLokjn__oYjNWom?Cd00Oon?Sh00Kooooooc<c<oo^k^ko<c<c
oc<0<ol00142ob8R8P0?o`0c<olc03?o4@00o`000?lc<c?o^k^kogMgMonk^k_on?ShoiRHV?nEUIGo
ZJVYoi6ATOmoOgoodM7A00Son?Sh00?oWIfMok^k^oohn?P02?ohn?P00ooYjNWoj>SXooShn002ooSh
n003onWYjOoXj>Son?Sh00gon?Sh00?oV9RHokJf]_ohn?P08?ohn?P00ooShn?on?ShooShn00@ooSh
n003ooOgmoohn?SomoOg00?on?Sh00?ofMWIonk^k_o^k^h0ooo^k^j5onk^kP006OoVi^H00onMWIgo
i^KVonKViP0FonKViP05om_Kfoofm_Kom?Cdono_koo[jn/00oo/k>`01ooZj^[ohN7Qok2`/?o<c<co
d];BomOGeooIfMT00_oLg=`02?oMgMgof][JomOGeooCdm?oc<c<ok2`/?oQhN7oj^[Z1Oo/k>`01ooZ
j^[ohN7Qok2`/?o<c<cod];BomOGeooIfMT00_oLg=`02?oMgMgof][JomOGeooCdm?oc<c<ok2`/?oQ
hN7oj^[Z1Oo/k>`01ooZj^[ohN7Qok2`/?o<c<cod];BomOGeooIfMT00_oLg=`02?oMgMgof][JomOG
eooCdm?oc<c<ok2`/?oQhN7oj^[Z1oo/k>`05_ooooooMgMgofHcI_mV<fKoMgMgohR8R?mVIVKo<c<0
o`0cc?l0I/co<`1Vo`000?mV<fKo<c<cogMgMoo<c<cok>c/ol[:b_o0`<3o`L71olS8b?oMgMd9onc/
k003oiZJV_ne]KGok>c/01gok>c/00?ob/[:omCDe?o/k>`08?o/k>`00ooJf][ok>c/onc/k00Conc/
k004ono_kooclo?omoOgom_Kfoooi^KVQooVi^H001Wok^k^00?oWinOonk^k_o^k^h05_o^k^h01?oN
g]konOWiooCdm?o^k^h4onWYj@06onSXj?oShn?o/[:bokno_oo<c<cod];B0_oGemL02OoHf=SoemOG
omKFe_oBd];obl_;okjn__na/K7ohn?SonSXj005onWYj@06onSXj?oShn?o/K6aokjn__o<c<cod];B
0_oGemL02OoHf=SoemOGomKFe_oBd];obl_;okjn__na/K7ohn?SonSXj005onWYj@06onSXj?oShn?o
/K6aokjn__o<c<cod];B0_oGemL02OoHf=SoemOGomKFe_oBd];obl_;okjn__na/K7ohn?SonSXj007
onWYj@09oooooom4A4Co<`0col`0c?mV<fKoIVIVoa400?nIIP3oc9T000;o06K<0_nI09T00onk^k_o
MgMgolc<c00?onWYj@03onOWiooXj>SojNWY043ojNWY00?oeMGEonWYjOoYjNT03?oYjNT00ooXj>So
jNWYonWYj@04onWYj@04onk^k_odm?ConOWiomkNg_ook^k^Qoo^k^h001Wooooo00?oXZ:Roooooooo
ool05_ooool01_oPh>3oo_knoo_knoofm_Kolo?cooCdm0?olo?c00Kol_;bom7AdOnb/[;oc/k>omcL
g?oVi^H3onSXj006onKVi_oLg=coc/k>ok:b/_oAdM7olO7a1ooclo<01_oalO7odM7Aok:b/_o>c/ko
g=cLonKViP?oj>SX00Koi^KVomcLg?o>c/ko/[:bom7AdOoalO47oo?cl`06oo7alOoAdM7o/[:bolk>
c_oLg=coi^KV0ooXj>P01_oVi^Kog=cLolk>c_nb/[;odM7Aoo7al@Solo?c00Cooooooc<c<oo<c<co
A4A40_l000002_lc03?oIVH0ooo<0?nIIP3oIP1Vol`0oomV06KoIS=VogMgMonk^k]Boo?cl`03om_K
fooclo?olo?c017olo?c00Kom?Cdoo?cloofm_Kono_kookno_oPh>3oooooohOooooo000Ionk^kP03
ojBTY?o^k^kok^k^01Kok^k^00Gohn?SooWinOojn_[on_[jooWin@02oo[jnP?onOWi04ComoOgolW9
bOnm_KgogMgMonk^k_oemOGom_KfooGemOo^k^kogMgMokfm_Oo8b<SomoOgooShn?ojn_[onOWioo[j
n_oinOWon_[iooWinOojn_[on?ShooOgmoo8b<So_KfmomgMgOo^k^komOGeooKfm_oemOGok^k^omgM
gOnm_Kgob<S8ooOgm_ohn?Son_[jooWinOojn_[onOWioo[jn_oinOWon_[iooShn?ogmoOob<S8okfm
_OoMgMgok^k^ooGemOofm_KomOGeonk^k_oMgMgo_KfmolS8b?ogmoOon?Shoo[jnOoinOWon_[jooWi
nOojn_[onOWioo[jn_oinOWoooooogMgM`;ok^k^00?o8R8RoiT0VOmV<fH00_mV06H0JOlc03?oVFH0
oa4A4Oo<c<cok^k^ogMgMoo<c<con_[iooWinOojn_[onOWioo[jn_oinOWon_[jooWinOojn_WonOWi
oo[jn_oinOWon_[jooWinOojn_[onOWioo[jnOoinOWon_[jooWinOojn_[onOWioo[jn_oinOWon_[i
ooWinOojn_[onOWioo[jn_oinOWon_[jooWinOojn_WonOWioo[jn_oinOWon_[jooWinOojn_[onOWi
oo[jnOoinOWon_[jooWinOojn_[onOWioo[jn_oinOWon_[iooWinOojn_[onOWioo[jn_oinOWon_[j
ooWinOojn_WonOWioo[jn_oinOWon_[jooWinOojn_[onOWioo[jnOoinOWon_[jooWinOojn_[onOWi
oo[jn_oinOWon_[iooWinOojn_[onOWioo[jn_oinOWon_[jooWinOojn_WonOWionSXj?oinOWon_[j
ooWinOojn_[onOWioo[jnOoinOWon_[jooWinOojn_[onOWioo[jn_oinOWon_[jooWin@02oo[jnP03
ooWinOojn_[on_[j00?on_[j00?onOWion?Shoo^k^h0ooo^k^j6onk^kP006OoVi^H00onWYjOoi^KV
onKViP0GonKViP04oo7alOogmoOom?Cdono_k`GokNg]00gok>c/on?Shono_koo]KFeom3@d?oNg]ko
i>CTomkNg_o@d=3o]KFeokno_ooShn?ok>c/00WokNg]00gok>c/on?Shono_koo]KFeom3@d?oNg]ko
i>CTomkNg_o@d=3o]KFeokno_ooShn?ok>c/00WokNg]00gok>c/on?Shono_koo]KFeom3@d?oNg]ko
i>CTomkNg_o@d=3o]KFeokno_ooShn?ok>c/00WokNg]00KoooooodA4A?o^k^koVIVIoa4A4Om4A4@2
ol`0c004oiT0VOl0<fKoc9T0ogMgM`;ok^k^00?oMgMgolc<c?o]kNd0DOo]kNd00ooMgMgokNg]ong]
k@0:ong]k@04onc/k?o]kNgokNg]onc/k0CokNg]00Cokno_ooCdm?ogmoOolO7aoooVi^J8onKViP00
6Oo^k^h00onYZJWok^k^onk^kP0Gonk^kP05onc/k?ohn?Som?Cdonk^k_o[jn/00ooZj^X03?oYjNWo
j^[Zon[Zj_oYjNWocLg=okNg]onUYJGoW9bLojFUYOng]kOocLg=onWYj@goj^[Z00WojNWYolg=cOng
]kOoYJFUoibLW?nUYJGo]kNgolg=cOoYjNT03OoZj^X02OoYjNWocLg=okNg]onUYJGoW9bLojFUYOng
]kOocLg=onWYj@0;on[ZjP09oooooolc<c?ok^k^ogMgMolc<c?oIVIVoc<c<oo<0<coA4A400;o03=V
00GoMgMgonk^k_o^k^koMgMgok^k^`1Bon[ZjP03omWIfOoZj^[oj^[Z017oj^[Z00Gojn_[onk^k_od
m?Con?Shonc/k03oonk^kXSok^k^000Iooooo`03ojb/[?oooooooooo01Sooooo00?ol?3`oo_knoof
m_H02_odm?@3oo?cla?om?Cd0ooclo<CooCdm0?olo?c3_odm?@00oooooooMgMgonk^kP03onk^kP06
ok^k^omV<fKoooooonk^k_nIVIWoR8R80_o^k^h00omgMgOoc<c<ooCdm01AooCdm003omoOgoodm?Co
m?Cd00gom?Cd00?olo?cooCdm?odm?@00_odm?@00oogmoOono_koo3`l03oooooohWooooo000Ionk^
kP03ojj^[_o^k^kok^k^01Sok^k^00?ol?3`oo7alOojn_X0Aoojn_X00ooooooo<c<cooooo`0;onk^
kP03ogMgMoo<c<con_[j057on_[j00?oj^[Zoo[jn_ojn_X04oojn_X00ooalO7ol?3`onk^kP3oonk^
kXSok^k^000IonKViP03ok6a/OoVi^Koi^KV01Woi^KV00Coj>SXonc/k?oalO7omoOgAOohn?P00ooo
oooo<c<cogMgM`0<ogMgM`03ooooooohn?Son?Sh053on?Sh00?ojn_[ooShn?ohn?P04?ohn?P01?og
moOolO7aonc/k?oXj>SoonKViX[oi^KV000Ionk^kP03ok>c/oo^k^kok^k^01cok^k^_?oShn?oonk^
kXgok^k^000Iooooo`03okJf]_oooooooooo0<Cooooo00?o][Jfooooooooool0oooooonNooooo`00
6Oo^k^h00onh^;Sok^k^onk^kP34onk^kP03okRh^?o^k^kok^k^0?ook^k^W_o^k^h001Woi^KV00?o
^k^kogmoOomoOgl0a?moOgl00onk^k_oi^KVonKViP3oonKViYkoi^KV000Ionk^kP05okfm_Oo[jn_o
inOWonCTi?oQhN401?oPh>03on7Qh@05on3Ph?oQhN7oh>3Pon3Ph?oOgml00_oPh>005?oQhN7oh>3Q
on7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Q
on3PhOoPh>3ogmoO0_oPh>004OoQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3o
hN7Qon3PhOoQhN7oh>3Pon7QhOoPh>3ohN7Q00;oh>3P07oogmoPon3Ph?oPh>3ohN7Qon3Ph?oQhN7o
h>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Qon3PhOoQhN7oh>3Pon7QhOoPh>3o
hN7Qon3Ph?oQhN7oh>3Qon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7o
h>3Pon7QhOoPh>3ohN7Qon3PhOoQhN7oh>3Pon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Qon7QhOoPh>3o
hN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Qon3PhOoQhN7o
h>3Pon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Qon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7o
hN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Qon3PhOoQhN7oh>3Pon7QhOoPh>3ohN7Qon3Ph?oQhN7o
h>3QomGEeOn^[Zkog]kNon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3o
hN7Qon3PhOoQhN7oh>3Pon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Qon7QhOoPh>3ohN7Qon3Ph?oQhN7o
h>3P00?ohN7Q00?oh>3Pon7QhOoQhN400ooPh>001?oShn?oj>SXon[Zj_nm_Kgoonk^kZ3ok^k^000I
ooooo`04ol30`?o`l?3ok>c/onOWi`Soh^;R0_oPh>001ooNg]kogMgMomgMgOoMgMgog]kNon3Ph?oQ
hN403OoRh^800ooQhN7oh>3PomkNgP03omgMg@03omkNg_oPh>3ohN7Q00goh^;R00?ohN7Qon3Ph?oN
g]h00ooMgMd00ooNg]koh>3Pon7Qh@1Lon;RhP03on3Ph?n:RX[o_kno01_oh^;R00?ohN7Qon;Rh_oR
h^801_oRh^801?oVi^Kok>c/oo3`l?o0`<3ooooooj3ooooo000Ionk^kP08ol;2`_o]kNgojNWYonGU
iOoRh^;ohn?Son;Rh_oTi>@2on?Sh`0=on7QhOoRh^;ogMgMomWIfOoEeMGod];Bom7AdOoBd];oeMGE
omWIfOoMgMgohN7Qon;RhP09on?Sh`0=on;Rh_oQhN7ogMgMomWIfOoEeMGod];Bom7AdOoBd];oeMGE
omWIfOoMgMgohN7Qon;RhP09on?Sh`0=on;Rh_oQhN7ogMgMomWIfOoEeMGod];Bom7AdOoBd];oeMGE
omWIfOoMgMgohN7Qon;RhP0Von?Sh`03omkNg_oIfMWohn?S00Sohn?S00?ofm_Kon;Rh_oShn<00_oN
g]h2on?Sh`03on7QhOoLg=cohn?S00[ohn?S00?of=SHon;Rh_oShn<03?oShn<00ooKfm_oh^;Ron?S
h`02omkNgP;ohn?S00?o]KFeoiNGUooShn<01OoShn<00ooNg]kofMWIon?Sh`0Don?Sh`03onCTi?oS
hn?oi>CT00Cohn?S00CoiNGUonWYjOo/k>co`/;2ooo^k^jPonk^kP006OoVi^H01?o5aLGok>c/onc/
k?o]kNd5onc/k01Eon_[jooYjNWoi>CTomcLg?oBd];obLW9ol?3`oo2`/;o`l?3olW9bOoBd];ogMgL
onCTi?oZj^[ojn_[ong]kOo/k>cokNg]onc/k?o]kNcok>c/ong]kOo[jn_oj^[ZonCTi?oMgMgod];B
olW9b?o3`l?o`/;2ol?3`oo9bLWod];BomgMgOoTi>Coj^[Yon_[joo]kNgok>c/ong]kOo/k>cokNg]
onc/k?o]kNcojn_[on[Zj_oTi>CogMgMom;Bd_o9bLWo`l?3ol;2`Oo3`l?obLW9om;Bd_oMgMgoi>CT
on[Zj_o[jn_okNg/onc/k?o]kNgok>c/ong]kOo/k>cokNg]onc/k?o]kNcok>c/ong]kOo/k>cokNg]
onc/k?o]kNgok>c/ong]k?o/k>cokNg]onc/k?o]kNgok>c/ong]kOo/k>cokNg/oiJFUP02ogmoO`0`
oh:2P_nCTi?o/;2`onKVi_o]kNcok>c/ong]kOoQhN7oWYjNoh20P?n>SXkoR8R8om;BdOo/k>co];Bd
oi^KVoo]kNgok>c/ong]kOnQXJ7oPX:2ohZ:R_o2`/;oQhN7ojBTY?o/k>codM7AohZ:R_n2PX7oXZ:R
okRh^?nCTi?okNg]onc/k?nJVY[o]KFeong]k?o/k>cof][Johj>S_n;Rh_oc/k>ong]kOo/k>cokNg/
onc/k?o]kNgoUYJF1?moOgl09onHV9Ook>c/oj6QXOn2PX;oRXZ:ol71`On7QhOoY:BTong]k?o/k>co
_KfmogmoOooKfm_ok>c/ong]kOo/k>coh^;QoijNW_n0P83oSHf=ong]kOo/k>cokNg]onc/k?o]kNco
k>c/ong]kOo/k>cokNg]onc/k?o]kNgok>c/ong]k?o/k>cokNg]onc/k?o]kNgok>c/ong]k@0<onc/
k003olG5aOoVi^Koi^KV0?ooi^KVW_oVi^H001Wok^k^00CoalO7oo3`l?o]kNgoj>SX1OoVi^H0OooT
i>Cog]kNom?Cdoo5aLGo^;Rhok6a/On/[:coZj^[ojb/[?na/K7o^;RholG5a?oCdm?og]kNon?ShooV
i^KoiNGUonKVi_oUiNGoi^KUonGUiOoVi^Kohn?SomkNg_oCdm?oaLG5okRh^?na/K3o[:b/oj^[Zon/
[:co/K6aokRh^?o5aLGodm?ComkNgOoShn?oi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KUon?ShooN
g]kodm?ColG5aOnh^;So/K6aojb/[?n[Zj[o[:b/ok6a/Onh^;SoaLG5om?CdooNg]kohn?SonKViOoU
iNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KUonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoV
i^GoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKViOnDU9Co[Jf]onGUiOoQhN7od=3@oiZJV_n<
S8cogmoOonGUiOoVi^KoVYZJoiRHV?oHf=Soi^KVon3Ph?oPh=ooiNGUok6a/OnIVIWoi^KVonGUiOo>
c/koP820omSHeooKfm_oXj>SohF5QOoVi^KoiNGUoj2PX?nRXZ;oh^;Qokjn__n5QHGoTY:BonKVi_oU
iNGoV9RHok6a/OoVi^GoiNGUojb/[?nIVIT00_oUiND0<_oVi^KoiNGUonKViOoUiNGoi^KVoiBDU?n]
[JgoiNGUonKVi_oUiNGoi^KUolk>c_n0P83oemOGom_KfonSXj?oQHF5onGUiOoVi^GoiNGUoi6ATOn2
PX;o[:b/onGUiOoVi^KoiNGUoiZJV_nHV9SofMWIonGUiOoVi^KoiNGUonKVi_oUiNGoi^KUonGUiOoV
i^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^GoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGU1?oVi^H0
2?oUiNGoi^KVonKVi_oVi^Koj>SXonc/k?o`l?3oalO7ooo^k^jPonk^kP006Oooool01?o:b/[om_Kf
oo7alOo]kNd2onOWi`0ConSXj?oWinOoi^KVon7QhOoGemOoalO7okJf]_nj^[[ocLg=omoOgooXj>So
gmoOolg=cOnk^k_o][JfolK6a_oGemOohN7QonKViP05onOWi`0AonKVi_oQhN7oemOGolK6a_nf][Ko
^[Zjolg=cOoOgmooj>SXomoOgoo=cLgo^k^kokJf]_o6a/KoemOGon7QhOoVi^H01OoWinL04OoVi^Ko
hN7QomOGeoo6a/Ko][JfokZj^_o=cLgogmoOonSXj?oOgmoocLg=ok^k^onf][Koa/K6omOGeooQhN7o
i^KV00OoinOW00?oooooohR8R?m4A4@01_m4A4@00olc<c?oA4A4odA4A003odA4A004oiVIVOoWinOo
UIFEojj^[P?oinOW00Ooi>CToh^;Ron][JgoinOWomWIfOmoOgoob/[:00GoinOW00[o/K6aoiVIVOoW
inOoinOWomOGeon0P83oc<c<onOWiono_kooS8b<0_oWinL01_n@T93o^KVionOWiooWinOo/;2`oi:B
TP;oinOW00KoVIVIok:b/_oWinOoinOWoijNW_n][Jd7onOWi`03oiFEUOn^[ZkoinOW00?oinOW00Ko
emOGoh20P?o<c<coinOWokno_on<S8`2onOWi`09om;Bd_moOgoo_knoohJ6Q_oTi>CoinOWomWIfOmo
Ogoob/[:01goinOW00Goj>SXong]kOo`l?3om_Kfol[:bP3ooooooj3ooooo000Ionk^kP04olc<c?oc
lo?ol?3`on_[j`Coj>SX00Ooi^KVomgMgOo>c/ko^[ZjolC4a?oWinOok^k^00?okno_00Ook^k^onWY
jOo5aLGo^k^kolk>c_oMgMgoi^KV00Goj>SX00Ooi^KVomgMgOo>c/ko^[ZjolC4a?oWinOok^k^00?o
kno_00Ook^k^onWYjOo5aLGo^k^kolk>c_oMgMgoi^KV00Goj>SX00Ooi^KVomgMgOo>c/ko^[ZjolC4
a?oWinOok^k^00?okno_00Ook^k^onWYjOo5aLGo^k^kolk>c_oMgMgoi^KV00Ooj>SX00?oooooodA4
A?mVIVH00omgMgL00omVIVKoMgMgogMgM`05ogMgM`05oc<c<oo<c<coj>SXoiFEUOn^[Zh01?oXj>P0
1Onb/[;oSHf=onSXj?o=cLgoOgmo00CoV9RH00Coclo?onSXj?nb/[;oVYZJ0ooXj>P01Oo6a/KoTi>C
oiBDU?nEUIGoS8b<00;oj>SX00KoTI6Aok^k^ooXj>Soj>SXokVi^OnBTY82onSXj006oiVIVOnc/k?o
j>SXonSXj?nNWYko[Jf]1ooXj>P00onEUIGo[Zj^onSXj004onSXj005olK6a_nCTi?oU9BDoiFEUOn<
S8`00_oXj>P02?nZZZ[oVIVIonSXj?n?Shoo`/;2onSXj?o=cLgoOgmo0onHV9PLonSXj004on_[joo`
l?3olo?colc<c?ook^k^X?o^k^h001Woi^KV00?oclo?oo;bl_obl_801Oobl_801_o^k^kohn?Solg=
cOo7alOoinOWoo7al@;omOGe00Wom_KfooGemOoemOGolo?conWYjOo7alOocLg=on?Shoo^k^h01Oob
l_801_o^k^kohn?Solg=cOo7alOoinOWoo7al@;omOGe00Wom_KfooGemOoemOGolo?conWYjOo7alOo
cLg=on?Shoo^k^h01Oobl_801_o^k^kohn?Solg=cOo7alOoinOWoo7al@;omOGe00Wom_KfooGemOoe
mOGolo?conWYjOo7alOocLg=on?Shoo^k^h01oobl_803?oooooo<c<conk^k_o^k^ko^k^kogMgMonZ
ZZ[oooooonk^k_oMgMgoMgMgomgMg@;ok^k^00GoMgMgolc<c?obl_;oUiNGok>c/`04oo;blP0=olK6
a_n0P83okno_on7QhOmoOgooc<c<omcLg?oHf=SoP820onKVi_obl_;o][JfoibLW005oo;blP03oo7a
lOo1`L7oSHf=00;ol_;b00KoTY:Bol71`Oobl_;ol_;bokno_onDU9@2oo;blP06oi^KVonh^;Sol_;b
oo;bl_nQXJ7o/[:b1oobl_800onGUiOo/k>coo;blP06oo;blP0@oo7alOo1`L7oSHf=oo;bl_o]kNgo
QHF5olS8b?obl_;o_knooiZJV_obl_;ohN7QogmoOoo<c<cog=cLomSHf1_ol_;b00Golo?coo;bl_ob
l_;ol_;bolo?c`3oonKViZ3oi^KV000Ionk^kP04om7AdOofm_Kol_;bong]k@?ojn_[00[oj^[ZonKV
i_oIfMWo`<30omKFe_oTi>Cojn_[oo3`l?oalO7ol_;b0_oalO401oo/k>coi^KVomOGeoo0`<3ofMWI
onKVi_oZj^X00oo[jn/02_oZj^[oi^KVomWIfOo0`<3oe]KFonCTi?o[jn_ol?3`oo7alOobl_82oo7a
l@07onc/k?oVi^KoemOGol30`?oIfMWoi^KVon[ZjP03on_[j`0:on[Zj_oVi^KofMWIol30`?oFe]Ko
i>CTon_[joo`l?3olO7aoo;blP;olO7a00Ook>c/onKVi_oGemOo`<30omWIfOoVi^Koj^[Z00Kojn_[
00Kooooooc<c<oooooook^k^ogMgMol0<l`2oc<c000;odA4A?lc03?o000RofH0I_mgMgOoooooogMg
Monk^k_ojn_[oiFEUOn`/;001?o[jn/05Onk^k_oPH61onWYjOo[jn_oVIVIojb/[?oWinOo`L71oi6A
TOo[jn_oj>SXok2`/?nIVIWoi^KVonSXj?o[jn_obl_;om_KfooYjNWoZ:RXoj:RXP02on_[j`06oi6A
TOnm_Kgojn_[on_[jonk^k_oTi>C0_o[jn/02?nJVY[o];Bdon_[jooXj>SoWIfMojf][OoVi^KojNWY
1Oo[jn/00onEUIGo/;2`on_[j`04on_[j`0Bol_;booKfm_ojNWYojRXZ?nRXZ;ojn_[olC4a?n4Q8Co
i^KVon_[jooShn?oPX:2om[Jf_o[jn_oVIVIojb/[?oWinOo`L717?o[jn/01?o]kNgolo?cooGemOoA
dM7oonk^kZ3ok^k^000Iooooo`04omCDe?olo?com_Kfoo7al@;ojn_[00[ok>c/on_[jooWinOofMWI
okno_ooIfMWoh^;RonSXj?oZj^[ok^k^0_o_knl01oo[jn_oj>SXonCTi?oJf][o_[jnomWIfOoVi^H0
0_o[jn/02oo/k>cojn_/on_[jooVi^KofMWIokjn__oIfMWoh^;RonSXj?oZj^[ok^k^00;okno_00Oo
jn_[onSXj?oTi>Cof][Jokjn_ooIfMWoi^KV00;ojn_[00_ok>c/on_[joo[jn_oi^KWomWIfOnn_[ko
fMWIon;Rh_oXj>Soj^[Zonk^kP02ono_k`07on_[jooXj>Soi>CTom[Jf_nn_[kofMWIonKVi`02on_[
j`07onc/k?o[jn_ok>c/on_[joo/k>coooooogMgM`02onk^kP1[ofIVI_l0I_oo06K<odA4A?lc03?o
<c<cogMgMolc03?oR8R8onk^k_mVIVKoc<c<on_[k?nFUYKo/;2`onc/k?o[jn_ok>c/on_[jonRXZ;o
TI6Aonc/k?o[jn_ohN7QoifMWOn4Q8CoRXZ:olg=cOo[jnco_;blohB4Q?n1PH7oRXZ:okno_oo[jn_o
^KVioiBDU?n5QHGoUiNGom;Bd_o[jn_ok>c/oi^KVoo2`/;ojn_/onc/k?o0`<3oW9bLon_[joo/k>co
VYZJokFe]Oo[jnco]KFeoh:2P_n4Q8CoRXZ:olW9bOo[jn_ok>c/on_[k?o/k>cojn_[oiJFU_n`/;3o
k>c/on_[joo/k>cojn_/onc/k?ni^KWoU9BDohF5QOnGUiOod];Bonc/k?nUYJGo[jn_on_[joo/k>co
jn_[ojf][Ong]kOok>c/on3PhOnMWIgoQ8B4ohZ:R_o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_o
k>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn/00_o/k>`00oo[jn_o
k>c/onc/k003onc/k005on_[jooalO7om_Kfooclo?oDe=@0oooooonPooooo`006Oo^k^h01?oFe]Ko
moOgooCdm?o_knl3ong]k@08on_[jooXj>Sofm_Kokjn__oJf][og]kNonCTi?oWinL3on[ZjP08onSX
j?oTi>Coh>3Pom[Jf_nn_[kofm_KonSXj?o/k>`3ong]k@08onc/k?oXj>Sofm_Kokjn__oIfMWogmoO
onCTi?oWinL3on[ZjP08onSXj?oTi>Coh>3Pom[Jf_nn_[kofm_KonSXj?o/k>`3ong]k@08onc/k?oX
j>Sofm_Kokjn__oIfMWogmoOonCTi?oWinL3on[ZjP08onSXj?oTi>Coh>3Pom[Jf_nn_[kofm_KonSX
j?o/k>`6ong]k@05oooooolc<c?ok^k^omgMgOlA4A400_l0I_l03?lcI/co8R8RohR8R?nIVIWo8R8R
omgMgOo^k^koMgMgolc<c?o]kNgoUYJFok6a/@?okNg]00?o`l?3ogmoOoo4a<@01?o]kNd00oo[jn_o
kNg]ong]k@02ong]k@03okFe]OnKVi_okNg]00CokNg]00?ok>c/ong]kOo]kNd02_o]kNd01_nJVY[o
]KFeong]kOo]kNgoX:2Pok2`/0OokNg]00?oUYJFok6a/Oo]kNd01_o]kNd00oo/k>cokNg]ong]k@0;
ong]k@03on_[joo]kNgokNg]01[okNg]00Gok>c/oo3`l?odm?ComoOgomKFeP3oonk^kZ3ok^k^000I
onKViP05omWIfOofm_Kom_KfooKfm_oemOD00oofm_H01oobl_;oi^KVokbl_?oJf][oh>3Pon?ShooW
inL00ooZj^X01ooXj>Soi>CTon7QhOoKfm_o_KfmonOWioobl_801Oofm_H01oobl_;oinOWokbl_?oJ
f][oh>3Pon?ShooWinL00ooZj^X01ooXj>Soi>CTon7QhOoKfm_o_KfmonOWioobl_801Oofm_H01oob
l_;oinOWokbl_?oJf][oh>3Pon?ShooWinL00ooZj^X01ooXj>Soi>CTon7QhOoKfm_o_KfmonOWioob
l_801oofm_H01_oooooo<c<conk^k_lc<c?o<`0co`004@;o8R8R017o03<coc<0<olA003o0000oc<c
<onk^k_oMgMgok^k^oofm_KoV9RHoiBDU?n][JgoXj>SoiBDU?n2PX;o`L71ooGem@09ooKfmP03omGE
eOn=SHgom_Kf017om_Kf00KoW9bLokZj^_ofm_Kom_KfonOWiooVi^H7ooKfmP03oiRHV?ne]KGom_Kf
02oom_Kf00?omOGeooKfm_oemOD00oofm_H00ooIfMWoi^KVonKViP3oonKViYkoi^KV000Ionk^kP05
om_Kfoohn?Som_Kfoo7alOo]kNd00oo^k^h01oo/k>cohn?Sok6a/Oo>c/koe=CDomWIfOoKfm/00_oN
g]h02?oOgmoog=cLomWIfOoEeMGoc/k>ok6a/OoShn?ok>c/1Oo^k^h01oo/k>cohn?Sok6a/Oo>c/ko
e=CDomWIfOoKfm/00_oNg]h02?oOgmoog=cLomWIfOoEeMGoc/k>ok6a/OoShn?ok>c/1Oo^k^h01oo/
k>cohn?Sok6a/Oo>c/koe=CDomWIfOoKfm/00_oNg]h02?oOgmoog=cLomWIfOoEeMGoc/k>ok6a/OoS
hn?ok>c/1oo^k^h04_ooooooMgMgofHcI_mV<fKoMgMgohR8R?mVIVKo<c<0o`0cc?l0I/co<`1Vo`00
0?mV<fKo<c<cogMgMoo<c<cok^k^ol_;b`;o`/;200?oaLG5omCDe?oUiND02oo^k^h01Oo[jn_oWIfM
ohj>S_n;Rh_og=cL00ook^k^00?oVYZJokJf]_o^k^h02_o^k^h00oo;bl_oe]KFonk^kP0bonk^kP04
oo7alOoemOGonOWiom_Kfoook^k^X?o^k^h001Wooooo00Cog]kNookno_oinOWolo?c1?o^k^h01_o]
kNgoj>SXokFe]Oo2`/;od=3@omKFeP;ofm_K00Wog=cLom_KfooJf][oe]KFolo?coo2`/;o]KFeonSX
j?o]kNd01Oo^k^h01_o]kNgoj>SXokFe]Oo2`/;od=3@omKFeP;ofm_K00Wog=cLom_KfooJf][oe]KF
olo?coo2`/;o]KFeonSXj?o]kNd01Oo^k^h01_o]kNgoj>SXokFe]Oo2`/;od=3@omKFeP;ofm_K00Wo
g=cLom_KfooJf][oe]KFolo?coo2`/;o]KFeonSXj?o]kNd01oo^k^h02OooooooA4A4oc<0<oo<0<co
IS=VofIVI_lA003oVFH0olbI0002o`1Vc0;oV@2I00?o^k^kogMgMoo<c<`05?o^k^h00ooTi>Coi^KV
onk^kP0?onk^kP03onc/k?o]kNgok^k^03Sok^k^00?okNg]onk^k_o^k^h01?o^k^h01?oclo?onOWi
ookno_oNg]kooooooj3ooooo000Ionk^kP06on3Ph?oinOWom_Kfoo7alOo^k^kokno_0oo^k^h01_o]
kNgocLg=ojn_[oo;bl_ofMWIon?Sh`?oiNGU00Kohn?SomWIfOo;bl_o[jn_olg=cOo/k>`7onk^kP06
onc/k?o=cLgo[jn_ol_;booIfMWohn?S0ooUiND01_oShn?ofMWIol_;bon_[joocLg=onc/k0Ook^k^
00Kok>c/olg=cOn_[joobl_;omWIfOoShn<3onGUi@06on?ShooIfMWobl_;ojn_[oo=cLgok>c/2?o^
k^h01?oooooo<c<colc<c?m4A4@2o`00000:oc<0<omVIP3ool`0oiUV0?mV06Koc03oofH0I_mV<fKo
MgMgok^k^fKok^k^00Kokno_onk^k_oalO7om_KfooWinOoPh>3oonk^kZ3ok^k^000IonKViP05on?S
hoogmoOon?ShooShn?ogmoL00_ohn?P3ooOgm`14ooGemOo7alOo^k^kom_Kfoo]kNgolo?cooGemOoc
lo?okNg]om_Kfonl_;_oa/K6ooGemOofm_Kon?ShooOgmoohn?SomoOgooShmoogmoOon?ShooKfm_oe
mOGoa/K6okbl_?oKfm_okNg/oo?clooemOGolo?cong]kOoKfm_o_;blolK6a_oemOCom_KfooShn?og
moOon?ShooOgmoohn?SomoOgooShmoofm_KomOGeolK6a_nl_;cofm_Kong]kOoclo?omOGdoo?cloo]
kNgofm_Kokbl_?o6a/KomOGeooKfm_ohn?OomoOgooShn?ogmoOon?ShooOgmoohn?SomoOgoooooomg
MgL2onk^kP03ob8R8_nI09WoIS=V00;oIP1V06Wo<`0coiUV0?lA4A7oc<c<onk^k_mgMgOoc<c<ooSh
moogmoOon?ShooOgmoohn?SomoOgooShn?ogmoOon?SgooOgmoohn?SomoOgooShn?ogmoOon?ShooOg
moohn?OomoOgooShn?ogmoOon?ShooOgmoohn?SomoOgooShmoogmoOon?ShooOgmoohn?SomoOgooSh
n?ogmoOon?SgooOgmoohn?SomoOgooShn?ogmoOon?ShooOgmoohn?OomoOgooShn?ogmoOon?ShooOg
moohn?SomoOgooShmoogmoOon?ShooOgmoohn?SomoOgooShn?ogmoOon?SgooOgmoohn?SomoOgooSh
n?ogmoOon?ShooOgmoohn?OomoOgooShn?ogmoOon?ShooOgmoohn?SomoOgooShmoogmoOon?ShooOg
moohn?SomoOgooShn?ogmoOon?SgooOgmoohn?SomoOgooShn?ogmoOon?ShooOgmoohn?OomoOgooSh
n?ogmoOon?ShooOgmoohn?SomoOgooShn?ogmoL00_ohn?P00oogmoOon?ShooShn003ooShn003ooOg
mooShn?oi^KV0?ooi^KVWooVi^H001[ok^k^00ColO7aooWinOofm_KolO7a1Oo_knl03Oo^k^koiNGU
ol71`Onf][KodM7AomoOgooUiNGogmoOom7AdOnf][Ko`L71onGUiOo^k^h02Oo_knl03Oo^k^koiNGU
ol71`Onf][KodM7AomoOgooUiNGogmoOom7AdOnf][Ko`L71onGUiOo^k^h02Oo_knl03Oo^k^koiNGU
ol71`Onf][KodM7AomoOgooUiNGogmoOom7AdOnf][Ko`L71onGUiOo^k^h02Oo_knl01_ooooooA4A4
onk^k_nIVIWo4A4AodA4A0;oc03<00CoV@2Io`0cI_o<V@3oMgMg0_o^k^h00omgMgOoc<c<ono_k`1N
ono_k`04onk^k_o_knookno_onk^kPCokno_00ColO7aooKfm_oinOWolO7aooo^k^jQonk^kP006_oo
ool01Oo/k>cooOgmooWinOoclo?ol?3`00?okno_00cok^k^ono_koo_knook^k^om7AdOnk^k_oZ:RX
oinOWonXZ:So^k^kom7AdOo^k^h=ono_k`09onk^k_oAdM7o^k^kojRXZ?nOWiooZ:RXok^k^ooAdM7o
k^k^00gokno_00Wok^k^om7AdOnk^k_oZ:RXoinOWonXZ:So^k^kom7AdOo^k^h02oo_knl02Ooooooo
<c<conk^k_mgMgOo<c<cofIVI_lc<c?oc03<odA4A002o`0cIP05ogMgMoo^k^kok^k^ogMgMonk^k/0
I_o_knl01Oo`l?3olo?cooWinOomoOgok>c/0?ooooooXOooool001[ok^k^00Cokno_oo3`l?ofm_Ko
lO7a2_o_knl3onk^kQ?okno_0oo^k^hCono_k`?ok^k^3_o_knl00oooooooMgMgonk^kP03onk^kP06
ok^k^omV<fKoooooonk^k_nIVIWoR8R80_o^k^h00omgMgOoc<c<ono_k`1Qono_k`03onk^k_o_knoo
kno_00;okno_00Col_;booKfm_o`l?3okno_ooo^k^jQonk^kP006ooVi^H00ooZj^[olO7aooShn017
ooShn003oooooolc<c?ooooo00_ok^k^00?oMgMgolc<c?ohn?P0Ioohn?P00ooalO7oj^[ZonKViP3o
onKViZ7oi^KV000Lonk^kP04ono_koo/k>colO7aooWinDGon_[j00?ooooooc<c<omgMgL03?mgMgL0
0ooooooon_[joo[jnP1Soo[jnP04ooWinOoalO7ok>c/ono_koook^k^Xoo^k^h001oooooo_?oShn?o
ooooojKooooo003oonk^k_ook^k^P_o^k^h00?ooi^KVoooVi^J2onKViP00ooo^k^koonk^kX;ok^k^
003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP00oooVi^KoonKViX;oi^KV003oonk^k_oo
k^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^003oonKVi_ooi^KVP_oVi^H0
0?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h00?ooi^KVoooV
i^J2onKViP00ooo^k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP00
oooVi^KoonKViX;oi^KV003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^
kX;ok^k^003oonKVi_ooi^KVP_oVi^H00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003o
onk^k_ook^k^P_o^k^h00?ooi^KVoooVi^J2onKViP00ooo^k^koonk^kX;ok^k^003ooooooooooooo
P_ooool00?ook^k^ooo^k^j2onk^kP00oooVi^KoonKViX;oi^KV003oonk^k_ook^k^P_o^k^h00?oo
oooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^003oonKVi_ooi^KVP_oVi^H00?ook^k^ooo^k^j2
onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^k^h00?ooi^KVoooVi^J2onKViP00ooo^
k^koonk^kX;ok^k^003oooooooooooooP_ooool00?ook^k^ooo^k^j2onk^kP00oooVi^KoonKViX;o
i^KV003oonk^k_ook^k^P_o^k^h00?oooooooooooon2ooooo`00ooo^k^koonk^kX;ok^k^003oonKV
i_ooi^KVP_oVi^H00?ook^k^ooo^k^j2onk^kP00oooooooooooooh;ooooo003oonk^k_ook^k^P_o^
k^h00?ooi^KVoooVi^J2onKViP00oomoOgmGogmoO`OoOWinoomoOglTogmoO`0000Cojn_[onKVi_oR
h^;og]kN1?oMgMd3omkNgP3oomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oM
gMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oN
g]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oM
gMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoN
g]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oM
gMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoN
g]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oM
gMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoN
g]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oM
gMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oN
g]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oM
gMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoN
g]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oM
gMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoN
g]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oM
gMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoN
g]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oM
gMgog]kNomgMgOoNg]kogMgM000FomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgM
g_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oLg=cogMgMom_Kf`;og=cL03?ogMgM
omgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgM
omkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kN
omgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgM
omkNg_oMgMgog]kNomgMg_oNg]h00_oLg=`01OoIfMWof=SHomOGeooHf=SofMWJ00;og=cL0?oog]kN
omgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgM
omkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kN
omgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgN
omkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kN
omgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgM
omkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kN
omgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgM
omkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kN
omgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgM
omkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kN
omgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgN
omkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kN
omgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgM
omkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kN
omgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgM
omkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kN
omgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]h001Oo
gMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMko
g]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMgP03omkNgP03omgMgOoNg]kog]kN00?ogMgM0OoQ
hN41onOWi`7oj^[Z00000oo/k>coi^KVon3Ph007omWIf@04omSHf?oFe]Kodm?Colo?c`?ocLg=00Co
d=3@om?CdooGemOof=SH2ooIfMT01?oHf=SoemOGom?Cdoo@d=03olg=c@04om3@d?oCdm?oemOGomSH
f0;ofMWI00?of=SHomWIfOoIfMT01_oIfMT01?oHf=SoemOGom?Cdoo@d=03olg=c@06om3@d?oCdm?o
emOGomSHf?oIfMWof=SHfOoIfMT2omSHf006omKFe_oCdm?odm?ComCDe?oGemOof=SH0_oIfMT00ooH
f=SofMWIomWIf@02omSHf0WofMWI00?of=SHomWIfOoIfMT00_oHf=P00ooIfMWof=SHomSHf002omSH
f1OofMWI00Cof=SHomKFe_oBd];oclo?0_o=cLd01?o?cloodm?ComOGeooHf=Q_omWIf@03omSHf?oI
fMWofMWI0:?ofMWI00?of=SHomWIfOoIfMT01_oIfMT1omkNgP7oi^KV0Oo/k>`00007onk^k_oYjNWo
i>CTon3Ph?oQhN7oh>3Pon;RhP02on7Qh@0=omkNg_oLg=codm?ColO7aonk^k_o/[:bojj^[_na/K7o
^k^kolO7aooCdm?ofm_KomoOg`09on7Qh@0=omoOgooKfm_odm?ColO7aonk^k_o/[:bojj^[_nb/[;o
^k^kolO7aooCdm?ofm_KomoOg`09on7Qh@0=omoOgooKfm_odm?ColO7aonk^k_o/[:bojj^[_nb/[;o
^k^kolO7aooCdm?ofm_KomoOg`3Jon7Qh@09on3Ph?oOgmoofm_KomKFe_oDe=Coe]KFom[Jf_oNg]ko
h>3P00KogmoO0ooPh>000ooOgmooh>3Pon3Ph002on3Ph0SogmoO0_oNg]h2omoOg`?oh>3P0_oOgml2
on3Ph0;ogmoO3OoPh>001OoOgmoogMgMomWIfOoEeMGodm?C00;od];B00?oe]KFomcLg?oPh>00oooQ
hN4Hon7Qh@03on;Rh_oQhN7oh^;R00CohN7Q0OoTi>@1onWYj@7okNg]00000oo`l?3okno_oo7al@03
oo3`l03oono_koo`l?3ok^k^onSXj?oKfm_o`L71oj>SXon<S8coNg]kogIfM_mkNg_oS8b<ojBTY?o2
`/7of][Jon[Zj_o]kNgolO7aono_kooalO7okno_oo7akoo_knoolO7aong]kOoZj^[of][Jol;2`_nT
Y:CoS8b;og]kNomgMgOoNg]kohb<S?nTY:Co`/;2om[Jf_oZj^Sok>c/oo7alOo_knoolO7aono_kooa
lO7okno_oo7akoo]kNgoj^[Zom[Jf_o2`/;oY:BTohb<S?mkNg_oMgMfog]kNon<S8coY:BTol;2`_oJ
f][oj^[Zong]kOoalNook^k^oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooa
lO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_
knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooa
lO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_
knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooa
lNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_
knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooa
lO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_
knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooa
lO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_
knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooa
lO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_
knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooa
lNookno_000Koo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7a
lOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNook^k^ono_kooZj^[oinOW00;o
h>3P00Oohn?Son_[jOo[jn_oj^[ZonKVi_oXj>SoinOW00;ojNWY01;ok^k/onc/k?o/k>coj>SXonc/
k?o]kNgol?3`onc/k?oZj^Soi^KVonSXj?oWinOojNWYonSXj?o[jn_oinOWonOWiOoUiND2onWYj@0?
onk^k_o]kNgokNg]onSXj?o[jnWok>c/onk^k_oYjNWoj^[Zon_[joo_knook>c/onc/j_oZj^[ok^k^
00;ok>c/0?ooj^[Zono_koo/k>cok>cZon[Zj_o^k^kok>c/ojn_[omfMWKoFEUIofi^K_ng]kKoh>3P
onWYjOo]kNgolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_
ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_
oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7a
ono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_
oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7a
ono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_
oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7a
ono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_koo`l>kokno_
oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_
ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_
oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7a
ono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_
oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7a
ono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_
oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7a
ono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_
oo7alOo_knl002golO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoo
lO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7o
kno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_oo3`l?o_knool?3`ono_koo`l?3o
kno_oo3`l?o_knl01?o`l?000003oo;bl_o^k^koinOW00CoiNGU013oi>CTomoOgooAdM7o/;2`ohZ:
R_mVIVKoDE5AodE5AOm2@T;oADE5oe5ADOmVIVKoRXZ9ok6a/OoAdM7og]kN0_oTi>@00ooUiNGoi>CT
onGUi002onCTi00?omkNg_oAdM7o/K6aohZ:R_mVIVKoDE5AodE5AOm2@T;oADE5oe5ADOmVIVKoRXZ:
ok6a/OoAdM3og]kN00;oi>CT0>goiNGUonCTi?oUiNGoi>CTonCThooNg]kodM7Aok6a/On:RX[oIVIV
oe5ADOm5ADGo@T92odE5AOmADE7oIVIVohZ:R_na/K7odM7AomkNg_oShn;oi>CTonGUiOoTi>CoiNGU
onCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGU
onCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGT
onCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CT
onGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGU
onCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGU
onCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGU
onCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGT
onCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CT
onGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGU
onCTi?oUiN@00_oTi>@0ooo5aLGo:2PXodA4A?n@T93odM7AomcLfooKfm_oemOGomCDe?oFe]Koe=CD
omGEeOoIfMWoh>3OomkNg_oJf][oe=CDomWIfOoNg]koh^;RomcLg?oGemKoe=CDomKFe_oDe=CoeMGE
omSHf?oKfm_oemOGomKFeOoEeMGoemOGomSHf?oNg]kogmoOomcLg?oEeMGoemOFomcLg?oMgMgoemOG
omKFe_oKfm_ohN7QomkNg_oKfm[of][JomkNg_oLg=cof][Jom_KfooPh>3ogmoOomcLfooIfMWog]kN
omoOgomdM7CoIfMWohf=SOmDE5Co20P8oj:RX_oLg=coh^;RonGUiOoTi>CoiNGUonCTi?oUiNCoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGT
onCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CT
onGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGU
onCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGU
onCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGU
onCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGT
onCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CT
onGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGU
onCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGTonCTi000F?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>Co
iNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGo
i>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>Co
iNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCo
i>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>Co
iNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGo
i>CTonGUi?oTi>@4onGUi@06onCTi?oUiNGoiNGUonGUiOoXj>SokNg]0Oobl_800003ooCdm?o]kNgo
inOW00;oh>3P01?ohN7QomoOgooNg]kod];BokBd]?n7QhOoG5aLofdk=OnNCT;ocFmOonV3Koo=KUko
WTi3ofdk=_mLG5coQhN7okBd]?oBd];og]kN00Goh>3P017og]kNom;Bd_nd];CoQhN7oeaLG?m]H2co
WYH^olg=?ooYjDgocLdooijJ;om]HbgoG5aLohN7Qond];Cod];BomkNgP05on3Ph00AomkNg_oBd];o
];BdohN7QomLG5coAfL^ofRN<onAcDOoZ^UEoi7=AomZWSCoBFX_oeaLG?n7QhOo];Bdom;Bd_oNg]h0
fOoPh>001_oOgmooclo?oiVIVOnBTY;o6ATIohb<S0;oeMGE01ooclo?ol;2`_o>c/koc/k>olG5aOo:
b/[of][JomSHf?o@d=3obl_;olo?cooHf=Sof][JomGEeOo?cloo`L71om3@d?o>c/koa<C4ol_;booH
f=SoemOGokjn__nk^k_odM7Aom3@d?oEeMGof=SHom?Cdoo<c<coc/k>00;oeMGE00Goc/k>olc<c?oC
dm?of][JomSHf002om;BdP04omSHf?oGemOodM7Aom?Cd`;ofMWI00Kodm?Com7AdOoGemOof=SHom7A
dOo@d=02om7Ad@04odI6A_m1@D7oemOGomkNgVgoh>3P00?ogmoOon3Ph?oPh>001OoPh>000ooOgmoo
h>3Pon3Ph00bon3Ph003omoOgooPh>3oh>3P06Soh>3P00?ogmoOon3Ph?oOgml00_oOgml3on3Ph003
on7QhOoWinOok>c/007om?Cd00000oofm_Kol_;bon_[j`03onSXj00ConOWiooRh^;ocLg=oinOWom[
GeooScH^ona`H?oiWI3ooK6Uoofl[oom]:OonInConedHonB=booJemOoinOWoo=cLgoh^;RonOWi`03
onSXj00ConOWiooRh^;ocLg=oinOWom^IUooTg8RongAA?oilgCooOf=oogmUOomoHkonOQfongGAonC
Lb;oKVMOoinOWoo<c<coh^;RonOWi`03onSXj00ConOWiooRh^;ocLg=oinOWomPJ5ooBg`Soi;QBonm
nG_od?fBomSmVooDoIGo`?UnoiSXCOm=P2CoH6UOoinOWoo=cLgohN7QonOWi`3JonSXj004onKVi_oQ
hN7oGEeMode=C@;ogMgM01ooD51@o`L71olE5AGoQ8B4oaHF5_m3@d?oh^;RomgMgOnLW9co0000ohn?
SooMgMgohN7Qom_Kfom0@43o20P8oaTI6On8R8So2`/;oeQHF?ng]kOo30`<o`L71olS8b?o9bLWogem
OOoJf][ogMgMomCDe?l;2`_oFEUI00;ofMWI00?oGEeMo`/;2ooCdm<00_oOgml01_mJFU[oCTi>omkN
g_oNg]ko8b<SohB4Q0;ohN7Q00coNWYjobh^;_oMgMgogMgMol;2`_m@D53o<c<cofi^K_n3Ph?o8B4Q
omkNg_oVi^KoonSXj1ooj>SX0Oo/k>`1oo;blP7om_Kf00000oogmoOon?ShooShn003ooShn00CooOg
moo^k^koc/k>oi2@T?n5;R[ojFAFoo^BQoonYY_oo[6UoonhZoon/ZKooZRLoo^DROo^J5WoRC4[oi2@
T?o>c/kok^k^ooOgm`03ooShn00CooOgmoo^k^koc/k>oi2@T?nIJB_ol;dmoo_PK_onm8;oo_j:oooo
T_onoXcoo_R3oo_UL?o``SkoVFX[oi2@T?o>c/kok^k^ooKfmP03ooShn00CooOgmoo^k^koc/k>oi2@
T?m2Lb_oQ<i3ojg_Loo2oXSoc_j@omKoUoo@oY;oa_j9ok;eM?n8dd?oA7D[oi2@T?o>c/kok^k^ooOg
m`3JooShn00UooKfm_oalO7oPH61oalO7oo]kNgoa/K6o`000?o3`l?odm?CoeaLG?l820Soj^[Zoo3`
l?oZj^[oDU9Boa@D5?lm?CgojNWYoo3`l?n_[joo1`L7om;Bd_o=cLgoCTi>oa/K6oo^k^kofm_Kojj^
[_oXj>Sok>c/ojj^[_l0003o];Bdonc/k?n`/;3o2`/;oaXJ6P02onCTi00;ob<S8ol>3PkoY:BTong]
kOo^k^koH61PoeADE?o^k^kokNg]obHV9_n=SHd00_o`l?003?n2PX;o<C4aonc/k?oZj^[o@d=3obl_
;onLW9coLg=cobXZ:_lJ6Q[ok^k^ooKfmPoon?Sh00?omoOgooShn?ohn?P0Foohn?P00oogmoOon?Sh
ooShn005ooShn003ooOgmoohn?Son?Sh03Oon?Sh00?omoOgooShn?ohn?P0IOohn?P00oogmoOon?Sh
ooShn002ooShn004ooOgmooinOWomoOgooOgm`7on?Sh00000oojn_[omOGeonk^kP02onc/k03oon_[
jooYjNWogmoOokZj^_miDU;o_c8TonMdJOomRGkooiR<oojRU_ooYi_ooZBHoonJSOonRWookWIZol<c
9?miDU;o^[ZjomoOgooZj^[ojn_[onc/k?o[jncoj^[ZomoOgonj^[[oR6EBon:A7?oi`e3ooMYSoooZ
L_onlgkoooZ2ookfOoook7?oo]iToo[7DOoRTQcoRFICokVi^OoOgmooj^[Zon_[joo/k>cojn_[on[Z
j_oOgmoo^[Zjoe9]D_mAXacoTM9EojKWJ_nhnG[o`?j2olOoROo3oXCo^OekojO/K?nDeUOoDZHLoe9]
D_ni^KWogmoOon[Zj_o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/
k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[
joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/
k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[
joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/
k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[
k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/
k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[
joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/
k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[
joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/
k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[
joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/0019
onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/
on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/onWYjOoUiNGoNWYj
oa`L7?oQhN;oc<c<o`<30onPX:3og]kNoiBDU?lC4a?ohN7Qon3PhOo@d=3o1PH6oj6QXOl92@Wo_kno
on7QhOnj^[[o0P82ok:b/_oMgMgoP820obPX:?oShn?oinOWonGUiOoOgmoofm_Kom?Cdol820SoQHF5
omoOgomYJFWoBTY:ocDe=On][Jgo_Kfmo`L71omhN7SoEEEEomoOgooPh>3oFe]Koe1@D002on7Qh@0:
ob@T9?n5QHGogmoOon7QhOmkNg_o;bl_on3Ph?oDe=Co1@D5ojRXZ0;ohn?S07;oOWiooaHF5_oQhN7o
j^[Zon_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>co
jn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jnco
k>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>co
jn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_o
k>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>co
jn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_o
k>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>co
jn_[onc/k?o[jn_ok>c/on_[k?o/k>`3on_[j`2Tonc/k?o[jn_ok>c/on[Zjoo/k>cojn_[onc/k?o[
jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/
k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[
jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/
k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[
jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/
k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[
jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/
k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[
jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/
k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[
jn_ok>c/on_[joo/k>cojn_[onc/k?o[jn`6on_[j`05onc/k?o[jn_ojn_[onk^k_ofm_H00OoinOT0
0003oo_knooclo?okNg]00;oiNGU0?ooi^KVonCTi?oIfMWo/K6aogT^;_o8@S?ohfYLooAjKOomR7co
oYN:oojKS_onV8_ooXYnooAkKOoWJegobT8dog/^;_nb/[;of=SHonCTi?oUiNGoi^KVonGUi_oTi>Co
f=SHok:b/_nFEBkojY`[oo^lA?onc5?ooMQRookSL_onjGGoo^IcookKIOomc5?onl55onjN:onIERko
/[:bomSHf?oTi>CoiNGUonKVi_oUiNGoi>CTomSHfOnb/[;o;V8^of>]:on7bTSoUmaIojGUJOnblgOo
^?IkokCeNOnWjV_oV=aIohW?BomS[R_o;V<^ok:b/_oHf=Wohn?SonGUiOoVi^KoiNGUonKVi_oUiNGo
i^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^Ko
iNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGo
i^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^Ko
iNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGo
i^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^Ko
iNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKo
i^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^Ko
iNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGo
i^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^Ko
iNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGo
i^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^Ko
iNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGo
i^KVonGUiOoVi^KoiNGUonKVi_oUiNH003Coi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oV
i^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oU
iNKoi^KVonGUiOoVi^Kohn?SomoOgomgMgOo6a/KomcLg?oQhN7oWYjNobl_;ol[:b_o<S8boa8B4_oL
g=cof][KohB4Q?lP823oh>3Poe9BD_mXJ6Sof][JomkNg_n@T93o:RXZobh^;_l/;2co9bLW0_oNg]h0
4ooIfMWodm?Dom3@d?mKFe_o0000okfm_OoJf][o:2PXohN7QomgMgSoJ6QXoh:2P_ll?3co`/;2o`l?
3ooDe=Cof][JoeUIFOm>CTh00_oLg=`0oolS8b?oPH61omGEeOoGemOoMgMgobh^;_oLg=coXj>So`00
0?o7alOof=SHomWIfOn=SHko5ADEomcLg?oTi>CoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKV
i_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGU
iOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKV
i_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGU
i_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKV
i_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGU
iOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKV
i_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGU
iOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKV
i_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGU
iOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKV
i_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGU
i_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKV
i_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGU
iOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKV
i_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGU
iOoVi^KoiNGUonKVi_oUiNKoi^KVonGUi@009_oVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGU
onKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KV
onGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGV
0_oVi^H00ooUiNGoi^KVonKViP03onKViP03onGUiOo]kNgom?Cd007ono_k00000oolo?con?Shoo7a
l@03onk^kP0Con_[jooQhN7o_;blogXG5oo3?c;odeI9onAXF_o^MV_om8=iooR7O?odQ7WolgU]onEY
FooIF4[oa3lbog`G5onl_;cohN7Qonc/k003onk^kP0Conc/k?oQhN7o_;blojE75ooVUc;omJ``oofl
@OombE?ooM1Poo_CIOomdV3oo/eDoofm@_oj[c;ojI/bojE65onl_;coh>3Ponc/k003onk^kP0Conc/
k?oQhN7o_;bloaMI5omOZ3;oM[dgohK=AonFeU[oX^1Uoj?PJOnShFOoUmYLohK>Aomg_cOoGj/boaMI
5onl_;cohN7Qonc/k03Jonk^kP0^onc/k?oWinOoNg]koa`L7?oTi>CojNWYonKVi_oQhN7og]kNohf=
SOlD51Coi^KVonCTi?le=CGoNGUion_[jonb/[;o5ADEomoOgooVi^Koi>CTon7QhOoMgMgoNWYjobTY
:OoXj>SoiNGUomgMgOna/K7o9RHVo`/;2onKVi_ojNWYolc<c?l0003oc/k>ol?3`olU9BGoBd];ogal
O?oXj>So<C4aojFUYOoTi>CoGEeMoe5AD@;oinOW00[o9BDUofUYJOoOgmoogmoOogMgMola<C7ojNWY
ol71`Ol0003oYjNW0_oOgml01?nCTi?o5QHFonOWioo/k>a]onk^kP03ong]kOo^k^kok^k^00Gok^k^
00?okNg]onk^k_o^k^h0YOo^k^h00oo]kNgol_;booShn001ooclo0000oomoOd05_olo?cooOgmoogm
oOolo?colo?com7AdOmW1`Oo^3@dolHo<_oBD4?ofV9Eon=^H_oTLFCoi6mRomaTEooCDD?oc44dokTd
=?m[1`Ood];Boo?cloolo?`3oogmo@0Cooclo?oclo?od];Boih[1ooJRSCoji/IooFX:Ooh]3oonKe:
ooRoCOoj_d[onKPoooJZ:_o_WQWofh/doj8]1ooBd];olo?cooclo003oogmo@0Cooclo?oclo?od];B
o`M01om=VSCoGj/Pog2h;omo`d?oR/e@ohg=D_n:cU3oPLM4og6i;omR[R3oCY/do`M21ooBd];olo?c
ooclo03Joogmo@0Soo_knoogmoOoQ8B4oahN7_oclo?onOWiok>c/oo@d=3olo?cofQXJ?m7AdOon_[j
omCDe?l0003ogMgMooclo?okno_o9bLWojRXZ?oinOWoZj^[omGEeOoalO7oE5ADoeiNG_oinOWom?Cd
oiBDU?l51@Go@410om7AdOogmoOon?ShoiNGUol[:b/00_ojn_X06olT92Co1`L7olS8b?okno_oQHF5
of=SHoogmoOoHf=SoeMGEoohn?SonOWiobLW9olE5AGoPh>3omOGeom2@T;oHf=Soo_knoojn_[o=3@d
odU9BOoKfm_oiNGUodm?ColG5aOon_[jooclo03ooogmoAcooOgm00?oo?cloogmoOolo?`00oomoOd0
000joogmoOojn_[olo?conk^k_o`l?3okno_onk^k_oYjNWod];Boe/M7OnR=3Co]2PMol4j;Oo7BCco
ceI:om1GBoo@Ed[obTXnol<k;_nf:1goXS@doe`M7OoCdm?oj^[Zonk^k_o`l?3okno_oo3`koo^k^ko
j^[Zom?Cdon<9Agob74domV47OoTU1GoiidTonjX<oo`ZSCokjXconbP9OoWUaGog8PMolQa=?n<9Ago
dm?Con[Zj_o^k^kol?3`ono_koo`l?3ok^k^on[ZjOoCdm?o7CPMocB2=?m7UAgoFZDKofV]:P;oM;Ph
0>;oMKThof^a:omKYacoB9XMocB2=?lM>1godm?Con[ZjOo^k^kol?3`ono_koo`l?3okno_oo3`l?o_
knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`
l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_
knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`
l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_
knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`
l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_
knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`
l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_
knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`
l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_
knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`
l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_
knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`
l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_
knool?3`0_o_knl0?OoZj^[oOWinoa`L7?oXj>OokNg]ohR8R?l`<33o3`l?oc4a<Ona/K7ok^k^ohF5
Q?m=CDgokno_onk^k_o_knooRXZ:oeUIFOo^k^koN7Qhob/[:ol?3`oo>3Phokno_oo]kNgoi>CTo`h>
3_mYJFWogmoOon?ShooUiNGojn_[of5QHOmgMgOok^k^ono_k_mfMWKo9RHVong]kOo_knooc<c<ob`/
;?oZj^[oKFe/of9RH_o/k>cokNg]oc/k>onCTi?oHV9Ro`h>3_ld=3Coa<C4ono_koo^k^kodM7Aoc`l
??l:2P[o9bLWofa/K?l/;2`00_o^k^h0KOo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`
l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_
koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`
l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_
koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`
koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_
koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`
l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>l00_o_knl0Yoo^k^kol?3`ono_
koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`
l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_
koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`
l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_
koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`
koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_
koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`
l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_
koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`
l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_
koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_00;o
l?3`1_o_knl1oo?cl`7onOWi0Oono_h00003ookno_ogmoOol?3`00CojNWY017oinOWom_KfomSBd_o
PC8bojHe=Onf=2go`Te1ol=DBOo4ED[o`eA9ol9=@Onf=2goYCDeoh4b<_mSBd_of][JonOWi`05onWY
j@0BonOWiooKfm_oRD];ojm;<_o=McGoeX/]on2L;_oPX3;ohJ0don2P<_oOVRkoeX/]olYe=On_Bc;o
RD];om_KfooVi^Koj>SX1?oYjNT04OoWinOofm_Kod];BolbH3;o>XTeoe>K;Om[ZbooL:dhofn^>_m`
[CSoJZX_oe>K;OliR3Go<V0bod];BooKfm_oinOW0=_ojNWY00Koj>SXonKVi_mkNg_o71`LonCTi?oX
j>P2onWYj@03onOWiooYjNWojNWY00_ojNWY00coinOWonWYjOoYjNWoj>SXomSHf?l:2P[o[Zj^omgM
gOoNg]koh>3PonGUiOoXj>P8onWYj@06onSXj?oVi^Kohn?Son?ShooVi^Koj>SX0ooYjNT00ooXj>So
jNWYonWYj@04onWYj@03onOWiooYjNWojNWY0:gojNWY00?oj>SXonWYjOoYjNT0J_oYjNT00ooXj>So
jNWYonWYj@04onWYj@7ol?3`0OogmoL1ooknoP0000Goo_knoo[jn_odm?Cokno_oo7al@02oo3`l00A
onk^k_o[jn_oUIBDodlS8onEE5Co^g=com>EUOoJW9cofYjLomVLW?oDUIGo^g=coiEDE?m?8b?oUIBD
on[Zj_o^k^h01Oo`l?004Oo_knooj^[ZojVDU?n18b?o^VYDomBJLooT_9Goj/NLonW7W?oZaicoiKbE
omBJLonkJUCoPB<SojZDU?oZj^[okno_00Gol?3`017okno_on[Zj_nDU9Co8bXSoeAjE?mcYG?oW/JE
ojc>W?n]cYco[<jLoik6UOmcYG?oE7YDob<Z8onDU9CojNWYono_k`3Koo3`l0;okno_00CoP820oadM
7Oo^k^kokno_4oo`l?02ono_k`07ofATI?lY:BWoPH61of=SHolk>c_ok^k^ono_k`08oo3`l006ono_
koo^k^koLg=cofUYJOo^k^kokno_3?o`l?000oo_knool?3`oo3`l00Aoo3`l003ono_koo`l?3ol?3`
09gol?3`00?okno_oo3`l?o`l?00JOo`l?001?oalO7ol?3`ooCdm?ojn_X1ooknoP0000CokO3boooo
ooooooooo_kn0_ooool2ooknoP3ooogmoOohn?SoKFe]oeXo?onaT93og/W9oo3Ti?oci^Kol>CTomk9
bOnaT93oFSloofe]KOohn?Soo?clooooooono_koooooookno_ooookoo_knooooooolo?con?Shohe]
KOn:?coobI6@onW@bOodjNCom^_VooCYi?oYd<WobI6@ohTo?on=KFgon?Sgooclo?ooooooo_knoooo
ooono_koooooookno_ooookoo?clooShn?m]KFgo?clooi2MT?o9eLWoi>cTonK^i_oTk>CobMG9oi2M
T?lo?cooKFe]ooShn?olo?coooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knoooo
ooono_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookn
o_ooooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knoooo
o_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookn
o_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knoooo
ooono_koooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookn
o_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knoooo
ooono_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookn
o_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knoooo
ooono_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookn
o_ooooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knoooo
o_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookn
o_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knoooo
ooono_koooonookno_ooooooo_kn000hooooooono_koooooookno_ooookoo_knooooooono_kooooo
ookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_kn
ooooooomoOgod=3@ojFUYOono_goo_knooooooono_koooooookno_ooooooo_knooooo_ono_kooooo
ookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_kooooooogmoOo1`L3oLG5a
oh61POn_[jl2ooknoP0<ooooooono_koooonookno_ooooooo_knooooooono_kooooooogmoOo2`/7o
_;bl0_ono_h0ooooooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_oo
ookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooon
o_koooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_oo
ooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooon
o_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_oo
ooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knooooooon
o_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_oo
ooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_on
o_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_oo
ookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooon
o_koooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_oo
ooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooon
o_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_oo
ooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knooooooon
o_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_oo
ooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_ooooooo_knooooo_on
o_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_oo
ookoo_knooooo`00:Oono_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knoooo
ooono_koooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knooooooono_koooooookn
o_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookno_ooooooo_kn00;o
oooo00?oo_knooooooooool00oooool1oo[jn`0000Coa<_Bookno_ojn_[om?Cd0ooalO403oo`l?3o
lO7aono_kooFe]KoJf][od<m?OnKS8coa[ZjomK<c?o7^[[oVhb<od<m?Om[Jf_oe]KFono_k`09oo7a
l@0>ono_kooGe]KoPf][og@m?OneS8coeKZjon7<c?oF^[[o]Xb<og8m?On1Jf_oemKFono_koo`l?08
oo7al@0=ono_kooFe]KoJf][ocdm?On<S8co^[Zjolc=c?nj^[[oS8b<ocdm?Om[Jf_oe]KFono_k`3o
oo7alOoolO7a=?oalO401?o`l?3olO7aoo7alOo`l?04oo7al@03ooCdm?oinOWoo_kn007ol?;c0000
1On7U:7ooOgmooOgmoo`l?3ojn_[00?oj^[Z00gojNWYon[Zj_oYjNWoj>SXoi^KVomIFEWo9RHVo`T9
2OlV9RKoFEUIoi^KVooXj>SojNWY00_oj^[Z00_ojNWYonSXj?nPVi_oJUUIod<V9_l]2@Wo@RHVofUI
FOnPVi_oj>SXonWYj@02on[ZjP03onWYjOoZj^[oj^[Z00Koj^[Z00oojNWYonSXj?nKVi_oFEUIobHV
9_l92@Wo9RHVoeUIFOnKVi_oj>SXonWYjOoZj^[ojNWYon[Zj_oYjNT0oooZj^XHon[ZjP03onWYjOoZ
j^[oj^[Z0?ooj^[Z7OoZj^X01?o[jn_ol?3`ooShn?omoOd1omkQh`0000Co>4UIok[2b_ojn_[om?Cd
2?oalO42oo3`l0?okno_0_o`l?03oo7al@03oo3`l?oalO7olO7a00WolO7a0_o`l?03ono_k`;ol?3`
3ooalO42oo3`l0?okno_0_o`l?3ooo7alOoolO7a>_oalO400oo`l?3olO7aoo7al@02oo7al@03ooCd
m?ojn_[ojng_007oWjBW00000olR=TWoCEiZok[3b@3oooooooooooooO?ooool1onW[k@7oYJZ/0OnK
XJD00006obLnD?lP=TKo=DQDoh:?V?o1alcok>g_ooooooooooooogKooooo00GonOWjon_^kooBe]So
VYnRoijSYP01ok>i_P00\
\>"], "Graphics",
  Evaluatable->False,
  ImageSize->{640, 480},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Create", "Subsection"],

Cell["Some constants for layers are listed.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(layerConstants = \
{\[IndentingNewLine]javax`swing`JLayeredPane`DEFAULTULAYER, \
\[IndentingNewLine]javax`swing`JLayeredPane`PALETTEULAYER, \
\[IndentingNewLine]javax`swing`JLayeredPane`MODALULAYER, \
\[IndentingNewLine]javax`swing`JLayeredPane`POPUPULAYER, \
\[IndentingNewLine]javax`swing`JLayeredPane`DRAGULAYER\[IndentingNewLine]}\)],\
 "Input"],

Cell[BoxData[
    \({0, 100, 200, 300, 400}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(javax`swing`JLayeredPane`FRAMEUCONTENTULAYER\)], "Input"],

Cell[BoxData[
    \(\(-30000\)\)], "Output"]
}, Open  ]],

Cell["We also list names of layers.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(layerNames = {\[IndentingNewLine]"\<Default Layer\>", \
\[IndentingNewLine]"\<Palette Layer\>", \[IndentingNewLine]"\<Modal Layer\>", \
\[IndentingNewLine]"\<Popup Layer\>", \[IndentingNewLine]"\<Drag Layer\>"\
\[IndentingNewLine]}\)], "Input"],

Cell[BoxData[
    \({"Default Layer", "Palette Layer", "Modal Layer", "Popup Layer", 
      "Drag Layer"}\)], "Output"]
}, Open  ]],

Cell["\<\
An ImageIcon which will be shown on a title bar of the internal \
frame is loaded.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(icon = 
      NewImageIcon[
        StringJoin[$JavaSwingMaterial, "\<NB(S).GIF\>"]]\)], "Input"],

Cell[BoxData[
    InterpretationBox[\(\[LeftGuillemet]JavaObject[
          "javax.swing.ImageIcon"] \[RightGuillemet]\),
      JLink`Objects`JavaObject29217873985537]], "Output"]
}, Open  ]],

Cell[TextData[{
  "JInternalFrame objects are added to the ",
  StyleBox["layer",
    FontWeight->"Bold"],
  " which is actually the layered pane of the frame.\nA close box of an \
internal frame is not handled at now."
}], "Text"],

Cell[BoxData[{
    \(\(internalFrames = {};\)\), "\n", 
    \(Do[\[IndentingNewLine]internalFrames = 
        AppendTo[\[IndentingNewLine]internalFrames, 
          NewJInternalFrame[\[IndentingNewLine]layer, 
            layerConstants[\([i]\)], \[IndentingNewLine]layerNames[\([i]\)], \
\[IndentingNewLine]Round[25  i], Round[25 \((i + 1)\)], 200, 
            250, \[IndentingNewLine]True, True, True, 
            True, \[IndentingNewLine]icon\[IndentingNewLine]]\
\[IndentingNewLine]]; \[IndentingNewLine]layer@
        repaint[];, \[IndentingNewLine]{i, 1, 
        5}\[IndentingNewLine]]\), "\n", 
    \(JavaShow[frame]\), "\[IndentingNewLine]", 
    \(frame@repaint[]\), "\[IndentingNewLine]", 
    \(internalFrames[\([1]\)]@setSelected[True]\)}], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dispose", "Subsection"],

Cell[TextData[{
  "JInternalFrame objects which is kept in the ",
  StyleBox["internalFrames",
    FontWeight->"Bold"],
  " are removed."
}], "Text"],

Cell[BoxData[
    \(Do[\[IndentingNewLine]internalFrames[\([i]\)]@
        dispose[]; \[IndentingNewLine]ReleaseObject[
        internalFrames[\([i]\)]];, \[IndentingNewLine]{i, 1, 
        5}\[IndentingNewLine]]\)], "Input"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[">>> javax.swing.JDesktopPane, JInternalFrame <<<",
  FontColor->GrayLevel[0.500008]]], "Section"],

Cell[CellGroupData[{

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:00001h1P00`40o`00
0?l0003oo`000?l00022000000000hS0^4R@R4R@R03oB928odR@R7i8T8P1
000000000hS0^<SPf8S0^03oR<2hohS0^7f8`;P1B9280@00000000>8`;S8
h=R8`;P0ohS0^?n8`;QmR<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVI
c?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<
NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVI
c?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<
NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVI
c?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<
NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVI
c?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<
NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVI
c?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<
NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVI
c?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<
NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;QmVIW<00?<c<aVIVIVIVH0a6IVIP03c<c<VIW<VIW<0?nIVL`bVIW<0XS0
^058T8P10000000018S0^<SPf8S0^8S0^7fIVL`?IVIV[9VIV@eVIVKoVIW<
=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;QmVIW<3VIVIZ`0000>
IVIVoiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hOIVIc<QV
IVKoVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;QmVIW<b6IV
I_nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^7fIVL`5IVIV
_/c<c0EVIVKoVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Qm
VIW<1FIVI[k<c<`5IVIVoiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2hOIVIc0EVIVJnc<c<1FIVI_nIVL`dVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^7fIVL`5IVIV_/c<c0EVIVKoVIW<=9VIc0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;QmVIW<1FIVI[k<c<`5IVIVoiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hOIVIc0EVIVJnc<c<1FIVI_nI
VL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^7fIVL`5IVIV_/c<
c0EVIVKoVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;QmVIW<
1FIVI[k<c<`5IVIVoiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hOIVIc0=VIVH00iVIVFIVI/c<c02mc<c<0fIVIP03VIVIIVIVVIW<0?nI
VL`cVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^7fIVL`2IVIV00<0
002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;QmVIW<0VIVIP030000VIVIIVIV0;k<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2hOIVIc09VIVH00`0009VIVFIVIP2nc<c<0VIVIP030000VIVIIVIV
0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^7fIVL`2IVIV
00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;QmVIW<0VIVIP030000VIVIIVIV0;k<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2hOIVIc09VIVH00`0009VIVFIVIP2nc<c<0VIVIP030000VIVI
IVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^7fIVL`2
IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;QmVIW<0VIVIP030000VIVIIVIV
0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hOIVIc09VIVH00`0009VIVFIVIP2nc<c<0VIVIP030000
VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^7fI
VL`2IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VI
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;QmVIW<0VIVIP030000VIVI
IVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2hI9VIc003c<c<IVIVIVIV01QVIVH00`0009VIVFIV
IP2nc<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^6BIVL`?IVIV2YVIV@9VIVH00`0009VIVFIVIP2nc<c<
0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^6BIVL`>IVIV2`00009VIVH00`0009VIVFIVIP2nc<c<0VIVIP03
0000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^6BIVL`KIVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<
=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;QTVIW<6fIVIP030000
VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hI9VIc0EVIVHDc<c<0VIVIP030000VIVIIVIV
0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hI9VIc0EVIVHDc<c<0VIVIP030000VIVIIVIV0;k<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2hI9VIc0EVIVHDc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
I9VIc0EVIVHDc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI9VIc0EV
IVHDc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVI
c3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI9VIc0EVIVHDc<c<
0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI9VIc0EVIVHDc<c<0VIVIP03
0000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2hI9VIc0EVIVHDc<c<0VIVIP030000VIVI
IVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2hI9VIc0=VIVH00iVIVFIVI/c<c00Cc<c<0VIVIP03
0000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2hI9VIc09VIVH00`0009VIVFIVIP0Dc<c<
0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI9VIc09VIVH00`0009VIVFIV
IP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVI
c3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI9VIc09VIVH00`00
09VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI9VIc09V
IVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
I9VIc09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2hI9VIc09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV
0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2hI9VIc09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000
VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hI9VIc09VIVH00`0009VIVFIVIP0Dc<c<0VIV
IP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2hI9VIc09VIVH00`0009VIVFIVIP0D
c<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI9VIc09VIVH00`0009VI
VFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hI9VIc09VIVH0
0`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002I
VIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hBiVI
c003c<c<IVIVIVIV01QVIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVI
IVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2hBiVIc0mVIVH:VIVI0VIVIP030000VIVIIVIV01C<
c<`2IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VI
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;VIW<3VIVIP/00002IVIV
00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP2nc<c<0VIVIP030000
VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^4^I
VL`KIVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP2nc<c<0VIV
IP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^4^IVL`KIVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP2n
c<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0
^<SPf8S0^8S0^4^IVL`5IVIV5<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIV
IP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2hBiVIc0EVIVHDc<c<0VIVIP030000
VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIV
IP3oVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;VIW<1FIV
IQC<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP2nc<c<
0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^4^IVL`5IVIV5<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP03
0000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2hBiVIc0EVIVHDc<c<0VIVIP030000VIVI
IVIV01C<c<`2IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3o
VIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;VIW<1FIVIQC<
c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP2nc<c<0VIV
IP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^4^IVL`5IVIV5<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000
VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hBiVIc0EVIVHDc<c<0VIVIP030000VIVIIVIV
01C<c<`2IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<
=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;VIW<0fIVIP03VIVI
IVIVc<c<01?<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIV
IP2nc<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^4^IVL`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`00
09VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hBiVIc09V
IVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0
002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;Q;VIW<0VIVIP030000VIVIIVIV01C<c<`2
IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP2nc<c<0VIVIP03
0000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^4^IVL`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP0Dc<c<
0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2hBiVIc09VIVH00`0009VIVFIV
IP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH0_/c<
c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;Q;VIW<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUV
IVH05<c<c09VIVH00`0009VIVFIVIP2nc<c<0VIVIP030000VIVIIVIV0?nI
VL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^4^IVL`2IVIV00<0
002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVI
IVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2hBiVIc09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP03
0000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VI
VFIVIP3oVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;Q;VIW<
0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH0
0`0009VIVFIVIP2nc<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^4^IVL`2IVIV00<0002IVIUVIVH05<c<
c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV
00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hBiVIc09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV01C<
c<`2IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VI
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PbVIW<00?<c<aVIVIVIVH0
66IVIP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH0
0`0009VIVFIVIP2nc<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^3:IVL`?IVIV2YVIV@9VIVH00`0009VI
VFIVIP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH0
_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@00000000B8
`;S8h=R8`;R8`;PbVIW<3VIVIP/00002IVIV00<0002IVIUVIVH05<c<c09V
IVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
<YVIc1]VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2
IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;PbVIW<6fIVIP030000VIVIIVIV
01C<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP2nc<c<
0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^3:IVL`5IVIV5<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP03
0000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH0_/c<c09VIVH00`0009VI
VFIVIP3oVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PbVIW<
1FIVIQC<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP0D
c<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h<YVIc0EVIVHDc<c<0VIV
IP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`00
09VIVFIVIP2nc<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^3:IVL`5IVIV5<c<c09VIVH00`0009VIVFIV
IP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH0_/c<
c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;PbVIW<1FIVIQC<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH0
0`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<c<`2IVIV00<0002I
VIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h<YVI
c0EVIVHDc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH0
5<c<c09VIVH00`0009VIVFIVIP2nc<c<0VIVIP030000VIVIIVIV0?nIVL`d
VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^3:IVL`5IVIV5<c<c09V
IVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0
002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;PbVIW<1FIVIQC<c<`2IVIV00<0002IVIUV
IVH05<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV0;k<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h<YVIc0=VIVH00iVIVFIVI/c<c00Cc<c<0VIVIP030000VIVI
IVIV01C<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP2n
c<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0
^<SPf8S0^8S0^3:IVL`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VI
VFIVIP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH0
_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@00000000B8
`;S8h=R8`;R8`;PbVIW<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002I
VIUVIVH05<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV
0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h<YVIc09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000
VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIV
IP2nc<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^3:IVL`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`00
09VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUV
IVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;PbVIW<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0
002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVI
IVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h<YVIc09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP03
0000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VI
VFIVIP2nc<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^3:IVL`2IVIV00<0002IVIUVIVH05<c<c09VIVH0
0`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0002I
VIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;PbVIW<0VIVIP030000VIVIIVIV01C<c<`2IVIV
00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP030000
VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h<YVIc09VIVH00`0009VIVFIVIP0Dc<c<0VIV
IP030000VIVIIVIV01C<c<`2IVIV00<0002IVIUVIVH05<c<c09VIVH00`00
09VIVFIVIP2nc<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^3:IVL`2IVIV00<0002IVIUVIVH05<c<c09V
IVH00`0009VIVFIVIP0Dc<c<0VIVIP030000VIVIIVIV01C<c<`2IVIV00<0
002IVIUVIVH0_/c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;PbVIW<0VIVIP030000VIVIIVIV01C<c<`2
IVIV00<0002IVIUVIVH05<c<c09VIVH00`0009VIVFIVIP0Dc<c<0VIVIP03
0000VIVIIVIV0;k<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc003c<c<IVJIIVJI0<AVIYUPc<c<
0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^1VIVL`?IVJI[9VIc0eVIYUOc<c<0VIVIP030000VIVIIVIV0?nI
VL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`>IVJI[000
00iVIYUOc<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^1VIVLc8IVJIGlc<c09VIVH00`0009VIVFIVIP3o
VIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<b6IVVEo<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc0EVIYVnc<c<1FIVVEo<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc0EVIYVn
c<c<1FIVVEo<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc0EVIYVnc<c<1FIVVEo<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc0EVIYVnc<c<1FIVVEo<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc0EVIYVnc<c<1FIVVEo<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc0EVIYVnc<c<1FIVVEo<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc0EVIYVn
c<c<1FIVVEo<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc0EVIYVnc<c<1FIVVEo<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc0=VIYT00iVIc6IVVLc<c02mc<c<0fIVV@03VIW<IVJIc<c<05k<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT0
0`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002I
VIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVI
c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV
00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<
IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IV
V@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVI
c3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`00
09VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09V
IYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT0
0`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002I
VIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVI
c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV
00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<
IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IV
V@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVI
c3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`00
09VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09V
IYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT0
0`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002I
VIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVI
c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV
00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<
IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IV
V@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVI
c3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`00
09VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09V
IYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT0
0`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002I
VIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVI
c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV
00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<
IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IV
V@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVI
c3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`00
09VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09V
IYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT0
0`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002I
VIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVI
c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV
00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<
IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IV
V@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVI
c3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`00
09VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09V
IYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT0
0`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002I
VIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVI
c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV
00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<
IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IV
V@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVI
c3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`00
09VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09V
IYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0
oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT0
0`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002I
VIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVI
c09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV
00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<
c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<
IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@03
0000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<
0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IV
V@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVI
c3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`00
09VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUV
IVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09V
IYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2IVIV00<0
002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI05o<c<`2
IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI05o<c<`2IVIV00<0002IVIUVIVH0oiVIc3BIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@030000VIW<IVJI065VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8
`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI
0;k<c<`2IVJI00<0002IVLaVIYT0Glc<c09VIVH00`0009VIVFIVIP3oVIW<
=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0Glc<c09VIVH00`0009VIVFIV
IP3oVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0Glc<c09VIVH00`00
09VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PI
VIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0Glc<c09V
IVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
8Lc<c0Ooool;c<c<2_oooa3<c<`>oooo1<c<c09VIVH00`0009VIVFIVIP3o
VIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT08<c<c0030000IVIVIVIV
00AVIVH00oooolc<c<c<c008c<c<00<0001VIVIVIVH01fIVIP03ooooc<c<
c<c<00g<c<`00`0006IVIVIVIP0;IVIV00?oooo<c<c<c<`00/c<c09VIVH0
0`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00@0002IVLaVIYT00002
c<c<0P0000;<c<`400001Lc<c08000001<c<c00000000<c<c0800008c<c<
00<0001VIVIVIVH00`000003IVIVooooc<c<00W<c<`00`0006IVIVIVIP02
IVIV10000003IVIVooooc<c<00k<c<`00`0006IVIVIVIP0:000000=VIVKo
ooo<c<`00lc<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00@0002IVLaVIYT00002c<c<0P000003c<c<0000000000;<c<`200001<c<
c08000001<c<c00000000<c<c0800008c<c<00<0001VIVKoool00/c<c003
0000IVIVoooo00[<c<`01@0006IVIVIVIVIVI_ooo`03c<c<00<0001VIVKo
ool03lc<c0030000IVIVc<c<00O<c<`01Oooolc<c00006IVI_ooo`04c<c<
0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT0100009VIc6IV
V@0000;<c<`2000000?<c<`0000000006<c<c0030000IVIVoooo00;<c<`0
0`0006IVI_ooo`0:c<c<00<0001VIVH000000VIVIP06ooooc<c<c<c<0000
IVIVoooo3lc<c0060000IVIVc<c<c<c<IVIVoooo0lc<c006IVIVoooooooo
0000IVIVoooo1<c<c09VIVH00`0009VIVFIVIP3oVIW<=9VIc0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00@0002IVLaVIYT00002c<c<0P000003c<c<0000000000@0000Dc<c<
00<0001VIVKoool00_ooo`9VIVH00oooolc<c<c<c008c<c<00@0001VIVKo
ool00002IVIV00Goooo<c<`0001VIVKoool03lc<c0040000IVIVc<c<0000
0VIVIP;oool3IVIV00C<c<`0001VIVKoool4c<c<0VIVIP030000VIVIIVIV
0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI
00<0002IVLaVIYT0_/c<c09VIYT0100009VIc6IVV@0000;<c<`2000000?<
c<`0000000000/c<c080000Dc<c<00<0001VIVIVIVH016IVIP_<c<`01@00
06IVI_ooolc<c0000002IVIV00CooomVIVIVIVKoool?c<c<00D0001VIVK<
c<c<c<`000001FIVIP;<c<`00`0006IVI_ooo`04c<c<0VIVIP030000VIVI
IVIV0?nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2
IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@02000000C<c<`0
0000003<c<`200000/c<c080000Dc<c<1`000003c<c<oooooooo00Coool4
c<c<00<0001VIVKoool00/c<c0030000IVIVIVIV009VIVH00oooolc<c<c<
c00=c<c<00<0001VIVK<c<`00/c<c0050000IVIVIVIVIVIVoooo00;<c<`0
0`0006IVI_ooo`04c<c<0VIVIP030000VIVIIVIV0?nIVL`dVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<
c09VIYT00`0009VIc6IVV@02c<c<0P0000?<c<`400007<c<c0030000IVIV
IVIV00=VIVH00oooolc<c<c<c002c<c<00<0001VIVKoool00oooo`050000
IVIVIVIVIVIVoooo00;<c<`2oooo2lc<c0030000IVIVc<c<00;<c<`4IVIV
00Koooo<c<c<c<`0001VIVKoool4c<c<0VIVIP030000IVIVIVIV0?nIVL`d
VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002I
VLaVIYT0_/c<c09VIYT00`0009VIc6IVV@0Wc<c<00@0001VIVIVIVIVIVH2
00001Lc<c0030000IVIVIVIV00MVIVH2oooo0VIVIP03ooooc<c<c<c<00W<
c<`0100006IVI/c<c<c<c0=VIVH0200006IVIVIVI_ooolc<c00006IVI_oo
o`C<c<`5IVIVoiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI02O<c<`0
1@0006IVIVIVIVIVI_ooo`06c<c<2@00009VIVH01?ooofIVIVIVI_ooo`_<
c<`0100006IVI/c<c000009VIVH2c<c<00L0001VIVIVIVK<c<`0001VIVKo
ool01<c<c0EVIVKoVIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT09lc<
c0030000IVIV0000009VIVH00oooolc<c<c<c00<c<c<00<0001VIVIVIVH0
0VIVIP03ooooc<c<c<c<00W<c<`01@0006IVI/c<c<c<c0000004c<c<00H0
003<c<c<c<`0001VIVKoool4c<c<1FIVI_nIVL`dVIW<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT0
0`0009VIc6IVV@0Wc<c<00@0001VIVKoool00002IVIV00?oooo<c<c<c<`0
2lc<c003oooo0000IVIV009VIVH00oooolc<c<c<c009c<c<00<0001VIVK<
c<`02Lc<c09VIVH00oooolc<c<c<c002c<c<1FIVI_nIVL`dVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<
c09VIYT00`0009VIc6IVV@0Wc<c<0P0000;<c<`00`0006IVIVIVIP0<c<c<
00<0001VIVIVIVH00fIVIP03ooooc<c<c<c<00W<c<`00`0006IVIVIVIP0;
IVIV00?oooo<c<c<c<`00/c<c0EVIVKoVIW<=9VIc0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT0;<c<c0030000c<c<c<c<00_<c<`600003<c<c0h00005c<c<
1FIVI_nIVL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2
IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@1Oc<c<1FIVI_nI
VL`dVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0
002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@1Oc<c<1FIVI_nIVL`dVIW<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaV
IYT0_/c<c09VIYT00`0009VIc6IVV@1Nc<c<1VIVI_nIVL`dVIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<
c09VIYT00`0009VIc6IVV@1TIVIVoiVIc3BIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI05NIVIT=IVIVoiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
05H0000>IVIVoiVIc3BIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI06AVIVKo
VIW<=9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0HfIVIP03c<c<VIW<VIW<
0?nIVL`bVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI
00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@16c<c<0VIVIP030000
VIVIIVIV0?nIVLa=VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VI
VL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@16c<c<0VIV
IP030000VIVIIVIV0?nIVLa=VIW<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@08
c<c<1oooo`_<c<`:oooo4<c<c0koool4c<c<0VIVIP030000VIVIIVIV0?nI
VLa=VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0
002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@07c<c<00<0001VIVIVIVH0
16IVIP03ooooc<c<c<c<00S<c<`00`0006IVIVIVIP07IVIV00?oooo<c<c<
c<`03Lc<c0030000IVIVIVIV00]VIVH00oooolc<c<c<c002c<c<0VIVIP03
0000VIVIIVIV0?nIVLa=VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@07c<c<
00<0001VIVIVIVH00`000003IVIVooooc<c<00W<c<`00`0006IVIVIVIP02
IVIV10000003IVIVooooc<c<00k<c<`00`0006IVIVIVIP0:000000=VIVKo
ooo<c<`00lc<c09VIVH00`0009VIVFIVIP3oVIW<CIVIc0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI
00<0002IVLaVIYT01lc<c0030000IVIVoooo00;<c<`00`0006IVI_ooo`0:
c<c<00D0001VIVIVIVIVIVKoool00lc<c0030000IVIVoooo00o<c<`00`00
06IVI/c<c007c<c<00Goooo<c<`0001VIVKoool01<c<c09VIVH00`0009VI
VFIVIP3oVIW<CIVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT01lc<c0030000
IVIVoooo00;<c<`00`0006IVI_ooo`0:c<c<00<0001VIVH000000VIVIP06
ooooc<c<c<c<0000IVIVoooo3lc<c0060000IVIVc<c<c<c<IVIVoooo0lc<
c006IVIVoooooooo0000IVIVoooo1<c<c09VIVH00`0009VIVFIVIP3oVIW<
CIVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000
VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT01lc<c0030000IVIVoooo00;o
ool2IVIV00?oooo<c<c<c<`02<c<c0040000IVIVoooo00000VIVIP05oooo
c<c<0000IVIVoooo00o<c<`0100006IVI/c<c000009VIVH2oooo0fIVIP04
c<c<0000IVIVoooo1<c<c09VIVH00`0009VIVFIVIP3oVIW<CIVIc0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT01lc<c0030000IVIVIVIV00AVIVH;c<c<00D0
001VIVKoooo<c<`000000VIVIP04ooooIVIVIVIVoooo3lc<c0050000IVIV
c<c<c<c<000000EVIVH2c<c<00<0001VIVKoool01<c<c09VIVH00`0009VI
VFIVIP3oVIW<CIVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT01lc<c0L00000
0lc<c?ooooooo`04oooo1<c<c0030000IVIVoooo00;<c<`00`0006IVIVIV
IP02IVIV00?oooo<c<c<c<`03Lc<c0030000IVIVc<c<00;<c<`01@0006IV
IVIVIVIVI_ooo`02c<c<00<0001VIVKoool01<c<c09VIVH00`0009VIVFIV
IP3oVIW<CIVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT03/c<c0030000IVIV
IVIV00=VIVH00oooolc<c<c<c002c<c<00<0001VIVKoool00oooo`050000
IVIVIVIVIVIVoooo00;<c<`2oooo2lc<c0030000IVIVc<c<00;<c<`4IVIV
00Koooo<c<c<c<`0001VIVKoool4c<c<0VIVIP030000IVIVIVIV0?nIVLa=
VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002I
VLaVIYT0_/c<c09VIYT00`0009VIc6IVV@0>c<c<00@0001VIVIVIVIVIVH2
00001Lc<c0030000IVIVIVIV00MVIVH2oooo0VIVIP03ooooc<c<c<c<00W<
c<`0100006IVI/c<c<c<c0=VIVH0200006IVIVIVI_ooolc<c00006IVI_oo
o`C<c<`5IVIVoiVIc4fIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI00k<c<`0
1@0006IVIVIVIVIVI_ooo`06c<c<2@00009VIVH01?ooofIVIVIVI_ooo`_<
c<`0100006IVI/c<c000009VIVH2c<c<00L0001VIVIVIVK<c<`0001VIVKo
ool01<c<c0EVIVKoVIW<CIVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT03/c<
c0030000IVIV0000009VIVH00oooolc<c<c<c00<c<c<00<0001VIVIVIVH0
0VIVIP03ooooc<c<c<c<00W<c<`01@0006IVI/c<c<c<c0000004c<c<00H0
003<c<c<c<`0001VIVKoool4c<c<1FIVI_nIVLa=VIW<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT0
0`0009VIc6IVV@0>c<c<00@0001VIVKoool00002IVIV00?oooo<c<c<c<`0
2lc<c003oooo0000IVIV009VIVH00oooolc<c<c<c009c<c<00<0001VIVK<
c<`02Lc<c09VIVH00oooolc<c<c<c002c<c<1FIVI_nIVLa=VIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<
c09VIYT00`0009VIc6IVV@0>c<c<0P0000;<c<`00`0006IVIVIVIP0<c<c<
00<0001VIVIVIVH00fIVIP03ooooc<c<c<c<00W<c<`00`0006IVIVIVIP0;
IVIV00?oooo<c<c<c<`00/c<c0EVIVKoVIW<CIVIc0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT04lc<c0030000c<c<c<c<00_<c<`600003<c<c0h00005c<c<
1FIVI_nIVLa=VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2
IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@16c<c<1FIVI_nI
VLa=VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0
002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@16c<c<1FIVI_nIVLa=VIW<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaV
IYT0_/c<c09VIYT00`0009VIc6IVV@15c<c<1VIVI_nIVLa=VIW<0XS0^058
T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<
c09VIYT00`0009VIc6IVV@1;IVIVoiVIc4fIVL`2R<2h0DR@R04000000004
R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000
VIW<IVJI03jIVIT=IVIVoiVIc4fIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI
03d0000>IVIVoiVIc4fIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h
6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI04]VIVKo
VIW<CIVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0BVIVIP03c<c<VIW<VIW<
0?nIVLa;VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI
00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@0]c<c<0VIVIP030000
VIVIIVIV0?nIVLaVVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VI
VL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@0]c<c<0VIV
IP030000VIVIIVIV0?nIVLaVVIW<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT0100009VIc6IVVLc<
c0[oool@c<c<3_ooo`C<c<`2IVIV00<0002IVIUVIVH0oiVIc6JIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@040000VIW<IVJI00002FIVIP03ooooc<c<c<c<00g<c<`00`00
06IVIVIVIP0;IVIV00?oooo<c<c<c<`00/c<c09VIVH00`0009VIVFIVIP3o
VIW<IYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00@0002IVLaVIYT00004IVIV10000003IVIV
ooooc<c<00k<c<`00`0006IVIVIVIP0:000000=VIVKoooo<c<`00lc<c09V
IVH00`0009VIVFIVIP3oVIW<IYVIc0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00@0002IVLaVIYT0
0003IVIV00Ooooo<c<c<c<c<c<`0001VIVKoool03lc<c0030000IVIVc<c<
00O<c<`01Oooolc<c00006IVI_ooo`04c<c<0VIVIP030000VIVIIVIV0?nI
VLaVVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0
002IVLaVIYT0_/c<c09VIYT01P0009VIc6IVV@0006IVIP00009VIVH01_oo
olc<c<c<c00006IVI_ooo`o<c<`01P0006IVI/c<c<c<c6IVI_ooo`?<c<`0
1VIVI_ooooooo`0006IVI_ooo`C<c<`2IVIV00<0002IVIUVIVH0oiVIc6JI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@070000VIW<IVJI0000IVIVoooo0000009VIVH01Ooo
olc<c00006IVI_ooo`0?c<c<00@0001VIVK<c<`00002IVIV0_ooo`=VIVH0
1<c<c00006IVI_ooo`C<c<`2IVIV00<0002IVIUVIVH0oiVIc6JIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@080000VIW<IVJI0000IVIVooooc<c<00000VIVIP04ooooIVIV
IVIVoooo3lc<c0050000IVIVc<c<c<c<000000EVIVH2c<c<00<0001VIVKo
ool01<c<c09VIVH00`0009VIVFIVIP3oVIW<IYVIc0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00H0
002IVLaVIYT0001VIVKoool2c<c<00<0001VIVIVIVH00VIVIP03ooooc<c<
c<c<00g<c<`00`0006IVI/c<c002c<c<00D0001VIVIVIVIVIVKoool00/c<
c0030000IVIVoooo00C<c<`2IVIV00<0002IVIUVIVH0oiVIc6JIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2n
c<c<0VIVV@050000VIW<IVJI0000IVIV00Coool01@0006IVIVIVIVIVI_oo
o`02c<c<0_ooo`_<c<`00`0006IVI/c<c002c<c<16IVIP06ooooc<c<c<c<
0000IVIVoooo1<c<c09VIVH00`0006IVIVIVIP3oVIW<IYVIc0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00@0002IVLaVIYT00009IVIV0_ooo`9VIVH00oooolc<c<c<c009c<c<
00@0001VIVK<c<c<c<`3IVIV00P0001VIVIVIVKoooo<c<`0001VIVKoool4
c<c<1FIVI_nIVLaVVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VI
VL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@0900000VIV
IP04ooooIVIVIVIVoooo2lc<c0040000IVIVc<c<00000VIVIP;<c<`01`00
06IVIVIVI/c<c00006IVI_ooo`04c<c<1FIVI_nIVLaVVIW<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09V
IYT00`0009VIc6IVV@09c<c<00<0001VIVIVIVH00VIVIP03ooooc<c<c<c<
00W<c<`01@0006IVI/c<c<c<c0000004c<c<00H0003<c<c<c<`0001VIVKo
ool4c<c<1FIVI_nIVLaVVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@09c<c<
00?oool0001VIVH00VIVIP03ooooc<c<c<c<00W<c<`00`0006IVI/c<c009
c<c<0VIVIP03ooooc<c<c<c<00;<c<`5IVIVoiVIc6JIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<c<0VIV
V@030000VIW<IVJI00S<c<`00`0006IVIVIVIP03IVIV00?oooo<c<c<c<`0
2Lc<c0030000IVIVIVIV00]VIVH00oooolc<c<c<c002c<c<1FIVI_nIVLaV
VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002I
VLaVIYT0_/c<c09VIYT00`0009VIc6IVV@08c<c<1P0000c<c<`>00001Lc<
c0EVIVKoVIW<IYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<
0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0;Lc<c0EVIVKo
VIW<IYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0;Lc<c0EVIVKoVIW<IYVI
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<
IVJI0;k<c<`2IVJI00<0002IVLaVIYT0;<c<c0IVIVKoVIW<IYVIc0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<
c<`2IVJI00<0002IVLaVIYT0<VIVI_nIVLaVVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`00
09VIc6IVV@0UVIVI3FIVI_nIVLaVVIW<0XS0^058T8P10000000018S0^<SP
f8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IV
V@0T00003VIVI_nIVLaVVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@0bIVIV
oiVIc6JIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT0
0`0009VIc6IVV@2nc<c<0VIVV@030000VIW<IVJI035VIVH00lc<c9VIc9VI
c03oVIW<I9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIV
V@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT05<c<c09VIVH00`00
09VIVFIVIP3oVIW<OiVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PI
VIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT05<c<c09V
IVH00`0009VIVFIVIP3oVIW<OiVIc0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT0
0/c<c0koool4c<c<0VIVIP030000VIVIIVIV0?nIVLaoVIW<0XS0^058T8P1
0000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09V
IYT01@0009VIc6IVVLc<c000000=IVIV00?oooo<c<c<c<`00/c<c09VIVH0
0`0009VIVFIVIP3oVIW<OiVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00D0002IVLaVIYW<c<`0
00000VIVIPX000000fIVI_ooolc<c003c<c<0VIVIP030000VIVIIVIV0?nI
VLaoVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0
002IVLaVIYT0_/c<c09VIYT01P0009VIc6IVVLc<c00006IVIPS<c<`01Ooo
olc<c00006IVI_ooo`04c<c<0VIVIP030000VIVIIVIV0?nIVLaoVIW<0XS0
^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0
_/c<c09VIYT01P0009VIc6IVVLc<c00006IVIP;<c<`00fIVI_ooolc<c002
c<c<00IVIVKoooooool0001VIVKoool4c<c<0VIVIP030000VIVIIVIV0?nI
VLaoVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0
002IVLaVIYT0_/c<c09VIYT0200009VIc6IVVLc<c00006IVI/c<c000009V
IVH2oooo0fIVIP04c<c<0000IVIVoooo1<c<c09VIVH00`0009VIVFIVIP3o
VIW<OiVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00H0002IVLaVIYW<c<`0001VIVH2c<c<00<0
001VIVIVIVH00fIVIP;<c<`00`0006IVI_ooo`04c<c<0VIVIP030000VIVI
IVIV0?nIVLaoVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2
IVJI00<0002IVLaVIYT0_/c<c09VIYT01P0009VIc6IVVLc<c00006IVIP?<
c<`01@0006IVIVIVIVIVI_ooo`02c<c<00<0001VIVKoool01<c<c09VIVH0
0`0009VIVFIVIP3oVIW<OiVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00H0002IVLaVIYW<c<`0
001VIVH3c<c<16IVIP06ooooc<c<c<c<0000IVIVoooo1<c<c09VIVH00`00
06IVIVIVIP3oVIW<OiVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PI
VIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00H0002IVLaVIYW<c<`0001V
IVH2c<c<0fIVIP080000IVIVIVIVooooc<c<0000IVIVoooo1<c<c0EVIVKo
VIW<OiVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@03
0000VIW<IVJI0;k<c<`2IVJI00P0002IVLaVIYW<c<`0001VIVK<c<`00002
IVIV0/c<c0070000IVIVIVIVc<c<0000IVIVoooo00C<c<`5IVIVoiVIc7nI
VL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VI
c6IVV@2nc<c<0VIVV@060000VIW<IVJIc<c<0000IVIV0/c<c0030000c<c<
c<c<00;<c<`01P000<c<c<c<c00006IVI_ooo`C<c<`5IVIVoiVIc7nIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IV
V@2nc<c<0VIVV@060000VIW<IVJIc<c<0000IVIV2/c<c09VIVH00oooolc<
c<c<c002c<c<1FIVI_nIVLaoVIW<0XS0^058T8P10000000018S0^<SPf8S0
^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<c09VIYT01@0009VIc6IVVLc<
c000000=IVIV00?oooo<c<c<c<`00/c<c0EVIVKoVIW<OiVIc0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00@0002IVLaVIYW<c<`>00001Lc<c0EVIVKoVIW<OiVIc0:8`;P1B928
0@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2
IVJI00<0002IVLaVIYT05<c<c0EVIVKoVIW<OiVIc0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0
002IVLaVIYT05<c<c0EVIVKoVIW<OiVIc0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaV
IYT04lc<c0IVIVKoVIW<OiVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PIVIW<0VIVV@030000VIW<IVJI0;k<c<`2IVJI00<0002IVLaVIYT06FIV
I_nIVLaoVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI
00<0002IVLaVIYT0_/c<c09VIYT00`0009VIc6IVV@0<VIVI3FIVI_nIVLao
VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002I
VLaVIYT0`6IVV@030000VIW<IVJI00/0000>IVIVoiVIc7nIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@2nc<co
0VIVV@030000VIW<IVJI01UVIVKoVIW<OiVIc0:8`;P1B9280@00000000B8
`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI0;k<c?l2IVJI00<0002I
VLaVIYT066IVIP03c<c<VIW<VIW<0?nIVLamVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^1VIVL`2IVJI00<0002IVLaVIYT0_/c<o`9VIYT00`00
09VIc6IVV@3oVIW<V9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PI
VIW<0VIVV@030000VIW<IVJI00G<c?l00oooohR8R4A4A006A4A400<c<c=4
A4A4A4@00dA4A003VIVIc<coc<co0:O<c?l2IVJI00<0002IVLaVIYT0oiVI
c9RIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`00
09VIc6IVV@05c<co00?ooom4A4AVIVH00gMgM`03IVIVMgMgMgMg00EgMgL0
0c<c<lc<c<c<o`1Zc<co1oooo`_<c?l:oooo4<c<o`koool4c<co0VIVV@03
0000VIW<IVJI0?nIVLbHVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^1VIVL`2IVJI00<0002IVLaVIYT01Lc<o`0<oooo<c<ck^k^k^k^^k^kMgMg
ZZZZooook^k^gMgMMgMggMgM0^k^kP03MgMgc<c<c<co06W<c?l00`0006IV
VFIVV@04IVJI00?oooo<c?o<c?l02<c<o`030000IVJIIVJI00MVIYT00ooo
olc<olc<o`0=c<co00<0001VIYUVIYT02fIVV@03ooooc<coc<co00;<c?l2
IVJI00<0002IVLaVIYT0oiVIc9RIVL`2R<2h0DR@R04000000004R<2hb>3H
R<2hR<2h6IVIc09VIYT00`0009VIc6IVV@05c<co00Kooolc<c?oooo^k^ig
MgL0<l`2<c<000Q4A4@c03<0029V06IgMgOooomgMgNk^k/5c<co0P000003
c<co0000000000;<c?l200000/c<o`800002c<co100000;<c?l200000lc<
o`800002c<co0P0000;<c?l5000000?<c?l0000000001<c<o`800004c<co
0P0000C<c?l5000000?<c?l0000000000/c<o`800002c<co0P0000;<c?l4
00001Lc<o`8000001<c<o`0000000<c<o`800008c<co00<0001VIYUVIYT0
0`000003IVJIooooc<co00W<c?l00`0006IVVFIVV@02IVJI10000003IVJI
ooooc<co00k<c?l00`0006IVVFIVV@0:000000=VIYWoooo<c?l00lc<o`9V
IYT00`0009VIc6IVV@3oVIW<V9VIc0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;PIVIW<0VIVV@030000VIW<IVJI00G<c?l04?ooogMgMnk^k^k^kVIV
IP1Vo`1Vc4A4A3<0<c<c<gMgMc<0<hR8R>k^kVIVI/c<c0G<c?l2000000?<
c?l0000000000/c<o`8000000lc<o`0000000002c<co0P0000;<c?l20000
00?<c?l0000000000lc<o`800002c<co0P000003c<co0000000000;<c?l2
000000?<c?l0000000001<c<o`800004c<co0P0000?<c?l200000/c<o`80
00000lc<o`0000000002c<co0P0000;<c?l2000000?<c?l0000000000/c<
o`800004c<co0P000004c<co00000000c<co0P0000S<c?l00`0006IVVOoo
o`02c<co00<0001VIYWoool02/c<o`050000IVJIIVJIIVJIoooo00?<c?l0
0`0006IVVOooo`0?c<co00<0001VIYW<c?l01lc<o`05ooooc<co0000IVJI
oooo00C<c?l2IVJI00<0002IVLaVIYT0oiVIc9RIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@05c<co00Gooolc
<c?^k^kMgMdA4A400P1Vo`09<fK<8R8RR8R8VIVI8R8RgMgMk^k^MgMgc<c<
00G<c?l2000000?<c?l0000000000/c<o`8000000lc<o`0000000002c<co
0P0000G<c?l200000lc<o`800002c<co0P000003c<co0000000000;<c?l2
000000?<c?l0000000001<c<o`800004c<co0P0000?<c?l200000/c<o`80
00000lc<o`0000000002c<co0P0000;<c?l2000000?<c?l0000000006<c<
o`030000IVJIoooo00;<c?l00`0006IVVOooo`0:c<co00<0001VIYT00000
0VIVV@06ooooc<coc<co0000IVJIoooo3lc<o`060000IVJIc<coc<coIVJI
oooo0lc<o`06IVJIoooooooo0000IVJIoooo1<c<o`9VIYT00`0009VIc6IV
V@3oVIW<V9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIV
V@030000VIW<IVJI00G<c?l01_oooc<c<nk^kS<c<c<0<`004@8R8R80200c
<c<0<a40000003<c<k^k^gMgMk^k^`G<c?l2000000?<c?l0000000000/c<
o`8000000lc<o`0000000002c<co1P000003c<co0000000000?<c?l20000
0/c<o`800002c<co0P000004c<co00000000c<co0P0000C<c?l200001<c<
o`800004c<co0P000004c<co00000000c<co0P0000;<c?l200000/c<o`80
00000lc<o`000000000400005<c<o`030000IVJIoooo00;oool2IVJI00?o
ooo<c?o<c?l02<c<o`040000IVJIoooo00000VIVV@05ooooc<co0000IVJI
oooo00o<c?l0100006IVVLc<o`00009VIYT2oooo0fIVV@04c<co0000IVJI
oooo1<c<o`9VIYT00`0009VIc6IVV@3oVIW<V9VIc0:8`;P1B9280@000000
00B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000VIW<IVJI00G<c?l04?ooogMg
MfHcIVHcIWMgMhR8R6IVIS<c000cc01Vc3<0IP0006HcIS<c<gMgMlc<c0G<
c?l2000000?<c?l0000000000/c<o`8000000lc<o`0000000002c<co0P00
00;<c?l2000000?<c?l0000000000lc<o`800002c<co0P0000?<c?l40000
00?<c?l0000000001<c<o`D000000lc<o`0000000005c<co10000003c<co
0000000000;<c?l200000/c<o`8000000lc<o`0000000002c<co0P0001C<
c?l00`0006IVVFIVV@04IVJI2lc<o`050000IVJIooooc<co0000009VIYT0
1?ooofIVVFIVVOooo`o<c?l01@0006IVVLc<olc<o`000005IVJI0/c<o`03
0000IVJIoooo00C<c?l2IVJI00<0002IVLaVIYT0oiVIc9RIVL`2R<2h0DR@
R04000000004R<2hb>3HR<2hR<2h6IVIc09VIYT00`0009VIc6IVV@05c<co
00Wooom4A4@c03?<0<aV<fIVIVHA002IIP3<V@000P1Vc0:I09T00k^k^gMg
Mlc<c005c<co0P000005c<co000000000000c<co008000000lc<o`000000
0002c<co0P0000;<c?l2000000?<c?l0000000000lc<o`<000001Lc<o`00
00000<c<o`000003c<co0P000003c<co0000000000C<c?l200001<c<o`80
0003c<co00@0003<c?o<c?o<c?l2000000G<c?l000000000003<c?l00`00
0004c<co00000000c<co0P0000;<c?l200005<c<o`L000000lc<oooooooo
o`04oooo1<c<o`030000IVJIoooo00;<c?l00`0006IVVFIVV@02IVJI00?o
ooo<c?o<c?l03Lc<o`030000IVJIc<co00;<c?l01@0006IVVFIVVFIVVOoo
o`02c<co00<0001VIYWoool01<c<o`9VIYT00`0009VIc6IVV@3oVIW<V9VI
c0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<0VIVV@030000IVJI
IVJI00G<c?l01?oooc<c<lc<c4A4A08000002S<0<fIV0?o<09UV06H0I/`0
ofH0IVHcIWMgMk^k^`G<c?l2000000C<c?l00000003<c?l2000000?<c?l0
000000000P0000;<c?l400000/c<o`@000001<c<o`0000000<c<o`800003
c<co100000;<c?l200001<c<o`800004c<co100000;<c?l400000/c<o`80
00000lc<o`0000000002c<co0P0000?<c?l400007<c<o`030000IVJIIVJI
00=VIYT00oooolc<olc<o`02c<co00<0001VIYWoool00oooo`050000IVJI
IVJIIVJIoooo00;<c?l2oooo2lc<o`030000IVJIc<co00;<c?l4IVJI00Ko
ooo<c?o<c?l0001VIYWoool4c<co0VIVV@030000IVJIIVJI0?nIVLbHVIW<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`5IVJI1Lc<o`07oooo
MgMgk^k^k^k^8R8RV@2IIS=V009V06H01c<0<iUV014A4Lc<c>k^kWMgMlc<
c005c<co0P0000S<c?l200007<c<o`800004c<co0P0003c<c?l0100006IV
VFIVVFIVV@800005c<co00<0001VIYUVIYT01fIVV@;oool2IVJI00?oooo<
c?o<c?l02Lc<o`040000IVJIc<coc<co0fIVV@080000IVJIIVJIooooc<co
0000IVJIoooo1<c<o`EVIYWoVIW<V9VIc0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;PIVIW<1FIVV@G<c?l01_ooodA4A>k^kYVIVA4A4DA4A0;<0<`0
19T0V@0cI/bI07MgM`;^k^h00gMgMlc<c<c<o`04c<co0P0000W<c?l00`00
0<c<olc<o`0Jc<co0P0000C<c?l50000>Lc<o`050000IVJIIVJIIVJIoooo
00K<c?l900000VIVV@04ooooIVJIIVJIoooo2lc<o`040000IVJIc<co0000
0VIVV@;<c?l01`0006IVVFIVVLc<o`0006IVVOooo`04c<co1FIVVOnIVLbH
VIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`5IVJI1Lc<o`09
oooo<c<ck^k^MgMg<c<cIVIV<c<cc03<A4A40080<fH01GMgMnk^k^k^kWMg
Mk^k^`1ac<co00<0001VIYT000000VIVV@03ooooc<coc<co00c<c?l00`00
06IVVFIVV@02IVJI00?oooo<c?o<c?l02Lc<o`050000IVJIc<coc<co0000
00C<c?l01P000<c<olc<o`0006IVVOooo`C<c?l5IVJIoiVIc9RIVL`2R<2h
0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc0EVIYT5c<co00?ooomgMgO^
k^h00nk^kP06^k^kIS=Vooook^k^VIVIR8R80^k^kP03MgMgc<c<c<co073<
c?l0100006IVVOooo`00009VIYT00oooolc<olc<o`0;c<co00?oool0001V
IYT00VIVV@03ooooc<coc<co00W<c?l00`0006IVVLc<o`09c<co0VIVV@03
ooooc<coc<co00;<c?l5IVJIoiVIc9RIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc0EVIYT5c<co00?ooolc<c?oool02nk^kP03MgMgc<c<
c<co073<c?l200000/c<o`030000IVJIIVJI00c<c?l00`0006IVVFIVV@03
IVJI00?oooo<c?o<c?l02Lc<o`030000IVJIIVJI00]VIYT00oooolc<olc<
o`02c<co1FIVVOnIVLbHVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0
^1VIVL`5IVJI1Lc<o`03oooo<c<cMgMg00agMgL00oooolc<olc<o`1dc<co
00<0003<c?o<c?l02lc<o`H0000<c<co3P0000G<c?l5IVJIoiVIc9RIVL`2
R<2h0DR@R04000000004R<2hb>3HR<2hR<2h6IVIc0EVIYVnc<co1FIVVOnI
VLbHVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^1VIVL`5IVJI_/c<
o`EVIYWoVIW<V9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;PIVIW<
1VIVVKc<c?l6IVJIoiVIc9RIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2h6IVIc<QVIYWoVIW<V9VIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PIVIW<3fIVVJbIVL`=IVJIoiVIc9RIVL`2R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h6IVIc0iVIYV/00003VIVVOnIVLbHVIW<0XS0^058T8P10000
000018S0^<SPf8S0^8S0^1VIVLc8IVJIoiVIc9RIVL`2R<2h0DR@R0400000
0004R<2hb>3HR<2hR<2h6IVIc003c<c<IVJIIVJI0<AVIYT00lc<c9VIc9VI
c03oVIW<UYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVI
c7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nI
VLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVI
c7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nI
VLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVI
c7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nI
VLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVI
c7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nI
VLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVI
c7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P100000000
18S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2h
R<2hoiVIc?nIVLajVIW<0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nI
VLcoVIW<NYVIc0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVI
c7ZIVL`2R<2h0DR@R04000000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<
0XS0^058T8P10000000018S0^<SPf8S0^8S0^?nIVLcoVIW<NYVIc0:8`;P1
B9280@00000000B8`;S8h=R8`;R8`;SoVIW<oiVIc7ZIVL`2R<2h0DR@R040
00000004R<2hb>3HR<2hR<2hoiVIc?nIVLajVIW<0XS0^058T8P100000000
0hS0^<SPf8S0^03oR<2hohS0^7f8`;P1B9280@00000000B8`;S8h=R8`;R8
`;PF00200`01P0800X001002P@03P@03P@03P@<0184200F100@01H801X80
1X801X8200N200<11h81288128800P48P`<12H<30@Z300<12h<12h@12h@0
0`4<Q0<13H@30@j50`8?Q@<248D40Q660`8BQP824hH0108CQ`8DQ`8DQ`8D
Q`<25HL20QJ700@35XP35hP35hP35hP30aR800<36HP36HT36HT010<JR@<3
6hT30ab:0`<MRP<47XX311n;0`@PR`<48H/312:<10@SS00412B<12B=12B=
12F=0PDUS@<59Xd00`DWS@DWSPDWSP031BR>0`DYSP031BZ>1BZ?1BZ?00<5
:hl41Bb?0`H]T0<6;Y021Rn@00@6;i46<946<946<9431S6A0PHbT@041S:B
1S>B1S>B1S>B0PHdTP031cBB1cFB1cFB0087=I<31cJC0`LgT`031cRC1cRD
1cRD00<7>I@31cZD0`LkU@<8?9D323fE10PnUP<8?iH2242F00@8@9L8@IL8
@IL8@IL324:G0PQ3U`042D>H2DBH2DBH2DBH0`U5V0032DJH2DJI2DJI00@9
AiT32DRI0`U9VP<9BYX32T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`010YAW0YA
W@YAW@YBW@8;DYd32e>M00<;E9d;E9h;E9h00`]EWP<;EYh00`]GWP]GW`]G
W`032eRO10]IW`<<FZ0335^P0PaLX00435bQ35fQ35fQ35fQ0`aNX@8<Gj40
10aOXPaPXPaPXPaPXP8<HJ800`eQXPeRXPeRXP023F:S0`eSX`<=I:<00`eU
X`eUY0eUY0033FJT0`eWY0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]YP043VfW
3VjW3VjW3VjW0`i_Y`8>L:L010m`Z0maZ0maZ0maZ0<?LZP00`mcZ0mcZ@mc
Z@043gBY0`meZ@<?MZX33gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`447f/00@@
OZ`@OZd@OZd@Ojd24Gn]0a60[@034H6]4H6^4H6^00<APZh34H>^00<AQ:hA
Q:lAQ:l00a65[`@AQZl34XN`0a:8/08BRK0011:9/A::/A::/A::/@<BRk42
4Xba00@BS;8BSK8BSK8BSK824Xjb00<CS[8CSk8CSk800Q>?/`<CT;<34i6c
00<CT[<CT[@CT[@00a>C]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI]P8DV[H0
11BJ]aBK]aBK]aBK]`<DW;L259fg00@EWKPEW[PEW[PEW[P35Inh00<EX;PE
X;TEX;T011FQ^@<EX[T35J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/35ZVl11JZ
_0045Z^l5Z^m5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn0aN`_P03
5k6n5k6o5k6o00<G/[l35k>o=QRd`0:8`;P1B9280@00000000B8`;S8h=R8
`;R8`;P4002000>KYo4c@jDc@jD02C=3Y@H0080300600P02P00400:100>1
00>100>10`04P@801H401005PP06PP06PP06PP801h800`47PP48PP48PP02
0@R30`49P`<12X<00`4;P`4;Q04;Q0030@b40`4=Q0<13XD30Pn50`8@Q@@2
4HH30Q:60P8CQP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<GR0<GR0<G
R0<368P00`<IR0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<47h/3122;
0`@QR`<48X`412><00@498`498d498d49Hd21BF=0`DVS@031BN=1BN>1BN>
00<5:8h31BV>00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_
T@H`T@H`T@H`T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7=987=I87
=I800PLeT`<7=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8
?ID423jF0`PoUP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9
A9P9A9P32DFH00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK
0`Y=V`<:CY/32TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]D
WP]DWP032eFN0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP
00@<G:4<GJ4<GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQXP033F6R
3F:R3F:R008=HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>
JJD33VZU10i[YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X
3g6X3g6X3g6X0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ
0a1iZ`<@NZ/347^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<A
PJdAPJhAPJh00a62[P<APjh00a64[Q64[a64[`034HF_1166[`<BQk034XR`
0Q:9/0044XVa4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[80
0a>>/Q>?/Q>?/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<C
UKD359Je0aBG]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL0
11FM^1FN^1FN^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj
0aJU^P<FY[/35ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]
_@035jjm5jjn5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/klf6;C0
0XS0^058T8P10000000018S0^<SPf8S0^8S0^0<008001i^WlOooohij]ZJK
a;>YdZRMb;>YdP02YY_400Fl^=g^k_CZjO7ooolc@jD01@00P0<00H0200:0
00@00X400h400h400h4300B10P05P@0400F200J200J200J20P07PP030@N2
0@R20@R2008128<30@V30`4:P`030@^30@^40@^400<138@30@f40`4>Q@<2
3hD30Q25108AQP<24XH20Q>600@24hL258L258L258L30QF70P8FQ`040aJ8
0aN80aN80aN80`<HR0030aV80aV90aV900@36XT30a^90`<LRP<37HX311j:
0`@OR`<488/3126;0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=00<5
9hd59hh59hh00`DXSP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@
0PH_T0041RnA1S2A1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=980
0`LdTPLeTPLeTP021cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7
>iD323bE0`PmU@@8?YH323nF0PQ0UP04242G246G246G246G0`Q2U`88@iL0
10U3V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ
0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]C
W@032eBM2eBN2eBN00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP
0`aKX08<G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82
366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=
Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL2
3W2W00@?L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ
0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/111m[00447j/47j]47j]47n]0Q5o
[@<AP:d00a61[A61[Q61[P034H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_
0a:7/0<BR;024XV`00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb
4Xfb0Q:>/P034hjb4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d00<C
Tk@34iBd0a>E]@<DU[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL3
59bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i
0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/
_@8G[;d35jfm00<G[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o
0aNc_`8H]<0P00000QRd`10000026;C00XS0^058T8P10000000018S0^<SP
f8S0^8S0^080080019^WlOooofaJYJnUbP:l^=d02_omok>Yd_oooooookbh
gIN:_:RMb>KVk?oooc=3Y@@0080300600P02P00400:100>100>100>10`04
P@801H401005PP06PP06PP06PP801h800`47PP48PP48PP020@R30`49P`<1
2X<00`4;P`4;Q04;Q0030@b40`4=Q0<13XD30Pn50`8@Q@@24HH30Q:60P8C
QP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<I
R0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`4
12><00@498`498d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>
00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`
T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7
=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`Po
UP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH
00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/3
2TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN
0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<
GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R3F:R008=
HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[
YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X
0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/3
47^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh0
0a62[P<APjh00a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa
4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?
/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG
]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN
^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/3
5ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn
5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/kl26;C000?8h=Q8T8Q8
T8P034R@R0030000b>3HB92800e8T8P0100001Rd`1Rd`<SPf0i8T8P00`00
01Rd`1Rd`002R<2h0DR@R04000000004R<2hb>3HR<2hR<2h0P00P00;VjOa
ooooZ9g8oooo/jWBH4bJSWZfN6F^Z9g8oooooogo00?oool00c=3Y@00P000
P00300200`01P0800X001002P@03P@03P@03P@<0184200F100@01H801X80
1X801X8200N200<11h81288128800P48P`<12H<30@Z300<12h<12h@12h@0
0`4<Q0<13H@30@j50`8?Q@8248D3oooo0P8AQP<24XH20Q>600@24hL258L2
58L258L30QF70P8FQ`040aJ80aN80aN80aN80`<HR0030aV80aV90aV900@3
6XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;0`@RS0@48h`010@TS0@T
S@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DXSP<5:Hh00`DZSPDZS`DZ
S`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A1S2A0`HaT@86<Y40
10HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC0`LfT`<7=i<00`Lh
T`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH323nF0PQ0UP04242G
246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6
V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:
DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;EIh32eJN00<;Eih;
Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aMX@aMX@aMX@<<GZ42
35nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS
00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>KJH0
10i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP33g:X00<?LjP?
LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/111m
[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61[P034H:^0a63[P03
4HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@BRK4BR[4BR[4BR[43
4X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008CSk<34i2c
0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D359Ne11BH]P<DVKH2
59Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^003
5J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY
_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h00aN__P<G
/;h00aNa_QNa_aNa_`035k:o0aNc_`8H]<000lSPf8S0^8S0^00;R<2h00=8
T8P00038h=P03HS0^005B92800006;C06;C0b>3H00f8`;P014R@R00001Rd
`1Rd`0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;P2002000jKYo7ooooo
oooKg>aPC9ZCQKZcZM:l^=ePC9ZISkjVVlC8`moooolc@jD600200oooo`80
0X000`02POooooooo`02oooo0P04P@0300F1oooo00F200<01X84oooo00<1
288128?oool00oooo`<12X<01_ooo`4;Q04;Q04<Q?ooo`4<Q0813H@01?oo
o`4>QOooo`4>Q@823hD01?ooo`8@QOooo`8@Q@824HH00oooo`8AQP8BQP02
0Q:60P8CQP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<3
68P00`<IR0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@Q
R`<48X`412><00@498`498d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5
:8h31BV>00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`
T@H`T@H`T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7=987=I87=I80
0PLeT`<7=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID4
23jF0`PoUP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9
A9P32DFH00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=
V`<:CY/32TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]D
WP032eFN0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<
G:4<GJ4<GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R
3F:R008=HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD3
3VZU10i[YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X
3g6X3g6X0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1i
Z`<@NZ/347^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdA
PJhAPJh00a62[P<APjh00a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9
/0044XVa4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>
/Q>?/Q>?/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD3
59Je0aBG]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM
^1FN^1FN^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU
^P<FY[/35ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@03
5jjm5jjn5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/kl26;C000C8
h=R8`;R8`;R8`;P6000018S0^003B9280000b>3H00:8`;P900000XS0^005
B92800006;C06;C0b>3H00f8`;P014R@R00001Rd`1Rd`0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;P3002000jKYo7ooonl^=fISkkooooFdMgKg>cc
o_nVVlC^k_B5M[2CQK[ooolc@jD4002000Ooool00H000H000H3oool00X3o
ool00`03P@06oooo00B100B100F1oooo00F20P06PP08oooo00N200N20@N2
oooo0@R2oooo0@R30`49P`04oooo0@Z30@Z3oooo0P4;Q0030@b4oooo0@b4
00813H@01?ooo`4>QOooo`4>Q@823hD00oooo`8@QOooo`03oooo0P8AQP<2
4XH20Q>600@24hL258L258L258L30QF70P8FQ`040aJ80aN80aN80aN80`<H
R0030aV80aV90aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;
0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DX
SP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A
1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP02
1cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8
?YH323nF0PQ0UP04242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4
V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK
0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN
00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aL
X@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=
HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>
JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?
LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[
0a1jZ`<@Nj/347b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61
[Q61[P034H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`
00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb
4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<D
U[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh
5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj
0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G
[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_`8H]<001<SP
f8S0^8S0^8S0^0H00004R<2h00=8T8P00038h=P00XS0^0030000R<2hR<2h
00F8`;P01@0008S0^8S0^4R@R00000026;C000C8h=R8`;R8`;R8`;P20000
18S0^0800002R<2h00A8T8P0000H]<0H]<02R<2h0DR@R04000000004R<2h
b>3HR<2hR<2h0`00P00?VjOaooooVHnnUhZle=?XkjbcogIkkYn[FeRUYY_4
UYoBH4bJ_;SMoooo<d>U00<008001oooo`01P001P001P?ooo`02P?ooo`03
00>100Koool01840187oool01H7oool200J200Soool01h801h811h;oool1
28;oool128<30@V300Woool12X?oool12h?oool12hCoool138Coool00P4=
Q004oooo0@j5oooo0@j50P8?Q@04oooo0Q25oooo0Q25108AQP<24XH20Q>6
00@24hL258L258L258L30QF70P8FQ`040aJ80aN80aN80aN80`<HR0030aV8
0aV90aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;0`@RS0@4
8h`010@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DXSP<5:Hh0
0`DZSPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A1S2A
0`HaT@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC0`Lf
T`<7=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH323nF
0PQ0UP04242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9AIP0
0`U6V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:
Ci`42U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;EIh3
2eJN00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aMX@aM
X@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ800PeR
X`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V
0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP3
3g:X00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@
Nj/347b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61[P03
4H:^0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@BRK4B
R[4BR[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb
008CSk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D359Ne
11BH]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh
5Ijh0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV^`<F
Yk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG
[[h00aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_`8H]<000lSPf8S0^8S0
^00;R<2h00=8T8P00038h=P00XS0^0030000R<2hR<2h00F8`;P01@0008S0
^8S0^4R@R00000026;C000?8h=R8`;R8`;P00XS0^0800002R<2h0P0000>8
`;P014R@R00001Rd`1Rd`0:8`;P1B9280@00000000B8`;S8h=R8`;R8`;P2
002000ZKYo7ooonGR[ajK:ZcanRYKZ38`mnCQKYKAY>ISkh2N6F^00A29hF_
YL[ooolc@jD400200`01P003oooo00:000:100Coool200B100?oool01H7o
ool00`06PPCoool00`48PP48P`48P`030@V300Woool12X?oool12h?oool1
2hCoool138Coool00P4=Q004oooo0@j5oooo0@j50P8?Q@03oooo0Q25oooo
00?oool20Q660`8BQP824hH0108CQ`8DQ`8DQ`8DQ`<25HL20QJ700@35XP3
5hP35hP35hP30aR800<36HP36HT36HT010<JR@<36hT30ab:0`<MRP<47XX3
11n;0`@PR`<48H/312:<10@SS00412B<12B=12B=12F=0PDUS@<59Xd00`DW
S@DWSPDWSP031BR>0`DYSP031BZ>1BZ?1BZ?00<5:hl41Bb?0`H]T0<6;Y02
1Rn@00@6;i46<946<946<9431S6A0PHbT@041S:B1S>B1S>B1S>B0PHdTP03
1cBB1cFB1cFB0087=I<31cJC0`LgT`031cRC1cRD1cRD00<7>I@31cZD0`Lk
U@<8?9D323fE10PnUP<8?iH2242F00@8@9L8@IL8@IL8@IL324:G0PQ3U`04
2D>H2DBH2DBH2DBH0`U5V0032DJH2DJI2DJI00@9AiT32DRI0`U9VP<9BYX3
2T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`010YAW0YAW@YAW@YBW@8;DYd32e>M
00<;E9d;E9h;E9h00`]EWP<;EYh00`]GWP]GW`]GW`032eRO10]IW`<<FZ03
35^P0PaLX00435bQ35fQ35fQ35fQ0`aNX@8<Gj4010aOXPaPXPaPXPaPXP8<
HJ800`eQXPeRXPeRXP023F:S0`eSX`<=I:<00`eUX`eUY0eUY0033FJT0`eW
Y0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]YP043VfW3VjW3VjW3VjW0`i_Y`8>
L:L010m`Z0maZ0maZ0maZ0<?LZP00`mcZ0mcZ@mcZ@043gBY0`meZ@<?MZX3
3gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`447f/00@@OZ`@OZd@OZd@Ojd24Gn]
0a60[@034H6]4H6^4H6^00<APZh34H>^00<AQ:hAQ:lAQ:l00a65[`@AQZl3
4XN`0a:8/08BRK0011:9/A::/A::/A::/@<BRk424Xba00@BS;8BSK8BSK8B
SK824Xjb00<CS[8CSk8CSk800Q>?/`<CT;<34i6c00<CT[<CT[@CT[@00a>C
]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI]P8DV[H011BJ]aBK]aBK]aBK]`<D
W;L259fg00@EWKPEW[PEW[PEW[P35Inh00<EX;PEX;TEX;T011FQ^@<EX[T3
5J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/35ZVl11JZ_0045Z^l5Z^m5Z^m5Zbm
0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn0aN`_P035k6n5k6o5k6o00<G/[l3
5k>o0QRd`003b>3HR<2hR<2h00^8`;P00dR@R0000<SPf002R<2h00<00028
`;R8`;P01HS0^0050000R<2hR<2hB9280000008H]<000lSPf8S0^8S0^003
R<2h100000B8`;P014R@R00001Rd`1Rd`0:8`;P1B9280@00000000B8`;S8
h=R8`;R8`;P2002000>KYo7oooooool00_ooo`0:ojf`ogIknLgDoNg^oooo
YY_4QGJ`_;SMoooo<d>U1@00P0<00H000oooo`02P002P@0300>100?oool0
187oool00P05P@0400F2oooo00J200J20P07PP030@N2oooo0@R2008128<3
oooo0P4:P`07oooo0@^3oooo0@^4oooo0@b4oooo00813H@01?ooo`4>QOoo
ooooo`823hD01_ooo`8@QOooo`8@Q@8AQ_ooo`824HH30Q:60P8CQP040Q>7
0QB70QB70QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<IR0<IR@<I
R@040aZ90`<KR@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`412><00@4
98`498d498d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>00<5:Xh5
:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`T@<6<I42
1S:A00@6<Y86<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7=Y<31cNC
00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`PoUP88@9H0
10Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH00<9AYP9
AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/32TnL10Y@
W0042U6L2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN0`]FWP03
2eNN2eNO2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<GJ4<GJ43
35jQ0PaOX@0435nR362R362R362R0PaQXP033F6R3F:R3F:R008=HZ<33F>S
0`eTX`033FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[YP<>K:H2
3VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X0`mbZ003
3g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/347^[0a1l
[0@@OJ`0111n[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh00a62[P<A
Pjh00a64[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa4XZa4XZa
4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?/P024hnc
0a>@/`<CTK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG]@@DV;H3
59Vf0QBJ]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN^1FN^0<E
WkP00aFP^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/35ZNk0aJX
^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn5jjn00<G
[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G/kl26;C000?8h=R8`;R8`;P02hS0
^003B9280000b>3H00:8`;P00`0008S0^8S0^005R<2h00D00028`;R8`;Q8
T8P000000QRd`003b>3HR<2hR<2h00B8`;P200001HS0^004B92800006;C0
6;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^0<008002Z6/l_W=e>8V
??Be_n8V??A]OOcSjOoooog]k_n]/0;oool00c=3Y@00P000P00400200`01
P003oooo00:000:100?oool200B100Goool01H401H401H;oool00P06PP?o
ool20@R200<128?oool12H<00P49P`812X<01?ooo`4;P`4;Q?ooo`8138@0
1oooo`4=Q04=Q?ooo`4>QOooo`4>Q@02oooo00<23hD248D248D01?ooo`04
0Q660Q:60Q:60Q:60P8CQP040Q>70QB70QB70QB70`8EQ`825XL010<FR0<G
R0<GR0<GR0<368P00`<IR0<IR@<IR@040aZ90`<KR@<378X30af:0`@NRP<4
7h/3122;0`@QR`<48X`412><00@498`498d498d49Hd21BF=0`DVS@031BN=
1BN>1BN>00<5:8h31BV>00<5:Xh5:Xl5:Xl00`D[S`@5;8l31Rf@0`H^T086
;i0010H_T@H`T@H`T@H`T@<6<I421S:A00@6<Y86<i86<i86<i821SBB00<7
=987=I87=I800PLeT`<7=Y<31cNC00<7>9<7>9@7>9@00`LiU0<7>Y@31c^E
0`PlU@<8?ID423jF0`PoUP88@9H010Q0U`Q1U`Q1U`Q1U`<8@YL224>G00@9
@iP9A9P9A9P9A9P32DFH00<9AYP9AYT9AYT010U7V@<9B9T32DVJ0`U:VP<:
BiX32TbK0`Y=V`<:CY/32TnL10Y@W0042U6L2U6M2U6M2U:M0P]BW@<;Did0
0`]DW@]DWP]DWP032eFN0`]FWP032eNN2eNO2eNO00<;F9l42eVO0`aJX0<<
Fj0235bP00@<G:4<GJ4<GJ4<GJ4335jQ0PaOX@0435nR362R362R362R0PaQ
XP033F6R3F:R3F:R008=HZ<33F>S0`eTX`033FFS3FFT3FFT00<=IZ@33FNT
0`eXY@<>JJD33VZU10i[YP<>K:H23VfV00@>KJL>KZL>KZL>KZL33VnW0Pi`
Y`043g2X3g6X3g6X3g6X0`mbZ0033g>X3g>Y3g>Y00@?M:T33gFY0`mfZP<?
MjX347RZ0a1iZ`<@NZ/347^[0a1l[0@@OJ`0111n[11n[A1n[A1o[@8AOjd3
4H2]00<APJdAPJhAPJh00a62[P<APjh00a64[Q64[a64[`034HF_1166[`<B
Qk034XR`0Q:9/0044XVa4XZa4XZa4XZa0a:;/@8BS;4011:</Q:=/Q:=/Q:=
/P8BS[800a>>/Q>?/Q>?/P024hnc0a>@/`<CTK<00a>B/a>B]1>B]0034i>d
0a>D]0<CUKD359Je0aBG]@@DV;H359Vf0QBJ]P0459Zg59^g59^g59^g0aBL
]`8DWKL011FM^1FN^1FN^1FN^0<EWkP00aFP^1FP^AFP^@045J6i0aFR^@<E
XkX35JBj0aJU^P<FY[/35ZNk0aJX^`<FZK`45ZZl00@FZk`FZkdFZkdF[;d2
5jbm0aN]_@035jjm5jjn5jjn00<G[kh35k2n00<G/KhG/KlG/Kl00aNb_`<G
/kl26;C000?8h=R8`;R8`;P02hS0^003B9280000b>3H00:8`;P00`0008S0
^8S0^005R<2h00D00028`;R8`;Q8T8P000000QRd`003b>3HR<2hR<2h00>8
`;P4000018S0^004B92800006;C06;C00XS0^058T8P10000000018S0^<SP
f8S0^8S0^08008003I^WlOg]k^8V??ken?N9UoARK_>P[_ARK_omoon]/?cS
jOoooc=3Y@0700200`01P003oooo00:000:100<00h4300B10P05P@0400F2
00J200J200J20P07PP050@N20@R20@R2oooo0@R300<12H<30@Z300<12h<1
2h@12h@00`4<Q0<13H@30@j50`8?Q@<248D40Q660`8BQP824hH0108CQ`8D
Q`8DQ`8DQ`<25HL20QJ700@35XP35hP35hP35hP30aR800<36HP36HT36HT0
10<JR@<36hT30ab:0`<MRP<47XX311n;0`@PR`<48H/312:<10@SS00412B<
12B=12B=12F=0PDUS@<59Xd00`DWS@DWSPDWSP031BR>0`DYSP031BZ>1BZ?
1BZ?00<5:hl41Bb?0`H]T0<6;Y021Rn@00@6;i46<946<946<9431S6A0PHb
T@041S:B1S>B1S>B1S>B0PHdTP031cBB1cFB1cFB0087=I<31cJC0`LgT`03
1cRC1cRD1cRD00<7>I@31cZD0`LkU@<8?9D323fE10PnUP<8?iH2242F00@8
@9L8@IL8@IL8@IL324:G0PQ3U`042D>H2DBH2DBH2DBH0`U5V0032DJH2DJI
2DJI00@9AiT32DRI0`U9VP<9BYX32T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`0
10YAW0YAW@YAW@YBW@8;DYd32e>M00<;E9d;E9h;E9h00`]EWP<;EYh00`]G
WP]GW`]GW`032eRO10]IW`<<FZ0335^P0PaLX00435bQ35fQ35fQ35fQ0`aN
X@8<Gj4010aOXPaPXPaPXPaPXP8<HJ800`eQXPeRXPeRXP023F:S0`eSX`<=
I:<00`eUX`eUY0eUY0033FJT0`eWY0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]
YP043VfW3VjW3VjW3VjW0`i_Y`8>L:L010m`Z0maZ0maZ0maZ0<?LZP00`mc
Z0mcZ@mcZ@043gBY0`meZ@<?MZX33gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`4
47f/00@@OZ`@OZd@OZd@Ojd24Gn]0a60[@034H6]4H6^4H6^00<APZh34H>^
00<AQ:hAQ:lAQ:l00a65[`@AQZl34XN`0a:8/08BRK0011:9/A::/A::/A::
/@<BRk424Xba00@BS;8BSK8BSK8BSK824Xjb00<CS[8CSk8CSk800Q>?/`<C
T;<34i6c00<CT[<CT[@CT[@00a>C]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI
]P8DV[H011BJ]aBK]aBK]aBK]`<DW;L259fg00@EWKPEW[PEW[PEW[P35Inh
00<EX;PEX;TEX;T011FQ^@<EX[T35J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/3
5ZVl11JZ_0045Z^l5Z^m5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn
0aN`_P035k6n5k6o5k6o00<G/[l35k>o0QRd`003b>3HR<2hR<2h00^8`;P0
0dR@R0000<SPf002R<2h00<00028`;R8`;P01HS0^0050000R<2hR<2hB928
0000008H]<000lSPf8S0^8S0^002R<2h0P0000:8`;P200000hS0^004B928
00006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^08008000i^W
lOK8c>8V?002ojf`00OO92koY9kf_<Go[K3^Nhcooolc@jD02000P0<00H00
0oooo`02P002P@0300>10`04P@801H401005PP06PP06PP06PP801h801@47
PP48PP48P_ooo`48P`030@V300Coool12X<12X<12h<20@^40`4<Q0<13H@3
0@j50`8?Q@<248D40Q660`8BQP824hH0108CQ`8DQ`8DQ`8DQ`<25HL20QJ7
00@35XP35hP35hP35hP30aR800<36HP36HT36HT010<JR@<36hT30ab:0`<M
RP<47XX311n;0`@PR`<48H/312:<10@SS00412B<12B=12B=12F=0PDUS@<5
9Xd00`DWS@DWSPDWSP031BR>0`DYSP031BZ>1BZ?1BZ?00<5:hl41Bb?0`H]
T0<6;Y021Rn@00@6;i46<946<946<9431S6A0PHbT@041S:B1S>B1S>B1S>B
0PHdTP031cBB1cFB1cFB0087=I<31cJC0`LgT`031cRC1cRD1cRD00<7>I@3
1cZD0`LkU@<8?9D323fE10PnUP<8?iH2242F00@8@9L8@IL8@IL8@IL324:G
0PQ3U`042D>H2DBH2DBH2DBH0`U5V0032DJH2DJI2DJI00@9AiT32DRI0`U9
VP<9BYX32T^J0`Y<V`<:CI/32TjK0`Y?W0@:D9`010YAW0YAW@YAW@YBW@8;
DYd32e>M00<;E9d;E9h;E9h00`]EWP<;EYh00`]GWP]GW`]GW`032eRO10]I
W`<<FZ0335^P0PaLX00435bQ35fQ35fQ35fQ0`aNX@8<Gj4010aOXPaPXPaP
XPaPXP8<HJ800`eQXPeRXPeRXP023F:S0`eSX`<=I:<00`eUX`eUY0eUY003
3FJT0`eWY0<=J:D33VVU0`iZY@@>JjH33VbV0Pi]YP043VfW3VjW3VjW3VjW
0`i_Y`8>L:L010m`Z0maZ0maZ0maZ0<?LZP00`mcZ0mcZ@mcZ@043gBY0`me
Z@<?MZX33gNZ0a1hZP<@NJ/347Z[0a1kZ`<@O:`447f/00@@OZ`@OZd@OZd@
Ojd24Gn]0a60[@034H6]4H6^4H6^00<APZh34H>^00<AQ:hAQ:lAQ:l00a65
[`@AQZl34XN`0a:8/08BRK0011:9/A::/A::/A::/@<BRk424Xba00@BS;8B
SK8BSK8BSK824Xjb00<CS[8CSk8CSk800Q>?/`<CT;<34i6c00<CT[<CT[@C
T[@00a>C]0<CU;@34iFe0aBF]@<DUkD459Rf0aBI]P8DV[H011BJ]aBK]aBK
]aBK]`<DW;L259fg00@EWKPEW[PEW[PEW[P35Inh00<EX;PEX;TEX;T011FQ
^@<EX[T35J>j0aFT^P<FYKX35ZJk0aJW^`<FZ;/35ZVl11JZ_0045Z^l5Z^m
5Z^m5Zbm0QN/_@<G[Kd00aN^_AN^_QN^_P035jnn0aN`_P035k6n5k6o5k6o
00<G/[l35k>o0QRd`003b>3HR<2hR<2h00^8`;P00dR@R0000<SPf002R<2h
2@0000:8`;P01DR@R00001Rd`1Rd`<SPf003R<2h0P0000B8`;P200000XS0
^004B92800006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^080
08000i^WlOW=e?N9U`02oooo00Oo[K3Q5SCoMW_oY9kR9ScoRGlc@jD02000
P0<00H000oooo`02P002P@0300>10`04P@801H401005PP06PP06PP06PP80
1h801047PP48PP48PP48P`Coool30@Z300<12h<12h@12h@00`4<Q0813H@0
1?ooo`4>Q@4>Q@4>Q@<23hD30Q25108AQP<24XH20Q>600@24hL258L258L2
58L30QF70P8FQ`040aJ80aN80aN80aN80`<HR0030aV80aV90aV900@36XT3
0a^90`<LRP<37HX311j:0`@OR`<488/3126;0`@RS0@48h`010@TS0@TS@@T
S@@US@859Hd31BJ=00<59hd59hh59hh00`DXSP<5:Hh00`DZSPDZS`DZS`03
1B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A1S2A0`HaT@86<Y4010Hb
TPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC0`LfT`<7=i<00`LhT`Lh
U0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH323nF0PQ0UP04242G246G
246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6V@04
2DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:
DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;EIh32eJN00<;Eih;Eil;
Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ
00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=
IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>KJH010i]
Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?
LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/111m[004
47j/47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61[P034H:^0a63[P034HB^
4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@BRK4BR[4BR[4BR[434X^a
0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008CSk<34i2c0a>A
/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D359Ne11BH]P<DVKH259Zf
00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h
5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@F
Z[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h00aN__P<G/;h0
0aNa_QNa_aNa_`035k:o0aNc_`8H]<000lSPf8S0^8S0^00;R<2h00=8T8P0
0038h=P00XS0^0T00002R<2h00E8T8P0000H]<0H]<38h=P03HS0^004B928
00006;C06;C00XS0^058T8P10000000018S0^<SPf8S0^8S0^08008001i^W
lOoooo>P[_ARK_ooooN9UoW=e002oooo00?cX:kooolc@jD02000P0<00H02
00:000@00X400h400h400h4300B10P05P@0400F200J200J200J20P07PP03
0@N20@R20@R2008128<30@V30`4:P`030@^30@^40@^400<138@30@f40`4>
Q@<23hD30Q25108AQP<24XH20Q>600@24hL258L258L258L30QF70P8FQ`04
0aJ80aN80aN80aN80`<HR0030aV80aV90aV900@36XT30a^90`<LRP<37HX3
11j:0`@OR`<488/3126;0`@RS0@48h`010@TS0@TS@@TS@@US@859Hd31BJ=
00<59hd59hh59hh00`DXSP<5:Hh00`DZSPDZS`DZS`031B^?10D/S`<6;I03
1Rj@0PH_T0041RnA1S2A1S2A1S2A0`HaT@86<Y4010HbTPHcTPHcTPHcTP86
=9800`LdTPLeTPLeTP021cFC0`LfT`<7=i<00`LhT`LhU0LhU0031cVD0`Lj
U0<7>iD323bE0`PmU@@8?YH323nF0PQ0UP04242G246G246G246G0`Q2U`88
@iL010U3V0U4V0U4V0U4V0<9AIP00`U6V0U6V@U6V@042DNI0`U8V@<9BIX3
2DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`42U2L00@:DI`:DId:DId:DYd22e:M
0`]CW@032eBM2eBN2eBN00<;EIh32eJN00<;Eih;Eil;Eil00`]HW`@;FIl3
35ZP0`aKX08<G:0010aLX@aMX@aMX@aMX@<<GZ4235nQ00@<Gj8<H:8<H:8<
H:82366R00<=HJ8=HZ8=HZ800PeRX`<=Hj<33FBS00<=IJ<=IJ@=IJ@00`eV
Y0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>
KjL23W2W00@?L:P?LJP?LJP?LJP33g:X00<?LjP?LjT?LjT010mdZ@<?MJT3
3gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/347b/111m[00447j/47j]47j]47n]
0Q5o[@<AP:d00a61[A61[Q61[P034H:^0a63[P034HB^4HB_4HB_00<AQJl4
4HJ_0a:7/0<BR;024XV`00@BRK4BR[4BR[4BR[434X^a0Q:</@044Xbb4Xfb
4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008CSk<34i2c0a>A/`034i:c4i:d4i:d
00<CTk@34iBd0a>E]@<DU[D359Ne11BH]P<DVKH259Zf00@DV[LDVkLDVkLD
VkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh0aFO^0035J2h5J2i5J2i00@EXKT3
5J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/35ZRk0aJY_0@FZ[`011J[_1J[_AJ[
_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h00aN__P<G/;h00aNa_QNa_aNa_`03
5k:o0aNc_`8H]<000lSPf8S0^8S0^00;R<2h00=8T8P00038h=P03HS0^005
B92800006;C06;C0b>3H00f8`;P014R@R00001Rd`1Rd`0:8`;P1B9280@00
000000B8`;S8h=R8`;R8`;P3002000^KYo7oooooRGooooocX:kaTj7ooooo
oOocX:kono`c@jD02000P0<00H0200:000@00X400h400h400h4300B10P05
P@0400F200J200J200J20P07PP030@N20@R20@R2008128<30@V30`4:P`03
0@^30@^40@^400<138@30@f40`4>Q@<23hD30Q25108AQP<24XH20Q>600@2
4hL258L258L258L30QF70P8FQ`040aJ80aN80aN80aN80`<HR0030aV80aV9
0aV900@36XT30a^90`<LRP<37HX311j:0`@OR`<488/3126;0`@RS0@48h`0
10@TS0@TS@@TS@@US@859Hd31BJ=00<59hd59hh59hh00`DXSP<5:Hh00`DZ
SPDZS`DZS`031B^?10D/S`<6;I031Rj@0PH_T0041RnA1S2A1S2A1S2A0`Ha
T@86<Y4010HbTPHcTPHcTPHcTP86=9800`LdTPLeTPLeTP021cFC0`LfT`<7
=i<00`LhT`LhU0LhU0031cVD0`LjU0<7>iD323bE0`PmU@@8?YH323nF0PQ0
UP04242G246G246G246G0`Q2U`88@iL010U3V0U4V0U4V0U4V0<9AIP00`U6
V0U6V@U6V@042DNI0`U8V@<9BIX32DZJ0`Y;VP<:C9/32TfK0`Y>V`<:Ci`4
2U2L00@:DI`:DId:DId:DYd22e:M0`]CW@032eBM2eBN2eBN00<;EIh32eJN
00<;Eih;Eil;Eil00`]HW`@;FIl335ZP0`aKX08<G:0010aLX@aMX@aMX@aM
X@<<GZ4235nQ00@<Gj8<H:8<H:8<H:82366R00<=HJ8=HZ8=HZ800PeRX`<=
Hj<33FBS00<=IJ<=IJ@=IJ@00`eVY0<=Ij@33FRU0`iYY@<>JZD43V^V0`i/
YP8>KJH010i]Y`i^Y`i^Y`i^Y`<>KjL23W2W00@?L:P?LJP?LJP?LJP33g:X
00<?LjP?LjT?LjT010mdZ@<?MJT33gJZ0`mgZP<@N:X347V[0a1jZ`<@Nj/3
47b/111m[00447j/47j]47j]47n]0Q5o[@<AP:d00a61[A61[Q61[P034H:^
0a63[P034HB^4HB_4HB_00<AQJl44HJ_0a:7/0<BR;024XV`00@BRK4BR[4B
R[4BR[434X^a0Q:</@044Xbb4Xfb4Xfb4Xfb0Q:>/P034hjb4hnb4hnb008C
Sk<34i2c0a>A/`034i:c4i:d4i:d00<CTk@34iBd0a>E]@<DU[D359Ne11BH
]P<DVKH259Zf00@DV[LDVkLDVkLDVkL359bg0QBM]`045Ifh5Ijh5Ijh5Ijh
0aFO^0035J2h5J2i5J2i00@EXKT35J:i0aFS^P<EY;X35ZFj0aJV^`<FYk/3
5ZRk0aJY_0@FZ[`011J[_1J[_AJ[_AJ/_@8G[;d35jfm00<G[[dG[[hG[[h0
0aN__P<G/;h00aNa_QNa_aNa_`035k:o0aNc_`8H]<0?b>3H00<00038h=S8
h=P03LSPf00300006;C06;C000o8h=P00`0001Rd`1Rd`002R<2h0DR@R040
00000004R<2hb>3HR<2hR<2h1000P0>KYo401_oooo>P[_Be_oJlaO_IfS=3
Y@T0080300600P02P00400:100>100>100>10`04P@801H401005PP06PP06
PP06PP801h800`47PP48PP48PP020@R30`49P`<12X<00`4;P`4;Q04;Q003
0@b40`4=Q0<13XD30Pn50`8@Q@@24HH30Q:60P8CQP040Q>70QB70QB70QB7
0`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<IR0<IR@<IR@040aZ90`<K
R@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`412><00@498`498d498d4
9Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>00<5:Xh5:Xl5:Xl00`D[
S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`T@<6<I421S:A00@6<Y86
<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7=Y<31cNC00<7>9<7>9@7
>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`PoUP88@9H010Q0U`Q1U`Q1
U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH00<9AYP9AYT9AYT010U7
V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/32TnL10Y@W0042U6L2U6M
2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN0`]FWP032eNN2eNO2eNO
00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<GJ4<GJ4335jQ0PaOX@04
35nR362R362R362R0PaQXP033F6R3F:R3F:R008=HZ<33F>S0`eTX`033FFS
3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[YP<>K:H23VfV00@>KJL>
KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X0`mbZ0033g>X3g>Y3g>Y
00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/347^[0a1l[0@@OJ`0111n
[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh00a62[P<APjh00a64[Q64
[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa4XZa4XZa4XZa0a:;/@8B
S;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?/P024hnc0a>@/`<CTK<0
0a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG]@@DV;H359Vf0QBJ]P04
59Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN^1FN^0<EWkP00aFP^1FP
^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/35ZNk0aJX^`<FZK`45ZZl
00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn5jjn00<G[kh35k2n00<G
/KhG/KlG/Kl00aNb_`<G/klf6;C00XS0^058T8P10000000018S0^<SPf8S0
^8S0^1H0080300600P02P00400:100>100>100>10`04P@801H401005PP06
PP06PP06PP801h800`47PP48PP48PP020@R30`49P`<12X<00`4;P`4;Q04;
Q0030@b40`4=Q0<13XD30Pn50`8@Q@@24HH30Q:60P8CQP040Q>70QB70QB7
0QB70`8EQ`825XL010<FR0<GR0<GR0<GR0<368P00`<IR0<IR@<IR@040aZ9
0`<KR@<378X30af:0`@NRP<47h/3122;0`@QR`<48X`412><00@498`498d4
98d49Hd21BF=0`DVS@031BN=1BN>1BN>00<5:8h31BV>00<5:Xh5:Xl5:Xl0
0`D[S`@5;8l31Rf@0`H^T086;i0010H_T@H`T@H`T@H`T@<6<I421S:A00@6
<Y86<i86<i86<i821SBB00<7=987=I87=I800PLeT`<7=Y<31cNC00<7>9<7
>9@7>9@00`LiU0<7>Y@31c^E0`PlU@<8?ID423jF0`PoUP88@9H010Q0U`Q1
U`Q1U`Q1U`<8@YL224>G00@9@iP9A9P9A9P9A9P32DFH00<9AYP9AYT9AYT0
10U7V@<9B9T32DVJ0`U:VP<:BiX32TbK0`Y=V`<:CY/32TnL10Y@W0042U6L
2U6M2U6M2U:M0P]BW@<;Did00`]DW@]DWP]DWP032eFN0`]FWP032eNN2eNO
2eNO00<;F9l42eVO0`aJX0<<Fj0235bP00@<G:4<GJ4<GJ4<GJ4335jQ0PaO
X@0435nR362R362R362R0PaQXP033F6R3F:R3F:R008=HZ<33F>S0`eTX`03
3FFS3FFT3FFT00<=IZ@33FNT0`eXY@<>JJD33VZU10i[YP<>K:H23VfV00@>
KJL>KZL>KZL>KZL33VnW0Pi`Y`043g2X3g6X3g6X3g6X0`mbZ0033g>X3g>Y
3g>Y00@?M:T33gFY0`mfZP<?MjX347RZ0a1iZ`<@NZ/347^[0a1l[0@@OJ`0
111n[11n[A1n[A1o[@8AOjd34H2]00<APJdAPJhAPJh00a62[P<APjh00a64
[Q64[a64[`034HF_1166[`<BQk034XR`0Q:9/0044XVa4XZa4XZa4XZa0a:;
/@8BS;4011:</Q:=/Q:=/Q:=/P8BS[800a>>/Q>?/Q>?/P024hnc0a>@/`<C
TK<00a>B/a>B]1>B]0034i>d0a>D]0<CUKD359Je0aBG]@@DV;H359Vf0QBJ
]P0459Zg59^g59^g59^g0aBL]`8DWKL011FM^1FN^1FN^1FN^0<EWkP00aFP
^1FP^AFP^@045J6i0aFR^@<EXkX35JBj0aJU^P<FY[/35ZNk0aJX^`<FZK`4
5ZZl00@FZk`FZkdFZkdF[;d25jbm0aN]_@035jjm5jjn5jjn00<G[kh35k2n
00<G/KhG/KlG/Kl00aNb_`<G/klf6;C00XS0^058T8P1000000000hS0^<SP
f8S0^03oR<2hohS0^7f8`;P1B9280@00000000>8`;S8h=R8`;P0ohS0^?n8
`;QmR<2h0DR@R04000000003R<2hb>3Hb>3H0?o8h=Sob>3HOLSPf058T8P1
0000003oR<2hohS0^868`;P100000000\
\>"], "Graphics",
  ImageSize->{640, 480},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}}],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`4000:00001h2000`400?l0
0000o`00003oooo`l?3ooo3`l8;ol?3`003ooo3`l?ool?3`P_o`l?000?oo
l?3`ooo`l?22oo3`l000ooo`l?3ooo3`l8;ol?3`003ooo3`l?ool?3`P_o`
l?000?ool?3`ooo`l?22oo3`l000ooo`l?3ooo3`l8;ol?3`003ooo3`l?oo
l?3`P_o`l?000?ool?3`ooo`l?22oo3`l000ooo`l?3ooo3`l8;ol?3`003o
oo3`l?ool?3`P_o`l?000?ool?3`ooo`l?22oo3`l000ooo`l?3ooo3`l8;o
l?3`003ooo3`l?ool?3`P_o`l?000?ool?3`ooo`l?22oo3`l000oolXG;Oo
obQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00
oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2
obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bg
oolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L0
0?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bg
P_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL
]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg
003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL
]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolX
G;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL
]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolX
G;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo
:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lX
G;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo
:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003o
obQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o
:5bg001mobQL]lSoRXZ:oolXG;LlobQL]`00OOlXG;O8ogmoOooo:5bg??lX
G;L007go:5bg00?oOgmoooooooooool0]Oooool00ooIfMWoooooooooo`0<
ooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L007go:5bg00?oOgmooooo
ooooool0]Oooool01?oIfMWooooooooooooUiND3ooooo`05onGUiOoooooo
oooooooooooUiND00oooool00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001m
obQL]`03ogmoOooooooooooo0;Gooooo00gofMWIoooooooJf][oSHf=onGU
iOoooooof][Johf=SOoUiNGoooooom[Jf_n=SHgoiNGU00;ooooo00?oOgmo
obQL]olXG;L0oolXG;LjobQL]`00OOlXG;L00omoOgooooooooooo`2eoooo
o`0@omWIfOooooooooooom[Jf_n=SHgoiNGUoooooooJf][oSHf=onGUiOoo
oooof][Johf=SOoUiNGoooooogmoOooo:5bg??lXG;L007go:5bg00?oOgmo
ooooooooool0]Oooool03OoIfMWooooooooooooooooof][Johf=SOoUiNGo
ooooom[Jf_n=SHgoiNGUoooooooJf]X00_ooool00omoOgoo:5bgobQL]`3o
obQL]c[o:5bg001mobQL]`03ogmoOooooooooooo0;Gooooo00?ofMWIoooo
ooooool00_ooool01ooJf][oSHf=onGUiOoooooof][Johf=SOoUiND00ooo
ool00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001mobQL]`03ogmoOooooooo
oooo0;Gooooo00?ofMWIooooooooool00oooool01ooJf][oSHf=onGUiOoo
oooof][Johf=SOoUiND00_ooool00omoOgoo:5bgobQL]`3oobQL]c[o:5bg
001mobQL]`03ogmoOooooooooooo0;Gooooo00?ofMWIooooooooool01?oo
ool02OoJf][oSHf=onGUiOoooooog=cLohf=SOoUiNGoooooogmoO`3oobQL
]cco:5bg001mobQL]`03ogmoOooooooooooo0;Gooooo00?ofMWIoooooooo
ool01Oooool01OoJf][oSHf=onGUiOoooooog=cL00;ooooo00?oOgmoobQL
]olXG;L0oolXG;LjobQL]`00OOlXG;L00omoOgooooooooooo`2eooooo`03
omWIfOoooooooooo00Kooooo00?og=cLohf=SOoUiND00oooool00omoOgoo
:5bgobQL]`3oobQL]c[o:5bg001mobQL]`03ogmoOooooooooooo0;Gooooo
00?ofMWIooooooooool01oooool00ooLg=coSHf=onGUi@02ooooo`03ogmo
OolXG;Oo:5bg0?oo:5bg>_lXG;L007go:5bg00?oOgmoooooooooool0]Ooo
ool00ooIfMWoooooooooo`08ooooo`05omcLg?n=SHgoiNGUoooooomoOgl0
oolXG;LlobQL]`00OOlXG;L00omoOgooooooooooo`2eooooo`03omWIfOoo
oooooooo00Wooooo00Cog=cLooooooooooooOgmooolXG;LlobQL]`00OOlX
G;L00omoOgooooooooooo`2eooooo`03omWIfOoooooooooo00cooooo00?o
OgmoobQL]olXG;L0oolXG;LjobQL]`00OOlXG;L00omoOgooooooooooo`2e
ooooo`oofMWI00?oOgmoobQL]olXG;L0oolXG;LjobQL]`00OOlXG;L00omo
Ogooooooooooo`34ooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L007go
:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o
:5bg001mobQL]`03ogmoOooVi^Koi^KV0<Coi^KV00?oOgmoobQL]olXG;L0
oolXG;LjobQL]`00OOlXG;L00omoOgook^k^onk^kP34onk^kP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L007go:5bg00?oOgmoooooooooool0a?ooool0
0omoOgoo:5bgobQL]`3oobQL]c[o:5bg001mobQL]`03ogmoOoo^k^kok^k^
0<Cok^k^00?oOgmoobQL]olXG;L0oolXG;LjobQL]`00OOlXG;L00omoOgoo
i^KVonKViP34onKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L007go:5bg
00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg
001TobQL]aWoRXZ:00?oOgmoooooooooool0a?ooool00omoOgoo:5bgobQL
]`3oobQL]c[o:5bg001TobQL]a[oOgmoa_o^k^h00omoOgoo:5bgobQL]`3o
obQL]c[o:5bg001TobQL]`03ogmoOooooooooooo01Kooooo00?oOgmoonKV
i_oVi^H0a?oVi^H00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03
ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo
:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03ogmoOooooooooooo01Kooooo
00?oOgmoooooooooool0a?ooool00omoOgoo:5bgobQL]`3oobQL]c[o:5bg
001TobQL]`03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^
k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03ogmoOooooooo
oooo01Kooooo00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgoo:5bgobQL]`3o
obQL]c[o:5bg001TobQL]`03ogmoOooooooooooo01Kooooo00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03
ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoo
:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03ogmoOooooooooooo01Kooooo
00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg
001TobQL]`03ogmoOooooooooooo01Kooooo00?oOgmoonKVi_oVi^H0a?oV
i^H00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03ogmoOooooooo
oooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3o
obQL]c[o:5bg001TobQL]`03ogmoOooooooooooo01Kooooo00?oOgmooooo
ooooool0a?ooool00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03
ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo
:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03ogmoOooooooooooo01Kooooo
00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgoo:5bgobQL]`3oobQL]c[o:5bg
001TobQL]`03ogmoOooooooooooo01Kooooo00?oOgmoonk^k_o^k^h0a?o^
k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03ogmoOooooooo
oooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoo:5bgobQL]`3o
obQL]c[o:5bg001TobQL]`03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^
k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03
ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgoo
:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03ogmoOoo^k^kok^k^01Kok^k^
00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg
001TobQL]`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?oo
ool00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03ogmoOoo^k^ko
k^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3o
obQL]c[o:5bg001TobQL]`03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H0a?oVi^H00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03
ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo
:5bgobQL]`3oobQL]c[o:5bg001TobQL]`03ogmoOooooooooooo01Kooooo
00?oOgmoooooooooool0a?ooool00omoOgoo:5bgobQL]`3oobQL]c[o:5bg
001;obQL]aWoRXZ:00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^
kP34onk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L004_o:5bg6_moOglH
onKViP03ogmoOooVi^Koi^KV0<Coi^KV00?oOgmoobQL]olXG;L0oolXG;Lj
obQL]`00BolXG;L00omoOgooooooooooo`0Fooooo`03ogmoOoo^k^kok^k^
01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL
]c[o:5bg001;obQL]`03ogmoOooooooooooo01Kooooo00?oOgmooooooooo
ool05_ooool00omoOgooooooooooo`34ooooo`03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L004_o:5bg00?oOgmoooooooooool05_ooool00omoOgook^k^
onk^kP0Fonk^kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoobQL]olXG;L0
oolXG;LjobQL]`00BolXG;L00omoOgooooooooooo`0Fooooo`03ogmoOooV
i^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgoo:5bgobQL
]`3oobQL]c[o:5bg001;obQL]`03ogmoOooooooooooo01Kooooo00?oOgmo
onk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP34onk^kP03ogmoOolXG;Oo
:5bg0?oo:5bg>_lXG;L004_o:5bg00?oOgmoooooooooool05_ooool00omo
Ogooooooooooo`0Fooooo`03ogmoOooooooooooo0<Cooooo00?oOgmoobQL
]olXG;L0oolXG;LjobQL]`00BolXG;L00omoOgooooooooooo`0Fooooo`03
ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo
:5bgobQL]`3oobQL]c[o:5bg001;obQL]`03ogmoOooooooooooo01Kooooo
00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP34onKViP03ogmo
OolXG;Oo:5bg0?oo:5bg>_lXG;L004_o:5bg00?oOgmoooooooooool05_oo
ool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^0<Cok^k^00?o
OgmoobQL]olXG;L0oolXG;LjobQL]`00BolXG;L00omoOgooooooooooo`0F
ooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool0
0omoOgoo:5bgobQL]`3oobQL]c[o:5bg001;obQL]`03ogmoOooooooooooo
01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP34onk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L004_o:5bg00?oOgmooooooooo
ool05_ooool00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV0<Co
i^KV00?oOgmoobQL]olXG;L0oolXG;LjobQL]`00BolXG;L00omoOgoooooo
ooooo`0Fooooo`03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0
a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001;obQL]`03ogmoOooo
oooooooo01Kooooo00?oOgmoooooooooool05_ooool00omoOgoooooooooo
o`34ooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L004_o:5bg00?oOgmo
ooooooooool05_ooool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^ko
k^k^0<Cok^k^00?oOgmoobQL]olXG;L0oolXG;LjobQL]`00BolXG;L00omo
Ogooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKV
i_oVi^H0a?oVi^H00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001;obQL]`03
ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgoo
k^k^onk^kP34onk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L004_o:5bg
00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03ogmo
Oooooooooooo0<Cooooo00?oOgmoobQL]olXG;L0oolXG;LjobQL]`00BolX
G;L00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg001;
obQL]`03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H05_oVi^H0
0omoOgooi^KVonKViP34onKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
04_o:5bg00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^
kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoobQL]olXG;L0oolXG;LjobQL
]`00BolXG;L00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Ko
oooo00?oOgmoooooooooool0a?ooool00omoOgoo:5bgobQL]`3oobQL]c[o
:5bg001;obQL]`03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h0
5_o^k^h00omoOgook^k^onk^kP34onk^kP03ogmoOolXG;Oo:5bg0?oo:5bg
>_lXG;L003;o:5bg6On:RXX00omoOgooi^KVonKViP0FonKViP03ogmoOooV
i^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgoo:5bgobQL
]`3oobQL]c[o:5bg000bobQL]a[oOgmo6?o^k^h00omoOgook^k^onk^kP0F
onk^kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoobQL]olXG;L0oolXG;Lj
obQL]`00<_lXG;L00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo
01Kooooo00?oOgmoooooooooool05_ooool00omoOgooooooooooo`34oooo
o`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L003;o:5bg00?oOgmooooooooo
ool05_ooool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Ko
k^k^00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o
:5bg000bobQL]`03ogmoOooooooooooo01Kooooo00?oOgmoonKVi_oVi^H0
5_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV0<Coi^KV
00?oOgmoobQL]olXG;L0oolXG;LjobQL]`00<_lXG;L00omoOgoooooooooo
o`0Fooooo`03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^
k^h00omoOgook^k^onk^kP34onk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lX
G;L003;o:5bg00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0F
ooooo`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool0
0omoOgoo:5bgobQL]`3oobQL]c[o:5bg000bobQL]`03ogmoOooooooooooo
01Kooooo00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^
kP03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoobQL]olXG;L0oolXG;LjobQL
]`00<_lXG;L00omoOgooooooooooo`0Fooooo`03ogmoOooVi^Koi^KV01Ko
i^KV00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP34onKViP03
ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L003;o:5bg00?oOgmoooooooooool0
5_ooool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^
00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg
000bobQL]`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_oo
ool00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo0<Cooooo00?o
OgmoobQL]olXG;L0oolXG;LjobQL]`00<_lXG;L00omoOgooooooooooo`0F
ooooo`03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP34onk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
03;o:5bg00?oOgmoooooooooool05_ooool00omoOgooi^KVonKViP0FonKV
iP03ogmoOooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omo
Ogoo:5bgobQL]`3oobQL]c[o:5bg000bobQL]`03ogmoOooooooooooo01Ko
oooo00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03
ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoobQL]olXG;L0oolXG;LjobQL]`00
<_lXG;L00omoOgooooooooooo`0Fooooo`03ogmoOooooooooooo01Kooooo
00?oOgmoooooooooool05_ooool00omoOgooooooooooo`34ooooo`03ogmo
OolXG;Oo:5bg0?oo:5bg>_lXG;L003;o:5bg00?oOgmoooooooooool05_oo
ool00omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg000b
obQL]`03ogmoOooooooooooo01Kooooo00?oOgmoonKVi_oVi^H05_oVi^H0
0omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV0<Coi^KV00?oOgmo
obQL]olXG;L0oolXG;LjobQL]`00<_lXG;L00omoOgook^k^onk^kP0Fonk^
kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omo
Ogook^k^onk^kP34onk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L003;o
:5bg00?oOgmoooooooooool05_ooool00omoOgooooooooooo`0Fooooo`03
ogmoOooooooooooo01Kooooo00?oOgmoooooooooool0a?ooool00omoOgoo
:5bgobQL]`3oobQL]c[o:5bg000bobQL]`03ogmoOoo^k^kok^k^01Kok^k^
00?oOgmoonk^k_o^k^h05_o^k^h00omoOgook^k^onk^kP0Fonk^kP03ogmo
Ooo^k^kok^k^0<Cok^k^00?oOgmoobQL]olXG;L0oolXG;LjobQL]`00<_lX
G;L00omoOgooi^KVonKViP0FonKViP03ogmoOooVi^Koi^KV01Koi^KV00?o
OgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP34onKViP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L003;o:5bg00?oOgmoonk^k_o^k^h05_o^k^h0
0omoOgook^k^onk^kP0Fonk^kP03ogmoOoo^k^kok^k^01Kok^k^00?oOgmo
onk^k_o^k^h0a?o^k^h00omoOgoo:5bgobQL]`3oobQL]c[o:5bg000bobQL
]`03ogmoOooooooooooo01Kooooo00?oOgmoooooooooool05_ooool00omo
Ogooooooooooo`0Fooooo`03ogmoOooooooooooo0<Cooooo00?oOgmoobQL
]olXG;L0oolXG;LjobQL]`00<_lXG;L00omoOgook^k^onk^kP0Fonk^kP03
ogmoOoo^k^kok^k^01Kok^k^00?oOgmoonk^k_o^k^h05_o^k^h00omoOgoo
k^k^onk^kP34onk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L003;o:5bg
00?oOgmoonKVi_oVi^H05_oVi^H00omoOgooi^KVonKViP0FonKViP03ogmo
OooVi^Koi^KV01Koi^KV00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgoo:5bg
obQL]`3oobQL]c[o:5bg000IobQL]lSoRXZ:Hoo^k^h00omoOgoo:5bgobQL
]`3oobQL]c[o:5bg000IobQL]lSoOgmoHoooool00omoOgoo:5bgobQL]`3o
obQL]c[o:5bg000IobQL]`03ogmoOooooooooooo0;Gooooo00?ofMWIoooo
ooooool03?ooool00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg
0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0]Oooool01?oIfMWo
oooooooooooUiND3ooooo`05onGUiOoooooooooooooooooUiND00oooool0
0omoOgooi^KVonKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoooooooooool0]Oooool03OoIfMWoooooom[Jf_n=SHgo
iNGUoooooooJf][oSHf=onGUiOoooooof][Johf=SOoUiND00_ooool00omo
Ogook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo
:5bg00?oOgmoooooooooool0]Oooool04?oIfMWooooooooooooJf][oSHf=
onGUiOoooooof][Johf=SOoUiNGoooooom[Jf_n=SHgoiNGUoooooomoOgmS
ooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmooooo
ooooool0]Oooool03OoIfMWooooooooooooooooof][Johf=SOoUiNGooooo
om[Jf_n=SHgoiNGUoooooooJf]X00_ooool00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmooooooooo
ool0]Oooool00ooIfMWoooooooooo`02ooooo`07om[Jf_n=SHgoiNGUoooo
oooJf][oSHf=onGUi@03ooooo`03ogmoOooVi^Koi^KV067oi^KV00?oOgmo
obQL]olXG;L0oolXG;LjobQL]`006OlXG;L00omoOgooooooooooo`2eoooo
o`03omWIfOoooooooooo00?ooooo00Oof][Johf=SOoUiNGoooooom[Jf_n=
SHgoiNGU00;ooooo00?oOgmoonk^k_o^k^h0HOo^k^h00omoOgoo:5bgobQL
]`3oobQL]c[o:5bg000IobQL]`03ogmoOooooooooooo0;Gooooo00?ofMWI
ooooooooool01?ooool02OoJf][oSHf=onGUiOoooooog=cLohf=SOoUiNGo
ooooogmoO`1Sooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg
00?oOgmoooooooooool0]Oooool00ooIfMWoooooooooo`05ooooo`05om[J
f_n=SHgoiNGUoooooooLg=`00_ooool00omoOgook^k^onk^kP1Qonk^kP03
ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0
]Oooool00ooIfMWoooooooooo`06ooooo`03omcLg?n=SHgoiNGU00?ooooo
00?oOgmoonKVi_oVi^H0HOoVi^H00omoOgoo:5bgobQL]`3oobQL]c[o:5bg
000IobQL]`03ogmoOooooooooooo0;Gooooo00?ofMWIooooooooool01ooo
ool00ooLg=coSHf=onGUi@02ooooo`03ogmoOoo^k^kok^k^067ok^k^00?o
OgmoobQL]olXG;L0oolXG;LjobQL]`006OlXG;L00omoOgooooooooooo`2e
ooooo`03omWIfOoooooooooo00Sooooo00Gog=cLohf=SOoUiNGoooooogmo
O`1Sooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmo
ooooooooool0]Oooool00ooIfMWoooooooooo`09ooooo`04omcLg?oooooo
ooooogmoOf?ok^k^00?oOgmoobQL]olXG;L0oolXG;LjobQL]`006OlXG;L0
0omoOgooooooooooo`2eooooo`03omWIfOoooooooooo00cooooo00?oOgmo
onKVi_oVi^H0HOoVi^H00omoOgoo:5bgobQL]`3oobQL]c[o:5bg000IobQL
]`03ogmoOooooooooooo0;Gooooo3ooIfMT00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmooooooooo
ool0a?ooool00omoOgooooooooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
OgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`1Qoooo
o`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KV
onKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oV
i^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoooooooooool0a?ooool00omoOgooooooooooo`1Qooooo`03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKV
iP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgoooooo
ooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmooooooooo
ool0a?ooool00omoOgooooooooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
OgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`1Qoooo
o`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KV
onKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oV
i^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoooooooooool0a?ooool00omoOgooooooooooo`1Qooooo`03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKV
iP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgoooooo
ooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmooooooooo
ool0a?ooool00omoOgooooooooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
OgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`1Qoooo
o`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KV
onKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oV
i^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoooooooooool0a?ooool00omoOgooooooooooo`1Qooooo`03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKV
iP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgoooooo
ooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmooooooooo
ool0a?ooool00omoOgooooooooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
OgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`1Qoooo
o`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KV
onKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oV
i^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoooooooooool0a?ooool00omoOgooooooooooo`1Qooooo`03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKV
iP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgoooooo
ooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmooooooooo
ool0a?ooool00omoOgooooooooooo`1Qooooo`03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
OgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ogmoOolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`1Qoooo
o`03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ogmoOolXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KV
onKViP1QonKViP03ogmoOolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03oh61POlX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`1Qooooo`03ohB4Q?lXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03ohJ6Q_lXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oV
i^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ohV9ROlXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03oh^;RolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoooooooooool0a?ooool00omoOgooooooooooo`1Qooooo`03ohj>S_lX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03oi2@T?lXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKV
iP03oi>CTolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03oiFEUOlXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgoooooo
ooooo`1Qooooo`03oiRHV?lXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03oiZJV_lX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H0
0omoOgooi^KVonKViP1QonKViP03oifMWOlXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03oinOWolXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmooooooooo
ool0a?ooool00omoOgooooooooooo`1Qooooo`03oj:RX_lXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^
onk^kP1Qonk^kP03ojBTY?lXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
OgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP1QonKViP03ojNWYolX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h0
0omoOgook^k^onk^kP1Qonk^kP03ojVYZOlXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`1Qoooo
o`03ojb/[?lXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ojj^[_lXG;Oo:5bg0?oo
:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KV
onKViP1QonKViP03ok6a/OlXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^kP03ok>c/olX
G;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool0
0omoOgooooooooooo`1Qooooo`03okJf]_lXG;Oo:5bg0?oo:5bg>_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP1Qonk^
kP03okRh^?lXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg00?oOgmoonKVi_oV
i^H0a?oVi^ITogmoO`03ok^k^olXG;Oo:5bg0?oo:5bg>_lXG;L001Wo:5bg
00?oOgmoonk^k_o^k^h0a?o^k^h0F?moOgooh>3Qon7QhOoPh>3ohN7Qon3P
h?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>3ohN7Q
on3PhOoQhN7oh>3Pon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Qon7QhOoPh>3o
hN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3Pon7QhOoP
h>3ohN7Qon3PhOoQhN7oh>3Pon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Qon7Q
hOoPh>3ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7oh>3P
on7QhOoPh>3ohN7Qon3PhOoQhN7oh>3Pon7QhOoPh>3ohN7Qon3Ph?oQhN7o
h>3Qon7QhOo4a<Co/;gCojnld_n`_M?o[kcBok2mdon__=?o/;gCojnld_n`
_M?o[kcBok2mdon__=83ok2md`03ojnld_n`_M?o/;gC00?o[kcB00Co/[oE
okO4f_nia]co_KfmoolXG;LlobQL]`006OlXG;L00omoOgooooooooooo`34
ooooo`03ogmoOooRh^;oh^;R04Soh^;R00?o`/;2ojbicon/^Ll02_n/^Ll0
0on[^<ko[;W?ojbic`06ojbic`04ok2mdonf`mWo^/OMol30`?oo:5bg??lX
G;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoohn?Son?Sh`05
on?Sh`03omSHf?oRh^;ohn?S00;ohn?S00?og]kNomWIfOoShn<04?oShn<0
0ooKfm_oh^;Ron?Sh`02omkNgQKohn?S00?ofm_Kon;Rh_oShn<00_oNg]h;
on?Sh`03olW9bOnb_mGo/[oE00co/[oE00?o/l3Fok:oeOnc`=H01?nb_mD0
1?nd`MOo^<GKok_8g_o2`/;oobQL]cco:5bg000IobQL]`03ogmoOooVi^Ko
i^KV0<Coi^KV05SoOgmoong]k?o4a<CoRh^;onc/k?o]kNgofMWIohj>S_n;
Rh_oclo>onc/k?oRh^;oWYjNoh20P?n=SHgoR8R8om7AdOo]kNcoVYZJokFe
]Oo/k>cokNg]onc/k?nJVY[o]KFeong]k?o/k>coaLG5ohZ:R_o]kNgok>c/
oj6QXOn2PX;oRXZ:ol71`On7QhOoY:BTong]kOnJVY[o]KFeonc/k?o]kNco
k>c/ong]kOo/k>cokNg]oiJFU_na/K7ok>c/ong]k?o/k>cokNg]onc/k?nJ
VY[o]KFeong]kOo/k>cokNg/oj6QXOn2PX;oRXZ:ol;2`_n7QhOoY:BTonc/
k?nJVY[o]KFeong]kOo/k>cokNg]onc/k?o]kNgok>c/ong]k?o/k>coeMGE
okg:h?nnbn7o_L[Pokk;hOnmb^3o_/_Pokg:h?nnbn7o_L[Pokk;hOnmb^3o
_/_Q3?nmb^000oo5aLGo:5bgobQL]`3oobQL]c[o:5bg000IobQL]`03ogmo
Ooo^k^kok^k^0<Cok^k^05WoOgmoonKViOo0`<3oRXZ:onGUiOoVi^Ko[:b/
oiVIVOoTi>Coi^KUonGUiOnJVY[oV9RHomWIfOoUiNGohN7QomoOgooVi^Go
V9RHok:b/_oUiNGoi^KVonGUiOnHV9So/K6aonKViOoUiNGo`<30ohZ:R_oV
i^Koc/k>oh20P?oGemOofm_Koj>SXon5QHGoiNGUonKVi_nHV9So/[:bonGU
iOoVi^GoiNGUonKVi_oUiNGoi^KVoiBDU?n][JgoiNGUonKViOoUiNGoi^KV
onGUiOnHV9So/K6aonKVi_oUiNGoc/k>oh20P?oHf=Sofm_Koj>SXon5QHGo
i^KVonGUiOnHV9So/K6aonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKViOoU
iNGocLg=okC1eone`]So]<7GokG2f?nd`MOo]L;GokC1eone`]So]<7GokG2
f?nd`MOo]L;HokC1e`04okG2f008okC1eone`]So]L;HokG2f?nga=[o^lSN
oko<h_o7alOoobQL]cco:5bg000IobQL]`03ogmoOooooooooooo0<Cooooo
00CoOgmoonOWioo1`L7oRXZ:0_oWinL01onNWYko[Jf]onOWiooWinOofMWI
ogmoOoo:b/X01OoWinL00onIVIWo/[:bonOWi`02onOWi`0=oiVIVOnb/[;o
inOWonOWioo1`L7oRXZ:onOWiooGemOoP820olc<c?oWinOo_knoohb<S002
onOWi`03oiVIVOnb/[;oinOW00GoinOW00?oUIFEojj^[_oWinL01?oWinL0
2_nIVIWo/[:bonOWiooWinOoemOGoh20P?o<c<coinOWokno_on<S8`2onOW
i`03oiVIVOnb/[;oinOW00OoinOW00?obLW9ok6ne?na_]@04_na_]@01Onb
_mGo]lCJok[7gOo0cN?ob/[:0?oo:5bg??lXG;L001Wo:5bg00?oOgmoonk^
k_o^k^h0a?o^k^h01?moOgooj>SXol;2`_n:RXX2onSXj006oijNW_n][Jgo
j>SXonSXj?o=cLgoOgmo1?nHV9P01?o?clooj>SXoiVIVOnc/k<3onSXj006
oiVIVOnc/k?oj>SXonSXj?o2`/;oRXZ:0_oXj>P01Oo6a/KoTi>CoiBDU?nE
UIGoS8b<00;oj>SX00?oVIVIok>c/ooXj>P01OoXj>P00onEUIGo[Zj^onSX
j004onSXj003oiVIVOnc/k?oj>SX00;oj>SX00Goa/K6oi>CTonDU9CoUIFE
ohb<S002onSXj003oiVIVOnc/k?oj>SX00Ooj>SX00?od=3@okO4f_nga=X0
4onga=X01?njamgo_lcRol;?iOo<c<coobQL]cco:5bg000IobQL]`03ogmo
OooVi^Koi^KV0<Coi^KV00CoOgmooo;bl_o5aLGoS8b<0_obl_803_nQXJ7o
/[:boo;bl_obl_;ohN7QogmoOoo<c<cog=cLomSHf?n0P83oi^KVoo;bl_nK
Vi_o[Zj^0oobl_801_nKVi_oZ:RXoo;bl_obl_;oaLG5ohb<S0Col_;b00?o
lO7aol71`On=SHd00_obl_800onKVi_o^;Rhoo;blP05oo;blP05oiNGUon<
S8coWIfMoifMWOn[Zj/00_obl_800onKVi_o[Zj^oo;blP04oo;blP03oo7a
lOo1`L7oSHf=00;ol_;b00?oVi^Kok2`/?obl_801oobl_800ooMgMgo`m3V
ol?@iP0Bol?@iP05olCAioo3d>Ko`m3Vol?@i_o?cll0oolXG;LlobQL]`00
6OlXG;L00omoOgook^k^onk^kP34onk^kP0@ogmoOooMgMgoXj>SoinOWoo[
jn_oj>SXoifMWOn][Jgoi^KVonWYjOo[jn_oVIVIojb/[?oWinOo`L71oi6A
T@;ojn_[00_oVYZJohN7Qonl_;cogmoOon[Zj_nJVY[oQhN7ok2`/?oMgMgo
Xj>SoinOW`02on_[j`05ol_;booKfm_ojNWYojRXZ?nRXZ800_o[jn/00onJ
VY[o];Bdon_[j`05on_[j`05oiFEUOnSXj?od=3@om3@d?oDe=@00_o[jn/0
2_nJVY[oQhN7okbl_?oOgmooj^[Zol_;booKfm_ojNWYojRXZ?nRXZ82on_[
j`04oiZJV_n7QhOo^[Zjon7Qh@Kojn_[00?oe=CDok[7gOnjamd04onjamd0
1?nlbMoo`/oUolCAiooAdM7oobQL]cco:5bg000IobQL]`03ogmoOooooooo
oooo0<Cooooo05SoOgmoohN7QonBTY;od];Bonc/k?nd];CoPX:2ohB4Q?n:
RX[ob<S9onc/k?oPh>3oWIfMohB4Q?n:RX[oc<c<onc/k?o[jncoXZ:RokVi
^OnVYZKoPX:2onGUiOnRXZ;o^[Zjok:b/_n7QhOoTY:Bom;Bd_o[jn_ok>c/
okVi^OnDU9CoQHF5oiNGUooBd];ok>c/on_[jonJVY[o];Bdonc/k?o[jnco
k>c/on_[joo/k>cojn_[oiJFU_n`/;3ok>c/on_[k?o/k>cojn_[onc/k?nR
XZ;o^KViojJVY_n2PX;oi>CUokVi^OnDU9CoQHF5oiNGUooBd];ojn_[onc/
k?nRXZ;o^[Zjojj^[_n5QHGojn_[onc/k?o[jn_ok>c/on_[k?o/k>cod=3@
okK3fOne`]So]/?IokG2f?nf`mWo]L;IokK3fOne`]So]/?IokG2f?nf`mWo
]L;H0_nf`mT00one`]So]/?IokK3f@03okK3f@05okG2f?nkb=ko`<gSolKC
jOoDe=@0oolXG;LlobQL]`006OlXG;L00omoOgook^k^onk^kP34onk^kP03
ogmoOoo/k>cokNg]00?okNg]00?oX:2Pok2`/?o]kNd01?o]kNd00oo[jn_o
kNg]ong]k@05ong]k@03on_[joo]kNgokNg]00;okNg]00?ok>c/ong]kOo]
kNd01?o]kNd00oo/k>cokNg]ong]k@02ong]k@03oiZJV_ne]KGokNg]00Go
kNg]00?oUYJFok6a/Oo]kNd01oo]kNd01Oo[jn_okNg]ong]kOo]kNgok>c/
00OokNg]00?ok>c/ong]kOo]kNd01?o]kNd00ooHf=So_<WOokc9g`0Bokc9
g`05ok_8g_noc>;o`m3VolKCjOoFe]H0oolXG;LlobQL]`006OlXG;L00omo
Ogooi^KVonKViP34onKViP03ogmoOoofm_Kom_Kf00?om_Kf00?oinOWonKV
i_ofm_H07Oofm_H00onLW9co^[ZjooKfmP05ooKfmP03oiRHV?nDU9Co[Zj^
00;o[Zj^00?oe=CDooKfm_ofm_H05Oofm_H00ooShn?oamCZolODjP0@olOD
jP03olKCjOo7e>[oa]?Y00?oamCZ00?ofMWIobQL]olXG;L0oolXG;LjobQL
]`006OlXG;L00omoOgook^k^onk^kP34onk^kP03ogmoOoo^k^kok^k^02?o
k^k^00?oVYZJokJf]_o^k^h01Oo^k^h00oo;bl_o`/;2ol;2`P02ol;2`P03
omWIfOo^k^kok^k^01Gok^k^00?of][Jokg:h?nmb^004onmb^001?o0cN?o
a=7WolSEjooKfm_oobQL]cco:5bg000IobQL]`03ogmoOooooooooooo0<Co
oooo00?oOgmoonk^k_o^k^h08oo^k^h00oo/k>cokNg]onk^kP0Ronk^kP03
omGEeOnhaM_o^<GK00co^<GK00?o]lCJokS5fonhaM/01?nhaM/01?nmb^3o
`m3VolSEjooNg]koobQL]cco:5bg000IobQL]`03ogmoOoo^k^kok^k^0<Co
k^k^00?oOgmoonk^k_o^k^h0B?o^k^h00ooKfm_o_L[Pokg:h00Aokg:h006
okk;hOnmb^3o`<gSolGBj?o8eN_oh>3PoolXG;LlobQL]`006OlXG;L00omo
Ogooi^KVonKViP34onKViP1KogmoOoohn?OomoOgooShn?ogmoOon?ShooOg
moohn?SomoOgooShmoogmoOon?ShooOgmoohn?SomoOgooShn?ogmoOon?Sg
ooOgmoohn?SomoOgooShn?ogmoOon?ShooOgmoohn?OomoOgooShn?ogmoOo
n?ShooOgmoohn?SomoOgooShmoogmoOon?ShooOgmoohn?SomoOgooShn?og
moOon?SgooOgmoohn?SomoOgooShn?ogmoOon?ShooOgmoohn?OomoOgooSh
n?ogmoOon?ShooOgmoohn?SomoOgooShmoogmoOon?ShooOgmoohn?SomoOg
ooShn?ogmoOon?SgooOgmoohn?SomoOgooShn?ogmoOon?ShooOgmoohn?Oo
moOgonSXj?o8eN_obMK/olSEjoo9e^cob=G[olWFjoo8eN_obMK/olSEjoo9
e^cob=G[olWFk?o8eN_obMK/olSEj`02olWFk003olSEjoo9e^cobMK/00?o
bMK/00?o^/_Xon?SholXG;L0oolXG;LkobQL]`006OlXG;L00omoOgook^k^
onk^kP34onk^kP03ogmoOoo_knookno_04Sokno_00?ogMgMokk;hOnnbn40
2_nnbn401?nmb^3o_/_Qokk;hOnmb^04okk;h@04ol3=hoo5d^Sob=G[oo7a
lOoo:5bg?OlXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgoo
kno_ono_k`18ono_k`03omWIfOnia]co^LKL017o^LKL00Go^/OMokg:h?o3
d>KoamCZonc/k03oobQL]cgo:5bg000IobQL]`03ogmoOoo^k^kok^k^0<Co
k^k^00?oOgmoono_koo_knl0B?o_knl00ooOgmoo_/_Qokk;h@0=okk;h@03
okg:h?nnbn7o_/_Q00;o_/_Q00Co`LkTolGBj?o`l?3o>FVloolXG;LmobQL
]`006OlXG;L00omoOgooi^KVonKViP34onKViP03ogmoOoohn?Son?Sh04So
n?Sh00?oj^[ZolWFk?o9e^`04oo9e^`00ooalO7oBWK2obQL]`3oobQL]cgo
:5bg000IobQL]`03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmooo[jn_ojn_X0
B?ojn_X00oo[jn_obMK/olWFk00@olWFk004ok[;j?oalO7ok>c/ocUY_?oo
:5bg?olXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgoohn?S
on?Sh`1Lon?Shooo:5bg@_lXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^
k^h00omoOgook^k^onk^kP18onk^kP03okJf]_lXG;Oo:5bg0?oo:5bgDolX
G;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KVonKViP18
onKViP03okRh^?lXG;Oo:5bg0?oo:5bgDolXG;L001Wo:5bg00?oOgmoonk^
k_o^k^h0a?o^k^i;ogmoO`03ok^k^olXG;Oo:5bg0?oo:5bgDolXG;L001Wo
:5bg00?oOgmoooooooooool0a?ooool0?omoOgooi^KVonGUiOoVi^KoiNGU
onKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^Ko
iNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoV
i^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGU
iOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KV
olC4a?n`_M?o[kcBok2mdon__=;o/;gCojnldon`_M?o[kcBok2mdon__=;o
/;gCojnldP03ok2md`03ojnld_n`_M?o/;gC00?o[kcB00Co/[oEokO4f_ni
a]co_KfmoolXG;MEobQL]`006OlXG;L00omoOgook^k^onk^kP34onk^kP03
ogmoOooMgMgogMgM02oogMgM00?o`/;2ojbicon/^Ll02_n/^Ll00on[^<ko
[;W?ojbic`06ojbic`04ok2mdonf`mWo^/OMol30`?oo:5bgEOlXG;L001Wo
:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgoohN7Qon7Qh@04on7Qh@03
omWIfOoPh>3ohN7Q00;og=cL5_oQhN400ooIfMWoh>3Pon7Qh@02omcLg0_o
hN7Q00?obLW9ok:oeOnb_mD03?nb_mD00onc`=Ko/[oEok?0eP04ok:oe@04
okC1eonhaM_o^lSNol;2`_oo:5bgEOlXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h0?omoOgook^k^olK6a_n;Rh_okno_onk^k_nRXZ;oPX:2ohZ:
R_o2`/;oQhN7ojBTY?o_knooVYZJokJf]_o^k^kokno^onk^k_o_knook^k^
ono_konFUYKo/K6aonk^k_o_knkok^k^ono_koo^k^koVi^KokJf]_o_knoo
k^k^ono_k_nRXZ;oPX:2ohZ:R_o3`l?oQhN7ojFUYOo^k^koVi^JokJf]_o_
knook^k^ono_koo^k^kokno_onk^k_o_knkok^k^omGEeOnmb^3o_/_Qokg:
h?nnbn7o_L[Pokk;h?nmb^3o_/_Qokg:h?nnbn7o_L[Pokk;h@0<okg:h003
olG5aOlXG;Oo:5bg0?oo:5bgDolXG;L001Wo:5bg00?oOgmoooooooooool0
a?ooool0@?moOgooj^[ZolC4a?n:RX[ojn_[om;Bd_n0P83ofm_Kon3PgonU
YJGoQXJ6on[Zj_o[jn_oVIVIokBd]?oZj^[ojn_Zon[Zj_o[jn_oj^[Zon_[
jonEUIGo/;2`on[Zj_o[jn[oj^[Zon_[jooZj^[oVYZJokBd]?o[jn_oj^[Z
om;Bd_n0P83og=cLomoOgonUYJGoQXJ6on_[jooZj^[oVYZIokBd]?o[jn_o
j^[Zon_[jooZj^[ojn_[on[Zj_o[jn[oj^[Zolg=cOnd`MOo]L;HokC1eone
`]So]<7GokG2eond`MOo]L;HokC1eone`]So]<7GokG2f?nd`ML4okG2f008
okC1eone`]So]L;HokG2f?nga=[o^lSNoko<h_o7alOoobQL]eGo:5bg000I
obQL]`03ogmoOoo^k^kok^k^0<Cok^k^00_oOgmoon;Rh_nn_[koRHV9on;R
h_oCdm?oP820olS8b?oRh^;o_;bloh^;R`02on;RhP03oiNGUon`/;3oh^;R
00Goh^;R00?oTi>Cojb/[?oRh^801?oRh^802_nGUiOo/;2`on;Rh_oRh^;o
dm?Coh20P?o8b<Soh^;Rokbl_?n;Rh/2on;RhP03oiNGUon`/;3oh^;R00Oo
h^;R00?obLW9ok6ne?na_]@04_na_]@01Onb_mGo]lCJok[7gOo0cN?ob/[:
0?oo:5bgEOlXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H01?moOgoo
i^KVol30`?n:RXX2onKViP05olC4a?nCTi?oTi>CoiBDU?n;Rh/00_oVi^H0
0onHV9So/[:bonKViP05onKViP03oiBDU?n][Jgoi^KV00Coi^KV00?oV9RH
ok:b/_oVi^H00_oVi^H01Oo4a<CoTi>Coi>CTonDU9CoRh^;00;oi^KV00?o
V9RHok:b/_oVi^H01ooVi^H00oo@d=3o]lCJokO4fP0CokO4fP04ok[7gOno
c>;o`/oUolc<c?oo:5bgEOlXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^
k^h01?moOgoom?CdolO7aon<S8`4ooCdm003oo?cloo2`/;oSXj>00;om?Cd
00?oW9bLokVi^Oodm?@01Oodm?@01OnGUiOoS8b<oijNW_nNWYko[:b/00;o
m?Cd00?oW9bLojn_[oodm?@01?odm?@00ooclo?o`/;2ohj>SP02ooCdm003
oibLW?na/K7om?Cd00Oom?Cd00?ogMgMol?@i_o3d>H04_o3d>H01Oo4dNOo
`m3Vol?@i_o3d>Koclo?0?oo:5bgEOlXG;L001Wo:5bg00?oOgmooooooooo
ool0a?ooool01?moOgoohN7QojFUYOnQXJ42oo3`l005olk>c_oOgmook^k^
ojVYZOnTY:@00_o`l?000onKVi_o]kNgoo3`l005oo3`l005oiJFU_nUYJGo
e=CDomCDe?oHf=P00_o`l?002_nKVi_oQhN7okno_ooTi>Cokno_olk>c_oO
gmook^k^ojVYZOnTY:@2oo3`l004oi^KVon8R8So_KfmonGUi@Kol?3`00?o
e=CDok[7gOnjamd04onjamd01?nlbMoo`/oUolCAiooAdM7oobQL]eGo:5bg
000IobQL]`03ogmoOoo^k^kok^k^0<Cok^k^03ooOgmoohN7QonATI7oc/k>
onKVi_oWinOo][Jfoi>CTon5QHGoUYJFolk>c_oWinOoi^KVoiVIVOnb/[;o
inOWonKViooWinOoi^KVonOWiooVi^KoUIFEojf][OoWinOoi^KWonOWiooV
i^KoinOWoj2PX?nf][KoY:BToh:2P_oOgn3o]kNgoi>CTon5QHGoUYJFolk>
c_oVi^KoinOWoj2PXOng]kOo[:b/ohF5QOoVi^KoinOWonKVi_oWinOoi^KW
onOWioo@d=3o]/?IokG2f?nf`mWo]L;HokK3fOne`]Wo]/?IokG2f?nf`mWo
]L;HokK3fOne`]P00_nf`mT00one`]So]/?IokK3f@03okK3f@05okG2f?nk
b=ko`<gSolKCjOoDe=@0oolXG;MEobQL]`006OlXG;L00omoOgooi^KVonKV
iP34onKViP03ogmoOooZj^[ojn_[00Gojn_[00?oj^[Zon_[joo[jn/00_o[
jn/00onJVY[o];Bdon_[j`05on_[j`03oiFEUOn`/;3ojn_[00Oojn_[00Go
jNWYon_[joo[jn_ojn_[on[ZjP07on_[j`03on[Zj_o[jn_ojn_[00Cojn_[
00?of=SHokc9gonlbMl04_nlbMl01Onkb=ko_lcRol?@i_o6dnWoe]KF0?oo
:5bgEOlXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoon?Sh
ooShn00:ooShn003oifMWOnk^k_on?Sh00Gon?Sh00?oV9RHoiBDU?n^[Zh0
0_n^[Zh00ooFe]Kon?ShooShn00EooShn003on?Shoo7e>[oamCZ013oamCZ
00?oa]?YolODj_o6dnT00oo7e>X00ooIfMWo:5bgobQL]`3oobQL]e?o:5bg
000IobQL]`03ogmoOooooooooooo0<Cooooo00?oOgmooo?clooclo<02_oc
lo<00onLW9co^;Rhoo?cl`05oo?cl`03olo?coo5aLGoaLG500;oaLG500?o
g]kNoo?clooclo<05Ooclo<00ooJf][o_L[Pokg:h00Cokg:h004ol3=hoo4
dNOob=G[om_Kfooo:5bgEOlXG;L001Wo:5bg00?oOgmoonk^k_o^k^h0a?o^
k^h00omoOgoojNWYonWYj@0:onWYj@03onOWiooXj>SojNWY02;ojNWY00?o
eMGEokS5fonhaM/03?nhaM/00onga=[o^<GKokS5f`04okS5f`04okg:h?o3
d>Kob=G[omkNg_oo:5bgEOlXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oV
i^H00omoOgook>c/onc/k00_onc/k003om_Kfonmb^3o_L[P017o_L[P00Ko
_/_Qokg:h?o0cN?oaM;XolSEjooPh>3oobQL]eGo:5bg000IobQL]`03ogmo
Ooo^k^kok^k^0<Cok^k^04;oOgmoooWinOojn_[onOWioo[jn_oinOWon_[j
ooWinOojn_WonOWioo[jn_oinOWon_[jooWinOojn_[onOWioo[jnOoinOWo
n_[jooWinOojn_[onOWioo[jn_oinOWon_[iooWinOojn_[onOWioo[jn_oi
nOWon_[jooWinOojn_WonOWioo[jn_oinOWon_[jooWinOojn_[onOWioo[j
nOoinOWon_[jooWinOojn_[onOWioo[jn_oinOWon_[iooWinOoXj>Sob=G[
olWFk?o8eN_obMK/olSEjoo9e^_ob=G[olWFk?o8eN_obMK/olSEjoo9e^co
b=G[olWFk?o8eN/2olWFk003olSEjoo9e^cobMK/00?obMK/00?o^/_Xon?S
holXG;L0oolXG;MDobQL]`006OlXG;L00omoOgooooooooooo`34ooooo`03
ogmoOoodm?Com?Cd02oom?Cd00?ogMgMokk;hOnnbn402_nnbn401?nmb^3o
_/_Qokk;hOnmb^04okk;h@04ol3=hoo5d^Sob=G[oo7alOoo:5bgE_lXG;L0
01Wo:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgooj^[Zon[ZjP0_on[Z
jP03omWIfOnia]co^LKL017o^LKL00Go^/OMokg:h?o3d>KoamCZonc/k03o
obQL]eKo:5bg000IobQL]`03ogmoOooVi^Koi^KV0<Coi^KV00?oOgmoong]
kOo]kNd0;oo]kNd00ooOgmoo_/_Qokk;h@0=okk;h@03okg:h?nnbn7o_/_Q
00;o_/_Q00Co`LkTolGBj?o`l?3o>FVloolXG;MFobQL]`006OlXG;L00omo
Ogook^k^onk^kP34onk^kP03ogmoOoojn_[on_[j02oon_[j00?oj^[ZolWF
k?o9e^`04oo9e^`00ooalO7oBWK2obQL]`3oobQL]eKo:5bg000IobQL]`03
ogmoOooooooooooo0<Cooooo00?oOgmoooooooooool0;oooool00oo[jn_o
bMK/olWFk00@olWFk004ok[;j?oalO7ok>c/ocUY_?oo:5bgF?lXG;L001Wo
:5bg00?oOgmoonk^k_o^k^h0a?o^k^h00omoOgoohn?Son?Sh`13on?Shooo
:5bgFolXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgooi^KV
onKViP0_onKViP03okJf]_lXG;Oo:5bg0?oo:5bgK?lXG;L001Wo:5bg00?o
Ogmoonk^k_o^k^h0a?o^k^h00omoOgook^k^onk^kP0_onk^kP03okRh^?lX
G;Oo:5bg0?oo:5bgK?lXG;L001Wo:5bg00?oOgmoooooooooool0a?oooolb
ogmoO`03ok^k^olXG;Oo:5bg0?oo:5bgK?lXG;L001Wo:5bg00?oOgmoonk^
k_o^k^h0a?o^k^h09_moOgooh>3Pon7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Q
on7QhOoPh>3ohN7Qon3Ph?oQhN7oh>3Pon7QhOoPh>7ohN7Qon3Ph?oQhN7o
h>3Pon7QhOoPh>3ohN7Qon3PhOoQhN7oa<C4ok2mdon__=;o/;gCojnld_n`
_M?o[kcCok2mdon__=;o/;gCojnld_n`_M?o[kcB0on`_M<00on__=;o/;gC
ok2md`03ojnldP04ok:oeOnga=[o^LKLokfm_Ooo:5bgK_lXG;L001Wo:5bg
00?oOgmoonKVi_oVi^H0a?oVi^H00omoOgoofm_Kom_Kf`0Fom_Kf`03ol;2
`_n/^Loo[;W?00[o[;W?00?oZkS>ojbicon/^Ll01_n/^Ll01?n`_M?o]/?I
ok[7gOo0`<3oobQL]fko:5bg000IobQL]`03ogmoOoo^k^kok^k^0<Cok^k^
00?oOgmoon?ShooShn<01_oShn<00ooKfm_oh^;Ron?Sh`02omkNgP_ohn?S
00?obLW9ok:oeOnb_mD03?nb_mD00onc`=Ko/[oEok?0eP04ok:oe@04okC1
eonhaM_o^lSNol;2`_oo:5bgK_lXG;L001Wo:5bg00?oOgmoooooooooool0
a?ooool09_moOgoom?Cdoo?clonLW9co^;RhooCdm?oclo?om?Ccoj>SXon2
PX;oRXZ:olK6a_n7QhOoYZJVoo?clonLW9co^;RhooCdm?oclo?om?Cdoo?c
loodm?Colo?cooCdlooclo?oeMGEokg:h?nnbn7o_L[Pokk;hOnmb^3o_/_P
okg:h?nnbn7o_L[Pokk;hOnmb^3o_/_Q3?nmb^000oo5aLGo:5bgobQL]`3o
obQL]fco:5bg000IobQL]`03ogmoOoo^k^kok^k^0<Cok^k^02OoOgmoonKV
i_oUiNGoV9RHok6a/OoVi^KoiNGUolk>c_n0P83of=SHom_KfonSXj?oQHF5
onKVi_oUiNGoV9RHok6a/OoVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^Go
iNGUolg=cOnd`MOo]L;HokC1eone`]So]<7GokG2eond`MOo]L;HokC1eone
`]So]<7GokG2f?nd`ML01?ne`]P02?nd`MOo]L;HokG2f?ne`]So]lCJok_8
g_noc>;oalO7oolXG;M^obQL]`006OlXG;L00omoOgooi^KVonKViP34onKV
iP05ogmoOooPh>3oh>3PoiNGUon_[jl00_oPh>001_oAdM7oP820olK6a_oP
h>3o^k^koh^;R`;oh>3P00?oUiNGojn_[ooPh>001ooPh>000oo9bLWo/KkD
ok6ne00Bok6ne005ok:oeOnga=[o^/OMol3=hoo:b/X0oolXG;M^obQL]`00
6OlXG;L00omoOgook^k^onk^kP34onk^kP05ogmoOooXj>Soj>SXoiVIVOnc
/k<00ooXj>P01Oo6a/KoTi>CoiBDU?nEUIGoS8b<00;oj>SX00?oVIVIok>c
/ooXj>P01ooXj>P00oo@d=3o]lCJokO4fP0CokO4fP04ok[7gOnoc>;o`/oU
olc<c?oo:5bgK_lXG;L001Wo:5bg00?oOgmoooooooooool0a?ooool01Omo
OgoonOWiooWinOnMWIgo/K6a00GonOWi00?on?SholG5aOn>SXh00_oinOT0
0onMWIgo/k>cooWin@07ooWin@03omgMgOo3d>Ko`m3V01;o`m3V00Goa=7W
ol?@i_o3d>Ko`m3Volo?c`3oobQL]fko:5bg000IobQL]`03ogmoOoo^k^ko
k^k^0<Cok^k^00goOgmoon_[joo[jn_oVYZJohN7Qonl_;cogmoOon[Zj_o;
bl_ofm_KonWYjOnXZ:SoXZ:R00;ojn_[00CoVYZJohN7Qonj^[[ohN7Q1_o[
jn/00ooDe=Co^/OMok[7g@0Cok[7g@04okc9goo2cnGoa=7Wom7AdOoo:5bg
K_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H09_moOgooi>CTonGU
iOnPX:3o]KFeoj>SXon2PX;og]kOokJf]_nBTY;oQHF5oiFEUOo=cLgoi>CT
onGUiOnPX:3o][Jfoj^[Zon5QHGoi>CTonGUiOoTi>CoiNGUonCTiOoUiNGo
d=3@okK3fOne`]So]/?IokG2f?nf`mWo]L;IokK3fOne`]So]/?IokG2f?nf
`mWo]L;H0_nf`mT00one`]So]/?IokK3f@03okK3f@05okG2f?nkb=ko`<gS
olKCjOoDe=@0oolXG;M^obQL]`006OlXG;L00omoOgook^k^onk^kP34onk^
kP03ogmoOoo]kNgokNg]00?okNg]00Gojn_[ong]kOo]kNgokNg]onc/k007
ong]k@03onc/k?o]kNgokNg]00CokNg]00?of=SHokc9gonlbMl04_nlbMl0
1Onkb=ko_lcRol?@i_o6dnWoe]KF0?oo:5bgK_lXG;L001Wo:5bg00?oOgmo
ooooooooool0a?ooool00omoOgoofMWIoogmo@0Foogmo@03on?Shoo7e>[o
amCZ013oamCZ00?oa]?YolODj_o6dnT00oo7e>X00ooIfMWo:5bgobQL]`3o
obQL]fco:5bg000IobQL]`03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoomWI
fOo^k^h05_o^k^h00ooJf][o_L[Pokg:h00Cokg:h004ol3=hoo4dNOob=G[
om_Kfooo:5bgK_lXG;L001Wo:5bg00?oOgmoonKVi_oVi^H0a?oVi^H00omo
OgooinOWonOWi`0FonOWi`03omGEeOnhaM_o^<GK00co^<GK00?o]lCJokS5
fonhaM/01?nhaM/01?nmb^3o`m3VolSEjooNg]koobQL]fko:5bg000IobQL
]`03ogmoOoo^k^kok^k^0<Cok^k^00?oOgmoonk^k_o^k^h05_o^k^h00ooK
fm_o_L[Pokg:h00Aokg:h006okk;hOnmb^3o`<gSolGBj?o8eN_oh>3PoolX
G;M^obQL]`006OlXG;L00omoOgooooooooooo`34ooooo`0YogmoOooooooo
o_knooooooono_koooooookno_ooookoo_knooooooono_koooooookno_oo
ooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_koooonookn
o_oXj>Sob=G[olWFk?o8eN_obMK/olSEjoo9e^_ob=G[olWFk?o8eN_obMK/
olSEjoo9e^cob=G[olWFk?o8eN/00_o9e^`00oo8eN_obMK/olWFk003olWF
k003ok[;j?oShn?o:5bg0?oo:5bgKOlXG;L001Wo:5bg00?oOgmoonk^k_o^
k^h0a?o^k^h00omoOgookno_ono_k`0Fono_k`03omgMgOnnbn7o_/_Q00[o
_/_Q00Co_L[Pokk;hOnnbn7o_L[P1?nnbn401?o0cN?oaM;XolSEjooalO7o
obQL]foo:5bg000IobQL]`03ogmoOooVi^Koi^KV0<Coi^KV00?oOgmoonSX
j?oXj>P05_oXj>P00ooIfMWo^LKLokW6g00AokW6g005ok[7gOnmb^3o`m3V
olODj_o/k>`0oolXG;M_obQL]`006OlXG;L00omoOgook^k^onk^kP34onk^
kP03ogmoOoo_knookno_01Kokno_00?ogmoOokk;hOnnbn403Onnbn400onm
b^3o_/_Qokk;h@02okk;h@04ol7>i?o5d^Sol?3`ocUY_?oo:5bgKolXG;L0
01Wo:5bg00?oOgmoooooooooool0a?ooool00omoOgooooooooooo`0Foooo
o`03on[Zj_o9e^cobMK/01?obMK/00?olO7aodYf`_lXG;L0oolXG;M_obQL
]`006OlXG;L00omoOgook^k^onk^kP34onk^kP03ogmoOoojn_[on_[j01Ko
n_[j00?ojn_[olWFk?o9e^`04?o9e^`01?njbnSolO7aonc/k?liJKcoobQL
]g7o:5bg000IobQL]`03ogmoOooVi^Koi^KV0<Coi^KV00?oOgmoon?ShooS
hn<0:_oShn?oobQL]gCo:5bg000IobQL]`03ogmoOoo^k^kok^k^0<Cok^k^
00?oOgmoonk^k_o^k^h05_o^k^h00onf][Ko:5bgobQL]`3oobQL]hGo:5bg
000IobQL]`03ogmoOooooooooooo0<Cooooo00?oOgmoooooooooool05_oo
ool00onh^;So:5bgobQL]`3oobQL]hGo:5bg000IobQL]`03ogmoOoo^k^ko
k^k^0<Cok^k^6OmoOgl00onk^k_o:5bgobQL]`3oobQL]hGo:5bg000IobQL
]`03ogmoOooVi^Koi^KV0<Coi^KV00goOgmook2mdon__=;o/;gCojnld_n`
_M?o[kcCok2mdon__=;o/;gCojnld_n`_M?o[kcB00?o/;gC00?o[kcBok2m
don`_M<00on__=801?nb_mGo]lCJokW6g?nm_KgoobQL]hOo:5bg000IobQL
]`03oh61POo^k^kok^k^0<Cok^k^00?oPH61ojbicon/^Ll02_n/^Ll00on[
^<ko[;W?ojbic`06ojbic`04ok2mdonf`mWo^/OMol30`?oo:5bgQolXG;L0
01Wo:5bg00?oQ8B4ooooooooool0a?ooool00on4Q8Co/[oEok:oe@0<ok:o
e@03ok?0e_nb_mGo/l3F00Co/[oE00Co]<7GokS5fonkb=ko`/;2oolXG;N7
obQL]`006OlXG;L00on6QXKok^k^onk^kP34onk^kP0=ohJ6Q_nmb^3o_/_Q
okg:h?nnbn7o_L[Pokk;h?nmb^3o_/_Qokg:h?nnbn7o_L[Pokk;h@0<okg:
h003olG5aOlXG;Oo:5bg0?oo:5bgQOlXG;L001Wo:5bg00?oRHV9onKVi_oV
i^H0a?oVi^H03_n9RHWo]<7GokG2f?nd`MOo]L;HokC1eone`]Oo]<7GokG2
f?nd`MOo]L;HokC1eone`]So]<7G1?ne`]P02?nd`MOo]L;HokG2f?ne`]So
]lCJok_8g_noc>;oalO7oolXG;N7obQL]`006OlXG;L00on;Rh_ok^k^onk^
kP34onk^kP03oh^;Rona_]Co/KkD01;o/KkD00Go/[oEokO4f_njamgo`<gS
ol[:bP3oobQL]hOo:5bg000IobQL]`03ohj>S_oooooooooo0<Cooooo00?o
SXj>okO4f_nga=X04onga=X01?njamgo_lcRol;?iOo<c<coobQL]hOo:5bg
000IobQL]`03oi2@T?o^k^kok^k^0<Cok^k^00?oT92@ol?@i_o3d>H04_o3
d>H01Oo4dNOo`m3Vol?@i_o3d>Koclo?0?oo:5bgQolXG;L001Wo:5bg00?o
Ti>ConKVi_oVi^H0a?oVi^H00onCTi?o^/OMok[7g@0Cok[7g@04okc9goo2
cnGoa=7Wom7AdOoo:5bgQolXG;L001Wo:5bg00?oUIFEonk^k_o^k^h0a?o^
k^h03OnEUIGo]/?IokG2f?nf`mWo]L;HokK3fOne`]Wo]/?IokG2f?nf`mWo
]L;HokK3fOne`]P00_nf`mT00one`]So]/?IokK3f@03okK3f@05okG2f?nk
b=ko`<gSolKCjOoDe=@0oolXG;N7obQL]`006OlXG;L00onHV9Sooooooooo
o`34ooooo`03oiRHV?nlbMoo_<WO01;o_<WO00Go^lSNoko<h_o3d>Koa]?Y
omKFeP3oobQL]hOo:5bg000IobQL]`03oiZJV_o^k^kok^k^0<Cok^k^00?o
VYZJolODj_o7e>X04?o7e>X00oo6dnWoamCZolKCj@03olODjP03omWIfOlX
G;Oo:5bg0?oo:5bgQOlXG;L001Wo:5bg00?oWIfMonKVi_oVi^H0a?oVi^H0
0onMWIgo_L[Pokg:h00Cokg:h004ol3=hoo4dNOob=G[om_Kfooo:5bgQolX
G;L001Wo:5bg00?oWinOonk^k_o^k^h0a?o^k^h00onOWioo^<GKokS5f`0<
okS5f`03okO4f_nhaM_o^<GK00Co^<GK00Co_L[Pol?@i_o8eN_og]kNoolX
G;N7obQL]`006OlXG;L00onRXZ;oooooooooo`34ooooo`03oj:RX_nmb^3o
_L[P017o_L[P00Ko_/_Qokg:h?o0cN?oaM;XolSEjooPh>3oobQL]hOo:5bg
000IobQL]`03ojBTY?o^k^kok^k^0<Cok^k^013oY:BTolSEjoo9e^cob=G[
olWFk?o8eN_obMK[olSEjoo9e^cob=G[olWFk?o8eN_obMK/olSEjoo9e^co
b=G[0_o9e^`00oo8eN_obMK/olWFk003olWFk003ok[;j?oShn?o:5bg0?oo
:5bgQ_lXG;L001Wo:5bg00?oYjNWonKVi_oVi^H0a?oVi^H00onWYjOo_/_Q
okk;h@0:okk;h@04okg:h?nnbn7o_/_Qokg:h0Co_/_Q00Co`<gSolGBj?o8
eN_olO7aoolXG;N8obQL]`006OlXG;L00onYZJWok^k^onk^kP34onk^kP03
ojVYZOnia]co^LKL017o^LKL00Go^/OMokg:h?o3d>KoamCZonc/k03oobQL
]hSo:5bg000IobQL]`03ojb/[?oooooooooo0<Cooooo00?o[:b/okk;hOnn
bn403Onnbn400onmb^3o_/_Qokk;h@02okk;h@04ol7>i?o5d^Sol?3`ocUY
_?oo:5bgR?lXG;L001Wo:5bg00?o[Zj^onk^k_o^k^h0a?o^k^h00on^[Zko
bMK/olWFk00ColWFk003oo7alOm:M/;o:5bg0?oo:5bgR?lXG;L001Wo:5bg
00?o/K6aonKVi_oVi^H0a?oVi^H00ona/K7obMK/olWFk00@olWFk004ok[;
j?oalO7ok>c/ocUY_?oo:5bgR_lXG;L001Wo:5bg00?o/k>conk^k_o^k^h0
a?o^k^h00onc/k?ohn?Son?Sh`0Aon?Shooo:5bgSOlXG;L001Wo:5bg00?o
][Jfooooooooool0a?ooool00onf][Ko:5bgobQL]`3oobQL]iko:5bg000I
obQL]`03okRh^?o^k^kok^k^0<Cok^k^00?o^;RhobQL]olXG;L0oolXG;NN
obQL]`006OlXG;L00onk^k_oOgmoogmoO`34ogmoO`03ok^k^olXG;Oo:5bg
0?oo:5bgW_lXG;L001Wo:5bg00Go_Kfmon_[jooVi^Koh^;RomkNgP04omgM
g@?og]kN0:oogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMko
g]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oM
gMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkN
g_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgM
omkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]ko
gMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oN
g]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgM
gOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kN
omgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgo
g]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oM
gMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkN
g_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgM
omkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]ko
gMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoN
g]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgM
gOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgM00?og]kN00?ogMgM
omkNg_oNg]h00ooMgMd01?oQhN7oinOWon[Zj_nm_KgoobQL]j3o:5bg000I
obQL]`04ol30`?o/k>coi^KVon3Ph0OofMWI00Cof=SHomKFe_oCdm?od=3@
0oo=cLd01?o@d=3odm?ComOGeooHf=P;omWIf@04omSHf?oGemOodm?Com3@
d0?ocLg=00Cod=3@om?CdooGemOof=SH2ooIfMT01?oHf=SoemOGom?Cdoo@
d=03olg=c@04om3@d?oCdm?oemOGomSHf7WofMWI00?of=SHomWIfOoIfMT0
1_oIfMT01?oNg]koi^KVonc/k?o0`<3oobQL]j3o:5bg000IobQL]`08ol;2
`_o^k^kojNWYonCTi?oPh>3ohN7Qon3Ph?oRh^82on7Qh@0=omkNg_oLg=co
dm?ColO7aonk^k_o/[:bojj^[_nb/[;o^k^kolO7aooCdm?ofm_KomoOg`09
on7Qh@0=omoOgooKfm_odm?ColO7aonk^k_o/[:bojj^[_nb/[;o^k^kolO7
aooCdm?ofm_KomoOg`09on7Qh@0=omoOgooKfm_odm?ColO7aonk^k_o/[:b
ojj^[_nb/[;o^k^kolO7aooCdm?ofm_KomoOg`0Xon7Qh@03ol[:b_oOgmoo
hN7Q00;ohN7Q00?oemOGolc<c?oQhN404?oQhN400oo@d=3ogmoOon7Qh@02
omOGeaKohN7Q00?od=3@omoOgooQhN400_oGemLJon7Qh@03on;Rh_oQhN7o
h^;R00CohN7Q00Coi>CTonWYjOo]kNgo`/;2oolXG;NPobQL]`006OlXG;L0
1?o5aLGol?3`ono_kooalO43oo3`l02lono_koo`l?3ok^k^onWYjOoKfm_o
`L71ojBTY?n<S8coNg]kogMgMomkNg_oS8b<ojBTY?o2`/7of][Jon[Zj_o]
kNgolO7aono_kooalO7okno_oo7akoo_knoolO7aong]kOoZj^[of][Jol;2
`_nTY:CoS8b;og]kNomgMgOoNg]kohb<S?nTY:Co`/;2om[Jf_oZj^SokNg]
oo7alOo_knoolO7aono_kooalO7okno_oo7akoo]kNgoj^[Zom[Jf_o2`/;o
Y:BTohb<S?mkNg_oMgMfog]kNon<S8coY:BTol;2`_oJf][oj^[Zong]kOoa
lNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_
kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7a
ono_kooalNoo<30`ofm_Koo_knoolO7aoc/k>omhN7Sokno_oo7akonHV9So
6QXJono_kooalO7oaLG5ob8R8_lL71co[jn^ono_kooJf][oADE5o`820_lP
823o5ADEokBd]?oalNoo>c/kogQhN?o_knoolO7aono_koll?3coMgMgoo7a
koo_knooVYZJoaXJ6_oalO7okno_oda<C?l71`Oo61PHoi:BT_lA4A7oDE5A
oo7alOlk>c_oN7Qhono_kooalNookno_oo7alOo_knoolO7aoc8b<_m]KFgo
kno_oo7akoo_knoolO7aono_koll?3coMgMgoo7alOo_knoolO7_od];Bol7
1`Oo61PHoi>CTolA4A7oDU9Bono_koll?3_oMgMgoo7alOo_knoolO7aono_
kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_
ono_kooalO7okno_oo7alOo_knoolO7aoo3`l?o_knool?3`ono_koo`l?3o
kno_oo3`l?o_knl4oo3`l003olG5aOlXG;Oo:5bg0?oo:5bgW_lXG;L001Wo
:5bg00CoalO7oo;bl_o^k^koinOW1?oUiND04?oTi>CogmoOom7AdOna/K7o
RXZ:ofIVI_mADE7oADE5od92@_m5ADGoDE5AofIVI_n:RXWo/K6aom7AdOoN
g]h2onCTi003onGUiOoTi>CoiNGT00;oi>CT00oog]kNom7AdOna/K7oRXZ:
ofIVI_mADE7oADE5od92@_m5ADGoDE5AofIVI_n:RX[o/K6aom7Ad?oNg]h0
0_oTi>@0S?oUiNGoi>CTonGUiOoTi>Coi>CSomkNg_oAdM7o/K6aohZ:R_mV
IVKoDE5AodE5AOm2@T;oADE5oe5ADOmVIVKoRXZ:ok6a/OoAdM7og]kNonCT
hooTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGo
i>CTonGUi?l^;RkoJFUYonCTi?oUiNGo>CTiog9bL_oTi>CoiNGToi6ATOlI
6AWoi>CTonGUiOmUIFGo>SXjon?ShooUiNCoi>CTocdm?Oli>CWob<S8onCT
i?oJf][of=SHonGUi?li>CWoLW9bonCTi?oUiNGoi>CTocTi>OmaLG7oiNGT
onCTi?nBTY;o6ATIonGUiOna/K7o0`<3olG5aOo>c/goDE5Ao`l?3ooTi>Co
iNGUocTi>OmbLW;oi>CTonGUi?oTi>CoiNGUonCTi?oUiNGo<30`ofQXJ?oT
i>CoiNGTonCTi?oUiNGoi>CTocTi>OmaLG7oiNGUonCTi?na/K7o0`<3olK6
a_o=cLgoDE5Ao`l?3ooUiNGoi>CTocTi>OmaLG7oiNGUonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCo
i>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CT1?oUiND02?oTi>CoiNGUonGU
iOoUiNGoj>SXong]kOobl_;oalO7oolXG;NPobQL]`006OlXG;L01?o:b/[o
m?Cdong]kOoWinL2on3Ph00Con7QhOoOgmoog]kNom;Bd_nd];CoQhN7oeaL
G?m]>cGoWTi2ole_GooYPfoocFmOoii>@om]>cKoG5aLohN7Qond];Cod];B
omkNgP05on3Ph00AomkNg_oBd];o];BdohN7QomLG5coKF0/oijF;_o=cCoo
jNU=olg=?onNVRooKF<]oeaLG?n7QhOo];Bdom;Bd_oNg]h01OoPh>004OoN
g]kod];BokBd]?n7QhOoG5aLodMW;_mXWS?oTLe7oj[YEOnAcDOoJYhdodUZ
;omLG5coQhN7okBd]?oBd];og]kN00Ooh>3P00?oooooohR8R?m4A4@01_m4
A4@00olc<c?oA4A4odA4A003odA4A004oiVIVOoPh>3o;Bd]ofMWI`;oh>3P
00Ko>3Phofm_KooPh>3oh>3Pohn?SolH61P2on3Ph007od=3@omTI6Coh>3P
on3Ph?o2`/;o0000oj6QX@05on3Ph003ocPh>?m_Kfooh>3P00;oh>3P00go
>3Phofm_KooPh>3oh>3Pohn?SolH61Soh>3Pokjn__l20P;oYZJVon3Ph?n;
Rh_o71`L00;oh>3P00?o>3Phofm_KooPh>001OoPh>000ol_;booIFEUon3P
h004on3Ph00:ocPh>?m_Kfooh>3Pon3Ph?nn_[ko0P82ojJVY_oPh>3oRh^;
oa`L70;oh>3P00?o>3Phofm_KooPh>005?oPh>000ooOgmooh>3PomoOg`02
omoOg`?oh>3P00GohN7QonOWioo/k>com?Cdol[:bP3oobQL]j3o:5bg000I
obQL]`04olc<c?ofm_Kol_;bon_[j`?oj>SX01?oinOWon;Rh_o=cLgoWinO
of]OGon?=RkokG5QooVMT?om/JGooKb_oofdYooiWi?okGASoi8g;om[Geoo
WinOolg=cOoRh^;oinOW00?oj>SX01?oinOWon;Rh_o=cLgoWinOofiVGonC
LR;okM54ooWcM?omoHgooOfEoogmS_oin7KokMM7oi=c8_m^IeooWinOolg=
cOoRh^;oinOW00?oj>SX01?oinOWon;Rh_o=cLgoWinOof1XGom;O2?oT^5;
okgiNoo@oI;of?fKomCmUOo0nGkoV>Q=odf09?mPJEooWinOolg=cOoRh^;o
inOW00Koj>SX00?oooooodA4A?mVIVH00omgMgL00omVIVKoMgMgogMgM`05
ogMgM`05oc<c<oo<c<coj>SXobl_;om[Jf/00_oXj>P01_lj>S[oLg=conSX
j?oXj>SoU9BDoaTI6@;oj>SX00OoATI6ofMWIooXj>Soj>SXojb/[?l0003o
=cLg00?o>CTi00Co/[:bonSXj?lj>S[oLg=c0ooXj>P01_lj>S[oLg=conSX
j?oXj>SoU9BDoaTI6@;oj>SX00GoWIfMobd];Ol^;Rko<C4aoadM7@02onSX
j003ocXj>_mcLg?oj>SX00Goj>SX00?o<C4aofUYJOoXj>P01?oXj>P00olj
>S[oLg=conSXj002onSXj005oifMWOl];Bgo;Rh^oc4a<OlM7Ad00_oXj>P0
0olj>S[oLg=conSXj00MonSXj004onc/k?obl_;om_Kfolc<c?oo:5bgX?lX
G;L001Wo:5bg00?oclo?ooOgmoohn?P01?ohn?P04oogmoOok^k^olk>c_n@
T93oQBl[onUTE_okTXOooZJKoojaYOoo^:_oo[>VoojXW?okU8WokVQIohTa
:on@T93oc/k>onk^k_ogmoL00oohn?P04oogmoOok^k^olk>c_n@T93oVFT[
oo2m?Ookh6koo_B2ooknR_oooi;oo_j<ookhPookiG3ol<8noiUZ:on@T93o
c/k>onk^k_ogmoL00oohn?P04oogmoOok^k^olk>c_n@T93o@W<[ohC>@on]
kg?o`_j8olknT?oFoiOod?jBolKnROnbmGCoR==3odAe:on@T93oc/k>onk^
k_ogmoL01_ohn?P03?oooooo<c<conk^k_o^k^ko^k^kogMgMonZZZ[ooooo
onk^k_oMgMgoMgMgomgMg@;ok^k^00GoMgMgolc<c?ohn?So<S8bog9bLP02
ooShn006ochn?_mJFU[on?ShooShn?nHV9So71`L0_ohn?P03_m:BT[oKVi^
ooShn?ohn?Soe=CDo`000?nVYZKobLW9ol71`Ol20P;og]kNooShn?ln?Sko
IVIV0oohn?P01_ln?SkoFUYJooShn?ohn?SoV9RHoa`L70Con?Sh00?om_Kf
ohn?SolP82000_ohn?P00oln?SkoNg]kooShn005ooShn005oc@d=?lM7Ago
@T92od92@_mPH6000_ohn?P00oln?SkoIVIVooShn004ooShn003ooKfm_n?
Shoo820P00;on?Sh00?o?ShnofYZJ_ohn?P05_ohn?P00oogmoOon?ShooSh
n002ooShn006ooOgmooinOWomoOgooOgmoohn?Soclo?oolXG;NPobQL]`00
6OlXG;L01?oAdM7on_[jooGemOo^k^h2onc/k01<on_[jooYjNWogmoOokZj
^_miDU;o_c8TonMdJOomRGkooiR<oojRU_ooZ9cooZBHoonJSOonRWookWIZ
ol<c9?miDU;o^[ZjomoOgooZj^[ojn_[onc/k?o[jncoj^[ZomoOgonj^[[o
R6EBon:A7?oi`e3ooMYSoooZL_onlgkoooZ2ookfOoook7?oo]iToo[7DOoR
TQcoRFICokZj^_oOgmooj^[Zon_[joo/k>cojn_[on[Zj_oOgmoo^[Zjoe9]
D_mAXacoTM9EojKWJ_nhnG[o`?j2olOoROo3oXCo^OekojO/K?nDeUOoDZHL
oe9]D_nj^[[ogmoOon[Zj_o[jn_ok>c/on_[joo/k>cojn_[onc/k?oooooo
<c<cooooooo^k^koMgMgo`0cc0;o<c<006KoA4A4oc<0<ol002;oIP1VogMg
MoooooooMgMgok^k^oo[jnco<30`ofa/K?o/k>cojn_[oc/k>olB4Q;oKFe]
olc<cOm@D53oATI6onc/k?oUiNGo@d=3ofATI?oQhN7oinOXonc/k?lj>S[o
Hf=Son?ShonBTY;o9bLWonc/k?o[jnco>c/koa4A4On6QXKod];Bon[Zj_lj
>S[o4Q8Bofa/KOo=cLgoD51@odM7Aoo[jn_ok>c/ojFUYOo9bLWoj>SYoeUI
FOm=CDgok>c/on_[jolk>c_oMGEeonc/k?o[jncok>c/on_[joo/k>cojn_[
oc4a<Om@D53o/K6aok2`/Onj^[[ojn_[onc/k?lj>S[o4A4AohF5QOoCdm?o
jNWZojJVY_o8b<SojNWYoeUIFOm=CDgojn_[onc/k?lj>S_o4a<Coh61POoF
e]Kojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[
joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>`7on_[j`07onc/k?o[jn_o
jn_[onk^k_ofm_KonOWiom7Ad@3oobQL]j3o:5bg000IobQL]`04omCDe?ok
no_olo?cong]k@;oiNGU04Soi^KVonCTi?oIfMWo/[:bogT^;_o8@SCohfYL
ooAjKOomR7cooYN:oojKS_onV8_ooXYnooAkKOoWJegobT8dog/^;_nb/[;o
f=SHonCTi?oUiNGoi^KVonGUi_oTi>Cof=SHok:b/_nFEBkojY`[oo^lA?on
c5?ooMQRookSL_onjGGoo^IcookKIOomc5?onl55onjN:onIERko/[:bomSH
f?oTi>CoiNGUonKVi_oUiNGoi>CTomSHfOnb/[;o;V8^of>]:on7bTSoUmaI
ojGUJOnblgOo^?IkokCeNOnWjV_oV=aIohW?BomS[R_o;V<^ok:b/_oHf=Wo
i>CTonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVoooooomgMgL2onk^kP1[ofIV
I_l0I_oo06K<odA4A?lc03?o<c<cogMgMolc03?oR8R8onk^k_mVIVKoc<c<
onGUi_l^;RkoJFUYonKVi_oUiNGoBd];ogemOOm]KFgo4A4BobTY:On`/;3o
i^KVog9bL_l71`Oo2PX:oaPH6?nLW9coi^KVolk>c_m0@43o2`/;oaTI6OnT
Y:Coi^KVonGUi_m;Bd_oNg]koe=CDol820Sof=SHod];BomnOWkoK6a]oa8B
4_lY:BWo/;2`onGUiOoVi^KoNg]kobd];Ol>3Pko<c<cok2`/?oVi^KoiNGU
ocTi>OmbLW;oi^KVonGUi_oVi^KoiNGUonKVi_oUiNGo<30`ofQXJ?oVi^Ko
iNGVonKVi_oUiNGoi^KVod];BomkNg_oDe=Co`P82?oGemSoO7alob`/;?l>
3Pko<c<cok2`/?oUiNGoi^KVod];BommOGgoIFEUo`h>3_oUiNGoi^KVonGU
iOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KV
onGUiOoVi^KoiNGUonKVi_oUiND00_oVi^H00ooUiNGoi^KVonKViP03onKV
iP05onGUiOo]kNgom?Cdoo_knooDe=@0oolXG;NPobQL]`006OlXG;L01?oF
e]Koo?clooShn?oalO43onk^kP0Con_[jooQhN7o_;blogXG5oo3?c;odeI9
onAXF_o_Mfcom8=iooR7O?oeQ7[olgU]onEYFooIF4[oa3lbog`G5onl_;co
hN7Qonc/k003onk^kP0Conc/k?oQhN7o_;blojE75ooVUc;omJ``oofl@Oom
bE?ooM1Poo_CIOomdV3oo/eDoofm@_oj[c;ojI/bojE65onl_;cohN7Qonc/
k003onk^kP0Conc/k?oQhN7o_;bloaMI5omOZ3;oM[dgohK=AonFeU[oX^1U
oj?PJOnShFOoUmYLohK>Aomg_cOoGj/boaMI5onl_;cohN7Qonc/k006onk^
kP05oooooolc<c?ok^k^omgMgOlA4A400_l0I_l03?lcI/co8R8RohR8R?nI
VIWo8R8RomgMgOo^k^koMgMgolc<c?o^k^ko<30`ofi^KPGok^k^00?okNg]
onk^k_o^k^h00_o^k^h00om7AdOoJVYZonk^kP04onk^kP03on_[joo^k^ko
k^k^00Gok^k^00?ojn_[onk^k_o^k^h00_o^k^h00oo]kNgok^k^onk^kP04
onk^kP03onc/k?o^k^kok^k^00;ok^k^00?o>c/kogIfM_o^k^h01Oo^k^h0
0olb<S;oK6a/onk^kP07onk^kP05on_[joo^k^kok^k^onk^k_o/k>`01oo^
k^h00oo]kNgok^k^onk^kP0Ionk^kP05ong]kOobl_;on?Shooclo?oFe]H0
oolXG;NPobQL]`006OlXG;L01OoIfMWooOgmoogmoOomoOgoo?cl00;ooOgm
01?oo?cloo?clooAdM7oJ0L7okPd=?o7?c?odU13omYREOoSKV;oi79TonA_
H_oLI5Oode53ola1=?ni=3CoJ`L7om;Bd_oclo?oo?cl00?ooOgm01?oo?cl
oo?clooBd];oWR/7omZ:=?o[VaWomJPYooRd?ooi_D[on;m=ooZoB_oi^3oo
mZXZonnN6OoKRcCoXRd7om;Bd_oclo?oo?cl00?ooOgm01?oo?cloo?clooB
d];o1d07odfJ=?mOZb3oL;P_ogo3@on:cE3oSLeBoh[>D?n1adCoLKT_of:^
8?m>VcCo1d87om;Bd_oclo?oo?cl00KooOgm00Kooooooc<c<oo^k^ko<c<c
oc<0<ol00142ob8R8P0;o`0c<olc03?o4@00o`000?lc<c?o^k^kogMgMonk
^k_ooOgmoc<c<omeMGD02_omoOd00ooNg]kog=cLoogmo@0Moogmo@03oclo
?omnOWkooOgm00GooOgm00?o=CDeobd];OmTI6@00_mTI6@00onf][KooOgm
oogmo@0Xoogmo@03ooclo?omoOgoo?cl00?ooOgm00?ofMWIobQL]olXG;L0
oolXG;NNobQL]`006OlXG;L0>ooKfm_ooOgmoo[jn_oclo?ok^k^oo3`l?o_
knook^k^onWYjOoCdm?oFadMoj8d=?nd:1go`CX]olM9??o?ET[od5M;om1G
B_o:BSko`c/^okHX7OnR=3CoG1dMom?CdooZj^[ok^k^oo3`l?o_knool?3_
onk^k_oZj^[odm?Coh`U7Oo8LCCofH@MonBD5OoWWBCokZPcoo2Z=?o_ZS?o
k:0UonNG5OoLR1gob74doh`U7OoCdm?oj^[Zonk^k_o`l?3okno_oo3`l?o^
k^koj^[Yom?CdolM>1go=88dodNE7OmJYA_oJJdZ00;oM;Ph017oMKThof^a
:omKYacoB9XMocB2=?lM>1godm?Con[ZjOo^k^kol?3`ono_koo`l?3okno_
oo3`l?o_knooooooogMgM`02ofHcIP12ogMgMon8R8SoIVIVoc<c0?l0<lco
06K<oc<0I_l0003oIS=Voc<c<omgMgOoc<c<oo3`konTY:Co_Kfmono_koo`
l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_
koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`
ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knoo
l?3`ono_koo`l>ookno_oo3`l?o_knool?3`oc/k>omgMgOokno_oo3`koo_
knool?3`ono_koo`l?3oY:BT1?n@T9009_o4a<Cokno_oo3`l?o_knool?3`
ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knoo
l?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_
knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_0_o`
l?06ono_k`04oo?clooinOWoo_knom_Kfooo:5bgX?lXG;L001Wo:5bg00Co
g]kNookno_ogmoOol?3`1?oYjNT04OoWinOofm_Kof=;Bon1<S;oYSDeokHd
;Oo2CD7o`eA9olAEB_o3E4Wo`Te1okHd;OnU=CGoPC8bof=;BooKfm_oinOW
00GojNWY017oinOWom_Kfon9Bd_o[d/boleg=OoFRbgoh9`^on2P<_oQX3Co
h:0bomnJ;_oFRbgobWDeojm;<_n9Bd_ofm_KonOWi`05onWYj@0AonOWiooK
fm_oBd];oc9P<_ljRCGoDi/]of^[;om`[CSoKjhjog2]>?mZZRooDi/]ocV8
=OlbH3;oBd];om_KfooWinL01ooYjNT02OooooooA4A4oc<0<oo<0<coIS=V
ofIVI_lA003oVFH0olbI0002o`1Vc0;oV@2I00?o^k^kogMgMoo<c<`0;OoY
jNT00ooUiNGoinOWonWYj@0aonWYj@03onSXj?oYjNWojNWY00CojNWY00Co
l?3`ooOgmoono_kog]kNoolXG;NPobQL]`006OlXG;L01_oPh>3oo_knoo[j
n_odm?Cokno_oo7al@;ol?3`017okno_on_[jonEU9CoCb<SoiEDE?nkLg?o
diFEomZLW?oJWYcofIbLomBEUOnkLg?oUEADodlS8onEU9Coj^[Zono_k`05
oo3`l00Aono_kooZj^[oZIBDoh4S8onjJUCoe9YconBlUOoZaicojLNLon[7
W?oU_9Goe9Ycok]ZE?n18b?oZYBDon[Zj_o_knl01Oo`l?004Oo_knooj^[Z
oiBDU?lS:R?oE7YDog>ULonNaYGo[<jLojg>W?n/cYcoW/JEog>ULomDNUCo
8bXSoiBDU?oZj^[okno_00Ool?3`00Cooooooc<c<oo<c<coA4A40_l00000
2_lc03?oIVH0ooo<0?nIIP3oIP1Vol`0oomV06KoIS=VogMgMonk^k]Voo3`
l006oo7alOo`l?3om?Cdoo[jn_ono_koh>3PoolXG;NPobQL]`006OlXG;L0
1OoShn?ojo3hooooooooooooo_kn00;ooooo0_ono_h0AOomoOgon?Shofi^
K_mJ?coo/I2@omk9bOo`i>ColnKVoo3Ti?oNbLWo/I2@oeXo?om]KFgon?Sh
ooclo?ooooooo_knooooooono_koooonookno_ooooooo?clooShn?n=KFgo
RSloolVAT?oYd<Wom>WTooK[i_odjNCojM39olVAT?n9?cooSFe]ooShmool
o?coooooookno_ooooooo_knooooooono_koooonooclo?ohn?SoKFe]oclo
?on@WI3obMG9onC/i?oVk^Koi>cTolWEbOn@WI3o?cloofe]KOohn?Soo?cl
ooooo_ono_koooooookno_ooooooo_knooooooono_koooooogMgM`02onk^
kP03ob8R8_nI09WoIS=V00;oIP1V06Wo<`0coiUV0?lA4A7oc<c<onk^k_mg
MgOoc<c<ooooo_ono_koooooookno_ooooooo_knooooooono_koooonookn
o_ooooooo_knooooooono_koooooookno_ooookoo_knooooooono_kooooo
ookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knooooooono_ko
ooonookno_ooooooo_knooooooono_koooooookno_ooookoo_knooooooon
o_koooooookno_ooooooo_knooooo_ono_koooooookno_ooooooo_knoooo
ooono_koooonookno_ooooooo_knooooooono_koooooookno_ooookoo_kn
ooooooono_koooooookno_ooooooo_knooooo_ono_koooooookno_oooooo
o_knooooooono_koooonookno_ooooooo_knooooooono_koooooookno_oo
ookoo_knooooooono_koooooookno_ooooooo_knooooooono_h00_ooool0
0oono_koooooooooo`03ooooo`03on_`n?oShn?o:5bg0?oo:5bgWolXG;L0
01[o:5bg00Com_Kfookno_ojn_[om?Cd1OoalO403Oo_knooe]KFof][Jom3
?CgoVhb<olJj^_oFc<coakZjoi^<S?m3?CgoJf][omKFe_o_knl02OoalO40
3Oo_knooemKFoh=[Jomd?Cgo]Hb<omFj^_oQc<coe[ZjokJ<S?mb?CgoPF][
omOFe_o_knl02OoalO403Oo_knooe]KFof][Jolm?CgoS8b<okZj^_o<cLco
^[Zjohb<S?lm?CgoJf][omKFe_o_knl02OoalO401_ooooooA4A4onk^k_nI
VIWo4A4AodA4A0;oc03<00CoV@2Io`0cI_o<V@3oMgMg0_o^k^h00omgMgOo
c<c<oo7al@1Noo7al@04oo3`l?oalO7olO7aoo3`l0ColO7a00Com?Cdoo[j
n_ono_kom_KfoolXG;NQobQL]`006_lXG;L01Oo^k^kooOgmooShn?o`l?3o
jn_[00?oj^[Z00gojNWYon[Zj_oYjNWoj>SXoi^KVomIFEWo9RHVo`T92OlV
9RKoFEUIoi^KVooXj>SojNWY00_oj^[Z00_ojNWYonSXj?nPVi_oJUUIod<V
9_l]2@Wo@RHVofUIFOnPVi_oj>SXonWYj@0;on[ZjP0;onWYjOoXj>SoVi^K
oeUIFOlV9RKo2@T9obHV9_mIFEWoVi^KonSXj?oYjNT02_oZj^X02Ooooooo
<c<conk^k_mgMgOo<c<cofIVI_lc<c?oc03<odA4A002o`0cIP05ogMgMoo^
k^kok^k^ogMgMonk^k/0I_oZj^X01Oo[jn_ol?3`ooShn?omoOgok^k^0?oo
:5bgXOlXG;L001[o:5bg00Co?ffnooCdm?ojn_[om?Cd2?oalO42oo3`l0?o
kno_0_o`l?0?oo7al@;ol?3`0oo_knl2oo3`l0oolO7a0_o`l?03ono_k`;o
l?3`3?oalO400oooooooMgMgonk^kP03onk^kP06ok^k^omV<fKoooooonk^
k_nIVIWoR8R80_o^k^h00omgMgOoc<c<oo7al@1Qoo7al@03oo3`l?oalO7o
lO7a00;olO7a00ComOGeoo[jn_odm?Co?ffnoolXG;NQobQL]`006olXG;L0
0omFOlKomOGeooooo`18ooooo`03oc<c<oooooook^k^00[ok^k^00?oMgMg
olc<c?ooool0Ioooool00ooemOGoEWo6obQL]`3oobQL]j7o:5bg000LobQL
]`04ocm]__o^k^kom_Kfon_`n4Kooooo00?o<c<cogMgMomgMgL02omgMgMV
ooooo`04on_`n?ofm_Kok^k^ocm]__oo:5bgXolXG;L001oo:5bg_?oShn?o
obQL]jKo:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00
oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2
obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bg
oolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L0
0?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bg
P_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL
]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg
003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL
]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolX
G;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL
]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolX
G;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo
:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lX
G;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003oobQL]ooo
:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o:5bg003o
obQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;OoobQL]h;o
:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00oolXG;Oo
obQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2obQL]`00
oolXG;OoobQL]h;o:5bg003oobQL]ooo:5bgP_lXG;L00?oo:5bgoolXG;N2
obQL]`00oomoOgmGogmoO`OoOWinoomoOglTogmoO`0000Cojn_[onKVi_oR
h^;og]kN0ooMgMd0oooLg=cog]kNomkNg_oNg]kogMgMomkNg_oMgMgog]kN
omgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgo
g]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oM
gMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkN
g_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgN
omkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]ko
gMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoN
g]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgM
gOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kN
omgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMko
g]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oM
gMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkN
g_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgM
omkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]ko
gMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oN
g]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgM
gOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kN
omgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgo
g]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oM
gMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkN
g_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgM
omkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]ko
gMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMg@00
6_oNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kN
omgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMko
g]kNomcLg?oMgMgofm_K0_oLg=`0<ooMgMgogMgNomkNg_oMgMgog]kNomgM
gOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kN
omgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgo
g]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oM
gMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkN
gP02omcLg005omWIfOoHf=SoemOGomSHf?oIfMX00_oLg=`0oooNg]kogMgM
omkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]ko
g=cMomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoN
g]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgM
gOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kN
omgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgo
g]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oM
gMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkN
g_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgM
omkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]ko
gMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoN
g]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgM
g_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oMgMgog]kN
omgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgo
g]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgNomkNg_oM
gMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]kogMgMomkN
g_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgN
omkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgMgOoNg]ko
gMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kNomgMgOoN
g]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMkog]kNomgM
gOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oMgMgog]kN
omgMgOoNg]kogMgNomkNg_oMgMgog]kNomgMgOoNg]kogMgMomkNg_oMgMko
g]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]kogMgMomkNg_oM
gMgog]kNomgMgOoNg]kogMgNomkNgP005ooMgMgog]kNomgMgOoNg]kogMgM
omkNg_oMgMkog]kNomgMgOoNg]kogMgMomkNg_oMgMgog]kNomgMg_oNg]ko
gMgMomkNg_oMgMgog]kNomgMgOoNg]kogMgN00?og]kN00?ogMgMomkNg_oN
g]h00ooMgMd1on7Qh@7oinOW0OoZj^X00003onc/k?oVi^Koh>3P00?ofMWI
00Sof=SHomWIfOoIfMWofMWIomSHf?oFe]Kodm?Com3@d0?ocLg=00Cod=3@
om?CdooGemOof=SH2ooIfMT01?oHf=SoemOGom?Cdoo@d=03olg=c@04om3@
d?oCdm?oemOGomSHf0_ofMWI00Cof=SHomOGeooCdm?od=3@0oo=cLd01?o@
d=3odm?ComOGeooHf=SKomWIf@;of=SH00Koe]KFom?CdooCdm?oe=CDomOG
eooHf=P2omWIf@03omSHf?oIfMWofMWI00;of=SH2OoIfMT00ooHf=SofMWI
omWIf@02omSHf003omWIfOoHf=Sof=SH00;of=SH5ooIfMT01?oHf=Soe]KF
om;Bd_o?cll2olg=c@04olo?cooCdm?oemOGomSHf0_ofMWI00?of=SHomWI
fOoIfMT0oooIfMT8omWIf@03omSHf?oIfMWofMWI00KofMWI0OoNg]h1onKV
iP7ok>c/00001oo^k^kojNWYonCTi?oPh>3ohN7Qon3Ph?oRh^800_oQhN40
3OoNg]kog=cLom?Cdoo7alOo^k^kok:b/_n^[Zko/[:bok^k^oo7alOodm?C
om_KfooOgml02OoQhN403OoOgmoofm_Kom?Cdoo7alOo^k^kok:b/_n^[Zko
/[:bok^k^oo7alOodm?Com_KfooOgml02OoQhN403OoOgmoofm_Kom?Cdoo7
alOo^k^kok:b/_n^[Zko/[:bok^k^oo7alOodm?Com_KfooOgml0f_oQhN40
2OoPh>3ogmoOom_KfooFe]Koe=CDomKFe_oJf][og]kNon3Ph006omoOg`?o
h>3P00?ogmoOon3Ph?oPh>000_oPh>08omoOg`;og]kN0_oOgml3on3Ph0;o
gmoO0_oPh>02omoOg`goh>3P00GogmoOomgMgOoIfMWoeMGEom?Cd`02om;B
dP03omKFe_oLg=coh>3P0?oohN7Q6?oQhN400ooRh^;ohN7Qon;RhP04on7Q
h@7oi>CT0OoYjNT1ong]k@0000?ol?3`ono_kooalO400_o`l?02ono_k`3o
oo3`l?o^k^koj>SXom_Kfoo1`L7oY:BTohb<S?mkNg_oMgMgog]kNon<S8co
Y:BTol;2`OoJf][oj^[Zong]kOoalO7okno_oo7alOo_knoolO7_ono_kooa
lO7okNg]on[Zj_oJf][o`/;2ojBTY?n<S8_oNg]kogMgMomkNg_oS8b<ojBT
Y?o2`/;of][Jon[Zj?o]kNgolO7aono_kooalO7okno_oo7alOo_knoolO7_
ong]kOoZj^[of][Jol;2`_nTY:CoS8b<og]kNomgMgKoNg]kohb<S?nTY:Co
`/;2om[Jf_oZj^[okNg]oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_
knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7a
lOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_
oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNoo
kno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooa
lO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_
kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7a
ono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoo
lO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_
knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7a
lOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_
oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7o
kno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooa
lO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_
kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7a
ono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoo
lO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_
knoolO7aono_kooalO7okno_oo7akoo_knoolO7a000Jono_kooalO7okno_
oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNoo
kno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo^k^kokno_on[Zj_oW
inL2on3Ph007on?Shoo[jnWojn_[on[Zj_oVi^Koj>SXonOWi`02onWYj@0B
onk^k?o/k>cok>c/onSXj?o/k>cokNg]oo3`l?o/k>coj^[XonKVi_oXj>So
inOWonWYjOoXj>Sojn_[onOWiooWinGoiNGU0_oYjNT03oo^k^kokNg]ong]
kOoXj>Sojn_Yonc/k?o^k^kojNWYon[Zj_o[jn_okno_onc/k?o/k>[oj^[Z
onk^kP02onc/k03oon[Zj_o_knook>c/onc/j_oZj^[ok^k^onc/k?n_[joo
MWIfoeUIFOm^KVko]kNfon3Ph?oYjNWokNg]oo7alOo_knoolO7aono_kooa
lNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_
kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7a
ono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoo
lO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_
knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7a
koo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_
oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7o
kno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooa
lO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_
kooalO7ok^k^oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_
ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoo
lO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_
knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7a
lOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooalO7okno_
oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_kooalNoo
kno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7aono_kooa
lO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoolO7aono_
kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_knoolO7a
ono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_oo7alOo_knoo
lO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7okno_oo7akoo_
knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooalO7okno_000]
oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_kooalO7o
kno_oo7akoo_knoolO7aono_kooalO7okno_oo7alOo_knoolO7_ono_kooa
lO7okno_oo7alOo_knoolO7aono_kooalNookno_oo7alOo_knoolO7aono_
kooalO7okno_oo7akoo`l?3okno_oo3`l?o_knool?3`ono_koo`l?3okno_
00Col?3`00000oobl_;ok^k^onOWi`04onGUi@0@onCTi?oOgmoodM7Aok6a
/On:RX[oIFEUoe5ADOm5ADGo@T92odE5AOmADE7oIVIVohZ:ROna/K7odM7A
omkNgP;oi>CT00?oiNGUonCTi?oUiN@00_oTi>@03ooNg]kodM7Aok6a/On:
RX[oIVIVoe5ADOm5ADGo@T92odE5AOmADE7oIVIVohZ:R_na/K7odM7@omkN
gP02onCTi03]onGUiOoTi>CoiNGUonCTi?oTi>?og]kNom7AdOna/K7oRXZ:
ofIVI_mADE7oADE5od92@_m5ADGoDE5AofIVI_n:RX[o/K6aom7AdOoNg]ko
i>CSonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoT
i>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGU
iOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGo
i>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oU
iNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCT
i?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGU
onCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>Co
iNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoT
i>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGU
i?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGo
i>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oU
iNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCT
i?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGT
onCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>Co
iNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoT
i>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGU
iOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CT
onGUiOoTi>CoiNGT00;oi>CT0?ooaLG5obPX:?m4A4CoT92@om7AdOoLg=_o
fm_KomOGeooDe=Coe]KFomCDe?oEeMGofMWIon3PgooNg]kof][JomCDe?oI
fMWog]kNon;Rh_oLg=coemOFomCDe?oFe]Koe=CDomGEeOoHf=Sofm_KomOG
eooFe]GoeMGEomOGeooHf=Sog]kNomoOgooLg=coeMGEomOGe_oLg=cogMgM
omOGeooFe]Kofm_Kon7QhOoNg]kofm_Jom[Jf_oNg]kog=cLom[Jf_oKfm_o
h>3PomoOgooLg=_ofMWIomkNg_oOgmooM7AdofMWIon=SHgoE5ADo`P82?nR
XZ;og=cLon;Rh_oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGU
iOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CT
onGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGo
i>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oU
iNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCT
i?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGU
onCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>Co
iNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoT
i>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGU
iOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoShn?oiNGUonCTi?oUiNCoi>CT
onGUiOoTi>CoiNGUon?ShooUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGo
i>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oU
iNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCT
i?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGU
onCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>Co
iNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoT
i>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oUiNGoi>CTonGU
i?oTi>@005SoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCTi?oUiNGo
i>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGUonCTi?oU
iNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>CoiNGTonCT
i?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoTi>CoiNGU
onCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGUiOoTi>Co
iNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CTonGUiOoT
i>CoiNGUonCTi?oUiNGoi>CTonGUi?oTi>CoiNGUonCTi?oUiNGoi>CTonGU
iOoTi>CoiNGTonCTi?oUiNGoi>CTonGUiOoTi>CoiNGUonCTi?oUiNCoi>CT
1?oUiND01_oTi>CoiNGUonGUiOoUiNGoj>SXong]k@7ol_;b00000oodm?Co
kNg]onOWi`03on3Ph00BomoOgooNg]kod];BokBd]?n7QhOoFe]Kofdk=OnN
CT;ocFmOonV3Koo=KeooWTi3ofdk=_mLG5coQhN7okBd]?oBd];og]kN1OoP
h>004OoNg]kod];BokBd]?n7QhOoG5aLofeP;?nNURkocLdoonWYCOo=cCoo
WYX_ofeS;OmLG5coQhN7okBd]?oBd];og]kN00Goh>3P017og]kNom;Bd_nd
];CoQhN7oeaLG?m7IbkoJ9hcoi7=AonZjEGoTLe7ofZN=?m9JRooG5aLohN7
Qond];Cod];BomkNgP3Ion3Ph006omoOgoo?clooVIVIoi:BT_lI6AWoS8b<
0_oEeMD07oo?cloo`/;2olk>c_o>c/koaLG5ol[:b_oJf][of=SHom3@d?o;
bl_oclo?omSHf?oJf][oeMGEolo?coo1`L7od=3@olk>c_o4a<Cobl_;omSH
f?oGemOo_[jnok^k^ooAdM7od=3@omGEeOoHf=Sodm?Colc<c?o>c/h00_oE
eMD01Oo>c/koc<c<om?CdooJf][of=SH00;od];B00Cof=SHomOGeooAdM7o
dm?C0_oIfMT01_oCdm?odM7AomOGeooHf=SodM7Aom3@d0;odM7A00CoATI6
od51@OoGemOog]kNL?oPh>000ooOgmooh>3Pon3Ph02Ron3Ph003omoOgooP
h>3ogmoO00;ogmoO0ooPh>000ooQhN7oinOWonc/k001ooCdm00000?om_Kf
oo;bl_o[jn/00ooXj>P04ooWinOoh^;Rolg=cOnOWiooJemOohlf;_o]LF7o
nIf@oofaYOom_:oooKBWooVOToo]M6?oTSL_of]OGonOWioocLg=on;Rh_oW
inL00ooXj>P04ooWinOoh^;Rolg=cOnOWiooKVIOoi=b8_o]dDConO=doogm
SOomoIGooOf>ooWhM_o]edOoTg<RofiWGonOWioocLg=on;Rh_oWinL00ooX
j>P04ooWinOoh^;Rolg=cOnOWiooH6QOod]l8onBhD_o_OUkom3mT_oHoI_o
e?fEol3iO_nHj4goCH0Tof1YGonOWioocLg=on;Rh_oWinL0f_oXj>P01?oV
i^KohN7QoeeMGOm=CDd2omgMg@0Ooe1@D?l71`Oo5ADEohB4Q?lF5QKo@d=3
on;Rh_oMgMgoW9bLo`000?n?ShoogMgMon7QhOoKfm_o@410o`P82?lI6AWo
R8R8o`/;2omHF5So]kNgo``<3?l71`Oo8b<SobLW9ommOGgof][JomgMgOoD
e=Co2`/;oeUIF@02omWIf@03oeeMGOl;2`_odm?C00;ogmoO00KoFUYJodi>
C_oNg]kog]kNob<S8on4Q8@2on7Qh@0<ogYjN_l^;RkogMgMomgMgOo2`/;o
D51@oc<c<om^KVkoPh>3ob4Q8OoNg]koi^KVoooXj>POonSXj07ok>c/0Oob
l_81ooKfmP0001WomoOgooShn?ohn?Son?ShooOgmoohn?SomoOgonk^k_o>
c/koT92@ohD_:ooYI5KonY:7oojVVoon/JGookR[oojcY_onZ9coniB9oniX
FOn9<B_oT92@olk>c_o^k^komoOg00?on?Sh01?omoOgonk^k_o>c/koT92@
oiUY:oo`_Cgonn1^ookdP_onoX[ooonBooknS?onn8?onnE`oo32?_nIJR_o
T92@olk>c_o^k^komoOg00?on?Sh01?omoOgonk^k_o>c/koT92@od9c:on4
cT?o[Nmcol;nR?o>oY3oe_nGom3nT_o6oXWo/_EdohSC@om4MB_oT92@olk>
c_o^k^komoOg0=[on?Sh02Gom_Kfoo7alOn1PH7o7alOong]kOo6a/Ko0000
ol?3`ooCdm?oG5aLo`P82?oZj^[ol?3`on[Zj_mBDU;o51@Docdm?OoYjNWo
l?3`ojn_[ol71`Ood];Bolg=cOm>CTko6a/Konk^k_oKfm_o[Zj^onSXj?o/
k>co[Zj^o`000?nd];Cok>c/ok2`/?l;2`_o6QXJ00;oi>CT00_o8b<So`h>
3_nTY:CokNg]onk^k_mPH63oE5ADonk^k_o]kNgo9RHVohf=S@02oo3`l00<
oh:2P_la<C7ok>c/on[Zj_m3@d?o;bl_oibLW?mcLg?o:RXZoaXJ6_o^k^ko
m_KfJOohn?P00oogmoOon?ShooShn005ooShn003ooOgmoohn?Son?Sh03;o
n?Sh00?omoOgooShn?ohn?P0K_ohn?P00oogmoOon?ShooShn002ooShn004
ooOgmooinOWomoOgooOgm`7on?Sh00000oojn_[omOGeonk^kP02onc/k03o
on_[jooYjNWogmoOokVi^OmiDU;o_c8TonMdJOomRGkooiR<oojRU_ooZ9co
oZBHoonJSOonRWookWIZol<c9?miDU;o^[ZjomoOgooZj^[ojn_[onc/k?o[
jncoj^[ZomoOgonj^[[oR6EBon:A7?oi`e3ooMYSoooZL_onlgkoooZ2ookf
Ooook7?oo]iToo[7DOoRTQcoRFICokZj^_oOgmooj^[Zon_[joo/k>cojn_[
on[Zj_oOgmoo^[Zjoe9]D_mAXacoTM9EojKWJ_nhnG[o`?j2olOoROo3oXCo
^OekojO/K?nDeUOoDZHLoe9]D_nj^[[ogmoOon[Zj_o[jn_ok>c/on_[joo/
k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[
k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/
on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_o
k>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[
jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/
k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/
onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>co
jn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/
k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[
joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/
on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jnco
k>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[
jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/
k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[
onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>co
jn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/
k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/0019onc/k?o[jn_ok>c/
on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_o
k>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[
jn_ok>c/onWYjOoUiNGoNWYjoa`L7?oQhN;oc<c<o`<30onPX:3og]kNoiBD
U?lC4a?ohN7Qon3PhOo@d=3o1PH6oj6QXOl92@Wo_knoon7QhOnj^[[o0P82
ok:b/_oMgMgoP820obPX:?oShn?oinOWonGUiOoOgmoofm_Kom?Cdol820So
QHF5omoOgomYJFWoBTY:ocDe=On][Jgo_Kfmo`L71omhN7SoEEEEomoOgooP
h>3oFe]Koe1@D002on7Qh@0:ob@T9?n5QHGogmoOon7QhOmkNg_o;bl_on3P
h?oDe=Co1@D5ojRXZ0;ohn?S0?ooOWiooaHF5_oQhN7oj^[Zon_[joo/k>co
jn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/
k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[
joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/
on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_o
k>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[
jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/
k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[
onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>co
jn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/
k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[
joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/
on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/k?o[jn_o
k>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[
jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>cojn_[onc/
k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[
onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[k?o/k>co
jn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/on_[joo/
k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_ok>c/on_[
k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[jn_ok>c/
on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/k?o[jn_o
k>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>cojn_/onc/k?o[
jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/k>cojn_[onc/
k?o[jn/001[ok>c/on_[k?o/k>cojn_[onc/k?o[jn_ok>c/on_[joo/k>co
jn_/onc/k?o[jn_ok>c/on_[joo/k>cojn_[onc/k?o[jncok>c/on_[joo/
k>cojn_[onc/k?o[jn_ok>c/on_[k0Kojn_[00Gok>c/on_[joo[jn_ok^k^
ooKfmP01ooWin@0000?ono_koo?cloo]kNd00_oUiND0oooVi^Kohn?SomWI
fOnb/[;oNBh^olQ2=?oSJUcolgU/oof8O?onUh[ooY^>oojHRoonRWkom7]]
onM[GOo:@SCoNbh^ok:b/_oHf=Soi>CTonGUiOoVi^KoiNGVonCTi?oHf=So
/[:boiIE;_oZW2_onka4ook<Doomf6;oo^=bookYMOoniW?oo]]Uoog<Dook
`DGokYh[oiUF;_nb/[;of=SHonCTi?oUiNGoi^KVonGUiOoTi>Cof=SIok:b
/_l^HRkoHjd[ohO:B?nGg5WoYNEYok;cMonhmW_o]?EiojOZJonHg5WoRLm;
of>^:ol^Hbko/[:bomSHfOoTi>CoiNGUonKVi_oUiNGoi^KVonGUiOoVi^Ko
iNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoV
i^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGU
iOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KV
onGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGo
i^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oU
iNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKV
i_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGU
onKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^Ko
iNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoV
i^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGU
i_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KV
onGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGo
i^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oU
iNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKV
i_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGV
onKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^Ko
iNGUonKVi_oUiNGoi^KVonGUiP00=?oVi^KoiNGUonKVi_oUiNGoi^KVonGU
iOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KV
onGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oShn?o
gmoOogMgMolK6a_og=cLon7QhOnNWYko;bl_ob/[:olb<S;o4Q8BomcLg?oJ
f]_oQ8B4ob0P8?oPh>3oDU9BofQXJ?oJf][og]kNoi2@T?lZ:R[o;Rh^ob`/
;?lW9bL2omkNgP0ComWIfOoCdmCod=3@oe]KFol0003o_Kfmom[Jf_lX:2So
QhN7ogMgN?mXJ6SoPX:2oc`l??o2`/;o3`l?omCDe?oJf][oFEUIodi>CP02
omcLg00Job<S8on1PH7oeMGEomOGeomgMgOo;Rh^omcLg?nSXj?o0000olO7
aooHf=SofMWIohf=S_lE5AGog=cLonCTi?oUiNGoi^KVonGUiOoVi^KoiNGV
onKVi_oUiNGoi^KVonGUiOoVi^H2onGUi@2NonGUi_oVi^KoiNGUonKVi_oU
iNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKV
i_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGU
onKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^Ko
iNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGUi_oV
i^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGU
iOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KV
onGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGo
i^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oU
iNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKV
i_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGU
onKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^Ko
iNGVonKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoV
i^KoiNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGU
iOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoVi^H2onGUi@1YonGUi_oVi^Ko
iNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KVonGUiOoV
i^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGoi^KVonGU
i_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oUiNGoi^KV
onGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKVi_oUiNGo
i^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGVonKVi_oU
iNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^KoiNGUonKV
i_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoVi^KoiNGV
onKVi_oUiNGoi^KVonGUiOoVi^KoiNGUonKVi_oUiNKoi^KVonGUiOoVi^Ko
iNGUonKVi_oUiNGoi^KVonGUi_oVi^KoiNGUonKVi_oUiNGoi^KVonGUiOoV
i^KoiNGV00;oi^KV00?oiNGUonKVi_oVi^H00ooVi^H00ooUiNGokNg]ooCd
m001oo_kn`0000?oo?clooShn?oalO400oo^k^h04oo[jn_ohN7Qokbl_?mj
5aOo`clbom9EB?oTJ5[okgM/ooB3NOohQgcomHAjoo=iKOoUJE_ofEQ:ol@o
<_ml5aOo_;blon7QhOo/k>`00oo^k^h04oo/k>cohN7Qokbl_?nUAaOoiYLb
ooF/<?om_47ooLUCoog@H?okdfGooM9Pook=E?om_D;onZlbonVK<_nUAQOo
_;blon7QhOo/k>`00oo^k^h04oo/k>cohN7Qokbl_?lGFAOoGjPbogJm=on6
cDOoU]IJoj;PIOnSh6WoXn5WoiOJG?n6cTOoMklgoen[<_lGFAOo_;blon7Q
hOo/k>`0f_o^k^h0;_o/k>coinOWog]kNolL71coi>CTonWYjOoVi^KohN7Q
omkNg_n=SHgo51@DonKVi_oTi>Co=CDeogUiNOo[jn_o/[:boaDE5OoOgmoo
i^KVonCTi?oQhN7ogMgMogYjN_lY:BWoj>SXonGUiOoMgMgo/K6aobHV9_l;
2`_oVi^KonWYjOo<c<co0000olk>c_o3`l?o9BDUod];BomlO7coj>SXoc4a
<OnUYJGoi>CToeeMGOmADE42onOWi`0:obDU9OmYJFWogmoOomoOgomgMgOo
<C4aonWYjOo1`L7o0000ojNWY`;ogmoO00CoTi>CoaHF5_oWinOok>c/Joo^
k^h00oo]kNgok^k^onk^kP02onk^kP03ong]kOo^k^kok^k^0:[ok^k^00?o
kNg]oo;bl_ohn?P00Oolo?`000?ooOgm01Koo?cloogmoOomoOgoo?cloo?c
looAdM7oJ0L7okPd=?o7?c?odU13omYREOoSKV;oi79TonA_H_oLI5Oode53
ola1=?ni=3CoJ`L7om;Bd_oclo?oo?cl0oomoOd04oolo?colo?com;Bd_nN
:`OofXXdon^K6OoeZ2Won;@oooVmB_oh_dgon[m:ooVh?oofZR[okihIom^;
=?nR;@Ood];Boo?cloolo?`00oomoOd04oolo?colo?com;Bd_l7@0OoCIXd
oen[8?m`^2ooOl=3oh[=D?n=cE;oR/i@oh77A?ma^BooHZhPodjK=?l7@POo
d];Boo?cloolo?`0f_omoOd08ookno_omoOgohB4Q?lN7Qkolo?cooWinOnc
/k?od=3@oo?clomXJ6SoAdM7oo[jn_oDe=Co0000omgMgOolo?cono_kobLW
9onXZ:SonOWioj^[ZooEeMGolO7aoeADE?mNGUkonOWiooCdm?nDU9Co1@D5
od10@?oAdM7omoOgooShn?nGUiOo:b/[00;on_[j01_o92@To`L71oo8b<So
no_kohF5QOmSHf?omoOgof=SHomGEeOon?ShooWinOlW9bOo5ADEoh>3PooG
emOo@T92of=SHookno_on_[joc@d=?m9BDWofm_KonGUiOm?Cdoo5aLGoo[j
n_olo?`0ooomoOdLoogmo@03ooclo?omoOgoo?cl00?ooOgm0000>_omoOgo
n_[joo?cloo^k^kol?3`ono_koo^k^kojNWYom?CdomJ71coXS@dok@X7Oo1
>BcoadTlolmFB_o@Ed_od5M:olY:?_o3>bko]RPMoj8d=?mL7Agodm?Con[Z
j_o^k^kol?3`ono_koo`l>ook^k^on[Zj_oCdm?oS2DMolQa=?oIQ1goi9@E
onNM9?o^Z3?ol:XdonnZ<oo/X2GoiiLEomb87Oo8LCCoS2DMom?CdooZj^[o
k^k^oo3`l?o_knool?3`onk^k_oZj^Wodm?Coadh7OldPSCoAiDMoeZU6omY
[BX2ogBh>03RogFi>?m[/B_oFjLLodRJ7OldPSCo7CPMom?CdooZj^Wok^k^
oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3o
kno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`
l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_
koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`
ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knoo
l?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_
knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`
koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_
oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3o
kno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`
l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_
koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_
ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knoo
l?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_
knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`
l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_
oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>oo
kno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`
l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_
koo`l>ookno_oo3`l0;okno_0?ooj^[ZoginO_lL71coj>SWong]kOn8R8So
<30`o`l?3ola<C7o/K6aonk^k_n5QHCoCDe=ono_koo^k^kokno_ohZ:R_mI
FEWok^k^ogQhN?l[:b_o3`l?ocPh>?no_kookNg]onCTi?l>3PkoJFUYomoO
gooShn?oiNGUon_[jomQHF7oMgMgonk^k_o_knkoMWIfobHV9_o]kNgokno_
olc<c?l/;2coj^[Zofe]K?mRHV;ok>c/ong]kOlk>c_oTi>Cof9RH_l>3Pko
=3@dolC4a?o_knook^k^om7AdOll?3co2PX:obLW9om/K6co;2`/ono_koo^
k^kol?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`
l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_
oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3o
kno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`
l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_
koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`
ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knoo
l?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_
knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`
koo_knool?3`ono_koo`l?3ok^k^oo3`l?o_knool?3_ono_koo`l?3okno_
oo3`l?o^k^kol?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3o
kno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`
l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_
koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_
ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`l?o_knoo
l?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3okno_oo3`l?o_
knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`l>ookno_oo3`
l?o_knl005Kol?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_koo`l?3o
kno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`ono_koo`
l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knool?3`ono_
koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_knool?3`
ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`koo_knoo
l?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_koo`l?3okno_oo3`l?o_
knool?3`ono_koo`l>ookno_oo3`l?o_knool?3`ono_koo`l?3okno_oo3`
koo_knool?3`ono_koo`l?3okno_oo3`l?o_knool?3_ono_k`;ol?3`1_o_
knl1oo?cl`7onOWi0Oono_h00003ookno_ogmoOol?3`00;ojNWY01?oj>SX
onWYjOoVi^Kofm_Kof=;Bon1<S;oYS@dokHd;Oo2CD7o`eA9olAEB_o3E4Wo
`Te1okHd;OnU=CGoPC8bof=;BooKfm_oinOW00GojNWY017oinOWom_Kfon9
Bd_o[d/boleg=OoFRbgoh9`^on2P<_oQX3Coh:0bomnJ;_oFRbgobWDeojm;
<_n9Bd_ofm_KonOWi`05onWYj@0AonOWiooKfm_oBd];oc9P<_ljRCGoDi/]
of^[;om`[CSoKjhjog2]>?mZZRooDi/]ocV8=OlbH3;oBd];om_KfooWinL0
fooYjNT01_oXj>Soi^KVog]kNolL71coi>CTonSXj0;ojNWY00?oinOWonWY
jOoYjNT02ooYjNT03?oWinOojNWYonWYjOoXj>Sof=SHo`X:2_n^[ZkogMgM
omkNg_oPh>3oiNGUonSXj0SojNWY00Koj>SXonKVi_oShn?ohn?SonKVi_oX
j>P3onWYj@03onSXj?oYjNWojNWY00CojNWY00?oinOWonWYjOoYjNT03ooY
jNT00ooXj>SojNWYonWYj@2GonWYj@03onSXj?oYjNWojNWY00?ojNWY00?o
j>SXonWYjOoYjNT0J?oYjNT00ooXj>SojNWYo