(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4900,        121]*)
(*NotebookOutlinePosition[      5686,        145]*)
(*  CellTagsIndexPosition[      5642,        141]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleBeep", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2002, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{
    \(\(\(Remove[SimpleBeep];\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(SimpleBeep[] := 
      JavaBlock[
        Module[\[IndentingNewLine]{frm, pane, button, label, buttonListener, 
            buttonFunc}, \[IndentingNewLine]InstallJava[]; \
\[IndentingNewLine] (*Create\ the\ GUI\ \(\(components\)\(.\)\)\
*) \[IndentingNewLine]frm = 
            NewMathJFrame["\<MathJFrame\>"]; \[IndentingNewLine]pane = 
            frm@getContentPane[]; \[IndentingNewLine]button = 
            NewJButton[pane, "\<Beep\>", Null, 0, 0, 200, 
              30, "\<Beep\>"]; \n\
\[IndentingNewLine]LoadJavaClass["\<javax.swing.JLabel\>"]; \
\[IndentingNewLine]label = 
            NewJLabel[pane, "\<Press button to beep.\>", Null, 0, 0, 200, 30, 
              javax`swing`JLabel`CENTER]; \[IndentingNewLine]\
\[IndentingNewLine] (*Configure\ their\ \(\(properties\)\(.\)\)\
*) \[IndentingNewLine]pane@
            setLayout[
              JavaNew["\<java.awt.GridLayout\>"]]; \[IndentingNewLine]pane@
            add[button]; \[IndentingNewLine]pane@
            add[label]; \[IndentingNewLine]frm@
            pack[]; \[IndentingNewLine]\[IndentingNewLine] (*Create\ the\ \
listener\ and\ set\ its\ handler\ \
\(\(function\)\(.\)\)*) \[IndentingNewLine]buttonListener = 
            JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]buttonListener@
            setHandler["\<actionPerformed\>", 
              ToString[
                buttonFunc]]; \[IndentingNewLine]\[IndentingNewLine] \
(*because\ the\ buttonFunc\ is\ defined\ within\ this\ Module, 
            we\ use\ ToString[
                buttonFunc]\ instead\ of\ writing\ "\<buttonFunc\>"\ manually\
*) \[IndentingNewLine]button@
            addActionListener[
              buttonListener]; \[IndentingNewLine]\[IndentingNewLine] \
(*Define\ \(\(buttonFunc\)\(.\)\)*) \[IndentingNewLine]buttonFunc[event_, 
              command_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]LoadJavaClass["\<java.awt.Toolkit\>"]; \n\t\ \ \ \ \
java`awt`Toolkit`getDefaultToolkit[]@beep[]; \[IndentingNewLine]Print[
                  event]; \[IndentingNewLine]Print[
                  command]; \[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine]frm@
            setLocation[200, 
              200]; \[IndentingNewLine]\[IndentingNewLine] (*Make\ the\ \
window\ visible\ and\ bring\ it\ in\ front\ of\ any\ notebook\ \
\(\(windows\)\(.\)\)*) \[IndentingNewLine]JavaShow[
            frm]; \[IndentingNewLine]\[IndentingNewLine] (*Tell\ the\ frame\ \
to\ end\ the\ modal\ loop\ when\ it\ is\ \(\(closed\)\(.\)\)\
*) \[IndentingNewLine]frm@
            setModal[]; \[IndentingNewLine]\[IndentingNewLine] (*Enter\ the\ \
modal\ \(\(loop\)\(.\)\)*) \[IndentingNewLine]DoModal[];\[IndentingNewLine]]]\
\)}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{956, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 27, 0, 76, "Title"],
Cell[1757, 54, 30, 0, 41, "Subtitle"],
Cell[1790, 56, 108, 2, 29, "Text"],
Cell[1901, 60, 83, 1, 22, "Input"],
Cell[1987, 63, 2897, 55, 942, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

