(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      7739,        172]*)
(*NotebookOutlinePosition[      8525,        196]*)
(*  CellTagsIndexPosition[      8481,        192]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleCardLayout", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2001, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{
    \(\(\(Remove[SimpleCardLayout];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(SimpleCardLayout[] := 
      JavaBlock[
        Module[\[IndentingNewLine]{frm, 
            pane, \[IndentingNewLine]controlPanel, prevButton, 
            nextButton, \[IndentingNewLine]cardsPanel, card1, card2, 
            card3\[IndentingNewLine]}, \[IndentingNewLine]\[IndentingNewLine] \
(*Create\ the\ GUI\ \(\(components\)\(.\)\)*) \[IndentingNewLine]frm = 
            NewMathJFrame["\<MathJFrame\>"]; \[IndentingNewLine]pane = 
            frm@getContentPane[]; \
\[IndentingNewLine]\[IndentingNewLine]controlPanel = 
            NewJPanelEtchedBorder[pane]; \[IndentingNewLine]controlPanel@
            setLayout[
              JavaNew["\<java.awt.GridLayout\>", 1, 2, 10, 
                10]]; \[IndentingNewLine]prevButton = 
            NewJButton[
              controlPanel, "\<Previous\>"]; \[IndentingNewLine]nextButton = 
            NewJButton[
              controlPanel, "\<Next\>"]; \[IndentingNewLine]\
\[IndentingNewLine] (*\(**\)\(\ \)\(prevButtonFunc\)\ \
***) \[IndentingNewLine]\[IndentingNewLine] (*Create\ the\ listener\ and\ set\
\ its\ handler\ \(\(function\)\(.\)\)*) \[IndentingNewLine]prevButtonListener \
= JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]prevButtonListener@
            setHandler["\<actionPerformed\>", 
              ToString[
                prevButtonFunc]]; \[IndentingNewLine]\[IndentingNewLine] \
(*because\ the\ buttonFunc\ is\ defined\ within\ this\ Module, 
            we\ use\ ToString[
                buttonFunc]\ instead\ of\ writing\ "\<buttonFunc\>"\ manually\
*) \[IndentingNewLine]prevButton@
            addActionListener[
              prevButtonListener]; \[IndentingNewLine]\[IndentingNewLine] \
(*Define\ \(\(buttonFunc\)\(.\)\)*) \[IndentingNewLine]prevButtonFunc[event_, 
              command_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]cardsPanel@\(getLayout[]@
                    previous[cardsPanel]\); \[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine]\
\[IndentingNewLine] (*\(**\)\(\ \)\(nextButtonFunc\)\ \
***) \[IndentingNewLine]\[IndentingNewLine] (*Create\ the\ listener\ and\ set\
\ its\ handler\ \(\(function\)\(.\)\)*) \[IndentingNewLine]nextButtonListener \
= JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]nextButtonListener@
            setHandler["\<actionPerformed\>", 
              ToString[
                nextButtonFunc]]; \[IndentingNewLine]\[IndentingNewLine] \
(*because\ the\ buttonFunc\ is\ defined\ within\ this\ Module, 
            we\ use\ ToString[
                buttonFunc]\ instead\ of\ writing\ "\<buttonFunc\>"\ manually\
*) \[IndentingNewLine]nextButton@
            addActionListener[
              nextButtonListener]; \[IndentingNewLine]\[IndentingNewLine] \
(*Define\ \(\(buttonFunc\)\(.\)\)*) \[IndentingNewLine]nextButtonFunc[event_, 
              command_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]cardsPanel@\(getLayout[]@
                    next[cardsPanel]\); \[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine]\
\[IndentingNewLine] \
(*\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\
*********) \[IndentingNewLine]cardsPanel = 
            JavaNew["\<javax.swing.JPanel\>"]; \[IndentingNewLine]cardsPanel@
            setLayout[
              JavaNew["\<java.awt.CardLayout\>"]]; \[IndentingNewLine] \
(**) \[IndentingNewLine]\[IndentingNewLine]card1 = 
            JavaNew["\<javax.swing.JPanel\>"]; \[IndentingNewLine]card1@
            setToolTipText["\<Card 1\>"]; \[IndentingNewLine]NewJLabel[
            card1, "\<MonaLisa\>", \[IndentingNewLine]NewImageIcon[
              StringJoin[$JavaSwingMaterial, "\<MonaLisa.gif\>"]]\
\[IndentingNewLine]]; \[IndentingNewLine]cardsPanel@
            add[card1, 
              JavaNew["\<java.lang.String\>", "\<Card 1\>"]]; \
\[IndentingNewLine]\[IndentingNewLine]card2 = 
            JavaNew["\<javax.swing.JPanel\>"]; \[IndentingNewLine]card2@
            setToolTipText["\<Card 2\>"]; \[IndentingNewLine]NewJLabel[
            card2, "\<RaceAtLinz\>", \[IndentingNewLine]NewImageIcon[
              StringJoin[$JavaSwingMaterial, "\<RaceAtLinz.gif\>"]]\
\[IndentingNewLine]]; \[IndentingNewLine]cardsPanel@
            add[card2, 
              JavaNew["\<java.lang.String\>", "\<Card 2\>"]]; \
\[IndentingNewLine]\[IndentingNewLine]card3 = 
            JavaNew["\<javax.swing.JPanel\>"]; \[IndentingNewLine]card3@
            setToolTipText["\<Card 3\>"]; \[IndentingNewLine]NewJLabel[
            card3, "\<ToyStoryCoffee\>", \[IndentingNewLine]NewImageIcon[
              StringJoin[$JavaSwingMaterial, "\<ToyStoryCoffee.gif\>"]]\
\[IndentingNewLine]]; \[IndentingNewLine]cardsPanel@
            add[card3, 
              JavaNew["\<java.lang.String\>", "\<Card 3\>"]]; \
\[IndentingNewLine]\[IndentingNewLine] (**) \[IndentingNewLine]pane@
            setLayout[
              JavaNew["\<java.awt.GridLayout\>", 2, 
                1]]; \[IndentingNewLine]pane@
            add[cardsPanel]; \[IndentingNewLine]pane@
            add[controlPanel]; \[IndentingNewLine]\[IndentingNewLine] \
(*\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\(**\)\
*********) \[IndentingNewLine]frm@
            setLocation[0, 
              0]; \[IndentingNewLine] (*\(frm@
                pack[];\)*) \[IndentingNewLine]JavaShow[
            frm]; \[IndentingNewLine]frm@
            setModal[]; \
\[IndentingNewLine]DoModal[];\[IndentingNewLine]]]\)}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{956, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 33, 0, 76, "Title"],
Cell[1763, 54, 30, 0, 41, "Subtitle"],
Cell[1796, 56, 108, 2, 29, "Text"],
Cell[1907, 60, 83, 1, 22, "Input"],
Cell[1993, 63, 5730, 106, 1782, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

