(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4111,        107]*)
(*NotebookOutlinePosition[      4897,        131]*)
(*  CellTagsIndexPosition[      4853,        127]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleJCheckBox", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2001, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{
    \(\(\(Remove[SimpleJCheckBox];\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(SimpleJCheckBox[] := 
      JavaBlock[
        Module[\[IndentingNewLine]{frm, pane, checkbox, listener, 
            handler}, \[IndentingNewLine]InstallJava[]; \
\[IndentingNewLine]frm = 
            NewMathJFrame["\<MathJFrame\>"]; \[IndentingNewLine]pane = 
            frm@getContentPane[]; \[IndentingNewLine]\[IndentingNewLine]icon \
= JavaNew["\<javax.swing.ImageIcon\>", 
              StringJoin[$JavaSwingMaterial, "\<NB(S).GIF\>"]]; \
\[IndentingNewLine]icon2 = 
            JavaNew["\<javax.swing.ImageIcon\>", 
              StringJoin[$JavaSwingMaterial, "\<NB(S)2.GIF\>"]]; \
\[IndentingNewLine]\[IndentingNewLine]checkbox = 
            NewJCheckBox[pane, "\<Hit me!\>", False, 
              icon]; \[IndentingNewLine]\[IndentingNewLine]listener = 
            JavaNew["\<com.wolfram.jlink.MathItemListener\>"]; \
\[IndentingNewLine]listener@
            setHandler["\<itemStateChanged\>", 
              ToString[handler]]; \[IndentingNewLine]checkbox@
            addItemListener[
              listener]; \[IndentingNewLine]\[IndentingNewLine]handler[
              event_, stateChanged_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{cb}, \
\[IndentingNewLine]LoadClass["\<java.awt.event.ItemEvent\>"]; \
\[IndentingNewLine]cb = event@getSource[]; \[IndentingNewLine]If[
                  stateChanged === 
                    java`awt`event`ItemEvent`SELECTED, \[IndentingNewLine]cb@
                    setText["\<ON\>"]; \[IndentingNewLine]cb@
                    setIcon[icon2];, \[IndentingNewLine]cb@
                    setText["\<OFF\>"]; \[IndentingNewLine]cb@
                    setIcon[
                      icon];\[IndentingNewLine]]; \
\[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine]\
\[IndentingNewLine]frm@setLocation[200, 200]; \[IndentingNewLine]JavaShow[
            frm]; \[IndentingNewLine]frm@
            setModal[]; \
\[IndentingNewLine]DoModal[];\[IndentingNewLine]]]\)}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{956, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 32, 0, 76, "Title"],
Cell[1762, 54, 30, 0, 41, "Subtitle"],
Cell[1795, 56, 108, 2, 29, "Text"],
Cell[1906, 60, 83, 1, 22, "Input"],
Cell[1992, 63, 2103, 41, 702, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

