(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8672,        191]*)
(*NotebookOutlinePosition[      9458,        215]*)
(*  CellTagsIndexPosition[      9414,        211]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleJMenu", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2001, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{
    \(\(\(Remove[SimpleJMenu];\)\(\[IndentingNewLine]\)
    \)\), "\[IndentingNewLine]", 
    \(SimpleJMenu[] := 
      JavaBlock[
        Module[\[IndentingNewLine]{frame, pane, \[IndentingNewLine]menubar, 
            menu, listener, handler, \[IndentingNewLine]item0, listener0, 
            handler0, \[IndentingNewLine]item1, listener1, 
            handler1, \[IndentingNewLine]item2, listener2, 
            handler2, \[IndentingNewLine]item3, listener3, 
            handler3, \[IndentingNewLine]item4, listener4, 
            handler4, \[IndentingNewLine]group\[IndentingNewLine]}, \
\[IndentingNewLine]InstallJava[]; \[IndentingNewLine]frame = 
            NewMathJFrame["\<SwingJLink\>", 400, 300]; \[IndentingNewLine]If[
            frame === $Failed, Abort[]]; \[IndentingNewLine]pane = 
            frame@getContentPane[]; \
\[IndentingNewLine]\[IndentingNewLine]menubar = 
            NewJMenuBar[frame]; \[IndentingNewLine]menu = 
            NewJMenu[
              menubar, "\<J/Link\>", "\<K\>"]; \[IndentingNewLine]\
\[IndentingNewLine]item0 = 
            NewJMenuItem[
              menu, "\<Mathematica\>", "\<M\>"]; \[IndentingNewLine]item1 = 
            NewJCheckBoxMenuItem[menu, "\<Java\>", "\<J\>", 
              True]; \[IndentingNewLine]item2 = 
            NewJRadioButtonMenuItem[
              menu, "\<MacOS X\>", "\<X\>"]; \[IndentingNewLine]item3 = 
            NewJRadioButtonMenuItem[
              menu, "\<Windows\>", "\<W\>"]; \[IndentingNewLine]item4 = 
            NewJRadioButtonMenuItem[
              menu, "\<Linux\>", "\<L\>"]; \[IndentingNewLine]\
\[IndentingNewLine]group = 
            JavaNew["\<javax.swing.ButtonGroup\>"]; \[IndentingNewLine]group@
            add[item2]; \[IndentingNewLine]group@
            add[item3]; \[IndentingNewLine]group@
            add[item4]; \[IndentingNewLine]item3@
            setSelected[
              True]; \[IndentingNewLine] (**) \[IndentingNewLine]listener = 
            JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]listener@
            setHandler["\<actionPerformed\>", 
              ToString[handler]]; \[IndentingNewLine]menu@
            addActionListener[
              listener]; \[IndentingNewLine]\[IndentingNewLine]item0@
            addActionListener[listener]; \[IndentingNewLine]item1@
            addActionListener[listener]; \[IndentingNewLine]item2@
            addActionListener[listener]; \[IndentingNewLine]item3@
            addActionListener[listener]; \[IndentingNewLine]item4@
            addActionListener[
              listener]; \[IndentingNewLine]\[IndentingNewLine]handler[
              event_, command_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]LoadClass["\<java.awt.Toolkit\>"]; \n\t\ \ \ \ \
java`awt`Toolkit`getDefaultToolkit[]@beep[]; \[IndentingNewLine]Print[
                  StringJoin["\<Menu Action Performed. \>", 
                    ToString[command]]]; \[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine] \
(**) \[IndentingNewLine]listener0 = 
            JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]listener0@
            setHandler["\<actionPerformed\>", 
              ToString[handler0]]; \[IndentingNewLine]item0@
            addActionListener[listener0]; \[IndentingNewLine]handler0[event_, 
              command_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]LoadClass["\<java.awt.Toolkit\>"]; \n\t\ \ \ \ \
java`awt`Toolkit`getDefaultToolkit[]@beep[]; \[IndentingNewLine]Print[
                  command]; \[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine]\
\[IndentingNewLine]listener1 = 
            JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]listener1@
            setHandler["\<actionPerformed\>", 
              ToString[handler1]]; \[IndentingNewLine]item1@
            addActionListener[listener1]; \[IndentingNewLine]handler1[event_, 
              command_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]LoadClass["\<java.awt.Toolkit\>"]; \n\t\ \ \ \ \
java`awt`Toolkit`getDefaultToolkit[]@beep[]; \[IndentingNewLine]Print[
                  command]; \[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine]\
\[IndentingNewLine]listener2 = 
            JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]listener2@
            setHandler["\<actionPerformed\>", 
              ToString[handler2]]; \[IndentingNewLine]item2@
            addActionListener[listener2]; \[IndentingNewLine]handler2[event_, 
              command_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]LoadClass["\<java.awt.Toolkit\>"]; \n\t\ \ \ \ \
java`awt`Toolkit`getDefaultToolkit[]@beep[]; \[IndentingNewLine]Print[
                  command]; \[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine]\
\[IndentingNewLine]listener3 = 
            JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]listener3@
            setHandler["\<actionPerformed\>", 
              ToString[handler3]]; \[IndentingNewLine]item3@
            addActionListener[listener3]; \[IndentingNewLine]handler3[event_, 
              command_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]LoadClass["\<java.awt.Toolkit\>"]; \n\t\ \ \ \ \
java`awt`Toolkit`getDefaultToolkit[]@beep[]; \[IndentingNewLine]Print[
                  command]; \[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine]\
\[IndentingNewLine]listener4 = 
            JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]listener4@
            setHandler["\<actionPerformed\>", 
              ToString[handler4]]; \[IndentingNewLine]item4@
            addActionListener[listener4]; \[IndentingNewLine]handler4[event_, 
              command_] := 
            JavaBlock[
              Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]LoadClass["\<java.awt.Toolkit\>"]; \n\t\ \ \ \ \
java`awt`Toolkit`getDefaultToolkit[]@beep[]; \[IndentingNewLine]Print[
                  command]; \[IndentingNewLine]ReleaseObject[
                  event];\[IndentingNewLine]]]; \[IndentingNewLine]\
\[IndentingNewLine]JavaShow[frame]; \[IndentingNewLine]frame@
            setModal[]; \
\[IndentingNewLine]DoModal[];\[IndentingNewLine]]]\)}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{956, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 28, 0, 76, "Title"],
Cell[1758, 54, 30, 0, 41, "Subtitle"],
Cell[1791, 56, 108, 2, 29, "Text"],
Cell[1902, 60, 83, 1, 22, "Input"],
Cell[1988, 63, 6668, 125, 2182, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

