(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8439,        184]*)
(*NotebookOutlinePosition[      9225,        208]*)
(*  CellTagsIndexPosition[      9181,        204]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleJPopupMenu", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2002, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{
    RowBox[{\(Remove[SimpleJPopupMenu];\), 
      "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
    RowBox[{\(SimpleJPopupMenu[]\), ":=", 
      RowBox[{"JavaBlock", "[", 
        RowBox[{"Module", "[", "\[IndentingNewLine]", 
          
          RowBox[{\({frame, pane, pop, \[IndentingNewLine]item1, listener1, 
              handler1, \[IndentingNewLine]item2, listener2, 
              handler2, \[IndentingNewLine]mouseListener, mouseClickedFunc, 
              mouseEnteredFunc, mouseExitedFunc, mousePressedFunc, 
              mouseReleasedFunc}\), ",", "\[IndentingNewLine]", 
            
            RowBox[{\(InstallJava[]\), ";", 
              "\[IndentingNewLine]", \(frame = 
                NewMathJFrame["\<MathJFrame\>"]\), ";", 
              "\[IndentingNewLine]", \(pane = frame@getContentPane[]\), ";", 
              "\[IndentingNewLine]", \(pane@setLayout[Null]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(pop = 
                JavaNew["\<javax.swing.JPopupMenu\>", "\<testpop\>"]\), ";", 
              "\[IndentingNewLine]", \(item1 = NewJMenuItem[pop, "\<One\>"]\),
               ";", "\[IndentingNewLine]", \(pop@addSeparator[]\), ";", 
              "\[IndentingNewLine]", \(item2 = NewJMenuItem[pop, "\<Two\>"]\),
               ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(mouseListener = 
                JavaNew["\<com.wolfram.jlink.MathMouseListener\>"]\), ";", 
              "\[IndentingNewLine]", \(mouseListener@
                setHandler["\<mouseClicked\>", ToString[mouseClickedFunc]]\), 
              ";", \(mouseListener@
                setHandler["\<mouseEntered\>", ToString[mouseEnteredFunc]]\), 
              ";", \(mouseListener@
                setHandler["\<mouseExited\>", ToString[mouseExitedFunc]]\), 
              ";", \(mouseListener@
                setHandler["\<mousePressed\>", ToString[mousePressedFunc]]\), 
              ";", \(mouseListener@
                setHandler["\<mouseReleased\>", 
                  ToString[mouseReleasedFunc]]\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(pane@addMouseListener[mouseListener]\),
               ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(mouseClickedFunc[event_, x_, y_, 
                  click_] := 
                JavaBlock[
                  Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]\(ReleaseObject[event];\)\[IndentingNewLine]]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(mouseEnteredFunc[event_, x_, y_, 
                  click_] := 
                JavaBlock[
                  Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]\(ReleaseObject[event];\)\[IndentingNewLine]]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(mouseExitedFunc[event_, x_, y_, 
                  click_] := 
                JavaBlock[
                  Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]\(ReleaseObject[event];\)\[IndentingNewLine]]]\), ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              
              StyleBox[\(mousePressedFunc[event_, x_, y_, click_] := 
                  JavaBlock[
                    Module[\[IndentingNewLine]{}, \[IndentingNewLine]If[
                        event@isPopupTrigger[], \[IndentingNewLine]pop@
                          show[event@getComponent[], x, 
                            y]\[IndentingNewLine]]; \
\[IndentingNewLine]ReleaseObject[event];\[IndentingNewLine]]]\),
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[";",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
              
              StyleBox[\(mouseReleasedFunc[event_, x_, y_, click_] := 
                  JavaBlock[
                    Module[\[IndentingNewLine]{}, \[IndentingNewLine]If[
                        event@isPopupTrigger[], \[IndentingNewLine]pop@
                          show[event@getComponent[], x, 
                            y]\[IndentingNewLine]]; \
\[IndentingNewLine]ReleaseObject[event];\[IndentingNewLine]]]\),
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox[";",
                FontColor->RGBColor[0, 0, 1]], 
              StyleBox["\[IndentingNewLine]",
                FontColor->RGBColor[0, 0, 1]], 
              "\[IndentingNewLine]", \(listener1 = 
                JavaNew["\<com.wolfram.jlink.MathActionListener\>"]\), ";", 
              "\[IndentingNewLine]", \(listener1@
                setHandler["\<actionPerformed\>", ToString[handler1]]\), ";", 
              "\[IndentingNewLine]", \(item1@addActionListener[listener1]\), 
              ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \
\(LoadJavaClass["\<java.awt.Toolkit\>"]\), ";", 
              "\[IndentingNewLine]", \(handler1[event_, command_] := 
                JavaBlock[
                  Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]java`awt`Toolkit`getDefaultToolkit[]@
                      beep[]; \[IndentingNewLine]Print[
                      command]; \[IndentingNewLine]ReleaseObject[
                      event];\[IndentingNewLine]]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(listener2 = 
                JavaNew["\<com.wolfram.jlink.MathActionListener\>"]\), ";", 
              "\[IndentingNewLine]", \(listener2@
                setHandler["\<actionPerformed\>", ToString[handler2]]\), ";", 
              "\[IndentingNewLine]", \(item2@addActionListener[listener2]\), 
              ";", "\[IndentingNewLine]", \(handler2[event_, command_] := 
                JavaBlock[
                  Module[\[IndentingNewLine]{}, \
\[IndentingNewLine]java`awt`Toolkit`getDefaultToolkit[]@
                      beep[]; \[IndentingNewLine]Print[
                      command]; \[IndentingNewLine]ReleaseObject[
                      event];\[IndentingNewLine]]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(JavaShow[frame]\), ";", 
              "\[IndentingNewLine]", \(frame@setModal[]\), ";", 
              "\[IndentingNewLine]", \(DoModal[]\), ";"}]}], "]"}], 
        "]"}]}]}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{956, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 33, 0, 76, "Title"],
Cell[1763, 54, 30, 0, 41, "Subtitle"],
Cell[1796, 56, 108, 2, 29, "Text"],
Cell[1907, 60, 83, 1, 22, "Input"],
Cell[1993, 63, 6430, 118, 1642, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

