(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      4481,        114]*)
(*NotebookOutlinePosition[      5269,        138]*)
(*  CellTagsIndexPosition[      5225,        134]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleJSlider", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2002, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{\(\(Remove[SimpleJSlider];\)\(\[IndentingNewLine]\)
    \), "\n", 
    RowBox[{\(SimpleJSlider[]\), ":=", 
      RowBox[{"JavaBlock", "[", 
        RowBox[{"Module", "[", "\[IndentingNewLine]", 
          
          RowBox[{\({frm, pane, slider, listener, handler, label}\), ",", 
            "\[IndentingNewLine]", 
            
            RowBox[{\(InstallJava[]\), ";", 
              "\[IndentingNewLine]", \(frm = 
                NewMathJFrame["\<MathJFrame\>"]\), ";", 
              "\[IndentingNewLine]", \(pane = frm@getContentPane[]\), ";", 
              "\[IndentingNewLine]", \(LoadJavaClass["\<javax.swing.BoxLayout\
\>"]\), ";", "\[IndentingNewLine]", \(pane@
                setLayout[
                  JavaNew["\<javax.swing.BoxLayout\>", 
                    pane, \[IndentingNewLine]javax`swing`BoxLayout`XUAXIS]]\),
               ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(slider = 
                NewJSlider[pane, javax`swing`JSlider`VERTICAL]\), ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"listener", "=", 
                RowBox[{"JavaNew", "[", 
                  
                  StyleBox[
                    "\"\<JLinkProgramming.JavaSwing.MathSwingChangeListener\>\
\"",
                    FontColor->RGBColor[1, 0, 0]], "]"}]}], ";", 
              "\[IndentingNewLine]", \(listener@
                setHandler["\<stateChanged\>", ToString[handler]]\), ";", 
              "\[IndentingNewLine]", \(slider@addChangeListener[listener]\), 
              ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(handler[event_] := 
                JavaBlock[
                  Module[\[IndentingNewLine]{}, \[IndentingNewLine]label@
                      setText[
                        ToString[
                          slider@
                            getValue[]]]; \[IndentingNewLine]ReleaseObject[
                      event];\[IndentingNewLine]]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(label = NewJLabel[pane, "\<50\>"]\), 
              ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(frm@setLocation[200, 200]\), ";", 
              "\[IndentingNewLine]", \(JavaShow[frm]\), ";", 
              "\[IndentingNewLine]", \(frm@setModal[]\), ";", 
              "\[IndentingNewLine]", \(DoModal[]\), ";"}]}], 
          "\[IndentingNewLine]", "]"}], "]"}]}]}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{645, 663},
WindowMargins->{{81, Automatic}, {Automatic, -1}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 30, 0, 76, "Title"],
Cell[1760, 54, 30, 0, 41, "Subtitle"],
Cell[1793, 56, 108, 2, 29, "Text"],
Cell[1904, 60, 83, 1, 22, "Input"],
Cell[1990, 63, 2475, 48, 602, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

