(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8920,        194]*)
(*NotebookOutlinePosition[      9707,        218]*)
(*  CellTagsIndexPosition[      9663,        214]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleJTabbedPane", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2001, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[TextData[{
  StyleBox["SimpleJTabbedPane[]",
    FontWeight->"Bold"],
  " shows a tab panel with several images on the frame. When a tab is \
clicked, its name is returned to the notebook by ",
  StyleBox["Print[]",
    FontWeight->"Bold"],
  " method."
}], "Text"],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{\(\(Remove[SimpleJTabbedPane];\)\(\[IndentingNewLine]\)
    \), "\n", 
    RowBox[{\(SimpleJTabbedPane[]\), ":=", 
      RowBox[{"JavaBlock", "[", 
        RowBox[{"Module", "[", "\[IndentingNewLine]", 
          
          RowBox[{\({frm, pane, aquaButtons, icons, tabbedPane, names, 
              labels}\), ",", "\[IndentingNewLine]", 
            
            RowBox[{\(InstallJava[]\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(frm = 
                NewMathJFrame["\<MathJFrame\>"]\), ";", 
              "\[IndentingNewLine]", \(pane = frm@getContentPane[]\), ";", 
              "\[IndentingNewLine]", \( (*\(--\(--\(--\(--\(--\(--\(--\(--\(\
--\(--\(--\(--\(--\(--\(--\(---\)\)\)\)\)\)\)\)\)\)\)\)\)\)\)\)*) \), 
              "\[IndentingNewLine]", \(aquaButtons = \
{\[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<Aqua/GrapeButton.JPG\>"]], \[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, "\<Aqua/GraphiteButton.JPG\
\>"]], \[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<Aqua/BlueberryButton.JPG\>"]], \[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<Aqua/BondiblueButton.JPG\>"]], \[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<Aqua/LimeButton.JPG\>"]], \[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<Aqua/TangerineButton.JPG\>"]], \[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<Aqua/StrawberryButton.JPG\>"]], \[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<Aqua/GrayButton.JPG\>"]]\[IndentingNewLine]}\), ";", 
              "\[IndentingNewLine]", \(icons = \
{\[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, "\<MonaLisa.gif\>"]], \
\[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, "\<DonauCruise.gif\>"]], \
\[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, "\<RaceAtLinz.gif\>"]], \
\[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<ToyStoryCoffee.gif\>"]], \[IndentingNewLine]NewImageIcon[
                    
                    StringJoin[$JavaSwingMaterial, "\<Scull3D.GIF\>"]], \
\[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<KumamotoCastle.jpg\>"]], \[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<SunsetOfKasadoIsland.jpg\>"]], \[IndentingNewLine]NewImageIcon[
                    StringJoin[$JavaSwingMaterial, \
"\<FromTheSkylonTower.gif\>"]]\[IndentingNewLine]}\), ";", 
              "\[IndentingNewLine]", \(tabbedPane = 
                NewJTabbedPane[pane, javax`swing`JTabbedPane`LEFT]\), ";", 
              "\[IndentingNewLine]", \(names = {\[IndentingNewLine]"\<Mona \
Lisa              \>", \[IndentingNewLine]"\<Donau Cruise           \>", \
\[IndentingNewLine]"\<Race At Linz           \>", \[IndentingNewLine]"\<Toy \
Story Coffee       \>", \[IndentingNewLine]"\<Scull 3D               \>", \
\[IndentingNewLine]"\<Kumamoto Castle        \>", \
\[IndentingNewLine]"\<Sunset Of Kasado Island\>", \[IndentingNewLine]"\<From \
The Skylon Tower  \>"\[IndentingNewLine]}\), ";", 
              "\[IndentingNewLine]", \(labels = 
                Table[\[IndentingNewLine]NewJLabel[Null, names[\([i]\)], 
                    icons[\([i]\)]], \[IndentingNewLine]{i, 1, 
                    Length[names]}\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(Do[\[IndentingNewLine]labels[\([i]\)]@
                    setHorizontalTextPosition[
                      javax`swing`JLabel`CENTER]\[IndentingNewLine]labels[\([\
i]\)]@setVerticalTextPosition[
                      javax`swing`JLabel`BOTTOM], \[IndentingNewLine]{i, 1, 
                  Length[names]}\[IndentingNewLine]]\), ";", 
              "\[IndentingNewLine]", \(labels[\([1]\)]@
                setText["\<Kama's smile reminds us Mona Lisa:-)\>"]\), ";", 
              "\[IndentingNewLine]", \(labels[\([2]\)]@
                setText["\<IMS'99 had been over. Then I was free!\>"]\), ";", 
              "\[IndentingNewLine]", \(labels[\([4]\)]@
                setText["\<Toy Story had an influence even on a coffee shop \
in Korea!\>"]\), 
              ";", \(Do[\[IndentingNewLine]tabbedPane@
                  addTab[names[\([i]\)], aquaButtons[\([i]\)], 
                    labels[\([i]\)], names[\([i]\)]], \[IndentingNewLine]{i, 
                  1, Length[names]}\[IndentingNewLine]]\), ";", 
              
              "\[IndentingNewLine]", \( (*\(--\(--\(--\(--\(--\(--\(--\(--\(\
--\(--\(--\(--\(--\(--\(--\(---\)\)\)\)\)\)\)\)\)\)\)\)\)\)\)\)*) \), 
              "\[IndentingNewLine]", 
              RowBox[{"changeListener", "=", 
                RowBox[{"JavaNew", "[", 
                  
                  StyleBox[
                    "\"\<JLinkProgramming.JavaSwing.MathSwingChangeListener\>\
\"",
                    FontColor->RGBColor[1, 0, 0]], "]"}]}], ";", 
              "\[IndentingNewLine]", \(changeListener@
                setHandler["\<stateChanged\>", ToString[changedFunc]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(tabbedPane@
                addChangeListener[changeListener]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \( (*Define\ \
\(\(buttonFunc\)\(.\)\)*) \), 
              "\[IndentingNewLine]", \(changedFunc[event_] := 
                JavaBlock[
                  Module[\[IndentingNewLine]{tabbedPane}, \
\[IndentingNewLine]tabbedPane = 
                      event@getSource[]; \[IndentingNewLine]Print[\
\[IndentingNewLine]tabbedPane@
                        getTitleAt[\[IndentingNewLine]tabbedPane@
                            getSelectedIndex[]\[IndentingNewLine]]\
\[IndentingNewLine]]; \[IndentingNewLine]ReleaseObject[
                      event];\[IndentingNewLine]]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(frm@setLocation[0, 0]\), ";", 
              "\[IndentingNewLine]", \(frm@pack[]\), ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", \(JavaShow[frm]\),
               ";", "\[IndentingNewLine]", \(frm@repaint[]\), ";", 
              "\[IndentingNewLine]", \(frm@setModal[]\), ";", 
              "\[IndentingNewLine]", \(DoModal[]\), ";"}]}], 
          "\[IndentingNewLine]", "]"}], "]"}]}]}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{778, 662},
WindowMargins->{{79, Automatic}, {Automatic, 3}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 34, 0, 76, "Title"],
Cell[1764, 54, 30, 0, 41, "Subtitle"],
Cell[1797, 56, 108, 2, 29, "Text"],
Cell[1908, 60, 270, 8, 50, "Text"],
Cell[2181, 70, 83, 1, 22, "Input"],
Cell[2267, 73, 6637, 118, 1642, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

