(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5279,        125]*)
(*NotebookOutlinePosition[      6067,        149]*)
(*  CellTagsIndexPosition[      6023,        145]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleJTable", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2002, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{\(\(Remove[SimpleJTable];\)\(\[IndentingNewLine]\)
    \), "\n", 
    RowBox[{\(SimpleJTable[]\), ":=", 
      RowBox[{"JavaBlock", "[", 
        RowBox[{"Module", "[", "\[IndentingNewLine]", 
          
          RowBox[{\({frm, pane, base, rowData, header, table, listener, 
              handler}\), ",", "\[IndentingNewLine]", 
            
            RowBox[{\(InstallJava[]\), ";", 
              "\[IndentingNewLine]", \(frm = 
                NewMathJFrame["\<MathJFrame\>"]\), ";", 
              "\[IndentingNewLine]", \(pane = frm@getContentPane[]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(LoadJavaClass["\<javax.swing.Box\>"]\),
               ";", "\[IndentingNewLine]", \(base = 
                javax`swing`Box`createVerticalBox[]\), ";", 
              "\[IndentingNewLine]", \(pane@add[base]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(rowData = 
                Table[\[IndentingNewLine]JavaNew["\<java.lang.String\>", 
                    StringJoin["\<Food \>", ToString[i], 
                      ToString[j]]], \[IndentingNewLine]{i, 4}, {j, 3}]\), 
              ";", "\[IndentingNewLine]", \(header = \
{\[IndentingNewLine]JavaNew["\<java.lang.String\>", "\<RoboPanda\>"], \
\[IndentingNewLine]JavaNew["\<java.lang.String\>", "\<RoboDog\>"], \
\[IndentingNewLine]JavaNew["\<java.lang.String\>", "\<RoboBird\>"]\
\[IndentingNewLine]}\), ";", "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(table = 
                NewJTable[pane, rowData, header]\), ";", 
              "\[IndentingNewLine]", "\[IndentingNewLine]", 
              RowBox[{"listener", "=", 
                RowBox[{"JavaNew", "[", 
                  
                  StyleBox[
                    "\"\<JLinkProgramming.JavaSwing.\
MathSwingListSelectionListener\>\"",
                    FontColor->RGBColor[1, 0, 0]], "]"}]}], ";", 
              "\[IndentingNewLine]", \(listener@
                setHandler["\<valueChanged\>", ToString[handler]]\), ";", 
              "\[IndentingNewLine]", \(table@\(getSelectionModel[]@
                  addListSelectionListener[listener]\)\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(handler[event_] := 
                JavaBlock[
                  Module[\[IndentingNewLine]{rows, cols, 
                      items}, \[IndentingNewLine]If[
                      table@\(getSelectionModel[]@getValueIsAdjusting[]\) === 
                        False, \[IndentingNewLine]rows = 
                        table@getSelectedRows[]; \[IndentingNewLine]cols = 
                        table@getSelectedColumns[]; \[IndentingNewLine]items \
= Flatten[Outer[List, rows, cols], 1]; \[IndentingNewLine]Print[
                        items];\[IndentingNewLine]]; \
\[IndentingNewLine]ReleaseObject[event];\[IndentingNewLine]]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(frm@setLocation[200, 200]\), ";", 
              "\[IndentingNewLine]", \(JavaShow[frm]\), ";", 
              "\[IndentingNewLine]", \(frm@setModal[]\), ";", 
              "\[IndentingNewLine]", \(DoModal[]\), ";"}]}], 
          "\[IndentingNewLine]", "]"}], "]"}]}]}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{655, 568},
WindowMargins->{{11, Automatic}, {Automatic, 14}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 29, 0, 76, "Title"],
Cell[1759, 54, 30, 0, 41, "Subtitle"],
Cell[1792, 56, 108, 2, 29, "Text"],
Cell[1903, 60, 83, 1, 22, "Input"],
Cell[1989, 63, 3274, 59, 862, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

