(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      6244,        142]*)
(*NotebookOutlinePosition[      7030,        166]*)
(*  CellTagsIndexPosition[      6986,        162]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleJTree", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2001, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{\(\(Remove[SimpleJTree];\)\(\[IndentingNewLine]\)
    \), "\n", 
    RowBox[{\(SimpleJTree[]\), ":=", 
      RowBox[{"JavaBlock", "[", 
        RowBox[{"Module", "[", "\[IndentingNewLine]", 
          
          RowBox[{\({frm, pane, \[IndentingNewLine]h0, h11, h12, h21, h22, 
              icon1, icon2, icon3, tree, scrl, \[IndentingNewLine]listener, 
              handler}\), ",", "\[IndentingNewLine]", 
            
            RowBox[{\(InstallJava[]\), ";", 
              "\[IndentingNewLine]", \(frm = 
                NewMathJFrame["\<MathJFrame\>"]\), ";", 
              "\[IndentingNewLine]", \(pane = frm@getContentPane[]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(h0 = 
                JavaNew["\<javax.swing.tree.DefaultMutableTreeNode\>", \
\[IndentingNewLine]JavaNew["\<java.lang.String\>", "\<Apple\>"]]\), 
              ";", \(h11 = 
                JavaNew["\<javax.swing.tree.DefaultMutableTreeNode\>", \
\[IndentingNewLine]JavaNew["\<java.lang.String\>", "\<MacOS X\>"]]\), 
              ";", \(h12 = 
                JavaNew["\<javax.swing.tree.DefaultMutableTreeNode\>", \
\[IndentingNewLine]JavaNew["\<java.lang.String\>", "\<PowerMac\>"]]\), ";", 
              "\[IndentingNewLine]", \(h0@add[h11]\), ";", 
              "\[IndentingNewLine]", \(h0@add[h12]\), 
              ";", \(h21 = 
                JavaNew["\<javax.swing.tree.DefaultMutableTreeNode\>", \
\[IndentingNewLine]JavaNew["\<java.lang.String\>", "\<QuickTime\>"]]\), 
              ";", \(h22 = 
                JavaNew["\<javax.swing.tree.DefaultMutableTreeNode\>", \
\[IndentingNewLine]JavaNew["\<java.lang.String\>", "\<Java\>"]]\), ";", 
              "\[IndentingNewLine]", \(h11@add[h21]\), ";", 
              "\[IndentingNewLine]", \(h11@add[h22]\), ";", 
              "\[IndentingNewLine]", \(icon1 = 
                JavaNew["\<javax.swing.ImageIcon\>", 
                  StringJoin[$JavaSwingMaterial, "\<file.gif\>"]]\), ";", 
              "\[IndentingNewLine]", \(icon2 = 
                JavaNew["\<javax.swing.ImageIcon\>", 
                  StringJoin[$JavaSwingMaterial, "\<0_red.gif\>"]]\), ";", 
              "\[IndentingNewLine]", \(icon3 = 
                JavaNew["\<javax.swing.ImageIcon\>", 
                  StringJoin[$JavaSwingMaterial, "\<3_green.gif\>"]]\), 
              ";", \(tree = NewJTree[Null, h0, icon1, icon2, icon3]\), ";", 
              "\[IndentingNewLine]", \(scrl = NewJScrollPane[pane, tree]\), 
              ";", "\n", "\[IndentingNewLine]", 
              RowBox[{"listener", "=", 
                RowBox[{"JavaNew", "[", 
                  
                  StyleBox[
                    "\"\<JLinkProgramming.JavaSwing.\
MathSwingTreeSelectionListener\>\"",
                    FontColor->RGBColor[1, 0, 0]], "]"}]}], ";", 
              "\[IndentingNewLine]", \(listener@
                setHandler["\<valueChanged\>", ToString[handler]]\), ";", 
              "\[IndentingNewLine]", \(tree@
                addTreeSelectionListener[listener]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(handler[event_] := 
                JavaBlock[
                  Module[\[IndentingNewLine]{selectedNode, 
                      selectedNodeName}, \[IndentingNewLine]selectedNode = 
                      tree@getLastSelectedPathComponent[]; \
\[IndentingNewLine]selectedNodeName = 
                      selectedNode@toString[]; \[IndentingNewLine]If[
                      selectedNode@isLeaf[], \[IndentingNewLine]Print[
                        StringJoin["\<Leaf:\>", 
                          selectedNodeName]], \[IndentingNewLine]Print[
                        StringJoin["\<Not Leaf:\>", 
                          selectedNodeName]]\[IndentingNewLine]]; \
\[IndentingNewLine]ReleaseObject[event];\[IndentingNewLine]]]\), ";", 
              "\[IndentingNewLine]", 
              "\[IndentingNewLine]", \(frm@setLocation[200, 200]\), ";", 
              "\[IndentingNewLine]", \(JavaShow[frm]\), ";", 
              "\[IndentingNewLine]", \(frm@setModal[]\), ";", 
              "\[IndentingNewLine]", \(DoModal[]\), ";"}]}], 
          "\[IndentingNewLine]", "]"}], "]"}]}]}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{956, 668},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 28, 0, 76, "Title"],
Cell[1758, 54, 30, 0, 41, "Subtitle"],
Cell[1791, 56, 108, 2, 29, "Text"],
Cell[1902, 60, 83, 1, 22, "Input"],
Cell[1988, 63, 4240, 76, 922, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

