(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      5291,        136]*)
(*NotebookOutlinePosition[      6079,        160]*)
(*  CellTagsIndexPosition[      6035,        156]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SimpleMathJFrame", "Title"],

Cell["Junzo SATO", "Subtitle"],

Cell["Copyright \[Copyright] 2000-2001, Junzo SATO. All rights reserved.", \
"Text",
  TextAlignment->Right],

Cell[BoxData[
    RowBox[{
      RowBox[{
      "This", " ", "is", " ", "the", " ", "Swing", " ", "version", " ", "of", 
        
        StyleBox[" ",
          FontWeight->"Bold"], 
        StyleBox[\(SimpleModal . nb\),
          FontWeight->"Bold"], 
        StyleBox[" ",
          FontWeight->"Bold"], 
        StyleBox["in",
          FontVariations->{"CompatibilityType"->0}], 
        StyleBox[" ",
          FontVariations->{"CompatibilityType"->0}], 
        StyleBox[\(J/Link\),
          FontVariations->{"CompatibilityType"->0}], 
        StyleBox[" ",
          FontVariations->{"CompatibilityType"->0}], 
        RowBox[{
          StyleBox["examples",
            FontVariations->{"CompatibilityType"->0}], 
          StyleBox[".",
            FontVariations->{"CompatibilityType"->0}], "\[IndentingNewLine]", 
          "MathJFrame"}]}], ",", "JButton", ",", 
      " ", \(and\ JTextField\ are\ used\ here . \ \[IndentingNewLine]Two\ \
\(methods : \ 
          setLayout \(()\)\ and\ add \(()\)\ of\ the\ frm@
              setContentPane[]\ are\ \(\(called\)\(.\)\)\)\)}]], "Text"],

Cell[BoxData[
    \(Needs["\<JLinkProgramming`JavaSwing`JavaSwing`\>"]\)], "Input"],

Cell[BoxData[{
    \(\(\(Remove[SimpleMathJFrame];\)\(\[IndentingNewLine]\)
    \)\), "\n", 
    \(SimpleMathJFrame[] := 
      JavaBlock[
        Module[\[IndentingNewLine]{frm, button, textField, windowListener, 
            buttonListener, 
            buttonFunc, \[IndentingNewLine]value = 
              0}, \[IndentingNewLine]InstallJava[]; \[IndentingNewLine]\
\[IndentingNewLine]frm = NewMathJFrame["\<\>"]; \[IndentingNewLine]button = 
            JavaNew["\<javax.swing.JButton\>"]; \[IndentingNewLine]textField \
= JavaNew["\<javax.swing.JTextField\>"]; \[IndentingNewLine]\
\[IndentingNewLine]frm@\(getContentPane[]@
              setLayout[
                JavaNew["\<java.awt.GridLayout\>"]]\); \
\[IndentingNewLine]frm@\(getContentPane[]@
              add[button]\); \[IndentingNewLine]frm@\(getContentPane[]@
              add[textField]\); \[IndentingNewLine]button@
            setLabel["\<++\>"]; \[IndentingNewLine]textField@
            setText["\<0\>"]; \[IndentingNewLine]frm@
            pack[]; \[IndentingNewLine]\[IndentingNewLine]buttonListener = 
            JavaNew["\<com.wolfram.jlink.MathActionListener\>"]; \
\[IndentingNewLine]buttonListener@
            setHandler["\<actionPerformed\>", 
              ToString[buttonFunc]]; \[IndentingNewLine]button@
            addActionListener[
              buttonListener]; \
\[IndentingNewLine]\[IndentingNewLine]buttonFunc[_, _] := 
            JavaBlock[
              Module[\[IndentingNewLine]{curText, 
                  newVal}, \[IndentingNewLine]curText = 
                  textField@getText[]; \[IndentingNewLine]newVal = 
                  ToExpression[curText] + 1; \[IndentingNewLine]textField@
                  setText[ToString[newVal]]; \[IndentingNewLine]value = 
                  newVal;\[IndentingNewLine]]]; \[IndentingNewLine]frm@
            setLocation[0, 0]; \[IndentingNewLine]\[IndentingNewLine]JavaShow[
            frm]; \[IndentingNewLine]frm@
            setModal[]; \[IndentingNewLine]DoModal[]; \[IndentingNewLine]\
\[IndentingNewLine]Print[
            StringJoin["\<Final value was \>", 
              ToString[value], "\<.\>"]];\[IndentingNewLine]]]\)}], "Input"]
}, Open  ]]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 695}},
WindowSize->{956, 668},
WindowMargins->{{8, Automatic}, {Automatic, -16}},
StyleDefinitions -> FrontEnd`FileName[{ParentDirectory[], "FrontEnd", \
"StyleSheets"}, "JavaSwingStyle.nb", CharacterEncoding -> "ShiftJIS"]
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1727, 52, 33, 0, 76, "Title"],
Cell[1763, 54, 30, 0, 41, "Subtitle"],
Cell[1796, 56, 108, 2, 29, "Text"],
Cell[1907, 60, 1100, 28, 63, "Text"],
Cell[3010, 90, 83, 1, 22, "Input"],
Cell[3096, 93, 2179, 40, 742, "Input"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

